// -*- c++ -*-
//------------------------------------------------------------------------------
//                               MyFileSaveDialog.h
//------------------------------------------------------------------------------
// $Id: MyFileSaveDialog.h,v 1.3 2006/12/21 03:36:35 vlg Exp $
//------------------------------------------------------------------------------
//  Copyright (c) 2006 by Vladislav Grinchenko
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version
//  2 of the License, or (at your option) any later version.
//------------------------------------------------------------------------------
#ifndef MY_FILE_SAVE_DIALOG_H
#define MY_FILE_SAVE_DIALOG_H

#include <gtkmm/filechooserdialog.h>
#include <gtkmm/fileselection.h>

#include "Granule-main.h"
#include "Granule.h"

class MyFileSaveDialog
{
public:
	MyFileSaveDialog (const Glib::ustring& title_,
					  Gtk::Widget*         parent_,
					  const Glib::ustring& filter_name_    = "",
					  const Glib::ustring& filter_pattern_ = "");

	~MyFileSaveDialog ();

	Glib::ustring get_filename     () const;
	void          set_current_name (const Glib::ustring& name_);

	int  run  ();
	void show ();
	void hide ();

private:

#ifdef OBSOLETE
	Gtk::FileSelection*     m_dialog;
#else
	Gtk::FileChooserDialog* m_dialog;
#endif
};

//------------------------------------------------------------------------------
// Inline functions
//------------------------------------------------------------------------------
inline
MyFileSaveDialog::
~MyFileSaveDialog ()
{
	if (m_dialog) {
		delete m_dialog;
		m_dialog = NULL;
	}
}

inline Glib::ustring 
MyFileSaveDialog::
get_filename () const
{
	return (m_dialog->get_filename ());
}

inline void
MyFileSaveDialog::
set_current_name (const Glib::ustring& name_)
{
#ifdef OBSOLETE
	m_dialog->set_filename (name_);
#else
	m_dialog->set_current_name (name_);
#endif
}

inline int
MyFileSaveDialog::
run ()
{
	return (m_dialog->run ());
}
	
inline void
MyFileSaveDialog::
hide ()
{
	m_dialog->hide ();
}

inline void
MyFileSaveDialog::
show ()
{
	m_dialog->show ();
}



#endif /* MY_FILE_SAVE_DIALOG_H */
