// -*- c++ -*-
// generated by glade--
//------------------------------------------------------------------------------
// $Id: GeneralPref.cpp,v 1.18 2006/12/11 03:07:22 vlg Exp $
//------------------------------------------------------------------------------
//                            GeneralPref.cpp
//------------------------------------------------------------------------------
//  Copyright (c) 2004-2006 by Vladislav Grinchenko
//
//  This program is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License   
//  as published by the Free Software Foundation; either version  
//  2 of the License, or (at your option) any later version.      
//------------------------------------------------------------------------------
//
// Date   : Sun May 30 21:09:23 EDT 2004
//
//------------------------------------------------------------------------------

#include <gtkmm/label.h>
#include <gtkmm/frame.h>
#include <gtkmm/box.h>
#include <gtkmm/scrolledwindow.h>

#include "Granule-main.h"
#include "GrappConf.h"
#include "PrefWindow.h"
#include "GeneralPref.h"

#include "Intern.h"             // i18n macros

using sigc::mem_fun;
using sigc::bind;

/**-----------------------------------------------------------------------------
   Class HistSizeBox methods
--------------------------------------------------------------------------------
**/
HistSizeBox::
HistSizeBox () : Gtk::HBox (false, 10)
{
	m_label = Gtk::manage(new Gtk::Label (
							  _("CardFile Recent History entries size")));
	m_label->set_alignment(0, 0.5);
	m_label->set_padding(0,0);
	m_label->set_justify(Gtk::JUSTIFY_FILL);
	m_label->set_line_wrap(false);
	m_label->set_use_markup(false);
	m_label->set_selectable(false);
	
	m_entry = Gtk::manage (new Gtk::Entry);
	m_entry->set_flags       (Gtk::CAN_FOCUS);
	m_entry->set_visibility  (true);
	m_entry->set_editable    (true);
	m_entry->set_max_length  (0);
	m_entry->set_text        ("5");
	m_entry->set_has_frame   (true);
	m_entry->set_width_chars (3);
	m_entry->set_activates_default (false);

	pack_start (*m_entry, Gtk::PACK_SHRINK, 0);
	pack_start (*m_label, Gtk::PACK_SHRINK, 0);
}

void
HistSizeBox::
set_value (int v_)
{
	char buf[24];
	sprintf (buf, "%d", v_);
	m_entry->set_text (buf);
}

int
HistSizeBox::
get_value ()
{
	return (::atoi (m_entry->get_text ().c_str ()));
}

/**-----------------------------------------------------------------------------
 *   Class GeneralPref methods
 **-----------------------------------------------------------------------------
 */
GeneralPref::
GeneralPref (PrefWindow& pwin_) 
	: 
	Gtk::VBox (false, 0),
	m_pref_window (pwin_)
{  
	trace_with_mask("GeneralPref::GeneralPref",GUITRACE);

#if defined(IS_HILDON) || defined(IS_PDA)
	set_border_width(0);
#else
	set_border_width(14);
#endif

	Gtk::Label* empty_label;

	Gtk::Frame* frame1 = Gtk::manage(new Gtk::Frame());
	Gtk::Frame* frame2 = Gtk::manage(new Gtk::Frame());
	Gtk::Frame* frame3 = Gtk::manage(new Gtk::Frame());
	Gtk::Frame* frame4 = Gtk::manage(new Gtk::Frame());
	Gtk::Frame* frame5 = Gtk::manage(new Gtk::Frame());

	m_dup_checkbutton  = 
	    Gtk::manage(new Gtk::CheckButton(
						_("Remove duplicates when inserting new\n"
						  "cards from a Deck to the CardBox")));

	m_relpath_checkbutton = 
	    Gtk::manage(new Gtk::CheckButton(
						_("Record all dynamic links in CardFile"
						  " as relative paths")));

	m_keys_shortcuts_checkbutton = 
	    Gtk::manage(new Gtk::CheckButton(
				_("Some keyboard input methods may conflict with keyboard\n"
				  "shortcuts. If checked, disable all shortcuts in DeckPlayer\n"
				  "dialog (requires restart).")));

	m_auto_pronounce_checkbutton =
	    Gtk::manage(new Gtk::CheckButton(
				_("If selected, auto-pronounce the word of each card.\n"
				  "When studying a flip side of the card, pronounce\n"
				  "each card as the answer is checked against the input.")));

	m_hist_size = Gtk::manage (new HistSizeBox);

	/** Duplicate check button
	 */
	MAKE_EMPTY_LABEL(empty_label);
	SET_CHECKBUTTON(m_dup_checkbutton);
	SET_FRAME(frame1,empty_label,m_dup_checkbutton);

	/** Relative path check button
	 */
	MAKE_EMPTY_LABEL(empty_label);
	SET_CHECKBUTTON(m_relpath_checkbutton);
	SET_FRAME(frame2,empty_label,m_relpath_checkbutton);

	/** History Size check button
	 */
	MAKE_EMPTY_LABEL(empty_label);
	SET_FRAME(frame3,empty_label,m_hist_size);

	/** Key shortcuts
	 */
	MAKE_EMPTY_LABEL(empty_label);
	SET_CHECKBUTTON(m_keys_shortcuts_checkbutton);
	SET_FRAME(frame4,empty_label,m_keys_shortcuts_checkbutton);

	/** Auto pronounce
	 */
	MAKE_EMPTY_LABEL(empty_label);
	SET_CHECKBUTTON(m_auto_pronounce_checkbutton);
	SET_FRAME(frame5,empty_label,m_auto_pronounce_checkbutton);

	Gtk::ScrolledWindow* scrollw = Gtk::manage (new Gtk::ScrolledWindow);

	scrollw->set_flags (Gtk::CAN_FOCUS);
	scrollw->set_shadow_type (Gtk::SHADOW_NONE);
	scrollw->set_policy (Gtk::POLICY_AUTOMATIC , Gtk::POLICY_ALWAYS);
	scrollw->property_window_placement ().set_value (Gtk::CORNER_TOP_LEFT);

	Gtk::VBox* scrollw_vbox = Gtk::manage (new Gtk::VBox (false, 0));

	/** Pack history size
	 */
	scrollw_vbox->pack_start (*frame3, Gtk::PACK_SHRINK, 0);

	/** [] Auto-pronounce each card when answer checked
	 */
	scrollw_vbox->pack_start (*frame5, Gtk::PACK_SHRINK, 0);

	/** [] Remove duplicates when inserting ...
	 */
	scrollw_vbox->pack_start (*frame1, Gtk::PACK_SHRINK, 0);

	/** [] Record all dynamic links in CardFile as relative paths
	 */
	scrollw_vbox->pack_start (*frame2, Gtk::PACK_SHRINK, 0);

	/** [] Disable all shortcuts in DeckPlayer dialog
	 */
	scrollw_vbox->pack_start (*frame4, Gtk::PACK_SHRINK, 0);

	scrollw->add (*scrollw_vbox);
	pack_start (*scrollw);

	/** Set callbacks
	 */
	m_dup_checkbutton->signal_toggled().connect (
		mem_fun (m_pref_window, &PrefWindow::changed_cb));

	m_relpath_checkbutton->signal_toggled().connect (
		mem_fun (m_pref_window, &PrefWindow::changed_cb));

	m_keys_shortcuts_checkbutton->signal_toggled().connect (
		mem_fun (m_pref_window, &PrefWindow::changed_cb));

	m_auto_pronounce_checkbutton->signal_toggled().connect (
		mem_fun (m_pref_window, &PrefWindow::changed_cb));

	m_hist_size->get_entry ()->signal_changed ().connect (
		mem_fun (m_pref_window, &PrefWindow::changed_cb));

	show_all ();
}

void
GeneralPref::
changed_cb ()
{ 
	m_pref_window.changed (); 
}

void
GeneralPref::
load_from_config ()
{
	trace_with_mask("GeneralPref::load_from_config",GUITRACE);

	m_hist_size          ->set_value  (CONFIG->get_history_size      ());
	m_dup_checkbutton    ->set_active (CONFIG->get_remove_duplicates ());
	m_relpath_checkbutton->set_active (CONFIG->with_relpaths         ());
	m_keys_shortcuts_checkbutton->set_active (CONFIG->disable_key_shortcuts ());
	m_auto_pronounce_checkbutton->set_active (CONFIG->auto_pronounce ());
}

void
GeneralPref::
save_to_config ()
{
	trace_with_mask("GeneralPref::save_to_config",GUITRACE);

	if (m_hist_size->get_value () <= 0) {
		m_hist_size->set_value (5); // enforce sane default
	}

	CONFIG->set_remove_duplicates (m_dup_checkbutton->get_active ());
	CONFIG->with_relpaths         (m_relpath_checkbutton->get_active ());
	CONFIG->set_history_size      (m_hist_size->get_value ());
	CONFIG->disable_key_shortcuts (m_keys_shortcuts_checkbutton->get_active ());
	CONFIG->auto_pronounce        (m_auto_pronounce_checkbutton->get_active ());
}

