// -*- c++ -*-
//------------------------------------------------------------------------------
//                              CardRef.cpp
//------------------------------------------------------------------------------
// $Id: CardRef.cpp,v 1.9 2004/06/13 04:56:04 vlg Exp $
//
//  Copyright (c) 2004 by Vladislav Grinchenko
//
//  This program is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License   
//  as published by the Free Software Foundation; either version  
//  2 of the License, or (at your option) any later version.      
//
// Date: Apr 24 2004
//------------------------------------------------------------------------------
#include <sstream>

#include <assa/TimeVal.h>
#include "CardRef.h"

CardRef::
CardRef (VCard& vcard_, Deck& deck_) : 
	m_card (dynamic_cast<Card&>(vcard_)), 
	m_deck (deck_),
	m_exp_date (CONFIG->get_load_time ())
{ 
	trace_with_mask("CardRef::CardRef",GUITRACE); 
}

void 
CardRef::
set_expiration (const ASSA::TimeVal& e_) 
{ 
	m_exp_date = e_.sec (); 
	ASSA::TimeVal exp_tv (m_exp_date, 0);
	DL((DECK, "New exp_date = %s\n", exp_tv.fmtString ("%c").c_str ()));
}

string
CardRef::
get_expiration_str ()
{ 
	std::ostringstream expd;
	expd << m_exp_date;
	return expd.str ();
}

/** Compares the expiration date of the card with today's date
	(time when the program started).

	@return true if card has expired; false if not
*/
bool
CardRef::
is_expired ()
{
	trace_with_mask("CardRef::is_expired",GUITRACE);

	ASSA::TimeVal tlh = get_expiration ();
	ASSA::TimeVal trh = CONFIG->get_load_time ();

	DL((GRAPP,"exp_time (%s) vs.\n", tlh.fmtString ("%c").c_str ()));
	DL((GRAPP,"loaded   (%s)\n",     trh.fmtString ("%c").c_str ()));
	DL((GRAPP,"the card %s\n", 
		(tlh <= trh ? "expired" : "has not expired yet")));

	return (tlh <= trh);
}


void
CardRef::
dump () const
{
	DL((DECK, "========= CardRef =========\n"));
	DL((DECK, "id       = \"%d\"\n", m_card.get_id ()));
	DL((DECK, "question = \"%s\"\n", m_card.get_question ().c_str ()));
	DL((DECK, "answer   = \"%s\"\n", m_card.get_answer ().c_str ()));
	DL((DECK, "example  = \"%s\"\n", m_card.get_example ().c_str ()));
	DL((DECK, "dirty?   = \"%s\"\n", (m_dirty ? "yes" : "no")));
	ASSA::TimeVal t (m_exp_date, 0);
	DL((DECK, "exp_date = %s\n", t.fmtString ("%c").c_str ()));

/*
	DL((DECK, "sel_side = \"%s\"\n", 
		(m_selection_side == FRONT ? "front" : "back")));
*/
}
