// -*- c++ -*-
//------------------------------------------------------------------------------
//                              Card.h
//------------------------------------------------------------------------------
// $Id: Card.h,v 1.11 2006/12/18 03:33:14 vlg Exp $
//
// Date: Jan 8, 2004
//------------------------------------------------------------------------------
#ifndef CARD_H
#define CARD_H

#include "VCard.h"
#include "Granule-main.h"

class Card : public VCard 
{
public:
	Card ();

	virtual void set_question     (const ustring& q_);
	virtual void set_answer       (const ustring& a_);
	virtual void set_example      (const ustring& e_);
	virtual void set_alt_spelling (SideSelection side_, const ustring& a_);

	void set_id (long id_);

	virtual ustring get_question     () const { return m_question;     }
	virtual ustring get_answer       () const { return m_answer;       }
	virtual ustring get_example      () const { return m_example;      }
	virtual ustring get_alt_spelling (SideSelection side_) const;
	virtual long    get_id           () const { return m_id;           }

	virtual void dump () const;

protected:
	virtual bool less_then_expiration (const VCard& rhs_) { return true; }
	virtual bool equal_expiration     (const VCard& rhs_) { return true; }

private:
	long      m_id;
	ustring   m_question;
	ustring   m_answer;
	ustring   m_example;
	ustring   m_front_alt_spelling;
	ustring   m_back_alt_spelling;
};

inline ustring
Card::get_alt_spelling (SideSelection side_) const 
{ 
	trace_with_mask("Card::get_alt_spelling",GUITRACE);

	ustring ret;
	if (side_ == FRONT) {
		DL ((GRAPP,"Return front.alt.spell = %s\n",
			 m_front_alt_spelling.c_str ()));
		ret = m_front_alt_spelling;
	}
	else {
		DL ((GRAPP,"Return back.alt.spell = %s\n",
			 m_back_alt_spelling.c_str ()));
		ret = m_back_alt_spelling;
	}
	return ret;
		
#ifdef BLOCK
	return (side_ == FRONT ? m_front_alt_spelling : m_back_alt_spelling);
#endif
}

inline void
Card::set_alt_spelling (SideSelection side_, const ustring& a_) 
{ 
//	trace_with_mask("Card::set_alt_spelling",GUITRACE);

	if (side_ == FRONT) {
		DL ((GRAPP,"Set front.alt.spell = %s\n", a_.c_str ()));
		m_front_alt_spelling = a_;
	}
	else {
		DL ((GRAPP,"Set back.alt.spell = %s\n", a_.c_str ()));
		m_back_alt_spelling = a_;
	}
	mark_dirty (); 
}

inline void 
Card::set_question (const ustring& q_) 
{ 
	m_question = q_;
	mark_dirty (); 
}

inline void 
Card::set_answer (const ustring& a_) 
{ 
	m_answer = a_;
	mark_dirty (); 
}

inline void
Card::set_example (const ustring& e_) 
{ 
	m_example = e_;
	mark_dirty (); 
}

inline void
Card::set_id (long id_)
{ 
	m_id = id_;
	mark_dirty (); 
}

#endif /* CARD_H */
