/*
 * Copyright 2011 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.tooling.internal.provider.dependencies;

import org.gradle.api.Project;
import org.gradle.plugins.ide.eclipse.model.ClasspathEntry;
import org.gradle.plugins.ide.eclipse.model.SourceFolder;
import org.gradle.tooling.internal.DefaultEclipseSourceDirectory;
import org.gradle.tooling.internal.protocol.eclipse.EclipseSourceDirectoryVersion1;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Szczepan Faber, @date: 20.03.11
 */
public class SourceDirectoriesFactory {
    public List<EclipseSourceDirectoryVersion1> create(Project project, List<ClasspathEntry> entries) {
        List<EclipseSourceDirectoryVersion1> sourceDirectories = new ArrayList<EclipseSourceDirectoryVersion1>();
        for (ClasspathEntry entry : entries) {
            if (entry instanceof SourceFolder) {
                String path = ((SourceFolder) entry).getPath();
                sourceDirectories.add(sourceDirectory(project, path));
            }
        }
        return sourceDirectories;
    }

    private EclipseSourceDirectoryVersion1 sourceDirectory(Project project, String path) {
        return new DefaultEclipseSourceDirectory(path, project.file(path));
    }
}
