/* 
 * gpsk31  - PSK31 for Linux with a GTK+ Interface
 * 
 * Copyright (C) 2005,2006,2007,2008 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * The main author can be reached at pg4i@amsat.org or by smail-mail:
 * Joop Stakenborg, Bramengaarde 24, 3992KG Houten, The Netherlands.
 * 
 */

/*
 * cfg.c - load and save program settings in GKeyFile format
 */

#include <gtk/gtk.h>
#include "cfg.h"
#include "globals.h"

/*
 * Initial configuration 
 */
void
config_create (void)
{
	ini_settings.tx_window_color = g_strdup ("black");
	ini_settings.tx_window_font = g_strdup ("courier new normal 12");

	ini_settings.rx_window_color_rx = g_strdup ("blue");
	ini_settings.rx_window_color_tx = g_strdup ("red");
	ini_settings.rx_window_font = g_strdup ("courier new normal 12");

	ini_settings.phase_scope_dcd_on_color = g_strdup ("yellow");
	ini_settings.phase_scope_dcd_off_color = g_strdup ("red");
	ini_settings.phase_scope_arc_color = g_strdup ("darkblue");

	ini_settings.spectrum_color = g_strdup ("green");
	ini_settings.spectrum_tune_line_color = g_strdup ("red");
	ini_settings.spectrum_center_line_color = g_strdup ("#808000");
	ini_settings.spectrum_width = 1;
	ini_settings.spectrum_speed = 100;

	ini_settings.ptt_device = g_strdup ("/dev/ttyS1");
	ini_settings.audio_device = g_strdup ("/dev/dsp");

	ini_settings.call = g_strdup ("N0CALL");
	ini_settings.name = g_strdup ("Nobody");
	ini_settings.qth = g_strdup ("Nowhere");
	ini_settings.cw_string = g_strdup ("de N0CALL kn");

	ini_settings.freq = 1000;
	ini_settings.dcd_level = 13;
	ini_settings.lsb = 0;

	ini_settings.new_rx = 1;
	ini_settings.log_filename = g_strdup ("gpsk31.log");
	ini_settings.xlog_auto_freq = 1;
	ini_settings.tcp_listen_port = 0;

	ini_settings.label[0] = g_strdup ("F1 CQ");
	ini_settings.label[1] = g_strdup ("F2");
	ini_settings.label[2] = g_strdup ("F3");
	ini_settings.label[3] = g_strdup ("F4 TX");
	ini_settings.label[4] = g_strdup ("F5 RX");
	ini_settings.label[5] = g_strdup ("F6");
	ini_settings.label[6] = g_strdup ("F7");
	ini_settings.label[7] = g_strdup ("F8");
	ini_settings.label[8] = g_strdup ("SHIFT F1");
	ini_settings.label[9] = g_strdup ("SHIFT F2");
	ini_settings.label[10] = g_strdup ("SHIFT F3");
	ini_settings.label[11] = g_strdup ("SHIFT F4");
	ini_settings.label[12] = g_strdup ("SHIFT F5");
	ini_settings.label[13] = g_strdup ("SHIFT F6");
	ini_settings.label[14] = g_strdup ("SHIFT F7");
	ini_settings.label[15] = g_strdup ("SHIFT F8");

	ini_settings.text[0] = g_strdup ("~tCQ CQ CQ de ~mc ~mc ~mc \nCQ CQ CQ de ~mc ~mc ~mc \nCQ CQ CQ de ~mc ~mc ~mc \n~r");
	ini_settings.text[1] = g_strdup ("");
	ini_settings.text[2] = g_strdup ("");
	ini_settings.text[3] = g_strdup ("~t");
	ini_settings.text[4] = g_strdup ("~r");
	ini_settings.text[5] = g_strdup ("");
	ini_settings.text[6] = g_strdup ("");
	ini_settings.text[7] = g_strdup ("");
	ini_settings.text[8] = g_strdup ("");
	ini_settings.text[9] = g_strdup ("");
	ini_settings.text[10] = g_strdup ("");
	ini_settings.text[11] = g_strdup ("");
	ini_settings.text[12] = g_strdup ("");
	ini_settings.text[13] = g_strdup ("");
	ini_settings.text[14] = g_strdup ("");
	ini_settings.text[15] = g_strdup ("");

}

/*
 * Load values from the configuration file and when failed load a fallback value
 * 
 * NOTE:
 * - when a value fails to load, a string will be NULL and an integer zero
 * - fallback values should be the same as in config_create above
 * 
 * because integers are zero when failed to load we add '1' when saving and
 * subtract '1' when loading, so zero values will be saved correctly
 */
static void config_load_from_keyfile (GKeyFile *file)
{
	ini_settings.tx_window_color =
		g_key_file_get_string (file, "tx_window", "color", NULL);
	if (!ini_settings.tx_window_color)
		ini_settings.tx_window_color = g_strdup ("black");
	ini_settings.tx_window_font =
		g_key_file_get_string (file, "tx_window", "font", NULL);
	if (!ini_settings.tx_window_font)
		ini_settings.tx_window_font = g_strdup ("courier new normal 12");

	ini_settings.rx_window_color_rx =
		g_key_file_get_string (file, "rx_window", "color_rx", NULL);
	if (!ini_settings.rx_window_color_rx)
		ini_settings.rx_window_color_rx = g_strdup ("blue");
	ini_settings.rx_window_color_tx =
		g_key_file_get_string (file, "rx_window", "color_tx", NULL);
	if (!ini_settings.rx_window_color_tx)
		ini_settings.rx_window_color_tx = g_strdup ("red");
	ini_settings.rx_window_font =
		g_key_file_get_string (file, "rx_window", "font", NULL);
	if (!ini_settings.rx_window_font)
		ini_settings.rx_window_font = g_strdup ("courier new normal 12");

	ini_settings.phase_scope_dcd_on_color =
		g_key_file_get_string (file, "phase_scope", "dcd_on_color", NULL);
	if (!ini_settings.phase_scope_dcd_on_color)
		ini_settings.phase_scope_dcd_on_color = g_strdup ("yellow");
	ini_settings.phase_scope_dcd_off_color =
		g_key_file_get_string (file, "phase_scope", "dcd_off_color", NULL);
	if (!ini_settings.phase_scope_dcd_off_color)
		ini_settings.phase_scope_dcd_off_color = g_strdup ("yellow");
	ini_settings.phase_scope_arc_color =
		g_key_file_get_string (file, "phase_scope", "arc_color", NULL);
	if (!ini_settings.phase_scope_arc_color)
		ini_settings.phase_scope_arc_color = g_strdup ("darkblue");

	ini_settings.spectrum_color =
		g_key_file_get_string (file, "spectrum", "color", NULL);
	if (!ini_settings.spectrum_color)
		ini_settings.spectrum_color = g_strdup ("green");
	ini_settings.spectrum_tune_line_color =
		g_key_file_get_string (file, "spectrum", "tune_line_color", NULL);
	if (!ini_settings.spectrum_tune_line_color)
		ini_settings.spectrum_tune_line_color = g_strdup ("red");
	ini_settings.spectrum_center_line_color =
		g_key_file_get_string (file, "spectrum", "center_line_color", NULL);
	if (!ini_settings.spectrum_center_line_color)
		ini_settings.spectrum_center_line_color = g_strdup ("#808000");
	ini_settings.spectrum_width =
		g_key_file_get_integer (file, "spectrum", "width", NULL);
	if (ini_settings.spectrum_width == 0)
		ini_settings.spectrum_width = 1;
	else
		ini_settings.spectrum_width = ini_settings.spectrum_width - 1;
	ini_settings.spectrum_speed =
		g_key_file_get_integer (file, "spectrum", "speed", NULL);
	if (ini_settings.spectrum_speed == 0)
		ini_settings.spectrum_speed = 100;

	ini_settings.ptt_device =
		g_key_file_get_string (file, "devices", "ptt_device", NULL);
	if (!ini_settings.ptt_device)
		ini_settings.ptt_device = g_strdup ("/dev/ttyS1");
	ini_settings.audio_device =
		g_key_file_get_string (file, "devices", "audio_device", NULL);
	if (!ini_settings.audio_device)
		ini_settings.audio_device = g_strdup ("/dev/dsp");

	ini_settings.call = g_key_file_get_string (file, "personal", "call", NULL);
	if (!ini_settings.call)
		ini_settings.call = g_strdup ("N0CALL");
	ini_settings.name = g_key_file_get_string (file, "personal", "name", NULL);
	if (!ini_settings.name)
		ini_settings.name = g_strdup ("Nobody");
	ini_settings.qth = g_key_file_get_string (file, "personal", "qth", NULL);
	if (!ini_settings.qth)
		ini_settings.qth = g_strdup ("Nowhere");
	ini_settings.cw_string =
		g_key_file_get_string (file, "personal", "cw_string", NULL);
	if (!ini_settings.cw_string)
		ini_settings.cw_string = g_strdup ("de N0CALL kn");

	ini_settings.freq = g_key_file_get_integer (file, "modem", "freq", NULL);
	if (ini_settings.freq == 0)
		ini_settings.freq = 800;
	ini_settings.dcd_level =
		g_key_file_get_integer (file, "modem", "dcd_level", NULL);
	if (ini_settings.dcd_level == 0)
		ini_settings.dcd_level = 13;
	else
		ini_settings.dcd_level = ini_settings.dcd_level - 1;
	ini_settings.lsb = g_key_file_get_integer (file, "modem", "lsb", NULL);
	if (ini_settings.lsb == 0)
		ini_settings.lsb = 0;
	else
		ini_settings.lsb = ini_settings.lsb - 1;

	ini_settings.new_rx =
		g_key_file_get_integer (file, "options", "new_rx", NULL);
	if (ini_settings.new_rx == 0)
		ini_settings.new_rx = 1;
	else
		ini_settings.new_rx = ini_settings.new_rx - 1;
	ini_settings.log_filename =
		g_key_file_get_string (file, "options", "log_filename", NULL);
	if (!ini_settings.log_filename)
		ini_settings.log_filename = g_strdup ("gpsk31.log");
	ini_settings.xlog_auto_freq =
		g_key_file_get_integer (file, "options", "xlog_auto_freq", NULL);
	if (ini_settings.xlog_auto_freq == 0)
		ini_settings.xlog_auto_freq = 1;
	else
		ini_settings.xlog_auto_freq = ini_settings.xlog_auto_freq - 1;
	ini_settings.tcp_listen_port =
		g_key_file_get_integer (file, "options", "tcp_listen_port", NULL);
	if (ini_settings.tcp_listen_port == 0)
		ini_settings.tcp_listen_port = 0;
	else
		ini_settings.tcp_listen_port = ini_settings.tcp_listen_port - 1;

	ini_settings.label[0] = g_key_file_get_string (file, "labels", "F1_label", NULL);
	if (!ini_settings.label[0])
		ini_settings.label[0] = g_strdup ("F1 CQ");
	ini_settings.label[1] = g_key_file_get_string (file, "labels", "F2_label", NULL);
	if (!ini_settings.label[1])
		ini_settings.label[1] = g_strdup ("F2");
	ini_settings.label[2] = g_key_file_get_string (file, "labels", "F3_label", NULL);
	if (!ini_settings.label[2])
		ini_settings.label[2] = g_strdup ("F3");
	ini_settings.label[3] = g_key_file_get_string (file, "labels", "F4_label", NULL);
	if (!ini_settings.label[3])
		ini_settings.label[3] = g_strdup ("F4 TX");
	ini_settings.label[4] = g_key_file_get_string (file, "labels", "F5_label", NULL);
	if (!ini_settings.label[4])
		ini_settings.label[4] = g_strdup ("F5 RX");
	ini_settings.label[5] = g_key_file_get_string (file, "labels", "F6_label", NULL);
	if (!ini_settings.label[5])
		ini_settings.label[5] = g_strdup ("F6");
	ini_settings.label[6] = g_key_file_get_string (file, "labels", "F7_label", NULL);
	if (!ini_settings.label[6])
		ini_settings.label[6] = g_strdup ("F7");
	ini_settings.label[7] = g_key_file_get_string (file, "labels", "F8_label", NULL);
	if (!ini_settings.label[7])
		ini_settings.label[7] = g_strdup ("F8");

	ini_settings.label[8] = g_key_file_get_string (file, "shiftlabels", "shift_F1_label", NULL);
	if (!ini_settings.label[8])
		ini_settings.label[8] = g_strdup ("SHIFT F1");
	ini_settings.label[9] = g_key_file_get_string (file, "shiftlabels", "shift_F2_label", NULL);
	if (!ini_settings.label[9])
		ini_settings.label[9] = g_strdup ("SHIFT F2");
	ini_settings.label[10] = g_key_file_get_string (file, "shiftlabels", "shift_F3_label", NULL);
	if (!ini_settings.label[10])
		ini_settings.label[10] = g_strdup ("SHIFT F3");
	ini_settings.label[11] = g_key_file_get_string (file, "shiftlabels", "shift_F4_label", NULL);
	if (!ini_settings.label[11])
		ini_settings.label[11] = g_strdup ("SHIFT F4");
	ini_settings.label[12] = g_key_file_get_string (file, "shiftlabels", "shift_F5_label", NULL);
	if (!ini_settings.label[12])
		ini_settings.label[12] = g_strdup ("SHIFT F5");
	ini_settings.label[13] = g_key_file_get_string (file, "shiftlabels", "shift_F6_label", NULL);
	if (!ini_settings.label[13])
		ini_settings.label[13] = g_strdup ("SHIFT F6");
	ini_settings.label[14] = g_key_file_get_string (file, "shiftlabels", "shift_F7_label", NULL);
	if (!ini_settings.label[14])
		ini_settings.label[14] = g_strdup ("SHIFT F7");
	ini_settings.label[15] = g_key_file_get_string (file, "shiftlabels", "shift_F8_label", NULL);
	if (!ini_settings.label[15])
		ini_settings.label[15] = g_strdup ("SHIFT F8");

	ini_settings.text[0] = g_key_file_get_string (file, "text", "F1_text", NULL);
	if (!ini_settings.text[0])
		ini_settings.text[0] = g_strdup ("~tCQ CQ CQ de ~mc ~mc ~mc \nCQ CQ CQ de ~mc ~mc ~mc \nCQ CQ CQ de ~mc ~mc ~mc \n~r");
	ini_settings.text[1] = g_key_file_get_string (file, "text", "F2_text", NULL);
	if (!ini_settings.text[1])
		ini_settings.text[1] = g_strdup ("");
	ini_settings.text[2] = g_key_file_get_string (file, "text", "F3_text", NULL);
	if (!ini_settings.text[2])
		ini_settings.text[2] = g_strdup ("");
	ini_settings.text[3] = g_key_file_get_string (file, "text", "F4_text", NULL);
	if (!ini_settings.text[3])
		ini_settings.text[3] = g_strdup ("~t");
	ini_settings.text[4] = g_key_file_get_string (file, "text", "F5_text", NULL);
	if (!ini_settings.text[4])
		ini_settings.text[4] = g_strdup ("~r");
	ini_settings.text[5] = g_key_file_get_string (file, "text", "F6_text", NULL);
	if (!ini_settings.text[5])
		ini_settings.text[5] = g_strdup ("");
	ini_settings.text[6] = g_key_file_get_string (file, "text", "F7_text", NULL);
	if (!ini_settings.text[6])
		ini_settings.text[6] = g_strdup ("");
	ini_settings.text[7] = g_key_file_get_string (file, "text", "F8_text", NULL);
	if (!ini_settings.text[7])
		ini_settings.text[7] = g_strdup ("");

	ini_settings.text[8] = g_key_file_get_string (file, "shifttext", "shift_F1_text", NULL);
	if (!ini_settings.text[8])
		ini_settings.text[8] = g_strdup ("");
	ini_settings.text[9] = g_key_file_get_string (file, "shifttext", "shift_F2_text", NULL);
	if (!ini_settings.text[9])
		ini_settings.text[9] = g_strdup ("");
	ini_settings.text[10] = g_key_file_get_string (file, "shifttext", "shift_F3_text", NULL);
	if (!ini_settings.text[10])
		ini_settings.text[10] = g_strdup ("");
	ini_settings.text[11] = g_key_file_get_string (file, "shifttext", "shift_F4_text", NULL);
	if (!ini_settings.text[11])
		ini_settings.text[11] = g_strdup ("");
	ini_settings.text[12] = g_key_file_get_string (file, "shifttext", "shift_F5_text", NULL);
	if (!ini_settings.text[12])
		ini_settings.text[12] = g_strdup ("");
	ini_settings.text[13] = g_key_file_get_string (file, "shifttext", "shift_F6_text", NULL);
	if (!ini_settings.text[13])
		ini_settings.text[13] = g_strdup ("");
	ini_settings.text[14] = g_key_file_get_string (file, "shifttext", "shift_F7_text", NULL);
	if (!ini_settings.text[14])
		ini_settings.text[14] = g_strdup ("");
	ini_settings.text[15] = g_key_file_get_string (file, "shifttext", "shift_F8_text", NULL);
	if (!ini_settings.text[15])
		ini_settings.text[15] = g_strdup ("");
}

/*
 * Load the configuration file 
 */
void
loadpreferences (gchar *path)
{
	config_create ();
	if (g_file_test(path, G_FILE_TEST_EXISTS))
	{
		GKeyFile *file = g_key_file_new ();
		g_key_file_load_from_file (file, path, G_KEY_FILE_KEEP_COMMENTS, NULL);
		config_load_from_keyfile (file);
		g_key_file_free(file);
	}
}

/*
 * Save configuration file 
 */
void
savepreferences (gchar *path)
{
	GKeyFile *file = g_key_file_new();
	g_key_file_load_from_file(file, path, G_KEY_FILE_KEEP_COMMENTS, NULL);

	g_key_file_set_string (file, "tx_window", "color", ini_settings.tx_window_color);
	g_key_file_set_string (file, "tx_window", "font", ini_settings.tx_window_font);

	g_key_file_set_string (file, "rx_window", "color_rx", ini_settings.rx_window_color_rx);
	g_key_file_set_string (file, "rx_window", "color_tx", ini_settings.rx_window_color_tx);
	g_key_file_set_string (file, "rx_window", "font", ini_settings.rx_window_font);

	g_key_file_set_string (file, "phase_scope", "dcd_on_color", ini_settings.phase_scope_dcd_on_color);
	g_key_file_set_string (file, "phase_scope", "dcd_off_color", ini_settings.phase_scope_dcd_off_color);
	g_key_file_set_string (file, "phase_scope", "arc_color", ini_settings.phase_scope_arc_color);

	g_key_file_set_string (file, "spectrum", "color", ini_settings.spectrum_color);
	g_key_file_set_string (file, "spectrum", "tune_line_color", ini_settings.spectrum_tune_line_color);
	g_key_file_set_string (file, "spectrum", "center_line_color", ini_settings.spectrum_center_line_color);
	g_key_file_set_integer (file, "spectrum", "width", ini_settings.spectrum_width + 1);
	g_key_file_set_integer (file, "spectrum", "speed", ini_settings.spectrum_speed);

	g_key_file_set_string (file, "devices", "ptt_device", ini_settings.ptt_device);
	g_key_file_set_string (file, "devices", "audio_device", ini_settings.audio_device);

	g_key_file_set_string (file, "personal", "call", ini_settings.call);
	g_key_file_set_string (file, "personal", "name", ini_settings.name);
	g_key_file_set_string (file, "personal", "qth", ini_settings.qth);
	g_key_file_set_string (file, "personal", "cw_string", ini_settings.cw_string);

	g_key_file_set_integer (file, "modem", "freq", ini_settings.freq);
	g_key_file_set_integer (file, "modem", "dcd_level", ini_settings.dcd_level + 1);
	g_key_file_set_integer (file, "modem", "lsb", ini_settings.lsb + 1);

	g_key_file_set_integer (file, "options", "new_rx", ini_settings.new_rx + 1);
	g_key_file_set_string (file, "options", "log_filename", ini_settings.log_filename);
	g_key_file_set_integer (file, "options", "xlog_auto_freq", ini_settings.xlog_auto_freq + 1);
	g_key_file_set_integer (file, "options", "tcp_listen_port", ini_settings.tcp_listen_port + 1);

	g_key_file_set_string (file, "labels", "F1_label", ini_settings.label[0]);
	g_key_file_set_string (file, "labels", "F2_label", ini_settings.label[1]);
	g_key_file_set_string (file, "labels", "F3_label", ini_settings.label[2]);
	g_key_file_set_string (file, "labels", "F4_label", ini_settings.label[3]);
	g_key_file_set_string (file, "labels", "F5_label", ini_settings.label[4]);
	g_key_file_set_string (file, "labels", "F6_label", ini_settings.label[5]);
	g_key_file_set_string (file, "labels", "F7_label", ini_settings.label[6]);
	g_key_file_set_string (file, "labels", "F8_label", ini_settings.label[7]);

	g_key_file_set_string (file, "shiftlabels", "shift_F1_label", ini_settings.label[8]);
	g_key_file_set_string (file, "shiftlabels", "shift_F2_label", ini_settings.label[9]);
	g_key_file_set_string (file, "shiftlabels", "shift_F3_label", ini_settings.label[10]);
	g_key_file_set_string (file, "shiftlabels", "shift_F4_label", ini_settings.label[11]);
	g_key_file_set_string (file, "shiftlabels", "shift_F5_label", ini_settings.label[12]);
	g_key_file_set_string (file, "shiftlabels", "shift_F6_label", ini_settings.label[13]);
	g_key_file_set_string (file, "shiftlabels", "shift_F7_label", ini_settings.label[14]);
	g_key_file_set_string (file, "shiftlabels", "shift_F8_label", ini_settings.label[15]);

	g_key_file_set_string (file, "text", "F1_text", ini_settings.text[0]);
	g_key_file_set_string (file, "text", "F2_text", ini_settings.text[1]);
	g_key_file_set_string (file, "text", "F3_text", ini_settings.text[2]);
	g_key_file_set_string (file, "text", "F4_text", ini_settings.text[3]);
	g_key_file_set_string (file, "text", "F5_text", ini_settings.text[4]);
	g_key_file_set_string (file, "text", "F6_text", ini_settings.text[5]);
	g_key_file_set_string (file, "text", "F7_text", ini_settings.text[6]);
	g_key_file_set_string (file, "text", "F8_text", ini_settings.text[7]);

	g_key_file_set_string (file, "shifttext", "shift_F1_text", ini_settings.text[8]);
	g_key_file_set_string (file, "shifttext", "shift_F2_text", ini_settings.text[9]);
	g_key_file_set_string (file, "shifttext", "shift_F3_text", ini_settings.text[10]);
	g_key_file_set_string (file, "shifttext", "shift_F4_text", ini_settings.text[11]);
	g_key_file_set_string (file, "shifttext", "shift_F5_text", ini_settings.text[12]);
	g_key_file_set_string (file, "shifttext", "shift_F6_text", ini_settings.text[14]);
	g_key_file_set_string (file, "shifttext", "shift_F7_text", ini_settings.text[14]);
	g_key_file_set_string (file, "shifttext", "shift_F8_text", ini_settings.text[15]);

	gchar *buffer = g_key_file_to_data(file, NULL, NULL);
	g_key_file_free(file);
	GIOChannel *channel = g_io_channel_new_file (path, "w", NULL);
	g_io_channel_write_chars (channel, buffer, -1, NULL, NULL);
	g_io_channel_unref (channel);
	g_free (buffer);
}
