/*
Copyright (C) 2002-2003  The PARI group.

This file is part of the GP2C package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

#include "config.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "header.h"

static int toplevel=0;
int initnode=0;

char *basename(char *s)
{
  long i;
  long l=strlen(s);
  for(i=l-1;i>=0;i--)
    if (s[i]=='/')
      return s+i+1;
  return s;
}
char *nameinitfunc(void)
{
  const char *initname="init_";
  char *p,*q,*name;
  char *absname;
  absname=basename(nameparse);
  name=calloc(strlen(initname)+strlen(absname)+1,sizeof(*name));
  sprintf(name,"%s",initname);
  q=name+strlen(name);
  for(p=absname;*p && *p!='.';p++,q++)
    if (isalnum(*p))
      *q=*p;
    else
      *q='_';
  *q=0;
  return name;
}
int addinitfunc(int n)
{
  int code;
  int ret;
  char *name;
  name=nameinitfunc();
  code=toplevel?toplevel:-1;
  code=addseqright(code,GNIL);
  initnode = newentry(name);
  code=newnode(Fdeffunc,newnode(Ffunction,initnode,-1),code);
  ret=addseqright(code,n);
  return ret;
}

void genpredeclaration(int args, int n)
{
  int stack[STACKSZ];
  int i;
  int nb=listtostack(args,Flistarg,stack,STACKSZ,"function declaration",n);
  if (nb==1 && stack[0]==GNOARG)
    nb--;
  for(i=0;i<nb;i++)
  {
    int var,tv;
    int val=-1;
    switch(tree[stack[i]].f)
    {
    case Ftag:
      var=tree[stack[i]].x;
      tv=tree[stack[i]].y;
      if (tree[var].f!=Fentry)
        die(stack[i],"Incorrect declaration");
      pushvar(var,(1<<Cuser)|(1<<Cglobal),-1,-1);
      break;
    case Fentry:
      pushvar(stack[i],(1<<Cuser)|(1<<Cglobal),-1,-1);
      break;
    case Faffect:
      genequal(stack[i],"declaration",&var,&val,&tv);
      pushvar(var,(1<<Cuser)|(1<<Cglobal),-1,-1);
      break;
    default:
      die(n,"Incorrect node %s in function declaration",
          funcname(tree[stack[i]].f));
    }
  }
}

/*
  n: node
  p:parent node
*/
void gentoplevel(int n, int p)
{
  int x,y;
  if (n<0)
    return;
  x=tree[n].x;
  y=tree[n].y;
  switch(tree[n].f)
  {
  case Fseq:
    if (x>=0 && tree[x].f!=Fdeffunc && tree[x].f!=Fseq)
    {
      if (isfunc(x,"global"))
        genpredeclaration(tree[x].y,x);
      if (isfunc(x,"local"))
        warning(x,"`local' at top-level discarded");
      else
        toplevel=addseqright(toplevel,x);
      tree[n].x=GNIL;
    }
    else
      gentoplevel(x,n);
    if (y>=0 && tree[y].f!=Fdeffunc)
    {
      if (isfunc(y,"global"))
        genpredeclaration(tree[y].y,y);
      if (isfunc(y,"local"))
        warning(y,"`local' at top-level discarded");
      else
        toplevel=addseqright(toplevel,y);
      tree[n].y=GNIL;
    }
    else
      gentoplevel(y,n);
    break;
  case Ffunction:
    die(n,"Ffunction in toplevel");
    gentoplevel(y,n);
    break;
  case Fdeffunc:
  case Fentry:
  case Fconst:
  case Fsmall:
  case Fnoarg:
    break;
  case Frefarg:
  case Ftag:
    die(n,"%s in toplevel",funcname(tree[n].f));
    gentoplevel(x,n);
    break;
  default:
    if (tree[n].f>=FneedENTRY)
    {
      die(n,"Internal error: unknown func %s in gentoplevel",funcname(tree[n].f));
    }
    else
    {
      gentoplevel(x,n);
      gentoplevel(y,n);
    }
  }
}

