.TH GRDINFO l "1 Apr 2007" "GMT4.2.0" "GMT4.2.0"
.SH NAME
grdinfo \- Get information about the contents of a 2-D grd file
.SH SYNOPSIS
\fBgrdinfo\fP \fIgrdfiles\fP [ \fB\-C\fP ] [ \fB\-F\fP ] 
[ \fB\-I\fP[\fIdx\fP[/\fIdy\fP]] ][ \fB\-L\fP[\fB1\fP|\fP2\fP] ] 
[ \fB\-M\fP ] [ \fB\-T\fP\fIdz\fP ] [ \fB\-V\fP ] [ \fB\-f\fP[\fBi\fP|\fBo\fP]\fIcolinfo\fP ]
.SH DESCRIPTION
\fBgrdinfo\fP reads a 2-D binary grd file and reports various statistics for
the (\fIx,y,z\fP) data in the grdfile(s).  The output information contains the
minimum/maximum values for \fIx\fP, \fIy\fP, and \fIz\fP, where the min/max of \fIz\fP occur, the
\fIx\fP- and \fIy\fP-increments, and the number of \fIx\fP and \fIy\fP nodes, and [optionally] the
mean, standard deviation, and/or the median, L1 scale of \fIz\fP, and number of
nodes set to NaN.
.TP
\fIgrdfile\fP
The name of one or several 2-D grd files.
.br
.sp
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-C
Formats the report using tab-separated fields on a single line.  The output is
\fIw e s n z0 z1 dx dy nx ny \fP[ \fIx0 y0 x1 y1\fP ] [ \fImed scale\fP ] [\fI mean std rms\fP] [\fIn_nan\fP].
The data in brackets are output only if the corresponding options
\fB\-M, \-L1\fP, \fB\-L2\fP, and \fB\-M\fP are used, respectively.
If the \fB\-I\fP option is used, the output format is instead
\fINF w e s n z0 z1\fP, where \fINF\fP is the total number of grids read and \fIw e s n\fP are rounded off (see \fB\-I\fP).
.TP
.B \-F
Report grid domain and x/y-increments in world mapping format [Default is generic].
Does not apply to the \fB\-C\fP option.
.TP
.B \-I
Report the min/max of the region to the nearest multiple of \fIdx\fP and \fIdy\fP,
and output this in the form \fB\-R\fP\fIw/e/s/n\fP (unless \fB\-C\fP is set).
To report the actual grid region, select \fB\-I-\fP.  If no argument is given
then we report the grid increment in the form \fB\-I\fP\fIxinc/yinc\fP.
.TP
.B \-L1
Report median and L1 scale of z (L1 scale = 1.4826 * Median Absolute Deviation (MAD)).
.TP
.B \-L2
Report mean, standard deviation, and rms of z.
.TP
.B \-M
Find and report the location of min/max z-values, and count and report the number of nodes
set to NaN, if any.
.TP
.B \-T
Determine min and max z-value, round off to multiples of \fIdz\fP, and report as the text string
\fB\-T\fP\fIzmin/zmax/dz\fP for use by \fBmakecpt\fP.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-f
Special formatting of input and output columns (time or geographical data).
Specify \fBi\fP(nput) or \fBo\fP(utput) [Default is both input and output].
Give one or more columns (or column ranges) separated by commas.
Append \fBT\fP (Absolute calendar time), \fBt\fP (time relative to chosen \fBTIME_EPOCH\fP),
\fBx\fP (longitude), \fBy\fP (latitude), or \fBf\fP (floating point) to each column
or column range item.  Shorthand \fB\-f\fP[\fBi\fP|\fBo\fP]\fBg\fP means \fB\-f\fP[\fBi\fP|\fBo\fP]0\fBx\fP,1\fBy\fP
(geographic coordinates).
.SH EXAMPLES
To obtain all the information about the data set in file hawaii_topo.grd:
.br
.sp
\fBgrdinfo\fP \fB\-L1 \-L2 \-M\fP hawaii_topo.grd
.SH "SEE ALSO"
.IR GMT (l),
.IR grd2cpt (l),
.IR grd2xyz (l),
.IR grdedit (l)
