/*
 * BackupStatus.java
 *
 * Created on December 13, 2000, 6:52 AM
 */

package com.sun.enterprise.config.backup.status;

import java.util.Date;
import com.sun.enterprise.config.backup.BackupException;
import com.sun.enterprise.config.backup.utils.BackupHelper;
import com.sun.enterprise.config.backup.utils.FactoryHelper;

/**
 * Backup Status is used to keep the status for 
 * the backup action. 
 * @author  sridatta
 */
public class BackupStatus extends Status {
    
    private String _absoluteBackupFileName;
   
    /** directory where the backup file is stored .
     */
    private String _backupDir;
    
    /** Size of the backup file */
    private long _backupFileSize;
    
    /** user entered extra info */
    private String _userInfo;
    
    /** Creates a new instance of BackupStatus */
    public BackupStatus() {
    }
    
    public BackupStatus(String userInfo, boolean initialize) throws BackupException {
        super(initialize);
        _userInfo = userInfo;
        if(initialize) {
            init();
        }
    }
    
    /**
     * Determine the next number to be created
     * Managed the max numbers.
     * Delete the oldest one if required
     * get the prefix
     * add timestamp
     * create fileName = dir/prefix + timestamp+ number
     *
     * Update BackupNumber, TargetFile in BackupStatus
     * update source files, etc
     */
    private void init()  throws BackupException {
        setBackupDirectory(getDirectory());
        setAbsoluteBackupFileName(getAbsoluteName(getCreationTimeStamp()));
    }
    
    protected String getDirectory() throws BackupException {
        return FactoryHelper.getEnv().getDirectoryToStoreBackupFiles();
    }
    
    private String getAbsoluteName(long ts) {
        return BackupHelper.getAbsoluteBackupFileName(ts);
    }
    
   public String getAbsoluteBackupFileName() {
        return _absoluteBackupFileName;
    }
    
    public String getBackupDirectory() {
        return _backupDir;
    }
       
    public long getBackupFileSize() {
        return _backupFileSize;
    }
    
    public void setBackupFileSize(long size) {
        _backupFileSize = size;
    }
    
    public String getUserInfo() {
        return _userInfo;
    }
    
    protected void setUserInfo(String s) {
        _userInfo = s;
    }
    
    public void setAbsoluteBackupFileName(String name) {
        _absoluteBackupFileName = name;
    }
    
    
    private void setBackupDirectory(String dir) {
        _backupDir = dir;
    }
    
    protected String thisToString() {
        
       String result = 
            "Backup FileName " + _absoluteBackupFileName + ", " +
            "Backup File Size " + _backupFileSize;       
       
              String userInfo = getUserInfo();
        
        if(userInfo != null && !userInfo.equals("") ) {
            result += ", User Info=" + userInfo;
        }
              
       return result;
    }
    
    public String getOperation() {
        return "backup";
    }
   
    public String[] getDirectoriesToBackup() {
        return FactoryHelper.getEnv().getDirectoriesToBackup();
    }
}
