# !/usr/bin/env python
#    Giplet - GNOME Panel Applet to display an IP Address
#    Copyright (C) 2006  Erik Larson
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#
import sys
try:
    import pygtk
    pygtk.require('2.0')
except:
    pass
try:
    import gtk
    import gtk.glade
    import os
    import os.path
    import giplet_globals as gipglobals
except:
    sys.exit(1)
    
class GipPrefs:
    """Giplet Preferences Class"""
    def __init__(self):        
        self.isFromInterface = 1
        self.isFromWeb = 0
        self.interface = "eth0"
        self.website = "www.getmyip.org"
        self.isTimer = 0
        self.interval = 10
        self.settingsFile = os.path.expanduser('~/.giplet/giplet-settings')
        
    def saveSettings(self, gipDlg):    
        self.isFromInterface = int(gipDlg.rbFromInterface.get_active())
        self.isFromWeb = int(gipDlg.rbFromWeb.get_active())
        self.interface = gipDlg.txtInterface.get_text()
        self.website = gipDlg.txtWebsite.get_text()
        self.isTimer = int(gipDlg.chkTimer.get_active())
        self.interval = int(gipDlg.txtTimer.get_text())
        
    def readFromFile(self):
        if (os.path.exists(self.settingsFile)):
            f = open(self.settingsFile, 'r')
            # Read the version number, ignore 
            f.readline()
            # Read the timer
            try:
                self.isTimer = int(f.readline()[:-1])
            except:
                self.isTimer = 0
            # Read the timer interval
            try:
                self.interval = int(f.readline()[:-1])
            except:
                self.interval = 10
            # Read the is interface
            try:
                self.isFromInterface = f.readline()[:-1]
            except:
                self.isFromInterface = 1
            # Read the interface
            try:
                self.interface = f.readline()[:-1]
            except:
                self.interface = 'eth0'
            # Read the is web
            try:
                self.isFromWeb = int(f.readline()[:-1])
            except:
                self.isFromWeb = 0
            # Read the website
            try:
                self.website = f.readline()[:-1]
            except:
                self.website = 'www.getmyip.org'
            # Close the file
            f.close()
        
        
    def writeToFile(self):
        settingsFile = os.path.expanduser('~/.giplet/giplet-settings')
        directory = os.path.dirname(settingsFile)
        if (not os.path.exists(directory)):
            os.mkdir(directory)
        f = open(settingsFile, 'w')
        f.write('1.0\n')
        f.write(str(self.isTimer) + '\n')
        f.write(str(self.interval) + '\n')
        f.write(str(self.isFromInterface) + '\n')
        f.write(self.interface + '\n')
        f.write(str(self.isFromWeb) + '\n')
        f.write(str(self.website) + '\n')
        f.close()
        
    def printSettings(self):
        print '*** start ***'
        print self.isTimer
        print self.interval
        print self.isFromInterface
        print self.interface
        print self.isFromWeb
        print self.website
        print '*** end ***'        
    
class GipPrefsDlg:
    """Giplet Preferences Dialog"""
    
    def __init__(self, gipPrefs):
        #Set the Glade File
        self.gladefile = gipglobals.glade_dir + "/giplet.glade"
        self.gipPrefs = gipPrefs
        self.getControls()                    
        self.setValues()
        
    def getControls(self):
        # Load the Widget Tree
        self.wTree = gtk.glade.XML(self.gladefile, "pref")        
        # Get the Dialog
        self.dlg = self.wTree.get_widget("pref")
        # Get the Radio Buttons
        self.rbFromWeb = self.wTree.get_widget("fromWeb")
        self.rbFromInterface = self.wTree.get_widget("fromInterface")
        # Get  the IP text boxes
        self.txtInterface = self.wTree.get_widget("interface")
        self.txtWebsite = self.wTree.get_widget("website")
        # Get the Timer Controls
        self.chkTimer = self.wTree.get_widget("recheck")
        self.txtTimer = self.wTree.get_widget("timerinterval")                
        
    def setValues(self):
        fromWeb = bool(self.gipPrefs.isFromWeb)
        self.rbFromWeb.set_active(fromWeb)
        self.rbFromInterface.set_active(not fromWeb)
        self.txtInterface.set_text(self.gipPrefs.interface)
        self.txtWebsite.set_text(self.gipPrefs.website)
        self.chkTimer.set_active(bool(self.gipPrefs.isTimer))
        self.txtTimer.set_text(str(self.gipPrefs.interval))
        
    def run(self):        
        # Run the Dialog
        self.result = self.dlg.run()   
        # After Running
        self.gipPrefs.saveSettings(self)
        # Done
        self.dlg.destroy()
        # Return
        return self.result
    
        
