class FVSkyview {
    constructor {args} {}
    destructor {}

    private variable skyvID
    private variable skyvCoord
    private variable skyvCoordSys
    private variable skyvEquinox
    private variable skyvImgSized
    private variable skyvImgSizex
    private variable skyvImgSizey
    private variable skyvCatalogFlag
    private variable skyvPlotFlag

    private variable skyvcatID
    private variable catCoord
    private variable catCoordSys
    private variable catEquinox
    private variable catImgSized
    private variable catOverlayFlag

    public method setskyvCoordSys {}
    public method getskyvcat {}
    public method getskyvfile {} 
    private method skyviewOK {}
    private method skyviewReset {}
    private method catOK {}
    private method catReset {}
    private method configCatalog {}
} 

body FVSkyview::constructor {args} {
    set skyvID 0
    set skyvCoord  ""
    set skyvCoordSys "Equatorial"
    set skyvEquinox "2000"
    set skyvImgSized "Default"
    set skyvImgSizex "300"
    set skyvImgSizey "300"
    set skyvCatalogFlag 0
    set skyvPlotFlag 1

    set skyvcatID 0
    set catCoord  ""
    set catCoordSys "Equatorial"
    set catImgSized ""
    set catEquinox "2000"
    set catOverlayFlag 0
}

body FVSkyview::destructor {} {   
}


body FVSkyview::getskyvfile {} {

    global titleFont


    
    if ![info exist skyvID] {
       set skyvID 1
    }

 
    if ![info exist skyvEquinox ] {
       set skyvEquinox "2000"
    }

    if ![info exist skyvImgSized ] {
       set skyvImgSized "Default"
    }


    if ![info exist skyvImgSizex ] {
       set skyvImgSizex "300"
    }

    if ![info exist skyvImgSizey ] {
       set skyvImgSizey "300"
    }

    if ![info exist skyvCatalogFlag ] {
       set skyvCatalogFlag 0
    } 
    
    if [winfo exist .skyviewdlg] {
       focus .skyviewdlg
       raise .skyviewdlg
       return
    }

    toplevel .skyviewdlg -class Dialog
    wm title .skyviewdlg "fv: SkyView"

    label .skyviewdlg.title -anchor w \
       -text "Retrieve an image from NASA's SkyView site." -font titleFont 
    pack  .skyviewdlg.title -pady 3 -padx 5 -anchor w

    frame .skyviewdlg.coord -relief flat
    label .skyviewdlg.coord.label -text "Coordinate or Source:" \
       -font titleFont -anchor w
    entry .skyviewdlg.coord.entry -width 40 \
            -textvariable [scope skyvCoord] -relief sunken   -font titleFont
    pack  .skyviewdlg.coord -pady 3 -padx 5 -anchor w
    pack  .skyviewdlg.coord.label .skyviewdlg.coord.entry -side left
    
    frame .skyviewdlg.note -relief flat
    label .skyviewdlg.note.label -text \
  "(e.g. \"Eta Carinae\", \"10 45 3.6, -59 41 4.2\", or \"161.265, -59.685\")" \
       -font titleFont -anchor w 
    pack  .skyviewdlg.note -pady 3 -padx 5 -anchor w
    pack  .skyviewdlg.note.label -side left
     
    frame .skyviewdlg.surveytext  -relief flat
    label .skyviewdlg.surveytext.label -text "Choose desired survey:" \
        -font titleFont -anchor w
    pack  .skyviewdlg.surveytext -pady 3 -padx 5 -anchor w
    pack  .skyviewdlg.surveytext.label -anchor w -side top 

    frame .skyviewdlg.survey  -relief flat
    listbox .skyviewdlg.survey.list  -exportselection 0 -takefocus 0 \
         -height 5 -width 40 -font titleFont \
         -yscrollcommand ".skyviewdlg.survey.scroll set"
    scrollbar .skyviewdlg.survey.scroll \
         -command ".skyviewdlg.survey.list yview"   
    .skyviewdlg.survey.list insert end "Digitized SkySurvey (optical)"
    .skyviewdlg.survey.list insert end "IRAS 12 micron (Infrared) "
    .skyviewdlg.survey.list insert end "IRAS 25 micron (Infrared) "
    .skyviewdlg.survey.list insert end "IRAS 60 micron (Infrared) "
    .skyviewdlg.survey.list insert end "IRAS 100 micron (Infrared) "
    .skyviewdlg.survey.list insert end "2MASS-J (Infrared) "
    .skyviewdlg.survey.list insert end "2MASS-H (Infrared) "
    .skyviewdlg.survey.list insert end "2MASS-K (Infrared) "
    .skyviewdlg.survey.list insert end "Greenbank (6 cm Radio) "
    .skyviewdlg.survey.list insert end "VLA FIRST (21 cm Radio) "
    .skyviewdlg.survey.list insert end \
		"WESTerbork N. Sky Survey (92 cm Radio)"
    .skyviewdlg.survey.list insert end "ROSAT PSPC 2.0 Deg (X-ray)"
    .skyviewdlg.survey.list insert end \
	      "ROSAT All Sky Survey 0.25 keV (X-ray)"
    .skyviewdlg.survey.list insert end \
	      "ROSAT All Sky Survey 0.75 keV (X-ray)"
    .skyviewdlg.survey.list insert end \
	      "ROSAT All Sky Survey 1.50 keV (X-ray)"
    .skyviewdlg.survey.list insert end "EGRET >100 MeV (Gamma-ray)"
    .skyviewdlg.survey.list insert end "EGRET <100 MeV (Gamma-ray)"
    .skyviewdlg.survey.list selection set 0 
    pack  .skyviewdlg.survey -pady 5 -padx 5 -anchor w
    pack .skyviewdlg.survey.list -side left 
    pack .skyviewdlg.survey.scroll -side right -fill y

    frame .skyviewdlg.coordsys -relief flat
    frame .skyviewdlg.coordsys.coord -relief flat
    set opt .skyviewdlg.coordsys.coord
    iwidgets::optionmenu $opt.sys -labeltext "System:" \
        -command {set skyvCoordSys [.skyviewdlg.coordsys.coord.sys get] }
    $opt.sys insert end "Equatorial"
    $opt.sys insert end "Galactic"
    $opt.sys insert end "Ecliptic"
    $opt.sys select 0

    frame $opt.equinox -relief flat
    label $opt.equinox.label -text "Equinox:  " \
          -font titleFont -anchor w
    entry $opt.equinox.entry -width 10 \
            -textvariable [scope skyvEquinox] -relief sunken   -font titleFont
    pack  $opt.equinox.label \
          $opt.equinox.entry  -side left -anchor w

    pack  $opt.sys -anchor w -side top 
    pack  $opt.equinox -anchor w -side top 

    frame .skyviewdlg.coordsys.options -relief flat
    frame .skyviewdlg.coordsys.options.imgsized -relief flat
    label .skyviewdlg.coordsys.options.imgsized.label \
            -text "Image width (degrees):" \
          -font titleFont -anchor w
    entry .skyviewdlg.coordsys.options.imgsized.entry -width 10 \
            -textvariable [scope skyvImgSized] -relief sunken   -font titleFont
    pack  .skyviewdlg.coordsys.options.imgsized.label \
          .skyviewdlg.coordsys.options.imgsized.entry \
           -side left -anchor w
    

    frame .skyviewdlg.coordsys.options.imgsizep -relief flat
    label .skyviewdlg.coordsys.options.imgsizep.label \
            -text "Image dimensions(Pixels):" \
          -font titleFont -anchor w
    label .skyviewdlg.coordsys.options.imgsizep.labelx \
            -text "X:" \
          -font titleFont -anchor w
    entry .skyviewdlg.coordsys.options.imgsizep.entryx -width 5 \
            -textvariable [scope skyvImgSizex] -relief sunken   -font titleFont
    label .skyviewdlg.coordsys.options.imgsizep.labely \
            -text "Y:" \
          -font titleFont -anchor w
    entry .skyviewdlg.coordsys.options.imgsizep.entryy -width 5 \
            -textvariable [scope skyvImgSizey] -relief sunken   -font titleFont
    pack  .skyviewdlg.coordsys.options.imgsizep.label  \
          .skyviewdlg.coordsys.options.imgsizep.labelx \
          .skyviewdlg.coordsys.options.imgsizep.entryx \
          .skyviewdlg.coordsys.options.imgsizep.labely \
          .skyviewdlg.coordsys.options.imgsizep.entryy \
           -side left -anchor w

    pack .skyviewdlg.coordsys.options.imgsized \
         .skyviewdlg.coordsys.options.imgsizep \
         -pady 5 -padx 5 -anchor w

    pack  .skyviewdlg.coordsys.coord -pady 3 -padx 5 -anchor w -side left
    pack  .skyviewdlg.coordsys.options -pady 3 -padx 5 -anchor n -side left
    pack  .skyviewdlg.coordsys -pady 3 -padx 5 -anchor w 

    frame .skyviewdlg.choices  -relief flat
    checkbutton .skyviewdlg.choices.cat \
         -text "Retrieve catalog(s) of objects within image?" \
        -font titleFont -anchor w -onvalue 1  -offvalue 0 \
        -variable [scope skyvCatalogFlag ] \
        -command [code $this configCatalog]
        
    pack  .skyviewdlg.choices -pady 3 -padx 5 -anchor w
    pack  .skyviewdlg.choices.cat -anchor w -side top 


    frame .skyviewdlg.catalog  -relief flat
    listbox .skyviewdlg.catalog.list  -exportselection 0 -takefocus 0 \
         -height 5 -width 40 -font titleFont -selectmode multiple \
         -yscrollcommand ".skyviewdlg.catalog.scroll set"
    scrollbar .skyviewdlg.catalog.scroll \
         -command ".skyviewdlg.catalog.list yview"   
    pack  .skyviewdlg.catalog -pady 3 -padx 5 -anchor w
    pack .skyviewdlg.catalog.list -side left 
    pack .skyviewdlg.catalog.scroll -side right -fill y
    configCatalog

    frame .skyviewdlg.plotchoice  -relief flat
    checkbutton .skyviewdlg.plotchoice.plot \
        -text "Display image after retrieving?" \
        -font titleFont -anchor w -onvalue 1  -offvalue 0 \
        -variable [scope skyvPlotFlag ]
    pack  .skyviewdlg.plotchoice -pady 3 -padx 5 -anchor w
    pack  .skyviewdlg.plotchoice.plot -anchor w -side top 

    frame .skyviewdlg.skyviewbt -relief flat
    button .skyviewdlg.skyviewbt.submit -text Submit  -width 8 \
           -command [code $this skyviewOK]
    button .skyviewdlg.skyviewbt.reset -text Reset -width 8 \
        -command [code $this skyviewReset]  
    button .skyviewdlg.skyviewbt.cancel -text Close -width 8 \
        -command {destroy .skyviewdlg}
    button .skyviewdlg.skyviewbt.help -text Help -width 8 \
        -command {hhelp SkyView}
    pack .skyviewdlg.skyviewbt.submit -side left   -padx 10 
    pack .skyviewdlg.skyviewbt.reset  -side left  -padx 10
    pack .skyviewdlg.skyviewbt.cancel -side left  -padx 10
    pack .skyviewdlg.skyviewbt.help   -side left -padx 10
    pack .skyviewdlg.skyviewbt -side top -pady 5 -padx 5 -expand true 
    tkwait window .skyviewdlg
}    

body FVSkyview::configCatalog {} { 
   if {$skyvCatalogFlag == 1} { 
    .skyviewdlg.catalog.list insert end "HST Guide Stars (1.1)"
    .skyviewdlg.catalog.list insert end "SAO Star Catalog"
    .skyviewdlg.catalog.list insert end "Bright Star Catalog"
    .skyviewdlg.catalog.list insert end "Hipparcos Main Catalog"
    .skyviewdlg.catalog.list insert end "Tycho-2 Catalog"
    .skyviewdlg.catalog.list insert end "Master Optical Catalogs"
    .skyviewdlg.catalog.list insert end "Master X-ray catalogs"
    .skyviewdlg.catalog.list insert end "Master Radio Catalogs"
    .skyviewdlg.catalog.list insert end "NGC 2000.0"
    .skyviewdlg.catalog.list insert end "Messier Nebulae"
    .skyviewdlg.catalog.list insert end "Extraglactic Radio Sources"
    .skyviewdlg.catalog.list insert end "Gliese Catalog of Nearby Stars"
    .skyviewdlg.catalog.list insert end "Henry Draper (HD) Catalog"
    .skyviewdlg.catalog.list insert end "Huchra CfA Redshift Catalog"
    .skyviewdlg.catalog.list insert end "IRAS Faint Sources"
    .skyviewdlg.catalog.list insert end "IRAS Point Sources"
    .skyviewdlg.catalog.list insert end "Markarian Galaxies"
    .skyviewdlg.catalog.list insert end "ROSAT All-Sky Survey: Bright Sources"
    .skyviewdlg.catalog.list insert end "ROSAT All-Sky Survey: Faint Sources"
    .skyviewdlg.catalog.list insert end "ROSAT Catalog PSPC RX MPE Sources"
    .skyviewdlg.catalog.list insert end "ROSAT Catalog PSPC WGA Sources"
    .skyviewdlg.catalog.list insert end "Third Reference Catalog of Galaxies"
    .skyviewdlg.catalog.list insert end "USNO A-2 (Monet) Catalog"
    .skyviewdlg.catalog.list insert end "Uppsala General Catalog of Galaxies"
    .skyviewdlg.catalog.list insert end "Veron Quasars & AGNs (V2000)"
    .skyviewdlg.catalog.list insert end "Zwicky Clusters"
   } else {
     .skyviewdlg.catalog.list delete 0 end 
   } 
}

body FVSkyview::skyviewOK {} {
    global fitsFileMode
    global backupDir

    package  require http 2.3

    set skyviewfile [file join $backupDir skyview.tmp$skyvID]
    if [file exists $skyviewfile] {
          file delete $skyviewfile
    }

    set i [.skyviewdlg.survey.list curselection]
    set skyvsurvey [.skyviewdlg.survey.list get $i ]
    regsub {\(.*} $skyvsurvey "" skyvsurvey
    set skyvsurvey [string trim $skyvsurvey]


    if {$skyvCoord == "" } { 
       tk_dialog .skverr "Skyview Error"  \
                        "Source is not entered." error 0 Ok
       return
    }


    set skyviewout [open $skyviewfile w]
    set  cmd [list ::http::formatQuery \
              VCOORD $skyvCoord   \
              SURVEY $skyvsurvey   \
              SCOORD $skyvCoordSys \
              SFACTR $skyvImgSized \
              PIXELX $skyvImgSizex \
              PIXELY $skyvImgSizey ] 
    if {$skyvCatalogFlag == 1} {
          set catalogs [.skyviewdlg.catalog.list curselection]  
          set l [llength $catalogs]
          if {$l == 0} {
             tk_dialog .skverr "Skyview Error"  \
               "The catalogs are not selected." error 0 Ok
             return
          }
          set catstr ""
          for {set i 0} {$i < $l} {incr i} { 
             set j [lindex $catalogs $i]
             set skyvcatalog [.skyviewdlg.catalog.list get $j]
             lappend catstr CATLOG  
             lappend catstr $skyvcatalog
          }
          set cmd [concat $cmd $catstr]
     } 
     set skyviewqst [eval $cmd]

     .skyviewdlg.skyviewbt.submit configure -state disabled
     .skyviewdlg.skyviewbt.reset configure -state disabled
     .skyviewdlg.skyviewbt.cancel configure -state disabled
     
     set token [::http::geturl "skyview.gsfc.nasa.gov/cgi-bin/pskcall" \
          -channel $skyviewout -query $skyviewqst  ] 
     close $skyviewout
     .skyviewdlg.skyviewbt.submit configure -state normal
     .skyviewdlg.skyviewbt.reset configure -state normal
     .skyviewdlg.skyviewbt.cancel configure -state normal


     set temptest [open $skyviewfile r ]  
     set line [read $temptest 6]
     close $temptest
     if {$line != "SIMPLE" } {  
       set temptest [open $skyviewfile r ]  
       set errstr ""
       set errorflag 0
       while {[gets $temptest line] >= 0} {
          if [regexp {^<P>} $line] {
             set  errorflag 0
          }  
          if [regexp {^ERROR:} $line] {
             set  errorflag 1
          }  
          if {$errorflag == 1} {
             set errstr "${errstr}${line}"
          }
       } 
       close $temptest
       if {$errstr == ""} {
            tk_dialog .skvmsg "Skyview Message"  \
     "No image available at this sky position in the selected survey."  \
                        info 0 Ok
            return 
       }	     
       tk_dialog .skverr "Skyview Error"  \
                        $errstr  error 0 Ok
       return
     } 

        
     set tmp [fits open $skyviewfile 0] 
     set hdunum [$tmp info nhdu]
     $tmp close 
 
     set oldMode $fitsFileMode
     # Set Read-Only flag
     set fitsFileMode 1
     set tmp [openFitsFile $skyviewfile]
     $tmp changeFile
     set fitsFileMode $oldMode
     incr skyvID

     if { $skyvPlotFlag == 1} {  
        fvCmds::select $skyviewfile
        fvCmds::display image 0 
        if { $skyvCatalogFlag == 1} {
          if { $hdunum == 2} {
           fvCmds::display curve 1 RA {} DEC {} 1 
          }  
          if {$hdunum < 2 } {
            tk_dialog .skvmsg "Skyview Message"  \
                   "No desired objects are found in the selected catalog(s)"  \
                        info 0 Ok
            return 
          }
        }
     }
}

body FVSkyview::skyviewReset {} {
      set skyvCoord  ""
      set skyvCoordSys "Equatorial"
      set skyvEquinox "2000"
      set skyvImgSized "Default"
      set skyvImgSizex "300"
      set skyvImgSizey "300"
      set skyvCatalogFlag 0
      set skyvPlotFlag 1
      .skyviewdlg.survey.list selection clear 0 end
      .skyviewdlg.survey.list selection set 0 
      configCatalog
}

body FVSkyview::getskyvcat {} {

    global titleFont


    
    if ![info exist skyvcatID] {
       set skyvcatID 1
    }

    if ![info exist catEquinox ] {
       set catEquinox "2000"
    }

    if ![info exist catOverlagFlag ] {
       set catOverlayFlag 0
    }

    if [winfo exist .skyvcatdlg] {
       focus .skyvcatdlg
       raise .skyvcatdlg
       return
    }

    toplevel .skyvcatdlg -class Dialog
    wm title .skyvcatdlg "fv: Catalog"

    label .skyvcatdlg.title -anchor w \
       -text "Retrieve catalog of objects from NASA's SkyView site." \
       -font titleFont 
    pack  .skyvcatdlg.title -pady 3 -padx 5 -anchor w

    frame .skyvcatdlg.coord -relief flat
    label .skyvcatdlg.coord.label -text "Coordinate or Source:" \
       -font titleFont -anchor w
    entry .skyvcatdlg.coord.entry -width 40 \
            -textvariable [scope catCoord] -relief sunken   -font titleFont
    pack  .skyvcatdlg.coord -pady 5 -padx 5 -anchor w
    pack  .skyvcatdlg.coord.label .skyvcatdlg.coord.entry -side left
    
    frame .skyvcatdlg.note -relief flat
    label .skyvcatdlg.note.label -text \
  "(e.g. \"Eta Carinae\", \"10 45 3.6, -59 41 4.2\", or \"161.265, -59.685\")" \
       -font titleFont -anchor w 
    pack  .skyvcatdlg.note -pady 5 -padx 5 -anchor w
    pack  .skyvcatdlg.note.label -side left
     

    frame .skyvcatdlg.radius -relief flat
    label .skyvcatdlg.radius.label -text "Search width (degrees):" \
          -font titleFont -anchor w
    entry .skyvcatdlg.radius.entry -width 10 \
            -textvariable [scope catImgSized] -relief sunken   -font titleFont
    pack  .skyvcatdlg.radius -pady 5 -padx 5 -anchor w
    pack  .skyvcatdlg.radius.label .skyvcatdlg.radius.entry \
           -side left -anchor w

    frame .skyvcatdlg.catalogtext  -relief flat
    label .skyvcatdlg.catalogtext.label -text "Choose desired catalog(s)" \
        -font titleFont -anchor w 
    pack  .skyvcatdlg.catalogtext -pady 5 -padx 5 -anchor w
    pack  .skyvcatdlg.catalogtext.label -anchor w -side top 


    frame .skyvcatdlg.catalog  -relief flat
    listbox .skyvcatdlg.catalog.list  -exportselection 0 -takefocus 0 \
         -height 5 -width 40 -font titleFont -selectmode multiple \
         -yscrollcommand ".skyvcatdlg.catalog.scroll set"
    scrollbar .skyvcatdlg.catalog.scroll \
         -command ".skyvcatdlg.catalog.list yview"   
    .skyvcatdlg.catalog.list insert end "HST Guide Stars (1.1)"
    .skyvcatdlg.catalog.list insert end "SAO Star Catalog"
    .skyvcatdlg.catalog.list insert end "Bright Star Catalog"
    .skyvcatdlg.catalog.list insert end "Hipparcos Main Catalog"
    .skyvcatdlg.catalog.list insert end "Tycho-2 Catalog"
    .skyvcatdlg.catalog.list insert end "Master Optical Catalogs"
    .skyvcatdlg.catalog.list insert end "Master X-ray catalogs"
    .skyvcatdlg.catalog.list insert end "Master Radio Catalogs"
    .skyvcatdlg.catalog.list insert end "NGC 2000.0"
    .skyvcatdlg.catalog.list insert end "Messier Nebulae"
    .skyvcatdlg.catalog.list insert end "Extraglactic Radio Sources"
    .skyvcatdlg.catalog.list insert end "Gliese Catalog of Nearby Stars"
    .skyvcatdlg.catalog.list insert end "Henry Draper (HD) Catalog"
    .skyvcatdlg.catalog.list insert end "Huchra CfA Redshift Catalog"
    .skyvcatdlg.catalog.list insert end "IRAS Faint Sources"
    .skyvcatdlg.catalog.list insert end "IRAS Point Sources"
    .skyvcatdlg.catalog.list insert end "Markarian Galaxies"
    .skyvcatdlg.catalog.list insert end "ROSAT All-Sky Survey: Bright Sources"
    .skyvcatdlg.catalog.list insert end "ROSAT All-Sky Survey: Faint Sources"
    .skyvcatdlg.catalog.list insert end "ROSAT Catalog PSPC RX MPE Sources"
    .skyvcatdlg.catalog.list insert end "ROSAT Catalog PSPC WGA Sources"
    .skyvcatdlg.catalog.list insert end "Third Reference Catalog of Galaxies"
    .skyvcatdlg.catalog.list insert end "USNO A-2 (Monet) Catalog"
    .skyvcatdlg.catalog.list insert end "Uppsala General Catalog of Galaxies"
    .skyvcatdlg.catalog.list insert end "Veron Quasars & AGNs (V2000)"
    .skyvcatdlg.catalog.list insert end "Zwicky Clusters"
    .skyvcatdlg.catalog.list selection set 0 
    pack  .skyvcatdlg.catalog -pady 5 -padx 5 -anchor w
    pack .skyvcatdlg.catalog.list -side left 
    pack .skyvcatdlg.catalog.scroll -side right -fill y

    frame .skyvcatdlg.coordsys -relief flat
    frame .skyvcatdlg.coordsys.coord -relief flat
    label .skyvcatdlg.coordsys.coord.label -text "Cooridinate System:" \
           -font titleFont -anchor w 
    radiobutton .skyvcatdlg.coordsys.coord.equatorial  -text "Equatorial" \
          -font titleFont -variable [scope catCoordSys] -value "Equatorial"
    radiobutton .skyvcatdlg.coordsys.coord.galactic  -text "Galactic" \
          -font titleFont -variable [scope catCoordSys] -value "Galactic"
    radiobutton .skyvcatdlg.coordsys.coord.ecliptic  -text "Ecliptic" \
          -font titleFont -variable [scope catCoordSys] -value "Ecliptic"
    .skyvcatdlg.coordsys.coord.equatorial select
    pack  .skyvcatdlg.coordsys.coord.label -anchor w -side top 
    pack .skyvcatdlg.coordsys.coord.equatorial -anchor w -side top 
    pack .skyvcatdlg.coordsys.coord.galactic -anchor w -side top 
    pack .skyvcatdlg.coordsys.coord.ecliptic -anchor w -side top 

    frame .skyvcatdlg.coordsys.options -relief flat
    label .skyvcatdlg.coordsys.options.label -text "Equinox:" \
          -font titleFont -anchor w
    entry .skyvcatdlg.coordsys.options.entry -width 10 \
            -textvariable [scope catEquinox] -relief sunken   -font titleFont
    checkbutton .skyvcatdlg.coordsys.options.checkbox \
        -text "Plot on the current graph? " \
        -font titleFont -anchor w -onvalue 1  -offvalue 0 \
        -variable [scope catOverlayFlag ]
    pack  .skyvcatdlg.coordsys.options.label -anchor w -side top
    pack  .skyvcatdlg.coordsys.options.entry -anchor w -side top
    pack  .skyvcatdlg.coordsys.options.checkbox -anchor w -side bottom

    pack  .skyvcatdlg.coordsys.coord -pady 5 -padx 5 -anchor w -side left
    pack  .skyvcatdlg.coordsys.options -pady 5 -padx 5 -anchor n -side left \
           -fill y
    pack  .skyvcatdlg.coordsys -pady 5 -padx 5 -anchor w 


    frame .skyvcatdlg.skyvcatbt -relief flat
    button .skyvcatdlg.skyvcatbt.submit -text Submit  -width 8 \
           -command [code $this catOK ]
    button .skyvcatdlg.skyvcatbt.reset -text Reset -width 8 \
        -command  [code $this catReset ]
    button .skyvcatdlg.skyvcatbt.cancel -text Close -width 8 \
        -command {destroy .skyvcatdlg}
    button .skyvcatdlg.skyvcatbt.help -text Help -width 8 \
        -command {hhelp catalog}
    pack .skyvcatdlg.skyvcatbt.submit -side left   -padx 10 
    pack .skyvcatdlg.skyvcatbt.reset  -side left  -padx 10
    pack .skyvcatdlg.skyvcatbt.cancel -side left  -padx 10
    pack .skyvcatdlg.skyvcatbt.help   -side left -padx 10
    pack .skyvcatdlg.skyvcatbt -side top -pady 5 -padx 5 -expand true 
    
    tkwait window .skyvcatdlg
}    

body FVSkyview::catOK {} {
    global fitsFileMode
    global backupDir
    package  require http 2.3

    set skyvcatfile [file join $backupDir skyvcat.tmp$skyvcatID]
    if [file exists $skyvcatfile] {
          file delete $skyvcatfile
    }

    set skyvcatout [open $skyvcatfile w]
    set skyvcattemp ""

    if {$catCoord == "" } { 
       tk_dialog .skverr "Catalog Error"  \
                        "Source is not entered." error 0 Ok
       return
    }
    if {$catImgSized == ""} {
             tk_dialog .skverr "Catalog Error"  \
                  "Search width is not entered." error 0 Ok
             return
    }
    set  cmd [list ::http::formatQuery \
              VCOORD $catCoord   \
              SURVEY $skyvcattemp   \
              SCOORD $catCoordSys \
              SFACTR $catImgSized ]
    set i [.skyvcatdlg.catalog.list curselection]
    set catalogs [.skyvcatdlg.catalog.list curselection]  
    set l [llength $catalogs]
    if {$l == 0} {
       tk_dialog .skverr "Catalog Error"  \
           "The catalogs are not selected." error 0 Ok
       return
    }
    set catstr ""
    for {set i 0} {$i < $l} {incr i} { 
        set j [lindex $catalogs $i]
        set catcatalog [.skyvcatdlg.catalog.list get $j]
        lappend catstr CATLOG  
        lappend catstr $catcatalog
    }
    set cmd [concat $cmd $catstr]
    set skyvcatqst [eval $cmd]

    .skyvcatdlg.skyvcatbt.submit configure -state disabled
    .skyvcatdlg.skyvcatbt.reset configure -state disabled
    .skyvcatdlg.skyvcatbt.cancel configure -state disabled

    set token [::http::geturl "skyview.gsfc.nasa.gov/cgi-bin/pskcall" \
         -channel $skyvcatout -query $skyvcatqst ] 
    close $skyvcatout
    .skyvcatdlg.skyvcatbt.submit configure -state normal
    .skyvcatdlg.skyvcatbt.reset configure -state normal
    .skyvcatdlg.skyvcatbt.cancel configure -state normal


     set temptest [open $skyvcatfile r ]  
     set line [read $temptest 6]
     close $temptest
     if {$line != "SIMPLE" } {  
       set temptest [open $skyvcatfile r ]  
       set errstr ""
       set errorflag 0
       while {[gets $temptest line] >= 0} {
          if [regexp {^<P>} $line] {
             set  errorflag 0
          }  
          if [regexp {^ERROR:} $line] {
             set  errorflag 1
          }  
          if {$errorflag == 1} {
             set errstr "${errstr}${line}"
          }
       } 
       close $temptest
       if {$errstr == ""} {
            tk_dialog .skvmsg "Catalog Message"  \
                        "No desired objects are found in selected catalog(s)"  \
                        info 0 Ok
            return 
       }
       tk_dialog .skverr "Catalog Error"  \
                        $errstr  error 0 Ok
       return
     }
    set oldMode $fitsFileMode
    
    set tmp [fits open $skyvcatfile 0] 
    set hdunum [$tmp info nhdu]
    $tmp close 

    # Set Read-Only flag
    set fitsFileMode 1
    set tmp [openFitsFile $skyvcatfile]
    $tmp changeFile
    set fitsFileMode $oldMode
    incr skyvcatID 
    
    # Plot on the current graph
    if { $catOverlayFlag == 1} {  
        fvCmds::select $skyvcatfile
        if { $hdunum == 2} {
           fvCmds::display curve 1 RA {} DEC {} 1 
        }  
    }
}

body FVSkyview::catReset {} {
          set catCoord  ""
          set catImgSized ""
          set catEquinox "2000"
          set catOverlayFlag 0
    .skyvcatdlg.catalog.list selection clear 0 end
}


