#!/usr/bin/env python

# $Id: gen_parser_gen.py 4372 2009-03-09 12:12:32Z potyra $

# Copyright (C) 2009 FAUmachine Team <info@faumachine.org>.
# This program is free software. You can redistribute it and/or modify it
# under the terms of the GNU General Public License, either version 2 of
# the License, or (at your option) any later version. See COPYING.

import subprocess
import sys

def check_bison_version():
	output = subprocess.Popen(["bison", "--version"], 
				stdout=subprocess.PIPE).communicate()[0]
	bv = output.split(")")[1].split("\n")[0].strip()

	return bv

def version_lt(v1, v2):
	""" v1 < v2 -> True, False otherwise
	"""
	v1ses = v1.split(".")
	v2ses = v2.split(".")
	v1ses.reverse()
	v2ses.reverse()

	while (len(v1ses) > 0) and (len(v2ses) > 0):
		t1 = v1ses.pop()
		t2 = v2ses.pop()

		i1 = int(t1)
		i2 = int(t2)

		if (i1 < i2):
			return True

		if (i1 > i2):
			return False
		
	# all consumed numbers equal
	if (len(v1ses) == 0) and (len(v2ses) == 0):
		return False

	# either v1 or v2 still contains digits 
	if len(v1ses) > 0:
		# e.g. "1.2.3.4" vs "1.2.3"
		return False

	# v1 empty, but v2 contains digits
	return True

def gen_parser(infile, outfile, version):
	f = file(infile, "r")
	of = file(outfile, "w")

	txt = f.read()
	f.close()

	if version_lt(version, "2.4.1"):
		# use %{ and %} for header code
		HEADER_DEFINITIONS_START="%{"
		HEADER_DEFINITIONS_END="%}"

	else:
		# 2.4.1 or later, can use "%code requires"
		HEADER_DEFINITIONS_START="%code requires {"
		HEADER_DEFINITIONS_END="}"
	
	txt = txt.replace("@HEADER_DEFINITIONS_START@", 
			HEADER_DEFINITIONS_START)

	txt = txt.replace("@HEADER_DEFINITIONS_END@",
			HEADER_DEFINITIONS_END)
	of.write(txt)
	of.close()

def usage():
	print "%s <infile> <outfile>" % sys.argv[0]

if __name__ == '__main__':
	if len(sys.argv) != 3:
		usage()
		sys.exit(1)

	v = check_bison_version()
	print "Detect bison version %s" % v
	print "Generating parser file %s from %s" % (sys.argv[2], sys.argv[1])
	gen_parser(sys.argv[1], sys.argv[2], v)
