/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename slots use Qt Designer which will
** update this file, preserving your code. Create an init() slot in place of
** a constructor, and a destroy() slot in place of a destructor.
*****************************************************************************/

#include <stdio.h>
#include <qmessagebox.h>
#include "recorder-background.xpm"
#include "plugins/bitmapbutton/bitmapbutton.h" 
#include "plugins/bitmapslider/bitmapslider.h" 
#include "cfgfile.h"
#include "metatracker.h"
#include "jack.h"
#include <qtimer.h>

void Recorder::init()
{
    meta_pos=0;
    meta_timer=new QTimer(this);
    connect(meta_timer, SIGNAL(timeout()), this, SLOT(meta_timeout()));
    meta_timer->start(200);
    
    BroadcastData->setBackgroundColor(QColor(0, 0, 0));
    QPalette pal=BroadcastData->palette();
    pal.setColor(QColorGroup::Foreground, QColor(255, 255, 0));
    BroadcastData->setPalette(pal);
    
    background=new QPixmap((const char **)recorder_background_xpm);
    
    LeftOnAir->hide();
    RightOnAir->hide();
    
    left=new Meter(this, 0, WRepaintNoErase);
    left->setGeometry(43, 43, 24, 154);
    
    right=new Meter(this, 0, WRepaintNoErase);
    right->setGeometry(83, 43, 24, 154);
    
    left->setValue(0.0, 0.0);
	left->update();
    right->setValue(0.0, 0.0);
	right->update();
    
    buffer=new RingBuffer(65536);
    bc_buffer=new RingBuffer(65535);
    
    Client *c=((Frame *)parent())->client();
    left_port=new Port(c, "recorder_left", -1, Port::Input);
    right_port=new Port(c, "recorder_right", -1, Port::Input);
    left_bc=new Port(c, "broadcast_left", -1, Port::Input);
    right_bc=new Port(c, "broadcast_right", -1, Port::Input);
    
    data_thread=new Recdata(this);
    if(out_pipe[0])
	data_thread->setOutput(out_pipe);
    data_thread->start();
    
    processor=new RecordProcessor(c, this);
}

void Recorder::destroy()
{
    delete data_thread;
    delete processor;
    delete left_port;
    delete right_port;
    delete background;
    delete buffer;
    delete bc_buffer;
}

RingBuffer* Recorder::getBuffer()
{
    return buffer;
}

int Recorder::rec_process(jack_nframes_t nsamples, void *arg)
{
    Recorder *rec=this;
    
    jack_default_audio_sample_t *left=(jack_default_audio_sample_t *) left_port->buffer(nsamples);
    jack_default_audio_sample_t *right=(jack_default_audio_sample_t *) right_port->buffer(nsamples);
    jack_default_audio_sample_t *bc_left=(jack_default_audio_sample_t *) left_bc->buffer(nsamples);
    jack_default_audio_sample_t *bc_right=(jack_default_audio_sample_t *) right_bc->buffer(nsamples);
    
    jack_nframes_t i;
    
    unsigned short data[nsamples*2];
    
    if(rec->getBuffer()->write_space() >= nsamples*2*sizeof(short))
    {
	for(i=0;i<nsamples;i++)
	{
	    data[i*2]=(int)(32767.0*left[i]);
	    data[i*2+1]=(int)(32767.0*right[i]);
	}
	rec->getBuffer()->write((char *)data, sizeof(short)*nsamples*2);
	for(i=0;i<nsamples;i++)
	{
	    data[i*2]=(int)(32767.0*bc_left[i]);
	    data[i*2+1]=(int)(32767.0*bc_right[i]);
	}
	rec->get_bc_buffer()->write((char *)data, sizeof(short)*nsamples*2);
	rec_wait.wakeOne();
    }
    return 0;
}

void Recorder::setMeters(double l, double r, double lp, double rp)
{
    left->setValue(l, lp);
	QThread::postEvent(left, new QPaintEvent(left->rect(), false));
    right->setValue(r, rp);
	QThread::postEvent(right, new QPaintEvent(right->rect(), false));
}

void Recorder::RecordButton_clicked()
{
    StopButton->setLit(false);
    RecordButton->setLit(true);
    
    if(out_pipe[0] && BroadcastOn->isOn())
	data_thread->setOutput(out_pipe);
    else
	data_thread->setOutput(0);
    
    if(RecordOn->isOn())
    {
	if(config->getValue("RecordPipeline", "") != "")
	{
	    data_thread->setRecfile(0);
	    SaveTake->setEnabled(false);
	}
	else
	{
	    data_thread->setRecfile(config->getValue("RecordFile", "/record/sound.raw"));
	    if(config->getValue("RecordFile", "/record/sound.raw") != "")
		SaveTake->setEnabled(true);
	    else
		SaveTake->setEnabled(false);
	}
    }
    else
    {
	data_thread->setRecfile(0);
	SaveTake->setEnabled(false);
    }
    data_thread->setRecord(true);
}

void Recorder::StopButton_clicked()
{
    RecordButton->setLit(false);
    StopButton->setLit(true);
    
    data_thread->setRecord(false);
}


void Recorder::SaveTake_clicked()
{
    StopButton_clicked();
    QDate d=QDate::currentDate();
    QTime t=QTime::currentTime();
    
    QString destname;
    destname.sprintf("/record/%04d-%02d-%02d-%02d-%02d-%02d.raw",
		     d.year(),
		     d.month(),
		     d.day(),
		     t.hour(),
		     t.minute(),
		     t.second());
    QString mpname;
    mpname.sprintf("/record/%04d-%02d-%02d-%02d-%02d-%02d.mp3",
		     d.year(),
		     d.month(),
		     d.day(),
		     t.hour(),
		     t.minute(),
		     t.second());
    rename(config->getValue("RecordFile", "/record/sound.raw"), destname);
    
    if(QMessageBox::warning(this, "Convert", "Do you wish to convert this take to .mp3 format?", "Yes", "No", 0, 0, 1) == 1)
	return;
    Mp3Convert *mp=new Mp3Convert(destname, mpname);
    mp->start();
}


void Recorder::paintEvent( QPaintEvent *e )
{
    bitBlt(this, 0, 0, background);
}


void Recorder::meta_timeout()
{
    QString meta="";
    
    if(frame->metatracker->isMetadataActive(0))
	meta=frame->player(0)->get_source()->display_info();
    if(frame->metatracker->isMetadataActive(1))
	meta=frame->player(1)->get_source()->display_info();
 	if(frame->metatracker->getLockedText() != "")   
	meta=frame->metatracker->getLockedText();
    if(meta_pos >= (int)meta.length()-25)
	meta_pos=-5;
    
    if(meta_pos > 0)
	BroadcastData->setText(meta.mid(meta_pos));
    else
	BroadcastData->setText(meta);
    meta_pos++;
}


RingBuffer * Recorder::get_bc_buffer()
{
    return bc_buffer;
}


void Recorder::BcMonitor_toggled( bool on)
{
	BcMonitor->setLit(on);
    data_thread->setBcMonitor(on);
}
