#ifndef _RECDATA_H_INCLUDED
#define _RECDATA_H_INCLUDED

#include <qthread.h>
#include <stdio.h>

extern QWaitCondition rec_wait;

class Recorder;

class Recdata : public QThread
{
public:
	Recdata(Recorder *rec);
	~Recdata();

	void setRecord(bool on);
	void setOutput(const char *pipe);
	void setRecfile(const char *recfile);
	void setBcMonitor(bool on);
protected:
	bool s_bc_monitor;
	QMutex rec_lock;
	Recorder *rec;
	int fd;
	bool do_record;
	bool s_stop;
	char *s_pipe;
	char *s_recfile;
	FILE *s_pipe_fp;
	FILE *s_rec_fp;
protected slots:
	virtual void run();
};
#endif
