<?php
include_once('../../inc/config.php');
include_once(DCL_ROOT . 'login.php');

import('TreeMenu');
LoadStringResource('menu');
buildMenuArray();
renderDCLMenu();

function renderDCLMenu()
{
	global $dcl_info;

	$t = CreateTemplate(array('hForm' => 'tree.tpl'));

	$title = '[' . $GLOBALS['dcl_domain_info'][$GLOBALS['dcl_domain']]['name'] . ' / ' . $GLOBALS['DCLNAME'] . ']';
	if ($dcl_info['DCL_HTML_TITLE'] != '')
		$title .= '&nbsp;-&nbsp;' . $dcl_info['DCL_HTML_TITLE'];

	$t->set_var('VAL_TITLE', $title);

	$t->set_var('DIR_IMAGES', 'img');
	$t->set_var('DIR_CSS', 'css');
	$t->set_var('DIR_JS', DCL_WWW_ROOT . 'js');
	$t->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
	$t->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
	$t->set_var('VAL_TREE', getMenu());

	$t->pparse('out', 'hForm');
}

function getMenu()
{
	$mid = new TreeMenu();
	$mid->setMenuStructureString(getMenuString());
	$mid->parseStructureForMenu('treemenu1');
	return $mid->newTreeMenu('treemenu1');
}

function getMenuLink($link)
{
	if (!ereg('html$', $link) && !ereg('\.php$', $link))
		return menuLink(DCL_WWW_ROOT . 'main.php', 'menuAction=' . $link);
	elseif (substr($link, 0, 7) != 'http://')
		return menuLink(DCL_WWW_ROOT . $link);

	return $link;
}

function getMenuString()
{
	$sRetVal = '';

	foreach ($GLOBALS['DCL_MENU'] as $menuname => $themenu)
	{
		if (count($themenu) < 2)
			continue;

		if (count($themenu) < 3)
		{
			reset($themenu);
			list($link, $seclvl) = $themenu;
			if ($GLOBALS['SEC'] >= $seclvl)
			{
				$sRetVal .= '.|' . $menuname . '|' . getMenuLink($link) . "\n";
			}

			continue;
		}

		$sRetVal .= '.|' . $menuname . "\n";

		foreach ($themenu as $name => $item)
		{
			reset($item);
			list($link, $seclvl) = $item;
			if ($GLOBALS['SEC'] >= $seclvl)
			{
				$sRetVal .= '..|' . $name . '|' . getMenuLink($link) . "\n";
			}
		}
	}

	return $sRetVal;
}

?>
