CREATE SEQUENCE "seq_attributesets";
CREATE SEQUENCE "seq_views";
CREATE SEQUENCE "seq_tickets";
CREATE SEQUENCE "seq_ticketresolutions";
CREATE SEQUENCE "seq_faq";
CREATE SEQUENCE "seq_faqtopics";
CREATE SEQUENCE "seq_faqquestions";
CREATE SEQUENCE "seq_faqanswers";

CREATE TABLE "tickets" (
	"ticketid" int4 NOT NULL,
	"product" int4 NOT NULL,
	"account" int4,
	"createdby" int4 NOT NULL,
	"createdon" timestamp DEFAULT 'now()' NOT NULL,
	"responsible" int4 NOT NULL,
	"closedby" int4,
	"closedon" timestamp,
	"status" int4 NOT NULL,
	"statuson" timestamp NOT NULL,
	"lastactionon" timestamp,
	"priority" int4 NOT NULL,
	"type" int4 NOT NULL,
	"contact" varchar(80),
	"contactphone" varchar(20),
	"issue" text NOT NULL,
	"version" varchar(20),
	"summary" varchar(100),
	"seconds" int4 not null default '0',
	"contactemail" varchar(100),
	PRIMARY KEY ("ticketid")
);

CREATE TABLE "ticketresolutions" (
	"resid" int4 NOT NULL,
	"ticketid" int4 NOT NULL,
	"loggedby" int4 NOT NULL,
	"loggedon" timestamp DEFAULT 'now()' NOT NULL,
	"status" int4 NOT NULL,
	"resolution" text NOT NULL,
	"startedon" timestamp NOT NULL,
	PRIMARY KEY ("resid")
);

CREATE TABLE "faq" (
	"faqid" int4 NOT NULL,
	"name" varchar(80) NOT NULL,
	"createby" int4,
	"createon" timestamp DEFAULT 'now()' NOT NULL,
	"modifyby" int4,
	"modifyon" timestamp,
	"active" char(1) DEFAULT 'Y' NOT NULL,
	"description" text,
	PRIMARY KEY ("faqid")
);

CREATE TABLE "faqtopics" (
	"topicid" int4 NOT NULL,
	"seq" int4 NOT NULL,
	"faqid" int4 NOT NULL,
	"name" varchar(80) NOT NULL,
	"description" text NOT NULL,
	"createby" int4,
	"createon" timestamp DEFAULT 'now()' NOT NULL,
	"modifyby" int4,
	"modifyon" timestamp,
	"active" char(1) DEFAULT 'Y' NOT NULL,
	PRIMARY KEY ("topicid")
);

CREATE TABLE "faqquestions" (
	"questionid" int4 NOT NULL,
	"seq" int4 NOT NULL,
	"topicid" int4 NOT NULL,
	"questiontext" text NOT NULL,
	"createby" int4,
	"createon" timestamp DEFAULT 'now()' NOT NULL,
	"modifyby" int4,
	"modifyon" timestamp,
	"active" char(1) DEFAULT 'Y' NOT NULL,
	PRIMARY KEY ("questionid")
);

CREATE TABLE "faqanswers" (
	"answerid" int4 NOT NULL,
	"questionid" int4 NOT NULL,
	"answertext" text NOT NULL,
	"createby" int4 NOT NULL,
	"createon" timestamp DEFAULT 'now()' NOT NULL,
	"modifyby" int4,
	"modifyon" timestamp,
	"active" char(1) DEFAULT 'Y' NOT NULL,
	PRIMARY KEY ("answerid")
);

alter table products add column ticketsto int4 not null;
update products set ticketsto=reportto;

alter table projects add column parentprojectid int4 default('0') not null;
update projects set parentprojectid=0;

CREATE TABLE "views" (
	"viewid" int4 NOT NULL,
	"whoid" int4 NOT NULL,
	"name" varchar(100) NOT NULL,
	"ispublic" char(1) DEFAULT 'N' NOT NULL,
	"viewurl" text NOT NULL,
	"tablename" varchar(30) not null,
	PRIMARY KEY("viewid")
);


CREATE TABLE "attributesets" (
	"id" int4 NOT NULL,
	"short" varchar(20) NOT NULL,
	"name" varchar(100) NOT NULL,
	"active" char(1) NOT NULL DEFAULT 'Y'
);

INSERT INTO attributesets(id,short,name,active) VALUES (nextval('seq_attributesets'), 'WO', 'Work Orders', 'Y');
INSERT INTO attributesets(id,short,name,active) VALUES (nextval('seq_attributesets'), 'TCK', 'Tickets', 'Y');

CREATE TABLE "attributesetsmap" (
	"setid" int4 NOT NULL,
	"typeid" int4 NOT NULL,
	"keyid" int4 NOT NULL,
	"weight" int4 NOT NULL
);

INSERT INTO attributesetsmap SELECT 1, 1, id, 1 FROM actions;
INSERT INTO attributesetsmap SELECT 1, 2, id, weight FROM priorities;
INSERT INTO attributesetsmap SELECT 1, 3, id, weight FROM severities;
INSERT INTO attributesetsmap SELECT 1, 4, id, 1 FROM statuses;

INSERT INTO attributesetsmap SELECT 2, 1, id, 1 FROM actions;
INSERT INTO attributesetsmap SELECT 2, 2, id, weight FROM priorities;
INSERT INTO attributesetsmap SELECT 2, 3, id, weight FROM severities;
INSERT INTO attributesetsmap SELECT 2, 4, id, 1 FROM statuses;

alter table products add column wosetid int4 not null default '0';
alter table products add column tcksetid int4 not null default '0';

update products set wosetid=1;
update products set tcksetid=2;
