<?php
/*
 * $Id: functions.inc.php,v 1.7.2.3.2.30 2004/01/01 18:18:16 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

// Common definitions
define('phpCrLf', "\r\n");
define('phpTab', "\t");

// Modes
define('DCL_MODE_NEW', 1);
define('DCL_MODE_EDIT', 2);
define('DCL_MODE_COPY', 3);

// Entities
define('DCL_ENTITY_GLOBAL', 0);
define('DCL_ENTITY_PROJECT', 1);
define('DCL_ENTITY_WORKORDER', 2);
define('DCL_ENTITY_TICKET', 3);
define('DCL_ENTITY_PRODUCT', 4);
define('DCL_ENTITY_ACCOUNT', 5);

// Embedded state
define('DCL_STANDALONE', 0);
define('DCL_PHPGW', 1);
define('DCL_XOOPS', 2);

function menuLink($target = '', $params = '')
{
	global $phpgw;

	if (DCL_EMBEDDED_STATE == DCL_PHPGW)
	{
		// In phpGW, this must be installed under /dcl
		if ($target == '')
			$target = '/dcl/main.php';

		return $phpgw->link($target, $params);
	}

	if ($target == '')
		$target = DCL_WWW_ROOT . 'main.php';

	if (substr($target, 0, strlen(DCL_WWW_ROOT)) == DCL_WWW_ROOT)
		$sRet = substr($target, DCL_WWW_ROOT);
	else
		$sRet = $target;

	if ($params != '')
		$sRet .= '?' . $params;

	return $sRet;
}

function GetSourceArray()
{
	if ($GLOBALS['HTTP_SERVER_VARS']['REQUEST_METHOD'] == 'GET')
		return 'HTTP_GET_VARS';

	return 'HTTP_POST_VARS';
}

function GPCStripSlashes($thisString)
{
	if (get_magic_quotes_gpc() == 0)
		return $thisString;

	return stripslashes($thisString);
}

function CleanVars($which)
{
	if (get_magic_quotes_gpc() == 0)
		return;

	reset($GLOBALS[$which]);
	while (list($k, $v) = each($GLOBALS[$which]))
		$GLOBALS[$which][$k] = GPCStripSlashes($GLOBALS[$which][$k]);
}

function RenderSepMenu($aMenu)
{
	reset($aMenu);
	$bNeedEnd = false;
	$bNeedStart = true;
	while (list($sText, $sLink) = each($aMenu))
	{
		if ($bNeedStart)
		{
			$bNeedStart = false;
			$bNeedEnd = true;
			echo '[';
		}
		else
			echo '&nbsp|';

		echo '&nbsp;<a class="adark" href="' . $sLink . '">' . $sText . '</a>';
	}

	if ($bNeedEnd)
		echo '&nbsp;]';
}

function GetPrefLang()
{
	global $dcl_info, $g_oSession;

	// TODO: Allow browser override and check if locale available, if so configured
	$lang = '';
	if (is_object($g_oSession))
	{
		$oPrefs = CreateObject('dcl.dbPreferences');
		$oPrefs->preferences_data = $g_oSession->Value('dcl_preferences');

		$lang = $oPrefs->Value('DCL_PREF_LANGUAGE');
	}

	if ($lang == '')
	{
		if (isset($dcl_info) && is_array($dcl_info) && isset($dcl_info['DCL_DEFAULT_LANGUAGE']))
			$lang = $dcl_info['DCL_DEFAULT_LANGUAGE'];
		else
			$lang = 'en';
	}

	return $lang;
}

function LoadStringResource($name)
{
	if (!IsSet($GLOBALS['STR_' . $name . '_INCLUDED']))
	{
		$GLOBALS['STR_' . $name . '_INCLUDED'] = 1;
		include(sprintf(DCL_ROOT . 'str/%s/%s.str', GetPrefLang(), $name));
	}
}

function LoadSchema($sTableName)
{
	$sConst = sprintf('SCHEMA_%s_INCLUDED', $sTableName);
	if (!defined($sConst))
	{
		if (!isset($GLOBALS['phpgw_baseline']) || !is_array($GLOBALS['phpgw_baseline']))
			$GLOBALS['phpgw_baseline'] = array();

		define($sConst, 1);
		include(sprintf(DCL_ROOT . 'schema/schema.%s.php', $sTableName));
	}
}

function Invoke($sClassMethod)
{
	list($class, $method) = explode(".", $sClassMethod);
	import($class);
	if (!class_exists($class))
	{
		print('Invoke could not find class: ' . htmlspecialchars($class));
		return;
	}

	$obj = new $class;
	if (!method_exists($obj, $method))
	{
		print('Class ' . htmlspecialchars($class) . ' does not contain a definition for method ' . htmlspecialchars($method));
		return;
	}
																
	$obj->$method();
}

function EvaluateReturnTo()
{
	// Always check the return value of this function to see if processing should continue
	// or the method should be invoked
	if (IsSet($GLOBALS['return_to']))
	{
		$GLOBALS['menuAction'] = $GLOBALS['return_to'];
		if ($GLOBALS['g_oSec']->ValidateMenuAction() == true)
		{
			Invoke($GLOBALS['menuAction']);

			return true;
		}
	}

	return false;
}

function import($className)
{
	if (!file_exists(DCL_ROOT . 'inc/class.' . $className . '.inc.php'))
	{
		print('Class not found: ' . htmlspecialchars($className));
		return;
	}

	include_once(DCL_ROOT . 'inc/class.' . $className . '.inc.php');
}

function &CreateViewObject($sType = '')
{
	switch ($sType)
	{
		case 'workorders':
			return CreateObject('dcl.htmlWorkOrderResults');
		case 'tickets':
			return CreateObject('dcl.htmlTicketResults');
		case 'dcl_product_module':
			return CreateObject('dcl.htmlProductModuleView');
		default:
			return CreateObject('dcl.htmlView');
	}
}

if (!function_exists('CreateObject'))
{
	function &CreateObject($className)
	{
		$className = substr($className, 4);

		import($className);

		$obj = new $className;

		return $obj;
	}
}

function &GetAuthenticator()
{
	if (DCL_EMBEDDED_STATE == DCL_PHPGW)
		return CreateObject('dcl.boAuthenticatePHPGW');
	
	if (DCL_EMBEDDED_STATE == DCL_XOOPS)
		return CreateObject('dcl.boAuthenticateXOOPS');
		
	return CreateObject('dcl.boAuthenticate');
}

function &GetPageObject()
{
	if (DCL_EMBEDDED_STATE == DCL_PHPGW)
		return CreateObject('dcl.PagePHPGW');
	
	if (DCL_EMBEDDED_STATE == DCL_XOOPS)
		return CreateObject('dcl.PageXOOPS');
		
	return CreateObject('dcl.Page');
}

function GetDefaultTemplateSet()
{
	// Session must be initialized before calling this!
	global $g_oSession, $dcl_info;

	$o = CreateObject('dcl.dbPreferences');
	$o->preferences_data = $g_oSession->Value('dcl_preferences');

	if ($o->Value('DCL_PREF_TEMPLATE_SET') != '')
		return $o->Value('DCL_PREF_TEMPLATE_SET');

	return $dcl_info['DCL_DEF_TEMPLATE_SET'];
}

function CreateTemplate($arrTemplate)
{
	global $dcl_info, $phpgw;

	// Create a template object and hook it up to the template in the
	// configured template set
	$Template = CreateObject('dcl.DCLTemplate');
	$Template->set_root(DCL_ROOT . 'templates/' . GetDefaultTemplateSet());
	$Template->set_file($arrTemplate);

	return $Template;
}

function RefreshTop($sRefreshTo)
{
	$t = CreateTemplate(array('hForm' => 'refreshTop.tpl'));
	$t->set_var('LNK_REFRESH', $sRefreshTo);
	$t->pparse('out', 'hForm');
	exit();
}

function GetHiddenVar($var, $val)
{
	return '<input type="hidden" name="' . $var . '" value="' . $val . '">';
}

if (!function_exists('str_repeat'))
{
	// PHP3 compatibility for PHP4 function
	function str_repeat($sString, $iRepeat)
	{
		if ($iRepeat < 1)
			return '';

		if ($iRepeat == 1)
			return $sString;

		// Try to be time effecient by doubling up string
		// then looping it for half the time
		$sRpt = $sString . $sString;
		$iRpt = floor($iRepeat / 2);
		$bExtra = ($iRepeat % 2 != 0);
		$sRet = '';

		for ($i = 0; $i < $iRpt; $i++)
			$sRet .= $sRpt;

		if ($bExtra)
			$sRet .= $sString;

		return $sRet;
	}
}

if (!function_exists('in_array'))
{
	// PHP3 compatibility for PHP4 function
	function in_array($sValue, &$aArray)
	{
		$bFound = false;
		if (is_array($aArray))
		{
			for ($i = 0; $i < count($aArray) && !$bFound; $i++)
				$bFound = ($aArray[$i] == $sValue);
		}

		return $bFound;
	}
}

if (!function_exists('array_keys'))
{
	// PHP3 compatibility for PHP4 function
	function array_keys(&$input, $vValue = '')
	{
		if ($vValue != '' && !is_array($vValue))
			$vValue = array($vValue);

		$keys = array();
		while (list($key, ) = each($input))
		{
			if ($vValue == '' || in_array($key, $vValue))
				$keys[] = $key;
		}

		return $keys;
	}
}

if (!function_exists('array_key_exists'))
{
	// PHP < 4.1.0 compatibility
	function array_key_exists($key, $search)
	{
		return in_array($key, array_keys($search));
	}
}

if (!function_exists('array_reverse'))
{
	// PHP3 compatibility for PHP4 function
	function array_reverse(&$input, $bPreserveKeys = false)
	{
		$newArray = array();
		if (!is_array($input) || count($input) == 0)
		{
			$input = array();
			return $newArray;
		}

		end($input);
		do
		{
			if ($bPreserveKeys)
				$newArray[key($input)] = current($input);
			else
				$newArray[] = current($input);
		}
		while (prev($input));

		$input = $newArray;

		return $newArray;
	}
}

function array_remove_keys(&$aArray, $vKeys)
{
	if (!is_array($vKeys))
	{
		if (isset($aArray[$vKeys]))
			unset($aArray[$vKeys]);
	}
	else
	{
		reset($vKeys);
		while (list($key, ) = each($vKeys))
		{
			if (isset($aArray[$key]))
				unset($aArray[$key]);
		}
	}
}

function GetHelpLink($dark = false)
{
	global $dcl_info;

	$linkText = '?';

	$linkClass = $dark == true ? 'adark' : 'alight';

	return sprintf('[&nbsp;<a class="%s" href="#" onClick="javascript:window.open(\'./str/%s/help/%s.php\', \'dclhelp\', \'width=400,height=400,resizable=yes,scrollbars=yes\');">%s</a>&nbsp;]',
		$linkClass,
		$dcl_info['DCL_DEFAULT_LANGUAGE'],
		$GLOBALS['menuAction'],
		$linkText);
}

function GetJSDateFormat()
{
	global $dcl_info;

	$calDateFormat = str_replace('m', 'mm', $dcl_info['DCL_DATE_FORMAT']);
	$calDateFormat = str_replace('d', 'dd', $calDateFormat);
	return str_replace('Y', 'y', $calDateFormat);
}

function IncludeCalendar()
{
	if (IsSet($GLOBALS['DCL_CALENDAR_INCLUDED']))
		return;

	$GLOBALS['DCL_CALENDAR_INCLUDED'] = 1;

	$t = CreateTemplate(array('hForm' => 'htmlCalendar.tpl'));

	$calDateFormat = str_replace('mm', '%m', GetJSDateFormat());
	$calDateFormat = str_replace('dd', '%d', $calDateFormat);
	$calDateFormat = str_replace('y', '%Y', $calDateFormat);

	$t->set_var('VAL_JSDATEFORMAT', $calDateFormat);
	$t->pparse('out', 'hForm');
}

function buildMenuArray()
{
	global $dcl_info, $DCL_MENU;

	// Is DCL contained in another app?
	$bContained = (DCL_EMBEDDED_STATE != DCL_STANDALONE);

	// TODO: remove after implementing module enable/disable
	$dcl_info['DCL_MODULE_WO_ENABLED'] = true;
	$dcl_info['DCL_MODULE_PROJECTS_ENABLED'] = true;
	$dcl_info['DCL_MODULE_TICKETS_ENABLED'] = true;

	$DCL_MENU = array();
	if (!$bContained)
		$DCL_MENU[DCL_MENU_HOME] = array('htmlMyDCL.show', 0);

	if ($dcl_info['DCL_MODULE_WO_ENABLED'])
	{
		$DCL_MENU[DCL_MENU_WORKORDERS] = array(
				DCL_MENU_MYWOS => array('htmlWorkorders.show&filterReportto=' . $GLOBALS['DCLID'], 0),
				DCL_MENU_NEW => array('boWorkorders.newjcn', $dcl_info['DCL_ADD_WO']),
				DCL_MENU_IMPORT => array('boWorkorders.csvupload', $dcl_info['DCL_ADD_WO']),
				DCL_MENU_ACTIVITY => array('reportPersonnelActivity.getparameters', 0),
				DCL_MENU_GRAPH => array('boWorkorders.graph', 0),
				DCL_MENU_STATISTICS => array('htmlWOStatistics.ShowUserVsProductStatusForm', 0),
				DCL_MENU_SCHEDULE => array('scheduleByPerson.SelectPersonToSchedule', $dcl_info['DCL_ASSIGN_WO']),
				DCL_MENU_SEARCH => array('htmlWOSearches.Show', 0),
				DCL_MENU_BROWSE => array('htmlWorkorders.show', 0)
			);
	}

	if ($dcl_info['DCL_MODULE_PROJECTS_ENABLED'])
	{
		$DCL_MENU[DCL_MENU_PROJECTS] = array(
				DCL_MENU_MYPROJECTS => array('htmlProjects.show&filterReportto=' . $GLOBALS['DCLID'], 0),
				DCL_MENU_NEW => array('boProjects.newproject', $dcl_info['DCL_ASSIGN_WO']),
				DCL_MENU_VIEW => array('htmlProjects.show', 0)
			);
	}

	if ($dcl_info['DCL_MODULE_TICKETS_ENABLED'])
	{
		$DCL_MENU[DCL_MENU_TICKETS] = array(
				DCL_MENU_MYTICKETS => array('htmlTickets.show&filterReportto=' . $GLOBALS['DCLID'], 0),
				DCL_MENU_NEW => array('boTickets.add', $dcl_info['DCL_ADD_WO']),
				DCL_MENU_ACTIVITY => array('reportTicketActivity.getparameters', 0),
				DCL_MENU_GRAPH => array('boTickets.graph', 0),
				DCL_MENU_STATISTICS => array('htmlTicketStatistics.ShowUserVsProductStatusForm', 0),
				DCL_MENU_SEARCH => array('htmlTicketSearches.Show', 0),
				DCL_MENU_BROWSE => array('htmlTickets.show', 0)
			);
	}

	$DCL_MENU[DCL_MENU_ADMIN] = array(
			DCL_MENU_CHANGEPASSWORD => array('boPersonnel.passwd', $dcl_info['DCL_CHG_PWD']),
			DCL_MENU_PREFERENCES => array('htmlPreferences.modify', 0),
			DCL_MENU_SYSTEMSETUP => array('boAdmin.ShowSystemConfig', $dcl_info['DCL_ADD_USER']),
			DCL_MENU_NEWACCOUNT => array('boAccounts.add', $dcl_info['DCL_ADD_USER']),
			DCL_MENU_VIEWACCOUNT => array('boAccounts.search', 0),
			DCL_MENU_CHECKLISTS => array('boChecklists.show', 0),
			DCL_MENU_PRODUCTS => array('boProducts.showall', 0),
			DCL_MENU_VIEWS => array('htmlViews.PrintAll', 0),
			DCL_MENU_WATCHES => array('boWatches.showall', 0),
			DCL_MENU_AGGREGATESTATS => array('htmlAgg.Init', 0),
			DCL_MENU_MAINWIKI => array('htmlWiki.show&name=FrontPage&type=0', $dcl_info['DCL_WIKI_VIEW']),
			DCL_MENU_SESSIONS => array('htmlSession.Show', $dcl_info['DCL_ADD_USER'])
		);

	if ($dcl_info['DCL_WIKI_ENABLED'] != 'Y' && isset($DCL_MENU[DCL_MENU_ADMIN][DCL_MENU_MAINWIKI]))
		unset($DCL_MENU[DCL_MENU_ADMIN][DCL_MENU_MAINWIKI]);

	$DCL_MENU[DCL_MENU_HELP] = array(
			DCL_MENU_FAQS => array('boFaq.ShowAll', 0),
			DCL_MENU_CLEARSCREEN => array('clearScreen', 0),
			DCL_MENU_DCLHOMEPAGE => array('http://dcl.sourceforge.net/index.php', 0),
			DCL_MENU_LICENSEINFO => array('gpl.php', 0),
			DCL_MENU_VERSIONINFO => array('htmlVersion.DisplayVersionInfo', 0)
		);

	if (!$bContained)
		$DCL_MENU[DCL_MENU_LOGOFF] = array('logout.php', 0);
}

function GetCharSet()
{
	$lang = GetPrefLang();
	switch ($lang)
	{
		case 'ru':
			return 'koi8-r';
		default:
			return 'iso-8859-1';
	}
}

function commonHeader($formValidateSrc = '', $onLoad = '')
{
	if (IsSet($GLOBALS['HTML_HEADER_GENERATED']))
		return;

	global $phpgw, $dcl_info;
	$GLOBALS['HTML_HEADER_GENERATED'] = 1;

	$title = '[' . $GLOBALS['dcl_domain_info'][$GLOBALS['dcl_domain']]['name'] . ' / ' . $GLOBALS['DCLNAME'] . ']';
	if ($dcl_info['DCL_HTML_TITLE'] != '')
		$title .= '&nbsp;-&nbsp;' . $dcl_info['DCL_HTML_TITLE'];

	LoadStringResource('menu');
	buildMenuArray();

	if (!empty($_SERVER))
		extract($_SERVER);
	else if (!empty($GLOBALS['HTTP_SERVER_VARS']))
		extract($GLOBALS['HTTP_SERVER_VARS']);

	if (DCL_EMBEDDED_STATE == DCL_PHPGW)
		$t = CreateTemplate(array('hForm' => 'contained.tpl'));
	else if (DCL_EMBEDDED_STATE == DCL_XOOPS)
		$t = CreateTemplate(array('hForm' => 'xoops.tpl'));
	else
		$t = CreateTemplate(array('hForm' => 'index.tpl'));

	$sTemplateSet = GetDefaultTemplateSet();
	
	$t->set_var('VAL_TITLE', $title);
	$t->set_var('DIR_IMAGES', 'templates/' . $sTemplateSet . '/img');
	$t->set_var('DIR_CSS', 'templates/' . $sTemplateSet . '/css');
	$t->set_var('DIR_JS', 'templates/' . $sTemplateSet . '/js');
	$t->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
	$t->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
	$t->set_var('CHARSET', GetCharSet());
	$t->pparse('out', 'hForm');

	if (file_exists('templates/' . $sTemplateSet . '/menu.php'))
	{
		include('templates/' . $sTemplateSet . '/menu.php');
		renderDCLMenu();
	}
}

function commonFooter()
{
	if (DCL_EMBEDDED_STATE == DCL_XOOPS)
	{
		include(XOOPS_ROOT_PATH . '/footer.php');
	}
	else if (DCL_EMBEDDED_STATE == DCL_STANDALONE)
	{
		$t = CreateTemplate(array('hForm' => 'footer.tpl'));
		$t->pparse('out', 'hForm');
	}
}

function PrintLink($linkName, $rollover, $linkURL, $dark = false, $printable = false)
{
	$class = $dark == false ? 'alight' : 'adark';
	print("<a class=\"$class\" href=\"$linkURL\" title=\"$rollover\">" ); 
	print($linkName) ;
	print('</a>&nbsp;');
}

function PrintLinkSet($linkArray, $rolloverArray, $enclose = true, $dark = false, $printable = false)
{
	print(GetLinkSet($linkArray, $rolloverArray, $enclose, $dark, $printable));
}

function GetLink($linkName, $rollover, $linkURL, $dark = false, $printable = false)
{
	$class = $dark == false ? 'alight' : 'adark';
	$link = "<a class=\"$class\" href=\"$linkURL\"";
	if ($rollover != '')
		$link .= " title=\"$rollover\"";
	$link .= '>' . $linkName . '</a>&nbsp;';

	return $link;
}

function GetLinkSet($linkArray, $rolloverArray, $enclose = true, $dark = false, $printable = false)
{
	global $dcl_info;

	if (!is_array($linkArray) || !is_array($rolloverArray) || count($linkArray) < 1)
	{
		// Output _something_ in case we need to allow a TD or TH to background
		// fill properly.
		return '&nbsp';
	}

	$linkset = '';
	if ($enclose)
		$linkset .= '<font color="' . $dcl_info['DCL_COLOR_LIGHT'] . '">[</font>&nbsp;';

	while (list($linkName, $linkURL) = each($linkArray))
		$linkset .= GetLink($linkName, $rolloverArray[$linkName], $linkURL, $dark, $printable);

	if ($enclose)
		$linkset .= '<font color="' . $dcl_info['DCL_COLOR_LIGHT'] . '">]</font>';

	return $linkset;
}

function PrintWithChocoFont($thisString, $printable = false)
{
	print("<span class=\"highlight\">$thisString</span>");
}

function PrintArrayAsChocoTable($nameArray, $fieldArray, $title, $footer = '', $titleLinks = '', $printable=false, $groupBy = -1, $bGroupLastRow = true, $iSubtotalColumn = -1, $sSubTotalFmt = '')
{
	global $dcl_info;

	$bGrouping = ($groupBy != -1);
	print('<table border="0" cellspacing="0">');
	print('<tr><th class="detailTitle">');
	print($title);

	if ($titleLinks != '')
		print('</th><th class="detailLinks">&nbsp;&nbsp;&nbsp;</th><th class="detailLinks">' . $titleLinks);

	print('</th></tr>');

	print('<tr><td');
	if ($titleLinks != '')
		print(' colspan="3"');

	print('><table style="border: 0px none; width: 100%;">');

	if (count($nameArray) < 1 || count($fieldArray) < 1 || !is_array($nameArray) || !is_array($fieldArray))
	{
		print('<tr><td>');
		PrintWithChocoFont(STR_CMMN_ARRAYTABLEERR);
		print('</td></tr><tr><td>');
		printf(STR_CMMN_ARRAYTABLEERRHELP, $title);
		print('</td></tr></table></center>');
		return;
	}

	print('<tr>');
	for ($i = 0; $i < count($nameArray); $i++)
	{
		if ($bGrouping && $i == $groupBy)
			continue;

		echo '<th style="border-bottom: solid black 2px">', $nameArray[$i], '</th>';
	}
	print('</tr>');

	$lastGroup = '<< undefined >>';
	for ($i = 0; $i < count($fieldArray); $i++)
	{
		if ($bGrouping && $lastGroup != $fieldArray[$i][$groupBy] && ($bGroupLastRow || (!$bGroupLastRow && $i < (count($fieldArray) - 1))))
		{
			// Get item count
			$iItems = 0;
			$iSub = 0;
			for ($x = $i; $x < count($fieldArray) && ($fieldArray[$i][$groupBy] == $fieldArray[$x][$groupBy]) && ($bGroupLastRow || (!$bGroupLastRow && $x < (count($fieldArray) - 1))); $x++)
			{
				if ($iSubtotalColumn > -1)
					$iSub += $fieldArray[$x][$iSubtotalColumn];

				$iItems++;
			}

			print('<tr><th colspan="' . (count($fieldArray[$i]) - 1) . '" style="background-color: #cecece; text-align: left;">');
			print($fieldArray[$i][$groupBy]) . '&nbsp;(' . $iItems . ')&nbsp;';
			if ($iSubtotalColumn > -1)
				printf($sSubTotalFmt, $iSub);

			print('</th></tr>');
			$lastGroup = $fieldArray[$i][$groupBy];
		}

		print('<tr>');
		for ($j = 0; $j < count($fieldArray[$i]); $j++)
		{
			if ($bGrouping && $j == $groupBy)
				continue;

			$k = $fieldArray[$i][$j];
			if (trim($k) == '')
				$k = '&nbsp;';

			$align = '';
               // Right justify all numbers (looks really swell)
			if (is_double($k) || is_long($k))
				$align = 'right';

			echo '<td style="';

			if (!$bGroupLastRow && $i == (count($fieldArray) - 1))
			{
				echo ' background-color: #ffffff; border-top: solid black 2px;';
			}
			else
			{
				if ($i % 2 == 0)
					echo 'background-color: ', $dcl_info['DCL_COLOR_LIGHT'], ';';
				else
					echo 'background-color: #ffffff;';
			}

			if ($align != '')
				echo '" align="', $align;

			echo '">';

			echo $k, '</td>';
		}
		print('</tr>');
	}
	if ($footer != '')
	{
		print('<tr><th>');
		print($footer);
		print('</th></tr>');
	}
	print('</table></td></tr></table>');
}

function ExportArray(&$aFieldNames, &$aData, $filename = 'dclexport.txt')
{
	// Silent function to export tab delimited file and force browser to
	// force the user to save the file.
	$hdr =  'Content-Type: application/binary; name=dclexport.txt' . phpCrLf;
	$hdr .= 'Content-Disposition: attachment; filename=dclexport.txt' . phpCrLf . phpCrLf;
	header($hdr);

	// Make object, run query, and (for now) blindly dump data.  The first
	// record will contain column headings.  Any tabs within data will be replaced
	// by spaces since our fields our tab delimited.
	$record = '';
	if (count($aFieldNames) > 0)
	{
		while (list($key, $val) = each($aFieldNames))
		{
			$val = str_replace(phpTab, ' ', $val);
			if ($record != '')
				$record .= phpTab;

			$record .= $val;
		}
	}

	// Output field headings
	echo $record . phpCrLf;

	// Now for the records
	for ($i = 0; $i < count($aData); $i++)
	{
		$record = '';
		for ($j = 0; $j < count($aData[$i]); $j++)
		{
			if ($j > 0)
				$record .= phpTab;

			$record .= str_replace(phpTab, ' ', $aData[$i][$j]);
		}

		echo $record . phpCrLf;
	}

	exit; // Don't output footer
}

function FormatPhone($phone)
{
	$retVal = trim($phone);
	if (strlen($retVal) == 7)
	{
		$retVal = substr($phone, 0, 3) . '-' . substr($phone, 3);
	}
	if (strlen($retVal) == 10)
	{
		$retVal = '(' . substr($phone, 0, 3) . ') ' . substr($phone, 3, 3) . '-' . substr($phone, 6);
	}

	return $retVal;
}

// FIXME: only left in htmlChecklistForm
function GetCalendarLink($linkTo)
{
	// Should have called IncludeCalendar() before this code goes out
	$link = '<a href="javascript:doNothing()" ';
	$link .= 'onclick="showCalendar(\'' . $linkTo . '\');">';
	$link .= '<img src="img/calendar.gif" border="0"></a>';

	return $link;
}

function CreateLinkedText($sText)
{
	// Regular stuff
	$sRetVal = eregi_replace('(http|ftp|telnet|irc|https)://[^<>[:space:]]+[[:alnum:]/]', '<a target="_blank" class="adark" href="\0">\0</a>', $sText);

	// Pseudo stuff
	$sRetVal = eregi_replace('dcl://workorders/([0-9]+)[-]([0-9]+)', '<a class="adark" href="main.php?menuAction=boWorkorders.viewjcn&jcn=\1&seq=\2">\0</a>', $sRetVal);
	$sRetVal = eregi_replace('dcl://tickets/([0-9]+)', '<a class="adark" href="main.php?menuAction=boTickets.view&ticketid=\1">\0</a>', $sRetVal);
	$sRetVal = eregi_replace('dcl://projects/([0-9]+)', '<a class="adark" href="main.php?menuAction=boProjects.viewproject&wostatus=0&project=\1">\0</a>', $sRetVal);

	return $sRetVal;
}

function ShowDeleteYesNo($title, $action, $id, $name, $canBeDeactivated = true, $idfield = 'id')
{
	global $dcl_info;

	$t = CreateTemplate(array('hForm' => 'htmlDeleteItem.tpl'));

	$t->set_var('TXT_TITLE', sprintf(STR_CMMN_DELETEITEM, $title));
	$t->set_var('TXT_YES', STR_CMMN_YES);
	$t->set_var('TXT_NO', STR_CMMN_NO);
	if ($canBeDeactivated)
		$t->set_var('TXT_DEACTIVATENOTE', STR_CMMN_DEACTIVATENOTE);
	else
		$t->set_var('TXT_DEACTIVATENOTE', '');

	$t->set_var('VAL_ACTION', menuLink());
	$t->set_var('VAL_MENUACTION', $action);
	$t->set_var('VAL_IDFIELD', $idfield);
	$t->set_var('VAL_ID', $id);
	$t->set_var('VAL_NAME', $name);
	$t->set_var('VAL_WARNING', sprintf(STR_CMMN_DELETECONFIRM, $title, $name));

	$t->pparse('out', 'hForm');
}

function GetYesNoCombo($default = 'Y', $cbName = 'active', $size = 0, $noneOption = true)
{
	$str = "<select name=\"$cbName";
	if ($size > 0)
		$str .= '[]" multiple size=' . $size;
	else
		$str .= '"';
	$str .= '>';
	if ($size == 0 && $noneOption == true)
		$str .= sprintf('<option value="?">%s', STR_CMMN_SELECTONE);

	$str .= '<option value="Y"';
	if ('Y' == $default)
		$str .= ' selected';
	$str .= sprintf('>%s</option>', STR_CMMN_YES);

	$str .= '<option value="N"';
	if ('N' == $default)
		$str .= ' selected';
	$str .= sprintf('>%s</option>', STR_CMMN_NO);

	$str .= '</select>';

	return $str;
}

function CreateYesNoCombo($default = 'Y', $cbName = 'active', $size = 0, $noneOption = true)
{
	print GetYesNoCombo($default, $cbName, $size, $noneOption);
}

function PrintPermissionDenied()
{
	echo '<center><h3><font color="red">' . STR_CMMN_PERMISSIONDENIED . '</font></h3></center>';
}
?>
