#
# rpm spec-file for cryptmount
# Copyright 2006-2009, Holger Mueller & RW Penney
#
Summary:	Let ordinary users mount an encrypted file system
Name:		cryptmount
Version: 	4.0.2
Release:	1
License:	GPL
URL:		http://cryptmount.sourceforge.net
Group:		Applications/System
Source0:	%{name}-%{version}.tar.gz
BuildRequires:  libgcrypt-devel 
Requires:	libgcrypt device-mapper
BuildRoot:	%{_tmppath}/%{name}-%{version}-root

%description
cryptmount is a utility for the GNU/Linux operating system which allows
an ordinary user to mount an encrypted filing system without requiring
superuser privileges. Filesystems can reside on raw disk partitions or
ordinary files, with cryptmount automatically configuring 
device-mapper and loopback devices before mounting.


%prep
%setup -n %{name}-%{version}
%{__perl} -pi.orig -e '
	s|^(\s*)chown(\s*root)|\1#chown\2|g;
	s|/etc/init.d|%{_initrddir}|g;
    ' Makefile.am Makefile.in


%build
%configure --enable-delegation --enable-fsck
%{__make} %{?_smp_mflags}


%install
%{__rm} -rf %{buildroot}
%{__install} -d -m0755 %{buildroot}%{_initrddir}
%{__install} -d -m0755 %{buildroot}%{_sbindir}
%{__install} -d -m0755 %{buildroot}%{_sysconfdir}/default/
%{__make} DESTDIR=%{buildroot} install
%find_lang %{name}


%clean
%{__rm} -rf %{buildroot}


%files -f %{name}.lang
%defattr(-, root, root, 0755)
%doc AUTHORS ChangeLog COPYING NEWS README* RELNOTES ToDo
%doc %{_mandir}/man5/cmtab.5*
%doc %{_mandir}/man8/cryptmount*.8*
%doc %{_mandir}/*/man5/cmtab.5*
%doc %{_mandir}/*/man8/cryptmount*.8*
%config(noreplace) %{_sysconfdir}/cryptmount/
%config %{_initrddir}/cryptmount
%config %{_initrddir}/cryptmount-early
%config %{_sysconfdir}/default/
%{_sbindir}/cryptmount-setup
%{_libdir}/cryptmount/

%attr(4751, root, root) %{_bindir}/cryptmount


%post
#/sbin/chkconfig --level S cryptmount-early on
/sbin/chkconfig --add cryptmount

%preun
if [ "$1" = 0 ]; then
    /sbin/chkconfig --del cryptmount
    #/sbin/chkconfig --del cryptmount-early
fi


%changelog
* Mon Jan 05 2009 RW Penney <cryptmount@rwpenney.org.uk> - 4.0
* Thu Jun 19 2008 RW Penney <cryptmount@rwpenney.org.uk> - 3.1
* Sun May 11 2008 RW Penney <cryptmount@rwpenney.org.uk> - 3.0
* Sun Dec 09 2007 RW Penney <cryptmount@rwpenney.org.uk> - 2.2
* Fri Jul 20 2007 RW Penney <cryptmount@rwpenney.org.uk> - 2.1
* Sat Apr 07 2007 RW Penney <cryptmount@rwpenney.org.uk> - 2.0
* Sun Oct 15 2006 RW Penney <cryptmount@rwpenney.org.uk> - 1.2
* Sun Jul 16 2006 RW Penney <cryptmount@rwpenney.org.uk> - 1.1
* Mon May 29 2006 RW Penney <cryptmount@rwpenney.org.uk> - 1.0
* Sat Apr 07 2006 RW Penney <cryptmount@rwpenney.org.uk> - 0.4
* Sun Mar 05 2006 RW Penney <cryptmount@rwpenney.org.uk> - 0.3
* Sun Jan 22 2006 RW Penney <cryptmount@rwpenney.org.uk> - 0.2
* Sun Jan 22 2006 Holger Mueller <holger@MAPS.euhm.de> - 0.1-1mr
- RPM spec created
