/*
 * Decompiled with CFR 0.152.
 */
package condor.gahp.gt42;

import condor.gahp.CommandHandler;
import condor.gahp.CommandHandlerResponse;
import condor.gahp.GahpInterface;
import condor.gahp.IOUtils;
import condor.gahp.gt42.GSIUtils;
import java.io.File;
import org.ietf.jgss.GSSCredential;

public class CacheProxyFromFileHandler
implements CommandHandler {
    private GahpInterface gahp;

    public void setGahp(GahpInterface gahpInterface) {
        this.gahp = gahpInterface;
    }

    public CommandHandlerResponse handleCommand(String[] stringArray) {
        String string = null;
        String string2 = null;
        try {
            string = stringArray[1];
            string2 = stringArray[2];
            if (string.length() == 0) {
                throw new Exception("Invalid id " + string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return CommandHandlerResponse.SYNTAX_ERROR;
        }
        if (string.equalsIgnoreCase("DEFAULT")) {
            return new CommandHandlerResponse("F " + IOUtils.escapeWord("DEFAULT not allowed"));
        }
        File file = new File(string2);
        if (!file.exists() || !file.canRead()) {
            return new CommandHandlerResponse("F", null);
        }
        GSSCredential gSSCredential = null;
        try {
            gSSCredential = GSIUtils.readCredentialFromFile(string2);
        }
        catch (Exception exception) {
            System.err.println("Error reading credential: " + exception.getMessage());
            exception.printStackTrace(System.err);
            return new CommandHandlerResponse("F " + IOUtils.escapeWord(exception.getMessage()));
        }
        GSIUtils.cacheCredential(this.gahp, string, gSSCredential);
        return new CommandHandlerResponse("S");
    }
}

