/*
 * Decompiled with CFR 0.152.
 */
package condor.gahp.gt4;

import condor.gahp.CommandHandler;
import condor.gahp.CommandHandlerResponse;
import condor.gahp.GahpInterface;
import condor.gahp.gt4.GSIUtils;
import condor.gahp.gt4.GramJobUtils;
import java.util.Calendar;
import javax.xml.rpc.Stub;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.globus.axis.util.Util;
import org.ietf.jgss.GSSCredential;
import org.oasis.wsrf.lifetime.ScheduledResourceTermination;
import org.oasis.wsrf.lifetime.SetTerminationTime;
import org.oasis.wsrf.lifetime.SetTerminationTimeResponse;
import org.oasis.wsrf.lifetime.WSResourceLifetimeServiceAddressingLocator;

public class Gt4SetTerminationTimeHandler
implements CommandHandler {
    private GahpInterface gahp = null;

    public void setGahp(GahpInterface gahpInterface) {
        this.gahp = gahpInterface;
    }

    public CommandHandlerResponse handleCommand(String[] stringArray) {
        Integer n = null;
        String string = null;
        Calendar calendar = null;
        Long l = null;
        try {
            n = new Integer(stringArray[1]);
            string = stringArray[2];
            l = new Long(stringArray[3]);
            calendar = Calendar.getInstance();
            if (stringArray[0].equals("GT4_SET_TERMINATION_TIME")) {
                calendar.add(13, l.intValue());
            } else {
                calendar.setTimeInMillis(l * 1000L);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return CommandHandlerResponse.SYNTAX_ERROR;
        }
        GSSCredential gSSCredential = GSIUtils.getCredential(this.gahp);
        return new CommandHandlerResponse("S", (Runnable)new SetTerminationTimeRunnable(n, string, calendar, this.gahp, gSSCredential));
    }

    static {
        Util.registerTransport();
    }

    class SetTerminationTimeRunnable
    implements Runnable {
        private int requestId;
        private String resourceHandle;
        private Calendar termTime;
        private GahpInterface gahp;
        private GSSCredential proxy;

        public SetTerminationTimeRunnable(int n, String string, Calendar calendar, GahpInterface gahpInterface, GSSCredential gSSCredential) {
            this.requestId = n;
            this.resourceHandle = string;
            this.termTime = calendar;
            this.gahp = gahpInterface;
            this.proxy = gSSCredential;
        }

        public void run() {
            String[] stringArray;
            long l = 0L;
            try {
                stringArray = null;
                stringArray = GramJobUtils.getEndpoint(this.resourceHandle);
                if (stringArray == null) {
                    throw new Exception("unrecognized service type");
                }
                WSResourceLifetimeServiceAddressingLocator wSResourceLifetimeServiceAddressingLocator = new WSResourceLifetimeServiceAddressingLocator();
                ScheduledResourceTermination scheduledResourceTermination = wSResourceLifetimeServiceAddressingLocator.getScheduledResourceTerminationPort((EndpointReferenceType)stringArray);
                GramJobUtils.setDefaultAttributes((Stub)scheduledResourceTermination, this.proxy);
                SetTerminationTime setTerminationTime = new SetTerminationTime();
                setTerminationTime.setRequestedTerminationTime(this.termTime);
                SetTerminationTimeResponse setTerminationTimeResponse = scheduledResourceTermination.setTerminationTime(setTerminationTime);
                Calendar calendar = setTerminationTimeResponse.getNewTerminationTime();
                l = calendar.getTime().getTime() / 1000L;
            }
            catch (Exception exception) {
                System.err.println("SetTerminationTime failed: ");
                exception.printStackTrace(System.err);
                String string = exception.getMessage() == null ? "unknown" : exception.getMessage();
                String[] stringArray2 = new String[]{"1", "0", string};
                this.gahp.addResult(this.requestId, stringArray2);
                return;
            }
            stringArray = new String[]{"0", "" + l, "NULL"};
            this.gahp.addResult(this.requestId, stringArray);
        }
    }
}

