exception Break

module Ordpath = struct
  type t = string
  let trailing_slash = Pcre.regexp "/\\s*$|\\\\\\s*$"
  let compare p1 p2 = 
    let p1' = Pcre.replace ~rex:trailing_slash ~templ:"" p1 in
    let p2' = Pcre.replace ~rex:trailing_slash ~templ:"" p2 in
    String.compare p1' p2'
end
module Strset = Set.Make(Ordpath)

(* the standard library should not be so deficient *)
module List = struct
  include List

  let filter_map f l = 
    List.fold_left
      (fun acc item -> 
         match f item with
         | Some x -> x :: acc
         | None -> acc)
      []
      l

  let find_map f l = 
    let res = ref None in
    try
      List.iter
        (fun x -> 
           match f x with
           | None -> ()
           | Some y -> res := Some y; raise Break)
        l;
      raise Not_found
    with Break -> 
      begin match !res with
      | Some y -> y
      | None -> raise Break
      end

  let map f l = 
    let r = rev_map f l in
    rev r
end

module Unix = struct
  include Unix

  let fold_path ~f ~init path = 
    let dir = Unix.opendir path in
    let acc = ref init in
    try
      while true do
        let file = Unix.readdir dir in
        acc := f file !acc
      done;
      !acc
    with 
    | End_of_file -> Unix.closedir dir; !acc
    | exn -> Unix.closedir dir; raise exn
end
