/*
**  ClanLib SDK
**  Copyright (c) 1997-2005 The ClanLib Team
**
**  This software is provided 'as-is', without any express or implied
**  warranty.  In no event will the authors be held liable for any damages
**  arising from the use of this software.
**
**  Permission is granted to anyone to use this software for any purpose,
**  including commercial applications, and to alter it and redistribute it
**  freely, subject to the following restrictions:
**
**  1. The origin of this software must not be misrepresented; you must not
**     claim that you wrote the original software. If you use this software
**     in a product, an acknowledgment in the product documentation would be
**     appreciated but is not required.
**  2. Altered source versions must be plainly marked as such, and must not be
**     misrepresented as being the original software.
**  3. This notice may not be removed or altered from any source distribution.
**
**  Note: Some of the libraries ClanLib may link to may have additional
**  requirements or restrictions.
**
**  File Author(s):
**
**    Magnus Norddahl
**    (if your name is missing here, please add it)
*/

//! clanDisplay="Input"
//! header=display.h

#ifndef header_inputevent
#define header_inputevent

#ifdef CL_API_DLL
#ifdef CL_DISPLAY_EXPORT
#define CL_API_DISPLAY __declspec(dllexport)
#else
#define CL_API_DISPLAY __declspec(dllimport)
#endif
#else
#define CL_API_DISPLAY
#endif

#if _MSC_VER > 1000
#pragma once
#endif

#include "input_device.h"
#include "../Core/Math/point.h"

//: Structure descripting an input device event.
//- !group=Display/Input!
//- !header=display.h!
class CL_API_DISPLAY CL_InputEvent
{
public:
	//: Event types.
	enum Type
	{
		no_key            = 0,
		pressed           = 1,
		released          = 2,
		moved             = 4,
		pointer_moved     = 4,
		axis_moved        = 5,
		ball_moved        = 6
	};

//! Construction:
public:
	//: Constructs a 'NoKey' key.
	CL_InputEvent();

	~CL_InputEvent();

//! Attributes:
public:
	//: Key identifier.
	int id;

	//: Character sequence generated by event.
	//- <p>A key press can generate one, none or multiple characters,
	//- the reason for this are deadkeys, ie. press ^ + a and get , so
	//- the first press would generate no key and the second one, in
	//- case that the second key being pressed doesn't support the ^ it
	//- would generate two characters (ie. ^ + 5 => "", "^5")</p>
	std::string str;

	//: Event type.
	Type type;

	//: Device that event originates from.
	CL_InputDevice device;
	
	//: Mouse position at event time.
	CL_Point mouse_pos;

	//: Axis position.
	float axis_pos;

	//: The repeat count for this event.
	//- <p>The variable contains the number of times the keystroke is
	//- autorepeated as a result of the user holding down the key.</p>
	int repeat_count;
};

#endif
