# +=========================================================================+
# || /usr/share/cipux/etc/cipux-task.cfgperl                               ||
# ||                                                                       ||
# || Configuration file for the CipUX Task Library.                        ||
# || Default boot strap configuration for CipUX tasks.                     ||
# || See manual page for more information.                                 ||
# ||                                                                       ||
# || Copyright (C) 2007 - 2009 by Christian Kuelker                        ||
# ||                                                                       ||
# || License: GNU GPL version 2 or any later version.                      ||
# ||                                                                       ||
# +=========================================================================+

# do NOT change the ordering of the configuration sections

# +=========================================================================+
# || CipUX Task Library API Section                                        ||
# +=========================================================================+

# +-------------------------------------------------------------------------+
# | basic user                                                              |
# +-------------------------------------------------------------------------+
# user account modalities:
# $cfg_task_api_hr
my $cfg = {
    'task_api' => {

        # +-----------------------------------------------------------------+
        # | ldap orga node                                                  |
        # +-----------------------------------------------------------------+

        # disable LDAP node entity untill needed
        #'cipux_task_create_ldap_orga_node' => {
        #    'desc'      => 'Create LDAP organizational node.',
        #    'object'    => ['cipux_ldap_orga_node_object'],
        #    'action'    => 'create_object_action',
        #    'must'      => [qw(ou)],
        #    'may'       => [qw(cipuxRemark)],
        #    'not'       => [qw()],
        #    'return'    => [qw()],
        #    'overwrite' => {
        #        'cipux_ldap_orga_node' =>
        #            { 'cipuxRemark' => 'CipUX task layer', },
        #    },
        #},
        #'cipux_task_destroy_ldap_orga_node' => {
        #    'desc'   => 'Destroy LDAP organizational node.',
        #    'object' => [qw(cipux_ldap_orga_node_object)],
        #    'action' => 'destroy_object_action',
        #    'must'   => [qw(ou)],
        #    'may'    => [qw()],
        #    'not'    => [qw()],
        #    'return' => [qw()],
        #},
        ##
        #'cipux_task_list_ldap_orga_nodes' => {
        #    'desc'   => 'List all LDAP organizational node.',
        #    'object' => [qw(cipux_ldap_orga_node_object)],
        #    'action' => 'list_object_action',
        #    'must'   => [qw()],
        #    'may'    => [qw()],
        #    'not'    => [qw()],
        #    'return' => [qw(cn)],    # TODO: check if needed
        #    'filter' => {
        #        'cipux_ldap_orga_node_object' =>
        #            { 'objectClass' => 'cipuxLdapOrgaNode', },
        #    },
        #    'ltarget' => 'ou',  # TODO verify 
        #},

        # +-----------------------------------------------------------------+
        # | role                                                            |
        # +-----------------------------------------------------------------+

        'cipux_task_create_role_account' => {
            'desc'   => 'Create role account.',
            'object' => [qw(cipux_role_object)],
            'action' => 'create_object_action',
            'must'   => [qw(uid)],                 # TODO
            'may'    => [
                qw(cipuxFirstname
                    cipuxLastname
                    userPassword
                    cipuxHomeDirectory)
            ],                                     # TODO
            'not'       => [qw(cipuxRole cn uid)], # TODO
            'return'    => [qw()],                 # TODO
            'overwrite' => {
                'cipux_account.user' => {
                    'cipuxFirstname' => 'Role',
                    'cipuxLastname'  => 'Account',
                    'cipuxRemark'    => 'CipUX task layer',
                    'cipuxRole'      => 'role',
                },
                'cipux_role.group' => {
                    'cipuxRemark' => 'CipUX task layer',
                    'cipuxRole'   => 'role',

                    #'groupType'    => 'authority_group',
                },
            },
            'dog' => {

                # The dog "post" section will be executed after the task
                # was issued. In this case after the object was created.
                # The mandatory key "cipux_dog" specify a section in
                # cipux-dog.conf. The key-word "@object@" will be replaced
                # with the value of -o or --object that was given with
                # the cipux_task_client on the command line or it will
                # be replaced by the value of the hash reference
                # { object => 'value', } via a library call. @object@
                # might be empty or undef.

                'post' => {

                    # refers to a cipux_dogs entry in cipux-dog.conf
                    'cipux_dog' => 'create_homedir',

                    # defines @user@ in cipux-dog.conf
                    'user' => '@object@',

                    # defines @role@ in cipux-dog.conf
                    'role' => 'role',
                },
            },
        },
        'cipux_task_destroy_role_account' => {
            'desc'   => 'Destroy role account.',
            'object' => [qw(cipux_role_object)],
            'action' => 'destroy_object_action',
            'must'   => [qw(uid)],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw()],
        },
        'cipux_task_list_role_accounts' => {
            'desc'   => 'List all role accounts.',
            'object' => [qw(authority_role_object)],
            'action' => 'list_object_action',
            'must'   => [qw()],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cn)],                      # TODO: check if needed
            'filter' => {
                'authority_account.group' =>
                    { 'groupType' => 'authority_group', },
            },
	    'ltarget' => 'cn',
        },
        'cipux_task_list_members_of_role_account' => {
            'desc'   => 'List all members of a given role account.',
            'object' => [qw(cipux_role_object)],
            'action' => 'list_object_attribute_action',
            'must'   => [qw(object)],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cn)],
            'scope'  => 'one',
            'filter' => {
                'cipux_role.group' => { 'groupType' => 'authority_group', },
            },
            'target' => { 'cipux_role.group' => { 'memberUid' => 0, }, },
            'ltarget' => 'memberUid',
        },

# cipux_ldap_set_value -a -t cipux_account.group -y memberUid=xxx -o bibeutlin
#mod filter [&(cn=bibeutlin)(objectClass=cipuxGroup)(cipuxIsAccount=TRUE)]
        'cipux_task_add_member_to_role_account' => {
            'desc'   => 'Add a member to a given role account.',
            'object' => [qw(cipux_role_object)],
            'action' => 'change_object_attribute_action',
            'must'   => [qw(object attr value )],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cn)],
            'scope'  => 'one',
            'filter' => {
                'cipux_role.group' => { 'groupType' => 'authority_group', },
            },
            'target' => {
                'cipux_role.group' => {
                    'memberUid' => 0,
                    'member'    => 'cipux_account.user'
                },
            },
            'changes' => { 'cipux_role.group' => 'add', },
        },

        'cipux_task_remove_member_from_role_account' => {
            'desc'   => 'Remove a member from a given  role account.',
            'object' => [qw(cipux_role_object)],
            'action' => 'change_object_attribute_action',
            'must'   => [qw(object attr value )],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cn)],
            'scope'  => 'one',
            'filter' => {},
            'target' => {
                'cipux_role.group' => {
                    'memberUid' => 0,
                    'member'    => 'cipux_account.user'
                },
            },
            'changes' => { 'cipux_role.group' => 'delete', },
        },

        # +-----------------------------------------------------------------+
        # | skel                                                            |
        # +-----------------------------------------------------------------+
        'cipux_task_create_skel_account' => {
            'desc'      => 'Create skel account.',
            'object'    => [qw(cipux_skel_object)],
            'action'    => 'create_object_action',
            'must'      => [qw(uid cipuxFirstname cipuxLastname)],    # TODO
            'may'       => [qw(userPassword cipuxHomeDirectory)],     # TODO
            'not'       => [qw(cipuxRole cn uid)],                    # TODO
            'return'    => [qw()],                                    # TODO
            'overwrite' => {
                'cipux_account.user' => {
                    'cipuxRemark' => 'CipUX task layer',
                    'cipuxRole'   => 'role',
                },
                'cipux_account.group' => {
                    'cipuxRemark' => 'CipUX task layer',
                    'cipuxRole'   => 'role',
                },
            },
            'dog' => {
                'post' => {
                    'cipux_dog' => 'create_homedir',
                    'user'      => '@object@',
                    'role'      => 'role',
                },
            },
        },
        'cipux_task_destroy_skel_account' => {
            'desc'   => 'Destroy skel account.',
            'object' => [qw(cipux_skel_object)],
            'action' => 'destroy_object_action',
            'must'   => [qw(uid)],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw()],
        },
        'cipux_task_list_skel_accounts' => {
            'desc'   => 'List all skel accounts.',
            'object' => [qw(cipux_skel_object)],
            'action' => 'list_object_action',
            'must'   => [qw()],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cn)],                    # TODO: check if needed
            'filter' => {
                'cipux_account.user' => {
                    'cipuxRole'   => 'role',
                    'cipuxIsRole' => 'TRUE',
                    'cipuxIsSkel' => 'TRUE',
                },
                'cipux_account.group' => {
                    'cipuxRole'   => 'role',
                    'cipuxIsRole' => 'TRUE',
                    'cipuxIsSkel' => 'TRUE',
                },
            },
	    'ltarget' => 'uid',
        },
        'cipux_task_list_members_of_skel_account' => {
            'desc'   => 'List all members of a given skel account.',
            'object' => [qw(cipux_skel_object)],
            'action' => 'list_object_attribute_action',
            'must'   => [qw(object)],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cn)],    # TODO: check if needed
            'scope'  => 'one',
            'filter' => {
                'cipux_account.group' => {
                    'cipuxRole'   => 'role',
                    'cipuxIsRole' => 'TRUE',
                    'cipuxIsSkel' => 'TRUE',
                },
            },
            'target' => { 'cipux_account.group' => { 'memberUid' => 0 }, },
            'ltarget' => 'memberUid',
        },

# cipux_ldap_set_value -a -t cipux_account.group -y memberUid=xxx -o bibeutlin
#mod filter [&(cn=bibeutlin)(objectClass=cipuxGroup)(cipuxIsAccount=TRUE)]
        'cipux_task_add_member_to_skel_account' => {
            'desc'   => 'Add a member to a given skel account.',
            'object' => [qw(cipux_skel_object)],
            'action' => 'change_object_attribute_action',
            'must'   => [qw(object attr value )],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cn)],    # TODO: check if needed
            'scope'  => 'one',
            'filter' => {
                'cipux_account.group' => {
                    'cipuxRole'   => 'role',
                    'cipuxIsRole' => 'TRUE',
                    'cipuxIsSkel' => 'TRUE',
                },
            },
            'target'  => { 'cipux_account.group' => { 'memberUid' => 0, }, },
            'changes' => { 'cipux_account.group' => 'add', },
        },
        'cipux_task_retrieve_all_skel_account_lastname_firstname' => {
            'desc' =>
                'Get firstname and lastname info from all skel accounts.',
            'object' => [qw(cipux_account_object)],
            'action' => 'list_all_attribute_action',
            'must'   => [qw()],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cipuxLastname)],           # TODO: check if needed
            'filter' => {
                'cipux_account.user' => {
                    'cipuxRole'   => 'role',
                    'cipuxIsRole' => 'TRUE',
                    'cipuxIsSkel' => 'TRUE',
                },
            },
            'scope'  => 'all',
            'target' => {
                'cipux_account.user' => {
                    'cipuxLastname'  => 0,
                    'cipuxFirstname' => 0,
                },
            },
            'ltarget' => 'uid',
        },
        'cipux_task_change_skel_account_password' => {
            'desc'   => "Change the password of a given skel acccount.",
            'object' => [qw(cipux_account_object)],
            'action' => 'change_object_attribute_action',
            'must'   => [qw(object attr value )],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cn)],    # TODO: check if needed
            'scope'  => 'one',
            'filter' => {
                'cipux_account.user' => {
                    'cipuxRole'   => 'role',
                    'cipuxIsRole' => 'TRUE',
                    'cipuxIsSkel' => 'TRUE',
                },
            },
            'target' => { 'cipux_account.user' => { 'userPassword' => 0, }, },
            'changes' => { 'cipux_account.user' => 'replace', },
        },

### CAT_module ###
        'cipux_task_register_cat_module' => {
            'desc'      => 'Register a CAT module.',
            'object'    => ['cipux_cat_module_object'],
            'action'    => 'create_object_action',
            'must'      => [qw(moduleid)],
            'may'       => [qw(name pos)],
            'not'       => [qw()],
            'return'    => [qw()],
            'overwrite' => {
                'cipux_cat_module_object' =>
                    { 'cipuxRemark' => 'CipUX task layer', },
            },
        },
        'cipux_task_deregister_cat_module' => {
            'desc'   => 'De-register a CAT module.',
            'object' => ['cipux_cat_module_object'],
            'action' => 'destroy_object_action',
            'must'   => [qw(moduleid)],
            'may'    => [],
            'not'    => [],
            'return' => [],
        },
        'cipux_task_list_cat_modules' => {
            'desc'   => 'List all CAT modules.',
            'object' => ['cipux_cat_module_object'],
            'action' => 'list_object_action',
            'must'   => [qw(moduleid)],
            'may'    => [qw(name pos)],
            'not'    => [qw()],
            'return' => [qw(cn)],
            'filter' => {},
            'ltarget' => 'cn',
        },
        'cipux_task_list_enabled_cat_modules' => {
            'desc'   => 'List all enabled CAT modules.',
            'object' => ['cipux_cat_module_object'],
            'action' => 'list_object_action',
            'must'   => [qw(moduleid)],
            'may'    => [qw(name pos)],
            'not'    => [qw()],
            'return' => [qw()],
            'filter' => {
                'cipux_cat_module_object' => { 'cipuxIsEnabled' => 'TRUE', },
            },
            'ltarget' => 'cn',
        },
        'cipux_task_list_disabled_cat_modules' => {
            'desc'   => 'List all disabled CAT modules.',
            'object' => ['cipux_cat_module_object'],
            'action' => 'list_object_action',
            'must'   => [qw(moduleid)],
            'may'    => [qw(name pos)],
            'not'    => [qw()],
            'return' => [qw()],
            'filter' => {
                'cipux_cat_module_object' => { 'cipuxIsEnabled' => 'FALSE', },
            },
            'ltarget' => 'cn',
        },
        'cipux_task_retrieve_all_cat_module_name_shortdescription' => {
            'desc' =>
                'Get all "cipuxName" and "cipuxShortDescription info of all CAT modules.',
            'object' => [qw(cipux_cat_module_object)],
            'action' => 'list_all_attribute_action',
            'must'   => [qw()],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cipuxName)],               # TODO: check if needed
            'filter' => {},
            'scope'  => 'all',
            'target' => {
                'cipux_cat_module' => {
                    'cipuxName'             => 0,
                    'cipuxShortDescription' => 0,
                },
            },
            'ltarget' => 'cn',
        },
        'cipux_task_retrieve_all_cat_module_name_shortdescription_templatedir_author_version_license_isenabled_icon'
            => {
            'desc' =>
                'Get all "cipuxName", "cipuxShortDescription, "cipuxTemplateDir", "cipuxAuthor", "cipuxVersion", "cipuxLicense" , "cipuxIsEnabled" and "cipuxIcon" info of all CAT modules.',
            'object' => [qw(cipux_cat_module_object)],
            'action' => 'list_all_attribute_action',
            'must'   => [qw()],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cipuxName)],               # TODO: check if needed
            'filter' => {},
            'scope'  => 'all',
            'target' => {
                'cipux_cat_module' => {
                    'cipuxName'             => 0,
                    'cipuxShortDescription' => 0,
                    'cipuxTemplateDir'      => 0,
                    'cipuxAuthor'           => 0,
                    'cipuxVersion'          => 0,
                    'cipuxLicense'          => 0,
                    'cipuxIsEnabled'        => 0,
                    'cipuxIcon'             => 0,
                },
            },
            'ltarget' => 'cn',
            },

     #'return' => [qw(cn cipuxTemplateDir cipuxShortDescription cipuxScript)],
        'cipux_task_retrieve_all_cat_module_name_shortdescription_templatedir_script_isenabled'
            => {
            'desc' =>
                'Get all "cipuxName", "cipuxShortDescription, "cipuxTemplateDir", "cipuxScript and "cipuxIsEnabled" info of all CAT modules.',
            'object' => [qw(cipux_cat_module_object)],
            'action' => 'list_all_attribute_action',
            'must'   => [qw()],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cipuxName)],               # TODO: check if needed
            'filter' => {},
            'scope'  => 'all',
            'target' => {
                'cipux_cat_module' => {
                    'cipuxName'             => 0,
                    'cipuxShortDescription' => 0,
                    'cipuxTemplateDir'      => 0,
                    'cipuxScript'           => 0,
                    'cipuxIsEnabled'        => 0,
                },
            },
            'ltarget' => 'cn',
            },
        'cipux_task_enable_cat_module' => {
            'desc'   => 'Enable a given CAT module.',
            'object' => [qw(cipux_cat_module_object)],
            'action' => 'change_object_attribute_action',
            'must'   => [qw(object attr value)],
            'may'    => [qw()],
            'not'    => [qw()],
            'return'    => [qw(cn)],    # TODO: check if needed
            'scope'     => 'one',
            'overwrite' => {
                'cipux_cat_module_object' => { 'cipuxIsEnabled' => 'TRUE', },
            },
            'filter' => {},
            'target' => { 'cipux_cat_module' => { 'cipuxIsEnabled' => 0, }, },
            'changes' => { 'cipux_cat_module' => 'replace', },
        },

        # disable
        'cipux_task_disable_cat_module' => {
            'desc'   => 'Disable a given CAT module.',
            'object' => [qw(cipux_cat_module_object)],
            'action' => 'change_object_attribute_action',
            'must'   => [qw(object attr value)],
            'may'    => [qw()],
            'not'    => [qw()],
            'return'    => [qw(cn)],    # TODO: check if needed
            'scope'     => 'one',
            'overwrite' => {
                'cipux_cat_module_object' => { 'cipuxIsEnabled' => 'FALSE', },
            },
            'filter' => {},
            'target' => { 'cipux_cat_module' => { 'cipuxIsEnabled' => 0, }, },
            'changes' => { 'cipux_cat_module' => 'replace', },
        },

        # optain
        'cipux_task_optain_cat_module_isenabled' => {
            'desc'   => 'Get "cipuxIsEnabled" from a given CAT module.',
            'object' => [qw(cipux_cat_module_object)],
            'action' => 'list_object_attribute_action',
            'must'   => [qw(object)],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cipuxIsEnabled)],    # TODO: check if needed
            'scope'  => 'one',
            'filter' => {},
            'target' => { 'cipux_cat_module' => { 'cipuxIsEnabled' => 0, }, },
            'ltarget' => 'cipuxIsEnabled',
        },
        # optain task
        'cipux_task_optain_cat_module_task' => {
            'desc'   => 'Get "cipuxTask" from a given CAT module.',
            'object' => [qw(cipux_cat_module_object)],
            'action' => 'list_object_attribute_action',
            'must'   => [qw(object)],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cipuxTask)],    # TODO: check if needed
            'scope'  => 'one',
            'filter' => {},
            'target' => { 'cipux_cat_module' => { 'cipuxTask' => 0, }, },
            'ltarget' => 'cipuxTask',
        },
        'cipux_task_list_members_of_cat_module' => {
            'desc'   => 'List all members of a given CAT module.',
            'object' => [qw(cipux_cat_module_object)],
            'action' => 'list_object_attribute_action',
            'must'   => [qw(object)],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cn)],                # TODO: check if needed
            'scope'  => 'one',
            'filter' => {},
            'target' => { 'cipux_cat_module' => { 'cipuxMemberRid' => 0, }, },
            'ltarget' => 'cipuxMemberRid',
        },
        'cipux_task_add_member_to_cat_module' => {
            'desc'   => 'Add a member to a given CAT module.',
            'object' => [qw(cipux_cat_module_object)],
            'action' => 'change_object_attribute_action',
            'must'   => [qw(object attr value )],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cn)],                # TODO: check if needed
            'scope'  => 'one',
            'filter' => {},
            'target' => { 'cipux_cat_module' => { 'cipuxMemberRid' => 0, }, },
            'changes' => { 'cipux_cat_module' => 'add', },
        },
        'cipux_task_remove_member_from_cat_module' => {
            'desc'   => 'Remove a member from a given CAT module.',
            'object' => [qw(cipux_cat_module_object)],
            'action' => 'change_object_attribute_action',
            'must'   => [qw(object attr value )],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cn)],    # TODO: check if needed
            'scope'  => 'one',
            'filter' => {},
            'target' => { 'cipux_cat_module' => { 'cipuxMemberRid' => 0, }, },
            'changes' => { 'cipux_cat_module' => 'delete', },
        },

### task ###
        'cipux_task_register_task' => {
            'desc'      => 'Register a task.',
            'object'    => ['cipux_task_object'],
            'action'    => 'create_object_action',
            'must'      => [qw(moduleid)],
            'may'       => [qw(name pos)],
            'not'       => [qw()],
            'return'    => [qw()],
            'overwrite' => {
                'cipux_task_object' =>
                    { 'cipuxRemark' => 'CipUX task layer', },
            },
        },
        'cipux_task_deregister_task' => {
            'desc'   => 'De-register a task.',
            'object' => ['cipux_task_object'],
            'action' => 'destroy_object_action',
            'must'   => [qw(moduleid)],
            'may'    => [],
            'not'    => [],
            'return' => [],
        },
        'cipux_task_list_tasks' => {
            'desc'   => 'List all tasks stored in LDAP',
            'object' => ['cipux_task_object'],
            'action' => 'list_object_action',
            'must'   => [qw(moduleid)],
            'may'    => [qw(name pos)],
            'not'    => [qw()],
            'return' => [qw()],
            'filter' => {},
            'ltarget' => 'cn',
        },
        'cipux_task_list_enabled_tasks' => {
            'desc'   => 'List all enabled tasks stored in LDAP.',
            'object' => ['cipux_task_object'],
            'action' => 'list_object_action',
            'must'   => [qw(moduleid)],
            'may'    => [qw(name pos)],
            'not'    => [qw()],
            'return' => [qw()],
            'filter' =>
                { 'cipux_task_object' => { 'cipuxIsEnabled' => 'TRUE', }, },
            'ltarget' => 'cn',
        },
        'cipux_task_list_disabled_tasks' => {
            'desc'   => 'List all disabled tasks stored in LDAP.',
            'object' => ['cipux_task_object'],
            'action' => 'list_object_action',
            'must'   => [qw(moduleid)],
            'may'    => [qw(name pos)],
            'not'    => [qw()],
            'return' => [qw()],
            'filter' =>
                { 'cipux_task_object' => { 'cipuxIsEnabled' => 'FALSE', }, },
            'ltarget' => 'cn',
        },
        'cipux_task_retrieve_all_task_name_shortdescription' => {
            'desc' =>
                'Get all "cipuxName" and "cipuxShortDescription info of all tasks stored in LDAP.',
            'object' => [qw(cipux_task_object)],
            'action' => 'list_all_attribute_action',
            'must'   => [qw()],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cipuxName)],               # TODO: check if needed
            'filter' => {},
            'scope'  => 'all',
            'target' => {
                'cipux_task' => {
                    'cipuxName'             => 0,
                    'cipuxShortDescription' => 0,
                },
            },
            'ltarget' => 'cn',
        },
        'cipux_task_retrieve_all_task_name_shortdescription_memberpid_isenabled'
            => {
            'desc' =>
                'Get all "cipuxName", "cipuxShortDescription, "cipuxMemberPID" and "cipuxIsEnabled" info of all tasks stored in LDAP.',
            'object' => [qw(cipux_task_object)],
            'action' => 'list_all_attribute_action',
            'must'   => [qw()],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cipuxName)],               # TODO: check if needed
            'filter' => {},
            'scope'  => 'all',
            'target' => {
                'cipux_task' => {
                    'cipuxName'             => 0,
                    'cipuxShortDescription' => 0,
                    'cipuxMemberPID'        => 0,
                    'cipuxIsEnabled'        => 0,
                },
            },
            'ltarget' => 'cn',
            },
        'cipux_task_enable_task' => {
            'desc'   => 'Enable a given task stored in LDAP.',
            'object' => [qw(cipux_task_object)],
            'action' => 'change_object_attribute_action',
            'must'   => [qw(object attr value)],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cn)],    # TODO: check if needed
            'scope'  => 'one',
            'overwrite' =>
                { 'cipux_task_object' => { 'cipuxIsEnabled' => 'TRUE', }, },
            'filter' => {},
            'target' => { 'cipux_task' => { 'cipuxIsEnabled' => 0, }, },
            'changes' => { 'cipux_task' => 'replace', },
        },

        # disable
        'cipux_task_disable_task' => {
            'desc'   => 'Disable a given task stored in LDAP.',
            'object' => [qw(cipux_task_object)],
            'action' => 'change_object_attribute_action',
            'must'   => [qw(object attr value)],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cn)],    # TODO: check if needed
            'scope'  => 'one',
            'overwrite' =>
                { 'cipux_task_object' => { 'cipuxIsEnabled' => 'FALSE', }, },
            'filter' => {},
            'target' => { 'cipux_task' => { 'cipuxIsEnabled' => 0, }, },
            'changes' => { 'cipux_task' => 'replace', },
        },

        # optain
        'cipux_task_optain_task_isenabled' => {
            'desc' =>
                'Get "cipuxIsEnabled" from a given task stored in LDAP.',
            'object' => [qw(cipux_task_object)],
            'action' => 'list_object_attribute_action',
            'must'   => [qw(object)],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cipuxIsEnabled)],          # TODO: check if needed
            'scope'  => 'one',
            'filter' => {},
            'target' => { 'cipux_task' => { 'cipuxIsEnabled' => 0, }, },
        },
        'cipux_task_add_member_to_task' => {
            'desc'   => 'Add a member to a given task.',
            'object' => [qw(cipux_task_object)],
            'action' => 'change_object_attribute_action',
            'must'   => [qw(object attr value )],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cn)],                      # TODO: check if needed
            'scope'  => 'one',
            'filter' => {},
            'target' => { 'cipux_task' => { 'cipuxMemberPid' => 0 }, },
            'changes' => { 'cipux_task' => 'add', },
        },
        'cipux_task_remove_member_from_task' => {
            'desc'   => 'Remove a member from a given task.',
            'object' => [qw(cipux_task_object)],
            'action' => 'change_object_attribute_action',
            'must'   => [qw(object attr value )],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cn)],    # TODO: check if needed
            'scope'  => 'one',
            'filter' => {},
            'target' => { 'cipux_task' => { 'cipuxMemberPid' => 0, }, },
            'changes' => { 'cipux_task' => 'delete', },
        },
        'cipux_task_list_members_of_task' => {
            'desc'   => 'List all members of a given task stored in LDAP.',
            'object' => [qw(cipux_task_object)],
            'action' => 'list_object_attribute_action',
            'must'   => [qw(object)],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cn)],    # TODO: check if needed
            'scope'  => 'one',
            'filter' => {},
            'target' => { 'cipux_task' => { 'cipuxMemberPid' => 0, }, },
            'ltarget' => 'cipuxMemberPid',
        },

### room ###
        'cipux_task_create_room' => {
            'desc'   => 'Create a room.',
            'object' => [qw(cipux_room_object)],
            'action' => 'create_object_action',
            'must'   => [qw(roomid)],
            'may'    => [
                qw( network_address
                    network_mask
                    gateway_address
                    gateway_mask
                    description
                    )
            ],
            'not'       => [qw()],
            'return'    => [qw()],
            'overwrite' => {},
        },
        'cipux_task_destroy_room' => {
            'desc'   => 'Destroy a room.',
            'object' => [qw(cipux_room_object)],
            'action' => 'destroy_object_action',
            'must'   => [qw(roomid)],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw()],
        },
        'cipux_task_list_rooms' => {
            'desc'   => 'List all rooms.',
            'object' => [qw(cipux_room_object)],
            'action' => 'list_object_action',
            'must'   => [qw()],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cn)],                  # TODO: check if needed
            'filter' => {},
            'ltarget' => 'cn',
        },
        'cipux_task_optain_room_network_address' => {
            'desc'   => 'Get a network address of a given room.',
            'object' => [qw(cipux_room_object)],
            'action' => 'optain_attribute',
            'must'   => [qw(roomid)],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cipuxNetworkAddress)],
        },
        'cipux_task_change_room_telephone' => {
            'desc'   => "Change the rooms telephone number.",
            'object' => [qw(cipux_room_object)],
            'action' => 'change_object_attribute_action',
            'must'   => [qw(object attr value )],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cn)],
            'scope'  => 'one',
            'target' => { 'cipux_room' => { 'telephoneNumber' => 0, }, },
            'filter' =>
                { 'cipux_room' => { 'objectClass' => 'cipuxRoom', }, },
            'changes' => { 'cipux_room' => 'replace', },
        },
        'cipux_task_change_room_department' => {
            'desc'   => "Change the rooms department.",
            'object' => [qw(cipux_room_object)],
            'action' => 'change_object_attribute_action',
            'must'   => [qw(object attr value )],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cn)],
            'scope'  => 'one',
            'target' => { 'cipux_room' => { 'cipuxFaculty' => 0, }, },
            'filter' =>
                { 'cipux_room' => { 'objectClass' => 'cipuxRoom', }, },
            'changes' => { 'cipux_room' => 'replace', },
        },
        'cipux_task_change_room_location' => {
            'desc'   => "Change the rooms location.",
            'object' => [qw(cipux_room_object)],
            'action' => 'change_object_attribute_action',
            'must'   => [qw(object attr value )],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cn)],
            'scope'  => 'one',
            'target' => { 'cipux_room' => { 'cipuxAddress' => 0, }, },
            'filter' =>
                { 'cipux_room' => { 'objectClass' => 'cipuxRoom', }, },
            'changes' => { 'cipux_room' => 'replace', },
        },
        'cipux_task_change_room_number' => {
            'desc'   => "Change the rooms number.",
            'object' => [qw(cipux_room_object)],
            'action' => 'change_object_attribute_action',
            'must'   => [qw(object attr value )],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cn)],
            'scope'  => 'one',
            'target' => { 'cipux_room' => { 'roomNumber' => 0, }, },
            'filter' =>
                { 'cipux_room' => { 'objectClass' => 'cipuxRoom', }, },
            'changes' => { 'cipux_room' => 'replace', },
        },
        'cipux_task_retrieve_all_room_telephone' => {
            'desc'   => 'Get all "telephoneNumber" info of all rooms.',
            'object' => [qw(cipux_room_object)],
            'action' => 'list_all_attribute_action',
            'must'   => [qw()],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(telephoneNumber)],    # TODO: check if needed
            'filter' => {},
            'scope'  => 'all',
            'target' => { 'cipux_room' => { 'telephoneNumber' => 0, }, },
        },
        'cipux_task_retrieve_all_room_department' => {
            'desc'   => 'Get all "cipuxFaculty" info of all rooms.',
            'object' => [qw(cipux_room_object)],
            'action' => 'list_all_attribute_action',
            'must'   => [qw()],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cipuxFaculty)],       # TODO: check if needed
            'filter' => {},
            'scope'  => 'all',
            'target' => { 'cipux_room' => { 'cipuxFaculty' => 0, }, },
        },
        'cipux_task_retrieve_all_room_number' => {
            'desc'   => 'Get all "roomNumber" info of all rooms.',
            'object' => [qw(cipux_room_object)],
            'action' => 'list_all_attribute_action',
            'must'   => [qw()],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(roomNumber)],         # TODO: check if needed
            'filter' => {},
            'scope'  => 'all',
            'target' => { 'cipux_room' => { 'roomNumber' => 0, }, },
        },
        'cipux_task_retrieve_all_room_location' => {
            'desc'   => 'Get all "cipuxAddress" info of all rooms.',
            'object' => [qw(cipux_room_object)],
            'action' => 'list_all_attribute_action',
            'must'   => [qw()],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cipuxAddress)],       # TODO: check if needed
            'filter' => {},
            'scope'  => 'all',
            'target' => { 'cipux_room' => { 'cipuxAddress' => 0, }, },
        },

### netgroup ###
        'cipux_task_create_netgroup' => {
            'desc'      => 'Create a netgroup.',
            'object'    => [qw(cipux_netgroup_object)],
            'action'    => 'create_object_action',
            'must'      => [qw(netgroupId)],
            'may'       => [qw()],
            'not'       => [qw()],
            'return'    => [qw()],
            'overwrite' => {},
        },
        'cipux_task_destroy_netgroup' => {
            'desc'   => 'Destroy a netgroup.',
            'object' => [qw(cipux_netgroup_object)],
            'action' => 'destroy_object_action',
            'must'   => [qw(netgroupId)],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw()],
        },
        'cipux_task_list_netgroups' => {
            'desc'   => 'List all netgroups.',
            'object' => [qw(cipux_netgroup_object)],
            'action' => 'list_object_action',
            'must'   => [qw()],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cn)],                      # TODO: check if needed
            'filter' => {},
            'ltarget' => 'cn',
        },

# open LDAP not capabale, see RFC2251 an mail on cipux-devel 2008-05-27
# you can add only ONE client, or you have to use cipuxNetgroupTriple
# instead of nisNetgroupTriple
#'cipux_task_add_client_to_netgroup' => {
#    'desc'    => 'Add a triple to a given netgroup.',
#    'object'  => ['cipux_netgroup_object'],
#    'action'  => 'change_object_attribute_action',
#    'must'    => [qw(object attr value)],
#    'may'     => [qw()],
#    'not'     => [qw()],
#    'return'  => [qw(cn)],
#    'scope'   => 'one',
#    'filter'  => { objectClass => 'nisNetgroup', },
#    'target'  => { 'cipux_netgroup' => {'nisNetgroupTriple'=>0,}, },
#    'changes' => { 'cipux_netgroup' => 'add', },
#},
# open LDAP not capabale, see RFC2251 an mail on cipux-devel 2008-05-27
# you can add only ONE client, or you have to use cipuxNetgroupTriple
# instead of nisNetgroupTriple
#'cipux_task_remove_client_from_netgroup' => {
#    'desc'   => "Remove a member from a given netgroup.",
#    'object' => [qw(cipux_netgroup_object)],
#    'action' => 'change_object_attribute_action',
#    'must'   => [qw(object attr value )],
#    'may'    => [qw()],
#    'not'    => [qw()],
#    'return' => [qw(cn)],                                   # TODO: check if needed
#    'scope'  => 'one',
#    'filter' =>
#      { 'cipux_netgroup' => { objectClass => 'nisNetgroup' }, },
#    'target'  => { 'cipux_netgroup' => {'nisNetgroupTriple'=>0,}, },
#    'changes' => { 'cipux_netgroup' => 'delete', },
#},
        'cipux_task_addmodify_all_clients_of_netgroup' => {
            'desc'   => "Change the client or clients of a given netgroup.",
            'object' => ['cipux_netgroup_object'],
            'action' => 'change_object_attribute_action',
            'must'   => [qw(object attr value )],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cn)],
            'scope'  => 'one',
            'filter' => { objectClass => 'nisNetgroup', },
            'target' =>
                { 'cipux_netgroup' => { 'nisNetgroupTriple' => 0, }, },
            'changes' => { 'cipux_netgroup' => 'replace', },
        },
        'cipux_task_erase_clients_of_netgroup' => {
            'desc'   => "Delete all client attributes of a given netgroup.",
            'object' => ['cipux_netgroup_object'],
            'action' => 'change_object_attribute_action',
            'must'   => [qw(object attr value )],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cn)],
            'scope'  => 'one',
            'escope' => 'all',
            'filter' => { objectClass => 'nisNetgroup', },
            'target' =>
                { 'cipux_netgroup' => { 'nisNetgroupTriple' => 0, }, },
            'changes' => { 'cipux_netgroup' => 'erase', }
            ,    # this deletes a LDAP attribute
             #'changes' => { 'cipux_netgroup' => 'delete', }, # this deletes a LDAP attribute
        },
        'cipux_task_list_clients_of_netgroup' => {
            'desc'   => 'List all members of a given netgroup.',
            'object' => [qw(cipux_netgroup_object)],
            'action' => 'list_object_attribute_action',
            'must'   => [qw(object)],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cn)],    # TODO: check if needed
            'scope'  => 'one',
            'filter' => {},
            'target' =>
                { 'cipux_netgroup' => { 'nisNetgroupTriple' => 0, }, },
            'shell' => [],
            'ltarget' => 'nisNetgroupTriple',
        },
### client ###
        'cipux_task_list_clients' => {
            'desc'   => 'List all clients.',
            'object' => [qw(cipux_client_object)],
            'action' => 'list_object_action',
            'must'   => [qw()],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cn)],                    # TODO: check if needed
            'scope'  => 'all',
            'filter' => {},
            'ltarget' => 'cn',
        },
        'cipux_task_create_client' => {
            'desc'      => 'Create client.',
            'object'    => [qw(cipux_client_object)],
            'action'    => 'create_object_action',
            'must'      => [qw(cn)],
            'may'       => [qw()],
            'not'       => [qw()],
            'return'    => [qw()],
            'overwrite' => {},
        },
        'cipux_task_destroy_client' => {
            'desc'   => 'Destroy client.',
            'object' => [qw(cipux_client_object)],
            'action' => 'destroy_object_action',
            'must'   => [qw(cn)],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw()],
        },
        'cipux_task_change_client_macaddress' => {
            'desc'   => "Change the clients MAC address.",
            'object' => [qw(cipux_client_object)],
            'action' => 'change_object_attribute_action',
            'must'   => [qw(object attr value )],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cn)],    # TODO: check if needed
            'scope'  => 'one',
            'target' => { 'cipux_client' => { 'macAddress' => 0, }, },
            'filter' =>
                { 'cipux_client' => { 'objectClass' => 'cipuxMachine', }, },
            'changes' => { 'cipux_client' => 'replace', },
        },
        'cipux_task_change_client_associateddomain' => {
            'desc'   => "Change the clients MAC address.",
            'object' => [qw(cipux_client_object)],
            'action' => 'change_object_attribute_action',
            'must'   => [qw(object attr value )],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cn)],    # TODO: check if needed
            'scope'  => 'one',
            'target' => { 'cipux_client' => { 'associatedDomain' => 0 }, },
            'filter' =>
                { 'cipux_client' => { 'objectClass' => 'cipuxMachine', }, },
            'changes' => { 'cipux_client' => 'replace', },
        },

        'cipux_task_change_client_iphostnumber' => {
            'desc'   => "Change the clients MAC address.",
            'object' => [qw(cipux_client_object)],
            'action' => 'change_object_attribute_action',
            'must'   => [qw(object attr value )],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cn)],    # TODO: check if needed
            'scope'  => 'one',
            'target' => { 'cipux_client' => { 'ipHostNumber' => 0, }, },
            'filter' =>
                { 'cipux_client' => { 'objectClass' => 'cipuxMachine', }, },
            'changes' => { 'cipux_client' => 'replace', },
        },
        'cipux_task_retrieve_all_client_iphostnumber_domainname_macaddress' =>
            {
            'desc' =>
                'Get all "ipHostNumber", "associatedDomain" and "macAddress" info of all clients.',
            'object' => [qw(cipux_client_object)],
            'action' => 'list_all_attribute_action',
            'must'   => [qw()],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cipuxName)],               # TODO: check if needed
            'filter' => {},
            'scope'  => 'all',
            'target' => {
                'cipux_client' => {
                    'ipHostNumber'     => 0,
                    'associatedDomain' => 0,
                    'macAddress'       => 0,
                },
            },
            'ltarget' => 'cn',
            },
### aux functions ###
        'cipux_task_sum' => {
            'desc' =>
                'XML-RPC test function. Add two numbers, returns result.',
            'object' => [],
            'action' => 'special',
            'must'   => [qw()],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw()],      # TODO: check if needed
        },
        'cipux_task_search_all_uidnumber' => {
            'desc'   => 'Search for all "uidNumber".',
            'object' => [qw(cipux_account_object)],
            'action' => 'list_object_attribute_action',
            'must'   => [qw()],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cn)],                      # TODO: check if needed
            'scope'  => 'all',
            'filter' => {},
            'target' => { 'cipux_account.user' => { 'uidNumber' => 0, }, },
        },
        'cipux_task_search_all_gidnumber' => {
            'desc'   => 'Search for all "gidNumber".',
            'object' => [qw(cipux_account_object)],
            'action' => 'list_object_attribute_action',
            'must'   => [qw()],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cn)],                      # TODO: check if needed
            'scope'  => 'all',
            'filter' => {},
            'target' => { 'cipux_account.group' => { 'gidNumber' => 0, }, },
        },

        # +-------------------------------------------------------------+
        # | generic user account                                        |
        # +-------------------------------------------------------------+
        'cipux_task_create_user_account' => {
            'desc'      => "Create a user account.",
            'object'    => [qw(cipux_account_object)],
            'action'    => 'create_object_action',
            'must'      => [qw(uid cipuxFirstname cipuxLastname)],    # TODO
            'may'       => [qw(userPassword cipuxHomeDirectory)],     # TODO
            'not'       => [qw(cipuxRole cn uid)],                    # TODO
            'return'    => [qw()],                                    # TODO
            'overwrite' => {
                'cipux_account.user' => {
                    'cipuxRemark' => 'CipUX task layer',
                    'cipuxRole'   => 'user',
                },
                'cipux_account.group' => {
                    'cipuxRemark' => 'CipUX task layer',
                    'cipuxRole'   => 'user',
                },
            },
            'dog' => {
                'post' => {
                    'cipux_dog' => 'create_homedir',
                    'user'      => '@object@',
                    'role'      => 'user',
                },
            },
        },
        'cipux_task_destroy_user_account' => {
            'desc'   => "Destroy a user account.",
            'object' => [qw(cipux_account_object)],
            'action' => 'destroy_object_action',
            'must'   => [qw(uid)],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw()],
        },
        'cipux_task_list_user_accounts' => {
            'desc'   => "List all user accounts.",
            'object' => [qw(cipux_account_object)],
            'action' => 'list_object_action',
            'must'   => [qw()],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cn)],                     # TODO: check if needed
            'filter' => {},
            'ltarget' => 'uid',
        },

        'cipux_task_list_members_of_user_account' => {
            'desc'   => "List all members of a given user account.",
            'object' => [qw(cipux_account_object)],
            'action' => 'list_object_attribute_action',
            'must'   => [qw(object)],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cn)],                     # TODO: check if needed
            'scope'  => 'one',
            'filter' =>
                { 'cipux_account.group' => { 'cipuxRole' => 'user', }, },
            'target' => { 'cipux_account.group' => { 'memberUid' => 0, }, },
            'ltarget' => 'memberUid',
        },

# cipux_ldap_set_value -a -t cipux_account.group -y memberUid=xxx -o bibeutlin
#mod filter [&(cn=bibeutlin)(objectClass=cipuxGroup)(cipuxIsAccount=TRUE)]
        'cipux_task_add_member_to_user_account' => {
            'desc'   => "Add a member to a given user account.",
            'object' => [qw(cipux_account_object)],
            'action' => 'change_object_attribute_action',
            'must'   => [qw(object attr value )],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cn)],    # TODO: check if needed
            'scope'  => 'one',
            'filter' =>
                { 'cipux_account.group' => { 'cipuxRole' => 'user', }, },
            'target'  => { 'cipux_account.group' => { 'memberUid' => 0, }, },
            'changes' => { 'cipux_account.group' => 'add', },
        },
        'cipux_task_remove_member_from_user_account' => {
            'desc'   => "Remove a member from a given user account.",
            'object' => [qw(cipux_account_object)],
            'action' => 'change_object_attribute_action',
            'must'   => [qw(object attr value )],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cn)],    # TODO: check if needed
            'scope'  => 'one',
            'filter' =>
                { 'cipux_account.group' => { 'cipuxRole' => 'user', }, },
            'target'  => { 'cipux_account.group' => { 'memberUid' => 0, }, },
            'changes' => { 'cipux_account.group' => 'delete', },
        },

        'cipux_task_change_user_account_password' => {
            'desc'   => "Change the password of a given user account.",
            'object' => [qw(cipux_account_object)],
            'action' => 'change_object_attribute_action',
            'must'   => [qw(object attr value )],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cn)],    # TODO: check if needed
            'scope'  => 'one',
            'filter' =>
                { 'cipux_account.user' => { 'cipuxRole' => 'user', }, },
            'target' => { 'cipux_account.user' => { 'userPassword' => 0, }, },
            'changes' => { 'cipux_account.user' => 'replace', },
        },

        # Not used after Dec 2008
        #'cipux_task_change_user_account_role' => {
        #    'desc'   => "Change the user account role.",
        #    'object' => [qw(cipux_account_object)],
        #    'action' => 'change_object_attribute_action',
        #    'must'   => [qw(object attr value )],
        #    'may'    => [qw()],
        #    'not'    => [qw()],
        #    'return' => [qw(cn)],      # TODO: check if needed
        #    'scope'  => 'one',
        #    'filter' =>
        #        { 'cipux_account.user' => { 'cipuxIsAccount' => 'TRUE', }, },
        #    'target' => { 'cipux_account.user' =>{'cipuxRole'=>0,}, },
        #    'changes' => { 'cipux_account.user' => 'replace', },
        #},

        'cipux_task_change_user_account_lastname' => {
            'desc'   => "Change the user account lastname.",
            'object' => [qw(cipux_account_object)],
            'action' => 'change_object_attribute_action',
            'must'   => [qw(object attr value )],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cipuxLastname)],
            'scope'  => 'one',
            'filter' =>
                { 'cipux_account.user' => { 'cipuxIsAccount' => 'TRUE', }, },
            'target' =>
                { 'cipux_account.user' => { 'cipuxLastname' => 0, }, },
            'changes' => { 'cipux_account.user' => 'replace', },
        },

        'cipux_task_change_user_account_firstname' => {
            'desc'   => "Change the user account firstname.",
            'object' => [qw(cipux_account_object)],
            'action' => 'change_object_attribute_action',
            'must'   => [qw(object attr value )],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cipuxFirstname)],
            'scope'  => 'one',
            'filter' =>
                { 'cipux_account.user' => { 'cipuxIsAccount' => 'TRUE', }, },
            'target' =>
                { 'cipux_account.user' => { 'cipuxFirstname' => 0, }, },
            'changes' => { 'cipux_account.user' => 'replace', },
        },

        'cipux_task_retrieve_all_user_account_homedir' => {
            'desc'   => "Get home directory info from all user accounts.",
            'object' => [qw(cipux_account_object)],
            'action' => 'list_all_attribute_action',
            'must'   => [qw()],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(homeDirectory)],
            'filter' => {},
            'scope'  => 'all',
            'target' =>
                { 'cipux_account.user' => { 'homeDirectory' => 0, }, },
            'ltarget' => 'uid',
        },

        'cipux_task_retrieve_all_user_account_firstname' => {
            'desc'   => 'Get firstname info from all user accounts.',
            'object' => [qw(cipux_account_object)],
            'action' => 'list_all_attribute_action',
            'must'   => [qw()],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cipuxFirstname)],
            'filter' => {},
            'scope'  => 'all',
            'target' =>
                { 'cipux_account.user' => { 'cipuxFirstname' => 0, }, },
            'ltarget' => 'uid',
        },
        'cipux_task_retrieve_all_user_account_lastname' => {
            'desc'   => "Get lastname info from all user accounts.",
            'object' => [qw(cipux_account_object)],
            'action' => 'list_all_attribute_action',
            'must'   => [qw()],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(uid cipuxLastname)],
            'filter' => {},
            'scope'  => 'all',
            'target' =>
                { 'cipux_account.user' => { 'cipuxLastname' => 0, }, },
            'ltarget' => 'uid',
        },
        'cipux_task_retrieve_all_user_account_lastname_firstname' => {
            'desc' => 'Get firstname, lastname info from all user accounts.',
            'object' => [qw(cipux_account_object)],
            'action' => 'list_all_attribute_action',
            'must'   => [qw()],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(uid cipuxLastname cipuxFirstname)],
            'scope'  => 'one',
            'filter' => {
                'cipux_account.group' => { 'objectClass' => 'cipuxAccount', },
            },
            'target' => {
                'cipux_account.user' => {
                    'cipuxLastname'  => 0,
                    'cipuxFirstname' => 0,
                },
            },
            'ltarget' => 'uid',
        },

       # TODO: replace main role with group based role
       # Concept of mainrole dropt in Dec 2008 in favor of multi role schema
       # However a non exclusive main role might reintroduced later
       #'cipux_task_retrieve_all_user_account_lastname_firstname_role' => {
       #    'desc' =>
       #        "Get first-, lastname and role info from all user accounts.",
       #    'object' => [qw(cipux_account_object)],
       #    'action' => 'list_all_attribute_action',
       #    'must'   => [qw()],
       #    'may'    => [qw()],
       #    'not'    => [qw()],
       #    'return' => [qw(uid cipuxLastname cipuxFirstname cipuxRole)],
       #    'filter' => {
       #        'cipux_account.group' => { 'objectClass' => 'cipuxAccount', },
       #    },
       #    'scope'  => 'all',
       #    'target' => {
       #        'cipux_account.user' => {
       #             'cipuxLastname'=>0,
       #             'cipuxFirstname'=>0,
       #             'cipuxRole'=>0,
       #        },
       #    },
       #},

        'cipux_task_retrieve_all_user_of_all_role' => {
            'desc'   => 'Get all users of all roles',
            'object' => [qw(cipux_role_object)],
            'action' => 'list_all_attribute_action',
            'must'   => [qw()],
            'may'    => [qw()],
            'not'    => [qw()],
            'return' => [qw(cn uid)],
            'scope'  => 'one',
            'filter' => {
                'cipux_role.group' => { 'groupType' => 'authority_group', },
            },
            'target' => { 'cipux_role.group' => { 'memberUid' => 0, }, },
            'ltarget' => 'uid',
        },
    },
};

#%config = (%{$config0_hr1},%{$config1_hr1},%{$config2_hr1});

#$cfg = \%config;

# CipUX CAT module modality:
foreach
    my $m (qw(admin student professor teacher assistant lecturer tutor pupil))
{

    # +-------------------------------------------------------------+
    # | basic user account                                          |
    # +-------------------------------------------------------------+
    my $o = $m;

    # possible hook to dispatch task name and role: $o =~ s{s$}{}smx;
    my $task = 'cipux_task_create_' . $o . '_account';
    $cfg->{task_api}->{$task} = {
        'desc'      => "Create a $o account.",
        'object'    => [qw(cipux_account_object)],
        'action'    => 'create_object_action',
        'must'      => [qw(uid cipuxFirstname cipuxLastname)],    # TODO
        'may'       => [qw(userPassword cipuxHomeDirectory)],     # TODO
        'not'       => [qw(cipuxRole cn uid)],                    # TODO
        'return'    => [qw()],                                    # TODO
        'overwrite' => {
            'cipux_account.user' => {
                'cipuxRemark' => 'CipUX task layer',
                'cipuxRole'   => "$m",
            },
            'cipux_account.group' => {
                'cipuxRemark' => 'CipUX task layer',
                'cipuxRole'   => "$m",
            },
        },
        'task' => {
            'post' => {
                'cipux_task_add_member_to_role_account' => {
                    'mode'    => 'exception',
                    'attr_hr' => {
                        object => "$m",          # role
                        value  => '@object@',    # member
                    },
                },

                # TODO OLD
                #'mode'    => 'exception',
                #'cmd_ar'  => ['cipux_task_add_member_to_role_account'],
                #'attr_ar' => [
                #    {
                #        object => "$m",          # role
                #        value  => '@object@',    # member
                #    },
                #],
            },
        },
        'dog' => {
            'post' => {
                'cipux_dog' => 'create_homedir',
                'user'      => '@object@',
                'role'      => "$m",
            },

        },
    };

    $task = 'cipux_task_destroy_' . $o . '_account';
    $cfg->{task_api}->{$task} = {
        'desc'   => "Destroy a $o account.",
        'object' => [qw(cipux_account_object)],
        'action' => 'destroy_object_action',
        'must'   => [qw(uid)],
        'may'    => [qw()],
        'not'    => [qw()],
        'return' => [qw()],
        'task'   => {
            'post' => {
                'cipux_task_remove_member_from_role_account' => {
                    'mode'    => 'exception',
                    'attr_hr' => {
                        object => "$m",          # role
                        value  => '@object@',    # member
                    },
                },

                # TODO OLD
                #'mode'    => 'exception',
                #'cmd_ar'  => ['cipux_task_remove_member_from_role_account'],
                #'attr_ar' => [
                #    {
                #        object => "$m",          # role
                #        value  => '@object@',    # member
                #    },
                #],
            },
        },
    };

    $task = 'cipux_task_list_' . $o . '_accounts';
    $cfg->{task_api}->{$task} = {
        'desc'       => "List all $o accounts.",
        'object'     => [qw(cipux_role_object)],
        'action'     => 'list_object_attribute_action',
        'must'       => [qw()],
        'may'        => [qw()],
        'not'        => [qw()],
        'return'     => [qw(memberUid)],
        'scope'      => 'one',
        'filter'     => { 'cipux_role.group' => { 'cn' => "$m", }, },
        'taskobject' => "$m",
        'target'     => { 'cipux_role.group' => { 'memberUid' => 0, }, },
        'ltarget'    => 'memberUid',
    };

    $task = 'cipux_task_list_members_of_' . $o . '_account';
    $cfg->{task_api}->{$task} = {
        'desc'   => "List all members of a given $o account.",
        'object' => [qw(cipux_account_object)],
        'action' => 'list_object_attribute_action',
        'must'   => [qw(object)],
        'may'    => [qw()],
        'not'    => [qw()],
        'return' => [qw(memberUid)],
        'scope'  => 'one',
        'filter' => { 'cipux_account.group' => { 'cipuxRole' => "$m", }, },
        'target' => { 'cipux_account.group' => { 'memberUid' => 0, }, },
        'ltarget' => 'memberUid',
    };

# cipux_ldap_set_value -a -t cipux_account.group -y memberUid=xxx -o bibeutlin
#mod filter [&(cn=bibeutlin)(objectClass=cipuxGroup)(cipuxIsAccount=TRUE)]
    $task = 'cipux_task_add_member_to_' . $o . '_account';
    $cfg->{task_api}->{$task} = {
        'desc'   => "Add a member to a given $o account.",
        'object' => [qw(cipux_account_object)],
        'action' => 'change_object_attribute_action',
        'must'   => [qw(object attr value )],
        'may'    => [qw()],
        'not'    => [qw()],
        'return' => [qw(cn)],    # TODO: check if needed
        'scope'  => 'one',
        'filter' => { 'cipux_account.group' => { 'cipuxRole' => "$m", }, },
        'target'  => { 'cipux_account.group' => { 'memberUid' => 0, }, },
        'changes' => { 'cipux_account.group' => 'add', },
    };

    $task = 'cipux_task_remove_member_from_' . $o . '_account';
    $cfg->{task_api}->{$task} = {
        'desc'   => "Remove a member from a given $o account.",
        'object' => [qw(cipux_account_object)],
        'action' => 'change_object_attribute_action',
        'must'   => [qw(object attr value )],
        'may'    => [qw()],
        'not'    => [qw()],
        'return' => [qw(cn)],    # TODO: check if needed
        'scope'  => 'one',
        'filter' => { 'cipux_account.group' => { 'cipuxRole' => "$m", }, },
        'target'  => { 'cipux_account.group' => { 'memberUid' => 0, }, },
        'changes' => { 'cipux_account.group' => 'delete', },
    };

    $task = 'cipux_task_change_' . $o . '_account_password';
    $cfg->{task_api}->{$task} = {
        'desc'   => "Change the password of a given $o account.",
        'object' => [qw(cipux_account_object)],
        'action' => 'change_object_attribute_action',
        'must'   => [qw(object attr value )],
        'may'    => [qw()],
        'not'    => [qw()],
        'return' => [qw(cn)],    # TODO: check if needed
        'scope'  => 'one',
        'filter' => { 'cipux_account.user' => { 'cipuxRole' => "$m", }, },
        'target'  => { 'cipux_account.user' => { 'userPassword' => 0, }, },
        'changes' => { 'cipux_account.user' => 'replace', },
    };

    # Concept of mainrole dropt in Dec 2008 in favor of multi role schema
    # However a non exclusive main role might reintroduced later
    #$task = 'cipux_task_retrieve_all_' . $o . '_account_mainrole';
    #$cfg->{task_api}->{$task} = {
    #    'desc'   => "Get lastname info from all $o accounts.",
    #    'object' => [qw(cipux_role_object)],
    #    'action' => 'list_object_attribute_action',
    #    'must'   => [qw()],
    #    'may'    => [qw()],
    #    'not'    => [qw()],
    #    'return' => [qw(cn)],
    #    'scope'  => 'one',
    #    'filter' => {
    #        'cipux_role.group' => {
    #            'groupType' => 'authority_group',
    #            'cn'        => "$m"
    #        },
    #    },
    #    'taskobject' => "$m",
    #    'target'     => { 'cipux_role.group' => {'memberUid'=>0,}, },
    #    'subtarget' =>
    #        { 'cipux_account.user' => [qw(cipuxRole)], },
    #    'subfilter' =>
    #        { 'cipux_account.user' => { objectClass => 'cipuxAccount' } },
    #};

    $task = 'cipux_task_change_' . $o . '_account_role';
    $cfg->{task_api}->{$task} = {
        'desc'   => "Change the $o account role.",
        'object' => [qw(cipux_account_object)],
        'action' => 'change_object_attribute_action',
        'must'   => [qw(object attr value )],
        'may'    => [qw()],
        'not'    => [qw()],
        'return' => [qw(cn)],                          # TODO: check if needed
        'scope'  => 'one',
        'filter' =>
            { 'cipux_account.user' => { 'cipuxIsAccount' => 'TRUE', }, },
        'target'  => { 'cipux_account.user' => { 'cipuxRole' => 0, }, },
        'changes' => { 'cipux_account.user' => 'replace', },
    };

    $task = 'cipux_task_retrieve_all_' . $o . '_account_homedir';
    $cfg->{task_api}->{$task} = {
        'desc'   => "Get lastname info from all $o accounts.",
        'object' => [qw(cipux_role_object)],
        'action' => 'list_object_attribute_action',
        'must'   => [qw()],
        'may'    => [qw()],
        'not'    => [qw()],
        'return' => [qw(cn)],
        'scope'  => 'one',
        'filter' => {
            'cipux_role.group' => {
                'groupType' => 'authority_group',
                'cn'        => "$m"
            },
        },
        'taskobject' => "$m",
        'target'     => { 'cipux_role.group' => { 'memberUid' => 0, }, },
         'ltarget' => 'uid',
        'subtarget' => { 'cipux_account.user' => { 'homeDirectory' => 0, }, },
        'subfilter' =>
            { 'cipux_account.user' => { objectClass => 'cipuxAccount' } },
    };

    $task = 'cipux_task_retrieve_all_' . $o . '_account_firstname';
    $cfg->{task_api}->{$task} = {
        'desc'   => "Get firstname info from all $o accounts.",
        'object' => [qw(cipux_role_object)],
        'action' => 'list_object_attribute_action',
        'must'   => [qw()],
        'may'    => [qw()],
        'not'    => [qw()],
        'return' => [qw(cn)],
        'scope'  => 'one',
        'filter' => {
            'cipux_role.group' => {
                'groupType' => 'authority_group',
                'cn'        => "$m"
            },
        },
        'taskobject' => "$m",
        'target'     => { 'cipux_role.group' => { 'memberUid' => 0, }, },
         'ltarget' => 'uid',
        'subtarget' =>
            { 'cipux_account.user' => { 'cipuxFirstname' => 0, }, },
        'subfilter' =>
            { 'cipux_account.user' => { objectClass => 'cipuxAccount' } },
    };

    $task = 'cipux_task_retrieve_all_' . $o . '_account_lastname';
    $cfg->{task_api}->{$task} = {
        'desc'   => "Get lastname info from all $o accounts.",
        'object' => [qw(cipux_role_object)],
        'action' => 'list_object_attribute_action',
        'must'   => [qw()],
        'may'    => [qw()],
        'not'    => [qw()],
        'return' => [qw(cn)],
        'scope'  => 'one',
        'filter' => {
            'cipux_role.group' => {
                'groupType' => 'authority_group',
                'cn'        => "$m"
            },
        },
        'taskobject' => "$m",
        'target'     => { 'cipux_role.group' => { 'memberUid' => 0, }, },
         'ltarget' => 'uid',
        'subtarget' => { 'cipux_account.user' => { 'cipuxLastname' => 0, }, },
        'subfilter' =>
            { 'cipux_account.user' => { objectClass => 'cipuxAccount' } },
    };

    # Most used task with sub task section
    $task = 'cipux_task_retrieve_all_' . $o . '_account_lastname_firstname';
    $cfg->{task_api}->{$task} = {
        'desc'   => "Get firstname and lastname info from all $o accounts.",
        'object' => [qw(cipux_role_object)],
        'action' => 'list_object_attribute_action',
        'must'   => [qw()],
        'may'    => [qw()],
        'not'    => [qw()],
        'return' => [qw(cn)],
        'scope'  => 'one',
        'filter' => {
            'cipux_role.group' => {
                'groupType' => 'authority_group',
                'cn'        => "$m"
            },
        },
        'taskobject' => "$m",
        'target'     => { 'cipux_role.group' => { 'memberUid' => 0, }, },
         'ltarget' => 'uid',

        # This task has a sub task section 'subtarget' and 'subfilter' with
        # defines the sub task. In general it means that the above target
        # 'memberUid' will be used as a positive list against all accounts
        # queried by the subfilter. The result is in alphabetical order.
        #
        # Example:
        # 1 task gives:
        #     memberUid: user1
        #     memberUid: user2
        # 2 task gives:
        #     uid user1, cipuxFirstname: fn1, cipuxLastname: ln1
        #     uid user2, cipuxFirstname: fn2, cipuxLastname: ln2
        #     uid user3, cipuxFirstname: fn3, cipuxLastname: ln3
        # Then the line 3 will be filtered because 'uid' is not in list
        # 'memberUid' The output will be lines 1-2
        'subtarget' => {
            'cipux_account.user' => {
                'cipuxLastname'  => 0,
                'cipuxFirstname' => 0,
            },
        },
        'subfilter' =>
            { 'cipux_account.user' => { objectClass => 'cipuxAccount' } },
    };
    $task
        = 'cipux_task_retrieve_all_' 
        . $o
        . '_account_lastname_firstname_role';
    $cfg->{task_api}->{$task} = {
        'desc'   => "Get firstname and lastname info from all $o accounts.",
        'object' => [qw(cipux_role_object)],
        'action' => 'list_object_attribute_action',
        'must'   => [qw()],
        'may'    => [qw()],
        'not'    => [qw()],
        'return' => [qw(cn)],
        'scope'  => 'one',
        'filter' => {
            'cipux_role.group' => {
                'groupType' => 'authority_group',
                'cn'        => "$m"
            },
        },
        'taskobject' => "$m",
        'target'     => { 'cipux_role.group' => ['memberUid'], },
         'ltarget' => 'uid',
        'subtarget'  => {
            'cipux_account.user' => {
                cipuxLastname  => 0,
                cipuxFirstname => 0,
                cipuxRole      => 0,
            },
        },
        'subfilter' =>
            { 'cipux_account.user' => { objectClass => 'cipuxAccount' } },
    };
}

# +-------------------------------------------------------------------------+
# | basic group                                                             |
# +-------------------------------------------------------------------------+

# CipUX CAT module modality:

for my $g (
    qw(course class studygroup seminar lecture reading workshop tutorial team)
    )
{

    # +-----------------------------------------------------------------+
    # | basic group share                                               |
    # +-----------------------------------------------------------------+

    my $task = 'cipux_task_create_' . $g . '_share';
    $cfg->{task_api}->{$task} = {
        'desc'      => "Create $g share account.",
        'object'    => [qw(cipux_share_object)],
        'action'    => 'create_object_action',
        'must'      => [qw(cn)],                     # TODO
        'may'       => [qw(userPassword)],           # TODO
        'not'       => [qw(cipuxRole cn uid)],       # TODO
        'return'    => [qw()],                       # TODO
        'overwrite' => {
            'cipux_share.user' => {
                'cipuxRemark' => 'CipUX task layer',
                'cipuxRole'   => $g,
            },
            'cipux_share.group' => {
                'cipuxRemark' => 'CipUX task layer',
                'cipuxRole'   => $g,
            },
        },
        'dog' => {
            'post' => {
                'cipux_dog' => 'create_homedir',
                'user'      => '@object@',
                'role'      => "$g",
            },
        },
    };
    $task = 'cipux_task_destroy_' . $g . '_share';
    $cfg->{task_api}->{$task} = {
        'desc'   => "Destroy $g share account.",
        'object' => [qw(cipux_share_object)],
        'action' => 'destroy_object_action',
        'must'   => [qw(cn)],
        'may'    => [qw()],
        'not'    => [qw()],
        'return' => [qw()],
    };

    # mod filter
    # [&(uid=*)
    #   (objectClass=cipuxAccount)
    #   (cipuxIsShare=TRUE)
    #   (cipuxRole=course)]
    $task = 'cipux_task_list_' . $g . '_shares';
    $cfg->{task_api}->{$task} = {
        'desc'   => "List all $g share accounts.",
        'object' => [qw(cipux_share_object)],
        'action' => 'list_object_action',
        'must'   => [qw()],
        'may'    => [qw()],
        'not'    => [qw()],
        'return' => [qw(uid cn)],
        'filter' => {
            'cipux_share.user'  => { 'cipuxRole' => $g, },
            'cipux_share.group' => { 'cipuxRole' => $g, },
        },
        'ltarget' => 'uid',
    };

    # cipux_ldap_get_value  -t cipux_share.group -o class84 -y memberUid
    # mod filter [&(cn=class84)(objectClass=cipuxGroup)(cipuxIsShare=TRUE)
    $task = 'cipux_task_list_members_of_' . $g . '_share';
    $cfg->{task_api}->{$task} = {
        'desc'   => "List all members of a given $g share account.",
        'object' => [qw(cipux_share_object)],
        'action' => 'list_object_attribute_action',
        'must'   => [qw(object)],
        'may'    => [qw()],
        'not'    => [qw()],
        'return' => [qw(memberUid)],
        'scope'  => 'one',
        'filter' => { 'cipux_share.group' => { 'cipuxRole' => $g, }, },
        'target' => { 'cipux_share.group' => { 'memberUid' => 0, }, },
        'ltarget' => 'memberUid',
    };

    # cipux_ldap_set_value -a -t cipux_share.group -y memberUid=xxx -o class85
    #mod filter [&(cn=class85)(objectClass=cipuxGroup)(cipuxIsShare=TRUE)]
    $task = 'cipux_task_add_member_to_' . $g . '_share';
    $cfg->{task_api}->{$task} = {
        'desc'   => "Add a  member to a given $g share account.",
        'object' => [qw(cipux_share_object)],
        'action' => 'change_object_attribute_action',
        'must'   => [qw(object attr value )],
        'may'    => [qw()],
        'not'    => [qw()],
        'return' => [qw(cn)],    # TODO: check if needed
        'scope'  => 'one',
        'filter' => { 'cipux_share.group' => { 'cipuxRole' => $g, }, },
        'target'  => { 'cipux_share.group' => { 'memberUid' => 0, }, },
        'changes' => { 'cipux_share.group' => 'add', },
    };

    $task = 'cipux_task_remove_member_from_' . $g . '_share';
    $cfg->{task_api}->{$task} = {
        'desc'   => "Remove a member from a given $g share account.",
        'object' => [qw(cipux_share_object)],
        'action' => 'change_object_attribute_action',
        'must'   => [qw(object attr value )],
        'may'    => [qw()],
        'not'    => [qw()],
        'return' => [qw(cn)],    # TODO: check if needed
        'scope'  => 'one',
        'filter' => { 'cipux_share.group' => { 'cipuxRole' => $g, }, },
        'target'  => { 'cipux_share.group' => { 'memberUid' => 0, }, },
        'changes' => { 'cipux_share.group' => 'delete', },
    };

    # 'cipux_task_remove_user_from_course_share',
    # 'cipux_task_list_user_nonmembers_of_course_share',

    $task = 'cipux_task_change_' . $g . '_share_password';
    $cfg->{task_api}->{$task} = {
        'desc'   => "Change the password of a given $g account.",
        'object' => [qw(cipux_share_object)],
        'action' => 'change_object_attribute_action',
        'must'   => [qw(object attr value )],
        'may'    => [qw()],
        'not'    => [qw()],
        'return' => [qw(cn)],    # TODO: check if needed
        'scope'  => 'one',
        'filter' => { 'cipux_share.user' => { 'cipuxRole' => "$g", }, },
        'target'  => { 'cipux_share.user' => { 'userPassword' => 0, }, },
        'changes' => { 'cipux_share.user' => 'replace', },
    };
}

# ALIAS task
my $alias = 'cipux_task_change_user_account_password_interactive';
my $task  = 'cipux_task_change_user_account_password';
$cfg->{task_api}->{$alias} = $cfg->{task_api}->{$task};
$alias = 'cipux_task_change_own_password_interactive';
$cfg->{task_api}->{$alias} = $cfg->{task_api}->{$task};

undef $task;
undef $alias;

return $cfg;
