/*
** Routine for putting a picture file on the root window. Uses Imlib.
** ff, 1998.
*/

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <Imlib.h>


int set_file(char *name, int stretch)
{
	Display *display;
	ImlibData *id;
	Window window;
	ImlibImage *im;
	Pixmap p, m;
	int w, h, rw, rh, screen;

	display = XOpenDisplay(NULL);

	id = Imlib_init(display);

	if((im = Imlib_load_image(id, name))==NULL)
		return 1;

	window = DefaultRootWindow(display);
	screen = DefaultScreen(display);

	rw = DisplayWidth(display, screen);
	rh = DisplayHeight(display, screen);

	if(stretch == 1) {
		w = rw;
		h = rh;
	} else {
		w = im->rgb_width;
		h = im->rgb_height;
	}

	XSelectInput(display, window, StructureNotifyMask);

	Imlib_render(id, im, w, h);

	p = Imlib_move_image(id, im);
	m = Imlib_move_mask(id, im);

	XSetWindowBackgroundPixmap(display, window, p);

	if (m) XShapeCombineMask(display, window, ShapeBounding,
		0, 0, m, ShapeSet);

	XMapWindow(display, window);
	XClearWindow(display, window);

/* Free the buffers that Imlib allocated... */
	Imlib_kill_image(id, im);
	Imlib_free_pixmap(id, p);
	Imlib_free_pixmap(id, m);

	XCloseDisplay(display);
	return 0;
}
