/***************************************************************************
                          bridgecfg.h  -  description
                             -------------------
    begin                : Mon Nov 18 2002
    copyright            : (C) 2002 by Ken Schenke
    email                : kschenke at users dot sourceforge dot net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software           *
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA         *
 *   02110-1301, USA                                                       *
 *                                                                         *
 ***************************************************************************/

#ifndef BRIDGECFG_H
#define BRIDGECFG_H

#include "bknode.h"
#include "bkexcept.h"

#include <vector>
#include <qstring.h>

/***************************************************************************
 *                                                                         *
 *   This class stores configuration information on a browser.             *
 *                                                                         *
 ***************************************************************************/

class BrowserCfg
{
public:
	BrowserCfg() : m_readOnly(false)
	{
		m_ordinal = rand();
	}
	BrowserCfg(const BrowserCfg &cfg) :
		m_browser(cfg.m_browser),
		m_browserNum(cfg.m_browserNum),
		m_Descrip(cfg.m_Descrip),
		m_Location(cfg.m_Location),
		m_readOnly(cfg.m_readOnly),
		m_ordinal(cfg.m_ordinal)
	{ };
	~BrowserCfg() { };

	BrowserCfg & operator=(const BrowserCfg &cfg)
	{
		m_browser = cfg.m_browser;
		m_Descrip = cfg.m_Descrip;
		m_Location = cfg.m_Location;
		m_readOnly = cfg.m_readOnly;
		m_browserNum = cfg.m_browserNum;
		m_ordinal = cfg.m_ordinal;

		return *this;
	}

	bool		operator==(BRWSNUM ordinal) { return m_ordinal == ordinal; }

	QString		browser(void) const { return m_browser; }
	BRWSTYPE	browserNum(void) const { return m_browserNum; }
	QString		Descrip(void) const { return m_Descrip; }
	QString		Location(void) const { return m_Location; }
	bool		readOnly(void) const { return m_readOnly; }
	BRWSNUM		ordinal(void) const { return m_ordinal; }

	void		setBrowser(const QString &browser) { m_browser = browser; }
	void		setBrowserNum(BRWSTYPE browserNum) { m_browserNum = browserNum; }
	void		setDescrip(const QString &descrip) { m_Descrip = descrip; }
	void		setLocation(const QString &location) { m_Location = location; }
	void		setReadOnly(bool readOnly) { m_readOnly = readOnly; }
	void		setOrdinal(BRWSNUM ordinal) { m_ordinal = ordinal; }

private:
	QString		m_browser;
	BRWSTYPE	m_browserNum;
	QString		m_Descrip;
	QString		m_Location;
	bool		m_readOnly;
	BRWSNUM		m_ordinal;
};

/***************************************************************************
 *                                                                         *
 *   This class stores configuration for BookmarkBridge.                   *
 *                                                                         *
 ***************************************************************************/

class BridgeCfg
{
public:
	BridgeCfg() throw(BkException)
		: ConfigFileName(""), XbelFileName("") { findConfigFile(); }
	BridgeCfg(const BridgeCfg &cfg) :
		browsers(cfg.browsers),
		sources(cfg.sources),
		destinations(cfg.destinations),
		DataDir(cfg.DataDir)
#ifdef Q_WS_WIN
//		,appdatadir(cfg.appdatadir),
		,m_AppDataDir(cfg.m_AppDataDir),
		m_FavoritesDir(cfg.m_FavoritesDir),
		m_ProgFilesDir(cfg.m_ProgFilesDir)
#endif
		{ }

	BridgeCfg & operator=(const BridgeCfg &cfg)
	{
		browsers = cfg.browsers;
		sources = cfg.sources;
		destinations = cfg.destinations;
		DataDir = cfg.DataDir;
#ifdef Q_WS_WIN
//		appdatadir = cfg.appdatadir;
		m_AppDataDir = cfg.m_AppDataDir;
		m_ProgFilesDir = cfg.m_ProgFilesDir;
		m_FavoritesDir = cfg.m_FavoritesDir;
#endif

		return *this;
	}

	void		readBookmarksXbel(BkFolder **root) throw(BkException);
	void		readConfig(void) throw(BkException);
	void		writeBookmarksXbel(const BkFolder &root) throw(BkException);
	void		writeConfig(void) throw(BkException);

	std::vector<BrowserCfg>
				browsers;
	std::vector<BRWSNUM>
				sources;
	std::vector<BRWSNUM>
				destinations;

	QString		DataDir;
#ifdef Q_WS_WIN
//	std::string appdatadir;		// Application Data directory (Windows)
	QString m_AppDataDir;
	QString m_FavoritesDir;		// Favorites directory (Windows)
	QString m_ProgFilesDir;		// Program Files directory (Windows)
#endif

private:
	QString		ConfigFileName;
	QString		XbelFileName;
	bool		configFileExists;
	bool		xbelFileExists;

	void		findConfigFile(void) throw(BkException);
#ifdef Q_WS_WIN
	void		InitMemberVars(void) throw(BkException);
#endif
	void		InitDefaults(void) throw(BkException);
};

#endif  // end of BRIDGECFG_H
