package aQute.junit.runtime;

import java.io.*;
import java.util.*;
import java.util.regex.*;

import junit.framework.*;

import org.osgi.framework.*;

public class XMLReport implements TestReporter {
    final File        file;
    final PrintStream out;
    List             /* <Test> */tests;
    boolean           open;

    public XMLReport(String reportName) throws FileNotFoundException {
        file = new File(reportName);
        out = new PrintStream(new FileOutputStream(file));
    }

    public void begin(Bundle fw, Bundle targetBundle, List classNames, int realcount) {
        out.println("<?xml version='1.0'?>");
        out.println("<testreport" );
        out.println("    target='"+targetBundle.getLocation()+"'");
        out.println("    time='"+new Date()+"' ");
        out.println("    framework='"+fw+"'>");
        Bundle [] bundles = fw.getBundleContext().getBundles();
        for ( int i =0; i<bundles.length; i++ ) {
            out.println("  <bundle location='"+bundles[i].getLocation()+"' ");
            out.println("     modified='"+bundles[i].getLastModified()+"' ");
            out.println("     state='"+bundles[i].getState()+"' ");
            out.println("     id='"+bundles[i].getBundleId()+"' ");
            out.println("     bsn='"+bundles[i].getSymbolicName()+"' ");
            out.println("     version='"+bundles[i].getHeaders().get("Bundle-Version")+"' ");
            out.println("  />");
        }
    }

    public void end() {
        out.println("</testreport>");
        out.close();
    }

    public void setTests(List flattened) {
        this.tests = flattened;
    }

    static Pattern TEST_NAME = Pattern.compile("(.+)\\((.+)\\)");
    public void startTest(Test test) {
        String nameAndClass = test.toString();
        String name = nameAndClass;
        String clazz="";
        Matcher m = TEST_NAME.matcher(nameAndClass);
        if ( m .matches() ) {
            name = m.group(1);
            clazz=m.group(2);
        }
        out.print("  <test name='" + name + "' class='" + clazz +"'");
        open = true;
    }

    public void addError(Test test, Throwable t) {
        if (open)
            out.println(">");
        open = false;
        out.println(" <error name='" + test.toString() + "' type='" + t.getClass().getName() + "'>");
        out.println("<![CDATA[");
        t.printStackTrace(out);
        out.println("]]>");
        out.println(" </error>");
    }

    public void addFailure(Test test, AssertionFailedError t) {
        if (open)
            out.println(">");
        open = false;
        out.println(" <failure name='" + test.toString() + "' type='" + t.getClass().getName() + "'>");
        out.println("<![CDATA[");
        t.printStackTrace(out);
        out.println("]]>");
        out.println(" </failure>");
    }

    public void endTest(Test test) {
        if (open)
            out.println("/>");
        else
            out.println("  </test>");
        open = false;
    }

    public void aborted() {
        if ( open ) {
            out.close();
            file.delete();
            System.out.println("Aborted, deleted file: " + file.getAbsolutePath() );
        }
    }

}
