/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "libraries.h"
#include "pdfviewer.h"
#include <gtk/gtk.h>
#include "gtkwrappers.h"
#include "unixwrappers.h"
#include "shell.h"
#include "uname.h"
#include "windowsoutpost.h"
#include "gwrappers.h"


void pdfviewer (const ustring& filename)
{
  
  // Handle Windows.
  if (uname_get () == untCygwin) {
    windowsoutpost_open_url (filename_modify_if_cygwin (filename));
    return; 
  }

  // Information about viewers on Linux and Macintosh.
  struct { char * command; char *argument; } pdf_viewers [] = 
  {
    { "acroread", "" },
    { "evince", "" },
    { "xpdf", "-paper match" },
    { "ghostview", "" },
    { "gpdf", "" },
    { "kpdf", "" },
    { "kghostview", "" },
    { "open", "" }
  };

  // Handle Unix.
  for (unsigned int i = 0; i < (sizeof (pdf_viewers) / sizeof (* pdf_viewers)); i++)
  {
    if (gw_find_program_in_path (pdf_viewers [i].command)) {
      ustring cmd = pdf_viewers [i].command;
      cmd.append (" ");
      cmd.append (pdf_viewers[i].argument);
      cmd.append (shell_quote_space (filename));
      cmd.append ("> /dev/null &");
      system (cmd.c_str ());
      return;
    }
  }

  // If we're here, it shows that no suitable viewer was found.
  // Inform the user about it, and what to do to solve it.
  ustring message = "The file cannot be displayed, because there is no suitable pdf viewer installed.\n";
  message.append ("Install one of the following supported pdf viewers:\n");
  for (unsigned int i = 0; i < (sizeof (pdf_viewers) / sizeof (* pdf_viewers)); i++) {
    message.append (pdf_viewers[i].command);
    message.append ("\n");
  }
  gtkw_dialog_error (NULL, message);
}
