
/*
 * Generated data (by mkcproc.pl)
 */
#line 1 "bseparasite.proc"

#include <bse/bseparasite.h>
#include <bse/bseprocedure.h>
#include <bse/bseexports.h>

#line 25 "bseparasite.proc"

/* --- list-parasites --- */
static void
list_parasites_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 26 "bseparasite.proc"
 {
#line 28 "bseparasite.proc"
  *(in_pspecs++)    = bse_param_spec_object ("item", _("Item"), NULL, BSE_TYPE_ITEM, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("path", _("Path"), NULL, NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("paths", _("Parasite Paths"), NULL, BSE_TYPE_STRING_SEQ, SFI_PARAM_STANDARD);
#line 31 "bseparasite.proc"
}  }
static BseErrorType
#line 31 "bseparasite.proc"
list_parasites_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 34 "bseparasite.proc"
{
  BseItem     *item = g_value_get_object (in_values++);
  const gchar *path = g_value_get_string (in_values++);
  SfiRing *ring;
  BseStringSeq *sseq;
  if (!BSE_IS_ITEM (item))
    return BSE_ERROR_PROC_PARAM_INVAL;
  sseq = bse_string_seq_new ();
  ring = bse_item_list_parasites (item, path);
  while (ring)
    bse_string_seq_append (sseq, sfi_ring_pop_head (&ring));
  bse_value_take_boxed (out_values++, sseq);
  return BSE_ERROR_NONE;
}

/* --- get-parasite --- */
static void
get_parasite_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 49 "bseparasite.proc"
 {
#line 50 "bseparasite.proc"
  SfiRecFields zero_fields = { 0, };
#line 52 "bseparasite.proc"
  *(in_pspecs++) = bse_param_spec_object ("item", _("Item"), NULL, BSE_TYPE_ITEM, SFI_PARAM_STANDARD);
  *(in_pspecs++) 	= sfi_pspec_string ("path", _("Path"), NULL, NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_rec ("parasite", _("Parasite"), NULL, zero_fields, SFI_PARAM_STANDARD);
#line 55 "bseparasite.proc"
}  }
static BseErrorType
#line 55 "bseparasite.proc"
get_parasite_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 58 "bseparasite.proc"
{
  BseItem     *item = g_value_get_object (in_values++);
  const gchar *path = g_value_get_string (in_values++);
  if (!BSE_IS_ITEM (item))
    return BSE_ERROR_PROC_PARAM_INVAL;
  sfi_value_set_rec (out_values++, bse_item_get_parasite (item, path));
  return BSE_ERROR_NONE;
}

/* --- set-parasite --- */
static void
set_parasite_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 67 "bseparasite.proc"
 {
#line 68 "bseparasite.proc"
  SfiRecFields zero_fields = { 0, };
#line 70 "bseparasite.proc"
  *(in_pspecs++)    = bse_param_spec_object ("item", _("Item"), NULL, BSE_TYPE_ITEM, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("path", _("Path"), NULL, NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_rec ("parasite", _("Parasite"), NULL, zero_fields, SFI_PARAM_STANDARD);
#line 73 "bseparasite.proc"
}  }
static BseErrorType
#line 73 "bseparasite.proc"
set_parasite_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 76 "bseparasite.proc"
{
  BseItem     *item = g_value_get_object (in_values++);
  const gchar *path = g_value_get_string (in_values++);
  SfiRec      *rec  = sfi_value_get_rec (in_values++);
  if (!BSE_IS_ITEM (item))
    return BSE_ERROR_PROC_PARAM_INVAL;
  bse_item_set_parasite (item, path, rec);
  return BSE_ERROR_NONE;
}

/* --- add-parasite --- */
static void
add_parasite_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 86 "bseparasite.proc"
 {
#line 87 "bseparasite.proc"
  SfiRecFields zero_fields = { 0, };
#line 89 "bseparasite.proc"
  *(in_pspecs++)    = bse_param_spec_object ("item", _("Item"), NULL, BSE_TYPE_ITEM, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("path", _("Path"), NULL, NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_rec ("parasite", _("Parasite"), NULL, zero_fields, SFI_PARAM_STANDARD);
#line 92 "bseparasite.proc"
}  }
static BseErrorType
#line 92 "bseparasite.proc"
add_parasite_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 95 "bseparasite.proc"
{
  BseItem     *item = g_value_get_object (in_values++);
  const gchar *path = g_value_get_string (in_values++);
  SfiRec      *rec  = sfi_value_get_rec (in_values++);
  if (!BSE_IS_ITEM (item))
    return BSE_ERROR_PROC_PARAM_INVAL;
  path = bse_item_create_parasite_name (item, path);
  if (path)
    bse_item_set_parasite (item, path, rec);
  g_print ("%s: %s: %p\n", G_STRFUNC, path, rec);
  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
static void
__enode_list_parasites__fill_strings (BseExportStrings *es)
{
  es->blurb = "List parasites within a parasite path segment.";
  es->file = "/opt/src/beast/bse/bseparasite.proc";
  es->line = 27;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_list_parasites = {
  { NULL, BSE_EXPORT_NODE_PROC,
    "BseItem+list-parasites", 
    NULL,
    "/Methods/BseItem/General/List Parasites",
    NULL,
    __enode_list_parasites__fill_strings,
  },
  0, list_parasites_setup, list_parasites_exec, 
};
static void
__enode_get_parasite__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve a parasite from an item.";
  es->file = "/opt/src/beast/bse/bseparasite.proc";
  es->line = 51;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_parasite = {
  { (BseExportNode*) &__enode_list_parasites, BSE_EXPORT_NODE_PROC,
    "BseItem+get-parasite", 
    NULL,
    "/Methods/BseItem/General/Get Parasite",
    NULL,
    __enode_get_parasite__fill_strings,
  },
  0, get_parasite_setup, get_parasite_exec, 
};
static void
__enode_set_parasite__fill_strings (BseExportStrings *es)
{
  es->blurb = "Set or change a parasite on an item.";
  es->file = "/opt/src/beast/bse/bseparasite.proc";
  es->line = 69;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_set_parasite = {
  { (BseExportNode*) &__enode_get_parasite, BSE_EXPORT_NODE_PROC,
    "BseItem+set-parasite", 
    NULL,
    "/Methods/BseItem/General/Set Parasite",
    NULL,
    __enode_set_parasite__fill_strings,
  },
  0, set_parasite_setup, set_parasite_exec, 
};
static void
__enode_add_parasite__fill_strings (BseExportStrings *es)
{
  es->blurb = "Add a new parasite to an item.";
  es->file = "/opt/src/beast/bse/bseparasite.proc";
  es->line = 88;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_add_parasite = {
  { (BseExportNode*) &__enode_set_parasite, BSE_EXPORT_NODE_PROC,
    "BseItem+add-parasite", 
    NULL,
    "/Methods/BseItem/General/Add Parasite",
    NULL,
    __enode_add_parasite__fill_strings,
  },
  0, add_parasite_setup, add_parasite_exec, 
};
BseExportNode* bse__builtin_init_bseparasite_genprc_c (void);
BseExportNode* bse__builtin_init_bseparasite_genprc_c (void)
{
  return (BseExportNode*) &__enode_add_parasite;
}

/*
 * Generated data ends here
 */
