
/* autopano-sift, Automatic panorama image creation
 * Copyright (C) 2004 -- Sebastian Nowozin
 *
 * This program is free software released under the GNU General Public
 * License, which is included in this software package (doc/LICENSE).
 */

public abstract class BasicImagingInterface
{
	public abstract int Width {
		get;
	}
	public abstract int Height {
		get;
	}

	// Downscale image so both x/y dimension are <= downsizeResolution. Use
	// best-quality scaling algorithm. Return floating point scale used.
	public abstract double ScaleWithin (int downsizeResolution);

	// Create an ImageMap object from it.
	public abstract ImageMap ConvertToImageMap (IPixelConverter pconv);
}

public interface IPixelConverter
{
	double Convert (byte r, byte g, byte b);
}

internal class CanonicalPixelConverter : IPixelConverter
{
	public double Convert (byte r, byte g, byte b)
	{
		// 1/3 and normalize to 0.0 - 1.0 range
		return ((r + g + b) / (255.0 * 3.0));
	}
}

