#!/usr/bin/env python

# Copyright (C) Andrew Mitchell 2006

#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.

#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
############################################################################

## client side: enable winbind

# manage /etc/samba/samba.conf
from AuthTool import samba, config, authtools
import debconf, sys, os


config.methods['Winbind'] = 'Samba/Winbind configuration'

class WinbindConfig(authtools.IAuthConfig):
    name = "Winbind"
    requires = []
    display = False

    def __init__(self, authconfig):
        self.cfg = authconfig
        self.db = authtools.Debconf()
        self.smb = samba.SambaConfig()

        authtools.IAuthConfig.__init__(self,authconfig)

    def config(self):
        """
        Return a list of configuration options in a standardised format
        {'id':['type','label',default','options'],...}
        """

        # Pull defaults from existing config
        cfg = {
            'domain':['string', 'Domain/Workgroup','LOCALDOMAIN',''],
            'realm':['string', 'AD Realm','localdomain',''],
            'idmap_uid':['string', 'User ID Map','10000-20000',''],
            'idmap_gid':['string', 'Group ID Map','10000-20000',''],
            'ads_server':['string', 'AD Server','win2k3.localdomain',''],
            'admin':['string','Administrator','Administrator',''],
            'admin_password':['password','Admin password','password','']
             }

        return cfg

    def store(self, id, data):
        #print "Storing %s:%s" % (id,data)
        # This should really avoid setting the samba configuration during editing
        if id == 'domain':
            self.smb.cf.set('global', "workgroup",data)
        elif id == 'realm':
            self.smb.cf.set('global', "realm",data)
        elif id =='ads_server':
            self.smb.cf.set('global', 'password server', data)
        elif id =='idmap_uid':
            self.smb.cf.set('global', 'idmap uid', data)
        elif id =='idmap_gid':
            self.smb.cf.set('global', 'idmap gid', data)
            
        elif id == 'admin':
            self.admin = data
        elif id == 'admin_password':
            self.admin_password = data
            
        authtools.IAuthConfig.store(self, id, data)


    def enable(self):
        #self.smb.cf.set('global', "security","ads")
        #self.smb.cf.set('global', "workgroup","localdomain")
        #self.smb.dump()

        #for key in self.persistent:
        #    try:
        #        self.store(key, self.get(key))

        self.save()
        
        self.smb.save()

        #print "Reloading daemons"
        os.spawnl(os.P_WAIT, "/usr/sbin/invoke-rc.d", "invoke-rc.d", "winbind", "force-reload")
        os.spawnl(os.P_WAIT, "/usr/sbin/invoke-rc.d", "invoke-rc.d", "samba",   "reload")
        
    

    
