#!/usr/bin/env python
# Copyright (C) Andrew Mitchell 2006

#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.

#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
############################################################################

## Configure /etc/{passwd,group,shadow} ##
# The main purpose of this is to have a line like '+::::::' in /etc/passwd


import sys, preserve

class IConfig:
    fn = '/tmp/info'

    def __init__(self):
        fh = open(self.fn)
        self.lines = fh.readlines()
        lines2=[]
        for line in self.lines:
            # test for comment
            #print self.lines[self.lines.index(line)].strip()
            lines2.append(line.strip())

        #print self.lines
        self.lines = lines2
        fh.close()


    def enable(self, opt):
        if opt == 'nis':
            # turn on nis compat stuff in self.fn
            pass

    def save(self):
        preserve.preserve(self.fn)
        try:
            fh = open(self.fn, "w")
        except IOError:
            fh = sys.stderr
        for line in self.lines:
            line += '\n'
            fh.write(line)
        if fh != sys.stderr:
            fh.close()


class PasswdConfig(IConfig):
    fn = '/etc/passwd'
    nis_line = '+::::::'

class GroupConfig(IConfig):
    fn = '/etc/group'
    nis_line = '+:::'

class ShadowConfig(IConfig):
    fn = '/etc/shadow'
    nis_line = '+::::::::'

        
if __name__=="__main__":
    pwd = PasswdConfig()
    pwd.enable('nis')
    pwd.save()    
    grp = GroupConfig()
    grp.enable('nis')
    grp.save()    
    shd = ShadowConfig()
    shd.enable('nis')
    shd.save()    


        
