#ifndef MATRIX_H
#define MATRIX_H

#define MATRIX_FULL (103)
#define MATRIX (102)
#define SNOW (101)

#ifdef MATRIX_C
#include <string.h>
#include "slangwrap.h"
#include "xfnc.h"

struct column;
struct column {
	struct column *next;
	int last_y, height;
	int async, async_pattern;
	short shine, draw, stop, cut;
	char *caption;
};

static void column_flush(struct column *c);
static void column_check_grow(struct column *c);
static void column_service(struct column *c);
static void column_draw(struct column *c, int x);
#else
extern int matrix_mode;
#endif
void matrix_init(int x, int y, int w, int h);
void matrix_draw(void);
void matrix_move(int n);
void matrix_service(void);
void matrix_change_mode(int c_normal, int c_shine, int mode);
void matrix_free(void);
#endif
