/** BEGIN COPYRIGHT BLOCK
 * Copyright (C) 2001 Sun Microsystems, Inc.  Used by permission.
 * Copyright (C) 2005 Red Hat, Inc.
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * END COPYRIGHT BLOCK **/
/*
 * statpingserv.c - determine the on/off status of any server.
 *
 * Takes a host and port, and the result can either be an
 * on or off icon, or text describing status.
 *
 * All blame to Adam Prishtina (adam@netscape.com)
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <base/util.h>
#include "libadminutil/distadm.h"
#include "libadminutil/resource.h"

#ifdef __cplusplus
extern "C" {
#endif

#include "libadmsslutil/certmgt.h"
#include "libadmsslutil/psetcssl.h"
#include "libadmsslutil/admsslutil.h"
#include "key.h"
#include "cert.h"
#include "secport.h"
#include "secmod.h"
#include "prnetdb.h"

#ifdef __cplusplus
}
#endif


int main(int argc, char *argv[])
{
  int _ai = ADMUTIL_Init();
  char *m;

  char *qs = getenv("QUERY_STRING");
  PRHostEnt   hent;
  char        buf[PR_NETDB_BUF_SIZE];
  PRStatus    err;
  char        gifbuf[BUFSIZ];
  PRInt32     bytes;

  PRFileDesc *req_socket= NULL;
  int retcode;
  PRNetAddr netAddr;

  char *result;
  char *host;
  int port;

  PRFileDesc *gif;
  char *file;
  char *portstr;
  struct PRFileInfo64 prfileinfo;

  m = getenv("REQUEST_METHOD");
  /*
    {
    int d=1;
    while(d>0)
    {;}
    }
  */

  if(!strcmp(m, "GET")) {
    if(qs)
      get_begin(qs);

    result = get_cgi_var("result", NULL, NULL);
    host = get_cgi_var("host", NULL, NULL);
	portstr = get_cgi_var("port", NULL, NULL);
	if (portstr) {
		port = atoi(portstr);
	} else {
		port = 0;
	}

    if(result && !strcmp(result, "text"))
      fprintf(stdout, "Content-type: text/html\n");
    else
      fprintf(stdout, "Content-type: image/gif\n");

	if (!host || !port) {
	rpt_err(APP_ERROR, "Invalid hostname and/or port number!", NULL, NULL);
	}
    if(!isdigit(host[0]))  {
      err = PR_GetHostByName(host, buf, sizeof(buf), &hent);
      if(err == PR_FAILURE) {
	rpt_err(APP_ERROR, "Cannot resolve host name!", NULL, NULL);
      }

      PR_InitializeNetAddr(PR_IpAddrNull, (PRUint16)port, &netAddr);
      memcpy((void *) &netAddr.inet.ip, (void const *) hent.h_addr_list[0], sizeof(netAddr.inet.ip));
    } else {
      PR_InitializeNetAddr(PR_IpAddrNull, (PRUint16)port, &netAddr);
      err = PR_StringToNetAddr(host, &netAddr);
      if(err == PR_FAILURE) {
        rpt_err(APP_ERROR, "Cannot parse host address!", NULL, NULL);
      }
    }

    req_socket = PR_NewTCPSocket();
      
    retcode = PR_Connect(req_socket, &netAddr, 10000);

    if (retcode != 0) {
      /* SERVER IS DOWN - output the OFF button */
      if(result && !strcmp(result, "text")) {
	rpt_success("The server is DOWN.");
	return 1;
      }
      file = PR_smprintf("%s/togoff.gif", ICONDIR);
    }
    else {
      /* SERVER IS RUNNING - output of ON button */
      if(result && !strcmp(result, "text")) {
	rpt_success("The server is UP.");
	return 1;
      }
      file = PR_smprintf("%s/togon.gif", ICONDIR);
    }

    PR_Close(req_socket);

	if ((PR_FAILURE == PR_GetFileInfo64(file, &prfileinfo)) ||
		(prfileinfo.type != PR_FILE_FILE)) {
      rpt_err(APP_ERROR, "Cannot open gif file!", NULL, NULL);
	}

    fprintf(stdout, "Content-length: %ld\n\n", (size_t)prfileinfo.size);
	fflush(stdout);

	PR_Sync(PR_STDOUT);
    gif = PR_Open(file, PR_RDONLY, 0);
    PR_smprintf_free(file);
    if(!gif)
      rpt_err(APP_ERROR, "Cannot open gif file!", NULL, NULL);
	while (0 < (bytes = PR_Read(gif, gifbuf, sizeof(gifbuf)))) {
		PRInt32 remaining = bytes;
		PRInt32 byteswritten = 0;
		while (((byteswritten = PR_Write(PR_STDOUT, gifbuf+byteswritten, remaining)) != remaining) &&
			   (byteswritten > 0)) {
			remaining -= byteswritten;
		}
		if (byteswritten < 0) {
			rpt_err(APP_ERROR, "Cannot write gif to stdout!", NULL, NULL);
		}
	}
	if (bytes < 0) {
		rpt_err(APP_ERROR, "Cannot read gif to write to stdout!", NULL, NULL);
	}
	PR_Sync(PR_STDOUT);
	PR_Close(gif);
  }

  return 0;
}

