/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.controller;

import com.amazonaws.services.auth.identity.cli.common.Utils;
import com.amazonaws.services.auth.identity.cli.controller.IAMDriver;
import com.amazonaws.services.auth.identity.cli.model.CLIRequest;
import com.amazonaws.services.auth.identity.cli.model.ServerCertUploadRequest;
import com.amazonaws.services.awsidentitymanagementv20100508.model.UploadServerCertificateRequest;
import com.amazonaws.services.awsidentitymanagementv20100508.model.UploadServerCertificateResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IAMServerCertUploadDriver
extends IAMDriver {
    private static final Log LOG = LogFactory.getLog(IAMServerCertUploadDriver.class);

    protected void invokeRequestImpl(CLIRequest request) {
        if (request instanceof ServerCertUploadRequest) {
            ServerCertUploadRequest uploadRequest = (ServerCertUploadRequest)request;
            LOG.debug((Object)("Uploading server certificate: " + uploadRequest));
            if (uploadRequest.getCertificateBodyFile() == null) {
                Utils.exit(1, "no public key certificate has been passed in", null);
            }
            if (uploadRequest.getPrivateKeyFile() == null) {
                Utils.exit(1, "no private key has been passed in", null);
            }
            UploadServerCertificateRequest scUploadRequest = new UploadServerCertificateRequest();
            scUploadRequest.setServerCertificateName(uploadRequest.getServerCertificateName());
            scUploadRequest.setPath(this.verifyPathAndAddSlashSuffix(uploadRequest.getPath()));
            String certBody = Utils.readFile(uploadRequest.getCertificateBodyFile());
            LOG.debug((Object)("Public key certificate body read from file is: " + certBody));
            scUploadRequest.setCertificateBody(certBody);
            String priKey = Utils.readFile(uploadRequest.getPrivateKeyFile());
            scUploadRequest.setPrivateKey(priKey);
            if (uploadRequest.getCertificateChainFile() != null) {
                String certChain = Utils.readFile(uploadRequest.getCertificateChainFile());
                LOG.debug((Object)("Public key certificate chain read from file is: " + certChain));
                scUploadRequest.setCertificateChain(certChain);
            }
            UploadServerCertificateResult scUploadResult = this.getClient().uploadServerCertificate(scUploadRequest);
            if (uploadRequest.isVerbose()) {
                LOG.info((Object)scUploadResult.getServerCertificateMetadata().getArn());
                LOG.info((Object)scUploadResult.getServerCertificateMetadata().getServerCertificateId());
            }
        } else {
            Utils.exit(1, "request " + request + " is of an incorrect type.", null);
        }
    }
}

