#!/usr/bin/env python
# -*- coding: utf-8 -*-
# License:: GPL
# Author:: Alberto Milone (aka tseliot) (mailto:albertomilone@alice.it)
# Website:: http://albertomilone.com

import sys
import string
import os
from subprocess import Popen, PIPE
import shutil
import interfaceclasses
import classes 
import main
import idcardlist
import xparse

import gettext, locale

from gettext import gettext as _

def envyver():
    ver = '1.1.1'#SET EnvyNG VERSION HERE
    return ver

ver = envyver()

legacyoses = ['dapper', 'etch']
debianos = ['etch']

def versionprint():
    print 'EnvyNG - Version ' + ver


def restorexorg():
    xreset = xparse.EnvyParser()
    xreset.drivercheck()
    xreset.removealloptions()


'''
######################################
Functions for the Graphical Installer
######################################
'''

'''
NVIDIA INSTALLATION SEQUENCE
(drv, save, build, path)
'''
def nvidiainstallg(drv, save=0, build=0, path=None):
    versionprint()
    compatible = classes.Compatibcheck()
    compatible.brandname = 'Nvidia'
    compat = compatible.check()#COMPATIBILITY CHECK

    task = classes.Specsdetect()
    
    '''
    Attributes in Specsdetect
    '''
    task.build = build
    task.save = save
    task.savepath = path
    
    task.cards = idcardlist.nvnewcards()#set the id lists
    task.middlecards = idcardlist.nvmidcards()
    task.legacycards = idcardlist.nvoldcards()
    
    task.details['cardbrand'] = 'nvidia'
    task.codename()#os name
    task.architecture()#arch
    task.systemcheck()#system/arch compatibility

    task.drivertype()#latest, middle, oldest driver
    
    if build == 0:
        task.cleanPackages()
        main.glxdiversion()
    
    utils = classes.Shutilities()
    utils.checkRepositories()
    main.headersCheck()
    task.nvidiaInstall()
    
    task.xorgbackup()
    main.depmodules()

    if build == 0:
        task.nvxorgset()
    
    os.system('sleep 3')
    print 'EnvyNG: Operation Complete'




'''NVIDIA UNINSTALLATION SEQUENCE'''
'''PART 2: THE REAL UNINSTALLATION SEQUENCE'''
def nvidiauninstall2g():
    task = classes.Specsdetect()#instantiate the class
    main.remove_nvidia_pkg()#remove previous nvidia packages
    main.glxdiversion()
    main.restoremesa()
    task.codename()
    
    restorexorg()
    
    os.system('sleep 3')
    print 'EnvyNG: Operation Complete'



'''PART 1: MAKE SURE THE COMPUTER HAS AN NVIDIA CARD'''
def nvidiauninstallg():
    versionprint()
    compatible = classes.Compatibcheck()
    compatible.brandname = 'Nvidia'
    nvidiauninstall2g()#CONTINUE THE INSTALLATION


#def maninstall3(brand, drv):
def maninstall3(drv, ver, save=0, build=0, path=None):
    versionprint()
    task = classes.Specsdetect()#instantiate the class
    
    '''
    Attributes in Specsdetect
    '''
    task.build = build
    task.save = save
    task.savepath = path
    
    '''
    No hardware detection
    '''
    task.details['cardbrand'] = drv#brand
    task.details['drvtype'] = ver#drv

    #print task.details['cardbrand']
    #print task.details['drvtype']

    task.codename()#os name
    task.architecture()#arch
    task.systemcheck()#system/arch compatibility
    
    
    if task.details['cardbrand'] == 'nvidia':
        if build == 0:
            task.cleanPackages()
            main.glxdiversion()
        
        utils = classes.Shutilities()
        utils.checkRepositories()
        main.headersCheck()
        task.nvidiaInstall()
        
        task.geforcegocheck()#only for geforce go and manual installation
        task.xorgbackup()
        main.depmodules()

        if build == 0:
            task.nvxorgset()
        os.system('sleep 3')
        print 'EnvyNG: Operation Complete'

    
    elif task.details['cardbrand'] == 'ati':
        if task.details['osname'] not in legacyoses and task.details['drvtype'] == 'oldest':
            print 'EnvyNG ERROR: ATI\'s legacy driver does not support your operating system'
        else:
            if build == 0:
                task.cleanPackages()
                main.glxdiversion()
            
            utils = classes.Shutilities()
            utils.checkRepositories()
            main.headersCheck()
            task.atiInstall()
           
            task.xorgbackup()
            main.depmodules()
    
        if build == 0:
            task.atixorgset()
        #os.system('sleep 3')
        print 'EnvyNG: Operation Complete'




def atiinstallg(drv, save=0, build=0, path=None):
    versionprint()
    compatible = classes.Compatibcheck()
    compatible.brandname = 'ATI'
    compat = compatible.check()#COMPATIBILITY CHECK
    
    main.remove_deb()#Just in case
    task = classes.Specsdetect()#instantiate the class
    task.cards = idcardlist.atinewcards()#set the id lists
    task.middlecards = idcardlist.atimidcards()
    task.legacycards = idcardlist.atioldcards()

    task.details['cardbrand'] = 'ati'
    task.codename()#os name
    task.architecture()#arch
    task.systemcheck()#system/arch compatibility
    
    task.drivertype()#latest, middle, oldest driver
    
    if task.details['osname'] not in legacyoses and task.details['drvtype'] == 'oldest':
        print 'EnvyNG ERROR: ATI\'s legacy driver does not support your operating system'
    else:
        task.atireleasenum()#(e.g. '8.28.8')
        
        if build == 0:
            task.cleanPackages()
            main.glxdiversion()
        
        utils = classes.Shutilities()
        utils.checkRepositories()
        main.headersCheck()
        task.atiInstall()
        task.xorgbackup()
        main.depmodules()#make sure the module is there
    
        if build == 0:
            task.atixorgset()
        os.system('sleep 3')
        print 'EnvyNG: Operation Complete'


'''ATI UNINSTALLATION SEQUENCE'''
'''PART 2: THE REAL UNINSTALLATION SEQUENCE'''
def atiuninstall2g():
    main.remove_deb()#Just in case
    task = classes.Specsdetect()#instantiate the class
    main.remove_ati_pkg()#remove previous ati packages
    task.codename()#os name
    
    main.glxdiversion()
    main.restoremesa()
    
    restorexorg()
    
    os.system('sleep 3')
    print 'EnvyNG: Operation Complete'

'''PART 1: MAKE SURE THE COMPUTER HAS AN ATI CARD'''
def atiuninstallg():
    versionprint()
    compatible = classes.Compatibcheck()
    compatible.brandname = 'ATI'
    atiuninstall2g()#CONTINUE THE INSTALLATION





'''
######################################
Functions for the Textual Installer
######################################
'''


'''NVIDIA INSTALLATION SEQUENCE'''
'''PART 2: THE REAL INSTALLATION SEQUENCE'''
def nvidiainstall2():
    try:
        task = classes.Specsdetect()#instantiate the class
        task.cards = idcardlist.nvnewcards()#set the id lists
        task.middlecards = idcardlist.nvmidcards()
        task.legacycards = idcardlist.nvoldcards()
        
        task.details['cardbrand'] = 'nvidia'
        task.codename()#os name
        task.architecture()#arch
        task.systemcheck()#system/arch compatibility
        

        task.drivertype()#latest, middle, oldest driver
        task.cleanPackages()
        main.glxdiversion()
        
        utils = classes.Shutilities()
        utils.checkRepositories()
        main.headersCheck()
        task.nvidiaInstall()
        
        task.xorgbackup()
        main.depmodules()
        
        task.nvxorgset()
        main.pcrestart()
        print 'EnvyNG: Operation Complete'
        mainmenu()
    except Exception, e:
        print e
        sys.exit(1)

'''PART 1: MAKE SURE THE COMPUTER HAS AN NVIDIA CARD'''
def nvidiainstall():
    versionprint()
    compatible = classes.Compatibcheck()
    compatible.brandname = 'Nvidia'
    compat = compatible.check()#COMPATIBILITY CHECK
    if compat != 'error':
        nvidiainstall2()#CONTINUE THE INSTALLATION
    else:
        mainmenu()



'''NVIDIA UNINSTALLATION SEQUENCE'''
'''PART 2: THE REAL UNINSTALLATION SEQUENCE'''
def nvidiauninstall2():
    try:
        main.remove_deb()#Just in case
        task = classes.Specsdetect()#instantiate the class

        task.details['cardbrand'] = 'nvidia'
        task.codename()#os name
        task.architecture()#arch
        task.systemcheck()#system/arch compatibility
        main.remove_nvidia_pkg()#remove previous nvidia packages
        main.remove_ati_pkg()#remove previous ati packages
        main.glxdiversion()
        main.restoremesa()
        
        restorexorg()
        
        print 'EnvyNG: Operation Complete'
        mainmenu()
    except Exception, e:
        print e
        sys.exit(1)


'''PART 1: MAKE SURE THE COMPUTER HAS AN NVIDIA CARD'''
def nvidiauninstall():
    versionprint()
    compatible = classes.Compatibcheck()
    compatible.brandname = 'Nvidia'
    nvidiauninstall2()#CONTINUE THE INSTALLATION


'''PART 1: MANUAL INSTALLATION''' 
def maninstall():
    try:
        versionprint()
        task = classes.Specsdetect()#instantiate the class
        
        task.codename()#os name
        task.architecture()#arch
        task.systemcheck()#system/arch compatibility
        
        task.manualdetails()#LET YOU CHOOSE THE CARD AND DRIVER
        
        if task.details['cardbrand'] == 'nvidia':
            task.cleanPackages()
            main.glxdiversion()
            
            utils = classes.Shutilities()
            utils.checkRepositories()
            main.headersCheck()
            task.nvidiaInstall()

            task.geforcegocheck()#only for geforce go and manual installation
            task.xorgbackup()
            main.depmodules()

            task.nvxorgset()
            main.pcrestart()
        
        elif task.details['cardbrand'] == 'ati':
            if task.details['osname'] not in legacyoses and task.details['drvtype'] == 'oldest':
                print 'EnvyNG ERROR: ATI\'s legacy driver does not support your operating system'
            else:
                task.cleanPackages()
                main.glxdiversion()
                
                utils = classes.Shutilities()
                utils.checkRepositories()
                main.headersCheck()
                task.atiInstall()
                
                task.xorgbackup()
                main.depmodules()
        
            task.atixorgset()
            main.pcrestart()#the ATI driver needs a reboot
            print 'EnvyNG: Operation Complete'
        mainmenu()
    except Exception, e:
        print e
        sys.exit(1)


'''ATI INSTALLATION SEQUENCE'''
'''PART 2: THE REAL INSTALLATION SEQUENCE'''
def atiinstall2():
    try:
        task = classes.Specsdetect()#instantiate the class
        task.cards = idcardlist.atinewcards()#set the id lists
        task.middlecards = idcardlist.atimidcards()
        task.legacycards = idcardlist.atioldcards()

        task.details['cardbrand'] = 'ati'
        task.codename()#os name
        task.architecture()#arch
        task.systemcheck()#system/arch compatibility
        
        task.drivertype()#latest, middle, oldest driver
        
        if task.details['osname'] not in legacyoses and task.details['drvtype'] == 'oldest':
            print 'EnvyNG ERROR: ATI\'s legacy driver does not support your operating system'
        else:
            task.atireleasenum()#(e.g. '8.28.8')
            
            task.cleanPackages()
            main.glxdiversion()
            
            utils = classes.Shutilities()
            utils.checkRepositories()
            main.headersCheck()
            task.atiInstall()
       
            task.xorgbackup()
            main.depmodules()#make sure the module is there
            
            task.atixorgset()
            main.pcrestart()#the ATI driver needs a reboot
            print 'EnvyNG: Operation Complete'
        mainmenu()
    except Exception, e:
        print e
        sys.exit(1)

'''PART 1: MAKE SURE THE COMPUTER HAS AN ATI CARD'''
def atiinstall():
    versionprint()
    compatible = classes.Compatibcheck()
    compatible.brandname = 'ATI'
    compat = compatible.check()#COMPATIBILITY CHECK
    if compat != 'error':
        atiinstall2()#CONTINUE THE INSTALLATION

    '''ATI INSTALLATION SEQUENCE'''



'''ATI UNINSTALLATION SEQUENCE'''
'''PART 2: THE REAL UNINSTALLATION SEQUENCE'''
def atiuninstall2():
    try:
        task = classes.Specsdetect()#instantiate the class
        main.remove_ati_pkg()#remove previous ati packages
        task.codename()#os name
        
        main.glxdiversion()
        main.restoremesa()
        
        restorexorg()
        
        #os.system('sleep 3')
        print 'EnvyNG: Operation Complete'
        mainmenu()
    except Exception, e:
        print e
        sys.exit(1)


'''PART 1: MAKE SURE THE COMPUTER HAS AN ATI CARD'''
def atiuninstall():
    versionprint()
    compatible = classes.Compatibcheck()
    compatible.brandname = 'ATI'
    atiuninstall2()#CONTINUE THE INSTALLATION



'''
RESTORE
THE SYSTEM
'''
def restore():
    versionprint()
    task = classes.Specsdetect()

    try:
        task.codename()#os name
        task.architecture()#arch
        task.systemcheck()#system/arch compatibility
        main.remove_ati_pkg()#remove previous ati packages
        main.remove_nvidia_pkg()#remove previous nvidia packages
        main.glxdiversion()
        main.restoremesa()
        task.codename()
        
        restorexorg()
        
        print 'EnvyNG: Operation Complete'
    except Exception, e:
        print e
        sys.exit(1)

'''RESTART THE XSERVER'''
def xserverstart():
    os.system('sudo /etc/init.d/gdm restart')
    os.system('sudo /etc/init.d/kdm restart')



'''
ASK FOR CONFIRMATION OF USER'S CHOICE
'''
def nvinstconfirm():#Install the Nvidia driver
    confirmation = interfaceclasses.Interface()
    confirmation.operation = 'install'
    confirmation.brand = 'Nvidia driver'
    confirmation.gotoop = nvidiainstall()
    confirmation.confirm()

def nvuninstconfirm():#Uninstall the Nvidia driver
    confirmation = interfaceclasses.Interface()
    confirmation.operation = 'uninstall'
    confirmation.brand = 'Nvidia driver'
    confirmation.gotoop = nvidiauninstall()
    confirmation.confirm()

def atiinstconfirm():#Install the ATI driver
    confirmation = interfaceclasses.Interface()
    confirmation.operation = 'install'
    confirmation.brand = 'Ati driver'
    confirmation.gotoop = atiinstall()
    confirmation.confirm()

def maninstconfirm():#Install the driver Manually
    confirmation = interfaceclasses.Interface()
    confirmation.operation = 'install'
    confirmation.brand = 'driver manually'
    confirmation.gotoop = maninstall()
    confirmation.confirm()

def atiuninstconfirm():#Uninstall the ATI driver
    confirmation = interfaceclasses.Interface()
    confirmation.operation = 'uninstall'
    confirmation.brand = 'Ati driver'
    confirmation.gotoop = atiuninstall()
    confirmation.confirm()

def nvcleanconfirm():#Clean the NVIDIA driver
    confirmation = interfaceclasses.Interface()
    confirmation.operation = 'clean'
    confirmation.brand = 'the NVIDIA driver'#RIDEFINIRE QUESTA STRINGA!!!
    confirmation.gotoop = nvidiaclean()#RIDEFINIRE LA FUNZIONE!!!
    confirmation.confirm()

def xorgreset():#Restart the Xserver
    confirmation = interfaceclasses.Interface()
    confirmation.operation = 'restart'
    confirmation.brand = 'Xserver'
    confirmation.gotoop = main.xserverstart()#nvidiainstall()
    confirmation.confirm()

def pcrestart():#Restart the Xserver
    confirmation = interfaceclasses.Interface()
    confirmation.operation = 'restart'
    confirmation.brand = 'computer'
    confirmation.gotoop = main.pcrestart()#nvidiainstall()
    confirmation.confirm()

'''INTERFACE OBJECTS'''
'''Welcome'''
def welcomemenu():
    menu0 = interfaceclasses.Interface()
    menu0.linetxt = ['-', '', '         Welcome to EnvyNG ' + ver, ' ', 'Developed by Alberto Milone (aka tseliot)', '', '-']
    menu0.page()

'''Main Menu'''
def  mainmenu():
    menu1 = interfaceclasses.Interface()
    menu1.linetxt = ['', 'EnvyNG Menu ver.' + ver, '', _('1 - Install the NVIDIA driver'), '', _('2 - Uninstall the NVIDIA driver'), '', _('3 - Install the ATI driver'), '', _('4 - Uninstall the ATI driver'), '', _('5 - Install the ATI/NVIDIA driver Manually'), '', _('6 - Restart the Xserver'), '', _('7 - Restart your computer'), '', _('8 - Exit'), '', _('NOTE: IF THE SCREEN TURNS BLACK, PLEASE TYPE ALT+F1'), '']

    while 1:
        menu1.page()
        reply = raw_input(_('Please select one of the activities displayed above and press ENTER:\n\n')).strip()
        if reply == '1':
            menu1.operation = 'nvinstall'
            #return operation
            break
        elif reply == '2':
            menu1.operation = 'nvuninstall'
            #return operation
            break
        elif reply == '3':
            menu1.operation = 'atiinstall'
            #return operation
            break
        elif reply == '4':
            menu1.operation = 'atiuninstall'
            #return operation
            break
        elif reply == '5':
            menu1.operation = 'maninstall'
            #return operation
            break
        #elif reply == '6':
            #menu1.operation = 'nvidiaclean'
            ##return operation
            #break
        elif reply == '6':
            menu1.operation = 'xorgrestart'
            #return operation
            break
        elif reply == '7':
            menu1.operation = 'pcrestart'
            break
        elif reply == '8':
            sys.exit()
            break
    menu1.process()





if __name__ == '__main__':
    gettext.textdomain("envy")
