#ifndef lint
static const char yysccsid[] = "@(#)yaccpar	1.9 (Berkeley) 02/21/93";
#endif

#define YYBYACC 1
#define YYMAJOR 1
#define YYMINOR 9
#define YYPATCH 20111219

#define YYEMPTY        (-1)
#define yyclearin      (yychar = YYEMPTY)
#define yyerrok        (yyerrflag = 0)
#define YYRECOVERING() (yyerrflag != 0)

#define YYPREFIX "yy"

#define YYPURE 0

#line 2 "winprefsyacc.y"
/*
 * Copyright (C) 1994-2000 The XFree86 Project, Inc. All Rights Reserved.
 * Copyright (C) Colin Harrison 2005-2008
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE XFREE86 PROJECT BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the name of the XFree86 Project
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * from the XFree86 Project.
 *
 * Authors:     Earle F. Philhower, III
 *              Colin Harrison
 */
/* $XFree86: $ */

#ifdef HAVE_XWIN_CONFIG_H
#include <xwin-config.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "winprefs.h"

/* The following give better error messages in bison at the cost of a few KB */
#define YYERROR_VERBOSE 1

/* YYLTYPE_IS_TRIVIAL and YYENABLE_NLS defined to suppress warnings */
#define YYLTYPE_IS_TRIVIAL 1
#define YYENABLE_NLS 0

/* The global pref settings */
WINPREFS pref;

/* The working menu */  
static MENUPARSED menu;

/* Functions for parsing the tokens into out structure */
/* Defined at the end section of this file */

static void SetIconDirectory (char *path);
static void SetDefaultIcon (char *fname);
static void SetRootMenu (char *menu);
static void SetDefaultSysMenu (char *menu, int pos);
static void SetTrayIcon (char *fname);

static void OpenMenu(char *menuname);
static void AddMenuLine(char *name, MENUCOMMANDTYPE cmd, char *param);
static void CloseMenu(void);

static void OpenIcons(void);
static void AddIconLine(char *matchstr, char *iconfile);
static void CloseIcons(void);

static void OpenStyles(void);
static void AddStyleLine(char *matchstr, unsigned long style);
static void CloseStyles(void);

static void OpenSysMenu(void);
static void AddSysMenuLine(char *matchstr, char *menuname, int pos);
static void CloseSysMenu(void);

static int yyerror (char *s);

extern void ErrorF (const char* /*f*/, ...);
extern char *yytext;
extern int yylex(void);

#line 89 "winprefsyacc.y"
#ifdef YYSTYPE
#undef  YYSTYPE_IS_DECLARED
#define YYSTYPE_IS_DECLARED 1
#endif
#ifndef YYSTYPE_IS_DECLARED
#define YYSTYPE_IS_DECLARED 1
typedef union {
  char *sVal;
  unsigned long uVal;
  int iVal;
} YYSTYPE;
#endif /* !YYSTYPE_IS_DECLARED */
#line 118 "winprefsyacc.c"

/* compatibility with bison */
#ifdef YYPARSE_PARAM
/* compatibility with FreeBSD */
# ifdef YYPARSE_PARAM_TYPE
#  define YYPARSE_DECL() yyparse(YYPARSE_PARAM_TYPE YYPARSE_PARAM)
# else
#  define YYPARSE_DECL() yyparse(void *YYPARSE_PARAM)
# endif
#else
# define YYPARSE_DECL() yyparse(void)
#endif

/* Parameters sent to lex. */
#ifdef YYLEX_PARAM
# define YYLEX_DECL() yylex(void *YYLEX_PARAM)
# define YYLEX yylex(YYLEX_PARAM)
#else
# define YYLEX_DECL() yylex(void)
# define YYLEX yylex()
#endif

/* Parameters sent to yyerror. */
#define YYERROR_DECL() yyerror(const char *s)
#define YYERROR_CALL(msg) yyerror(msg)

extern int YYPARSE_DECL();

#define NEWLINE 257
#define MENU 258
#define LB 259
#define RB 260
#define ICONDIRECTORY 261
#define DEFAULTICON 262
#define ICONS 263
#define STYLES 264
#define TOPMOST 265
#define MAXIMIZE 266
#define MINIMIZE 267
#define BOTTOM 268
#define NOTITLE 269
#define OUTLINE 270
#define NOFRAME 271
#define DEFAULTSYSMENU 272
#define SYSMENU 273
#define ROOTMENU 274
#define SEPARATOR 275
#define ATSTART 276
#define ATEND 277
#define EXEC 278
#define ALWAYSONTOP 279
#define DEBUGOUTPUT 280
#define DEBUG 281
#define RELOAD 282
#define TRAYICON 283
#define FORCEEXIT 284
#define SILENTEXIT 285
#define STRING 286
#define YYERRCODE 256
static const short yylhs[] = {                           -1,
    0,    0,    5,    5,    7,    7,    6,    6,    6,    6,
    6,    6,    6,    6,    6,    6,    6,    6,   17,   14,
   15,    8,    9,   20,   20,   20,   20,   20,   21,   21,
   22,   10,   23,   24,   24,   25,   11,    1,    1,    1,
    1,    2,    2,    2,    3,    3,    3,    3,   26,   27,
   27,   28,   12,    4,    4,    4,   29,   30,   30,   31,
   13,   18,   19,   16,
};
static const short yylen[] = {                            2,
    0,    2,    1,    1,    0,    2,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    3,    3,
    4,    3,    3,    3,    4,    5,    5,    4,    1,    2,
    0,    7,    4,    1,    2,    0,    6,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    2,    2,    4,    1,
    2,    0,    6,    0,    1,    1,    5,    1,    2,    0,
    7,    2,    2,    3,
};
static const short yydefred[] = {                         1,
    0,    3,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    2,    4,    7,    8,    9,   10,
   11,   12,   13,   14,   15,   16,   17,   18,    0,    0,
    0,   36,   52,    0,    0,    0,    0,    0,   62,   63,
   31,   23,   22,    0,    0,   55,   56,    0,   60,   20,
   64,   19,    0,    0,    0,    0,   21,    0,    0,    6,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   35,   37,   38,   39,   40,   41,   42,   43,
   44,    0,    0,    0,   51,   53,    0,    0,    0,    0,
    0,    0,    0,    0,   30,   32,    0,   47,   48,    0,
    0,   59,   61,   24,    0,    0,    0,    0,   33,   49,
    0,    0,    0,   25,   28,    0,   27,   26,   57,
};
static const short yydgoto[] = {                          1,
   82,   83,   84,   48,   15,   16,   55,   17,   18,   19,
   20,   21,   22,   23,   24,   25,   26,   27,   28,   70,
   71,   53,   62,   63,   44,   65,   66,   45,   88,   89,
   58,
};
static const short yysindex[] = {                         0,
 -247,    0, -262, -256, -254, -218, -217, -240, -215, -238,
 -237, -236, -210, -206,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, -205, -204,
 -201,    0,    0, -242, -200, -199, -198, -197,    0,    0,
    0,    0,    0, -196, -196,    0,    0, -192,    0,    0,
    0,    0, -196, -196, -222, -220,    0, -196, -274,    0,
 -216, -222, -191, -193, -220, -181, -203, -177, -239, -274,
 -179, -175,    0,    0,    0,    0,    0,    0,    0,    0,
    0, -248, -261, -173,    0,    0, -195, -203, -174, -196,
 -194, -190, -172, -170,    0,    0, -196,    0,    0, -196,
 -242,    0,    0,    0, -169, -168, -196, -196,    0,    0,
 -167, -196, -196,    0,    0, -196,    0,    0,    0,
};
static const short yyrindex[] = {                         0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, -196,    0,    0,    0,    0,    0,    0,
    0,    0,    0, -189, -189,    0,    0,    0,    0,    0,
    0,    0, -255, -257,    0,    0,    0, -189,    0,    0,
    0, -166,    0,    0, -165,    0,    0,    0,    0, -162,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, -164, -158,    0,    0,    0,    0, -160,    0, -257,
    0,    0,    0,    0,    0,    0, -258,    0,    0, -258,
 -196,    0,    0,    0,    0,    0, -257, -257,    0,    0,
    0, -257, -257,    0,    0, -258,    0,    0,    0,
};
static const short yygindex[] = {                         0,
   18,   20,    0,    2,    0,    0,  -45,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   34,    0,    0,   43,    0,    0,   41,    0,    0,   19,
    0,
};
#define YYTABLESIZE 107
static const short yytable[] = {                         56,
   68,    5,    5,   75,   76,   77,   78,   59,   60,    2,
    3,   69,   67,    4,    5,    6,    7,    5,   91,    5,
   79,   80,   81,   29,    8,    9,   10,    5,    5,   30,
    5,   31,   11,   46,   47,   12,   13,   14,   92,   93,
   32,   33,   94,   35,  104,   34,   39,   36,   37,   38,
   40,  109,   42,   41,  110,   43,   49,   50,   51,   52,
   54,  114,  115,   61,   57,   64,  117,  118,   74,   72,
  119,   75,   76,   77,   78,   79,   80,   81,   86,   90,
   96,   97,   87,  100,  107,  103,  108,  112,  113,  116,
  101,  105,   45,   34,   50,  106,    5,   29,   46,   58,
   99,   98,  111,   95,   73,   85,  102,
};
static const short yycheck[] = {                         45,
  275,  260,  260,  265,  266,  267,  268,   53,   54,  257,
  258,  286,   58,  261,  262,  263,  264,  275,  258,  275,
  269,  270,  271,  286,  272,  273,  274,  286,  286,  286,
  286,  286,  280,  276,  277,  283,  284,  285,  278,  279,
  259,  259,  282,  259,   90,  286,  257,  286,  286,  286,
  257,   97,  257,  259,  100,  257,  257,  257,  257,  257,
  257,  107,  108,  286,  257,  286,  112,  113,  260,  286,
  116,  265,  266,  267,  268,  269,  270,  271,  260,  257,
  260,  257,  286,  257,  257,  260,  257,  257,  257,  257,
  286,  286,  257,  260,  260,  286,  286,  260,  257,  260,
   83,   82,  101,   70,   62,   65,   88,
};
#define YYFINAL 1
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 286
#if YYDEBUG
static const char *yyname[] = {

"end-of-file",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"NEWLINE","MENU","LB","RB",
"ICONDIRECTORY","DEFAULTICON","ICONS","STYLES","TOPMOST","MAXIMIZE","MINIMIZE",
"BOTTOM","NOTITLE","OUTLINE","NOFRAME","DEFAULTSYSMENU","SYSMENU","ROOTMENU",
"SEPARATOR","ATSTART","ATEND","EXEC","ALWAYSONTOP","DEBUGOUTPUT","\"DEBUG\"",
"RELOAD","TRAYICON","FORCEEXIT","SILENTEXIT","STRING",
};
static const char *yyrule[] = {
"$accept : input",
"input :",
"input : input line",
"line : NEWLINE",
"line : command",
"newline_or_nada :",
"newline_or_nada : NEWLINE newline_or_nada",
"command : defaulticon",
"command : icondirectory",
"command : menu",
"command : icons",
"command : styles",
"command : sysmenu",
"command : rootmenu",
"command : defaultsysmenu",
"command : debug",
"command : trayicon",
"command : forceexit",
"command : silentexit",
"trayicon : TRAYICON STRING NEWLINE",
"rootmenu : ROOTMENU STRING NEWLINE",
"defaultsysmenu : DEFAULTSYSMENU STRING atspot NEWLINE",
"defaulticon : DEFAULTICON STRING NEWLINE",
"icondirectory : ICONDIRECTORY STRING NEWLINE",
"menuline : SEPARATOR NEWLINE newline_or_nada",
"menuline : STRING ALWAYSONTOP NEWLINE newline_or_nada",
"menuline : STRING EXEC STRING NEWLINE newline_or_nada",
"menuline : STRING MENU STRING NEWLINE newline_or_nada",
"menuline : STRING RELOAD NEWLINE newline_or_nada",
"menulist : menuline",
"menulist : menuline menulist",
"$$1 :",
"menu : MENU STRING LB $$1 newline_or_nada menulist RB",
"iconline : STRING STRING NEWLINE newline_or_nada",
"iconlist : iconline",
"iconlist : iconline iconlist",
"$$2 :",
"icons : ICONS LB $$2 newline_or_nada iconlist RB",
"group1 : TOPMOST",
"group1 : MAXIMIZE",
"group1 : MINIMIZE",
"group1 : BOTTOM",
"group2 : NOTITLE",
"group2 : OUTLINE",
"group2 : NOFRAME",
"stylecombo : group1",
"stylecombo : group2",
"stylecombo : group1 group2",
"stylecombo : group2 group1",
"styleline : STRING stylecombo NEWLINE newline_or_nada",
"stylelist : styleline",
"stylelist : styleline stylelist",
"$$3 :",
"styles : STYLES LB $$3 newline_or_nada stylelist RB",
"atspot :",
"atspot : ATSTART",
"atspot : ATEND",
"sysmenuline : STRING STRING atspot NEWLINE newline_or_nada",
"sysmenulist : sysmenuline",
"sysmenulist : sysmenuline sysmenulist",
"$$4 :",
"sysmenu : SYSMENU LB NEWLINE $$4 newline_or_nada sysmenulist RB",
"forceexit : FORCEEXIT NEWLINE",
"silentexit : SILENTEXIT NEWLINE",
"debug : DEBUGOUTPUT STRING NEWLINE",

};
#endif

int      yydebug;
int      yynerrs;

int      yyerrflag;
int      yychar;
YYSTYPE  yyval;
YYSTYPE  yylval;

/* define the initial stack-sizes */
#ifdef YYSTACKSIZE
#undef YYMAXDEPTH
#define YYMAXDEPTH  YYSTACKSIZE
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 10000
#define YYMAXDEPTH  500
#endif
#endif

#define YYINITSTACKSIZE 500

typedef struct {
    unsigned stacksize;
    short    *s_base;
    short    *s_mark;
    short    *s_last;
    YYSTYPE  *l_base;
    YYSTYPE  *l_mark;
} YYSTACKDATA;
/* variables for the parser stack */
static YYSTACKDATA yystack;
#line 251 "winprefsyacc.y"
/*
 * Errors in parsing abort and print log messages
 */
static int
yyerror (char *s) 
{
  extern int yylineno; /* Handled by flex internally */

  ErrorF("LoadPreferences: %s line %d\n", s, yylineno);
  return 1;
}

/* Miscellaneous functions to store TOKENs into the structure */
static void
SetIconDirectory (char *path)
{
  strncpy (pref.iconDirectory, path, PATH_MAX);
  pref.iconDirectory[PATH_MAX] = 0;
}

static void
SetDefaultIcon (char *fname)
{
  strncpy (pref.defaultIconName, fname, NAME_MAX);
  pref.defaultIconName[NAME_MAX] = 0;
}

static void
SetTrayIcon (char *fname)
{
  strncpy (pref.trayIconName, fname, NAME_MAX);
  pref.trayIconName[NAME_MAX] = 0;
}

static void
SetRootMenu (char *menu)
{
  strncpy (pref.rootMenuName, menu, MENU_MAX);
  pref.rootMenuName[MENU_MAX] = 0;
}

static void
SetDefaultSysMenu (char *menu, int pos)
{
  strncpy (pref.defaultSysMenuName, menu, MENU_MAX);
  pref.defaultSysMenuName[MENU_MAX] = 0;
  pref.defaultSysMenuPos = pos;
}

static void
OpenMenu (char *menuname)
{
  if (menu.menuItem) free(menu.menuItem);
  menu.menuItem = NULL;
  strncpy(menu.menuName, menuname, MENU_MAX);
  menu.menuName[MENU_MAX] = 0;
  menu.menuItems = 0;
}

static void
AddMenuLine (char *text, MENUCOMMANDTYPE cmd, char *param)
{
  if (menu.menuItem==NULL)
    menu.menuItem = (MENUITEM*)malloc(sizeof(MENUITEM));
  else
    menu.menuItem = (MENUITEM*)
      realloc(menu.menuItem, sizeof(MENUITEM)*(menu.menuItems+1));

  strncpy (menu.menuItem[menu.menuItems].text, text, MENU_MAX);
  menu.menuItem[menu.menuItems].text[MENU_MAX] = 0;

  menu.menuItem[menu.menuItems].cmd = cmd;

  strncpy(menu.menuItem[menu.menuItems].param, param, PARAM_MAX);
  menu.menuItem[menu.menuItems].param[PARAM_MAX] = 0;

  menu.menuItem[menu.menuItems].commandID = 0;

  menu.menuItems++;
}

static void
CloseMenu (void)
{
  if (menu.menuItem==NULL || menu.menuItems==0)
    {
      ErrorF("LoadPreferences: Empty menu detected\n");
      return;
    }
  
  if (pref.menuItems)
    pref.menu = (MENUPARSED*)
      realloc (pref.menu, (pref.menuItems+1)*sizeof(MENUPARSED));
  else
    pref.menu = (MENUPARSED*)malloc (sizeof(MENUPARSED));
  
  memcpy (pref.menu+pref.menuItems, &menu, sizeof(MENUPARSED));
  pref.menuItems++;

  memset (&menu, 0, sizeof(MENUPARSED));
}

static void 
OpenIcons (void)
{
  if (pref.icon != NULL) {
    ErrorF("LoadPreferences: Redefining icon mappings\n");
    free(pref.icon);
    pref.icon = NULL;
  }
  pref.iconItems = 0;
}

static void
AddIconLine (char *matchstr, char *iconfile)
{
  if (pref.icon==NULL)
    pref.icon = (ICONITEM*)malloc(sizeof(ICONITEM));
  else
    pref.icon = (ICONITEM*)
      realloc(pref.icon, sizeof(ICONITEM)*(pref.iconItems+1));

  strncpy(pref.icon[pref.iconItems].match, matchstr, MENU_MAX);
  pref.icon[pref.iconItems].match[MENU_MAX] = 0;

  strncpy(pref.icon[pref.iconItems].iconFile, iconfile, PATH_MAX+NAME_MAX+1);
  pref.icon[pref.iconItems].iconFile[PATH_MAX+NAME_MAX+1] = 0;

  pref.icon[pref.iconItems].hicon = 0;

  pref.iconItems++;
}

static void 
CloseIcons (void)
{
}

static void
OpenStyles (void)
{
  if (pref.style != NULL) {
    ErrorF("LoadPreferences: Redefining window style\n");
    free(pref.style);
    pref.style = NULL;
  }
  pref.styleItems = 0;
}

static void
AddStyleLine (char *matchstr, unsigned long style)
{
  if (pref.style==NULL)
    pref.style = (STYLEITEM*)malloc(sizeof(STYLEITEM));
  else
    pref.style = (STYLEITEM*)
      realloc(pref.style, sizeof(STYLEITEM)*(pref.styleItems+1));

  strncpy(pref.style[pref.styleItems].match, matchstr, MENU_MAX);
  pref.style[pref.styleItems].match[MENU_MAX] = 0;

  pref.style[pref.styleItems].type = style;

  pref.styleItems++;
}

static void
CloseStyles (void)
{
}

static void
OpenSysMenu (void)
{
  if (pref.sysMenu != NULL) {
    ErrorF("LoadPreferences: Redefining system menu\n");
    free(pref.sysMenu);
    pref.sysMenu = NULL;
  }
  pref.sysMenuItems = 0;
}

static void
AddSysMenuLine (char *matchstr, char *menuname, int pos)
{
  if (pref.sysMenu==NULL)
    pref.sysMenu = (SYSMENUITEM*)malloc(sizeof(SYSMENUITEM));
  else
    pref.sysMenu = (SYSMENUITEM*)
      realloc(pref.sysMenu, sizeof(SYSMENUITEM)*(pref.sysMenuItems+1));

  strncpy (pref.sysMenu[pref.sysMenuItems].match, matchstr, MENU_MAX);
  pref.sysMenu[pref.sysMenuItems].match[MENU_MAX] = 0;

  strncpy (pref.sysMenu[pref.sysMenuItems].menuName, menuname, MENU_MAX);
  pref.sysMenu[pref.sysMenuItems].menuName[MENU_MAX] = 0;

  pref.sysMenu[pref.sysMenuItems].menuPos = pos;

  pref.sysMenuItems++;
}

static void
CloseSysMenu (void)
{
}

#line 608 "winprefsyacc.c"

#if YYDEBUG
#include <stdio.h>		/* needed for printf */
#endif

#include <stdlib.h>	/* needed for malloc, etc */
#include <string.h>	/* needed for memset */

/* allocate initial stack or double stack size, up to YYMAXDEPTH */
static int yygrowstack(YYSTACKDATA *data)
{
    int i;
    unsigned newsize;
    short *newss;
    YYSTYPE *newvs;

    if ((newsize = data->stacksize) == 0)
        newsize = YYINITSTACKSIZE;
    else if (newsize >= YYMAXDEPTH)
        return -1;
    else if ((newsize *= 2) > YYMAXDEPTH)
        newsize = YYMAXDEPTH;

    i = data->s_mark - data->s_base;
    newss = (short *)realloc(data->s_base, newsize * sizeof(*newss));
    if (newss == 0)
        return -1;

    data->s_base = newss;
    data->s_mark = newss + i;

    newvs = (YYSTYPE *)realloc(data->l_base, newsize * sizeof(*newvs));
    if (newvs == 0)
        return -1;

    data->l_base = newvs;
    data->l_mark = newvs + i;

    data->stacksize = newsize;
    data->s_last = data->s_base + newsize - 1;
    return 0;
}

#if YYPURE || defined(YY_NO_LEAKS)
static void yyfreestack(YYSTACKDATA *data)
{
    free(data->s_base);
    free(data->l_base);
    memset(data, 0, sizeof(*data));
}
#else
#define yyfreestack(data) /* nothing */
#endif

#define YYABORT  goto yyabort
#define YYREJECT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR  goto yyerrlab

int
YYPARSE_DECL()
{
    int yym, yyn, yystate;
#if YYDEBUG
    const char *yys;

    if ((yys = getenv("YYDEBUG")) != 0)
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif

    yynerrs = 0;
    yyerrflag = 0;
    yychar = YYEMPTY;
    yystate = 0;

#if YYPURE
    memset(&yystack, 0, sizeof(yystack));
#endif

    if (yystack.s_base == NULL && yygrowstack(&yystack)) goto yyoverflow;
    yystack.s_mark = yystack.s_base;
    yystack.l_mark = yystack.l_base;
    yystate = 0;
    *yystack.s_mark = 0;

yyloop:
    if ((yyn = yydefred[yystate]) != 0) goto yyreduce;
    if (yychar < 0)
    {
        if ((yychar = YYLEX) < 0) yychar = 0;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, reading %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
    }
    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: state %d, shifting to state %d\n",
                    YYPREFIX, yystate, yytable[yyn]);
#endif
        if (yystack.s_mark >= yystack.s_last && yygrowstack(&yystack))
        {
            goto yyoverflow;
        }
        yystate = yytable[yyn];
        *++yystack.s_mark = yytable[yyn];
        *++yystack.l_mark = yylval;
        yychar = YYEMPTY;
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag) goto yyinrecovery;

    yyerror("syntax error");

    goto yyerrlab;

yyerrlab:
    ++yynerrs;

yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if ((yyn = yysindex[*yystack.s_mark]) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: state %d, error recovery shifting\
 to state %d\n", YYPREFIX, *yystack.s_mark, yytable[yyn]);
#endif
                if (yystack.s_mark >= yystack.s_last && yygrowstack(&yystack))
                {
                    goto yyoverflow;
                }
                yystate = yytable[yyn];
                *++yystack.s_mark = yytable[yyn];
                *++yystack.l_mark = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: error recovery discarding state %d\n",
                            YYPREFIX, *yystack.s_mark);
#endif
                if (yystack.s_mark <= yystack.s_base) goto yyabort;
                --yystack.s_mark;
                --yystack.l_mark;
            }
        }
    }
    else
    {
        if (yychar == 0) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, error recovery discards token %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
        yychar = YYEMPTY;
        goto yyloop;
    }

yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: state %d, reducing by rule %d (%s)\n",
                YYPREFIX, yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    if (yym)
        yyval = yystack.l_mark[1-yym];
    else
        memset(&yyval, 0, sizeof yyval);
    switch (yyn)
    {
case 19:
#line 159 "winprefsyacc.y"
	{ SetTrayIcon(yystack.l_mark[-1].sVal); free(yystack.l_mark[-1].sVal); }
break;
case 20:
#line 162 "winprefsyacc.y"
	{ SetRootMenu(yystack.l_mark[-1].sVal); free(yystack.l_mark[-1].sVal); }
break;
case 21:
#line 165 "winprefsyacc.y"
	{ SetDefaultSysMenu(yystack.l_mark[-2].sVal, yystack.l_mark[-1].iVal); free(yystack.l_mark[-2].sVal); }
break;
case 22:
#line 168 "winprefsyacc.y"
	{ SetDefaultIcon(yystack.l_mark[-1].sVal); free(yystack.l_mark[-1].sVal); }
break;
case 23:
#line 171 "winprefsyacc.y"
	{ SetIconDirectory(yystack.l_mark[-1].sVal); free(yystack.l_mark[-1].sVal); }
break;
case 24:
#line 174 "winprefsyacc.y"
	{ AddMenuLine("-", CMD_SEPARATOR, ""); }
break;
case 25:
#line 175 "winprefsyacc.y"
	{ AddMenuLine(yystack.l_mark[-3].sVal, CMD_ALWAYSONTOP, ""); free(yystack.l_mark[-3].sVal); }
break;
case 26:
#line 176 "winprefsyacc.y"
	{ AddMenuLine(yystack.l_mark[-4].sVal, CMD_EXEC, yystack.l_mark[-2].sVal); free(yystack.l_mark[-4].sVal); free(yystack.l_mark[-2].sVal); }
break;
case 27:
#line 177 "winprefsyacc.y"
	{ AddMenuLine(yystack.l_mark[-4].sVal, CMD_MENU, yystack.l_mark[-2].sVal); free(yystack.l_mark[-4].sVal); free(yystack.l_mark[-2].sVal); }
break;
case 28:
#line 178 "winprefsyacc.y"
	{ AddMenuLine(yystack.l_mark[-3].sVal, CMD_RELOAD, ""); free(yystack.l_mark[-3].sVal); }
break;
case 31:
#line 185 "winprefsyacc.y"
	{ OpenMenu(yystack.l_mark[-1].sVal); free(yystack.l_mark[-1].sVal); }
break;
case 32:
#line 185 "winprefsyacc.y"
	{CloseMenu();}
break;
case 33:
#line 188 "winprefsyacc.y"
	{ AddIconLine(yystack.l_mark[-3].sVal, yystack.l_mark[-2].sVal); free(yystack.l_mark[-3].sVal); free(yystack.l_mark[-2].sVal); }
break;
case 36:
#line 195 "winprefsyacc.y"
	{OpenIcons();}
break;
case 37:
#line 195 "winprefsyacc.y"
	{CloseIcons();}
break;
case 38:
#line 198 "winprefsyacc.y"
	{ yyval.uVal=STYLE_TOPMOST; }
break;
case 39:
#line 199 "winprefsyacc.y"
	{ yyval.uVal=STYLE_MAXIMIZE; }
break;
case 40:
#line 200 "winprefsyacc.y"
	{ yyval.uVal=STYLE_MINIMIZE; }
break;
case 41:
#line 201 "winprefsyacc.y"
	{ yyval.uVal=STYLE_BOTTOM; }
break;
case 42:
#line 204 "winprefsyacc.y"
	{ yyval.uVal=STYLE_NOTITLE; }
break;
case 43:
#line 205 "winprefsyacc.y"
	{ yyval.uVal=STYLE_OUTLINE; }
break;
case 44:
#line 206 "winprefsyacc.y"
	{ yyval.uVal=STYLE_NOFRAME; }
break;
case 45:
#line 209 "winprefsyacc.y"
	{ yyval.uVal=yystack.l_mark[0].uVal; }
break;
case 46:
#line 210 "winprefsyacc.y"
	{ yyval.uVal=yystack.l_mark[0].uVal; }
break;
case 47:
#line 211 "winprefsyacc.y"
	{ yyval.uVal=yystack.l_mark[-1].uVal|yystack.l_mark[0].uVal; }
break;
case 48:
#line 212 "winprefsyacc.y"
	{ yyval.uVal=yystack.l_mark[-1].uVal|yystack.l_mark[0].uVal; }
break;
case 49:
#line 215 "winprefsyacc.y"
	{ AddStyleLine(yystack.l_mark[-3].sVal, yystack.l_mark[-2].uVal); free(yystack.l_mark[-3].sVal); }
break;
case 52:
#line 222 "winprefsyacc.y"
	{OpenStyles();}
break;
case 53:
#line 222 "winprefsyacc.y"
	{CloseStyles();}
break;
case 54:
#line 225 "winprefsyacc.y"
	{ yyval.iVal=AT_END; }
break;
case 55:
#line 226 "winprefsyacc.y"
	{ yyval.iVal=AT_START; }
break;
case 56:
#line 227 "winprefsyacc.y"
	{ yyval.iVal=AT_END; }
break;
case 57:
#line 230 "winprefsyacc.y"
	{ AddSysMenuLine(yystack.l_mark[-4].sVal, yystack.l_mark[-3].sVal, yystack.l_mark[-2].iVal); free(yystack.l_mark[-4].sVal); free(yystack.l_mark[-3].sVal); }
break;
case 60:
#line 237 "winprefsyacc.y"
	{OpenSysMenu();}
break;
case 61:
#line 237 "winprefsyacc.y"
	{CloseSysMenu();}
break;
case 62:
#line 240 "winprefsyacc.y"
	{ pref.fForceExit = TRUE; }
break;
case 63:
#line 243 "winprefsyacc.y"
	{ pref.fSilentExit = TRUE; }
break;
case 64:
#line 246 "winprefsyacc.y"
	{ ErrorF("LoadPreferences: %s\n", yystack.l_mark[-1].sVal); free(yystack.l_mark[-1].sVal); }
break;
#line 966 "winprefsyacc.c"
    }
    yystack.s_mark -= yym;
    yystate = *yystack.s_mark;
    yystack.l_mark -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: after reduction, shifting from state 0 to\
 state %d\n", YYPREFIX, YYFINAL);
#endif
        yystate = YYFINAL;
        *++yystack.s_mark = YYFINAL;
        *++yystack.l_mark = yyval;
        if (yychar < 0)
        {
            if ((yychar = YYLEX) < 0) yychar = 0;
#if YYDEBUG
            if (yydebug)
            {
                yys = 0;
                if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
                if (!yys) yys = "illegal-symbol";
                printf("%sdebug: state %d, reading %d (%s)\n",
                        YYPREFIX, YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == 0) goto yyaccept;
        goto yyloop;
    }
    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: after reduction, shifting from state %d \
to state %d\n", YYPREFIX, *yystack.s_mark, yystate);
#endif
    if (yystack.s_mark >= yystack.s_last && yygrowstack(&yystack))
    {
        goto yyoverflow;
    }
    *++yystack.s_mark = (short) yystate;
    *++yystack.l_mark = yyval;
    goto yyloop;

yyoverflow:
    yyerror("yacc stack overflow");

yyabort:
    yyfreestack(&yystack);
    return (1);

yyaccept:
    yyfreestack(&yystack);
    return (0);
}
