/* libgdata.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "GData", lower_case_cprefix = "gdata_")]
namespace GData {
	[CCode (cheader_filename = "gdata/gdata.h")]
	public class AccessRule : GData.Entry {
		[CCode (has_construct_function = false)]
		public AccessRule (string id);
		public unowned string get_role ();
		public void get_scope (string type, string value);
		public void set_role (string role);
		public void set_scope (string type, string value);
		public string role { get; set; }
		[NoAccessorMethod]
		public string scope_type { owned get; set; }
		[NoAccessorMethod]
		public string scope_value { owned get; set; }
	}
	[CCode (cheader_filename = "gdata/gdata.h")]
	public class Author : GData.Parsable {
		[CCode (has_construct_function = false)]
		public Author (string name, string uri, string email_address);
		public int compare (GData.Author b);
		public unowned string get_email_address ();
		public unowned string get_name ();
		public unowned string get_uri ();
		public void set_email_address (string email_address);
		public void set_name (string name);
		public void set_uri (string uri);
		public string email_address { get; set; }
		public string name { get; set; }
		public string uri { get; set; }
	}
	[CCode (cheader_filename = "gdata/gdata.h")]
	public class CalendarCalendar : GData.Entry, GData.AccessHandler {
		[CCode (has_construct_function = false)]
		public CalendarCalendar (string id);
		public unowned string get_access_level ();
		public void get_color (GData.Color color);
		public void get_edited (GLib.TimeVal edited);
		public uint get_times_cleaned ();
		public unowned string get_timezone ();
		public void set_color (GData.Color color);
		public void set_is_hidden (bool is_hidden);
		public void set_is_selected (bool is_selected);
		public void set_timezone (string _timezone);
		public string access_level { get; }
		public GData.Color color { get; set; }
		public GLib.TimeVal edited { get; }
		[NoAccessorMethod]
		public bool is_hidden { get; set; }
		[NoAccessorMethod]
		public bool is_selected { get; set; }
		public uint times_cleaned { get; }
		public string timezone { get; set; }
	}
	[CCode (cheader_filename = "gdata/gdata.h")]
	public class CalendarEvent : GData.Entry {
		[CCode (has_construct_function = false)]
		public CalendarEvent (string id);
		public void add_person (GData.GDWho who);
		public void add_place (GData.GDWhere where);
		public void add_time (GData.GDWhen when);
		public bool get_anyone_can_add_self ();
		public void get_edited (GLib.TimeVal edited);
		public bool get_guests_can_invite_others ();
		public bool get_guests_can_modify ();
		public bool get_guests_can_see_guests ();
		public void get_original_event_details (string event_id, string event_uri);
		public unowned GLib.List get_people ();
		public unowned GLib.List get_places ();
		public bool get_primary_time (GLib.TimeVal start_time, GLib.TimeVal end_time, out unowned GData.GDWhen when);
		public unowned string get_recurrence ();
		public uint get_sequence ();
		public unowned string get_status ();
		public unowned GLib.List get_times ();
		public unowned string get_transparency ();
		public unowned string get_uid ();
		public unowned string get_visibility ();
		public bool is_exception ();
		public void set_anyone_can_add_self (bool anyone_can_add_self);
		public void set_guests_can_invite_others (bool guests_can_invite_others);
		public void set_guests_can_modify (bool guests_can_modify);
		public void set_guests_can_see_guests (bool guests_can_see_guests);
		public void set_recurrence (string recurrence);
		public void set_sequence (uint sequence);
		public void set_status (string status);
		public void set_transparency (string transparency);
		public void set_uid (string uid);
		public void set_visibility (string visibility);
		public bool anyone_can_add_self { get; set; }
		public GLib.TimeVal edited { get; }
		public bool guests_can_invite_others { get; set; }
		public bool guests_can_modify { get; set; }
		public bool guests_can_see_guests { get; set; }
		[NoAccessorMethod]
		public string original_event_id { owned get; }
		[NoAccessorMethod]
		public string original_event_uri { owned get; }
		public string recurrence { get; set; }
		public uint sequence { get; set; }
		public string status { get; set; }
		public string transparency { get; set; }
		public string uid { get; set; }
		public string visibility { get; set; }
	}
	[CCode (cheader_filename = "gdata/gdata.h")]
	public class CalendarFeed : GData.Feed {
		public uint get_times_cleaned ();
		public unowned string get_timezone ();
		public uint times_cleaned { get; }
		public string timezone { get; }
	}
	[CCode (cheader_filename = "gdata/gdata.h")]
	public class CalendarQuery : GData.Query {
		[CCode (has_construct_function = false)]
		public CalendarQuery (string q);
		public bool get_future_events ();
		public unowned string get_order_by ();
		public void get_recurrence_expansion_end (GLib.TimeVal end);
		public void get_recurrence_expansion_start (GLib.TimeVal start);
		public bool get_single_events ();
		public unowned string get_sort_order ();
		public void get_start_max (GLib.TimeVal start_max);
		public void get_start_min (GLib.TimeVal start_min);
		public unowned string get_timezone ();
		public void set_future_events (bool future_events);
		public void set_order_by (string order_by);
		public void set_recurrence_expansion_end (GLib.TimeVal end);
		public void set_recurrence_expansion_start (GLib.TimeVal start);
		public void set_single_events (bool single_events);
		public void set_sort_order (string sort_order);
		public void set_start_max (GLib.TimeVal start_max);
		public void set_start_min (GLib.TimeVal start_min);
		public void set_timezone (string _timezone);
		[CCode (has_construct_function = false)]
		public CalendarQuery.with_limits (string q, GLib.TimeVal start_min, GLib.TimeVal start_max);
		public bool future_events { get; set; }
		public string order_by { get; set; }
		public GLib.TimeVal recurrence_expansion_end { get; set; }
		public GLib.TimeVal recurrence_expansion_start { get; set; }
		public bool single_events { get; set; }
		public string sort_order { get; set; }
		public GLib.TimeVal start_max { get; set; }
		public GLib.TimeVal start_min { get; set; }
		public string timezone { get; set; }
	}
	[CCode (cheader_filename = "gdata/gdata.h")]
	public class CalendarService : GData.Service {
		[CCode (has_construct_function = false)]
		public CalendarService (string client_id);
		public unowned GData.CalendarEvent insert_event (GData.CalendarEvent event, GLib.Cancellable cancellable) throws GLib.Error;
		public unowned GData.Feed query_all_calendars (GData.Query query, GLib.Cancellable cancellable, GData.QueryProgressCallback progress_callback, void* progress_user_data) throws GLib.Error;
		public async void query_all_calendars_async (GData.Query query, GLib.Cancellable cancellable, GData.QueryProgressCallback progress_callback, void* progress_user_data);
		public unowned GData.Feed query_events (GData.CalendarCalendar calendar, GData.Query query, GLib.Cancellable cancellable, GData.QueryProgressCallback progress_callback, void* progress_user_data) throws GLib.Error;
		public unowned GData.Feed query_own_calendars (GData.Query query, GLib.Cancellable cancellable, GData.QueryProgressCallback progress_callback, void* progress_user_data) throws GLib.Error;
		public async void query_own_calendars_async (GData.Query query, GLib.Cancellable cancellable, GData.QueryProgressCallback progress_callback, void* progress_user_data);
	}
	[CCode (cheader_filename = "gdata/gdata.h")]
	public class Category : GData.Parsable {
		[CCode (has_construct_function = false)]
		public Category (string term, string scheme, string label);
		public int compare (GData.Category b);
		public unowned string get_label ();
		public unowned string get_scheme ();
		public unowned string get_term ();
		public void set_label (string label);
		public void set_scheme (string scheme);
		public void set_term (string term);
		public string label { get; set; }
		public string scheme { get; set; }
		public string term { get; set; }
	}
	[Compact]
	[CCode (type_id = "GDATA_TYPE_COLOR", cheader_filename = "gdata/gdata.h")]
	public class Color {
		public uint16 blue;
		public uint16 green;
		public uint16 red;
		public static bool from_hexadecimal (string hexadecimal, GData.Color color);
		public unowned string to_hexadecimal ();
	}
	[CCode (cheader_filename = "gdata/gdata.h")]
	public class ContactsContact : GData.Entry {
		[CCode (has_construct_function = false)]
		public ContactsContact (string id);
		public void add_email_address (GData.GDEmailAddress email_address);
		public void add_group (string href);
		public void add_im_address (GData.GDIMAddress im_address);
		public void add_organization (GData.GDOrganization organization);
		public void add_phone_number (GData.GDPhoneNumber phone_number);
		public void add_postal_address (GData.GDPostalAddress postal_address);
		public void get_edited (GLib.TimeVal edited);
		public unowned GLib.List get_email_addresses ();
		public unowned GLib.HashTable get_extended_properties ();
		public unowned string get_extended_property (string name);
		public unowned GLib.List get_groups ();
		public unowned GLib.List get_im_addresses ();
		public unowned GData.GDName get_name ();
		public unowned GLib.List get_organizations ();
		public unowned GLib.List get_phone_numbers ();
		public unowned string get_photo (GData.ContactsService service, size_t length, string content_type, GLib.Cancellable cancellable) throws GLib.Error;
		public unowned GLib.List get_postal_addresses ();
		public unowned GData.GDEmailAddress get_primary_email_address ();
		public unowned GData.GDIMAddress get_primary_im_address ();
		public unowned GData.GDOrganization get_primary_organization ();
		public unowned GData.GDPhoneNumber get_primary_phone_number ();
		public unowned GData.GDPostalAddress get_primary_postal_address ();
		public bool is_deleted ();
		public bool is_group_deleted (string href);
		public void remove_all_email_addresses ();
		public void remove_all_im_addresses ();
		public void remove_all_organizations ();
		public void remove_all_phone_numbers ();
		public void remove_all_postal_addresses ();
		public void remove_group (string href);
		public bool set_extended_property (string name, string value);
		public bool set_photo (GData.Service service, string data, size_t length, GLib.Cancellable cancellable) throws GLib.Error;
		[NoAccessorMethod]
		public bool deleted { get; }
		public GLib.TimeVal edited { get; }
		[NoAccessorMethod]
		public bool has_photo { get; }
		public GData.GDName name { get; }
	}
	[CCode (cheader_filename = "gdata/gdata.h")]
	public class ContactsQuery : GData.Query {
		[CCode (has_construct_function = false)]
		public ContactsQuery (string q);
		public unowned string get_group ();
		public unowned string get_order_by ();
		public unowned string get_sort_order ();
		public void set_group (string group);
		public void set_order_by (string order_by);
		public void set_show_deleted (bool show_deleted);
		public void set_sort_order (string sort_order);
		[CCode (has_construct_function = false)]
		public ContactsQuery.with_limits (string q, int start_index, int max_results);
		public string group { get; set; }
		public string order_by { get; set; }
		[NoAccessorMethod]
		public bool show_deleted { get; set; }
		public string sort_order { get; set; }
	}
	[CCode (cheader_filename = "gdata/gdata.h")]
	public class ContactsService : GData.Service {
		[CCode (has_construct_function = false)]
		public ContactsService (string client_id);
		public unowned GData.ContactsContact insert_contact (GData.ContactsContact contact, GLib.Cancellable cancellable) throws GLib.Error;
		public unowned GData.Feed query_contacts (GData.Query query, GLib.Cancellable cancellable, GData.QueryProgressCallback progress_callback, void* progress_user_data) throws GLib.Error;
		public async void query_contacts_async (GData.Query query, GLib.Cancellable cancellable, GData.QueryProgressCallback progress_callback, void* progress_user_data);
		public unowned GData.ContactsContact update_contact (GData.ContactsContact contact, GLib.Cancellable cancellable) throws GLib.Error;
	}
	[CCode (cheader_filename = "gdata/gdata.h")]
	public class DocumentsEntry : GData.Entry, GData.AccessHandler {
		public unowned string get_document_id ();
		public void get_edited (GLib.TimeVal edited);
		public unowned GData.Author get_last_modified_by ();
		public void get_last_viewed (GLib.TimeVal last_viewed);
		public unowned string get_path ();
		public void set_writers_can_invite (bool writers_can_invite);
		public string document_id { get; }
		public GLib.TimeVal edited { get; }
		[NoAccessorMethod]
		public bool is_deleted { get; set; }
		public GData.Author last_modified_by { get; }
		public GLib.TimeVal last_viewed { get; }
		[NoAccessorMethod]
		public bool writers_can_invite { get; set; }
	}
	[CCode (cheader_filename = "gdata/gdata.h")]
	public class DocumentsFeed : GData.Feed {
	}
	[CCode (cheader_filename = "gdata/gdata.h")]
	public class DocumentsFolder : GData.DocumentsEntry, GData.AccessHandler {
		[CCode (has_construct_function = false)]
		public DocumentsFolder (string id);
	}
	[CCode (cheader_filename = "gdata/gdata.h")]
	public class DocumentsPresentation : GData.DocumentsEntry, GData.AccessHandler {
		[CCode (has_construct_function = false)]
		public DocumentsPresentation (string id);
		public unowned GLib.File download_document (GData.DocumentsService service, string content_type, GData.DocumentsPresentationFormat export_format, GLib.File destination_file, bool replace_file_if_exists, GLib.Cancellable cancellable) throws GLib.Error;
		public unowned string get_download_uri (GData.DocumentsPresentationFormat export_format);
	}
	[CCode (cheader_filename = "gdata/gdata.h")]
	public class DocumentsQuery : GData.Query {
		[CCode (has_construct_function = false)]
		public DocumentsQuery (string q);
		public void add_collaborator (string email_address);
		public void add_reader (string email_address);
		public unowned GLib.List get_collaborator_addresses ();
		public bool get_exact_title ();
		public unowned string get_folder_id ();
		public unowned GLib.List get_reader_addresses ();
		public unowned string get_title ();
		public void set_folder_id (string folder_id);
		public void set_show_deleted (bool show_deleted);
		public void set_show_folders (bool show_folders);
		public void set_title (string title, bool exact_title);
		[CCode (has_construct_function = false)]
		public DocumentsQuery.with_limits (string q, int start_index, int max_results);
		[NoAccessorMethod]
		public bool exact_title { get; set; }
		public string folder_id { get; set; }
		[NoAccessorMethod]
		public bool show_deleted { get; set; }
		[NoAccessorMethod]
		public bool show_folders { get; set; }
		public string title { get; set; }
	}
	[CCode (cheader_filename = "gdata/gdata.h")]
	public class DocumentsService : GData.Service {
		[CCode (has_construct_function = false)]
		public DocumentsService (string client_id);
		public static GLib.Quark error_quark ();
		public static unowned string get_upload_uri (GData.DocumentsFolder folder);
		public unowned GData.DocumentsEntry move_document_to_folder (GData.DocumentsEntry document, GData.DocumentsFolder folder, GLib.Cancellable cancellable) throws GLib.Error;
		public unowned GData.DocumentsFeed query_documents (GData.DocumentsQuery query, GLib.Cancellable cancellable, GData.QueryProgressCallback progress_callback, void* progress_user_data) throws GLib.Error;
		public async void query_documents_async (GData.DocumentsQuery query, GLib.Cancellable cancellable, GData.QueryProgressCallback progress_callback, void* progress_user_data);
		public unowned GData.DocumentsEntry query_single_document (GLib.Type document_type, string document_id, GLib.Cancellable cancellable) throws GLib.Error;
		public unowned GData.DocumentsEntry remove_document_from_folder (GData.DocumentsEntry document, GData.DocumentsFolder folder, GLib.Cancellable cancellable) throws GLib.Error;
		public unowned GData.DocumentsEntry update_document (GData.DocumentsEntry document, GLib.File document_file, GLib.Cancellable cancellable) throws GLib.Error;
		public unowned GData.DocumentsEntry upload_document (GData.DocumentsEntry document, GLib.File document_file, GData.DocumentsFolder folder, GLib.Cancellable cancellable) throws GLib.Error;
		[NoAccessorMethod]
		public GData.Service spreadsheet_service { owned get; }
	}
	[CCode (cheader_filename = "gdata/gdata.h")]
	public class DocumentsSpreadsheet : GData.DocumentsEntry, GData.AccessHandler {
		[CCode (has_construct_function = false)]
		public DocumentsSpreadsheet (string id);
		public unowned GLib.File download_document (GData.DocumentsService service, string content_type, GData.DocumentsSpreadsheetFormat export_format, int gid, GLib.File destination_file, bool replace_file_if_exists, GLib.Cancellable cancellable) throws GLib.Error;
		public unowned string get_download_uri (GData.DocumentsSpreadsheetFormat export_format, int gid);
	}
	[CCode (cheader_filename = "gdata/gdata.h")]
	public class DocumentsText : GData.DocumentsEntry, GData.AccessHandler {
		[CCode (has_construct_function = false)]
		public DocumentsText (string id);
		public unowned GLib.File download_document (GData.DocumentsService service, string content_type, GData.DocumentsTextFormat export_format, GLib.File destination_file, bool replace_file_if_exists, GLib.Cancellable cancellable) throws GLib.Error;
		public unowned string get_download_uri (GData.DocumentsTextFormat export_format);
	}
	[CCode (cheader_filename = "gdata/gdata.h")]
	public class DownloadStream : GLib.InputStream, GLib.Seekable {
		[CCode (type = "GInputStream*", has_construct_function = false)]
		public DownloadStream (GData.Service service, string download_uri);
		public ssize_t get_content_length ();
		public unowned string get_content_type ();
		public unowned string get_download_uri ();
		public unowned GData.Service get_service ();
		public long content_length { get; }
		public string content_type { get; }
		public string download_uri { get; construct; }
		public GData.Service service { get; construct; }
	}
	[CCode (cheader_filename = "gdata/gdata.h")]
	public class Entry : GData.Parsable {
		[CCode (has_construct_function = false)]
		public Entry (string id);
		public void add_author (GData.Author author);
		public void add_category (GData.Category category);
		public void add_link (GData.Link link);
		public unowned GLib.List get_categories ();
		public unowned string get_content ();
		public unowned string get_etag ();
		public unowned string get_id ();
		public void get_published (GLib.TimeVal published);
		public unowned string get_rights ();
		public unowned string get_summary ();
		public unowned string get_title ();
		public void get_updated (GLib.TimeVal updated);
		public unowned GData.Link look_up_link (string rel);
		public unowned GLib.List look_up_links (string rel);
		public void set_content (string content);
		public void set_rights (string rights);
		public void set_summary (string summary);
		public void set_title (string title);
		public string content { get; set; }
		public string etag { get; construct; }
		public string id { get; construct; }
		[NoAccessorMethod]
		public bool is_inserted { get; }
		public GLib.TimeVal published { get; }
		public string rights { get; set; }
		public string summary { get; set; }
		public string title { get; set; }
		public GLib.TimeVal updated { get; }
	}
	[CCode (cheader_filename = "gdata/gdata.h")]
	public class Feed : GData.Parsable {
		public unowned GLib.List<GData.Author> get_authors ();
		public unowned GLib.List<GData.Category> get_categories ();
		public unowned GLib.List<GData.Entry> get_entries ();
		public unowned string get_etag ();
		public unowned GData.Generator get_generator ();
		public unowned string get_icon ();
		public unowned string get_id ();
		public uint get_items_per_page ();
		public unowned GLib.List get_links ();
		public unowned string get_logo ();
		public uint get_start_index ();
		public unowned string get_subtitle ();
		public unowned string get_title ();
		public uint get_total_results ();
		public void get_updated (GLib.TimeVal updated);
		public unowned GData.Entry look_up_entry (string id);
		public unowned GData.Link look_up_link (string rel);
		public string etag { get; }
		public GData.Generator generator { get; }
		public string icon { get; }
		public string id { get; }
		public uint items_per_page { get; }
		public string logo { get; }
		public uint start_index { get; }
		public string subtitle { get; }
		public string title { get; }
		public uint total_results { get; }
		public GLib.TimeVal updated { get; }
	}
	[CCode (cheader_filename = "gdata/gdata.h")]
	public class GDEmailAddress : GData.Parsable {
		[CCode (has_construct_function = false)]
		public GDEmailAddress (string address, string relation_type, string label, bool is_primary);
		public int compare (GData.GDEmailAddress b);
		public unowned string get_address ();
		public unowned string get_display_name ();
		public unowned string get_label ();
		public unowned string get_relation_type ();
		public void set_address (string address);
		public void set_display_name (string display_name);
		public void set_is_primary (bool is_primary);
		public void set_label (string label);
		public void set_relation_type (string relation_type);
		public string address { get; set; }
		public string display_name { get; set; }
		[NoAccessorMethod]
		public bool is_primary { get; set; }
		public string label { get; set; }
		public string relation_type { get; set; }
	}
	[Compact]
	[CCode (cheader_filename = "gdata/gdata.h")]
	public class GDFeedLink {
		public uint count_hint;
		public weak string href;
		public bool read_only;
		public weak string rel;
		[CCode (has_construct_function = false)]
		public GDFeedLink (string href, string rel, uint count_hint, bool read_only);
		public int compare (GData.GDFeedLink b);
	}
	[CCode (cheader_filename = "gdata/gdata.h")]
	public class GDIMAddress : GData.Parsable {
		[CCode (cname = "gdata_gd_im_address_new", has_construct_function = false)]
		public GDIMAddress (string address, string protocol, string relation_type, string label, bool is_primary);
		[CCode (cname = "gdata_gd_im_address_compare")]
		public int compare (GData.GDIMAddress b);
		[CCode (cname = "gdata_gd_im_address_get_address")]
		public unowned string get_address ();
		[CCode (cname = "gdata_gd_im_address_get_label")]
		public unowned string get_label ();
		[CCode (cname = "gdata_gd_im_address_get_protocol")]
		public unowned string get_protocol ();
		[CCode (cname = "gdata_gd_im_address_get_relation_type")]
		public unowned string get_relation_type ();
		[CCode (cname = "gdata_gd_im_address_set_address")]
		public void set_address (string address);
		[CCode (cname = "gdata_gd_im_address_set_is_primary")]
		public void set_is_primary (bool is_primary);
		[CCode (cname = "gdata_gd_im_address_set_label")]
		public void set_label (string label);
		[CCode (cname = "gdata_gd_im_address_set_protocol")]
		public void set_protocol (string protocol);
		[CCode (cname = "gdata_gd_im_address_set_relation_type")]
		public void set_relation_type (string relation_type);
		public string address { get; set; }
		[NoAccessorMethod]
		public bool is_primary { get; set; }
		public string label { get; set; }
		public string protocol { get; set; }
		public string relation_type { get; set; }
	}
	[CCode (cheader_filename = "gdata/gdata.h")]
	public class GDName : GData.Parsable {
		[CCode (has_construct_function = false)]
		public GDName (string given_name, string family_name);
		public int compare (GData.GDName b);
		public unowned string get_additional_name ();
		public unowned string get_family_name ();
		public unowned string get_full_name ();
		public unowned string get_given_name ();
		public unowned string get_prefix ();
		public unowned string get_suffix ();
		public void set_additional_name (string additional_name);
		public void set_family_name (string family_name);
		public void set_full_name (string full_name);
		public void set_given_name (string given_name);
		public void set_prefix (string prefix);
		public void set_suffix (string suffix);
		public string additional_name { get; set; }
		public string family_name { get; set; }
		public string full_name { get; set; }
		public string given_name { get; set; }
		public string prefix { get; set; }
		public string suffix { get; set; }
	}
	[CCode (cheader_filename = "gdata/gdata.h")]
	public class GDOrganization : GData.Parsable {
		[CCode (has_construct_function = false)]
		public GDOrganization (string name, string title, string relation_type, string label, bool is_primary);
		public int compare (GData.GDOrganization b);
		public unowned string get_department ();
		public unowned string get_job_description ();
		public unowned string get_label ();
		public unowned GData.GDWhere get_location ();
		public unowned string get_name ();
		public unowned string get_relation_type ();
		public unowned string get_symbol ();
		public unowned string get_title ();
		public void set_department (string department);
		public void set_is_primary (bool is_primary);
		public void set_job_description (string job_description);
		public void set_label (string label);
		public void set_location (GData.GDWhere location);
		public void set_name (string name);
		public void set_relation_type (string relation_type);
		public void set_symbol (string symbol);
		public void set_title (string title);
		public string department { get; set; }
		[NoAccessorMethod]
		public bool is_primary { get; set; }
		public string job_description { get; set; }
		public string label { get; set; }
		public GData.GDWhere location { get; set; }
		public string name { get; set; }
		public string relation_type { get; set; }
		public string symbol { get; set; }
		public string title { get; set; }
	}
	[CCode (cheader_filename = "gdata/gdata.h")]
	public class GDPhoneNumber : GData.Parsable {
		[CCode (has_construct_function = false)]
		public GDPhoneNumber (string number, string relation_type, string label, string uri, bool is_primary);
		public int compare (GData.GDPhoneNumber b);
		public unowned string get_label ();
		public unowned string get_number ();
		public unowned string get_relation_type ();
		public unowned string get_uri ();
		public void set_is_primary (bool is_primary);
		public void set_label (string label);
		public void set_number (string number);
		public void set_relation_type (string relation_type);
		public void set_uri (string uri);
		[NoAccessorMethod]
		public bool is_primary { get; set; }
		public string label { get; set; }
		public string number { get; set; }
		public string relation_type { get; set; }
		public string uri { get; set; }
	}
	[CCode (cheader_filename = "gdata/gdata.h")]
	public class GDPostalAddress : GData.Parsable {
		[CCode (has_construct_function = false)]
		public GDPostalAddress (string relation_type, string label, bool is_primary);
		public int compare (GData.GDPostalAddress b);
		public unowned string get_address ();
		public unowned string get_agent ();
		public unowned string get_city ();
		public unowned string get_country ();
		public unowned string get_country_code ();
		public unowned string get_house_name ();
		public unowned string get_label ();
		public unowned string get_mail_class ();
		public unowned string get_neighborhood ();
		public unowned string get_po_box ();
		public unowned string get_postcode ();
		public unowned string get_region ();
		public unowned string get_relation_type ();
		public unowned string get_street ();
		public unowned string get_subregion ();
		public unowned string get_usage ();
		public void set_address (string address);
		public void set_agent (string agent);
		public void set_city (string city);
		public void set_country (string country, string country_code);
		public void set_house_name (string house_name);
		public void set_is_primary (bool is_primary);
		public void set_label (string label);
		public void set_mail_class (string mail_class);
		public void set_neighborhood (string neighborhood);
		public void set_po_box (string po_box);
		public void set_postcode (string postcode);
		public void set_region (string region);
		public void set_relation_type (string relation_type);
		public void set_street (string street);
		public void set_subregion (string subregion);
		public void set_usage (string usage);
		public string address { get; set; }
		public string agent { get; set; }
		public string city { get; set; }
		public string country { get; }
		public string country_code { get; }
		public string house_name { get; set; }
		[NoAccessorMethod]
		public bool is_primary { get; set; }
		public string label { get; set; }
		public string mail_class { get; set; }
		public string neighborhood { get; set; }
		public string po_box { get; set; }
		public string postcode { get; set; }
		public string region { get; set; }
		public string relation_type { get; set; }
		public string street { get; set; }
		public string subregion { get; set; }
		public string usage { get; set; }
	}
	[Compact]
	[CCode (cheader_filename = "gdata/gdata.h")]
	public class GDRating {
		public double average;
		public uint max;
		public uint min;
		public uint num_raters;
		[CCode (has_construct_function = false)]
		public GDRating (uint min, uint max, uint num_raters, double average);
		public int compare (GData.GDRating b);
	}
	[CCode (cheader_filename = "gdata/gdata.h")]
	public class GDReminder : GData.Parsable {
		[CCode (has_construct_function = false)]
		public GDReminder (string method, GLib.TimeVal absolute_time, int relative_time);
		public int compare (GData.GDReminder b);
		public void get_absolute_time (GLib.TimeVal absolute_time);
		public unowned string get_method ();
		public int get_relative_time ();
		public void set_absolute_time (GLib.TimeVal absolute_time);
		public void set_method (string method);
		public void set_relative_time (int relative_time);
		public GLib.TimeVal absolute_time { get; set; }
		[NoAccessorMethod]
		public bool is_absolute_time { get; }
		public string method { get; set; }
		public int relative_time { get; set; }
	}
	[CCode (cheader_filename = "gdata/gdata.h")]
	public class GDWhen : GData.Parsable {
		[CCode (has_construct_function = false)]
		public GDWhen (GLib.TimeVal start_time, GLib.TimeVal end_time, bool is_date);
		public int compare (GData.GDWhen b);
		public void get_end_time (GLib.TimeVal end_time);
		public unowned GLib.List get_reminders ();
		public void get_start_time (GLib.TimeVal start_time);
		public unowned string get_value_string ();
		public void set_end_time (GLib.TimeVal end_time);
		public void set_is_date (bool is_date);
		public void set_start_time (GLib.TimeVal start_time);
		public void set_value_string (string value_string);
		public GLib.TimeVal end_time { get; set; }
		[NoAccessorMethod]
		public bool is_date { get; set; }
		public GLib.TimeVal start_time { get; set; }
		public string value_string { get; set; }
	}
	[CCode (cheader_filename = "gdata/gdata.h")]
	public class GDWhere : GData.Parsable {
		[CCode (has_construct_function = false)]
		public GDWhere (string relation_type, string value_string, string label);
		public int compare (GData.GDWhere b);
		public unowned string get_label ();
		public unowned string get_relation_type ();
		public unowned string get_value_string ();
		public void set_label (string label);
		public void set_relation_type (string relation_type);
		public void set_value_string (string value_string);
		public string label { get; set; }
		public string relation_type { get; set; }
		public string value_string { get; set; }
	}
	[CCode (cheader_filename = "gdata/gdata.h")]
	public class GDWho : GData.Parsable {
		[CCode (has_construct_function = false)]
		public GDWho (string relation_type, string value_string, string email_address);
		public int compare (GData.GDWho b);
		public unowned string get_email_address ();
		public unowned string get_relation_type ();
		public unowned string get_value_string ();
		public void set_email_address (string email_address);
		public void set_relation_type (string relation_type);
		public void set_value_string (string value_string);
		public string email_address { get; set; }
		public string relation_type { get; set; }
		public string value_string { get; set; }
	}
	[Compact]
	[CCode (type_id = "GDATA_TYPE_GTIME_VAL", cheader_filename = "gdata/gdata.h")]
	public class GTimeVal {
	}
	[CCode (cheader_filename = "gdata/gdata.h")]
	public class Generator : GData.Parsable {
		[CCode (has_construct_function = false)]
		public Generator (string name, string uri, string version);
		public int compare (GData.Generator b);
		public unowned string get_name ();
		public unowned string get_uri ();
		public unowned string get_version ();
		public string name { get; }
		public string uri { get; }
		public string version { get; }
	}
	[CCode (cheader_filename = "gdata/gdata.h")]
	public class Link : GData.Parsable {
		[CCode (has_construct_function = false)]
		public Link (string uri, string relation_type);
		public int compare (GData.Link b);
		public unowned string get_content_type ();
		public unowned string get_language ();
		public int get_length ();
		public unowned string get_relation_type ();
		public unowned string get_title ();
		public unowned string get_uri ();
		public void set_content_type (string content_type);
		public void set_language (string language);
		public void set_length (int length);
		public void set_relation_type (string relation_type);
		public void set_title (string title);
		public void set_uri (string uri);
		public string content_type { get; set; }
		public string language { get; set; }
		public int length { get; set; }
		public string relation_type { get; set; }
		public string title { get; set; }
		public string uri { get; set; }
	}
	[CCode (cheader_filename = "gdata/gdata.h")]
	public class MediaCategory : GData.Parsable {
		[CCode (has_construct_function = false)]
		public MediaCategory (string category, string scheme, string label);
		public unowned string get_category ();
		public unowned string get_label ();
		public unowned string get_scheme ();
		public void set_category (string category);
		public void set_label (string label);
		public void set_scheme (string scheme);
		public string category { get; set; }
		public string label { get; set; }
		public string scheme { get; set; }
	}
	[CCode (cheader_filename = "gdata/gdata.h")]
	public class MediaContent : GData.Parsable {
		[CCode (has_construct_function = false)]
		public MediaContent (string uri, string type, bool is_default, GData.MediaExpression expression, int duration, int format);
		public unowned GLib.File download (GData.Service service, string default_filename, GLib.File target_dest_file, bool replace_file_if_exists, GLib.Cancellable cancellable) throws GLib.Error;
		public unowned string get_content_type ();
		public int64 get_duration ();
		public GData.MediaExpression get_expression ();
		public size_t get_filesize ();
		public uint get_height ();
		public GData.MediaMedium get_medium ();
		public unowned string get_uri ();
		public uint get_width ();
		public string content_type { get; }
		public int64 duration { get; }
		public GData.MediaExpression expression { get; }
		public ulong filesize { get; }
		public uint height { get; }
		[NoAccessorMethod]
		public bool is_default { get; }
		public GData.MediaMedium medium { get; }
		public string uri { get; }
		public uint width { get; }
	}
	[CCode (cheader_filename = "gdata/gdata.h")]
	public class MediaCredit : GData.Parsable {
		[CCode (has_construct_function = false)]
		public MediaCredit (string credit, bool partner);
		public unowned string get_credit ();
		public unowned string get_role ();
		public unowned string get_scheme ();
		public string credit { get; }
		public string role { get; }
		public string scheme { get; }
	}
	[Compact]
	[CCode (cheader_filename = "gdata/gdata.h")]
	public class MediaRating {
		public weak string country;
		public weak string scheme;
		[CCode (has_construct_function = false)]
		public MediaRating (string scheme, string country);
	}
	[Compact]
	[CCode (cheader_filename = "gdata/gdata.h")]
	public class MediaRestriction {
		public weak string countries;
		public bool relationship;
		[CCode (has_construct_function = false)]
		public MediaRestriction (string countries, bool relationship);
	}
	[CCode (cheader_filename = "gdata/gdata.h")]
	public class MediaThumbnail : GData.Parsable {
		[CCode (has_construct_function = false)]
		public MediaThumbnail (string uri, uint width, uint height, int64 _time);
		public static unowned string build_time (int64 _time);
		public unowned GLib.File download (GData.Service service, string default_filename, GLib.File target_dest_file, bool replace_file_if_exists, GLib.Cancellable cancellable) throws GLib.Error;
		public uint get_height ();
		public int64 get_time ();
		public unowned string get_uri ();
		public uint get_width ();
		public static int64 parse_time (string time_string);
		public uint height { get; }
		public int64 time { get; }
		public string uri { get; }
		public uint width { get; }
	}
	[CCode (cheader_filename = "gdata/gdata.h")]
	public class Parsable : GLib.Object {
		[CCode (has_construct_function = false)]
		public Parsable.from_xml (GLib.Type parsable_type, string xml, int length) throws GLib.Error;
		[NoWrapper]
		public virtual void get_namespaces (GLib.HashTable namespaces);
		public virtual void get_xml ();
		[NoWrapper]
		public virtual bool parse_xml (Xml.Doc doc, Xml.Node node) throws GLib.Error;
		[NoWrapper]
		public virtual bool post_parse_xml (void* user_data) throws GLib.Error;
		[NoWrapper]
		public virtual void pre_get_xml (GLib.StringBuilder xml_string);
		[NoWrapper]
		public virtual bool pre_parse_xml (Xml.Doc doc, Xml.Node root_node) throws GLib.Error;
	}
	[CCode (type_check_function = "GDATA_IS_PICASAWEB_ALBUM",lower_case_cprefix="gdata_picasaweb_album_", cheader_filename = "gdata/gdata.h")]
	public class PicasaWebAlbum : GData.Entry {
		[CCode (cname = "gdata_picasaweb_album_new", has_construct_function = false)]
		public PicasaWebAlbum (string id);
		[CCode (cname = "gdata_picasaweb_album_get_bytes_used")]
		public long get_bytes_used ();
		[CCode (cname = "gdata_picasaweb_album_get_comment_count")]
		public uint get_comment_count ();
		[CCode (cname = "gdata_picasaweb_album_get_contents")]
		public unowned GLib.List get_contents ();
		[CCode (cname = "gdata_picasaweb_album_get_coordinates")]
		public void get_coordinates (double latitude, double longitude);
		[CCode (cname = "gdata_picasaweb_album_get_edited")]
		public void get_edited (GLib.TimeVal edited);
		[CCode (cname = "gdata_picasaweb_album_get_location")]
		public unowned string get_location ();
		[CCode (cname = "gdata_picasaweb_album_get_nickname")]
		public unowned string get_nickname ();
		[CCode (cname = "gdata_picasaweb_album_get_num_photos")]
		public uint get_num_photos ();
		[CCode (cname = "gdata_picasaweb_album_get_num_photos_remaining")]
		public uint get_num_photos_remaining ();
		[CCode (cname = "gdata_picasaweb_album_get_tags")]
		public unowned string get_tags ();
		[CCode (cname = "gdata_picasaweb_album_get_thumbnails")]
		public unowned GLib.List get_thumbnails ();
		[CCode (cname = "gdata_picasaweb_album_get_timestamp")]
		public void get_timestamp (GLib.TimeVal timestamp);
		[CCode (cname = "gdata_picasaweb_album_get_user")]
		public unowned string get_user ();
		[CCode (cname = "gdata_picasaweb_album_get_visibility")]
		public GData.PicasaWebVisibility get_visibility ();
		[CCode (cname = "gdata_picasaweb_album_set_coordinates")]
		public void set_coordinates (double latitude, double longitude);
		[CCode (cname = "gdata_picasaweb_album_set_is_commenting_enabled")]
		public void set_is_commenting_enabled (bool is_commenting_enabled);
		[CCode (cname = "gdata_picasaweb_album_set_location")]
		public void set_location (string location);
		[CCode (cname = "gdata_picasaweb_album_set_tags")]
		public void set_tags (string tags);
		[CCode (cname = "gdata_picasaweb_album_set_timestamp")]
		public void set_timestamp (GLib.TimeVal timestamp);
		[CCode (cname = "gdata_picasaweb_album_set_visibility")]
		public void set_visibility (GData.PicasaWebVisibility visibility);
		public long bytes_used { get; }
		public uint comment_count { get; }
		public GLib.TimeVal edited { get; }
		[NoAccessorMethod]
		public bool is_commenting_enabled { get; set; }
		[NoAccessorMethod]
		public double latitude { get; set; }
		public string location { get; set; }
		[NoAccessorMethod]
		public double longitude { get; set; }
		public string nickname { get; }
		public uint num_photos { get; }
		public uint num_photos_remaining { get; }
		public string tags { get; set; }
		public GLib.TimeVal timestamp { get; set; }
		public string user { get; }
		public GData.PicasaWebVisibility visibility { get; set; }
	}
	[CCode (cheader_filename = "gdata/gdata.h")]
	public class PicasaWebFeed : GData.Feed {
	}
	[CCode (type_check_function = "GDATA_IS_PICASAWEB_FILE",lower_case_cprefix="gdata_picasaweb_file_", cheader_filename = "gdata/gdata.h")]
	public class PicasaWebFile : GData.Entry {
		[CCode (cname = "gdata_picasaweb_file_new", has_construct_function = false)]
		public PicasaWebFile (string id);
		[CCode (cname = "gdata_picasaweb_file_get_album_id")]
		public unowned string get_album_id ();
		[CCode (cname = "gdata_picasaweb_file_get_caption")]
		public unowned string get_caption ();
		[CCode (cname = "gdata_picasaweb_file_get_checksum")]
		public unowned string get_checksum ();
		[CCode (cname = "gdata_picasaweb_file_get_client")]
		public unowned string get_client ();
		[CCode (cname = "gdata_picasaweb_file_get_comment_count")]
		public uint get_comment_count ();
		[CCode (cname = "gdata_picasaweb_file_get_contents")]
		public unowned GLib.List get_contents ();
		[CCode (cname = "gdata_picasaweb_file_get_coordinates")]
		public void get_coordinates (double latitude, double longitude);
		[CCode (cname = "gdata_picasaweb_file_get_credit")]
		public unowned string get_credit ();
		[CCode (cname = "gdata_picasaweb_file_get_distance")]
		public double get_distance ();
		[CCode (cname = "gdata_picasaweb_file_get_edited")]
		public void get_edited (GLib.TimeVal edited);
		[CCode (cname = "gdata_picasaweb_file_get_exposure")]
		public double get_exposure ();
		[CCode (cname = "gdata_picasaweb_file_get_flash")]
		public bool get_flash ();
		[CCode (cname = "gdata_picasaweb_file_get_focal_length")]
		public double get_focal_length ();
		[CCode (cname = "gdata_picasaweb_file_get_fstop")]
		public double get_fstop ();
		[CCode (cname = "gdata_picasaweb_file_get_height")]
		public uint get_height ();
		[CCode (cname = "gdata_picasaweb_file_get_image_unique_id")]
		public unowned string get_image_unique_id ();
		[CCode (cname = "gdata_picasaweb_file_get_iso")]
		public int get_iso ();
		[CCode (cname = "gdata_picasaweb_file_get_make")]
		public unowned string get_make ();
		[CCode (cname = "gdata_picasaweb_file_get_model")]
		public unowned string get_model ();
		[CCode (cname = "gdata_picasaweb_file_get_position")]
		public double get_position ();
		[CCode (cname = "gdata_picasaweb_file_get_rotation")]
		public uint get_rotation ();
		[CCode (cname = "gdata_picasaweb_file_get_size")]
		public size_t get_size ();
		[CCode (cname = "gdata_picasaweb_file_get_tags")]
		public unowned string get_tags ();
		[CCode (cname = "gdata_picasaweb_file_get_thumbnails")]
		public unowned GLib.List get_thumbnails ();
		[CCode (cname = "gdata_picasaweb_file_get_timestamp")]
		public void get_timestamp (GLib.TimeVal timestamp);
		[CCode (cname = "gdata_picasaweb_file_get_version")]
		public unowned string get_version ();
		[CCode (cname = "gdata_picasaweb_file_get_video_status")]
		public unowned string get_video_status ();
		[CCode (cname = "gdata_picasaweb_file_get_width")]
		public uint get_width ();
		[CCode (cname = "gdata_picasaweb_file_set_album_id")]
		public void set_album_id (string album_id);
		[CCode (cname = "gdata_picasaweb_file_set_caption")]
		public void set_caption (string caption);
		[CCode (cname = "gdata_picasaweb_file_set_checksum")]
		public void set_checksum (string checksum);
		[CCode (cname = "gdata_picasaweb_file_set_client")]
		public void set_client (string client);
		[CCode (cname = "gdata_picasaweb_file_set_coordinates")]
		public void set_coordinates (double latitude, double longitude);
		[CCode (cname = "gdata_picasaweb_file_set_is_commenting_enabled")]
		public void set_is_commenting_enabled (bool is_commenting_enabled);
		[CCode (cname = "gdata_picasaweb_file_set_position")]
		public void set_position (double position);
		[CCode (cname = "gdata_picasaweb_file_set_rotation")]
		public void set_rotation (uint rotation);
		[CCode (cname = "gdata_picasaweb_file_set_tags")]
		public void set_tags (string tags);
		[CCode (cname = "gdata_picasaweb_file_set_timestamp")]
		public void set_timestamp (GLib.TimeVal timestamp);
		public string album_id { get; set; }
		public string caption { get; set; }
		public string checksum { get; set; }
		public string client { get; set; }
		public uint comment_count { get; }
		public string credit { get; }
		public double distance { get; }
		public GLib.TimeVal edited { get; }
		public double exposure { get; }
		public bool flash { get; }
		public double focal_length { get; }
		public double fstop { get; }
		public uint height { get; }
		public string image_unique_id { get; }
		[NoAccessorMethod]
		public bool is_commenting_enabled { get; set; }
		public long iso { get; }
		[NoAccessorMethod]
		public double latitude { get; set; }
		[NoAccessorMethod]
		public double longitude { get; set; }
		public string make { get; }
		public string model { get; }
		public double position { get; set; }
		public uint rotation { get; set; }
		public ulong size { get; }
		public string tags { get; set; }
		public GLib.TimeVal timestamp { get; set; }
		public string version { get; construct; }
		public string video_status { get; }
		public uint width { get; }
	}
	[CCode (type_check_function = "GDATA_IS_PICASAWEB_QUERY", cheader_filename = "gdata/gdata.h")]
	public class PicasaWebQuery : GData.Query {
		[CCode (cname = "gdata_picasaweb_query_new", has_construct_function = false)]
		public PicasaWebQuery (string q);
		[CCode (cname = "gdata_picasaweb_query_get_bounding_box")]
		public void get_bounding_box (double north, double east, double south, double west);
		[CCode (cname = "gdata_picasaweb_query_get_image_size")]
		public unowned string get_image_size ();
		[CCode (cname = "gdata_picasaweb_query_get_location")]
		public unowned string get_location ();
		[CCode (cname = "gdata_picasaweb_query_get_tag")]
		public unowned string get_tag ();
		[CCode (cname = "gdata_picasaweb_query_get_thumbnail_size")]
		public unowned string get_thumbnail_size ();
		[CCode (cname = "gdata_picasaweb_query_get_visibility")]
		public GData.PicasaWebVisibility get_visibility ();
		[CCode (cname = "gdata_picasaweb_query_set_bounding_box")]
		public void set_bounding_box (double north, double east, double south, double west);
		[CCode (cname = "gdata_picasaweb_query_set_image_size")]
		public void set_image_size (string image_size);
		[CCode (cname = "gdata_picasaweb_query_set_location")]
		public void set_location (string location);
		[CCode (cname = "gdata_picasaweb_query_set_tag")]
		public void set_tag (string tag);
		[CCode (cname = "gdata_picasaweb_query_set_thumbnail_size")]
		public void set_thumbnail_size (string thumbnail_size);
		[CCode (cname = "gdata_picasaweb_query_set_visibility")]
		public void set_visibility (GData.PicasaWebVisibility visibility);
		[CCode (cname = "gdata_picasaweb_query_new_with_limits", has_construct_function = false)]
		public PicasaWebQuery.with_limits (string q, int start_index, int max_results);
		public string image_size { get; set; }
		public string location { get; set; }
		public string tag { get; set; }
		public string thumbnail_size { get; set; }
		public int visibility { get; set; }
	}
	[CCode (type_check_function = "GDATA_IS_PICASAWEB_SERVICE", cheader_filename = "gdata/gdata.h")]
	public class PicasaWebService : GData.Service {
		[CCode (cname = "gdata_picasaweb_service_new", has_construct_function = false)]
		public PicasaWebService (string client_id);
		[CCode (cname = "gdata_picasaweb_service_get_user")]
		public unowned GData.PicasaWebUser get_user (string username, GLib.Cancellable cancellable) throws GLib.Error;
		[CCode (cname = "gdata_picasaweb_service_insert_album")]
		public unowned GData.PicasaWebAlbum insert_album (GData.PicasaWebAlbum album, GLib.Cancellable cancellable) throws GLib.Error;
		[CCode (cname = "gdata_picasaweb_service_query_all_albums")]
		public unowned GData.Feed query_all_albums (GData.Query? query, string? username, GLib.Cancellable? cancellable, GData.QueryProgressCallback? progress_callback) throws GLib.Error;
		[CCode (cname = "gdata_picasaweb_service_query_all_albums_async")]
		public async void query_all_albums_async (GData.Query? query, string username, GLib.Cancellable? cancellable, GData.QueryProgressCallback progress_callback);
		[CCode (cname = "gdata_picasaweb_service_query_files")]
		public unowned GData.Feed query_files (GData.PicasaWebAlbum album, GData.Query? query, GLib.Cancellable? cancellable, GData.QueryProgressCallback? progress_callback) throws GLib.Error;
		[CCode (cname = "gdata_picasaweb_service_upload_file")]
		public unowned GData.PicasaWebFile upload_file (GData.PicasaWebAlbum album, GData.PicasaWebFile file_entry, GLib.File file_data, GLib.Cancellable cancellable) throws GLib.Error;
		[CCode (cname = "gdata_picasaweb_service_upload_file_async")]
		public async GData.PicasaWebFile upload_file_async (GData.PicasaWebAlbum album, GData.PicasaWebFile file_entry, GLib.File file_data, GLib.Cancellable? cancellable = null) throws GLib.Error;
	}
	[CCode (cheader_filename = "gdata/gdata.h")]
	public class PicasaWebUser : GData.Entry {
		[CCode (cname = "gdata_picasaweb_user_get_max_photos_per_album")]
		public int get_max_photos_per_album ();
		[CCode (cname = "gdata_picasaweb_user_get_nickname")]
		public unowned string get_nickname ();
		[CCode (cname = "gdata_picasaweb_user_get_quota_current")]
		public int64 get_quota_current ();
		[CCode (cname = "gdata_picasaweb_user_get_quota_limit")]
		public int64 get_quota_limit ();
		[CCode (cname = "gdata_picasaweb_user_get_thumbnail_uri")]
		public unowned string get_thumbnail_uri ();
		[CCode (cname = "gdata_picasaweb_user_get_user")]
		public unowned string get_user ();
		public int max_photos_per_album { get; }
		public string nickname { get; }
		public int64 quota_current { get; }
		public int64 quota_limit { get; }
		public string thumbnail_uri { get; }
		public string user { get; }
	}
	[CCode (cheader_filename = "gdata/gdata.h")]
	public class Query : GLib.Object {
		[CCode (has_construct_function = false)]
		public Query (string q);
		[CCode (has_construct_function = false)]
		public Query.for_id (string entry_id);
		public unowned string get_author ();
		public unowned string get_categories ();
		public unowned string get_entry_id ();
		public unowned string get_etag ();
		public int get_max_results ();
		public void get_published_max (GLib.TimeVal published_max);
		public void get_published_min (GLib.TimeVal published_min);
		public unowned string get_q ();
		public virtual void get_query_uri (string feed_uri);
		public int get_start_index ();
		public void get_updated_max (GLib.TimeVal updated_max);
		public void get_updated_min (GLib.TimeVal updated_min);
		public void next_page ();
		public bool previous_page ();
		public void set_author (string author);
		public void set_categories (string categories);
		public void set_entry_id (string entry_id);
		public void set_etag (string etag);
		public void set_is_strict (bool is_strict);
		public void set_max_results (int max_results);
		public void set_published_max (GLib.TimeVal published_max);
		public void set_published_min (GLib.TimeVal published_min);
		public void set_q (string q);
		public void set_start_index (int start_index);
		public void set_updated_max (GLib.TimeVal updated_max);
		public void set_updated_min (GLib.TimeVal updated_min);
		[CCode (has_construct_function = false)]
		public Query.with_limits (string q, int start_index, int max_results);
		public string author { get; set; }
		public string categories { get; set; }
		public string entry_id { get; set; }
		public string etag { get; set; }
		[NoAccessorMethod]
		public bool is_strict { get; set; }
		public int max_results { get; set; }
		public GLib.TimeVal published_max { get; set; }
		public GLib.TimeVal published_min { get; set; }
		public string q { get; set; }
		public int start_index { get; set; }
		public GLib.TimeVal updated_max { get; set; }
		public GLib.TimeVal updated_min { get; set; }
	}
	[CCode (cheader_filename = "gdata/gdata.h")]
	public class Service : GLib.Object {
		[NoWrapper]
		public virtual void append_query_headers (Soup.Message message);
		public bool authenticate (string username, string password, GLib.Cancellable? cancellable) throws GLib.Error;
		public async bool authenticate_async (string username, string password, GLib.Cancellable cancellable) throws GLib.Error;
		public bool authenticate_finish (GLib.AsyncResult async_result) throws GLib.Error;
		public bool delete_entry (GData.Entry entry, GLib.Cancellable cancellable) throws GLib.Error;
		public async bool delete_entry_async (GData.Entry entry, GLib.Cancellable cancellable) throws GLib.Error;
		public bool delete_entry_finish (GLib.AsyncResult async_result) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public unowned string get_client_id ();
		public unowned string get_password ();
		public unowned Soup.URI get_proxy_uri ();
		public unowned string get_username ();
		public unowned GData.Entry insert_entry (string upload_uri, GData.Entry entry, GLib.Cancellable cancellable) throws GLib.Error;
		public async unowned GData.Entry insert_entry_async (string upload_uri, GData.Entry entry, GLib.Cancellable cancellable) throws GLib.Error;
		public unowned GData.Entry insert_entry_finish (GLib.AsyncResult async_result) throws GLib.Error;
		public bool is_authenticated ();
		[NoWrapper]
		public virtual bool parse_authentication_response (uint status, string response_body, int length) throws GLib.Error;
		[NoWrapper]
		public virtual void parse_error_response (GData.OperationType operation_type, uint status, string reason_phrase, string response_body, int length) throws GLib.Error;
		public unowned GData.Feed query (string feed_uri, GData.Query query, GLib.Type entry_type, GLib.Cancellable cancellable, GData.QueryProgressCallback progress_callback, void* progress_user_data) throws GLib.Error;
		public async unowned GData.Feed query_async (string feed_uri, GData.Query query, GLib.Type entry_type, GLib.Cancellable cancellable, GData.QueryProgressCallback progress_callback, void* progress_user_data) throws GLib.Error;
		public unowned GData.Feed query_finish (GLib.AsyncResult async_result) throws GLib.Error;
		public void set_proxy_uri (Soup.URI proxy_uri);
		public unowned GData.Entry update_entry (GData.Entry entry, GLib.Cancellable cancellable) throws GLib.Error;
		public async unowned GData.Entry update_entry_async (GData.Entry entry, GLib.Cancellable cancellable) throws GLib.Error;
		public unowned GData.Entry update_entry_finish (GLib.AsyncResult async_result) throws GLib.Error;
		[NoAccessorMethod]
		public bool authenticated { get; }
		public string client_id { get; construct; }
		public string password { get; }
		public Soup.URI proxy_uri { get; set; }
		public string username { get; }
		public virtual signal unowned string captcha_challenge (string p0);
	}
	[CCode (cheader_filename = "gdata/gdata.h")]
	public class UploadStream : GLib.OutputStream {
		[CCode (type = "GOutputStream*", has_construct_function = false)]
		public UploadStream (GData.Service service, string method, string upload_uri, GData.Entry entry, string slug, string content_type);
		public unowned string get_content_type ();
		public unowned GData.Entry get_entry ();
		public unowned string get_response (ssize_t length);
		public unowned GData.Service get_service ();
		public unowned string get_slug ();
		public unowned string get_upload_uri ();
		public string content_type { get; construct; }
		public GData.Entry entry { get; construct; }
		public GData.Service service { get; construct; }
		public string slug { get; construct; }
		public string upload_uri { get; construct; }
	}
	[CCode (type_check_function = "GDATA_IS_YOUTUBE_CONTENT", cheader_filename = "gdata/gdata.h")]
	public class YouTubeContent : GData.MediaContent {
		[CCode (cname = "gdata_youtube_content_get_format")]
		public GData.YouTubeFormat get_format ();
		public GData.YouTubeFormat format { get; }
	}
	[CCode (type_check_function = "GDATA_IS_YOUTUBE_CREDIT", cheader_filename = "gdata/gdata.h")]
	public class YouTubeCredit : GData.MediaCredit {
		[CCode (cname = "gdata_youtube_credit_get_entity_type")]
		public unowned string get_entity_type ();
		public string entity_type { get; }
	}
	[CCode (type_check_function = "GDATA_IS_YOUTUBE_QUERY", cheader_filename = "gdata/gdata.h")]
	public class YouTubeQuery : GData.Query {
		[CCode (cname = "gdata_youtube_query_new", has_construct_function = false)]
		public YouTubeQuery (string q);
		[CCode (cname = "gdata_youtube_query_get_age")]
		public GData.YouTubeAge get_age ();
		[CCode (cname = "gdata_youtube_query_get_format")]
		public GData.YouTubeFormat get_format ();
		[CCode (cname = "gdata_youtube_query_get_language")]
		public unowned string get_language ();
		[CCode (cname = "gdata_youtube_query_get_location")]
		public void get_location (double latitude, double longitude, double radius, bool has_location);
		[CCode (cname = "gdata_youtube_query_get_order_by")]
		public unowned string get_order_by ();
		[CCode (cname = "gdata_youtube_query_get_restriction")]
		public unowned string get_restriction ();
		[CCode (cname = "gdata_youtube_query_get_safe_search")]
		public GData.YouTubeSafeSearch get_safe_search ();
		[CCode (cname = "gdata_youtube_query_get_sort_order")]
		public GData.YouTubeSortOrder get_sort_order ();
		[CCode (cname = "gdata_youtube_query_get_uploader")]
		public GData.YouTubeUploader get_uploader ();
		[CCode (cname = "gdata_youtube_query_set_age")]
		public void set_age (GData.YouTubeAge age);
		[CCode (cname = "gdata_youtube_query_set_format")]
		public void set_format (GData.YouTubeFormat format);
		[CCode (cname = "gdata_youtube_query_set_language")]
		public void set_language (string language);
		[CCode (cname = "gdata_youtube_query_set_location")]
		public void set_location (double latitude, double longitude, double radius, bool has_location);
		[CCode (cname = "gdata_youtube_query_set_order_by")]
		public void set_order_by (string order_by);
		[CCode (cname = "gdata_youtube_query_set_restriction")]
		public void set_restriction (string restriction);
		[CCode (cname = "gdata_youtube_query_set_safe_search")]
		public void set_safe_search (GData.YouTubeSafeSearch safe_search);
		[CCode (cname = "gdata_youtube_query_set_sort_order")]
		public void set_sort_order (GData.YouTubeSortOrder sort_order);
		[CCode (cname = "gdata_youtube_query_set_uploader")]
		public void set_uploader (GData.YouTubeUploader uploader);
		public GData.YouTubeAge age { get; set; }
		public GData.YouTubeFormat format { get; set; }
		[NoAccessorMethod]
		public bool has_location { get; set; }
		public string language { get; set; }
		[NoAccessorMethod]
		public double latitude { get; set; }
		[NoAccessorMethod]
		public double location_radius { get; set; }
		[NoAccessorMethod]
		public double longitude { get; set; }
		public string order_by { get; set; }
		public string restriction { get; set; }
		public GData.YouTubeSafeSearch safe_search { get; set; }
		public GData.YouTubeSortOrder sort_order { get; set; }
		public GData.YouTubeUploader uploader { get; set; }
	}
	[CCode (type_check_function = "GDATA_IS_YOUTUBE_SERVICE", cheader_filename = "gdata/gdata.h")]
	public class YouTubeService : GData.Service {
		[CCode (cname = "gdata_youtube_service_new", has_construct_function = false)]
		public YouTubeService (string developer_key, string client_id);
		[CCode (cname = "gdata_youtube_service_error_quark")]
		public static GLib.Quark error_quark ();
		[CCode (cname = "gdata_youtube_service_get_developer_key")]
		public unowned string get_developer_key ();
		[CCode (cname = "gdata_youtube_service_get_youtube_user")]
		public unowned string get_youtube_user ();
		[CCode (cname = "gdata_youtube_service_query_related")]
		public unowned GData.Feed query_related (GData.YouTubeVideo video, GData.Query query, GLib.Cancellable cancellable, GData.QueryProgressCallback progress_callback, void* progress_user_data) throws GLib.Error;
		[CCode (cname = "gdata_youtube_service_query_related_async")]
		public async void query_related_async (GData.YouTubeVideo video, GData.Query query, GLib.Cancellable cancellable, GData.QueryProgressCallback progress_callback, void* progress_user_data);
		[CCode (cname = "gdata_youtube_service_query_single_video")]
		public unowned GData.YouTubeVideo query_single_video (GData.Query query, string video_id, GLib.Cancellable cancellable) throws GLib.Error;
		[CCode (cname = "gdata_youtube_service_query_single_video_async")]
		public async unowned GData.YouTubeVideo query_single_video_async (GData.Query query, string video_id, GLib.Cancellable cancellable) throws GLib.Error;
		[CCode (cname = "gdata_youtube_service_query_single_video_finish")]
		public unowned GData.YouTubeVideo query_single_video_finish (GLib.AsyncResult async_result) throws GLib.Error;
		[CCode (cname = "gdata_youtube_service_query_standard_feed")]
		public unowned GData.Feed query_standard_feed (GData.YouTubeStandardFeedType feed_type, GData.Query query, GLib.Cancellable cancellable, GData.QueryProgressCallback progress_callback, void* progress_user_data) throws GLib.Error;
		[CCode (cname = "gdata_youtube_service_query_standard_feed_async")]
		public async void query_standard_feed_async (GData.YouTubeStandardFeedType feed_type, GData.Query? query, GLib.Cancellable? cancellable, GData.QueryProgressCallback? progress_callback);
		[CCode (cname = "gdata_youtube_service_query_videos")]
		public unowned GData.Feed query_videos (GData.Query query, GLib.Cancellable cancellable, GData.QueryProgressCallback progress_callback, void* progress_user_data) throws GLib.Error;
		[CCode (cname = "gdata_youtube_service_query_videos_async")]
		public async void query_videos_async (GData.Query query, GLib.Cancellable cancellable, GData.QueryProgressCallback progress_callback, void* progress_user_data);
		[CCode (cname = "gdata_youtube_service_upload_video")]
		public unowned GData.YouTubeVideo upload_video (GData.YouTubeVideo video, GLib.File video_file, GLib.Cancellable cancellable) throws GLib.Error;
		public string developer_key { get; construct; }
		public string youtube_user { get; }
	}
	[CCode (type_check_function = "GDATA_IS_YOUTUBE_STATE", cheader_filename = "gdata/gdata.h")]
	public class YouTubeState : GData.Parsable {
		[CCode (cname = "gdata_youtube_state_new", has_construct_function = false)]
		public YouTubeState (string name, string message, string reason_code, string help_uri);
		[CCode (cname = "gdata_youtube_state_get_help_uri")]
		public unowned string get_help_uri ();
		[CCode (cname = "gdata_youtube_state_get_message")]
		public unowned string get_message ();
		[CCode (cname = "gdata_youtube_state_get_name")]
		public unowned string get_name ();
		[CCode (cname = "gdata_youtube_state_get_reason_code")]
		public unowned string get_reason_code ();
		public string help_uri { get; }
		public string message { get; }
		public string name { get; }
		public string reason_code { get; }
	}
	[CCode (type_check_function = "GDATA_IS_YOUTUBE_VIDEO", cheader_filename = "gdata/gdata.h")]
	public class YouTubeVideo : GData.Entry {
		[CCode (cname = "gdata_youtube_video_new", has_construct_function = false)]
		public YouTubeVideo (string id);
		[CCode (cname = "gdata_youtube_video_get_aspect_ratio")]
		public GData.YouTubeAspectRatio get_aspect_ratio ();
		[CCode (cname = "gdata_youtube_video_get_category")]
		public unowned GData.MediaCategory get_category ();
		[CCode (cname = "gdata_youtube_video_get_credit")]
		public unowned GData.YouTubeCredit get_credit ();
		[CCode (cname = "gdata_youtube_video_get_description")]
		public unowned string get_description ();
		[CCode (cname = "gdata_youtube_video_get_duration")]
		public uint get_duration ();
		[CCode (cname = "gdata_youtube_video_get_favorite_count")]
		public uint get_favorite_count ();
		[CCode (cname = "gdata_youtube_video_get_keywords")]
		public unowned string get_keywords ();
		[CCode (cname = "gdata_youtube_video_get_location")]
		public unowned string get_location ();
		[CCode (cname = "gdata_youtube_video_get_no_embed")]
		public bool get_no_embed ();
		[CCode (cname = "gdata_youtube_video_get_player_uri")]
		public unowned string get_player_uri ();
		[CCode (cname = "gdata_youtube_video_get_rating")]
		public void get_rating (uint min, uint max, uint count, double average);
		[CCode (cname = "gdata_youtube_video_get_recorded")]
		public void get_recorded (GLib.TimeVal recorded);
		[CCode (cname = "gdata_youtube_video_get_state")]
		public unowned GData.YouTubeState get_state ();
		[CCode (cname = "gdata_youtube_video_get_thumbnails")]
		public unowned GLib.List get_thumbnails ();
		[CCode (cname = "gdata_youtube_video_get_uploaded")]
		public void get_uploaded (GLib.TimeVal uploaded);
		[CCode (cname = "gdata_youtube_video_get_video_id")]
		public unowned string get_video_id ();
		[CCode (cname = "gdata_youtube_video_get_video_id_from_uri")]
		public static unowned string get_video_id_from_uri (string video_uri);
		[CCode (cname = "gdata_youtube_video_get_view_count")]
		public uint get_view_count ();
		[CCode (cname = "gdata_youtube_video_is_restricted_in_country")]
		public bool is_restricted_in_country (string country);
		[CCode (cname = "gdata_youtube_video_look_up_content")]
		public unowned GData.YouTubeContent look_up_content (string type);
		[CCode (cname = "gdata_youtube_video_set_aspect_ratio")]
		public void set_aspect_ratio (GData.YouTubeAspectRatio aspect_ratio);
		[CCode (cname = "gdata_youtube_video_set_category")]
		public void set_category (GData.MediaCategory category);
		[CCode (cname = "gdata_youtube_video_set_description")]
		public void set_description (string description);
		[CCode (cname = "gdata_youtube_video_set_is_draft")]
		public void set_is_draft (bool is_draft);
		[CCode (cname = "gdata_youtube_video_set_is_private")]
		public void set_is_private (bool is_private);
		[CCode (cname = "gdata_youtube_video_set_keywords")]
		public void set_keywords (string keywords);
		[CCode (cname = "gdata_youtube_video_set_location")]
		public void set_location (string location);
		[CCode (cname = "gdata_youtube_video_set_no_embed")]
		public void set_no_embed (bool no_embed);
		[CCode (cname = "gdata_youtube_video_set_recorded")]
		public void set_recorded (GLib.TimeVal recorded);
		public GData.YouTubeAspectRatio aspect_ratio { get; set; }
		[NoAccessorMethod]
		public double average_rating { get; }
		public GData.MediaCategory category { get; set; }
		public GData.YouTubeCredit credit { get; }
		public string description { get; set; }
		public uint duration { get; }
		public uint favorite_count { get; }
		[NoAccessorMethod]
		public bool is_draft { get; set; }
		[NoAccessorMethod]
		public bool is_private { get; set; }
		public string keywords { get; set; }
		public string location { get; set; }
		[NoAccessorMethod]
		public uint max_rating { get; }
		[NoAccessorMethod]
		public uint min_rating { get; }
		public bool no_embed { get; set; }
		public string player_uri { get; }
		[NoAccessorMethod]
		public uint rating_count { get; }
		public GLib.TimeVal recorded { get; set; }
		public GData.YouTubeState state { get; }
		public GLib.TimeVal uploaded { get; }
		public string video_id { get; }
		public uint view_count { get; }
	}
	[CCode (cheader_filename = "gdata/gdata.h")]
	public interface AccessHandler : GData.Entry {
		public bool delete_rule (GData.Service service, GData.AccessRule rule, GLib.Cancellable cancellable) throws GLib.Error;
		public unowned GData.Feed get_rules (GData.Service service, GLib.Cancellable cancellable, GData.QueryProgressCallback progress_callback, void* progress_user_data) throws GLib.Error;
		public unowned GData.AccessRule insert_rule (GData.Service service, GData.AccessRule rule, GLib.Cancellable cancellable) throws GLib.Error;
		[NoWrapper]
		public abstract bool is_owner_rule (GData.AccessRule rule);
		public unowned GData.AccessRule update_rule (GData.Service service, GData.AccessRule rule, GLib.Cancellable cancellable) throws GLib.Error;
	}
	[CCode (cprefix = "GDATA_AUTHENTICATION_ERROR_", cheader_filename = "gdata/gdata.h")]
	public enum AuthenticationError {
		BAD_AUTHENTICATION,
		NOT_VERIFIED,
		TERMS_NOT_AGREED,
		CAPTCHA_REQUIRED,
		ACCOUNT_DELETED,
		ACCOUNT_DISABLED,
		SERVICE_DISABLED
	}
	[CCode (cprefix = "GDATA_DOCUMENTS_PRESENTATION_", cheader_filename = "gdata/gdata.h")]
	public enum DocumentsPresentationFormat {
		PDF,
		PNG,
		PPT,
		SWF,
		TXT
	}
	[CCode (cprefix = "GDATA_DOCUMENTS_SERVICE_ERROR_INVALID_CONTENT_", cheader_filename = "gdata/gdata.h")]
	public enum DocumentsServiceError {
		TYPE
	}
	[CCode (cprefix = "GDATA_DOCUMENTS_SPREADSHEET_", cheader_filename = "gdata/gdata.h")]
	public enum DocumentsSpreadsheetFormat {
		XLS,
		CSV,
		PDF,
		ODS,
		TSV,
		HTML
	}
	[CCode (cprefix = "GDATA_DOCUMENTS_TEXT_", cheader_filename = "gdata/gdata.h")]
	public enum DocumentsTextFormat {
		DOC,
		HTML,
		ODT,
		PDF,
		PNG,
		RTF,
		TXT,
		ZIP
	}
	[CCode (cprefix = "GDATA_MEDIA_EXPRESSION_", cheader_filename = "gdata/gdata.h")]
	public enum MediaExpression {
		SAMPLE,
		FULL,
		NONSTOP
	}
	[CCode (cprefix = "GDATA_MEDIA_", cheader_filename = "gdata/gdata.h")]
	public enum MediaMedium {
		UNKNOWN,
		IMAGE,
		AUDIO,
		VIDEO,
		DOCUMENT,
		EXECUTABLE
	}
	[CCode (cprefix = "GDATA_OPERATION_", cheader_filename = "gdata/gdata.h")]
	public enum OperationType {
		QUERY,
		INSERTION,
		UPDATE,
		DELETION,
		DOWNLOAD,
		UPLOAD
	}
	[CCode (cprefix = "GDATA_PARSER_ERROR_", cheader_filename = "gdata/gdata.h")]
	public enum ParserError {
		PARSING_STRING,
		EMPTY_DOCUMENT
	}
	[CCode (cprefix = "GDATA_PICASAWEB_", cheader_filename = "gdata/gdata.h")]
	public enum PicasaWebVisibility {
		PUBLIC,
		PRIVATE
	}
	[CCode (cprefix = "GDATA_SERVICE_ERROR_", cheader_filename = "gdata/gdata.h")]
	public enum ServiceError {
		UNAVAILABLE,
		PROTOCOL_ERROR,
		ENTRY_ALREADY_INSERTED,
		AUTHENTICATION_REQUIRED,
		NOT_FOUND,
		CONFLICT,
		FORBIDDEN,
		BAD_QUERY_PARAMETER
	}
	[CCode (cprefix = "GDATA_YOUTUBE_AGE_", cheader_filename = "gdata/gdata.h")]
	public enum YouTubeAge {
		ALL_TIME,
		TODAY,
		THIS_WEEK,
		THIS_MONTH
	}
	[CCode (cprefix = "GDATA_YOUTUBE_ASPECT_RATIO_", cheader_filename = "gdata/gdata.h")]
	public enum YouTubeAspectRatio {
		UNKNOWN,
		WIDESCREEN
	}
	[CCode (cprefix = "GDATA_YOUTUBE_FORMAT_", cheader_filename = "gdata/gdata.h")]
	public enum YouTubeFormat {
		UNKNOWN,
		RTSP_H263_AMR,
		HTTP_SWF,
		RTSP_MPEG4_AAC
	}
	[CCode (cprefix = "GDATA_YOUTUBE_SAFE_SEARCH_", cheader_filename = "gdata/gdata.h")]
	public enum YouTubeSafeSearch {
		NONE,
		MODERATE,
		STRICT
	}
	[CCode (cprefix = "GDATA_YOUTUBE_SERVICE_ERROR_", cheader_filename = "gdata/gdata.h")]
	public enum YouTubeServiceError {
		API_QUOTA_EXCEEDED,
		ENTRY_QUOTA_EXCEEDED
	}
	[CCode (cprefix = "GDATA_YOUTUBE_SORT_", cheader_filename = "gdata/gdata.h")]
	public enum YouTubeSortOrder {
		NONE,
		ASCENDING,
		DESCENDING
	}
	[CCode (cprefix = "GDATA_YOUTUBE_", cheader_filename = "gdata/gdata.h")]
	public enum YouTubeStandardFeedType {
		TOP_RATED_FEED,
		TOP_FAVORITES_FEED,
		MOST_VIEWED_FEED,
		MOST_POPULAR_FEED,
		MOST_RECENT_FEED,
		MOST_DISCUSSED_FEED,
		MOST_LINKED_FEED,
		MOST_RESPONDED_FEED,
		RECENTLY_FEATURED_FEED,
		WATCH_ON_MOBILE_FEED
	}
	[CCode (cprefix = "GDATA_YOUTUBE_UPLOADER_", cheader_filename = "gdata/gdata.h")]
	public enum YouTubeUploader {
		ALL,
		PARTNER
	}
	[CCode (cheader_filename = "gdata/gdata.h")]
	public delegate void QueryProgressCallback (GData.Entry entry, uint entry_key, uint entry_count);
	[CCode (cheader_filename = "gdata/gdata.h")]
	public const string GD_ADDRESS_USAGE_GENERAL;
	[CCode (cheader_filename = "gdata/gdata.h")]
	public const string GD_ADDRESS_USAGE_LOCAL;
	[CCode (cheader_filename = "gdata/gdata.h")]
	public const string GD_MAIL_CLASS_BOTH;
	[CCode (cheader_filename = "gdata/gdata.h")]
	public const string GD_MAIL_CLASS_LETTERS;
	[CCode (cheader_filename = "gdata/gdata.h")]
	public const string GD_MAIL_CLASS_NEITHER;
	[CCode (cheader_filename = "gdata/gdata.h")]
	public const string GD_MAIL_CLASS_PARCELS;
	[CCode (cheader_filename = "gdata/gdata.h")]
	public const string LINK_ALTERNATE;
	[CCode (cheader_filename = "gdata/gdata.h")]
	public const string LINK_EDIT;
	[CCode (cheader_filename = "gdata/gdata.h")]
	public const string LINK_EDIT_MEDIA;
	[CCode (cheader_filename = "gdata/gdata.h")]
	public const string LINK_ENCLOSURE;
	[CCode (cheader_filename = "gdata/gdata.h")]
	public const string LINK_RELATED;
	[CCode (cheader_filename = "gdata/gdata.h")]
	public const string LINK_SELF;
	[CCode (cheader_filename = "gdata/gdata.h")]
	public const string LINK_VIA;
	[CCode (cheader_filename = "gdata/gdata.h")]
	public static GLib.Quark authentication_error_quark ();
	[CCode (cheader_filename = "gdata/gdata.h")]
	public static GLib.Quark parser_error_quark ();
}
