/* user-list.c generated by valac 0.14.0, the Vala compiler
 * generated from user-list.vala, do not modify */

/*
 * Copyright (C) 2011 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Robert Ancell <robert.ancell@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <cairo.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include <gtk/gtk.h>
#include <libindicator/indicator.h>
#include <libindicator/indicator-desktop-shortcuts.h>
#include <libindicator/indicator-image-helper.h>
#include <libindicator/indicator-object.h>
#include <libindicator/indicator-service.h>
#include <libindicator/indicator-service-manager.h>
#include <atk/atk.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <sys/utsname.h>
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>
#include <gio/gio.h>
#include <stdio.h>
#include <gtk/gtkx.h>
#include <pango/pangocairo.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <gobject/gvaluecollector.h>


#define TYPE_ANIMATE_TIMER (animate_timer_get_type ())
#define ANIMATE_TIMER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ANIMATE_TIMER, AnimateTimer))
#define ANIMATE_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ANIMATE_TIMER, AnimateTimerClass))
#define IS_ANIMATE_TIMER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ANIMATE_TIMER))
#define IS_ANIMATE_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ANIMATE_TIMER))
#define ANIMATE_TIMER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ANIMATE_TIMER, AnimateTimerClass))

typedef struct _AnimateTimer AnimateTimer;
typedef struct _AnimateTimerClass AnimateTimerClass;
typedef struct _AnimateTimerPrivate AnimateTimerPrivate;
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
typedef struct _ParamSpecAnimateTimer ParamSpecAnimateTimer;

#define TYPE_USER_ENTRY (user_entry_get_type ())
#define USER_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_ENTRY, UserEntry))
#define USER_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_ENTRY, UserEntryClass))
#define IS_USER_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_ENTRY))
#define IS_USER_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_ENTRY))
#define USER_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_ENTRY, UserEntryClass))

typedef struct _UserEntry UserEntry;
typedef struct _UserEntryClass UserEntryClass;
typedef struct _UserEntryPrivate UserEntryPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ParamSpecUserEntry ParamSpecUserEntry;

#define TYPE_INDICATOR_MENU_ITEM (indicator_menu_item_get_type ())
#define INDICATOR_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INDICATOR_MENU_ITEM, IndicatorMenuItem))
#define INDICATOR_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_INDICATOR_MENU_ITEM, IndicatorMenuItemClass))
#define IS_INDICATOR_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INDICATOR_MENU_ITEM))
#define IS_INDICATOR_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_INDICATOR_MENU_ITEM))
#define INDICATOR_MENU_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_INDICATOR_MENU_ITEM, IndicatorMenuItemClass))

typedef struct _IndicatorMenuItem IndicatorMenuItem;
typedef struct _IndicatorMenuItemClass IndicatorMenuItemClass;
typedef struct _IndicatorMenuItemPrivate IndicatorMenuItemPrivate;

#define TYPE_SESSION_MENU_ITEM (session_menu_item_get_type ())
#define SESSION_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SESSION_MENU_ITEM, SessionMenuItem))
#define SESSION_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SESSION_MENU_ITEM, SessionMenuItemClass))
#define IS_SESSION_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SESSION_MENU_ITEM))
#define IS_SESSION_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SESSION_MENU_ITEM))
#define SESSION_MENU_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SESSION_MENU_ITEM, SessionMenuItemClass))

typedef struct _SessionMenuItem SessionMenuItem;
typedef struct _SessionMenuItemClass SessionMenuItemClass;
typedef struct _SessionMenuItemPrivate SessionMenuItemPrivate;

#define TYPE_BACKGROUND (background_get_type ())
#define BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKGROUND, Background))
#define BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKGROUND, BackgroundClass))
#define IS_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKGROUND))
#define IS_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKGROUND))
#define BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKGROUND, BackgroundClass))

typedef struct _Background Background;
typedef struct _BackgroundClass BackgroundClass;
typedef struct _BackgroundPrivate BackgroundPrivate;
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
typedef struct _ParamSpecBackground ParamSpecBackground;

#define TYPE_USER_LIST (user_list_get_type ())
#define USER_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_LIST, UserList))
#define USER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_LIST, UserListClass))
#define IS_USER_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_LIST))
#define IS_USER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_LIST))
#define USER_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_LIST, UserListClass))

typedef struct _UserList UserList;
typedef struct _UserListClass UserListClass;
typedef struct _UserListPrivate UserListPrivate;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _background_unref0(var) ((var == NULL) ? NULL : (var = (background_unref (var), NULL)))
#define __g_list_free__user_entry_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__user_entry_unref0_ (var), NULL)))
#define _user_entry_unref0(var) ((var == NULL) ? NULL : (var = (user_entry_unref (var), NULL)))
#define _animate_timer_unref0(var) ((var == NULL) ? NULL : (var = (animate_timer_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _pango_font_description_free0(var) ((var == NULL) ? NULL : (var = (pango_font_description_free (var), NULL)))

struct _AnimateTimer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AnimateTimerPrivate * priv;
};

struct _AnimateTimerClass {
	GTypeClass parent_class;
	void (*finalize) (AnimateTimer *self);
};

struct _AnimateTimerPrivate {
	GTimer* timer;
	guint timeout;
	gdouble last_timestep;
};

struct _ParamSpecAnimateTimer {
	GParamSpec parent_instance;
};

struct _UserEntry {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UserEntryPrivate * priv;
	gchar* name;
	PangoLayout* layout;
	gchar* background;
	gboolean is_active;
};

struct _UserEntryClass {
	GTypeClass parent_class;
	void (*finalize) (UserEntry *self);
};

struct _ParamSpecUserEntry {
	GParamSpec parent_instance;
};

struct _IndicatorMenuItem {
	GtkMenuItem parent_instance;
	IndicatorMenuItemPrivate * priv;
	IndicatorObjectEntry* entry;
};

struct _IndicatorMenuItemClass {
	GtkMenuItemClass parent_class;
};

struct _IndicatorMenuItemPrivate {
	GtkHBox* hbox;
};

struct _SessionMenuItem {
	GtkRadioMenuItem parent_instance;
	SessionMenuItemPrivate * priv;
	gchar* session_name;
};

struct _SessionMenuItemClass {
	GtkRadioMenuItemClass parent_class;
};

struct _Background {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BackgroundPrivate * priv;
	cairo_pattern_t* pattern;
};

struct _BackgroundClass {
	GTypeClass parent_class;
	void (*finalize) (Background *self);
};

struct _BackgroundPrivate {
	gchar* filename;
	gint width;
	gint height;
	GThread* thread;
};

struct _ParamSpecBackground {
	GParamSpec parent_instance;
};

struct _UserList {
	GtkContainer parent_instance;
	UserListPrivate * priv;
	GList* indicator_objects;
};

struct _UserListClass {
	GtkContainerClass parent_class;
};

struct _UserListPrivate {
	gchar* default_theme_name;
	gint frame_count;
	GTimer* draw_timer;
	guint draw_timeout;
	gint draw_count;
	gint box_width;
	GHashTable* backgrounds;
	Background* background;
	Background* old_background;
	guint change_background_timeout;
	GList* entries;
	UserEntry* selected_entry;
	gdouble scroll_target_location;
	gdouble scroll_location;
	gdouble scroll_direction;
	AnimateTimer* scroll_timer;
	AnimateTimer* background_timer;
	gdouble background_alpha;
	GList* children;
	GtkMenuBar* menubar;
	cairo_t* menubar_cairo_context;
	GtkCheckMenuItem* high_contrast_item;
	GPid keyboard_pid;
	GtkWindow* keyboard_window;
	gchar* error;
	gchar* message;
	cairo_surface_t* box_surface;
	cairo_pattern_t* box_pattern;
	GtkEntry* prompt_entry;
	GtkButton* login_button;
	GtkButton* options_button;
	GtkMenu* options_menu;
	GSList* session_group;
	gboolean complete;
	gint box_height;
};


extern gint grid_size;
gint grid_size = 42;
extern cairo_surface_t* logo_surface;
cairo_surface_t* logo_surface = NULL;
static gpointer animate_timer_parent_class = NULL;
static gpointer user_entry_parent_class = NULL;
static gpointer indicator_menu_item_parent_class = NULL;
static gpointer session_menu_item_parent_class = NULL;
static gpointer background_parent_class = NULL;
static gpointer user_list_parent_class = NULL;

#define default_background "#2C001E"
gint get_grid_offset (gint size);
gpointer animate_timer_ref (gpointer instance);
void animate_timer_unref (gpointer instance);
GParamSpec* param_spec_animate_timer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_animate_timer (GValue* value, gpointer v_object);
void value_take_animate_timer (GValue* value, gpointer v_object);
gpointer value_get_animate_timer (const GValue* value);
GType animate_timer_get_type (void) G_GNUC_CONST;
#define ANIMATE_TIMER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ANIMATE_TIMER, AnimateTimerPrivate))
enum  {
	ANIMATE_TIMER_DUMMY_PROPERTY
};
static gboolean animate_timer_animate_cb (AnimateTimer* self);
void animate_timer_reset (AnimateTimer* self);
void animate_timer_stop (AnimateTimer* self);
static gboolean _animate_timer_animate_cb_gsource_func (gpointer self);
AnimateTimer* animate_timer_new (void);
AnimateTimer* animate_timer_construct (GType object_type);
gboolean animate_timer_get_is_running (AnimateTimer* self);
static void animate_timer_finalize (AnimateTimer* obj);
gpointer user_entry_ref (gpointer instance);
void user_entry_unref (gpointer instance);
GParamSpec* param_spec_user_entry (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_user_entry (GValue* value, gpointer v_object);
void value_take_user_entry (GValue* value, gpointer v_object);
gpointer value_get_user_entry (const GValue* value);
GType user_entry_get_type (void) G_GNUC_CONST;
enum  {
	USER_ENTRY_DUMMY_PROPERTY
};
UserEntry* user_entry_new (void);
UserEntry* user_entry_construct (GType object_type);
static void user_entry_finalize (UserEntry* obj);
GType indicator_menu_item_get_type (void) G_GNUC_CONST;
#define INDICATOR_MENU_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_INDICATOR_MENU_ITEM, IndicatorMenuItemPrivate))
enum  {
	INDICATOR_MENU_ITEM_DUMMY_PROPERTY
};
IndicatorMenuItem* indicator_menu_item_new (IndicatorObjectEntry* entry);
IndicatorMenuItem* indicator_menu_item_construct (GType object_type, IndicatorObjectEntry* entry);
void indicator_menu_item_visibility_changed_cb (IndicatorMenuItem* self, GtkWidget* widget);
static void _indicator_menu_item_visibility_changed_cb_gtk_widget_show (GtkWidget* _sender, gpointer self);
static void _indicator_menu_item_visibility_changed_cb_gtk_widget_hide (GtkWidget* _sender, gpointer self);
gboolean indicator_menu_item_has_visible_child (IndicatorMenuItem* self);
static void indicator_menu_item_finalize (GObject* obj);
GType session_menu_item_get_type (void) G_GNUC_CONST;
enum  {
	SESSION_MENU_ITEM_DUMMY_PROPERTY
};
SessionMenuItem* session_menu_item_new (void);
SessionMenuItem* session_menu_item_construct (GType object_type);
static void session_menu_item_finalize (GObject* obj);
gpointer background_ref (gpointer instance);
void background_unref (gpointer instance);
GParamSpec* param_spec_background (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_background (GValue* value, gpointer v_object);
void value_take_background (GValue* value, gpointer v_object);
gpointer value_get_background (const GValue* value);
GType background_get_type (void) G_GNUC_CONST;
#define BACKGROUND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BACKGROUND, BackgroundPrivate))
enum  {
	BACKGROUND_DUMMY_PROPERTY
};
Background* background_new (const gchar* filename, gint width, gint height);
Background* background_construct (GType object_type, const gchar* filename, gint width, gint height);
gboolean background_load (Background* self);
static cairo_pattern_t* background_render (Background* self);
static gpointer _background_render_gthread_func (gpointer self);
static gboolean background_ready_cb (Background* self);
static gboolean _background_ready_cb_gsource_func (gpointer self);
static void background_finalize (Background* obj);
GType user_list_get_type (void) G_GNUC_CONST;
#define USER_LIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_USER_LIST, UserListPrivate))
enum  {
	USER_LIST_DUMMY_PROPERTY,
	USER_LIST_SELECTED,
	USER_LIST_SESSION
};
static void _user_entry_unref0_ (gpointer var);
static void _g_list_free__user_entry_unref0_ (GList* self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
UserList* user_list_new (void);
UserList* user_list_construct (GType object_type);
static gboolean user_list_menubar_draw_cb (UserList* self, cairo_t* c);
static gboolean _user_list_menubar_draw_cb_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self);
static void user_list_prompt_entry_activate_cb (UserList* self);
static void _user_list_prompt_entry_activate_cb_gtk_entry_activate (GtkEntry* _sender, gpointer self);
static void user_list_login_button_clicked_cb (UserList* self);
static void _user_list_login_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void user_list_options_button_clicked_cb (UserList* self);
static void _user_list_options_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _g_free0_ (gpointer var);
static void _background_unref0_ (gpointer var);
static void user_list_scroll_animate_cb (UserList* self, gdouble timestep);
static void _user_list_scroll_animate_cb_animate_timer_animate (AnimateTimer* _sender, gdouble timestep, gpointer self);
static void user_list_background_animate_cb (UserList* self, gdouble timestep);
static void _user_list_background_animate_cb_animate_timer_animate (AnimateTimer* _sender, gdouble timestep, gpointer self);
static void user_list_setup_indicators (UserList* self);
void user_list_set_logo (UserList* self, const gchar* logo_path);
static void user_list_draw_child_cb (UserList* self, GtkWidget* child);
static void user_list_draw_background (UserList* self, cairo_t* c);
static void _user_list_draw_child_cb_gtk_callback (GtkWidget* widget, gpointer self);
static void user_list_greeter_set_env (UserList* self, const gchar* key, const gchar* val);
static void user_list_keyboard_toggled_cb (UserList* self, GtkCheckMenuItem* item);
static void _user_list_keyboard_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self);
static void user_list_high_contrast_toggled_cb (UserList* self, GtkCheckMenuItem* item);
static void _user_list_high_contrast_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self);
static void user_list_screen_reader_toggled_cb (UserList* self, GtkCheckMenuItem* item);
static void _user_list_screen_reader_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self);
static void user_list_indicator_added_cb (UserList* self, IndicatorObject* object, IndicatorObjectEntry* entry);
static void _user_list_indicator_added_cb_indicator_object_entry_added (IndicatorObject* _sender, IndicatorObjectEntry* entry, gpointer self);
static void user_list_indicator_removed_cb (UserList* self, IndicatorObject* object, IndicatorObjectEntry* entry);
static void _user_list_indicator_removed_cb_indicator_object_entry_removed (IndicatorObject* _sender, IndicatorObjectEntry* entry, gpointer self);
static void user_list_change_background (UserList* self);
void user_list_show_message (UserList* self, const gchar* text, gboolean _error_);
void user_list_show_prompt (UserList* self, const gchar* text, gboolean secret);
void user_list_show_authenticated (UserList* self);
void user_list_login_complete (UserList* self);
void user_list_set_error (UserList* self, const gchar* text);
static guint user_list_get_indicator_index (UserList* self, IndicatorObject* object);
static IndicatorObject* user_list_get_indicator_object_from_entry (UserList* self, IndicatorObjectEntry* entry);
void user_list_add_session (UserList* self, const gchar* name, const gchar* label);
static UserEntry* user_list_find_entry (UserList* self, const gchar* name);
void user_list_add_entry (UserList* self, const gchar* name, const gchar* label, const gchar* background, gboolean is_active);
static void user_list_select_entry (UserList* self, UserEntry* entry, gdouble direction);
void user_list_set_active_entry (UserList* self, const gchar* name);
void user_list_remove_entry (UserList* self, const gchar* name);
static void user_list_options_menu_position_cb (UserList* self, GtkMenu* menu, gint* x, gint* y, gboolean* push_in);
static void _user_list_options_menu_position_cb_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self);
static gboolean user_list_change_background_timeout_cb (UserList* self);
static Background* user_list_make_background (UserList* self, const gchar* filename);
static gboolean _user_list_change_background_timeout_cb_gsource_func (gpointer self);
static void user_list_select_prev_entry (UserList* self);
static void user_list_select_next_entry (UserList* self);
static void user_list_get_selected_location (UserList* self, gint* x, gint* y);
static void user_list_real_add (GtkContainer* base, GtkWidget* widget);
static void user_list_real_remove (GtkContainer* base, GtkWidget* widget);
static void user_list_real_forall_internal (GtkContainer* base, gboolean include_internal, GtkCallback callback, void* callback_target);
static void user_list_real_realize (GtkWidget* base);
static void user_list_real_map (GtkWidget* base);
static void user_list_real_size_allocate (GtkWidget* base, GtkAllocation* allocation);
static void user_list_draw_entry (UserList* self, cairo_t* c, UserEntry* entry, gdouble alpha);
static void user_list_background_loaded_cb (UserList* self, Background* b);
static void _user_list_background_loaded_cb_background_loaded (Background* _sender, gpointer self);
Background* user_list_get_background (UserList* self);
static gboolean user_list_draw_expire_cb (UserList* self);
static gboolean user_list_real_draw (GtkWidget* base, cairo_t* c);
static gboolean _user_list_draw_expire_cb_gsource_func (gpointer self);
static guint user_list_get_n_above (UserList* self);
static guint user_list_get_n_below (UserList* self);
static gboolean user_list_real_key_press_event (GtkWidget* base, GdkEventKey* event);
static gboolean user_list_inside_entry (UserList* self, gdouble x, gdouble y, gdouble entry_y, UserEntry* entry);
static gboolean user_list_real_button_release_event (GtkWidget* base, GdkEventButton* event);
static void user_list_real_unrealize (GtkWidget* base);
const gchar* user_list_get_selected (UserList* self);
const gchar* user_list_get_session (UserList* self);
void user_list_set_session (UserList* self, const gchar* value);
static void user_list_finalize (GObject* obj);
static void _vala_user_list_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_user_list_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


gint get_grid_offset (gint size) {
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
	_tmp0_ = size;
	_tmp1_ = grid_size;
	result = ((gint) (_tmp0_ % _tmp1_)) / 2;
	return result;
}


static gboolean animate_timer_animate_cb (AnimateTimer* self) {
	gboolean result = FALSE;
	GTimer* _tmp0_;
	gdouble _tmp1_ = 0.0;
	gdouble t;
	gdouble _tmp2_;
	gdouble timestep;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->timer;
	_tmp1_ = g_timer_elapsed (_tmp0_, NULL);
	t = _tmp1_;
	_tmp2_ = self->priv->last_timestep;
	timestep = t - _tmp2_;
	self->priv->last_timestep = t;
	g_signal_emit_by_name (self, "animate", timestep);
	result = TRUE;
	return result;
}


static gboolean _animate_timer_animate_cb_gsource_func (gpointer self) {
	gboolean result;
	result = animate_timer_animate_cb (self);
	return result;
}


void animate_timer_reset (AnimateTimer* self) {
	GTimer* _tmp0_;
	guint _tmp1_ = 0U;
	g_return_if_fail (self != NULL);
	animate_timer_stop (self);
	self->priv->last_timestep = 0.0;
	_tmp0_ = g_timer_new ();
	_g_timer_destroy0 (self->priv->timer);
	self->priv->timer = _tmp0_;
	_tmp1_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 10, _animate_timer_animate_cb_gsource_func, animate_timer_ref (self), animate_timer_unref);
	self->priv->timeout = _tmp1_;
}


void animate_timer_stop (AnimateTimer* self) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->timeout;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->timeout;
		g_source_remove (_tmp1_);
	}
	self->priv->timeout = (guint) 0;
}


AnimateTimer* animate_timer_construct (GType object_type) {
	AnimateTimer* self = NULL;
	self = (AnimateTimer*) g_type_create_instance (object_type);
	return self;
}


AnimateTimer* animate_timer_new (void) {
	return animate_timer_construct (TYPE_ANIMATE_TIMER);
}


gboolean animate_timer_get_is_running (AnimateTimer* self) {
	gboolean result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->timeout;
	result = _tmp0_ != ((guint) 0);
	return result;
}


static void value_animate_timer_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_animate_timer_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		animate_timer_unref (value->data[0].v_pointer);
	}
}


static void value_animate_timer_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = animate_timer_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_animate_timer_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_animate_timer_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		AnimateTimer* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = animate_timer_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_animate_timer_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	AnimateTimer** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = animate_timer_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_animate_timer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecAnimateTimer* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_ANIMATE_TIMER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_animate_timer (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ANIMATE_TIMER), NULL);
	return value->data[0].v_pointer;
}


void value_set_animate_timer (GValue* value, gpointer v_object) {
	AnimateTimer* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ANIMATE_TIMER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ANIMATE_TIMER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		animate_timer_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		animate_timer_unref (old);
	}
}


void value_take_animate_timer (GValue* value, gpointer v_object) {
	AnimateTimer* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ANIMATE_TIMER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ANIMATE_TIMER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		animate_timer_unref (old);
	}
}


static void animate_timer_class_init (AnimateTimerClass * klass) {
	animate_timer_parent_class = g_type_class_peek_parent (klass);
	ANIMATE_TIMER_CLASS (klass)->finalize = animate_timer_finalize;
	g_type_class_add_private (klass, sizeof (AnimateTimerPrivate));
	g_signal_new ("animate", TYPE_ANIMATE_TIMER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__DOUBLE, G_TYPE_NONE, 1, G_TYPE_DOUBLE);
}


static void animate_timer_instance_init (AnimateTimer * self) {
	self->priv = ANIMATE_TIMER_GET_PRIVATE (self);
	self->priv->timeout = (guint) 0;
	self->ref_count = 1;
}


static void animate_timer_finalize (AnimateTimer* obj) {
	AnimateTimer * self;
	self = ANIMATE_TIMER (obj);
	_g_timer_destroy0 (self->priv->timer);
}


GType animate_timer_get_type (void) {
	static volatile gsize animate_timer_type_id__volatile = 0;
	if (g_once_init_enter (&animate_timer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_animate_timer_init, value_animate_timer_free_value, value_animate_timer_copy_value, value_animate_timer_peek_pointer, "p", value_animate_timer_collect_value, "p", value_animate_timer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (AnimateTimerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) animate_timer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AnimateTimer), 0, (GInstanceInitFunc) animate_timer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType animate_timer_type_id;
		animate_timer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AnimateTimer", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&animate_timer_type_id__volatile, animate_timer_type_id);
	}
	return animate_timer_type_id__volatile;
}


gpointer animate_timer_ref (gpointer instance) {
	AnimateTimer* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void animate_timer_unref (gpointer instance) {
	AnimateTimer* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		ANIMATE_TIMER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


UserEntry* user_entry_construct (GType object_type) {
	UserEntry* self = NULL;
	self = (UserEntry*) g_type_create_instance (object_type);
	return self;
}


UserEntry* user_entry_new (void) {
	return user_entry_construct (TYPE_USER_ENTRY);
}


static void value_user_entry_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_user_entry_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		user_entry_unref (value->data[0].v_pointer);
	}
}


static void value_user_entry_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = user_entry_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_user_entry_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_user_entry_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		UserEntry* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = user_entry_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_user_entry_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	UserEntry** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = user_entry_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_user_entry (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecUserEntry* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_USER_ENTRY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_user_entry (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_USER_ENTRY), NULL);
	return value->data[0].v_pointer;
}


void value_set_user_entry (GValue* value, gpointer v_object) {
	UserEntry* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_USER_ENTRY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_USER_ENTRY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		user_entry_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		user_entry_unref (old);
	}
}


void value_take_user_entry (GValue* value, gpointer v_object) {
	UserEntry* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_USER_ENTRY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_USER_ENTRY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		user_entry_unref (old);
	}
}


static void user_entry_class_init (UserEntryClass * klass) {
	user_entry_parent_class = g_type_class_peek_parent (klass);
	USER_ENTRY_CLASS (klass)->finalize = user_entry_finalize;
}


static void user_entry_instance_init (UserEntry * self) {
	self->ref_count = 1;
}


static void user_entry_finalize (UserEntry* obj) {
	UserEntry * self;
	self = USER_ENTRY (obj);
	_g_free0 (self->name);
	_g_object_unref0 (self->layout);
	_g_free0 (self->background);
}


GType user_entry_get_type (void) {
	static volatile gsize user_entry_type_id__volatile = 0;
	if (g_once_init_enter (&user_entry_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_user_entry_init, value_user_entry_free_value, value_user_entry_copy_value, value_user_entry_peek_pointer, "p", value_user_entry_collect_value, "p", value_user_entry_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (UserEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) user_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UserEntry), 0, (GInstanceInitFunc) user_entry_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType user_entry_type_id;
		user_entry_type_id = g_type_register_fundamental (g_type_fundamental_next (), "UserEntry", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&user_entry_type_id__volatile, user_entry_type_id);
	}
	return user_entry_type_id__volatile;
}


gpointer user_entry_ref (gpointer instance) {
	UserEntry* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void user_entry_unref (gpointer instance) {
	UserEntry* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		USER_ENTRY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _indicator_menu_item_visibility_changed_cb_gtk_widget_show (GtkWidget* _sender, gpointer self) {
	indicator_menu_item_visibility_changed_cb (self, _sender);
}


static void _indicator_menu_item_visibility_changed_cb_gtk_widget_hide (GtkWidget* _sender, gpointer self) {
	indicator_menu_item_visibility_changed_cb (self, _sender);
}


IndicatorMenuItem* indicator_menu_item_construct (GType object_type, IndicatorObjectEntry* entry) {
	IndicatorMenuItem * self = NULL;
	IndicatorObjectEntry* _tmp0_;
	GtkHBox* _tmp1_;
	GtkHBox* _tmp2_;
	GtkHBox* _tmp3_;
	GtkHBox* _tmp4_;
	IndicatorObjectEntry* _tmp5_;
	GtkLabel* _tmp6_;
	IndicatorObjectEntry* _tmp14_;
	GtkImage* _tmp15_;
	IndicatorObjectEntry* _tmp23_;
	const gchar* _tmp24_;
	IndicatorObjectEntry* _tmp28_;
	GtkMenu* _tmp29_;
	gboolean _tmp32_ = FALSE;
	g_return_val_if_fail (entry != NULL, NULL);
	self = (IndicatorMenuItem*) g_object_new (object_type, NULL);
	_tmp0_ = entry;
	self->entry = _tmp0_;
	_tmp1_ = (GtkHBox*) gtk_hbox_new (FALSE, 3);
	_tmp2_ = g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->hbox);
	self->priv->hbox = _tmp2_;
	_tmp3_ = self->priv->hbox;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp3_);
	_tmp4_ = self->priv->hbox;
	gtk_widget_show ((GtkWidget*) _tmp4_);
	_tmp5_ = entry;
	_tmp6_ = _tmp5_->label;
	if (_tmp6_ != NULL) {
		IndicatorObjectEntry* _tmp7_;
		GtkLabel* _tmp8_;
		IndicatorObjectEntry* _tmp9_;
		GtkLabel* _tmp10_;
		GtkHBox* _tmp11_;
		IndicatorObjectEntry* _tmp12_;
		GtkLabel* _tmp13_;
		_tmp7_ = entry;
		_tmp8_ = _tmp7_->label;
		g_signal_connect_object ((GtkWidget*) _tmp8_, "show", (GCallback) _indicator_menu_item_visibility_changed_cb_gtk_widget_show, self, 0);
		_tmp9_ = entry;
		_tmp10_ = _tmp9_->label;
		g_signal_connect_object ((GtkWidget*) _tmp10_, "hide", (GCallback) _indicator_menu_item_visibility_changed_cb_gtk_widget_hide, self, 0);
		_tmp11_ = self->priv->hbox;
		_tmp12_ = entry;
		_tmp13_ = _tmp12_->label;
		gtk_box_pack_start ((GtkBox*) _tmp11_, (GtkWidget*) _tmp13_, FALSE, FALSE, (guint) 0);
	}
	_tmp14_ = entry;
	_tmp15_ = _tmp14_->image;
	if (_tmp15_ != NULL) {
		IndicatorObjectEntry* _tmp16_;
		GtkImage* _tmp17_;
		IndicatorObjectEntry* _tmp18_;
		GtkImage* _tmp19_;
		GtkHBox* _tmp20_;
		IndicatorObjectEntry* _tmp21_;
		GtkImage* _tmp22_;
		_tmp16_ = entry;
		_tmp17_ = _tmp16_->image;
		g_signal_connect_object ((GtkWidget*) _tmp17_, "show", (GCallback) _indicator_menu_item_visibility_changed_cb_gtk_widget_show, self, 0);
		_tmp18_ = entry;
		_tmp19_ = _tmp18_->image;
		g_signal_connect_object ((GtkWidget*) _tmp19_, "hide", (GCallback) _indicator_menu_item_visibility_changed_cb_gtk_widget_hide, self, 0);
		_tmp20_ = self->priv->hbox;
		_tmp21_ = entry;
		_tmp22_ = _tmp21_->image;
		gtk_box_pack_start ((GtkBox*) _tmp20_, (GtkWidget*) _tmp22_, FALSE, FALSE, (guint) 0);
	}
	_tmp23_ = entry;
	_tmp24_ = _tmp23_->accessible_desc;
	if (_tmp24_ != NULL) {
		AtkObject* _tmp25_ = NULL;
		IndicatorObjectEntry* _tmp26_;
		const gchar* _tmp27_;
		_tmp25_ = gtk_widget_get_accessible ((GtkWidget*) self);
		_tmp26_ = entry;
		_tmp27_ = _tmp26_->accessible_desc;
		atk_object_set_name (_tmp25_, _tmp27_);
	}
	_tmp28_ = entry;
	_tmp29_ = _tmp28_->menu;
	if (_tmp29_ != NULL) {
		IndicatorObjectEntry* _tmp30_;
		GtkMenu* _tmp31_;
		_tmp30_ = entry;
		_tmp31_ = _tmp30_->menu;
		gtk_menu_item_set_submenu ((GtkMenuItem*) self, _tmp31_);
	}
	_tmp32_ = indicator_menu_item_has_visible_child (self);
	if (_tmp32_) {
		gtk_widget_show ((GtkWidget*) self);
	}
	return self;
}


IndicatorMenuItem* indicator_menu_item_new (IndicatorObjectEntry* entry) {
	return indicator_menu_item_construct (TYPE_INDICATOR_MENU_ITEM, entry);
}


gboolean indicator_menu_item_has_visible_child (IndicatorMenuItem* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	IndicatorObjectEntry* _tmp2_;
	GtkImage* _tmp3_;
	gboolean _tmp7_;
	gboolean _tmp15_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp2_ = self->entry;
	_tmp3_ = _tmp2_->image;
	if (_tmp3_ != NULL) {
		IndicatorObjectEntry* _tmp4_;
		GtkImage* _tmp5_;
		gboolean _tmp6_ = FALSE;
		_tmp4_ = self->entry;
		_tmp5_ = _tmp4_->image;
		_tmp6_ = gtk_widget_get_visible ((GtkWidget*) _tmp5_);
		_tmp1_ = _tmp6_;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp7_ = _tmp1_;
	if (_tmp7_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp8_ = FALSE;
		IndicatorObjectEntry* _tmp9_;
		GtkLabel* _tmp10_;
		gboolean _tmp14_;
		_tmp9_ = self->entry;
		_tmp10_ = _tmp9_->label;
		if (_tmp10_ != NULL) {
			IndicatorObjectEntry* _tmp11_;
			GtkLabel* _tmp12_;
			gboolean _tmp13_ = FALSE;
			_tmp11_ = self->entry;
			_tmp12_ = _tmp11_->label;
			_tmp13_ = gtk_widget_get_visible ((GtkWidget*) _tmp12_);
			_tmp8_ = _tmp13_;
		} else {
			_tmp8_ = FALSE;
		}
		_tmp14_ = _tmp8_;
		_tmp0_ = _tmp14_;
	}
	_tmp15_ = _tmp0_;
	result = _tmp15_;
	return result;
}


void indicator_menu_item_visibility_changed_cb (IndicatorMenuItem* self, GtkWidget* widget) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = indicator_menu_item_has_visible_child (self);
	gtk_widget_set_visible ((GtkWidget*) self, _tmp0_);
}


static void indicator_menu_item_class_init (IndicatorMenuItemClass * klass) {
	indicator_menu_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (IndicatorMenuItemPrivate));
	G_OBJECT_CLASS (klass)->finalize = indicator_menu_item_finalize;
}


static void indicator_menu_item_instance_init (IndicatorMenuItem * self) {
	self->priv = INDICATOR_MENU_ITEM_GET_PRIVATE (self);
}


static void indicator_menu_item_finalize (GObject* obj) {
	IndicatorMenuItem * self;
	self = INDICATOR_MENU_ITEM (obj);
	_g_object_unref0 (self->priv->hbox);
	G_OBJECT_CLASS (indicator_menu_item_parent_class)->finalize (obj);
}


GType indicator_menu_item_get_type (void) {
	static volatile gsize indicator_menu_item_type_id__volatile = 0;
	if (g_once_init_enter (&indicator_menu_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IndicatorMenuItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) indicator_menu_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IndicatorMenuItem), 0, (GInstanceInitFunc) indicator_menu_item_instance_init, NULL };
		GType indicator_menu_item_type_id;
		indicator_menu_item_type_id = g_type_register_static (GTK_TYPE_MENU_ITEM, "IndicatorMenuItem", &g_define_type_info, 0);
		g_once_init_leave (&indicator_menu_item_type_id__volatile, indicator_menu_item_type_id);
	}
	return indicator_menu_item_type_id__volatile;
}


SessionMenuItem* session_menu_item_construct (GType object_type) {
	SessionMenuItem * self = NULL;
	self = (SessionMenuItem*) g_object_new (object_type, NULL);
	return self;
}


SessionMenuItem* session_menu_item_new (void) {
	return session_menu_item_construct (TYPE_SESSION_MENU_ITEM);
}


static void session_menu_item_class_init (SessionMenuItemClass * klass) {
	session_menu_item_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = session_menu_item_finalize;
}


static void session_menu_item_instance_init (SessionMenuItem * self) {
}


static void session_menu_item_finalize (GObject* obj) {
	SessionMenuItem * self;
	self = SESSION_MENU_ITEM (obj);
	_g_free0 (self->session_name);
	G_OBJECT_CLASS (session_menu_item_parent_class)->finalize (obj);
}


GType session_menu_item_get_type (void) {
	static volatile gsize session_menu_item_type_id__volatile = 0;
	if (g_once_init_enter (&session_menu_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SessionMenuItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) session_menu_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SessionMenuItem), 0, (GInstanceInitFunc) session_menu_item_instance_init, NULL };
		GType session_menu_item_type_id;
		session_menu_item_type_id = g_type_register_static (GTK_TYPE_RADIO_MENU_ITEM, "SessionMenuItem", &g_define_type_info, 0);
		g_once_init_leave (&session_menu_item_type_id__volatile, session_menu_item_type_id);
	}
	return session_menu_item_type_id__volatile;
}


Background* background_construct (GType object_type, const gchar* filename, gint width, gint height) {
	Background* self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (filename != NULL, NULL);
	self = (Background*) g_type_create_instance (object_type);
	_tmp0_ = filename;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->filename);
	self->priv->filename = _tmp1_;
	_tmp2_ = width;
	self->priv->width = _tmp2_;
	_tmp3_ = height;
	self->priv->height = _tmp3_;
	return self;
}


Background* background_new (const gchar* filename, gint width, gint height) {
	return background_construct (TYPE_BACKGROUND, filename, width, height);
}


static gpointer _background_render_gthread_func (gpointer self) {
	gpointer result;
	result = background_render (self);
	return result;
}


gboolean background_load (Background* self) {
	gboolean result = FALSE;
	cairo_pattern_t* _tmp0_;
	GThread* _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->pattern;
	if (_tmp0_ != NULL) {
		result = TRUE;
		return result;
	}
	_tmp1_ = self->priv->thread;
	if (_tmp1_ != NULL) {
		result = FALSE;
		return result;
	}
	_tmp2_ = self->priv->filename;
	_tmp3_ = self->priv->width;
	_tmp4_ = self->priv->height;
	g_debug ("user-list.vala:158: Making background %s at %dx%d", _tmp2_, _tmp3_, _tmp4_);
	{
		GThread* _tmp5_ = NULL;
		GThread* _tmp6_;
		_tmp5_ = g_thread_create (_background_render_gthread_func, self, TRUE, &_inner_error_);
		_tmp6_ = _tmp5_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_THREAD_ERROR) {
				goto __catch9_g_thread_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		self->priv->thread = _tmp6_;
	}
	goto __finally9;
	__catch9_g_thread_error:
	{
		GError* e = NULL;
		cairo_pattern_t* _tmp7_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = cairo_pattern_create_rgb ((gdouble) 0, (gdouble) 0, (gdouble) 0);
		_cairo_pattern_destroy0 (self->pattern);
		self->pattern = _tmp7_;
		result = TRUE;
		_g_error_free0 (e);
		return result;
	}
	__finally9:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = FALSE;
	return result;
}


static gboolean background_ready_cb (Background* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GThread* _tmp3_;
	gpointer _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->filename;
	_tmp1_ = self->priv->width;
	_tmp2_ = self->priv->height;
	g_debug ("user-list.vala:174: Render of background %s at %dx%d complete", _tmp0_, _tmp1_, _tmp2_);
	_tmp3_ = self->priv->thread;
	_tmp4_ = g_thread_join (_tmp3_);
	_cairo_pattern_destroy0 (self->pattern);
	self->pattern = (cairo_pattern_t*) _tmp4_;
	self->priv->thread = NULL;
	g_signal_emit_by_name (self, "loaded");
	result = FALSE;
	return result;
}


static gboolean _background_ready_cb_gsource_func (gpointer self) {
	gboolean result;
	result = background_ready_cb (self);
	return result;
}


static cairo_pattern_t* background_render (Background* self) {
	cairo_pattern_t* result = NULL;
	GdkColor color = {0};
	GdkPixbuf* orig_image;
	const gchar* _tmp0_;
	GdkColor _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	GdkPixbuf* image;
	GdkPixbuf* _tmp8_;
	gint _tmp57_;
	gint _tmp58_ = 0;
	gint grid_x_offset;
	gint _tmp59_;
	gint _tmp60_ = 0;
	gint grid_y_offset;
	gint _tmp61_;
	gint _tmp62_;
	cairo_surface_t* _tmp63_;
	cairo_surface_t* overlay_surface;
	cairo_surface_t* _tmp64_;
	cairo_t* _tmp65_;
	cairo_t* oc;
	cairo_t* _tmp66_;
	cairo_t* _tmp67_;
	gint _tmp68_;
	cairo_t* _tmp69_;
	gint _tmp70_;
	cairo_t* _tmp71_;
	gint _tmp72_;
	gint _tmp73_;
	cairo_t* _tmp74_;
	cairo_t* _tmp75_;
	cairo_surface_t* _tmp76_;
	cairo_pattern_t* _tmp77_;
	cairo_pattern_t* overlay;
	cairo_matrix_t matrix = {0};
	gint _tmp78_;
	gint _tmp79_;
	cairo_pattern_t* _tmp80_;
	cairo_matrix_t _tmp81_;
	cairo_pattern_t* _tmp82_;
	gint _tmp83_;
	gint _tmp84_;
	cairo_surface_t* _tmp85_;
	cairo_surface_t* surface;
	cairo_surface_t* _tmp86_;
	cairo_t* _tmp87_;
	cairo_t* bc;
	GdkPixbuf* _tmp88_;
	cairo_t* _tmp93_;
	cairo_t* _tmp94_;
	cairo_pattern_t* _tmp95_;
	cairo_t* _tmp96_;
	gint _tmp97_;
	gint _tmp98_;
	gint _tmp99_;
	gint _tmp100_;
	gint _tmp101_;
	gint _tmp102_;
	cairo_t* _tmp103_;
	cairo_surface_t* _tmp104_;
	cairo_surface_t* _tmp117_;
	cairo_pattern_t* _tmp118_;
	cairo_pattern_t* pattern;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	orig_image = NULL;
	_tmp0_ = self->priv->filename;
	_tmp2_ = gdk_color_parse (_tmp0_, &_tmp1_);
	color = _tmp1_;
	if (!_tmp2_) {
		{
			const gchar* _tmp3_;
			GdkPixbuf* _tmp4_;
			GdkPixbuf* _tmp5_;
			_tmp3_ = self->priv->filename;
			_tmp4_ = gdk_pixbuf_new_from_file (_tmp3_, &_inner_error_);
			_tmp5_ = _tmp4_;
			if (_inner_error_ != NULL) {
				goto __catch10_g_error;
			}
			_g_object_unref0 (orig_image);
			orig_image = _tmp5_;
		}
		goto __finally10;
		__catch10_g_error:
		{
			GError* e = NULL;
			GError* _tmp6_;
			const gchar* _tmp7_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp6_ = e;
			_tmp7_ = _tmp6_->message;
			g_debug ("user-list.vala:196: Error loading background: %s", _tmp7_);
			_g_error_free0 (e);
		}
		__finally10:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (orig_image);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	image = NULL;
	_tmp8_ = orig_image;
	if (_tmp8_ != NULL) {
		gint _tmp9_;
		gint _tmp10_;
		gdouble target_aspect;
		GdkPixbuf* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		GdkPixbuf* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gdouble aspect;
		gdouble scale = 0.0;
		gdouble offset_x;
		gdouble offset_y;
		gdouble _tmp17_;
		gdouble _tmp18_;
		GdkPixbuf* _tmp37_;
		GdkColorspace _tmp38_;
		GdkColorspace _tmp39_;
		GdkPixbuf* _tmp40_;
		gboolean _tmp41_;
		gboolean _tmp42_;
		GdkPixbuf* _tmp43_;
		gint _tmp44_;
		gint _tmp45_;
		gint _tmp46_;
		gint _tmp47_;
		GdkPixbuf* _tmp48_;
		GdkPixbuf* _tmp49_;
		GdkPixbuf* _tmp50_;
		gint _tmp51_;
		gint _tmp52_;
		gdouble _tmp53_;
		gdouble _tmp54_;
		gdouble _tmp55_;
		gdouble _tmp56_;
		_tmp9_ = self->priv->width;
		_tmp10_ = self->priv->height;
		target_aspect = ((gdouble) _tmp9_) / _tmp10_;
		_tmp11_ = orig_image;
		_tmp12_ = gdk_pixbuf_get_width (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = orig_image;
		_tmp15_ = gdk_pixbuf_get_height (_tmp14_);
		_tmp16_ = _tmp15_;
		aspect = ((gdouble) _tmp13_) / _tmp16_;
		offset_x = (gdouble) 0;
		offset_y = (gdouble) 0;
		_tmp17_ = aspect;
		_tmp18_ = target_aspect;
		if (_tmp17_ > _tmp18_) {
			gint _tmp19_;
			GdkPixbuf* _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
			GdkPixbuf* _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			gdouble _tmp26_;
			gint _tmp27_;
			_tmp19_ = self->priv->height;
			_tmp20_ = orig_image;
			_tmp21_ = gdk_pixbuf_get_height (_tmp20_);
			_tmp22_ = _tmp21_;
			scale = ((gdouble) _tmp19_) / _tmp22_;
			_tmp23_ = orig_image;
			_tmp24_ = gdk_pixbuf_get_width (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = scale;
			_tmp27_ = self->priv->width;
			offset_x = ((_tmp25_ * _tmp26_) - _tmp27_) / 2;
		} else {
			gint _tmp28_;
			GdkPixbuf* _tmp29_;
			gint _tmp30_;
			gint _tmp31_;
			GdkPixbuf* _tmp32_;
			gint _tmp33_;
			gint _tmp34_;
			gdouble _tmp35_;
			gint _tmp36_;
			_tmp28_ = self->priv->width;
			_tmp29_ = orig_image;
			_tmp30_ = gdk_pixbuf_get_width (_tmp29_);
			_tmp31_ = _tmp30_;
			scale = ((gdouble) _tmp28_) / _tmp31_;
			_tmp32_ = orig_image;
			_tmp33_ = gdk_pixbuf_get_height (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = scale;
			_tmp36_ = self->priv->height;
			offset_y = ((_tmp34_ * _tmp35_) - _tmp36_) / 2;
		}
		_tmp37_ = orig_image;
		_tmp38_ = gdk_pixbuf_get_colorspace (_tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = orig_image;
		_tmp41_ = gdk_pixbuf_get_has_alpha (_tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = orig_image;
		_tmp44_ = gdk_pixbuf_get_bits_per_sample (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = self->priv->width;
		_tmp47_ = self->priv->height;
		_tmp48_ = gdk_pixbuf_new (_tmp39_, _tmp42_, _tmp45_, _tmp46_, _tmp47_);
		_g_object_unref0 (image);
		image = _tmp48_;
		_tmp49_ = orig_image;
		_tmp50_ = image;
		_tmp51_ = self->priv->width;
		_tmp52_ = self->priv->height;
		_tmp53_ = offset_x;
		_tmp54_ = offset_y;
		_tmp55_ = scale;
		_tmp56_ = scale;
		gdk_pixbuf_scale (_tmp49_, _tmp50_, 0, 0, _tmp51_, _tmp52_, -_tmp53_, -_tmp54_, _tmp55_, _tmp56_, GDK_INTERP_BILINEAR);
	}
	_tmp57_ = self->priv->width;
	_tmp58_ = get_grid_offset (_tmp57_);
	grid_x_offset = _tmp58_;
	_tmp59_ = self->priv->height;
	_tmp60_ = get_grid_offset (_tmp59_);
	grid_y_offset = _tmp60_;
	_tmp61_ = grid_size;
	_tmp62_ = grid_size;
	_tmp63_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, _tmp61_, _tmp62_);
	overlay_surface = _tmp63_;
	_tmp64_ = overlay_surface;
	_tmp65_ = cairo_create (_tmp64_);
	oc = _tmp65_;
	_tmp66_ = oc;
	cairo_rectangle (_tmp66_, (gdouble) 0, (gdouble) 0, (gdouble) 1, (gdouble) 1);
	_tmp67_ = oc;
	_tmp68_ = grid_size;
	cairo_rectangle (_tmp67_, (gdouble) (_tmp68_ - 1), (gdouble) 0, (gdouble) 1, (gdouble) 1);
	_tmp69_ = oc;
	_tmp70_ = grid_size;
	cairo_rectangle (_tmp69_, (gdouble) 0, (gdouble) (_tmp70_ - 1), (gdouble) 1, (gdouble) 1);
	_tmp71_ = oc;
	_tmp72_ = grid_size;
	_tmp73_ = grid_size;
	cairo_rectangle (_tmp71_, (gdouble) (_tmp72_ - 1), (gdouble) (_tmp73_ - 1), (gdouble) 1, (gdouble) 1);
	_tmp74_ = oc;
	cairo_set_source_rgba (_tmp74_, 1.0, 1.0, 1.0, 0.25);
	_tmp75_ = oc;
	cairo_fill (_tmp75_);
	_tmp76_ = overlay_surface;
	_tmp77_ = cairo_pattern_create_for_surface (_tmp76_);
	overlay = _tmp77_;
	cairo_matrix_init_identity (&matrix);
	_tmp78_ = grid_x_offset;
	_tmp79_ = grid_y_offset;
	cairo_matrix_translate (&matrix, (gdouble) (-_tmp78_), (gdouble) (-_tmp79_));
	_tmp80_ = overlay;
	_tmp81_ = matrix;
	cairo_pattern_set_matrix (_tmp80_, &_tmp81_);
	_tmp82_ = overlay;
	cairo_pattern_set_extend (_tmp82_, CAIRO_EXTEND_REPEAT);
	_tmp83_ = self->priv->width;
	_tmp84_ = self->priv->height;
	_tmp85_ = cairo_image_surface_create (CAIRO_FORMAT_RGB24, _tmp83_, _tmp84_);
	surface = _tmp85_;
	_tmp86_ = surface;
	_tmp87_ = cairo_create (_tmp86_);
	bc = _tmp87_;
	_tmp88_ = image;
	if (_tmp88_ != NULL) {
		cairo_t* _tmp89_;
		GdkPixbuf* _tmp90_;
		_tmp89_ = bc;
		_tmp90_ = image;
		gdk_cairo_set_source_pixbuf (_tmp89_, _tmp90_, (gdouble) 0, (gdouble) 0);
	} else {
		cairo_t* _tmp91_;
		GdkColor _tmp92_;
		_tmp91_ = bc;
		_tmp92_ = color;
		gdk_cairo_set_source_color (_tmp91_, &_tmp92_);
	}
	_tmp93_ = bc;
	cairo_paint (_tmp93_);
	_tmp94_ = bc;
	_tmp95_ = overlay;
	cairo_set_source (_tmp94_, _tmp95_);
	_tmp96_ = bc;
	_tmp97_ = grid_size;
	_tmp98_ = grid_size;
	_tmp99_ = self->priv->width;
	_tmp100_ = grid_size;
	_tmp101_ = self->priv->height;
	_tmp102_ = grid_size;
	cairo_rectangle (_tmp96_, (gdouble) (_tmp97_ - 1), (gdouble) (_tmp98_ - 1), (gdouble) ((_tmp99_ - (_tmp100_ * 2)) + 2), (gdouble) ((_tmp101_ - (_tmp102_ * 2)) + 2));
	_tmp103_ = bc;
	cairo_fill (_tmp103_);
	_tmp104_ = logo_surface;
	if (_tmp104_ != NULL) {
		cairo_t* _tmp105_;
		gint _tmp106_;
		gint _tmp107_;
		gint _tmp108_;
		gint _tmp109_;
		gint y;
		cairo_t* _tmp110_;
		gint _tmp111_;
		gint _tmp112_;
		cairo_t* _tmp113_;
		cairo_surface_t* _tmp114_;
		cairo_t* _tmp115_;
		cairo_t* _tmp116_;
		_tmp105_ = bc;
		cairo_save (_tmp105_);
		_tmp106_ = self->priv->height;
		_tmp107_ = grid_size;
		_tmp108_ = grid_size;
		_tmp109_ = grid_y_offset;
		y = (((gint) ((_tmp106_ / _tmp107_) - 2)) * _tmp108_) + _tmp109_;
		_tmp110_ = bc;
		_tmp111_ = grid_x_offset;
		_tmp112_ = y;
		cairo_translate (_tmp110_, (gdouble) _tmp111_, (gdouble) _tmp112_);
		_tmp113_ = bc;
		_tmp114_ = logo_surface;
		cairo_set_source_surface (_tmp113_, _tmp114_, (gdouble) 0, (gdouble) 0);
		_tmp115_ = bc;
		cairo_paint_with_alpha (_tmp115_, 0.5);
		_tmp116_ = bc;
		cairo_restore (_tmp116_);
	}
	_tmp117_ = surface;
	_tmp118_ = cairo_pattern_create_for_surface (_tmp117_);
	pattern = _tmp118_;
	cairo_pattern_set_extend (pattern, CAIRO_EXTEND_REPEAT);
	gdk_threads_add_idle (_background_ready_cb_gsource_func, self);
	result = pattern;
	_cairo_destroy0 (bc);
	_cairo_surface_destroy0 (surface);
	_cairo_pattern_destroy0 (overlay);
	_cairo_destroy0 (oc);
	_cairo_surface_destroy0 (overlay_surface);
	_g_object_unref0 (image);
	_g_object_unref0 (orig_image);
	return result;
}


static void value_background_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_background_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		background_unref (value->data[0].v_pointer);
	}
}


static void value_background_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = background_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_background_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_background_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Background* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = background_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_background_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Background** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = background_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_background (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecBackground* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_BACKGROUND), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_background (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BACKGROUND), NULL);
	return value->data[0].v_pointer;
}


void value_set_background (GValue* value, gpointer v_object) {
	Background* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BACKGROUND));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BACKGROUND));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		background_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		background_unref (old);
	}
}


void value_take_background (GValue* value, gpointer v_object) {
	Background* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BACKGROUND));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BACKGROUND));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		background_unref (old);
	}
}


static void background_class_init (BackgroundClass * klass) {
	background_parent_class = g_type_class_peek_parent (klass);
	BACKGROUND_CLASS (klass)->finalize = background_finalize;
	g_type_class_add_private (klass, sizeof (BackgroundPrivate));
	g_signal_new ("loaded", TYPE_BACKGROUND, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void background_instance_init (Background * self) {
	self->priv = BACKGROUND_GET_PRIVATE (self);
	self->pattern = NULL;
	self->ref_count = 1;
}


static void background_finalize (Background* obj) {
	Background * self;
	self = BACKGROUND (obj);
	_g_free0 (self->priv->filename);
	_cairo_pattern_destroy0 (self->pattern);
}


GType background_get_type (void) {
	static volatile gsize background_type_id__volatile = 0;
	if (g_once_init_enter (&background_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_background_init, value_background_free_value, value_background_copy_value, value_background_peek_pointer, "p", value_background_collect_value, "p", value_background_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (BackgroundClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) background_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Background), 0, (GInstanceInitFunc) background_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType background_type_id;
		background_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Background", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&background_type_id__volatile, background_type_id);
	}
	return background_type_id__volatile;
}


gpointer background_ref (gpointer instance) {
	Background* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void background_unref (gpointer instance) {
	Background* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BACKGROUND_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _user_entry_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (user_entry_unref (var), NULL));
}


static void _g_list_free__user_entry_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _user_entry_unref0_, NULL);
	g_list_free (self);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gboolean _user_list_menubar_draw_cb_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self) {
	gboolean result;
	result = user_list_menubar_draw_cb (self, cr);
	return result;
}


static void _user_list_prompt_entry_activate_cb_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	user_list_prompt_entry_activate_cb (self);
}


static void _user_list_login_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	user_list_login_button_clicked_cb (self);
}


static void _user_list_options_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	user_list_options_button_clicked_cb (self);
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _background_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (background_unref (var), NULL));
}


static void _user_list_scroll_animate_cb_animate_timer_animate (AnimateTimer* _sender, gdouble timestep, gpointer self) {
	user_list_scroll_animate_cb (self, timestep);
}


static void _user_list_background_animate_cb_animate_timer_animate (AnimateTimer* _sender, gdouble timestep, gpointer self) {
	user_list_background_animate_cb (self, timestep);
}


UserList* user_list_construct (GType object_type) {
	UserList * self = NULL;
	GtkSettings* _tmp0_ = NULL;
	GtkMenuBar* _tmp1_;
	GtkMenuBar* _tmp2_;
	GtkMenuBar* _tmp3_;
	GtkMenuBar* _tmp4_;
	GtkMenuBar* _tmp5_;
	GtkMenuBar* _tmp6_;
	struct utsname _tmp7_ = {0};
	const gchar* _tmp8_;
	GtkLabel* _tmp9_;
	GtkLabel* _tmp10_;
	GtkLabel* label;
	GtkLabel* _tmp11_;
	GtkMenuItem* _tmp12_;
	GtkMenuItem* _tmp13_;
	GtkMenuItem* hostname_item;
	GtkLabel* _tmp14_;
	GtkMenuBar* _tmp15_;
	GtkLabel* _tmp16_;
	GtkLabel* _tmp17_;
	GtkLabel* _tmp18_;
	GtkStyle* _tmp19_ = NULL;
	GdkColor* _tmp20_;
	gint _tmp20__length1;
	GdkColor _tmp21_;
	GtkEntry* _tmp22_;
	GtkEntry* _tmp23_;
	GtkEntry* _tmp24_;
	GtkEntry* _tmp25_;
	GtkEntry* _tmp26_;
	GtkBorder b = {0};
	GtkEntry* _tmp27_;
	GtkBorder _tmp28_;
	GtkEntry* _tmp29_;
	GtkEntry* _tmp30_;
	GtkButton* _tmp31_;
	GtkButton* _tmp32_;
	const gchar* _tmp33_ = NULL;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	GtkLabel* _tmp38_;
	GtkLabel* _tmp39_;
	GtkLabel* _tmp40_;
	GtkLabel* _tmp41_;
	GtkButton* _tmp42_;
	GtkLabel* _tmp43_;
	GtkButton* _tmp44_;
	GtkButton* _tmp45_;
	GtkButton* _tmp46_;
	GtkButton* _tmp47_;
	GtkButton* _tmp48_;
	GtkButton* _tmp49_;
	AtkObject* _tmp50_ = NULL;
	const gchar* _tmp51_ = NULL;
	gchar* _tmp52_ = NULL;
	gchar* _tmp53_;
	GtkImage* _tmp54_;
	GtkImage* _tmp55_;
	GtkImage* _tmp56_;
	GtkImage* image;
	GtkButton* _tmp57_;
	GtkButton* _tmp58_;
	GtkButton* _tmp59_;
	GtkButton* _tmp60_;
	GtkMenu* _tmp61_;
	GtkMenu* _tmp62_;
	GTimer* _tmp63_;
	gchar* _tmp64_ = NULL;
	gchar* _tmp65_;
	cairo_surface_t* _tmp66_;
	cairo_surface_t* _tmp67_;
	cairo_pattern_t* _tmp68_;
	GHashFunc _tmp69_;
	GEqualFunc _tmp70_;
	GHashTable* _tmp71_;
	AnimateTimer* _tmp72_;
	AnimateTimer* _tmp73_;
	AnimateTimer* _tmp74_;
	AnimateTimer* _tmp75_;
	self = (UserList*) g_object_new (object_type, NULL);
	g_object_set ((GtkWidget*) self, "can-focus", FALSE, NULL);
	self->priv->background_alpha = 1.0;
	_tmp0_ = gtk_settings_get_default ();
	g_object_get ((GObject*) _tmp0_, "gtk-theme-name", &self->priv->default_theme_name, NULL);
	_tmp1_ = (GtkMenuBar*) gtk_menu_bar_new ();
	_tmp2_ = g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->menubar);
	self->priv->menubar = _tmp2_;
	_tmp3_ = self->priv->menubar;
	g_signal_connect_object ((GtkWidget*) _tmp3_, "draw", (GCallback) _user_list_menubar_draw_cb_gtk_widget_draw, self, G_CONNECT_AFTER);
	_tmp4_ = self->priv->menubar;
	gtk_menu_bar_set_pack_direction (_tmp4_, GTK_PACK_DIRECTION_RTL);
	_tmp5_ = self->priv->menubar;
	gtk_widget_show ((GtkWidget*) _tmp5_);
	_tmp6_ = self->priv->menubar;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp6_);
	uname (&_tmp7_);
	_tmp8_ = _tmp7_.nodename;
	_tmp9_ = (GtkLabel*) gtk_label_new (_tmp8_);
	_tmp10_ = g_object_ref_sink (_tmp9_);
	label = _tmp10_;
	_tmp11_ = label;
	gtk_widget_show ((GtkWidget*) _tmp11_);
	_tmp12_ = (GtkMenuItem*) gtk_menu_item_new ();
	_tmp13_ = g_object_ref_sink (_tmp12_);
	hostname_item = _tmp13_;
	_tmp14_ = label;
	gtk_container_add ((GtkContainer*) hostname_item, (GtkWidget*) _tmp14_);
	gtk_widget_set_sensitive ((GtkWidget*) hostname_item, FALSE);
	gtk_menu_item_set_right_justified (hostname_item, TRUE);
	gtk_widget_show ((GtkWidget*) hostname_item);
	_tmp15_ = self->priv->menubar;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp15_, (GtkWidget*) hostname_item);
	_tmp16_ = label;
	gtk_widget_ensure_style ((GtkWidget*) _tmp16_);
	_tmp17_ = label;
	_tmp18_ = label;
	_tmp19_ = gtk_widget_get_style ((GtkWidget*) _tmp18_);
	_tmp20_ = _tmp19_->fg;
	_tmp20__length1 = -1;
	_tmp21_ = _tmp20_[GTK_STATE_NORMAL];
	gtk_widget_modify_fg ((GtkWidget*) _tmp17_, GTK_STATE_INSENSITIVE, &_tmp21_);
	_tmp22_ = (GtkEntry*) gtk_entry_new ();
	_tmp23_ = g_object_ref_sink (_tmp22_);
	_g_object_unref0 (self->priv->prompt_entry);
	self->priv->prompt_entry = _tmp23_;
	_tmp24_ = self->priv->prompt_entry;
	gtk_entry_set_invisible_char (_tmp24_, (guint) 10043U);
	_tmp25_ = self->priv->prompt_entry;
	g_object_set (_tmp25_, "caps-lock-warning", TRUE, NULL);
	_tmp26_ = self->priv->prompt_entry;
	gtk_entry_set_has_frame (_tmp26_, FALSE);
	memset (&b, 0, sizeof (GtkBorder));
	b.left = (gint16) 15;
	b.right = (gint16) 15;
	b.top = (gint16) 15;
	b.bottom = (gint16) 15;
	_tmp27_ = self->priv->prompt_entry;
	_tmp28_ = b;
	gtk_entry_set_inner_border (_tmp27_, &_tmp28_);
	_tmp29_ = self->priv->prompt_entry;
	g_signal_connect_object (_tmp29_, "activate", (GCallback) _user_list_prompt_entry_activate_cb_gtk_entry_activate, self, 0);
	_tmp30_ = self->priv->prompt_entry;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp30_);
	_tmp31_ = (GtkButton*) gtk_button_new ();
	_tmp32_ = g_object_ref_sink (_tmp31_);
	_g_object_unref0 (self->priv->login_button);
	self->priv->login_button = _tmp32_;
	_tmp33_ = _ ("Login");
	_tmp34_ = g_strconcat ("<span font_size=\"large\">", _tmp33_, NULL);
	_tmp35_ = _tmp34_;
	_tmp36_ = g_strconcat (_tmp35_, "</span>", NULL);
	_tmp37_ = _tmp36_;
	_tmp38_ = (GtkLabel*) gtk_label_new (_tmp37_);
	_tmp39_ = g_object_ref_sink (_tmp38_);
	_g_object_unref0 (label);
	label = _tmp39_;
	_g_free0 (_tmp37_);
	_g_free0 (_tmp35_);
	_tmp40_ = label;
	gtk_label_set_use_markup (_tmp40_, TRUE);
	_tmp41_ = label;
	gtk_widget_show ((GtkWidget*) _tmp41_);
	_tmp42_ = self->priv->login_button;
	_tmp43_ = label;
	gtk_container_add ((GtkContainer*) _tmp42_, (GtkWidget*) _tmp43_);
	_tmp44_ = self->priv->login_button;
	g_signal_connect_object (_tmp44_, "clicked", (GCallback) _user_list_login_button_clicked_cb_gtk_button_clicked, self, 0);
	_tmp45_ = self->priv->login_button;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp45_);
	_tmp46_ = (GtkButton*) gtk_button_new ();
	_tmp47_ = g_object_ref_sink (_tmp46_);
	_g_object_unref0 (self->priv->options_button);
	self->priv->options_button = _tmp47_;
	_tmp48_ = self->priv->options_button;
	gtk_button_set_focus_on_click (_tmp48_, FALSE);
	_tmp49_ = self->priv->options_button;
	_tmp50_ = gtk_widget_get_accessible ((GtkWidget*) _tmp49_);
	_tmp51_ = _ ("Session Options");
	atk_object_set_name (_tmp50_, _tmp51_);
	_tmp52_ = g_build_filename (PKGDATADIR, "cog.png", NULL, NULL);
	_tmp53_ = _tmp52_;
	_tmp54_ = (GtkImage*) gtk_image_new_from_file (_tmp53_);
	_tmp55_ = g_object_ref_sink (_tmp54_);
	_tmp56_ = _tmp55_;
	_g_free0 (_tmp53_);
	image = _tmp56_;
	gtk_widget_show ((GtkWidget*) image);
	_tmp57_ = self->priv->options_button;
	gtk_button_set_relief (_tmp57_, GTK_RELIEF_NONE);
	_tmp58_ = self->priv->options_button;
	gtk_container_add ((GtkContainer*) _tmp58_, (GtkWidget*) image);
	_tmp59_ = self->priv->options_button;
	g_signal_connect_object (_tmp59_, "clicked", (GCallback) _user_list_options_button_clicked_cb_gtk_button_clicked, self, 0);
	_tmp60_ = self->priv->options_button;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp60_);
	_tmp61_ = (GtkMenu*) gtk_menu_new ();
	_tmp62_ = g_object_ref_sink (_tmp61_);
	_g_object_unref0 (self->priv->options_menu);
	self->priv->options_menu = _tmp62_;
	_tmp63_ = g_timer_new ();
	_g_timer_destroy0 (self->priv->draw_timer);
	self->priv->draw_timer = _tmp63_;
	_tmp64_ = g_build_filename (PKGDATADIR, "dialog_background.png", NULL, NULL);
	_tmp65_ = _tmp64_;
	_tmp66_ = cairo_image_surface_create_from_png (_tmp65_);
	_cairo_surface_destroy0 (self->priv->box_surface);
	self->priv->box_surface = _tmp66_;
	_g_free0 (_tmp65_);
	_tmp67_ = self->priv->box_surface;
	_tmp68_ = cairo_pattern_create_for_surface (_tmp67_);
	_cairo_pattern_destroy0 (self->priv->box_pattern);
	self->priv->box_pattern = _tmp68_;
	_tmp69_ = g_str_hash;
	_tmp70_ = g_str_equal;
	_tmp71_ = g_hash_table_new_full (_tmp69_, _tmp70_, _g_free0_, _background_unref0_);
	_g_hash_table_unref0 (self->priv->backgrounds);
	self->priv->backgrounds = _tmp71_;
	_tmp72_ = animate_timer_new ();
	_animate_timer_unref0 (self->priv->scroll_timer);
	self->priv->scroll_timer = _tmp72_;
	_tmp73_ = self->priv->scroll_timer;
	g_signal_connect_object (_tmp73_, "animate", (GCallback) _user_list_scroll_animate_cb_animate_timer_animate, self, 0);
	_tmp74_ = animate_timer_new ();
	_animate_timer_unref0 (self->priv->background_timer);
	self->priv->background_timer = _tmp74_;
	_tmp75_ = self->priv->background_timer;
	g_signal_connect_object (_tmp75_, "animate", (GCallback) _user_list_background_animate_cb_animate_timer_animate, self, 0);
	user_list_setup_indicators (self);
	_g_object_unref0 (image);
	_g_object_unref0 (hostname_item);
	_g_object_unref0 (label);
	return self;
}


UserList* user_list_new (void) {
	return user_list_construct (TYPE_USER_LIST);
}


void user_list_set_logo (UserList* self, const gchar* logo_path) {
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (logo_path != NULL);
	_tmp0_ = logo_path;
	_tmp1_ = g_file_test (_tmp0_, G_FILE_TEST_EXISTS);
	if (_tmp1_) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		cairo_surface_t* _tmp4_;
		_tmp2_ = logo_path;
		g_debug ("user-list.vala:439: Using logo %s", _tmp2_);
		_tmp3_ = logo_path;
		_tmp4_ = cairo_image_surface_create_from_png (_tmp3_);
		_cairo_surface_destroy0 (logo_surface);
		logo_surface = _tmp4_;
	} else {
		const gchar* _tmp5_;
		_tmp5_ = logo_path;
		g_debug ("user-list.vala:444: Can't use logo %s, it does not exist", _tmp5_);
		_cairo_surface_destroy0 (logo_surface);
		logo_surface = NULL;
	}
}


static void user_list_draw_child_cb (UserList* self, GtkWidget* child) {
	GtkMenuBar* _tmp0_;
	GtkWidget* _tmp1_;
	cairo_t* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (child != NULL);
	_tmp0_ = self->priv->menubar;
	_tmp1_ = child;
	_tmp2_ = self->priv->menubar_cairo_context;
	gtk_container_propagate_draw ((GtkContainer*) _tmp0_, _tmp1_, _tmp2_);
}


static gpointer _cairo_reference0 (gpointer self) {
	return self ? cairo_reference (self) : NULL;
}


static void _user_list_draw_child_cb_gtk_callback (GtkWidget* widget, gpointer self) {
	user_list_draw_child_cb (self, widget);
}


static gboolean user_list_menubar_draw_cb (UserList* self, cairo_t* c) {
	gboolean result = FALSE;
	cairo_t* _tmp0_;
	cairo_t* _tmp1_;
	cairo_t* _tmp2_;
	cairo_t* _tmp3_;
	cairo_t* _tmp4_;
	GtkMenuBar* _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	_tmp0_ = c;
	user_list_draw_background (self, _tmp0_);
	_tmp1_ = c;
	cairo_set_source_rgb (_tmp1_, (gdouble) 0, (gdouble) 0, (gdouble) 0);
	_tmp2_ = c;
	cairo_paint_with_alpha (_tmp2_, 0.25);
	_tmp3_ = c;
	_tmp4_ = _cairo_reference0 (_tmp3_);
	_cairo_destroy0 (self->priv->menubar_cairo_context);
	self->priv->menubar_cairo_context = _tmp4_;
	_tmp5_ = self->priv->menubar;
	gtk_container_forall ((GtkContainer*) _tmp5_, _user_list_draw_child_cb_gtk_callback, self);
	result = FALSE;
	return result;
}


static void user_list_greeter_set_env (UserList* self, const gchar* key, const gchar* val) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = key;
	_tmp1_ = val;
	g_setenv (_tmp0_, _tmp1_, TRUE);
	{
		GDBusProxy* _tmp2_;
		GDBusProxy* proxy;
		const GVariantType* _tmp3_;
		GVariantBuilder* _tmp4_;
		GVariantBuilder* builder;
		GVariantBuilder* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		GDBusProxy* _tmp8_;
		GVariantBuilder* _tmp9_;
		GVariant* _tmp10_;
		GVariant* _tmp11_;
		_tmp2_ = g_dbus_proxy_new_for_bus_sync (G_BUS_TYPE_SESSION, G_DBUS_PROXY_FLAGS_NONE, NULL, "org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus", NULL, &_inner_error_);
		proxy = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch11_g_error;
		}
		_tmp3_ = G_VARIANT_TYPE_ARRAY;
		_tmp4_ = g_variant_builder_new (_tmp3_);
		builder = _tmp4_;
		_tmp5_ = builder;
		_tmp6_ = key;
		_tmp7_ = val;
		g_variant_builder_add (_tmp5_, "{ss}", _tmp6_, _tmp7_, NULL);
		_tmp8_ = proxy;
		_tmp9_ = builder;
		_tmp10_ = g_variant_new ("(a{ss})", _tmp9_, NULL);
		_tmp11_ = g_variant_ref_sink (_tmp10_);
		g_dbus_proxy_call (_tmp8_, "UpdateActivationEnvironment", _tmp11_, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL, NULL);
		_g_variant_unref0 (_tmp11_);
		_g_variant_builder_unref0 (builder);
		_g_object_unref0 (proxy);
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_warning ("user-list.vala:489: Could not get set environment for indicators: %s", _tmp13_);
		_g_error_free0 (e);
		return;
	}
	__finally11:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void _user_list_keyboard_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self) {
	user_list_keyboard_toggled_cb (self, _sender);
}


static void _user_list_high_contrast_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self) {
	user_list_high_contrast_toggled_cb (self, _sender);
}


static void _user_list_screen_reader_toggled_cb_gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self) {
	user_list_screen_reader_toggled_cb (self, _sender);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _user_list_indicator_added_cb_indicator_object_entry_added (IndicatorObject* _sender, IndicatorObjectEntry* entry, gpointer self) {
	user_list_indicator_added_cb (self, _sender, entry);
}


static void _user_list_indicator_removed_cb_indicator_object_entry_removed (IndicatorObject* _sender, IndicatorObjectEntry* entry, gpointer self) {
	user_list_indicator_removed_cb (self, _sender, entry);
}


static void user_list_setup_indicators (UserList* self) {
	GtkMenuItem* _tmp0_;
	GtkMenuItem* _tmp1_;
	GtkMenuItem* a11y_item;
	GtkHBox* _tmp2_;
	GtkHBox* _tmp3_;
	GtkHBox* hbox;
	GtkHBox* _tmp4_;
	GtkMenuItem* _tmp5_;
	GtkHBox* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	GtkImage* _tmp9_;
	GtkImage* _tmp10_;
	GtkImage* _tmp11_;
	GtkImage* image;
	GtkImage* _tmp12_;
	GtkHBox* _tmp13_;
	GtkImage* _tmp14_;
	GtkMenuItem* _tmp15_;
	GtkMenuItem* _tmp16_;
	GtkMenu* _tmp17_;
	GtkMenu* _tmp18_;
	const gchar* _tmp19_ = NULL;
	GtkCheckMenuItem* _tmp20_;
	GtkCheckMenuItem* _tmp21_;
	GtkCheckMenuItem* item;
	GtkCheckMenuItem* _tmp22_;
	GtkCheckMenuItem* _tmp23_;
	GtkMenuItem* _tmp24_;
	GtkMenu* _tmp25_;
	GtkMenu* _tmp26_;
	GtkCheckMenuItem* _tmp27_;
	const gchar* _tmp28_ = NULL;
	GtkCheckMenuItem* _tmp29_;
	GtkCheckMenuItem* _tmp30_;
	GtkCheckMenuItem* _tmp31_;
	GtkCheckMenuItem* _tmp32_;
	GtkMenuItem* _tmp33_;
	GtkMenu* _tmp34_;
	GtkMenu* _tmp35_;
	GtkCheckMenuItem* _tmp36_;
	const gchar* _tmp37_ = NULL;
	GtkCheckMenuItem* _tmp38_;
	GtkCheckMenuItem* _tmp39_;
	GtkCheckMenuItem* _tmp40_;
	GtkCheckMenuItem* _tmp41_;
	GtkMenuItem* _tmp42_;
	GtkMenu* _tmp43_;
	GtkMenu* _tmp44_;
	GtkCheckMenuItem* _tmp45_;
	GtkMenuBar* _tmp46_;
	GtkMenuItem* _tmp47_;
	GtkMenuBar* _tmp48_;
	GList* _tmp49_ = NULL;
	GList* _tmp50_;
	guint _tmp51_ = 0U;
	const gchar* _tmp52_ = NULL;
	const gchar* _tmp53_ = NULL;
	gchar* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	gchar** _tmp58_ = NULL;
	gchar** filenames;
	gint filenames_length1;
	gint _filenames_size_;
	gchar** _tmp59_;
	gint _tmp59__length1;
	const gchar* _tmp71_ = NULL;
	const gchar* _tmp72_ = NULL;
	g_return_if_fail (self != NULL);
	user_list_greeter_set_env (self, "INDICATOR_GREETER_MODE", "1");
	user_list_greeter_set_env (self, "GIO_USE_VFS", "local");
	user_list_greeter_set_env (self, "GVFS_DISABLE_FUSE", "1");
	user_list_greeter_set_env (self, "RUNNING_UNDER_GDM", "1");
	_tmp0_ = (GtkMenuItem*) gtk_menu_item_new ();
	_tmp1_ = g_object_ref_sink (_tmp0_);
	a11y_item = _tmp1_;
	_tmp2_ = (GtkHBox*) gtk_hbox_new (FALSE, 3);
	_tmp3_ = g_object_ref_sink (_tmp2_);
	hbox = _tmp3_;
	_tmp4_ = hbox;
	gtk_widget_show ((GtkWidget*) _tmp4_);
	_tmp5_ = a11y_item;
	_tmp6_ = hbox;
	gtk_container_add ((GtkContainer*) _tmp5_, (GtkWidget*) _tmp6_);
	_tmp7_ = g_build_filename (PKGDATADIR, "a11y.svg", NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = (GtkImage*) gtk_image_new_from_file (_tmp8_);
	_tmp10_ = g_object_ref_sink (_tmp9_);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp8_);
	image = _tmp11_;
	_tmp12_ = image;
	gtk_widget_show ((GtkWidget*) _tmp12_);
	_tmp13_ = hbox;
	_tmp14_ = image;
	gtk_container_add ((GtkContainer*) _tmp13_, (GtkWidget*) _tmp14_);
	_tmp15_ = a11y_item;
	gtk_widget_show ((GtkWidget*) _tmp15_);
	_tmp16_ = a11y_item;
	_tmp17_ = (GtkMenu*) gtk_menu_new ();
	_tmp18_ = g_object_ref_sink (_tmp17_);
	gtk_menu_item_set_submenu (_tmp16_, _tmp18_);
	_g_object_unref0 (_tmp18_);
	_tmp19_ = _ ("Onscreen keyboard");
	_tmp20_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label (_tmp19_);
	_tmp21_ = g_object_ref_sink (_tmp20_);
	item = _tmp21_;
	_tmp22_ = item;
	g_signal_connect_object (_tmp22_, "toggled", (GCallback) _user_list_keyboard_toggled_cb_gtk_check_menu_item_toggled, self, 0);
	_tmp23_ = item;
	gtk_widget_show ((GtkWidget*) _tmp23_);
	_tmp24_ = a11y_item;
	_tmp25_ = gtk_menu_item_get_submenu (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = item;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp26_, (GtkWidget*) ((GtkMenuItem*) _tmp27_));
	_tmp28_ = _ ("High Contrast");
	_tmp29_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label (_tmp28_);
	_tmp30_ = g_object_ref_sink (_tmp29_);
	_g_object_unref0 (self->priv->high_contrast_item);
	self->priv->high_contrast_item = _tmp30_;
	_tmp31_ = self->priv->high_contrast_item;
	g_signal_connect_object (_tmp31_, "toggled", (GCallback) _user_list_high_contrast_toggled_cb_gtk_check_menu_item_toggled, self, 0);
	_tmp32_ = self->priv->high_contrast_item;
	gtk_widget_show ((GtkWidget*) _tmp32_);
	_tmp33_ = a11y_item;
	_tmp34_ = gtk_menu_item_get_submenu (_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = self->priv->high_contrast_item;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp35_, (GtkWidget*) ((GtkMenuItem*) _tmp36_));
	_tmp37_ = _ ("Screen Reader");
	_tmp38_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label (_tmp37_);
	_tmp39_ = g_object_ref_sink (_tmp38_);
	_g_object_unref0 (item);
	item = _tmp39_;
	_tmp40_ = item;
	g_signal_connect_object (_tmp40_, "toggled", (GCallback) _user_list_screen_reader_toggled_cb_gtk_check_menu_item_toggled, self, 0);
	_tmp41_ = item;
	gtk_widget_show ((GtkWidget*) _tmp41_);
	_tmp42_ = a11y_item;
	_tmp43_ = gtk_menu_item_get_submenu (_tmp42_);
	_tmp44_ = _tmp43_;
	_tmp45_ = item;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp44_, (GtkWidget*) ((GtkMenuItem*) _tmp45_));
	_tmp46_ = self->priv->menubar;
	_tmp47_ = a11y_item;
	_tmp48_ = self->priv->menubar;
	_tmp49_ = gtk_container_get_children ((GtkContainer*) _tmp48_);
	_tmp50_ = _tmp49_;
	_tmp51_ = g_list_length (_tmp50_);
	gtk_menu_shell_insert ((GtkMenuShell*) _tmp46_, (GtkWidget*) _tmp47_, ((gint) _tmp51_) - 1);
	_g_list_free0 (_tmp50_);
	_tmp52_ = g_getenv ("LANG");
	_tmp53_ = g_getenv ("LANGUAGE");
	g_debug ("user-list.vala:529: LANG=%s LANGUAGE=%s", _tmp52_, _tmp53_);
	_tmp54_ = g_strdup ("/usr/lib/indicators3/6/libsession.so");
	_tmp55_ = g_strdup ("/usr/lib/indicators3/6/libdatetime.so");
	_tmp56_ = g_strdup ("/usr/lib/indicators3/6/libpower.so");
	_tmp57_ = g_strdup ("/usr/lib/indicators3/6/libsoundmenu.so");
	_tmp58_ = g_new0 (gchar*, 4 + 1);
	_tmp58_[0] = _tmp54_;
	_tmp58_[1] = _tmp55_;
	_tmp58_[2] = _tmp56_;
	_tmp58_[3] = _tmp57_;
	filenames = _tmp58_;
	filenames_length1 = 4;
	_filenames_size_ = filenames_length1;
	_tmp59_ = filenames;
	_tmp59__length1 = filenames_length1;
	{
		gchar** filename_collection = NULL;
		gint filename_collection_length1 = 0;
		gint _filename_collection_size_ = 0;
		gint filename_it = 0;
		filename_collection = _tmp59_;
		filename_collection_length1 = _tmp59__length1;
		for (filename_it = 0; filename_it < _tmp59__length1; filename_it = filename_it + 1) {
			gchar* _tmp60_;
			gchar* filename = NULL;
			_tmp60_ = g_strdup (filename_collection[filename_it]);
			filename = _tmp60_;
			{
				const gchar* _tmp61_;
				IndicatorObject* _tmp62_;
				IndicatorObject* io;
				IndicatorObject* _tmp63_;
				IndicatorObject* _tmp64_;
				IndicatorObject* _tmp65_;
				IndicatorObject* _tmp66_;
				IndicatorObject* _tmp67_;
				GList* _tmp68_ = NULL;
				_tmp61_ = filename;
				_tmp62_ = indicator_object_new_from_file (_tmp61_);
				io = _tmp62_;
				_tmp63_ = io;
				_tmp64_ = _g_object_ref0 (_tmp63_);
				self->indicator_objects = g_list_append (self->indicator_objects, _tmp64_);
				_tmp65_ = io;
				g_signal_connect_object (_tmp65_, "entry-added", (GCallback) _user_list_indicator_added_cb_indicator_object_entry_added, self, 0);
				_tmp66_ = io;
				g_signal_connect_object (_tmp66_, "entry-removed", (GCallback) _user_list_indicator_removed_cb_indicator_object_entry_removed, self, 0);
				_tmp67_ = io;
				_tmp68_ = indicator_object_get_entries (_tmp67_);
				{
					GList* entry_collection = NULL;
					GList* entry_it = NULL;
					entry_collection = _tmp68_;
					for (entry_it = entry_collection; entry_it != NULL; entry_it = entry_it->next) {
						IndicatorObjectEntry* entry = NULL;
						entry = (IndicatorObjectEntry*) entry_it->data;
						{
							IndicatorObject* _tmp69_;
							IndicatorObjectEntry* _tmp70_;
							_tmp69_ = io;
							_tmp70_ = entry;
							user_list_indicator_added_cb (self, _tmp69_, _tmp70_);
						}
					}
					_g_list_free0 (entry_collection);
				}
				_g_object_unref0 (io);
				_g_free0 (filename);
			}
		}
	}
	_tmp71_ = g_getenv ("LANG");
	_tmp72_ = g_getenv ("LANGUAGE");
	g_debug ("user-list.vala:543: LANG=%s LANGUAGE=%s", _tmp71_, _tmp72_);
	filenames = (_vala_array_free (filenames, filenames_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (item);
	_g_object_unref0 (image);
	_g_object_unref0 (hbox);
	_g_object_unref0 (a11y_item);
}


static void user_list_keyboard_toggled_cb (UserList* self, GtkCheckMenuItem* item) {
	GtkWindow* _tmp0_;
	GtkWindow* _tmp30_;
	GtkCheckMenuItem* _tmp31_;
	gboolean _tmp32_;
	gboolean _tmp33_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = self->priv->keyboard_window;
	if (_tmp0_ == NULL) {
		gint id = 0;
		GtkSocket* _tmp15_;
		GtkSocket* _tmp16_;
		GtkSocket* keyboard_socket;
		GtkSocket* _tmp17_;
		GtkWindow* _tmp18_;
		GtkWindow* _tmp19_;
		GtkWindow* _tmp20_;
		GtkWindow* _tmp21_;
		GtkWindow* _tmp22_;
		GtkSocket* _tmp23_;
		GtkSocket* _tmp24_;
		gint _tmp25_;
		GtkWindow* _tmp26_;
		gint _tmp27_ = 0;
		GtkWindow* _tmp28_;
		gint _tmp29_ = 0;
		{
			gchar** argv = NULL;
			gint argv_length1 = 0;
			gint _argv_size_ = 0;
			gint onboard_stdout_fd = 0;
			gchar** _tmp1_ = NULL;
			gint _tmp2_ = 0;
			gchar** _tmp3_;
			gint _tmp3__length1;
			GPid _tmp4_ = 0;
			gint _tmp5_ = 0;
			gint _tmp6_;
			FILE* _tmp7_ = NULL;
			FILE* f;
			gchar* _tmp8_ = NULL;
			gchar* stdout_text;
			gint stdout_text_length1;
			gint _stdout_text_size_;
			FILE* _tmp9_;
			gchar* _tmp10_;
			gint _tmp10__length1;
			gchar* _tmp11_;
			gint _tmp11__length1;
			gint _tmp12_ = 0;
			g_shell_parse_argv ("onboard --xid", &_tmp2_, &_tmp1_, &_inner_error_);
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			argv = _tmp1_;
			argv_length1 = _tmp2_;
			_argv_size_ = argv_length1;
			if (_inner_error_ != NULL) {
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				goto __catch12_g_error;
			}
			_tmp3_ = argv;
			_tmp3__length1 = argv_length1;
			g_spawn_async_with_pipes (NULL, _tmp3_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp4_, NULL, &_tmp5_, NULL, &_inner_error_);
			self->priv->keyboard_pid = _tmp4_;
			onboard_stdout_fd = _tmp5_;
			if (_inner_error_ != NULL) {
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				goto __catch12_g_error;
			}
			_tmp6_ = onboard_stdout_fd;
			_tmp7_ = fdopen (_tmp6_, "r");
			f = _tmp7_;
			_tmp8_ = g_new0 (gchar, 1024);
			stdout_text = _tmp8_;
			stdout_text_length1 = 1024;
			_stdout_text_size_ = stdout_text_length1;
			_tmp9_ = f;
			_tmp10_ = stdout_text;
			_tmp10__length1 = stdout_text_length1;
			fgets (_tmp10_, _tmp10__length1, _tmp9_);
			_tmp11_ = stdout_text;
			_tmp11__length1 = stdout_text_length1;
			_tmp12_ = atoi ((const gchar*) _tmp11_);
			id = _tmp12_;
			stdout_text = (g_free (stdout_text), NULL);
			_fclose0 (f);
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		}
		goto __finally12;
		__catch12_g_error:
		{
			GError* e = NULL;
			GError* _tmp13_;
			const gchar* _tmp14_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp13_ = e;
			_tmp14_ = _tmp13_->message;
			g_warning ("user-list.vala:575: Error setting up keyboard: %s", _tmp14_);
			_g_error_free0 (e);
			return;
		}
		__finally12:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp15_ = (GtkSocket*) gtk_socket_new ();
		_tmp16_ = g_object_ref_sink (_tmp15_);
		keyboard_socket = _tmp16_;
		_tmp17_ = keyboard_socket;
		gtk_widget_show ((GtkWidget*) _tmp17_);
		_tmp18_ = (GtkWindow*) gtk_window_new (GTK_WINDOW_TOPLEVEL);
		_tmp19_ = g_object_ref_sink (_tmp18_);
		_g_object_unref0 (self->priv->keyboard_window);
		self->priv->keyboard_window = _tmp19_;
		_tmp20_ = self->priv->keyboard_window;
		gtk_window_set_accept_focus (_tmp20_, FALSE);
		_tmp21_ = self->priv->keyboard_window;
		gtk_window_set_focus_on_map (_tmp21_, FALSE);
		_tmp22_ = self->priv->keyboard_window;
		_tmp23_ = keyboard_socket;
		gtk_container_add ((GtkContainer*) _tmp22_, (GtkWidget*) _tmp23_);
		_tmp24_ = keyboard_socket;
		_tmp25_ = id;
		gtk_socket_add_id (_tmp24_, _tmp25_);
		_tmp26_ = self->priv->keyboard_window;
		_tmp27_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
		gtk_window_move (_tmp26_, 0, _tmp27_ - 200);
		_tmp28_ = self->priv->keyboard_window;
		_tmp29_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
		gtk_window_resize (_tmp28_, _tmp29_, 200);
		_g_object_unref0 (keyboard_socket);
	}
	_tmp30_ = self->priv->keyboard_window;
	_tmp31_ = item;
	_tmp32_ = gtk_check_menu_item_get_active (_tmp31_);
	_tmp33_ = _tmp32_;
	gtk_widget_set_visible ((GtkWidget*) _tmp30_, _tmp33_);
}


static void user_list_high_contrast_toggled_cb (UserList* self, GtkCheckMenuItem* item) {
	GtkSettings* _tmp0_ = NULL;
	GtkSettings* _tmp1_;
	GtkSettings* settings;
	GtkCheckMenuItem* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = gtk_settings_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	settings = _tmp1_;
	_tmp2_ = item;
	_tmp3_ = gtk_check_menu_item_get_active (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		GtkSettings* _tmp5_;
		_tmp5_ = settings;
		g_object_set ((GObject*) _tmp5_, "gtk-theme-name", "HighContrastInverse", NULL);
	} else {
		GtkSettings* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = settings;
		_tmp7_ = self->priv->default_theme_name;
		g_object_set ((GObject*) _tmp6_, "gtk-theme-name", _tmp7_, NULL);
	}
	user_list_change_background (self);
	gtk_widget_queue_draw ((GtkWidget*) self);
	_g_object_unref0 (settings);
}


static void user_list_screen_reader_toggled_cb (UserList* self, GtkCheckMenuItem* item) {
	GSettings* _tmp0_;
	GSettings* settings;
	GSettings* _tmp1_;
	GtkCheckMenuItem* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GSettings* _tmp5_;
	GSettings* _tmp6_;
	GtkCheckMenuItem* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = g_settings_new ("org.gnome.desktop.a11y.applications");
	settings = _tmp0_;
	_tmp1_ = settings;
	_tmp2_ = item;
	_tmp3_ = gtk_check_menu_item_get_active (_tmp2_);
	_tmp4_ = _tmp3_;
	g_settings_set_boolean (_tmp1_, "screen-reader-enabled", _tmp4_);
	_tmp5_ = g_settings_new ("org.gnome.desktop.interface");
	_g_object_unref0 (settings);
	settings = _tmp5_;
	_tmp6_ = settings;
	_tmp7_ = item;
	_tmp8_ = gtk_check_menu_item_get_active (_tmp7_);
	_tmp9_ = _tmp8_;
	g_settings_set_boolean (_tmp6_, "toolkit-accessibility", _tmp9_);
	_g_object_unref0 (settings);
}


void user_list_show_message (UserList* self, const gchar* text, gboolean _error_) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = text;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->message);
	self->priv->message = _tmp1_;
	gtk_widget_queue_draw ((GtkWidget*) self);
}


void user_list_show_prompt (UserList* self, const gchar* text, gboolean secret) {
	GtkButton* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GtkEntry* _tmp3_;
	GtkEntry* _tmp4_;
	GtkEntry* _tmp5_;
	GtkEntry* _tmp6_;
	gboolean _tmp7_;
	GtkEntry* _tmp8_;
	AtkObject* _tmp9_ = NULL;
	AtkObject* _tmp10_;
	AtkObject* accessible;
	UserEntry* _tmp11_;
	const gchar* _tmp12_;
	GtkEntry* _tmp27_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = self->priv->login_button;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	_tmp1_ = text;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (self->priv->message);
	self->priv->message = _tmp2_;
	_tmp3_ = self->priv->prompt_entry;
	gtk_entry_set_text (_tmp3_, "");
	_tmp4_ = self->priv->prompt_entry;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, TRUE);
	_tmp5_ = self->priv->prompt_entry;
	gtk_widget_show ((GtkWidget*) _tmp5_);
	_tmp6_ = self->priv->prompt_entry;
	_tmp7_ = secret;
	gtk_entry_set_visibility (_tmp6_, !_tmp7_);
	_tmp8_ = self->priv->prompt_entry;
	_tmp9_ = gtk_widget_get_accessible ((GtkWidget*) _tmp8_);
	_tmp10_ = _g_object_ref0 (_tmp9_);
	accessible = _tmp10_;
	_tmp11_ = self->priv->selected_entry;
	_tmp12_ = _tmp11_->name;
	if (_tmp12_ != NULL) {
		AtkObject* _tmp13_;
		const gchar* _tmp14_ = NULL;
		UserEntry* _tmp15_;
		PangoLayout* _tmp16_;
		const gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_;
		_tmp13_ = accessible;
		_tmp14_ = _ ("Enter password for %s");
		_tmp15_ = self->priv->selected_entry;
		_tmp16_ = _tmp15_->layout;
		_tmp17_ = pango_layout_get_text (_tmp16_);
		_tmp18_ = g_strdup_printf (_tmp14_, _tmp17_);
		_tmp19_ = _tmp18_;
		atk_object_set_name (_tmp13_, _tmp19_);
		_g_free0 (_tmp19_);
	} else {
		GtkEntry* _tmp20_;
		gboolean _tmp21_;
		gboolean _tmp22_;
		_tmp20_ = self->priv->prompt_entry;
		_tmp21_ = gtk_entry_get_visibility (_tmp20_);
		_tmp22_ = _tmp21_;
		if (_tmp22_) {
			AtkObject* _tmp23_;
			const gchar* _tmp24_ = NULL;
			_tmp23_ = accessible;
			_tmp24_ = _ ("Enter username");
			atk_object_set_name (_tmp23_, _tmp24_);
		} else {
			AtkObject* _tmp25_;
			const gchar* _tmp26_ = NULL;
			_tmp25_ = accessible;
			_tmp26_ = _ ("Enter password");
			atk_object_set_name (_tmp25_, _tmp26_);
		}
	}
	_tmp27_ = self->priv->prompt_entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp27_);
	gtk_widget_queue_draw ((GtkWidget*) self);
	_g_object_unref0 (accessible);
}


void user_list_show_authenticated (UserList* self) {
	GtkEntry* _tmp0_;
	gchar* _tmp1_;
	GtkButton* _tmp2_;
	GtkButton* _tmp3_;
	AtkObject* _tmp4_ = NULL;
	AtkObject* _tmp5_;
	AtkObject* accessible;
	const gchar* _tmp6_ = NULL;
	UserEntry* _tmp7_;
	PangoLayout* _tmp8_;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	GtkButton* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->prompt_entry;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	_tmp1_ = g_strdup ("");
	_g_free0 (self->priv->message);
	self->priv->message = _tmp1_;
	_tmp2_ = self->priv->login_button;
	gtk_widget_show ((GtkWidget*) _tmp2_);
	_tmp3_ = self->priv->login_button;
	_tmp4_ = gtk_widget_get_accessible ((GtkWidget*) _tmp3_);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	accessible = _tmp5_;
	_tmp6_ = _ ("Login as %s");
	_tmp7_ = self->priv->selected_entry;
	_tmp8_ = _tmp7_->layout;
	_tmp9_ = pango_layout_get_text (_tmp8_);
	_tmp10_ = g_strdup_printf (_tmp6_, _tmp9_);
	_tmp11_ = _tmp10_;
	atk_object_set_name (accessible, _tmp11_);
	_g_free0 (_tmp11_);
	_tmp12_ = self->priv->login_button;
	gtk_widget_grab_focus ((GtkWidget*) _tmp12_);
	gtk_widget_queue_draw ((GtkWidget*) self);
	_g_object_unref0 (accessible);
}


void user_list_login_complete (UserList* self) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GtkButton* _tmp2_;
	GtkEntry* _tmp3_;
	g_return_if_fail (self != NULL);
	self->priv->complete = TRUE;
	gtk_widget_set_sensitive ((GtkWidget*) self, FALSE);
	_g_free0 (self->priv->error);
	self->priv->error = NULL;
	_tmp0_ = _ ("Logging in...");
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->message);
	self->priv->message = _tmp1_;
	_tmp2_ = self->priv->login_button;
	gtk_widget_hide ((GtkWidget*) _tmp2_);
	_tmp3_ = self->priv->prompt_entry;
	gtk_widget_hide ((GtkWidget*) _tmp3_);
	gtk_widget_queue_draw ((GtkWidget*) self);
}


void user_list_set_error (UserList* self, const gchar* text) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = text;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->error);
	self->priv->error = _tmp1_;
	gtk_widget_queue_draw ((GtkWidget*) self);
}


static guint user_list_get_indicator_index (UserList* self, IndicatorObject* object) {
	guint result = 0U;
	guint index;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (object != NULL, 0U);
	index = (guint) 0;
	_tmp0_ = self->indicator_objects;
	{
		GList* io_collection = NULL;
		GList* io_it = NULL;
		io_collection = _tmp0_;
		for (io_it = io_collection; io_it != NULL; io_it = io_it->next) {
			IndicatorObject* _tmp1_;
			IndicatorObject* io = NULL;
			_tmp1_ = _g_object_ref0 ((IndicatorObject*) io_it->data);
			io = _tmp1_;
			{
				IndicatorObject* _tmp2_;
				IndicatorObject* _tmp3_;
				guint _tmp4_;
				_tmp2_ = io;
				_tmp3_ = object;
				if (_tmp2_ == _tmp3_) {
					result = index;
					_g_object_unref0 (io);
					return result;
				}
				_tmp4_ = index;
				index = _tmp4_ + 1;
				_g_object_unref0 (io);
			}
		}
	}
	result = index;
	return result;
}


static IndicatorObject* user_list_get_indicator_object_from_entry (UserList* self, IndicatorObjectEntry* entry) {
	IndicatorObject* result = NULL;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (entry != NULL, NULL);
	_tmp0_ = self->indicator_objects;
	{
		GList* io_collection = NULL;
		GList* io_it = NULL;
		io_collection = _tmp0_;
		for (io_it = io_collection; io_it != NULL; io_it = io_it->next) {
			IndicatorObject* _tmp1_;
			IndicatorObject* io = NULL;
			_tmp1_ = _g_object_ref0 ((IndicatorObject*) io_it->data);
			io = _tmp1_;
			{
				IndicatorObject* _tmp2_;
				GList* _tmp3_ = NULL;
				_tmp2_ = io;
				_tmp3_ = indicator_object_get_entries (_tmp2_);
				{
					GList* e_collection = NULL;
					GList* e_it = NULL;
					e_collection = _tmp3_;
					for (e_it = e_collection; e_it != NULL; e_it = e_it->next) {
						IndicatorObjectEntry* e = NULL;
						e = (IndicatorObjectEntry*) e_it->data;
						{
							IndicatorObjectEntry* _tmp4_;
							IndicatorObjectEntry* _tmp5_;
							_tmp4_ = e;
							_tmp5_ = entry;
							if (_tmp4_ == _tmp5_) {
								result = io;
								_g_list_free0 (e_collection);
								return result;
							}
						}
					}
					_g_list_free0 (e_collection);
				}
				_g_object_unref0 (io);
			}
		}
	}
	result = NULL;
	return result;
}


static void user_list_indicator_added_cb (UserList* self, IndicatorObject* object, IndicatorObjectEntry* entry) {
	IndicatorObject* _tmp0_;
	guint _tmp1_ = 0U;
	guint index;
	gint pos;
	GtkMenuBar* _tmp2_;
	GList* _tmp3_ = NULL;
	IndicatorObjectEntry* _tmp15_;
	gint _tmp16_;
	IndicatorObjectEntry* _tmp17_;
	IndicatorMenuItem* _tmp18_;
	IndicatorMenuItem* _tmp19_;
	IndicatorMenuItem* menuitem;
	GtkMenuBar* _tmp20_;
	gint _tmp21_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	g_return_if_fail (entry != NULL);
	_tmp0_ = object;
	_tmp1_ = user_list_get_indicator_index (self, _tmp0_);
	index = _tmp1_;
	pos = 0;
	_tmp2_ = self->priv->menubar;
	_tmp3_ = gtk_container_get_children ((GtkContainer*) _tmp2_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp3_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* child = NULL;
			child = (GtkWidget*) child_it->data;
			{
				GtkWidget* _tmp4_;
				GtkWidget* _tmp5_;
				IndicatorMenuItem* _tmp6_;
				IndicatorMenuItem* menuitem;
				IndicatorMenuItem* _tmp7_;
				IndicatorObjectEntry* _tmp8_;
				IndicatorObject* _tmp9_ = NULL;
				IndicatorObject* child_object;
				IndicatorObject* _tmp10_;
				guint _tmp11_ = 0U;
				guint child_index;
				guint _tmp12_;
				guint _tmp13_;
				gint _tmp14_;
				_tmp4_ = child;
				if (!IS_INDICATOR_MENU_ITEM (_tmp4_)) {
					break;
				}
				_tmp5_ = child;
				_tmp6_ = _g_object_ref0 (INDICATOR_MENU_ITEM (_tmp5_));
				menuitem = _tmp6_;
				_tmp7_ = menuitem;
				_tmp8_ = _tmp7_->entry;
				_tmp9_ = user_list_get_indicator_object_from_entry (self, _tmp8_);
				child_object = _tmp9_;
				_tmp10_ = child_object;
				_tmp11_ = user_list_get_indicator_index (self, _tmp10_);
				child_index = _tmp11_;
				_tmp12_ = child_index;
				_tmp13_ = index;
				if (_tmp12_ > _tmp13_) {
					_g_object_unref0 (child_object);
					_g_object_unref0 (menuitem);
					break;
				}
				_tmp14_ = pos;
				pos = _tmp14_ + 1;
				_g_object_unref0 (child_object);
				_g_object_unref0 (menuitem);
			}
		}
		_g_list_free0 (child_collection);
	}
	_tmp15_ = entry;
	_tmp16_ = pos;
	g_debug ("user-list.vala:718: Adding indicator object %p at position %d", _tmp15_, _tmp16_);
	_tmp17_ = entry;
	_tmp18_ = indicator_menu_item_new (_tmp17_);
	_tmp19_ = g_object_ref_sink (_tmp18_);
	menuitem = _tmp19_;
	_tmp20_ = self->priv->menubar;
	_tmp21_ = pos;
	gtk_menu_shell_insert ((GtkMenuShell*) _tmp20_, (GtkWidget*) menuitem, _tmp21_);
	_g_object_unref0 (menuitem);
}


static void user_list_indicator_removed_cb (UserList* self, IndicatorObject* object, IndicatorObjectEntry* entry) {
	IndicatorObjectEntry* _tmp0_;
	GtkMenuBar* _tmp1_;
	GList* _tmp2_ = NULL;
	IndicatorObjectEntry* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	g_return_if_fail (entry != NULL);
	_tmp0_ = entry;
	g_debug ("user-list.vala:726: Removing indicator object %p", _tmp0_);
	_tmp1_ = self->priv->menubar;
	_tmp2_ = gtk_container_get_children ((GtkContainer*) _tmp1_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp2_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* child = NULL;
			child = (GtkWidget*) child_it->data;
			{
				GtkWidget* _tmp3_;
				IndicatorMenuItem* _tmp4_;
				IndicatorMenuItem* menuitem;
				IndicatorMenuItem* _tmp5_;
				IndicatorObjectEntry* _tmp6_;
				IndicatorObjectEntry* _tmp7_;
				_tmp3_ = child;
				_tmp4_ = _g_object_ref0 (INDICATOR_MENU_ITEM (_tmp3_));
				menuitem = _tmp4_;
				_tmp5_ = menuitem;
				_tmp6_ = _tmp5_->entry;
				_tmp7_ = entry;
				if (_tmp6_ == _tmp7_) {
					GtkMenuBar* _tmp8_;
					GtkWidget* _tmp9_;
					_tmp8_ = self->priv->menubar;
					_tmp9_ = child;
					gtk_container_remove ((GtkContainer*) _tmp8_, _tmp9_);
					_g_object_unref0 (menuitem);
					_g_list_free0 (child_collection);
					return;
				}
				_g_object_unref0 (menuitem);
			}
		}
		_g_list_free0 (child_collection);
	}
	_tmp10_ = entry;
	g_warning ("user-list.vala:738: Indicator object %p not in menubar", _tmp10_);
}


void user_list_add_session (UserList* self, const gchar* name, const gchar* label) {
	SessionMenuItem* _tmp0_;
	SessionMenuItem* _tmp1_;
	SessionMenuItem* item;
	GSList* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	GtkMenu* _tmp6_;
	GSList* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (label != NULL);
	_tmp0_ = session_menu_item_new ();
	_tmp1_ = g_object_ref_sink (_tmp0_);
	item = _tmp1_;
	_tmp2_ = self->priv->session_group;
	gtk_radio_menu_item_set_group ((GtkRadioMenuItem*) item, _tmp2_);
	_tmp3_ = name;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (item->session_name);
	item->session_name = _tmp4_;
	_tmp5_ = label;
	gtk_menu_item_set_label ((GtkMenuItem*) item, _tmp5_);
	gtk_widget_show ((GtkWidget*) item);
	_tmp6_ = self->priv->options_menu;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp6_, (GtkWidget*) ((GtkMenuItem*) item));
	_tmp7_ = gtk_radio_menu_item_get_group ((GtkRadioMenuItem*) item);
	self->priv->session_group = (GSList*) _tmp7_;
	_g_object_unref0 (item);
}


static gpointer _user_entry_ref0 (gpointer self) {
	return self ? user_entry_ref (self) : NULL;
}


static UserEntry* user_list_find_entry (UserList* self, const gchar* name) {
	UserEntry* result = NULL;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->entries;
	{
		GList* entry_collection = NULL;
		GList* entry_it = NULL;
		entry_collection = _tmp0_;
		for (entry_it = entry_collection; entry_it != NULL; entry_it = entry_it->next) {
			UserEntry* _tmp1_;
			UserEntry* entry = NULL;
			_tmp1_ = _user_entry_ref0 ((UserEntry*) entry_it->data);
			entry = _tmp1_;
			{
				UserEntry* _tmp2_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				_tmp2_ = entry;
				_tmp3_ = _tmp2_->name;
				_tmp4_ = name;
				if (g_strcmp0 (_tmp3_, _tmp4_) == 0) {
					result = entry;
					return result;
				}
				_user_entry_unref0 (entry);
			}
		}
	}
	result = NULL;
	return result;
}


void user_list_add_entry (UserList* self, const gchar* name, const gchar* label, const gchar* background, gboolean is_active) {
	const gchar* _tmp0_;
	UserEntry* _tmp1_ = NULL;
	UserEntry* e;
	UserEntry* _tmp2_;
	UserEntry* _tmp9_;
	const gchar* _tmp10_;
	PangoLayout* _tmp11_ = NULL;
	UserEntry* _tmp12_;
	PangoLayout* _tmp13_;
	PangoFontDescription* _tmp14_ = NULL;
	PangoFontDescription* _tmp15_;
	UserEntry* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	UserEntry* _tmp19_;
	gboolean _tmp20_;
	UserEntry* _tmp21_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (label != NULL);
	g_return_if_fail (background != NULL);
	_tmp0_ = name;
	_tmp1_ = user_list_find_entry (self, _tmp0_);
	e = _tmp1_;
	_tmp2_ = e;
	if (_tmp2_ == NULL) {
		UserEntry* _tmp3_;
		UserEntry* _tmp4_;
		UserEntry* _tmp5_;
		UserEntry* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp3_ = user_entry_new ();
		_user_entry_unref0 (e);
		e = _tmp3_;
		_tmp4_ = e;
		_tmp5_ = _user_entry_ref0 (_tmp4_);
		self->priv->entries = g_list_append (self->priv->entries, _tmp5_);
		_tmp6_ = e;
		_tmp7_ = name;
		_tmp8_ = g_strdup (_tmp7_);
		_g_free0 (_tmp6_->name);
		_tmp6_->name = _tmp8_;
	}
	_tmp9_ = e;
	_tmp10_ = label;
	_tmp11_ = gtk_widget_create_pango_layout ((GtkWidget*) self, _tmp10_);
	_g_object_unref0 (_tmp9_->layout);
	_tmp9_->layout = _tmp11_;
	_tmp12_ = e;
	_tmp13_ = _tmp12_->layout;
	_tmp14_ = pango_font_description_from_string ("Ubuntu 16");
	_tmp15_ = _tmp14_;
	pango_layout_set_font_description (_tmp13_, _tmp15_);
	_pango_font_description_free0 (_tmp15_);
	_tmp16_ = e;
	_tmp17_ = background;
	_tmp18_ = g_strdup (_tmp17_);
	_g_free0 (_tmp16_->background);
	_tmp16_->background = _tmp18_;
	_tmp19_ = e;
	_tmp20_ = is_active;
	_tmp19_->is_active = _tmp20_;
	_tmp21_ = self->priv->selected_entry;
	if (_tmp21_ == NULL) {
		UserEntry* _tmp22_;
		_tmp22_ = e;
		user_list_select_entry (self, _tmp22_, 1.0);
	} else {
		UserEntry* _tmp23_;
		_tmp23_ = self->priv->selected_entry;
		user_list_select_entry (self, _tmp23_, 1.0);
	}
	gtk_widget_queue_draw ((GtkWidget*) self);
	_user_entry_unref0 (e);
}


void user_list_set_active_entry (UserList* self, const gchar* name) {
	const gchar* _tmp0_;
	UserEntry* _tmp1_ = NULL;
	UserEntry* e;
	UserEntry* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = name;
	_tmp1_ = user_list_find_entry (self, _tmp0_);
	e = _tmp1_;
	_tmp2_ = e;
	if (_tmp2_ != NULL) {
		UserEntry* _tmp3_;
		_tmp3_ = e;
		user_list_select_entry (self, _tmp3_, 1.0);
	}
	_user_entry_unref0 (e);
}


void user_list_remove_entry (UserList* self, const gchar* name) {
	const gchar* _tmp0_;
	UserEntry* _tmp1_ = NULL;
	UserEntry* entry;
	UserEntry* _tmp2_;
	GList* _tmp3_;
	UserEntry* _tmp4_;
	gint _tmp5_ = 0;
	gint index;
	UserEntry* _tmp6_;
	UserEntry* _tmp7_;
	UserEntry* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = name;
	_tmp1_ = user_list_find_entry (self, _tmp0_);
	entry = _tmp1_;
	_tmp2_ = entry;
	if (_tmp2_ == NULL) {
		_user_entry_unref0 (entry);
		return;
	}
	_tmp3_ = self->priv->entries;
	_tmp4_ = entry;
	_tmp5_ = g_list_index (_tmp3_, _tmp4_);
	index = _tmp5_;
	_tmp6_ = entry;
	self->priv->entries = g_list_remove (self->priv->entries, _tmp6_);
	_tmp7_ = entry;
	_tmp8_ = self->priv->selected_entry;
	if (_tmp7_ == _tmp8_) {
		gint _tmp9_;
		GList* _tmp10_;
		guint _tmp11_ = 0U;
		GList* _tmp13_;
		gint _tmp14_;
		gconstpointer _tmp15_ = NULL;
		_tmp9_ = index;
		_tmp10_ = self->priv->entries;
		_tmp11_ = g_list_length (_tmp10_);
		if (((guint) _tmp9_) >= _tmp11_) {
			gint _tmp12_;
			_tmp12_ = index;
			index = _tmp12_ - 1;
		}
		_tmp13_ = self->priv->entries;
		_tmp14_ = index;
		_tmp15_ = g_list_nth_data (_tmp13_, (guint) _tmp14_);
		user_list_select_entry (self, (UserEntry*) _tmp15_, -1.0);
	}
	gtk_widget_queue_draw ((GtkWidget*) self);
	_user_entry_unref0 (entry);
}


static void user_list_prompt_entry_activate_cb (UserList* self) {
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GtkEntry* _tmp3_;
	GtkEntry* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->prompt_entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = _tmp1_;
	g_signal_emit_by_name (self, "respond-to-prompt", _tmp2_);
	_tmp3_ = self->priv->prompt_entry;
	gtk_entry_set_text (_tmp3_, "");
	_tmp4_ = self->priv->prompt_entry;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, FALSE);
}


static void user_list_login_button_clicked_cb (UserList* self) {
	UserEntry* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->selected_entry;
	_tmp1_ = _tmp0_->name;
	g_debug ("user-list.vala:835: Start session for %s", _tmp1_);
	g_signal_emit_by_name (self, "start-session");
}


static void user_list_options_menu_position_cb (UserList* self, GtkMenu* menu, gint* x, gint* y, gboolean* push_in) {
	gint _vala_x = 0;
	gint _vala_y = 0;
	gboolean _vala_push_in = FALSE;
	GtkAllocation button_allocation = {0};
	GtkButton* _tmp0_;
	GtkAllocation _tmp1_ = {0};
	GdkWindow* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_;
	GtkAllocation _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GtkAllocation _tmp9_;
	gint _tmp10_;
	GtkAllocation _tmp11_;
	gint _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	_tmp0_ = self->priv->options_button;
	gtk_widget_get_allocation ((GtkWidget*) _tmp0_, &_tmp1_);
	button_allocation = _tmp1_;
	_tmp2_ = gtk_widget_get_window ((GtkWidget*) self);
	gdk_window_get_origin (_tmp2_, &_tmp3_, &_tmp4_);
	_vala_x = _tmp3_;
	_vala_y = _tmp4_;
	_tmp5_ = _vala_x;
	_tmp6_ = button_allocation;
	_tmp7_ = _tmp6_.x;
	_vala_x = _tmp5_ + _tmp7_;
	_tmp8_ = _vala_y;
	_tmp9_ = button_allocation;
	_tmp10_ = _tmp9_.y;
	_tmp11_ = button_allocation;
	_tmp12_ = _tmp11_.height;
	_vala_y = _tmp8_ + (_tmp10_ + _tmp12_);
	_vala_push_in = TRUE;
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
	if (push_in) {
		*push_in = _vala_push_in;
	}
}


static void _user_list_options_menu_position_cb_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self) {
	user_list_options_menu_position_cb (self, menu, x, y, push_in);
}


static void user_list_options_button_clicked_cb (UserList* self) {
	GtkMenu* _tmp0_;
	guint32 _tmp1_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->options_menu;
	_tmp1_ = gtk_get_current_event_time ();
	gtk_menu_popup (_tmp0_, NULL, NULL, _user_list_options_menu_position_cb_gtk_menu_position_func, self, (guint) 0, _tmp1_);
}


static void user_list_scroll_animate_cb (UserList* self, gdouble timestep) {
	gdouble _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp26_;
	gdouble _tmp27_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->scroll_location;
	_tmp1_ = self->priv->scroll_target_location;
	if (_tmp0_ != _tmp1_) {
		gdouble speed;
		gdouble _tmp2_;
		gdouble _tmp3_;
		gdouble delta;
		GList* _tmp4_;
		guint _tmp5_ = 0U;
		gdouble h;
		gdouble _tmp6_;
		gdouble _tmp7_;
		gdouble distance;
		gdouble _tmp8_;
		gdouble _tmp10_;
		gdouble _tmp13_;
		gdouble _tmp14_;
		speed = 5.0;
		_tmp2_ = timestep;
		_tmp3_ = speed;
		delta = _tmp2_ * _tmp3_;
		_tmp4_ = self->priv->entries;
		_tmp5_ = g_list_length (_tmp4_);
		h = (gdouble) _tmp5_;
		_tmp6_ = self->priv->scroll_target_location;
		_tmp7_ = self->priv->scroll_location;
		distance = _tmp6_ - _tmp7_;
		_tmp8_ = self->priv->scroll_direction;
		if (_tmp8_ < 0.0) {
			gdouble _tmp9_;
			_tmp9_ = distance;
			distance = -_tmp9_;
		}
		_tmp10_ = distance;
		if (_tmp10_ < ((gdouble) 0)) {
			gdouble _tmp11_;
			gdouble _tmp12_;
			_tmp11_ = distance;
			_tmp12_ = h;
			distance = _tmp11_ + _tmp12_;
		}
		_tmp13_ = distance;
		_tmp14_ = delta;
		if (_tmp13_ <= _tmp14_) {
			gdouble _tmp15_;
			_tmp15_ = self->priv->scroll_target_location;
			self->priv->scroll_location = _tmp15_;
		} else {
			gdouble _tmp16_;
			gdouble _tmp17_;
			gdouble _tmp18_;
			gdouble _tmp19_;
			gdouble _tmp20_;
			gdouble _tmp23_;
			_tmp16_ = self->priv->scroll_location;
			_tmp17_ = delta;
			_tmp18_ = self->priv->scroll_direction;
			self->priv->scroll_location = _tmp16_ + (_tmp17_ * _tmp18_);
			_tmp19_ = self->priv->scroll_location;
			_tmp20_ = h;
			if (_tmp19_ > _tmp20_) {
				gdouble _tmp21_;
				gdouble _tmp22_;
				_tmp21_ = self->priv->scroll_location;
				_tmp22_ = h;
				self->priv->scroll_location = _tmp21_ - _tmp22_;
			}
			_tmp23_ = self->priv->scroll_location;
			if (_tmp23_ < ((gdouble) 0)) {
				gdouble _tmp24_;
				gdouble _tmp25_;
				_tmp24_ = self->priv->scroll_location;
				_tmp25_ = h;
				self->priv->scroll_location = _tmp24_ + _tmp25_;
			}
		}
		gtk_widget_queue_draw ((GtkWidget*) self);
	}
	_tmp26_ = self->priv->scroll_location;
	_tmp27_ = self->priv->scroll_target_location;
	if (_tmp26_ == _tmp27_) {
		AnimateTimer* _tmp28_;
		g_debug ("user-list.vala:892: Stop scroll animation");
		_tmp28_ = self->priv->scroll_timer;
		animate_timer_stop (_tmp28_);
	}
}


static gpointer _background_ref0 (gpointer self) {
	return self ? background_ref (self) : NULL;
}


static void user_list_background_animate_cb (UserList* self, gdouble timestep) {
	gdouble speed;
	gdouble _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	g_return_if_fail (self != NULL);
	speed = 5.0;
	_tmp0_ = self->priv->background_alpha;
	_tmp1_ = timestep;
	_tmp2_ = speed;
	self->priv->background_alpha = _tmp0_ + (_tmp1_ * _tmp2_);
	_tmp3_ = self->priv->background_alpha;
	if (_tmp3_ > 1.0) {
		self->priv->background_alpha = 1.0;
	}
	gtk_widget_queue_draw ((GtkWidget*) self);
	_tmp4_ = self->priv->background_alpha;
	if (_tmp4_ == 1.0) {
		Background* _tmp5_;
		Background* _tmp6_;
		AnimateTimer* _tmp7_;
		g_debug ("user-list.vala:910: Stop background animation");
		_tmp5_ = self->priv->background;
		_tmp6_ = _background_ref0 (_tmp5_);
		_background_unref0 (self->priv->old_background);
		self->priv->old_background = _tmp6_;
		_tmp7_ = self->priv->background_timer;
		animate_timer_stop (_tmp7_);
	}
}


static gboolean user_list_change_background_timeout_cb (UserList* self) {
	gboolean result = FALSE;
	Background* new_background = NULL;
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	Background* _tmp7_;
	Background* _tmp8_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->high_contrast_item;
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		Background* _tmp3_ = NULL;
		_tmp3_ = user_list_make_background (self, default_background);
		_background_unref0 (new_background);
		new_background = _tmp3_;
	} else {
		UserEntry* _tmp4_;
		const gchar* _tmp5_;
		Background* _tmp6_ = NULL;
		_tmp4_ = self->priv->selected_entry;
		_tmp5_ = _tmp4_->background;
		_tmp6_ = user_list_make_background (self, _tmp5_);
		_background_unref0 (new_background);
		new_background = _tmp6_;
	}
	_tmp7_ = self->priv->background;
	_tmp8_ = new_background;
	if (_tmp7_ != _tmp8_) {
		gint _tmp9_;
		Background* _tmp10_;
		Background* _tmp11_;
		Background* _tmp12_;
		Background* _tmp13_;
		g_debug ("user-list.vala:926: Change background");
		_tmp9_ = self->priv->frame_count;
		if (_tmp9_ > 0) {
			self->priv->background_alpha = 0.0;
		}
		_tmp10_ = self->priv->background;
		_tmp11_ = _background_ref0 (_tmp10_);
		_background_unref0 (self->priv->old_background);
		self->priv->old_background = _tmp11_;
		_tmp12_ = new_background;
		_tmp13_ = _background_ref0 (_tmp12_);
		_background_unref0 (self->priv->background);
		self->priv->background = _tmp13_;
		gtk_widget_queue_draw ((GtkWidget*) self);
	}
	self->priv->change_background_timeout = (guint) 0;
	result = FALSE;
	_background_unref0 (new_background);
	return result;
}


static gboolean _user_list_change_background_timeout_cb_gsource_func (gpointer self) {
	gboolean result;
	result = user_list_change_background_timeout_cb (self);
	return result;
}


static void user_list_change_background (UserList* self) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->frame_count;
	if (_tmp0_ > 0) {
		guint _tmp1_;
		guint _tmp3_ = 0U;
		_tmp1_ = self->priv->change_background_timeout;
		if (_tmp1_ != ((guint) 0)) {
			guint _tmp2_;
			_tmp2_ = self->priv->change_background_timeout;
			g_source_remove (_tmp2_);
		}
		_tmp3_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 200, _user_list_change_background_timeout_cb_gsource_func, g_object_ref (self), g_object_unref);
		self->priv->change_background_timeout = _tmp3_;
	} else {
		user_list_change_background_timeout_cb (self);
	}
}


static void user_list_select_entry (UserList* self, UserEntry* entry, gdouble direction) {
	UserEntry* _tmp0_;
	UserEntry* _tmp1_;
	GList* _tmp11_;
	UserEntry* _tmp12_;
	gint _tmp13_ = 0;
	gdouble _tmp14_;
	gint _tmp15_;
	gboolean _tmp17_ = FALSE;
	gdouble _tmp18_;
	gdouble _tmp19_;
	gboolean _tmp23_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	_tmp0_ = self->priv->selected_entry;
	_tmp1_ = entry;
	if (_tmp0_ != _tmp1_) {
		UserEntry* _tmp2_;
		UserEntry* _tmp3_;
		GtkEntry* _tmp4_;
		GtkButton* _tmp5_;
		gboolean _tmp6_ = FALSE;
		_tmp2_ = entry;
		_tmp3_ = _user_entry_ref0 (_tmp2_);
		_user_entry_unref0 (self->priv->selected_entry);
		self->priv->selected_entry = _tmp3_;
		_tmp4_ = self->priv->prompt_entry;
		gtk_widget_hide ((GtkWidget*) _tmp4_);
		_tmp5_ = self->priv->login_button;
		gtk_widget_hide ((GtkWidget*) _tmp5_);
		_tmp6_ = gtk_widget_get_realized ((GtkWidget*) self);
		if (_tmp6_) {
			UserEntry* _tmp7_;
			const gchar* _tmp8_;
			UserEntry* _tmp9_;
			const gchar* _tmp10_;
			_tmp7_ = entry;
			_tmp8_ = _tmp7_->name;
			g_debug ("user-list.vala:963: Select %s", _tmp8_);
			user_list_change_background (self);
			_tmp9_ = self->priv->selected_entry;
			_tmp10_ = _tmp9_->name;
			g_signal_emit_by_name (self, "user-selected", _tmp10_);
		}
	}
	_tmp11_ = self->priv->entries;
	_tmp12_ = self->priv->selected_entry;
	_tmp13_ = g_list_index (_tmp11_, _tmp12_);
	self->priv->scroll_target_location = (gdouble) _tmp13_;
	_tmp14_ = direction;
	self->priv->scroll_direction = _tmp14_;
	_tmp15_ = self->priv->frame_count;
	if (_tmp15_ == 0) {
		gdouble _tmp16_;
		_tmp16_ = self->priv->scroll_target_location;
		self->priv->scroll_location = _tmp16_;
	}
	_tmp18_ = self->priv->scroll_location;
	_tmp19_ = self->priv->scroll_target_location;
	if (_tmp18_ != _tmp19_) {
		AnimateTimer* _tmp20_;
		gboolean _tmp21_;
		gboolean _tmp22_;
		_tmp20_ = self->priv->scroll_timer;
		_tmp21_ = animate_timer_get_is_running (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp17_ = !_tmp22_;
	} else {
		_tmp17_ = FALSE;
	}
	_tmp23_ = _tmp17_;
	if (_tmp23_) {
		AnimateTimer* _tmp24_;
		g_debug ("user-list.vala:977: Start scroll animation");
		_tmp24_ = self->priv->scroll_timer;
		animate_timer_reset (_tmp24_);
	}
}


static void user_list_select_prev_entry (UserList* self) {
	GList* _tmp0_;
	UserEntry* _tmp1_;
	gint _tmp2_ = 0;
	gint index;
	gint _tmp3_;
	GList* _tmp7_;
	gint _tmp8_;
	gconstpointer _tmp9_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->entries;
	_tmp1_ = self->priv->selected_entry;
	_tmp2_ = g_list_index (_tmp0_, _tmp1_);
	index = _tmp2_ - 1;
	_tmp3_ = index;
	if (_tmp3_ < 0) {
		gint _tmp4_;
		GList* _tmp5_;
		guint _tmp6_ = 0U;
		_tmp4_ = index;
		_tmp5_ = self->priv->entries;
		_tmp6_ = g_list_length (_tmp5_);
		index = _tmp4_ + ((gint) _tmp6_);
	}
	_tmp7_ = self->priv->entries;
	_tmp8_ = index;
	_tmp9_ = g_list_nth_data (_tmp7_, (guint) _tmp8_);
	user_list_select_entry (self, (UserEntry*) _tmp9_, -1.0);
}


static void user_list_select_next_entry (UserList* self) {
	GList* _tmp0_;
	UserEntry* _tmp1_;
	gint _tmp2_ = 0;
	gint index;
	gint _tmp3_;
	GList* _tmp4_;
	guint _tmp5_ = 0U;
	GList* _tmp9_;
	gint _tmp10_;
	gconstpointer _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->entries;
	_tmp1_ = self->priv->selected_entry;
	_tmp2_ = g_list_index (_tmp0_, _tmp1_);
	index = _tmp2_ + 1;
	_tmp3_ = index;
	_tmp4_ = self->priv->entries;
	_tmp5_ = g_list_length (_tmp4_);
	if (_tmp3_ >= ((gint) _tmp5_)) {
		gint _tmp6_;
		GList* _tmp7_;
		guint _tmp8_ = 0U;
		_tmp6_ = index;
		_tmp7_ = self->priv->entries;
		_tmp8_ = g_list_length (_tmp7_);
		index = _tmp6_ - ((gint) _tmp8_);
	}
	_tmp9_ = self->priv->entries;
	_tmp10_ = index;
	_tmp11_ = g_list_nth_data (_tmp9_, (guint) _tmp10_);
	user_list_select_entry (self, (UserEntry*) _tmp11_, 1.0);
}


static void user_list_get_selected_location (UserList* self, gint* x, gint* y) {
	gint _vala_x = 0;
	gint _vala_y = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_;
	gint _tmp3_ = 0;
	gint _tmp4_;
	gint _tmp5_;
	gint row;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp1_ = get_grid_offset (_tmp0_);
	_tmp2_ = grid_size;
	_vala_x = _tmp1_ + _tmp2_;
	_tmp3_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp4_ = grid_size;
	_tmp5_ = self->priv->box_height;
	row = ((gint) ((_tmp3_ / _tmp4_) - _tmp5_)) / 2;
	_tmp6_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp7_ = get_grid_offset (_tmp6_);
	_tmp8_ = grid_size;
	_vala_y = _tmp7_ + (row * _tmp8_);
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
}


static void user_list_real_add (GtkContainer* base, GtkWidget* widget) {
	UserList * self;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GtkWidget* _tmp5_;
	self = (UserList*) base;
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	self->priv->children = g_list_append (self->priv->children, _tmp1_);
	_tmp2_ = gtk_widget_get_realized ((GtkWidget*) self);
	if (_tmp2_) {
		GtkWidget* _tmp3_;
		GdkWindow* _tmp4_ = NULL;
		_tmp3_ = widget;
		_tmp4_ = gtk_widget_get_window ((GtkWidget*) self);
		gtk_widget_set_parent_window (_tmp3_, _tmp4_);
	}
	_tmp5_ = widget;
	gtk_widget_set_parent (_tmp5_, (GtkWidget*) self);
}


static void user_list_real_remove (GtkContainer* base, GtkWidget* widget) {
	UserList * self;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	self = (UserList*) base;
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	gtk_widget_unparent (_tmp0_);
	_tmp1_ = widget;
	self->priv->children = g_list_remove (self->priv->children, _tmp1_);
}


static void user_list_real_forall_internal (GtkContainer* base, gboolean include_internal, GtkCallback callback, void* callback_target) {
	UserList * self;
	GList* _tmp0_;
	self = (UserList*) base;
	_tmp0_ = self->priv->children;
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp0_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* _tmp1_;
			GtkWidget* child = NULL;
			_tmp1_ = _g_object_ref0 ((GtkWidget*) child_it->data);
			child = _tmp1_;
			{
				GtkCallback _tmp2_;
				void* _tmp2__target;
				GtkWidget* _tmp3_;
				_tmp2_ = callback;
				_tmp2__target = callback_target;
				_tmp3_ = child;
				_tmp2_ (_tmp3_, _tmp2__target);
				_g_object_unref0 (child);
			}
		}
	}
}


static void user_list_real_realize (GtkWidget* base) {
	UserList * self;
	Background* _tmp0_ = NULL;
	Background* _tmp1_;
	Background* _tmp2_;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp3_ = {0};
	GdkWindowAttr attributes = {0};
	GtkAllocation _tmp4_;
	gint _tmp5_;
	GtkAllocation _tmp6_;
	gint _tmp7_;
	GtkAllocation _tmp8_;
	gint _tmp9_;
	GtkAllocation _tmp10_;
	gint _tmp11_;
	GdkVisual* _tmp12_ = NULL;
	gint attributes_mask;
	GdkWindow* _tmp13_ = NULL;
	GdkWindowAttr _tmp14_;
	gint _tmp15_;
	GdkWindow* _tmp16_;
	GdkWindow* window;
	GdkWindow* _tmp17_;
	GdkWindow* _tmp18_;
	GdkWindow* _tmp19_;
	GList* _tmp20_;
	self = (UserList*) base;
	_tmp0_ = user_list_make_background (self, default_background);
	_background_unref0 (self->priv->old_background);
	self->priv->old_background = _tmp0_;
	_tmp1_ = self->priv->old_background;
	_tmp2_ = _background_ref0 (_tmp1_);
	_background_unref0 (self->priv->background);
	self->priv->background = _tmp2_;
	user_list_change_background (self);
	gtk_widget_set_realized ((GtkWidget*) self, TRUE);
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp3_);
	allocation = _tmp3_;
	memset (&attributes, 0, sizeof (GdkWindowAttr));
	attributes.window_type = GDK_WINDOW_CHILD;
	_tmp4_ = allocation;
	_tmp5_ = _tmp4_.x;
	attributes.x = _tmp5_;
	_tmp6_ = allocation;
	_tmp7_ = _tmp6_.y;
	attributes.y = _tmp7_;
	_tmp8_ = allocation;
	_tmp9_ = _tmp8_.width;
	attributes.width = _tmp9_;
	_tmp10_ = allocation;
	_tmp11_ = _tmp10_.height;
	attributes.height = _tmp11_;
	attributes.wclass = GDK_INPUT_OUTPUT;
	_tmp12_ = gtk_widget_get_visual ((GtkWidget*) self);
	attributes.visual = _tmp12_;
	attributes.event_mask = (gint) (((GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK) | GDK_BUTTON_RELEASE_MASK) | GDK_KEY_PRESS_MASK);
	attributes_mask = (gint) ((GDK_WA_X | GDK_WA_Y) | GDK_WA_VISUAL);
	_tmp13_ = gtk_widget_get_parent_window ((GtkWidget*) self);
	_tmp14_ = attributes;
	_tmp15_ = attributes_mask;
	_tmp16_ = gdk_window_new (_tmp13_, &_tmp14_, _tmp15_);
	window = _tmp16_;
	_tmp17_ = window;
	_tmp18_ = _g_object_ref0 (_tmp17_);
	gtk_widget_set_window ((GtkWidget*) self, _tmp18_);
	_tmp19_ = window;
	gdk_window_set_user_data (_tmp19_, self);
	_tmp20_ = self->priv->children;
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp20_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* _tmp21_;
			GtkWidget* child = NULL;
			_tmp21_ = _g_object_ref0 ((GtkWidget*) child_it->data);
			child = _tmp21_;
			{
				GtkWidget* _tmp22_;
				GdkWindow* _tmp23_ = NULL;
				_tmp22_ = child;
				_tmp23_ = gtk_widget_get_window ((GtkWidget*) self);
				gtk_widget_set_parent_window (_tmp22_, _tmp23_);
				_g_object_unref0 (child);
			}
		}
	}
	_g_object_unref0 (window);
}


static void user_list_real_map (GtkWidget* base) {
	UserList * self;
	GList* _tmp0_;
	GdkWindow* _tmp10_ = NULL;
	self = (UserList*) base;
	gtk_widget_set_mapped ((GtkWidget*) self, TRUE);
	_tmp0_ = self->priv->children;
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp0_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* _tmp1_;
			GtkWidget* child = NULL;
			_tmp1_ = _g_object_ref0 ((GtkWidget*) child_it->data);
			child = _tmp1_;
			{
				gboolean _tmp2_ = FALSE;
				GtkWidget* _tmp3_;
				gboolean _tmp4_;
				gboolean _tmp5_;
				gboolean _tmp8_;
				_tmp3_ = child;
				_tmp4_ = gtk_widget_get_visible (_tmp3_);
				_tmp5_ = _tmp4_;
				if (_tmp5_) {
					GtkWidget* _tmp6_;
					gboolean _tmp7_ = FALSE;
					_tmp6_ = child;
					_tmp7_ = gtk_widget_get_mapped (_tmp6_);
					_tmp2_ = !_tmp7_;
				} else {
					_tmp2_ = FALSE;
				}
				_tmp8_ = _tmp2_;
				if (_tmp8_) {
					GtkWidget* _tmp9_;
					_tmp9_ = child;
					gtk_widget_map (_tmp9_);
				}
				_g_object_unref0 (child);
			}
		}
	}
	_tmp10_ = gtk_widget_get_window ((GtkWidget*) self);
	gdk_window_show (_tmp10_);
}


static void user_list_real_size_allocate (GtkWidget* base, GtkAllocation* allocation) {
	UserList * self;
	gboolean _tmp0_ = FALSE;
	GtkAllocation _tmp1_;
	gint _tmp2_;
	gint _tmp3_ = 0;
	gboolean _tmp7_;
	gboolean resized;
	GtkAllocation _tmp8_;
	gboolean _tmp9_ = FALSE;
	GdkWindow* _tmp10_ = NULL;
	GtkAllocation _tmp11_;
	gint _tmp12_;
	GtkAllocation _tmp13_;
	gint _tmp14_;
	GtkAllocation _tmp15_;
	gint _tmp16_;
	GtkAllocation _tmp17_;
	gint _tmp18_;
	gboolean _tmp19_;
	GtkRequisition natural_size = {0};
	GtkMenuBar* _tmp22_;
	GtkRequisition _tmp23_ = {0};
	GtkAllocation child_allocation = {0};
	gint _tmp24_ = 0;
	GtkRequisition _tmp25_;
	gint _tmp26_;
	GtkRequisition _tmp27_;
	gint _tmp28_;
	GtkMenuBar* _tmp29_;
	GtkAllocation _tmp30_;
	gint base_x = 0;
	gint base_y = 0;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	gint _tmp33_;
	gint _tmp34_;
	gint _tmp35_;
	gint _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	gint _tmp39_;
	gint _tmp40_;
	GtkEntry* _tmp41_;
	GtkAllocation _tmp42_;
	GtkButton* _tmp43_;
	GtkAllocation _tmp44_;
	gint _tmp45_;
	gint _tmp46_;
	gint _tmp47_;
	gint _tmp48_;
	gint _tmp49_;
	gint _tmp50_;
	gint _tmp51_;
	gint _tmp52_;
	gint _tmp53_;
	GtkButton* _tmp54_;
	GtkAllocation _tmp55_;
	GtkButton* _tmp56_;
	gboolean _tmp57_;
	self = (UserList*) base;
	g_return_if_fail (allocation != NULL);
	_tmp1_ = *allocation;
	_tmp2_ = _tmp1_.height;
	_tmp3_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	if (_tmp2_ != _tmp3_) {
		_tmp0_ = TRUE;
	} else {
		GtkAllocation _tmp4_;
		gint _tmp5_;
		gint _tmp6_ = 0;
		_tmp4_ = *allocation;
		_tmp5_ = _tmp4_.width;
		_tmp6_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
		_tmp0_ = _tmp5_ != _tmp6_;
	}
	_tmp7_ = _tmp0_;
	resized = _tmp7_;
	_tmp8_ = *allocation;
	gtk_widget_set_allocation ((GtkWidget*) self, &_tmp8_);
	_tmp9_ = gtk_widget_get_realized ((GtkWidget*) self);
	if (!_tmp9_) {
		return;
	}
	_tmp10_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp11_ = *allocation;
	_tmp12_ = _tmp11_.x;
	_tmp13_ = *allocation;
	_tmp14_ = _tmp13_.y;
	_tmp15_ = *allocation;
	_tmp16_ = _tmp15_.width;
	_tmp17_ = *allocation;
	_tmp18_ = _tmp17_.height;
	gdk_window_move_resize (_tmp10_, _tmp12_, _tmp14_, _tmp16_, _tmp18_);
	_tmp19_ = resized;
	if (_tmp19_) {
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		_tmp20_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
		_tmp21_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
		g_debug ("user-list.vala:1076: Resized to %dx%d", _tmp20_, _tmp21_);
	}
	_tmp22_ = self->priv->menubar;
	gtk_widget_get_preferred_size ((GtkWidget*) _tmp22_, NULL, &_tmp23_);
	natural_size = _tmp23_;
	memset (&child_allocation, 0, sizeof (GtkAllocation));
	natural_size.height = 32;
	_tmp24_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	natural_size.width = _tmp24_;
	child_allocation.x = 0;
	child_allocation.y = 0;
	_tmp25_ = natural_size;
	_tmp26_ = _tmp25_.width;
	child_allocation.width = _tmp26_;
	_tmp27_ = natural_size;
	_tmp28_ = _tmp27_.height;
	child_allocation.height = _tmp28_;
	_tmp29_ = self->priv->menubar;
	_tmp30_ = child_allocation;
	gtk_widget_size_allocate ((GtkWidget*) _tmp29_, &_tmp30_);
	user_list_get_selected_location (self, &_tmp31_, &_tmp32_);
	base_x = _tmp31_;
	base_y = _tmp32_;
	_tmp33_ = base_x;
	_tmp34_ = grid_size;
	child_allocation.x = _tmp33_ + (_tmp34_ / 2);
	_tmp35_ = base_y;
	_tmp36_ = grid_size;
	_tmp37_ = grid_size;
	child_allocation.y = (_tmp35_ + (_tmp36_ * 2)) - (_tmp37_ / 2);
	_tmp38_ = grid_size;
	_tmp39_ = self->priv->box_width;
	child_allocation.width = _tmp38_ * (_tmp39_ - 1);
	_tmp40_ = grid_size;
	child_allocation.height = _tmp40_;
	_tmp41_ = self->priv->prompt_entry;
	_tmp42_ = child_allocation;
	gtk_widget_size_allocate ((GtkWidget*) _tmp41_, &_tmp42_);
	_tmp43_ = self->priv->login_button;
	_tmp44_ = child_allocation;
	gtk_widget_size_allocate ((GtkWidget*) _tmp43_, &_tmp44_);
	_tmp45_ = base_x;
	_tmp46_ = self->priv->box_width;
	_tmp47_ = grid_size;
	_tmp48_ = grid_size;
	_tmp49_ = grid_size;
	child_allocation.x = ((_tmp45_ + (_tmp46_ * _tmp47_)) - _tmp48_) - (_tmp49_ / 4);
	_tmp50_ = base_y;
	_tmp51_ = grid_size;
	child_allocation.y = _tmp50_ + (_tmp51_ / 4);
	_tmp52_ = grid_size;
	child_allocation.width = _tmp52_;
	_tmp53_ = grid_size;
	child_allocation.height = _tmp53_;
	_tmp54_ = self->priv->options_button;
	_tmp55_ = child_allocation;
	gtk_widget_size_allocate ((GtkWidget*) _tmp54_, &_tmp55_);
	_tmp56_ = self->priv->options_button;
	gtk_widget_show ((GtkWidget*) _tmp56_);
	_tmp57_ = resized;
	if (_tmp57_) {
		GHashTable* _tmp58_;
		g_debug ("user-list.vala:1109: Regenerating backgrounds");
		_tmp58_ = self->priv->backgrounds;
		g_hash_table_remove_all (_tmp58_);
		user_list_change_background (self);
	}
}


static void user_list_draw_entry (UserList* self, cairo_t* c, UserEntry* entry, gdouble alpha) {
	cairo_t* _tmp0_;
	GtkCheckMenuItem* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	UserEntry* _tmp4_;
	gboolean _tmp5_;
	gint _tmp14_;
	gint _tmp15_;
	cairo_pattern_t* _tmp16_;
	cairo_pattern_t* mask;
	gdouble left;
	gdouble _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	cairo_t* _tmp20_;
	gint w = 0;
	gint h = 0;
	UserEntry* _tmp21_;
	PangoLayout* _tmp22_;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	cairo_t* _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	cairo_t* _tmp29_;
	cairo_t* _tmp30_;
	UserEntry* _tmp31_;
	PangoLayout* _tmp32_;
	cairo_t* _tmp33_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	g_return_if_fail (entry != NULL);
	_tmp0_ = c;
	cairo_save (_tmp0_);
	_tmp1_ = self->priv->high_contrast_item;
	_tmp2_ = gtk_check_menu_item_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		alpha = 1.0;
	}
	_tmp4_ = entry;
	_tmp5_ = _tmp4_->is_active;
	if (_tmp5_) {
		cairo_t* _tmp6_;
		gint _tmp7_;
		cairo_t* _tmp8_;
		cairo_t* _tmp9_;
		cairo_t* _tmp10_;
		cairo_t* _tmp11_;
		gdouble _tmp12_;
		cairo_t* _tmp13_;
		_tmp6_ = c;
		_tmp7_ = grid_size;
		cairo_move_to (_tmp6_, (gdouble) 8, ((_tmp7_ / 2) + 0.5) - 4);
		_tmp8_ = c;
		cairo_rel_line_to (_tmp8_, (gdouble) 5, (gdouble) 4);
		_tmp9_ = c;
		cairo_rel_line_to (_tmp9_, (gdouble) (-5), (gdouble) 4);
		_tmp10_ = c;
		cairo_close_path (_tmp10_);
		_tmp11_ = c;
		_tmp12_ = alpha;
		cairo_set_source_rgba (_tmp11_, 1.0, 1.0, 1.0, _tmp12_);
		_tmp13_ = c;
		cairo_fill (_tmp13_);
	}
	_tmp14_ = grid_size;
	_tmp15_ = self->priv->box_width;
	_tmp16_ = cairo_pattern_create_linear ((gdouble) 0, (gdouble) 0, (gdouble) (_tmp14_ * _tmp15_), (gdouble) 0);
	mask = _tmp16_;
	left = 1.0 - (2.0 / 7);
	_tmp17_ = alpha;
	cairo_pattern_add_color_stop_rgba (mask, left, 1.0, 1.0, 1.0, _tmp17_);
	_tmp18_ = grid_size;
	_tmp19_ = self->priv->box_width;
	cairo_pattern_add_color_stop_rgba (mask, left + (64.0 / (_tmp18_ * _tmp19_)), 1.0, 1.0, 1.0, 0.0);
	_tmp20_ = c;
	cairo_set_source (_tmp20_, mask);
	_tmp21_ = entry;
	_tmp22_ = _tmp21_->layout;
	pango_layout_get_pixel_size (_tmp22_, &_tmp23_, &_tmp24_);
	w = _tmp23_;
	h = _tmp24_;
	_tmp25_ = c;
	_tmp26_ = grid_size;
	_tmp27_ = grid_size;
	_tmp28_ = grid_size;
	cairo_translate (_tmp25_, (gdouble) (_tmp26_ / 2), (gdouble) ((_tmp27_ - ((_tmp28_ - h) / 2)) - h));
	_tmp29_ = c;
	cairo_move_to (_tmp29_, (gdouble) 0, (gdouble) 0);
	_tmp30_ = c;
	_tmp31_ = entry;
	_tmp32_ = _tmp31_->layout;
	pango_cairo_show_layout (_tmp30_, _tmp32_);
	_tmp33_ = c;
	cairo_restore (_tmp33_);
	_cairo_pattern_destroy0 (mask);
}


static void user_list_background_loaded_cb (UserList* self, Background* b) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	user_list_change_background (self);
	gtk_widget_queue_draw ((GtkWidget*) self);
}


static void _user_list_background_loaded_cb_background_loaded (Background* _sender, gpointer self) {
	user_list_background_loaded_cb (self, _sender);
}


static Background* user_list_make_background (UserList* self, const gchar* filename) {
	Background* result = NULL;
	GHashTable* _tmp0_;
	const gchar* _tmp1_;
	gconstpointer _tmp2_ = NULL;
	Background* _tmp3_;
	Background* b;
	Background* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	_tmp0_ = self->priv->backgrounds;
	_tmp1_ = filename;
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
	_tmp3_ = _background_ref0 ((Background*) _tmp2_);
	b = _tmp3_;
	_tmp4_ = b;
	if (_tmp4_ == NULL) {
		const gchar* _tmp5_;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		Background* _tmp8_;
		Background* _tmp9_;
		GHashTable* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		Background* _tmp13_;
		Background* _tmp14_;
		_tmp5_ = filename;
		_tmp6_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
		_tmp7_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
		_tmp8_ = background_new (_tmp5_, _tmp6_, _tmp7_);
		_background_unref0 (b);
		b = _tmp8_;
		_tmp9_ = b;
		g_signal_connect_object (_tmp9_, "loaded", (GCallback) _user_list_background_loaded_cb_background_loaded, self, 0);
		_tmp10_ = self->priv->backgrounds;
		_tmp11_ = filename;
		_tmp12_ = g_strdup (_tmp11_);
		_tmp13_ = b;
		_tmp14_ = _background_ref0 (_tmp13_);
		g_hash_table_insert (_tmp10_, _tmp12_, _tmp14_);
	}
	result = b;
	return result;
}


Background* user_list_get_background (UserList* self) {
	Background* result = NULL;
	UserEntry* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->selected_entry;
	if (_tmp0_ != NULL) {
		UserEntry* _tmp1_;
		const gchar* _tmp2_;
		Background* _tmp3_ = NULL;
		_tmp1_ = self->priv->selected_entry;
		_tmp2_ = _tmp1_->background;
		_tmp3_ = user_list_make_background (self, _tmp2_);
		result = _tmp3_;
		return result;
	} else {
		Background* _tmp4_ = NULL;
		_tmp4_ = user_list_make_background (self, default_background);
		result = _tmp4_;
		return result;
	}
}


static void user_list_draw_background (UserList* self, cairo_t* c) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Background* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp6_;
	gboolean _tmp10_;
	cairo_t* _tmp12_;
	gdouble _tmp13_;
	gboolean _tmp20_ = FALSE;
	Background* _tmp21_;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp24_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	_tmp2_ = self->priv->background;
	_tmp3_ = background_load (_tmp2_);
	if (_tmp3_) {
		Background* _tmp4_;
		Background* _tmp5_;
		_tmp4_ = self->priv->background;
		_tmp5_ = self->priv->old_background;
		_tmp1_ = _tmp4_ != _tmp5_;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp6_ = _tmp1_;
	if (_tmp6_) {
		AnimateTimer* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp7_ = self->priv->background_timer;
		_tmp8_ = animate_timer_get_is_running (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp0_ = !_tmp9_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp10_ = _tmp0_;
	if (_tmp10_) {
		AnimateTimer* _tmp11_;
		g_debug ("user-list.vala:1179: Start background animation");
		_tmp11_ = self->priv->background_timer;
		animate_timer_reset (_tmp11_);
	}
	_tmp12_ = c;
	cairo_set_source_rgb (_tmp12_, (gdouble) 0x2C, (gdouble) 0x00, (gdouble) 0x1E);
	_tmp13_ = self->priv->background_alpha;
	if (_tmp13_ < 1.0) {
		Background* _tmp14_;
		gboolean _tmp15_ = FALSE;
		cairo_t* _tmp19_;
		_tmp14_ = self->priv->old_background;
		_tmp15_ = background_load (_tmp14_);
		if (_tmp15_) {
			cairo_t* _tmp16_;
			Background* _tmp17_;
			cairo_pattern_t* _tmp18_;
			_tmp16_ = c;
			_tmp17_ = self->priv->old_background;
			_tmp18_ = _tmp17_->pattern;
			cairo_set_source (_tmp16_, _tmp18_);
		}
		_tmp19_ = c;
		cairo_paint (_tmp19_);
	}
	_tmp21_ = self->priv->background;
	_tmp22_ = background_load (_tmp21_);
	if (_tmp22_) {
		gdouble _tmp23_;
		_tmp23_ = self->priv->background_alpha;
		_tmp20_ = _tmp23_ > 0.0;
	} else {
		_tmp20_ = FALSE;
	}
	_tmp24_ = _tmp20_;
	if (_tmp24_) {
		cairo_t* _tmp25_;
		Background* _tmp26_;
		cairo_pattern_t* _tmp27_;
		cairo_t* _tmp28_;
		gdouble _tmp29_;
		_tmp25_ = c;
		_tmp26_ = self->priv->background;
		_tmp27_ = _tmp26_->pattern;
		cairo_set_source (_tmp25_, _tmp27_);
		_tmp28_ = c;
		_tmp29_ = self->priv->background_alpha;
		cairo_paint_with_alpha (_tmp28_, _tmp29_);
	}
}


static gboolean user_list_draw_expire_cb (UserList* self) {
	gboolean result = FALSE;
	GTimer* _tmp0_;
	gdouble _tmp1_ = 0.0;
	gdouble elapsed;
	gint _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->draw_timer;
	_tmp1_ = g_timer_elapsed (_tmp0_, NULL);
	elapsed = _tmp1_;
	_tmp2_ = self->priv->draw_count;
	_tmp3_ = self->priv->draw_count;
	g_debug ("user-list.vala:1204: Drew %d frames in %.1f seconds (%f fps)", _tmp2_, elapsed, _tmp3_ / elapsed);
	_g_timer_destroy0 (self->priv->draw_timer);
	self->priv->draw_timer = NULL;
	self->priv->draw_count = 0;
	self->priv->draw_timeout = (guint) 0;
	result = FALSE;
	return result;
}


static gboolean _user_list_draw_expire_cb_gsource_func (gpointer self) {
	gboolean result;
	result = user_list_draw_expire_cb (self);
	return result;
}


static gboolean user_list_real_draw (GtkWidget* base, cairo_t* c) {
	UserList * self;
	gboolean result = FALSE;
	gint _tmp0_;
	guint _tmp1_;
	GTimer* _tmp3_;
	guint _tmp5_ = 0U;
	gint _tmp6_;
	gint _tmp7_;
	cairo_t* _tmp8_;
	cairo_t* _tmp9_;
	gint base_x = 0;
	gint base_y = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	cairo_t* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gint index;
	GList* _tmp15_;
	cairo_t* _tmp94_;
	gint border;
	cairo_t* _tmp95_;
	gint _tmp96_;
	gint _tmp97_;
	cairo_t* _tmp98_;
	cairo_pattern_t* _tmp99_;
	cairo_t* _tmp100_;
	cairo_t* _tmp101_;
	UserEntry* _tmp102_;
	gboolean _tmp143_ = FALSE;
	const gchar* _tmp144_;
	gboolean _tmp146_;
	cairo_t* _tmp169_;
	GList* _tmp170_;
	self = (UserList*) base;
	g_return_val_if_fail (c != NULL, FALSE);
	_tmp0_ = self->priv->frame_count;
	if (_tmp0_ == 0) {
		g_debug ("user-list.vala:1216: Rendered first frame");
	}
	_tmp1_ = self->priv->draw_timeout;
	if (_tmp1_ != ((guint) 0)) {
		guint _tmp2_;
		_tmp2_ = self->priv->draw_timeout;
		g_source_remove (_tmp2_);
	}
	_tmp3_ = self->priv->draw_timer;
	if (_tmp3_ == NULL) {
		GTimer* _tmp4_;
		_tmp4_ = g_timer_new ();
		_g_timer_destroy0 (self->priv->draw_timer);
		self->priv->draw_timer = _tmp4_;
	}
	_tmp5_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, _user_list_draw_expire_cb_gsource_func, g_object_ref (self), g_object_unref);
	self->priv->draw_timeout = _tmp5_;
	_tmp6_ = self->priv->draw_count;
	self->priv->draw_count = _tmp6_ + 1;
	_tmp7_ = self->priv->frame_count;
	self->priv->frame_count = _tmp7_ + 1;
	_tmp8_ = c;
	user_list_draw_background (self, _tmp8_);
	_tmp9_ = c;
	cairo_save (_tmp9_);
	user_list_get_selected_location (self, &_tmp10_, &_tmp11_);
	base_x = _tmp10_;
	base_y = _tmp11_;
	_tmp12_ = c;
	_tmp13_ = base_x;
	_tmp14_ = base_y;
	cairo_translate (_tmp12_, (gdouble) _tmp13_, (gdouble) _tmp14_);
	index = 0;
	_tmp15_ = self->priv->entries;
	{
		GList* entry_collection = NULL;
		GList* entry_it = NULL;
		entry_collection = _tmp15_;
		for (entry_it = entry_collection; entry_it != NULL; entry_it = entry_it->next) {
			UserEntry* _tmp16_;
			UserEntry* entry = NULL;
			_tmp16_ = _user_entry_ref0 ((UserEntry*) entry_it->data);
			entry = _tmp16_;
			{
				guint _tmp17_;
				guint _tmp18_;
				gint _tmp19_;
				gdouble h_above;
				cairo_t* _tmp20_;
				cairo_t* _tmp21_;
				gdouble _tmp22_;
				gint _tmp23_;
				gint _tmp24_;
				gdouble _tmp25_;
				cairo_t* _tmp26_;
				cairo_t* _tmp27_;
				gint _tmp28_;
				gint _tmp29_;
				gdouble _tmp30_;
				gint _tmp31_;
				gdouble _tmp32_;
				gint _tmp33_;
				guint _tmp34_;
				guint _tmp35_;
				gdouble alpha;
				cairo_t* _tmp36_;
				UserEntry* _tmp37_;
				gdouble _tmp38_;
				cairo_t* _tmp39_;
				GList* _tmp40_;
				guint _tmp41_ = 0U;
				gint _tmp42_;
				gdouble _tmp43_;
				gint _tmp44_;
				GList* _tmp45_;
				guint _tmp46_ = 0U;
				guint _tmp47_;
				guint _tmp48_;
				cairo_t* _tmp49_;
				UserEntry* _tmp50_;
				gdouble _tmp51_;
				cairo_t* _tmp52_;
				guint _tmp53_;
				guint _tmp54_;
				gint _tmp55_;
				gdouble h_below;
				cairo_t* _tmp56_;
				cairo_t* _tmp57_;
				gint _tmp58_;
				gint _tmp59_;
				gint _tmp60_;
				gint _tmp61_;
				gdouble _tmp62_;
				cairo_t* _tmp63_;
				cairo_t* _tmp64_;
				gint _tmp65_;
				gint _tmp66_;
				gdouble _tmp67_;
				gint _tmp68_;
				cairo_t* _tmp69_;
				gint _tmp70_;
				gint _tmp71_;
				gint _tmp72_;
				gdouble _tmp73_;
				guint _tmp74_;
				guint _tmp75_;
				cairo_t* _tmp76_;
				UserEntry* _tmp77_;
				gdouble _tmp78_;
				cairo_t* _tmp79_;
				GList* _tmp80_;
				guint _tmp81_ = 0U;
				gint _tmp82_;
				gint _tmp83_;
				GList* _tmp84_;
				guint _tmp85_ = 0U;
				gdouble _tmp86_;
				guint _tmp87_;
				guint _tmp88_;
				cairo_t* _tmp89_;
				UserEntry* _tmp90_;
				gdouble _tmp91_;
				cairo_t* _tmp92_;
				gint _tmp93_;
				_tmp17_ = user_list_get_n_above (self);
				_tmp18_ = _tmp17_;
				_tmp19_ = grid_size;
				h_above = ((gdouble) (_tmp18_ + 1)) * _tmp19_;
				_tmp20_ = c;
				cairo_save (_tmp20_);
				_tmp21_ = c;
				_tmp22_ = h_above;
				_tmp23_ = self->priv->box_width;
				_tmp24_ = grid_size;
				_tmp25_ = h_above;
				cairo_rectangle (_tmp21_, (gdouble) 0, -_tmp22_, (gdouble) (_tmp23_ * _tmp24_), _tmp25_);
				_tmp26_ = c;
				cairo_clip (_tmp26_);
				_tmp27_ = c;
				_tmp28_ = index;
				_tmp29_ = grid_size;
				_tmp30_ = self->priv->scroll_location;
				_tmp31_ = grid_size;
				cairo_translate (_tmp27_, (gdouble) 0, (_tmp28_ * _tmp29_) - (_tmp30_ * _tmp31_));
				_tmp32_ = self->priv->scroll_location;
				_tmp33_ = index;
				_tmp34_ = user_list_get_n_above (self);
				_tmp35_ = _tmp34_;
				alpha = 1.0 - ((_tmp32_ - _tmp33_) / (_tmp35_ + 1));
				_tmp36_ = c;
				_tmp37_ = entry;
				_tmp38_ = alpha;
				user_list_draw_entry (self, _tmp36_, _tmp37_, _tmp38_);
				_tmp39_ = c;
				_tmp40_ = self->priv->entries;
				_tmp41_ = g_list_length (_tmp40_);
				_tmp42_ = grid_size;
				cairo_translate (_tmp39_, (gdouble) 0, (gdouble) ((-_tmp41_) * _tmp42_));
				_tmp43_ = self->priv->scroll_location;
				_tmp44_ = index;
				_tmp45_ = self->priv->entries;
				_tmp46_ = g_list_length (_tmp45_);
				_tmp47_ = user_list_get_n_above (self);
				_tmp48_ = _tmp47_;
				alpha = 1.0 - ((_tmp43_ - (_tmp44_ - ((gint) _tmp46_))) / (_tmp48_ + 1));
				_tmp49_ = c;
				_tmp50_ = entry;
				_tmp51_ = alpha;
				user_list_draw_entry (self, _tmp49_, _tmp50_, _tmp51_);
				_tmp52_ = c;
				cairo_restore (_tmp52_);
				_tmp53_ = user_list_get_n_below (self);
				_tmp54_ = _tmp53_;
				_tmp55_ = grid_size;
				h_below = ((gdouble) (_tmp54_ + 1)) * _tmp55_;
				_tmp56_ = c;
				cairo_save (_tmp56_);
				_tmp57_ = c;
				_tmp58_ = self->priv->box_height;
				_tmp59_ = grid_size;
				_tmp60_ = self->priv->box_width;
				_tmp61_ = grid_size;
				_tmp62_ = h_below;
				cairo_rectangle (_tmp57_, (gdouble) 0, (gdouble) (_tmp58_ * _tmp59_), (gdouble) (_tmp60_ * _tmp61_), _tmp62_);
				_tmp63_ = c;
				cairo_clip (_tmp63_);
				_tmp64_ = c;
				_tmp65_ = index;
				_tmp66_ = grid_size;
				_tmp67_ = self->priv->scroll_location;
				_tmp68_ = grid_size;
				cairo_translate (_tmp64_, (gdouble) 0, (_tmp65_ * _tmp66_) - (_tmp67_ * _tmp68_));
				_tmp69_ = c;
				_tmp70_ = self->priv->box_height;
				_tmp71_ = grid_size;
				cairo_translate (_tmp69_, (gdouble) 0, (gdouble) ((_tmp70_ - 1) * _tmp71_));
				_tmp72_ = index;
				_tmp73_ = self->priv->scroll_location;
				_tmp74_ = user_list_get_n_below (self);
				_tmp75_ = _tmp74_;
				alpha = 1.0 - ((_tmp72_ - _tmp73_) / (_tmp75_ + 1));
				_tmp76_ = c;
				_tmp77_ = entry;
				_tmp78_ = alpha;
				user_list_draw_entry (self, _tmp76_, _tmp77_, _tmp78_);
				_tmp79_ = c;
				_tmp80_ = self->priv->entries;
				_tmp81_ = g_list_length (_tmp80_);
				_tmp82_ = grid_size;
				cairo_translate (_tmp79_, (gdouble) 0, (gdouble) (_tmp81_ * _tmp82_));
				_tmp83_ = index;
				_tmp84_ = self->priv->entries;
				_tmp85_ = g_list_length (_tmp84_);
				_tmp86_ = self->priv->scroll_location;
				_tmp87_ = user_list_get_n_below (self);
				_tmp88_ = _tmp87_;
				alpha = 1.0 - (((_tmp83_ + ((gint) _tmp85_)) - _tmp86_) / (_tmp88_ + 1));
				_tmp89_ = c;
				_tmp90_ = entry;
				_tmp91_ = alpha;
				user_list_draw_entry (self, _tmp89_, _tmp90_, _tmp91_);
				_tmp92_ = c;
				cairo_restore (_tmp92_);
				_tmp93_ = index;
				index = _tmp93_ + 1;
				_user_entry_unref0 (entry);
			}
		}
	}
	_tmp94_ = c;
	cairo_save (_tmp94_);
	border = 4;
	_tmp95_ = c;
	_tmp96_ = border;
	_tmp97_ = border;
	cairo_translate (_tmp95_, (gdouble) (-_tmp96_), (gdouble) (-_tmp97_));
	_tmp98_ = c;
	_tmp99_ = self->priv->box_pattern;
	cairo_set_source (_tmp98_, _tmp99_);
	_tmp100_ = c;
	cairo_paint (_tmp100_);
	_tmp101_ = c;
	cairo_restore (_tmp101_);
	_tmp102_ = self->priv->selected_entry;
	if (_tmp102_ != NULL) {
		gint w = 0;
		gint h = 0;
		UserEntry* _tmp103_;
		PangoLayout* _tmp104_;
		gint _tmp105_ = 0;
		gint _tmp106_ = 0;
		gint _tmp107_;
		gint _tmp108_;
		gint _tmp109_;
		gint _tmp110_;
		gint _tmp111_;
		gint text_y;
		UserEntry* _tmp112_;
		gboolean _tmp113_;
		cairo_t* _tmp122_;
		gint _tmp123_;
		gint _tmp124_;
		gint _tmp125_;
		gint _tmp126_;
		cairo_pattern_t* _tmp127_;
		cairo_pattern_t* mask;
		gdouble left;
		cairo_pattern_t* _tmp128_;
		gdouble _tmp129_;
		cairo_pattern_t* _tmp130_;
		gdouble _tmp131_;
		gint _tmp132_;
		gint _tmp133_;
		cairo_pattern_t* _tmp134_;
		gdouble _tmp135_;
		gint _tmp136_;
		gint _tmp137_;
		cairo_t* _tmp138_;
		cairo_pattern_t* _tmp139_;
		cairo_t* _tmp140_;
		UserEntry* _tmp141_;
		PangoLayout* _tmp142_;
		_tmp103_ = self->priv->selected_entry;
		_tmp104_ = _tmp103_->layout;
		pango_layout_get_pixel_size (_tmp104_, &_tmp105_, &_tmp106_);
		w = _tmp105_;
		h = _tmp106_;
		_tmp107_ = grid_size;
		_tmp108_ = grid_size;
		_tmp109_ = border;
		_tmp110_ = h;
		_tmp111_ = h;
		text_y = (_tmp107_ - (((_tmp108_ - _tmp109_) - _tmp110_) / 4)) - _tmp111_;
		_tmp112_ = self->priv->selected_entry;
		_tmp113_ = _tmp112_->is_active;
		if (_tmp113_) {
			cairo_t* _tmp114_;
			gint _tmp115_;
			gint _tmp116_;
			cairo_t* _tmp117_;
			cairo_t* _tmp118_;
			cairo_t* _tmp119_;
			cairo_t* _tmp120_;
			cairo_t* _tmp121_;
			_tmp114_ = c;
			_tmp115_ = text_y;
			_tmp116_ = h;
			cairo_move_to (_tmp114_, (gdouble) 8, ((_tmp115_ + (_tmp116_ / 2)) + 0.5) - 4);
			_tmp117_ = c;
			cairo_rel_line_to (_tmp117_, (gdouble) 5, (gdouble) 4);
			_tmp118_ = c;
			cairo_rel_line_to (_tmp118_, (gdouble) (-5), (gdouble) 4);
			_tmp119_ = c;
			cairo_close_path (_tmp119_);
			_tmp120_ = c;
			cairo_set_source_rgb (_tmp120_, 1.0, 1.0, 1.0);
			_tmp121_ = c;
			cairo_fill (_tmp121_);
		}
		_tmp122_ = c;
		_tmp123_ = grid_size;
		_tmp124_ = text_y;
		cairo_move_to (_tmp122_, (gdouble) (_tmp123_ / 2), (gdouble) _tmp124_);
		_tmp125_ = grid_size;
		_tmp126_ = self->priv->box_width;
		_tmp127_ = cairo_pattern_create_linear ((gdouble) 0, (gdouble) 0, (gdouble) (_tmp125_ * _tmp126_), (gdouble) 0);
		mask = _tmp127_;
		left = 1.0 - (2.0 / 7);
		_tmp128_ = mask;
		_tmp129_ = left;
		cairo_pattern_add_color_stop_rgba (_tmp128_, _tmp129_, 1.0, 1.0, 1.0, 1.0);
		_tmp130_ = mask;
		_tmp131_ = left;
		_tmp132_ = grid_size;
		_tmp133_ = self->priv->box_width;
		cairo_pattern_add_color_stop_rgba (_tmp130_, _tmp131_ + (5.4 / (_tmp132_ * _tmp133_)), 1.0, 1.0, 1.0, 0.5);
		_tmp134_ = mask;
		_tmp135_ = left;
		_tmp136_ = grid_size;
		_tmp137_ = self->priv->box_width;
		cairo_pattern_add_color_stop_rgba (_tmp134_, _tmp135_ + (27.0 / (_tmp136_ * _tmp137_)), 1.0, 1.0, 1.0, 0.0);
		_tmp138_ = c;
		_tmp139_ = mask;
		cairo_set_source (_tmp138_, _tmp139_);
		_tmp140_ = c;
		_tmp141_ = self->priv->selected_entry;
		_tmp142_ = _tmp141_->layout;
		pango_cairo_show_layout (_tmp140_, _tmp142_);
		_cairo_pattern_destroy0 (mask);
	}
	_tmp144_ = self->priv->error;
	if (_tmp144_ != NULL) {
		_tmp143_ = TRUE;
	} else {
		const gchar* _tmp145_;
		_tmp145_ = self->priv->message;
		_tmp143_ = _tmp145_ != NULL;
	}
	_tmp146_ = _tmp143_;
	if (_tmp146_) {
		gchar* text = NULL;
		const gchar* _tmp147_;
		const gchar* _tmp152_;
		PangoLayout* _tmp153_ = NULL;
		PangoLayout* layout;
		PangoLayout* _tmp154_;
		PangoFontDescription* _tmp155_ = NULL;
		PangoFontDescription* _tmp156_;
		gint w = 0;
		gint h = 0;
		PangoLayout* _tmp157_;
		gint _tmp158_ = 0;
		gint _tmp159_ = 0;
		cairo_t* _tmp160_;
		gint _tmp161_;
		gint _tmp162_;
		gint _tmp163_;
		const gchar* _tmp164_;
		cairo_t* _tmp167_;
		PangoLayout* _tmp168_;
		_tmp147_ = self->priv->error;
		if (_tmp147_ == NULL) {
			const gchar* _tmp148_;
			gchar* _tmp149_;
			_tmp148_ = self->priv->message;
			_tmp149_ = g_strdup (_tmp148_);
			_g_free0 (text);
			text = _tmp149_;
		} else {
			const gchar* _tmp150_;
			gchar* _tmp151_;
			_tmp150_ = self->priv->error;
			_tmp151_ = g_strdup (_tmp150_);
			_g_free0 (text);
			text = _tmp151_;
		}
		_tmp152_ = text;
		_tmp153_ = gtk_widget_create_pango_layout ((GtkWidget*) self, _tmp152_);
		layout = _tmp153_;
		_tmp154_ = layout;
		_tmp155_ = pango_font_description_from_string ("Ubuntu 10");
		_tmp156_ = _tmp155_;
		pango_layout_set_font_description (_tmp154_, _tmp156_);
		_pango_font_description_free0 (_tmp156_);
		_tmp157_ = layout;
		pango_layout_get_pixel_size (_tmp157_, &_tmp158_, &_tmp159_);
		w = _tmp158_;
		h = _tmp159_;
		_tmp160_ = c;
		_tmp161_ = grid_size;
		_tmp162_ = grid_size;
		_tmp163_ = h;
		cairo_move_to (_tmp160_, (gdouble) (_tmp161_ / 2), (_tmp162_ * 1.25) - _tmp163_);
		_tmp164_ = self->priv->error;
		if (_tmp164_ != NULL) {
			cairo_t* _tmp165_;
			_tmp165_ = c;
			cairo_set_source_rgb (_tmp165_, 1.0, 0.0, 0.0);
		} else {
			cairo_t* _tmp166_;
			_tmp166_ = c;
			cairo_set_source_rgb (_tmp166_, 1.0, 1.0, 1.0);
		}
		_tmp167_ = c;
		_tmp168_ = layout;
		pango_cairo_show_layout (_tmp167_, _tmp168_);
		_g_object_unref0 (layout);
		_g_free0 (text);
	}
	_tmp169_ = c;
	cairo_restore (_tmp169_);
	_tmp170_ = self->priv->children;
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp170_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* _tmp171_;
			GtkWidget* child = NULL;
			_tmp171_ = _g_object_ref0 ((GtkWidget*) child_it->data);
			child = _tmp171_;
			{
				GtkWidget* _tmp172_;
				cairo_t* _tmp173_;
				_tmp172_ = child;
				_tmp173_ = c;
				gtk_container_propagate_draw ((GtkContainer*) self, _tmp172_, _tmp173_);
				_g_object_unref0 (child);
			}
		}
	}
	result = FALSE;
	return result;
}


static gboolean user_list_real_key_press_event (GtkWidget* base, GdkEventKey* event) {
	UserList * self;
	gboolean result = FALSE;
	GdkEventKey _tmp0_;
	guint _tmp1_;
	self = (UserList*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.keyval;
	switch (_tmp1_) {
		case GDK_KEY_Up:
		{
			g_debug ("user-list.vala:1342: Up pressed");
			user_list_select_prev_entry (self);
			break;
		}
		case GDK_KEY_Down:
		{
			g_debug ("user-list.vala:1346: Down pressed");
			user_list_select_next_entry (self);
			break;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
	result = TRUE;
	return result;
}


static gboolean user_list_inside_entry (UserList* self, gdouble x, gdouble y, gdouble entry_y, UserEntry* entry) {
	gboolean result = FALSE;
	gint w = 0;
	gint h = 0;
	UserEntry* _tmp0_;
	PangoLayout* _tmp1_;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gdouble _tmp14_;
	gboolean _tmp17_;
	gboolean _tmp20_;
	gboolean _tmp24_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (entry != NULL, FALSE);
	_tmp0_ = entry;
	_tmp1_ = _tmp0_->layout;
	pango_layout_get_pixel_size (_tmp1_, &_tmp2_, &_tmp3_);
	w = _tmp2_;
	h = _tmp3_;
	_tmp4_ = w;
	_tmp5_ = grid_size;
	w = _tmp4_ + (_tmp5_ / 2);
	_tmp6_ = grid_size;
	h = _tmp6_;
	_tmp7_ = w;
	_tmp8_ = grid_size;
	_tmp9_ = grid_size;
	_tmp10_ = grid_size;
	w = (((gint) (_tmp7_ + _tmp8_)) / _tmp9_) * _tmp10_;
	_tmp14_ = x;
	if (_tmp14_ >= ((gdouble) 0)) {
		gdouble _tmp15_;
		gint _tmp16_;
		_tmp15_ = x;
		_tmp16_ = w;
		_tmp13_ = _tmp15_ <= ((gdouble) _tmp16_);
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	if (_tmp17_) {
		gdouble _tmp18_;
		gdouble _tmp19_;
		_tmp18_ = y;
		_tmp19_ = entry_y;
		_tmp12_ = _tmp18_ >= _tmp19_;
	} else {
		_tmp12_ = FALSE;
	}
	_tmp20_ = _tmp12_;
	if (_tmp20_) {
		gdouble _tmp21_;
		gdouble _tmp22_;
		gint _tmp23_;
		_tmp21_ = y;
		_tmp22_ = entry_y;
		_tmp23_ = h;
		_tmp11_ = _tmp21_ <= (_tmp22_ + _tmp23_);
	} else {
		_tmp11_ = FALSE;
	}
	_tmp24_ = _tmp11_;
	result = _tmp24_;
	return result;
}


static gboolean user_list_real_button_release_event (GtkWidget* base, GdkEventButton* event) {
	UserList * self;
	gboolean result = FALSE;
	gint base_x = 0;
	gint base_y = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GdkEventButton _tmp2_;
	gdouble _tmp3_;
	gint _tmp4_;
	gdouble x;
	GdkEventButton _tmp5_;
	gdouble _tmp6_;
	gint _tmp7_;
	gdouble y;
	GList* _tmp8_;
	guint _tmp9_ = 0U;
	gint _tmp10_;
	gdouble h;
	gdouble offset;
	GList* _tmp11_;
	self = (UserList*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	user_list_get_selected_location (self, &_tmp0_, &_tmp1_);
	base_x = _tmp0_;
	base_y = _tmp1_;
	_tmp2_ = *event;
	_tmp3_ = _tmp2_.x;
	_tmp4_ = base_x;
	x = _tmp3_ - _tmp4_;
	_tmp5_ = *event;
	_tmp6_ = _tmp5_.y;
	_tmp7_ = base_y;
	y = _tmp6_ - _tmp7_;
	_tmp8_ = self->priv->entries;
	_tmp9_ = g_list_length (_tmp8_);
	_tmp10_ = grid_size;
	h = ((gdouble) _tmp9_) * _tmp10_;
	offset = 0.0;
	_tmp11_ = self->priv->entries;
	{
		GList* entry_collection = NULL;
		GList* entry_it = NULL;
		entry_collection = _tmp11_;
		for (entry_it = entry_collection; entry_it != NULL; entry_it = entry_it->next) {
			UserEntry* _tmp12_;
			UserEntry* entry = NULL;
			_tmp12_ = _user_entry_ref0 ((UserEntry*) entry_it->data);
			entry = _tmp12_;
			{
				gdouble _tmp13_;
				gint _tmp14_;
				gdouble _tmp15_;
				gdouble entry_y;
				guint _tmp16_;
				guint _tmp17_;
				gint _tmp18_;
				gdouble h_above;
				gboolean _tmp19_ = FALSE;
				gdouble _tmp20_;
				gboolean _tmp23_;
				gdouble _tmp38_;
				gint _tmp39_;
				gint _tmp40_;
				gdouble below_y;
				guint _tmp41_;
				guint _tmp42_;
				gint _tmp43_;
				gdouble h_below;
				gboolean _tmp44_ = FALSE;
				gdouble _tmp45_;
				gboolean _tmp48_;
				gdouble _tmp65_;
				gint _tmp66_;
				_tmp13_ = self->priv->scroll_location;
				_tmp14_ = grid_size;
				_tmp15_ = offset;
				entry_y = ((-_tmp13_) * _tmp14_) + _tmp15_;
				_tmp16_ = user_list_get_n_above (self);
				_tmp17_ = _tmp16_;
				_tmp18_ = grid_size;
				h_above = ((gdouble) _tmp17_) * _tmp18_;
				_tmp20_ = y;
				if (_tmp20_ < ((gdouble) 0)) {
					gdouble _tmp21_;
					gdouble _tmp22_;
					_tmp21_ = y;
					_tmp22_ = h_above;
					_tmp19_ = _tmp21_ > (-_tmp22_);
				} else {
					_tmp19_ = FALSE;
				}
				_tmp23_ = _tmp19_;
				if (_tmp23_) {
					gboolean _tmp24_ = FALSE;
					gdouble _tmp25_;
					gdouble _tmp26_;
					gdouble _tmp27_;
					UserEntry* _tmp28_;
					gboolean _tmp29_ = FALSE;
					gboolean _tmp36_;
					_tmp25_ = x;
					_tmp26_ = y;
					_tmp27_ = entry_y;
					_tmp28_ = entry;
					_tmp29_ = user_list_inside_entry (self, _tmp25_, _tmp26_, _tmp27_, _tmp28_);
					if (_tmp29_) {
						_tmp24_ = TRUE;
					} else {
						gdouble _tmp30_;
						gdouble _tmp31_;
						gdouble _tmp32_;
						gdouble _tmp33_;
						UserEntry* _tmp34_;
						gboolean _tmp35_ = FALSE;
						_tmp30_ = x;
						_tmp31_ = y;
						_tmp32_ = entry_y;
						_tmp33_ = h;
						_tmp34_ = entry;
						_tmp35_ = user_list_inside_entry (self, _tmp30_, _tmp31_, _tmp32_ - _tmp33_, _tmp34_);
						_tmp24_ = _tmp35_;
					}
					_tmp36_ = _tmp24_;
					if (_tmp36_) {
						UserEntry* _tmp37_;
						_tmp37_ = entry;
						user_list_select_entry (self, _tmp37_, -1.0);
						result = TRUE;
						_user_entry_unref0 (entry);
						return result;
					}
				}
				_tmp38_ = y;
				_tmp39_ = self->priv->box_height;
				_tmp40_ = grid_size;
				below_y = _tmp38_ - (_tmp39_ * _tmp40_);
				_tmp41_ = user_list_get_n_below (self);
				_tmp42_ = _tmp41_;
				_tmp43_ = grid_size;
				h_below = ((gdouble) _tmp42_) * _tmp43_;
				_tmp45_ = below_y;
				if (_tmp45_ > ((gdouble) 0)) {
					gdouble _tmp46_;
					gdouble _tmp47_;
					_tmp46_ = below_y;
					_tmp47_ = h_below;
					_tmp44_ = _tmp46_ < _tmp47_;
				} else {
					_tmp44_ = FALSE;
				}
				_tmp48_ = _tmp44_;
				if (_tmp48_) {
					gboolean _tmp49_ = FALSE;
					gdouble _tmp50_;
					gdouble _tmp51_;
					gdouble _tmp52_;
					gint _tmp53_;
					UserEntry* _tmp54_;
					gboolean _tmp55_ = FALSE;
					gboolean _tmp63_;
					_tmp50_ = x;
					_tmp51_ = below_y;
					_tmp52_ = entry_y;
					_tmp53_ = grid_size;
					_tmp54_ = entry;
					_tmp55_ = user_list_inside_entry (self, _tmp50_, _tmp51_, _tmp52_ - _tmp53_, _tmp54_);
					if (_tmp55_) {
						_tmp49_ = TRUE;
					} else {
						gdouble _tmp56_;
						gdouble _tmp57_;
						gdouble _tmp58_;
						gint _tmp59_;
						gdouble _tmp60_;
						UserEntry* _tmp61_;
						gboolean _tmp62_ = FALSE;
						_tmp56_ = x;
						_tmp57_ = below_y;
						_tmp58_ = entry_y;
						_tmp59_ = grid_size;
						_tmp60_ = h;
						_tmp61_ = entry;
						_tmp62_ = user_list_inside_entry (self, _tmp56_, _tmp57_, (_tmp58_ - _tmp59_) + _tmp60_, _tmp61_);
						_tmp49_ = _tmp62_;
					}
					_tmp63_ = _tmp49_;
					if (_tmp63_) {
						UserEntry* _tmp64_;
						_tmp64_ = entry;
						user_list_select_entry (self, _tmp64_, 1.0);
						result = TRUE;
						_user_entry_unref0 (entry);
						return result;
					}
				}
				_tmp65_ = offset;
				_tmp66_ = grid_size;
				offset = _tmp65_ + _tmp66_;
				_user_entry_unref0 (entry);
			}
		}
	}
	result = FALSE;
	return result;
}


static void user_list_real_unrealize (GtkWidget* base) {
	UserList * self;
	GPid _tmp0_;
	self = (UserList*) base;
	_tmp0_ = self->priv->keyboard_pid;
	if (_tmp0_ != ((GPid) 0)) {
		GPid _tmp1_;
		gint status = 0;
		GPid _tmp2_;
		gint _tmp3_ = 0;
		_tmp1_ = self->priv->keyboard_pid;
		kill ((pid_t) _tmp1_, SIGKILL);
		_tmp2_ = self->priv->keyboard_pid;
		waitpid ((pid_t) _tmp2_, &_tmp3_, 0);
		status = _tmp3_;
	}
}


const gchar* user_list_get_selected (UserList* self) {
	const gchar* result;
	UserEntry* _tmp0_;
	UserEntry* _tmp1_;
	const gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->selected_entry;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->selected_entry;
	_tmp2_ = _tmp1_->name;
	result = _tmp2_;
	return result;
}


const gchar* user_list_get_session (UserList* self) {
	const gchar* result;
	GSList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->session_group;
	{
		GSList* item_collection = NULL;
		GSList* item_it = NULL;
		item_collection = _tmp0_;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			SessionMenuItem* _tmp1_;
			SessionMenuItem* item = NULL;
			_tmp1_ = _g_object_ref0 ((SessionMenuItem*) item_it->data);
			item = _tmp1_;
			{
				SessionMenuItem* _tmp2_;
				gboolean _tmp3_;
				gboolean _tmp4_;
				_tmp2_ = item;
				_tmp3_ = gtk_check_menu_item_get_active ((GtkCheckMenuItem*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (_tmp4_) {
					SessionMenuItem* _tmp5_;
					const gchar* _tmp6_;
					_tmp5_ = item;
					_tmp6_ = _tmp5_->session_name;
					result = _tmp6_;
					_g_object_unref0 (item);
					return result;
				}
				_g_object_unref0 (item);
			}
		}
	}
	result = NULL;
	return result;
}


void user_list_set_session (UserList* self, const gchar* value) {
	GSList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->session_group;
	{
		GSList* item_collection = NULL;
		GSList* item_it = NULL;
		item_collection = _tmp0_;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			SessionMenuItem* _tmp1_;
			SessionMenuItem* item = NULL;
			_tmp1_ = _g_object_ref0 ((SessionMenuItem*) item_it->data);
			item = _tmp1_;
			{
				SessionMenuItem* _tmp2_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				_tmp2_ = item;
				_tmp3_ = _tmp2_->session_name;
				_tmp4_ = value;
				if (g_strcmp0 (_tmp3_, _tmp4_) == 0) {
					SessionMenuItem* _tmp5_;
					_tmp5_ = item;
					gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp5_, TRUE);
					_g_object_unref0 (item);
					return;
				}
				_g_object_unref0 (item);
			}
		}
	}
	g_object_notify ((GObject *) self, "session");
}


static guint user_list_get_n_above (UserList* self) {
	guint result;
	GList* _tmp0_;
	guint _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->entries;
	_tmp1_ = g_list_length (_tmp0_);
	result = (_tmp1_ - 1) / 2;
	return result;
}


static guint user_list_get_n_below (UserList* self) {
	guint result;
	GList* _tmp0_;
	guint _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->entries;
	_tmp1_ = g_list_length (_tmp0_);
	result = _tmp1_ / 2;
	return result;
}


static void user_list_class_init (UserListClass * klass) {
	user_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UserListPrivate));
	GTK_CONTAINER_CLASS (klass)->add = user_list_real_add;
	GTK_CONTAINER_CLASS (klass)->remove = user_list_real_remove;
	GTK_CONTAINER_CLASS (klass)->forall = user_list_real_forall_internal;
	GTK_WIDGET_CLASS (klass)->realize = user_list_real_realize;
	GTK_WIDGET_CLASS (klass)->map = user_list_real_map;
	GTK_WIDGET_CLASS (klass)->size_allocate = user_list_real_size_allocate;
	GTK_WIDGET_CLASS (klass)->draw = user_list_real_draw;
	GTK_WIDGET_CLASS (klass)->key_press_event = user_list_real_key_press_event;
	GTK_WIDGET_CLASS (klass)->button_release_event = user_list_real_button_release_event;
	GTK_WIDGET_CLASS (klass)->unrealize = user_list_real_unrealize;
	G_OBJECT_CLASS (klass)->get_property = _vala_user_list_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_user_list_set_property;
	G_OBJECT_CLASS (klass)->finalize = user_list_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), USER_LIST_SELECTED, g_param_spec_string ("selected", "selected", "selected", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USER_LIST_SESSION, g_param_spec_string ("session", "session", "session", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("user_selected", TYPE_USER_LIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("respond_to_prompt", TYPE_USER_LIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("start_session", TYPE_USER_LIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void user_list_instance_init (UserList * self) {
	self->priv = USER_LIST_GET_PRIVATE (self);
	self->priv->frame_count = 0;
	self->priv->draw_timer = NULL;
	self->priv->draw_timeout = (guint) 0;
	self->priv->draw_count = 0;
	self->priv->box_width = 7;
	self->priv->change_background_timeout = (guint) 0;
	self->priv->entries = NULL;
	self->priv->selected_entry = NULL;
	self->priv->keyboard_pid = (GPid) 0;
	self->priv->keyboard_window = NULL;
	self->priv->box_surface = NULL;
	self->priv->session_group = NULL;
	self->priv->complete = FALSE;
	self->priv->box_height = 3;
}


static void user_list_finalize (GObject* obj) {
	UserList * self;
	self = USER_LIST (obj);
	_g_free0 (self->priv->default_theme_name);
	_g_timer_destroy0 (self->priv->draw_timer);
	_g_hash_table_unref0 (self->priv->backgrounds);
	_background_unref0 (self->priv->background);
	_background_unref0 (self->priv->old_background);
	__g_list_free__user_entry_unref0_0 (self->priv->entries);
	_user_entry_unref0 (self->priv->selected_entry);
	_animate_timer_unref0 (self->priv->scroll_timer);
	_animate_timer_unref0 (self->priv->background_timer);
	__g_list_free__g_object_unref0_0 (self->priv->children);
	_g_object_unref0 (self->priv->menubar);
	_cairo_destroy0 (self->priv->menubar_cairo_context);
	__g_list_free__g_object_unref0_0 (self->indicator_objects);
	_g_object_unref0 (self->priv->high_contrast_item);
	_g_object_unref0 (self->priv->keyboard_window);
	_g_free0 (self->priv->error);
	_g_free0 (self->priv->message);
	_cairo_surface_destroy0 (self->priv->box_surface);
	_cairo_pattern_destroy0 (self->priv->box_pattern);
	_g_object_unref0 (self->priv->prompt_entry);
	_g_object_unref0 (self->priv->login_button);
	_g_object_unref0 (self->priv->options_button);
	_g_object_unref0 (self->priv->options_menu);
	G_OBJECT_CLASS (user_list_parent_class)->finalize (obj);
}


GType user_list_get_type (void) {
	static volatile gsize user_list_type_id__volatile = 0;
	if (g_once_init_enter (&user_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UserListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) user_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UserList), 0, (GInstanceInitFunc) user_list_instance_init, NULL };
		GType user_list_type_id;
		user_list_type_id = g_type_register_static (GTK_TYPE_CONTAINER, "UserList", &g_define_type_info, 0);
		g_once_init_leave (&user_list_type_id__volatile, user_list_type_id);
	}
	return user_list_type_id__volatile;
}


static void _vala_user_list_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UserList * self;
	self = USER_LIST (object);
	switch (property_id) {
		case USER_LIST_SELECTED:
		g_value_set_string (value, user_list_get_selected (self));
		break;
		case USER_LIST_SESSION:
		g_value_set_string (value, user_list_get_session (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_user_list_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UserList * self;
	self = USER_LIST (object);
	switch (property_id) {
		case USER_LIST_SESSION:
		user_list_set_session (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



