/* unity-greeter.c generated by valac 0.14.0, the Vala compiler
 * generated from unity-greeter.vala, do not modify */

/*
 * Copyright (C) 2011 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Robert Ancell <robert.ancell@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <lightdm.h>
#include <cairo.h>
#include <gdk/gdk.h>
#include <atk/atk.h>
#include <glib/gi18n-lib.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include <gdk/gdkx.h>
#include <cairo-xlib.h>
#include <stdio.h>
#include <locale.h>
#include <unistd.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>


#define TYPE_UNITY_GREETER (unity_greeter_get_type ())
#define UNITY_GREETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNITY_GREETER, UnityGreeter))
#define UNITY_GREETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNITY_GREETER, UnityGreeterClass))
#define IS_UNITY_GREETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNITY_GREETER))
#define IS_UNITY_GREETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNITY_GREETER))
#define UNITY_GREETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNITY_GREETER, UnityGreeterClass))

typedef struct _UnityGreeter UnityGreeter;
typedef struct _UnityGreeterClass UnityGreeterClass;
typedef struct _UnityGreeterPrivate UnityGreeterPrivate;

#define TYPE_USER_LIST (user_list_get_type ())
#define USER_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_LIST, UserList))
#define USER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_LIST, UserListClass))
#define IS_USER_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_LIST))
#define IS_USER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_LIST))
#define USER_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_LIST, UserListClass))

typedef struct _UserList UserList;
typedef struct _UserListClass UserListClass;

#define TYPE_SETTINGS_DAEMON (settings_daemon_get_type ())
#define SETTINGS_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTINGS_DAEMON, SettingsDaemon))
#define SETTINGS_DAEMON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTINGS_DAEMON, SettingsDaemonClass))
#define IS_SETTINGS_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTINGS_DAEMON))
#define IS_SETTINGS_DAEMON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTINGS_DAEMON))
#define SETTINGS_DAEMON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTINGS_DAEMON, SettingsDaemonClass))

typedef struct _SettingsDaemon SettingsDaemon;
typedef struct _SettingsDaemonClass SettingsDaemonClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_BACKGROUND (background_get_type ())
#define BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKGROUND, Background))
#define BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKGROUND, BackgroundClass))
#define IS_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKGROUND))
#define IS_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKGROUND))
#define BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKGROUND, BackgroundClass))

typedef struct _Background Background;
typedef struct _BackgroundClass BackgroundClass;
typedef struct _BackgroundPrivate BackgroundPrivate;
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _background_unref0(var) ((var == NULL) ? NULL : (var = (background_unref (var), NULL)))
#define _XCloseDisplay0(var) ((var == NULL) ? NULL : (var = (XCloseDisplay (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _unity_greeter_unref0(var) ((var == NULL) ? NULL : (var = (unity_greeter_unref (var), NULL)))
typedef struct _ParamSpecUnityGreeter ParamSpecUnityGreeter;

struct _UnityGreeter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UnityGreeterPrivate * priv;
	UserList* user_list;
};

struct _UnityGreeterClass {
	GTypeClass parent_class;
	void (*finalize) (UnityGreeter *self);
};

struct _UnityGreeterPrivate {
	GFile* state_file;
	GKeyFile* state;
	SettingsDaemon* settings_daemon;
	gchar* default_background;
	GtkWindow* main_window;
	LightDMGreeter* greeter;
	gboolean prompted;
	gboolean have_session;
	gchar* authenticate_user;
	gchar* test_username;
	gboolean test_is_authenticated;
};

struct _Background {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BackgroundPrivate * priv;
	cairo_pattern_t* pattern;
};

struct _BackgroundClass {
	GTypeClass parent_class;
	void (*finalize) (Background *self);
};

struct _ParamSpecUnityGreeter {
	GParamSpec parent_instance;
};


static gpointer unity_greeter_parent_class = NULL;
static gboolean unity_greeter_show_version;
static gboolean unity_greeter_show_version = FALSE;
static gboolean unity_greeter_test_mode;
static gboolean unity_greeter_test_mode = FALSE;
static GTimer* unity_greeter_log_timer;
static GTimer* unity_greeter_log_timer = NULL;
static GKeyFile* unity_greeter_config;
static GKeyFile* unity_greeter_config = NULL;
static cairo_surface_t* unity_greeter_background_surface;
static cairo_surface_t* unity_greeter_background_surface = NULL;

gpointer unity_greeter_ref (gpointer instance);
void unity_greeter_unref (gpointer instance);
GParamSpec* param_spec_unity_greeter (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_unity_greeter (GValue* value, gpointer v_object);
void value_take_unity_greeter (GValue* value, gpointer v_object);
gpointer value_get_unity_greeter (const GValue* value);
GType unity_greeter_get_type (void) G_GNUC_CONST;
GType user_list_get_type (void) G_GNUC_CONST;
GType settings_daemon_get_type (void) G_GNUC_CONST;
#define UNITY_GREETER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_UNITY_GREETER, UnityGreeterPrivate))
enum  {
	UNITY_GREETER_DUMMY_PROPERTY
};
UnityGreeter* unity_greeter_new (void);
UnityGreeter* unity_greeter_construct (GType object_type);
static void unity_greeter_show_message_cb (UnityGreeter* self, const gchar* text, LightDMMessageType type);
static void _unity_greeter_show_message_cb_lightdm_greeter_show_message (LightDMGreeter* _sender, const gchar* text, LightDMMessageType type, gpointer self);
static void unity_greeter_show_prompt_cb (UnityGreeter* self, const gchar* text, LightDMPromptType type);
static void _unity_greeter_show_prompt_cb_lightdm_greeter_show_prompt (LightDMGreeter* _sender, const gchar* text, LightDMPromptType type, gpointer self);
static void unity_greeter_authentication_complete_cb (UnityGreeter* self);
static void _unity_greeter_authentication_complete_cb_lightdm_greeter_authentication_complete (LightDMGreeter* _sender, gpointer self);
SettingsDaemon* settings_daemon_new (void);
SettingsDaemon* settings_daemon_construct (GType object_type);
void settings_daemon_start (SettingsDaemon* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void settings_daemon_start_finish (SettingsDaemon* self, GAsyncResult* _res_);
gchar* unity_greeter_get_config_value (const gchar* group_name, const gchar* key, const gchar* _default_);
static void unity_greeter_monitors_changed_cb (UnityGreeter* self, GdkScreen* screen);
static void _unity_greeter_monitors_changed_cb_gdk_screen_monitors_changed (GdkScreen* _sender, gpointer self);
UserList* user_list_new (void);
UserList* user_list_construct (GType object_type);
void user_list_set_logo (UserList* self, const gchar* logo_path);
void user_list_add_session (UserList* self, const gchar* name, const gchar* label);
void user_list_add_entry (UserList* self, const gchar* name, const gchar* label, const gchar* background, gboolean is_active);
void user_list_set_active_entry (UserList* self, const gchar* name);
static void unity_greeter_user_added_cb (UnityGreeter* self, LightDMUser* user);
static void _unity_greeter_user_added_cb_lightdm_user_list_user_added (LightDMUserList* _sender, LightDMUser* user, gpointer self);
static void _unity_greeter_user_added_cb_lightdm_user_list_user_changed (LightDMUserList* _sender, LightDMUser* user, gpointer self);
static void unity_greeter_user_removed_cb (UnityGreeter* self, LightDMUser* user);
static void _unity_greeter_user_removed_cb_lightdm_user_list_user_removed (LightDMUserList* _sender, LightDMUser* user, gpointer self);
static void unity_greeter_user_selected_cb (UnityGreeter* self, const gchar* username);
static void _unity_greeter_user_selected_cb_user_list_user_selected (UserList* _sender, const gchar* username, gpointer self);
static void unity_greeter_respond_to_prompt_cb (UnityGreeter* self, const gchar* text);
static void _unity_greeter_respond_to_prompt_cb_user_list_respond_to_prompt (UserList* _sender, const gchar* text, gpointer self);
static void unity_greeter_start_session_cb (UnityGreeter* self);
static void _unity_greeter_start_session_cb_user_list_start_session (UserList* _sender, gpointer self);
const gchar* user_list_get_selected (UserList* self);
void user_list_remove_entry (UserList* self, const gchar* name);
void unity_greeter_show (UnityGreeter* self);
static void unity_greeter_update_session (UnityGreeter* self);
void user_list_set_session (UserList* self, const gchar* value);
void user_list_show_message (UserList* self, const gchar* text, gboolean _error_);
static void unity_greeter_update_other_label (UnityGreeter* self);
void user_list_show_prompt (UserList* self, const gchar* text, gboolean secret);
gpointer background_ref (gpointer instance);
void background_unref (gpointer instance);
GParamSpec* param_spec_background (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_background (GValue* value, gpointer v_object);
void value_take_background (GValue* value, gpointer v_object);
gpointer value_get_background (const GValue* value);
GType background_get_type (void) G_GNUC_CONST;
static void unity_greeter_background_loaded_cb (UnityGreeter* self, Background* background);
static void unity_greeter_refresh_background (UnityGreeter* self, GdkScreen* screen);
const gchar* user_list_get_session (UserList* self);
void user_list_login_complete (UserList* self);
Background* user_list_get_background (UserList* self);
static void _unity_greeter_background_loaded_cb_background_loaded (Background* _sender, gpointer self);
gboolean background_load (Background* self);
void user_list_show_authenticated (UserList* self);
void user_list_set_error (UserList* self, const gchar* text);
static void unity_greeter_start_authentication (UnityGreeter* self);
static cairo_surface_t* unity_greeter_create_root_surface (GdkScreen* screen);
static void unity_greeter_log_cb (const gchar* log_domain, GLogLevelFlags log_level, const gchar* message);
gint unity_greeter_main (gchar** args, int args_length1);
static void _unity_greeter_log_cb_glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self);
static void unity_greeter_finalize (UnityGreeter* obj);

const GOptionEntry UNITY_GREETER_options[3] = {{"version", 'v', 0, G_OPTION_ARG_NONE, &unity_greeter_show_version, "Show release version", NULL}, {"test-mode", (gchar) 0, 0, G_OPTION_ARG_NONE, &unity_greeter_test_mode, "Run in test mode", NULL}, {NULL}};

static void _unity_greeter_show_message_cb_lightdm_greeter_show_message (LightDMGreeter* _sender, const gchar* text, LightDMMessageType type, gpointer self) {
	unity_greeter_show_message_cb (self, text, type);
}


static void _unity_greeter_show_prompt_cb_lightdm_greeter_show_prompt (LightDMGreeter* _sender, const gchar* text, LightDMPromptType type, gpointer self) {
	unity_greeter_show_prompt_cb (self, text, type);
}


static void _unity_greeter_authentication_complete_cb_lightdm_greeter_authentication_complete (LightDMGreeter* _sender, gpointer self) {
	unity_greeter_authentication_complete_cb (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _unity_greeter_monitors_changed_cb_gdk_screen_monitors_changed (GdkScreen* _sender, gpointer self) {
	unity_greeter_monitors_changed_cb (self, _sender);
}


static void _unity_greeter_user_added_cb_lightdm_user_list_user_added (LightDMUserList* _sender, LightDMUser* user, gpointer self) {
	unity_greeter_user_added_cb (self, user);
}


static void _unity_greeter_user_added_cb_lightdm_user_list_user_changed (LightDMUserList* _sender, LightDMUser* user, gpointer self) {
	unity_greeter_user_added_cb (self, user);
}


static void _unity_greeter_user_removed_cb_lightdm_user_list_user_removed (LightDMUserList* _sender, LightDMUser* user, gpointer self) {
	unity_greeter_user_removed_cb (self, user);
}


static void _unity_greeter_user_selected_cb_user_list_user_selected (UserList* _sender, const gchar* username, gpointer self) {
	unity_greeter_user_selected_cb (self, username);
}


static void _unity_greeter_respond_to_prompt_cb_user_list_respond_to_prompt (UserList* _sender, const gchar* text, gpointer self) {
	unity_greeter_respond_to_prompt_cb (self, text);
}


static void _unity_greeter_start_session_cb_user_list_start_session (UserList* _sender, gpointer self) {
	unity_greeter_start_session_cb (self);
}


UnityGreeter* unity_greeter_construct (GType object_type) {
	UnityGreeter* self = NULL;
	LightDMGreeter* _tmp0_;
	LightDMGreeter* _tmp1_;
	LightDMGreeter* _tmp2_;
	LightDMGreeter* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp6_;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* state_dir;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	GFile* _tmp13_ = NULL;
	GKeyFile* _tmp14_;
	gchar* _tmp25_;
	gchar* last_user;
	gchar* _tmp29_ = NULL;
	GtkWindow* _tmp30_;
	GtkWindow* _tmp31_;
	GdkColor bg_color = {0};
	GdkColor _tmp32_ = {0};
	GtkWindow* _tmp33_;
	GdkColor _tmp34_;
	GtkWindow* _tmp35_;
	AtkObject* _tmp36_ = NULL;
	const gchar* _tmp37_ = NULL;
	GtkWindow* _tmp38_;
	gboolean _tmp39_;
	UserList* _tmp46_;
	UserList* _tmp47_;
	GtkWindow* _tmp48_;
	UserList* _tmp49_;
	UserList* _tmp50_;
	gchar* _tmp51_ = NULL;
	gchar* _tmp52_;
	gchar* _tmp53_ = NULL;
	gchar* _tmp54_;
	UserList* _tmp55_;
	GList* _tmp56_ = NULL;
	gboolean _tmp70_;
	UserList* _tmp117_;
	UserList* _tmp118_;
	UserList* _tmp119_;
	UserList* _tmp120_;
	const gchar* _tmp121_;
	const gchar* _tmp122_;
	GError * _inner_error_ = NULL;
	self = (UnityGreeter*) g_type_create_instance (object_type);
	_tmp0_ = lightdm_greeter_new ();
	_g_object_unref0 (self->priv->greeter);
	self->priv->greeter = _tmp0_;
	_tmp1_ = self->priv->greeter;
	g_signal_connect (_tmp1_, "show-message", (GCallback) _unity_greeter_show_message_cb_lightdm_greeter_show_message, self);
	_tmp2_ = self->priv->greeter;
	g_signal_connect (_tmp2_, "show-prompt", (GCallback) _unity_greeter_show_prompt_cb_lightdm_greeter_show_prompt, self);
	_tmp3_ = self->priv->greeter;
	g_signal_connect (_tmp3_, "authentication-complete", (GCallback) _unity_greeter_authentication_complete_cb_lightdm_greeter_authentication_complete, self);
	_tmp4_ = unity_greeter_test_mode;
	if (!_tmp4_) {
		{
			LightDMGreeter* _tmp5_;
			_tmp5_ = self->priv->greeter;
			lightdm_greeter_connect_sync (_tmp5_, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			g_warning ("unity-greeter.vala:73: Failed to connect to LightDM daemon");
			exit (EXIT_FAILURE);
			_g_error_free0 (e);
		}
		__finally1:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp6_ = unity_greeter_test_mode;
	if (!_tmp6_) {
		SettingsDaemon* _tmp7_;
		SettingsDaemon* _tmp8_;
		_tmp7_ = settings_daemon_new ();
		_g_object_unref0 (self->priv->settings_daemon);
		self->priv->settings_daemon = _tmp7_;
		_tmp8_ = self->priv->settings_daemon;
		settings_daemon_start (_tmp8_, NULL, NULL);
	}
	_tmp9_ = g_get_user_cache_dir ();
	_tmp10_ = g_build_filename (_tmp9_, "unity-greeter", NULL);
	state_dir = _tmp10_;
	g_mkdir_with_parents (state_dir, 0775);
	_tmp11_ = g_build_filename (state_dir, "state", NULL);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_file_new_for_path (_tmp12_);
	_g_object_unref0 (self->priv->state_file);
	self->priv->state_file = _tmp13_;
	_g_free0 (_tmp12_);
	_tmp14_ = g_key_file_new ();
	_g_key_file_free0 (self->priv->state);
	self->priv->state = _tmp14_;
	{
		GKeyFile* _tmp15_;
		GFile* _tmp16_;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_;
		_tmp15_ = self->priv->state;
		_tmp16_ = self->priv->state_file;
		_tmp17_ = g_file_get_path (_tmp16_);
		_tmp18_ = _tmp17_;
		g_key_file_load_from_file (_tmp15_, _tmp18_, G_KEY_FILE_NONE, &_inner_error_);
		_g_free0 (_tmp18_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp19_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp19_ = e;
		if (!g_error_matches (_tmp19_, G_FILE_ERROR, G_FILE_ERROR_NOENT)) {
			GFile* _tmp20_;
			gchar* _tmp21_ = NULL;
			gchar* _tmp22_;
			GError* _tmp23_;
			const gchar* _tmp24_;
			_tmp20_ = self->priv->state_file;
			_tmp21_ = g_file_get_path (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = e;
			_tmp24_ = _tmp23_->message;
			g_warning ("unity-greeter.vala:96: Failed to load state from %s: %s\n", _tmp22_, _tmp24_);
			_g_free0 (_tmp22_);
		}
		_g_error_free0 (e);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_free0 (state_dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp25_ = g_strdup ("");
	last_user = _tmp25_;
	{
		GKeyFile* _tmp26_;
		gchar* _tmp27_ = NULL;
		gchar* _tmp28_;
		_tmp26_ = self->priv->state;
		_tmp27_ = g_key_file_get_value (_tmp26_, "greeter", "last-user", &_inner_error_);
		_tmp28_ = _tmp27_;
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
		_g_free0 (last_user);
		last_user = _tmp28_;
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_free0 (last_user);
		_g_free0 (state_dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp29_ = unity_greeter_get_config_value ("greeter", "background", "#2C001E");
	_g_free0 (self->priv->default_background);
	self->priv->default_background = _tmp29_;
	_tmp30_ = (GtkWindow*) gtk_window_new (GTK_WINDOW_TOPLEVEL);
	_tmp31_ = g_object_ref_sink (_tmp30_);
	_g_object_unref0 (self->priv->main_window);
	self->priv->main_window = _tmp31_;
	memset (&bg_color, 0, sizeof (GdkColor));
	gdk_color_parse ("#2C001E", &_tmp32_);
	bg_color = _tmp32_;
	_tmp33_ = self->priv->main_window;
	_tmp34_ = bg_color;
	gtk_widget_modify_bg ((GtkWidget*) _tmp33_, GTK_STATE_NORMAL, &_tmp34_);
	_tmp35_ = self->priv->main_window;
	_tmp36_ = gtk_widget_get_accessible ((GtkWidget*) _tmp35_);
	_tmp37_ = _ ("Login Screen");
	atk_object_set_name (_tmp36_, _tmp37_);
	_tmp38_ = self->priv->main_window;
	gtk_window_set_has_resize_grip (_tmp38_, FALSE);
	_tmp39_ = unity_greeter_test_mode;
	if (_tmp39_) {
		GtkWindow* _tmp40_;
		_tmp40_ = self->priv->main_window;
		gtk_window_resize (_tmp40_, 1024, 600);
	} else {
		GtkWindow* _tmp41_;
		GdkScreen* _tmp42_ = NULL;
		GdkScreen* _tmp43_;
		GdkScreen* screen;
		GdkScreen* _tmp44_;
		GdkScreen* _tmp45_;
		_tmp41_ = self->priv->main_window;
		_tmp42_ = gtk_window_get_screen (_tmp41_);
		_tmp43_ = _g_object_ref0 (_tmp42_);
		screen = _tmp43_;
		_tmp44_ = screen;
		g_signal_connect (_tmp44_, "monitors-changed", (GCallback) _unity_greeter_monitors_changed_cb_gdk_screen_monitors_changed, self);
		_tmp45_ = screen;
		unity_greeter_monitors_changed_cb (self, _tmp45_);
		_g_object_unref0 (screen);
	}
	_tmp46_ = user_list_new ();
	_tmp47_ = g_object_ref_sink (_tmp46_);
	_g_object_unref0 (self->user_list);
	self->user_list = _tmp47_;
	_tmp48_ = self->priv->main_window;
	_tmp49_ = self->user_list;
	gtk_container_add ((GtkContainer*) _tmp48_, (GtkWidget*) _tmp49_);
	_tmp50_ = self->user_list;
	_tmp51_ = g_build_filename (PKGDATADIR, "logo.png", NULL, NULL);
	_tmp52_ = _tmp51_;
	_tmp53_ = unity_greeter_get_config_value ("greeter", "logo", _tmp52_);
	_tmp54_ = _tmp53_;
	user_list_set_logo (_tmp50_, _tmp54_);
	_g_free0 (_tmp54_);
	_g_free0 (_tmp52_);
	_tmp55_ = self->user_list;
	gtk_widget_show ((GtkWidget*) _tmp55_);
	_tmp56_ = lightdm_get_sessions ();
	{
		GList* session_collection = NULL;
		GList* session_it = NULL;
		session_collection = _tmp56_;
		for (session_it = session_collection; session_it != NULL; session_it = session_it->next) {
			LightDMSession* session = NULL;
			session = (LightDMSession*) session_it->data;
			{
				LightDMSession* _tmp57_;
				const gchar* _tmp58_;
				const gchar* _tmp59_;
				LightDMSession* _tmp60_;
				const gchar* _tmp61_;
				const gchar* _tmp62_;
				UserList* _tmp63_;
				LightDMSession* _tmp64_;
				const gchar* _tmp65_;
				const gchar* _tmp66_;
				LightDMSession* _tmp67_;
				const gchar* _tmp68_;
				const gchar* _tmp69_;
				_tmp57_ = session;
				_tmp58_ = lightdm_session_get_key (_tmp57_);
				_tmp59_ = _tmp58_;
				_tmp60_ = session;
				_tmp61_ = lightdm_session_get_name (_tmp60_);
				_tmp62_ = _tmp61_;
				g_debug ("unity-greeter.vala:130: Adding session %s (%s)", _tmp59_, _tmp62_);
				_tmp63_ = self->user_list;
				_tmp64_ = session;
				_tmp65_ = lightdm_session_get_key (_tmp64_);
				_tmp66_ = _tmp65_;
				_tmp67_ = session;
				_tmp68_ = lightdm_session_get_name (_tmp67_);
				_tmp69_ = _tmp68_;
				user_list_add_session (_tmp63_, _tmp66_, _tmp69_);
			}
		}
	}
	_tmp70_ = unity_greeter_test_mode;
	if (_tmp70_) {
		UserList* _tmp71_;
		UserList* _tmp72_;
		UserList* _tmp73_;
		UserList* _tmp74_;
		const gchar* _tmp75_ = NULL;
		const gchar* _tmp76_;
		UserList* _tmp77_;
		const gchar* _tmp78_ = NULL;
		const gchar* _tmp79_;
		UserList* _tmp80_;
		UserList* _tmp81_;
		UserList* _tmp82_;
		const gchar* _tmp83_;
		_tmp71_ = self->user_list;
		user_list_add_entry (_tmp71_, "alice", "가나다라마", "/usr/share/backgrounds/Berries_by_Orb9220.jpg", TRUE);
		_tmp72_ = self->user_list;
		user_list_add_entry (_tmp72_, "bob", "Bob User", "/usr/share/backgrounds/White_flowers_by_Garuna_bor-bor.jpg", FALSE);
		_tmp73_ = self->user_list;
		user_list_add_entry (_tmp73_, "carol", "Carol User", "/usr/share/backgrounds/Bird_by_Magnus.jpg", FALSE);
		_tmp74_ = self->user_list;
		_tmp75_ = _ ("Guest Session");
		_tmp76_ = self->priv->default_background;
		user_list_add_entry (_tmp74_, "*guest", _tmp75_, _tmp76_, TRUE);
		_tmp77_ = self->user_list;
		_tmp78_ = _ ("Other...");
		_tmp79_ = self->priv->default_background;
		user_list_add_entry (_tmp77_, "*other", _tmp78_, _tmp79_, FALSE);
		_tmp80_ = self->user_list;
		user_list_add_session (_tmp80_, "gnome", "Ubuntu");
		_tmp81_ = self->user_list;
		user_list_add_session (_tmp81_, "gnome-shell", "GNOME");
		_tmp82_ = self->user_list;
		user_list_add_session (_tmp82_, "kde", "KDE");
		_tmp83_ = last_user;
		if (_tmp83_ != NULL) {
			UserList* _tmp84_;
			const gchar* _tmp85_;
			_tmp84_ = self->user_list;
			_tmp85_ = last_user;
			user_list_set_active_entry (_tmp84_, _tmp85_);
		}
	} else {
		LightDMGreeter* _tmp86_;
		gboolean _tmp87_;
		gboolean _tmp88_;
		LightDMGreeter* _tmp98_;
		gboolean _tmp99_;
		gboolean _tmp100_;
		UserList* _tmp104_;
		const gchar* _tmp105_ = NULL;
		const gchar* _tmp106_;
		LightDMGreeter* _tmp107_;
		const gchar* _tmp108_;
		const gchar* _tmp109_;
		_tmp86_ = self->priv->greeter;
		_tmp87_ = lightdm_greeter_get_hide_users_hint (_tmp86_);
		_tmp88_ = _tmp87_;
		if (!_tmp88_) {
			LightDMUserList* _tmp89_ = NULL;
			LightDMUserList* _tmp90_;
			LightDMUserList* users;
			LightDMUserList* _tmp91_;
			LightDMUserList* _tmp92_;
			LightDMUserList* _tmp93_;
			LightDMUserList* _tmp94_;
			GList* _tmp95_;
			GList* _tmp96_;
			_tmp89_ = lightdm_user_list_get_instance ();
			_tmp90_ = _g_object_ref0 (_tmp89_);
			users = _tmp90_;
			_tmp91_ = users;
			g_signal_connect (_tmp91_, "user-added", (GCallback) _unity_greeter_user_added_cb_lightdm_user_list_user_added, self);
			_tmp92_ = users;
			g_signal_connect (_tmp92_, "user-changed", (GCallback) _unity_greeter_user_added_cb_lightdm_user_list_user_changed, self);
			_tmp93_ = users;
			g_signal_connect (_tmp93_, "user-removed", (GCallback) _unity_greeter_user_removed_cb_lightdm_user_list_user_removed, self);
			_tmp94_ = users;
			_tmp95_ = lightdm_user_list_get_users (_tmp94_);
			_tmp96_ = _tmp95_;
			{
				GList* user_collection = NULL;
				GList* user_it = NULL;
				user_collection = _tmp96_;
				for (user_it = user_collection; user_it != NULL; user_it = user_it->next) {
					LightDMUser* user = NULL;
					user = (LightDMUser*) user_it->data;
					{
						LightDMUser* _tmp97_;
						_tmp97_ = user;
						unity_greeter_user_added_cb (self, _tmp97_);
					}
				}
			}
			_g_object_unref0 (users);
		}
		_tmp98_ = self->priv->greeter;
		_tmp99_ = lightdm_greeter_get_has_guest_account_hint (_tmp98_);
		_tmp100_ = _tmp99_;
		if (_tmp100_) {
			UserList* _tmp101_;
			const gchar* _tmp102_ = NULL;
			const gchar* _tmp103_;
			g_debug ("unity-greeter.vala:163: Adding guest account entry");
			_tmp101_ = self->user_list;
			_tmp102_ = _ ("Guest Session");
			_tmp103_ = self->priv->default_background;
			user_list_add_entry (_tmp101_, "*guest", _tmp102_, _tmp103_, FALSE);
		}
		g_debug ("unity-greeter.vala:167: Adding other entry");
		_tmp104_ = self->user_list;
		_tmp105_ = _ ("Other...");
		_tmp106_ = self->priv->default_background;
		user_list_add_entry (_tmp104_, "*other", _tmp105_, _tmp106_, FALSE);
		_tmp107_ = self->priv->greeter;
		_tmp108_ = lightdm_greeter_get_select_user_hint (_tmp107_);
		_tmp109_ = _tmp108_;
		if (_tmp109_ != NULL) {
			UserList* _tmp110_;
			LightDMGreeter* _tmp111_;
			const gchar* _tmp112_;
			const gchar* _tmp113_;
			_tmp110_ = self->user_list;
			_tmp111_ = self->priv->greeter;
			_tmp112_ = lightdm_greeter_get_select_user_hint (_tmp111_);
			_tmp113_ = _tmp112_;
			user_list_set_active_entry (_tmp110_, _tmp113_);
		} else {
			const gchar* _tmp114_;
			_tmp114_ = last_user;
			if (_tmp114_ != NULL) {
				UserList* _tmp115_;
				const gchar* _tmp116_;
				_tmp115_ = self->user_list;
				_tmp116_ = last_user;
				user_list_set_active_entry (_tmp115_, _tmp116_);
			}
		}
	}
	_tmp117_ = self->user_list;
	g_signal_connect (_tmp117_, "user-selected", (GCallback) _unity_greeter_user_selected_cb_user_list_user_selected, self);
	_tmp118_ = self->user_list;
	g_signal_connect (_tmp118_, "respond-to-prompt", (GCallback) _unity_greeter_respond_to_prompt_cb_user_list_respond_to_prompt, self);
	_tmp119_ = self->user_list;
	g_signal_connect (_tmp119_, "start-session", (GCallback) _unity_greeter_start_session_cb_user_list_start_session, self);
	_tmp120_ = self->user_list;
	_tmp121_ = user_list_get_selected (_tmp120_);
	_tmp122_ = _tmp121_;
	unity_greeter_user_selected_cb (self, _tmp122_);
	_g_free0 (last_user);
	_g_free0 (state_dir);
	return self;
}


UnityGreeter* unity_greeter_new (void) {
	return unity_greeter_construct (TYPE_UNITY_GREETER);
}


static void unity_greeter_monitors_changed_cb (UnityGreeter* self, GdkScreen* screen) {
	GdkRectangle geometry = {0};
	GdkScreen* _tmp0_;
	GdkScreen* _tmp1_;
	gint _tmp2_ = 0;
	GdkRectangle _tmp3_ = {0};
	GdkRectangle _tmp4_;
	gint _tmp5_;
	GdkRectangle _tmp6_;
	gint _tmp7_;
	GdkRectangle _tmp8_;
	gint _tmp9_;
	GdkRectangle _tmp10_;
	gint _tmp11_;
	GtkWindow* _tmp12_;
	GdkRectangle _tmp13_;
	gint _tmp14_;
	GdkRectangle _tmp15_;
	gint _tmp16_;
	GtkWindow* _tmp17_;
	GdkRectangle _tmp18_;
	gint _tmp19_;
	GdkRectangle _tmp20_;
	gint _tmp21_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (screen != NULL);
	_tmp0_ = screen;
	_tmp1_ = screen;
	_tmp2_ = gdk_screen_get_primary_monitor (_tmp1_);
	gdk_screen_get_monitor_geometry (_tmp0_, _tmp2_, &_tmp3_);
	geometry = _tmp3_;
	_tmp4_ = geometry;
	_tmp5_ = _tmp4_.width;
	_tmp6_ = geometry;
	_tmp7_ = _tmp6_.height;
	_tmp8_ = geometry;
	_tmp9_ = _tmp8_.x;
	_tmp10_ = geometry;
	_tmp11_ = _tmp10_.y;
	g_debug ("unity-greeter.vala:187: Monitor is %dx%d pixels at %d,%d", _tmp5_, _tmp7_, _tmp9_, _tmp11_);
	_tmp12_ = self->priv->main_window;
	_tmp13_ = geometry;
	_tmp14_ = _tmp13_.width;
	_tmp15_ = geometry;
	_tmp16_ = _tmp15_.height;
	gtk_window_resize (_tmp12_, _tmp14_, _tmp16_);
	_tmp17_ = self->priv->main_window;
	_tmp18_ = geometry;
	_tmp19_ = _tmp18_.x;
	_tmp20_ = geometry;
	_tmp21_ = _tmp20_.y;
	gtk_window_move (_tmp17_, _tmp19_, _tmp21_);
}


static void unity_greeter_user_added_cb (UnityGreeter* self, LightDMUser* user) {
	LightDMUser* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	LightDMUser* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	LightDMUser* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* label;
	LightDMUser* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	UserList* _tmp17_;
	LightDMUser* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	LightDMUser* _tmp23_;
	gboolean _tmp24_;
	gboolean _tmp25_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (user != NULL);
	_tmp0_ = user;
	_tmp1_ = lightdm_user_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = user;
	_tmp4_ = lightdm_user_get_real_name (_tmp3_);
	_tmp5_ = _tmp4_;
	g_debug ("unity-greeter.vala:195: Adding/updating user %s (%s)", _tmp2_, _tmp5_);
	_tmp6_ = user;
	_tmp7_ = lightdm_user_get_real_name (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strdup (_tmp8_);
	label = _tmp9_;
	_tmp10_ = user;
	_tmp11_ = lightdm_user_get_real_name (_tmp10_);
	_tmp12_ = _tmp11_;
	if (g_strcmp0 (_tmp12_, "") == 0) {
		LightDMUser* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp13_ = user;
		_tmp14_ = lightdm_user_get_name (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strdup (_tmp15_);
		_g_free0 (label);
		label = _tmp16_;
	}
	_tmp17_ = self->user_list;
	_tmp18_ = user;
	_tmp19_ = lightdm_user_get_name (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = label;
	_tmp22_ = self->priv->default_background;
	_tmp23_ = user;
	_tmp24_ = lightdm_user_get_logged_in (_tmp23_);
	_tmp25_ = _tmp24_;
	user_list_add_entry (_tmp17_, _tmp20_, _tmp21_, _tmp22_, _tmp25_);
	_g_free0 (label);
}


static void unity_greeter_user_removed_cb (UnityGreeter* self, LightDMUser* user) {
	LightDMUser* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	UserList* _tmp3_;
	LightDMUser* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (user != NULL);
	_tmp0_ = user;
	_tmp1_ = lightdm_user_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	g_debug ("unity-greeter.vala:205: Removing user %s", _tmp2_);
	_tmp3_ = self->user_list;
	_tmp4_ = user;
	_tmp5_ = lightdm_user_get_name (_tmp4_);
	_tmp6_ = _tmp5_;
	user_list_remove_entry (_tmp3_, _tmp6_);
}


void unity_greeter_show (UnityGreeter* self) {
	GtkWindow* _tmp0_;
	GtkWindow* _tmp1_;
	GdkWindow* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_debug ("unity-greeter.vala:211: Showing main window");
	_tmp0_ = self->priv->main_window;
	gtk_widget_show ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->main_window;
	_tmp2_ = gtk_widget_get_window ((GtkWidget*) _tmp1_);
	gdk_window_focus (_tmp2_, (guint32) GDK_CURRENT_TIME);
}


static void unity_greeter_update_session (UnityGreeter* self) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->have_session;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = unity_greeter_test_mode;
	if (_tmp1_) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		GQuark _tmp6_ = 0U;
		static GQuark _tmp5_label0 = 0;
		static GQuark _tmp5_label1 = 0;
		static GQuark _tmp5_label2 = 0;
		_tmp2_ = self->priv->test_username;
		if (_tmp2_ == NULL) {
			return;
		}
		_tmp3_ = self->priv->test_username;
		_tmp4_ = _tmp3_;
		_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
		if (_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("alice")))) {
			switch (0) {
				default:
				{
					UserList* _tmp7_;
					_tmp7_ = self->user_list;
					user_list_set_session (_tmp7_, "ubuntu");
					break;
				}
			}
		} else if (_tmp6_ == ((0 != _tmp5_label1) ? _tmp5_label1 : (_tmp5_label1 = g_quark_from_static_string ("bob")))) {
			switch (0) {
				default:
				{
					UserList* _tmp8_;
					_tmp8_ = self->user_list;
					user_list_set_session (_tmp8_, "gnome-shell");
					break;
				}
			}
		} else if (_tmp6_ == ((0 != _tmp5_label2) ? _tmp5_label2 : (_tmp5_label2 = g_quark_from_static_string ("carol")))) {
			switch (0) {
				default:
				{
					UserList* _tmp9_;
					_tmp9_ = self->user_list;
					user_list_set_session (_tmp9_, "kde");
					break;
				}
			}
		} else {
			switch (0) {
				default:
				{
					return;
				}
			}
		}
		self->priv->have_session = TRUE;
		return;
	} else {
		LightDMGreeter* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		LightDMUserList* _tmp13_ = NULL;
		LightDMGreeter* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		LightDMUser* _tmp17_ = NULL;
		LightDMUser* _tmp18_;
		LightDMUser* user;
		LightDMUser* _tmp19_;
		UserList* _tmp24_;
		LightDMUser* _tmp25_;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		_tmp10_ = self->priv->greeter;
		_tmp11_ = lightdm_greeter_get_authentication_user (_tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_ == NULL) {
			return;
		}
		_tmp13_ = lightdm_user_list_get_instance ();
		_tmp14_ = self->priv->greeter;
		_tmp15_ = lightdm_greeter_get_authentication_user (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = lightdm_user_list_get_user_by_name (_tmp13_, _tmp16_);
		_tmp18_ = _g_object_ref0 (_tmp17_);
		user = _tmp18_;
		_tmp19_ = user;
		if (_tmp19_ == NULL) {
			UserList* _tmp20_;
			LightDMGreeter* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			_tmp20_ = self->user_list;
			_tmp21_ = self->priv->greeter;
			_tmp22_ = lightdm_greeter_get_default_session_hint (_tmp21_);
			_tmp23_ = _tmp22_;
			user_list_set_session (_tmp20_, _tmp23_);
			_g_object_unref0 (user);
			return;
		}
		_tmp24_ = self->user_list;
		_tmp25_ = user;
		_tmp26_ = lightdm_user_get_session (_tmp25_);
		_tmp27_ = _tmp26_;
		user_list_set_session (_tmp24_, _tmp27_);
		self->priv->have_session = TRUE;
		_g_object_unref0 (user);
	}
}


static void unity_greeter_show_message_cb (UnityGreeter* self, const gchar* text, LightDMMessageType type) {
	UserList* _tmp0_;
	const gchar* _tmp1_;
	LightDMMessageType _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	unity_greeter_update_session (self);
	_tmp0_ = self->user_list;
	_tmp1_ = text;
	_tmp2_ = type;
	user_list_show_message (_tmp0_, _tmp1_, _tmp2_ == LIGHTDM_MESSAGE_TYPE_ERROR);
}


static void unity_greeter_show_prompt_cb (UnityGreeter* self, const gchar* text, LightDMPromptType type) {
	const gchar* _tmp0_;
	const gchar* _tmp2_;
	UserList* _tmp4_;
	const gchar* _tmp5_;
	LightDMPromptType _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	unity_greeter_update_session (self);
	unity_greeter_update_other_label (self);
	self->priv->prompted = TRUE;
	_tmp0_ = text;
	if (g_strcmp0 (_tmp0_, "Password: ") == 0) {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = _ ("Password:");
		text = _tmp1_;
	}
	_tmp2_ = text;
	if (g_strcmp0 (_tmp2_, "login:") == 0) {
		const gchar* _tmp3_ = NULL;
		_tmp3_ = _ ("Username:");
		text = _tmp3_;
	}
	_tmp4_ = self->user_list;
	_tmp5_ = text;
	_tmp6_ = type;
	user_list_show_prompt (_tmp4_, _tmp5_, _tmp6_ == LIGHTDM_PROMPT_TYPE_SECRET);
}


static void unity_greeter_background_loaded_cb (UnityGreeter* self, Background* background) {
	cairo_surface_t* _tmp0_;
	cairo_t* _tmp1_;
	cairo_t* c;
	cairo_t* _tmp2_;
	Background* _tmp3_;
	cairo_pattern_t* _tmp4_;
	cairo_t* _tmp5_;
	GdkScreen* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (background != NULL);
	_tmp0_ = unity_greeter_background_surface;
	_tmp1_ = cairo_create (_tmp0_);
	c = _tmp1_;
	_tmp2_ = c;
	_tmp3_ = background;
	_tmp4_ = _tmp3_->pattern;
	cairo_set_source (_tmp2_, _tmp4_);
	_tmp5_ = c;
	cairo_paint (_tmp5_);
	_cairo_destroy0 (c);
	c = NULL;
	_tmp6_ = gdk_screen_get_default ();
	unity_greeter_refresh_background (self, _tmp6_);
	{
		LightDMGreeter* _tmp7_;
		UserList* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp7_ = self->priv->greeter;
		_tmp8_ = self->user_list;
		_tmp9_ = user_list_get_session (_tmp8_);
		_tmp10_ = _tmp9_;
		lightdm_greeter_start_session_sync (_tmp7_, _tmp10_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_warning ("unity-greeter.vala:294: Failed to start session: %s", _tmp12_);
		_g_error_free0 (e);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_cairo_destroy0 (c);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_cairo_destroy0 (c);
}


static void _unity_greeter_background_loaded_cb_background_loaded (Background* _sender, gpointer self) {
	unity_greeter_background_loaded_cb (self, _sender);
}


static void unity_greeter_authentication_complete_cb (UnityGreeter* self) {
	gboolean is_authenticated = FALSE;
	gboolean _tmp0_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	unity_greeter_update_session (self);
	unity_greeter_update_other_label (self);
	_tmp0_ = unity_greeter_test_mode;
	if (_tmp0_) {
		gboolean _tmp1_;
		_tmp1_ = self->priv->test_is_authenticated;
		is_authenticated = _tmp1_;
	} else {
		LightDMGreeter* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = self->priv->greeter;
		_tmp3_ = lightdm_greeter_get_is_authenticated (_tmp2_);
		_tmp4_ = _tmp3_;
		is_authenticated = _tmp4_;
	}
	_tmp5_ = is_authenticated;
	if (_tmp5_) {
		gboolean _tmp6_;
		_tmp6_ = self->priv->prompted;
		if (_tmp6_) {
			UserList* _tmp7_;
			gboolean _tmp8_;
			_tmp7_ = self->user_list;
			user_list_login_complete (_tmp7_);
			_tmp8_ = unity_greeter_test_mode;
			if (_tmp8_) {
				UserList* _tmp9_;
				_tmp9_ = self->user_list;
				user_list_login_complete (_tmp9_);
			} else {
				UserList* _tmp10_;
				Background* _tmp11_ = NULL;
				Background* background;
				Background* _tmp12_;
				Background* _tmp13_;
				gboolean _tmp14_ = FALSE;
				_tmp10_ = self->user_list;
				_tmp11_ = user_list_get_background (_tmp10_);
				background = _tmp11_;
				_tmp12_ = background;
				g_signal_connect (_tmp12_, "loaded", (GCallback) _unity_greeter_background_loaded_cb_background_loaded, self);
				_tmp13_ = background;
				_tmp14_ = background_load (_tmp13_);
				if (_tmp14_) {
					Background* _tmp15_;
					_tmp15_ = background;
					unity_greeter_background_loaded_cb (self, _tmp15_);
				}
				_background_unref0 (background);
			}
		} else {
			UserList* _tmp16_;
			self->priv->prompted = TRUE;
			_tmp16_ = self->user_list;
			user_list_show_authenticated (_tmp16_);
		}
	} else {
		gboolean _tmp17_;
		_tmp17_ = self->priv->prompted;
		if (_tmp17_) {
			UserList* _tmp18_;
			const gchar* _tmp19_ = NULL;
			_tmp18_ = self->user_list;
			_tmp19_ = _ ("Invalid password, please try again");
			user_list_set_error (_tmp18_, _tmp19_);
			unity_greeter_start_authentication (self);
		} else {
			UserList* _tmp20_;
			const gchar* _tmp21_ = NULL;
			UserList* _tmp22_;
			_tmp20_ = self->user_list;
			_tmp21_ = _ ("Failed to authenticate");
			user_list_set_error (_tmp20_, _tmp21_);
			_tmp22_ = self->user_list;
			user_list_show_authenticated (_tmp22_);
		}
	}
}


static void unity_greeter_user_selected_cb (UnityGreeter* self, const gchar* username) {
	GKeyFile* _tmp0_;
	const gchar* _tmp1_;
	GKeyFile* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* data;
	const gchar* _tmp9_;
	UserList* _tmp10_;
	gboolean _tmp11_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->state;
	_tmp1_ = username;
	g_key_file_set_value (_tmp0_, "greeter", "last-user", _tmp1_);
	_tmp2_ = self->priv->state;
	_tmp3_ = g_key_file_to_data (_tmp2_, NULL, NULL);
	data = _tmp3_;
	{
		GFile* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp4_ = self->priv->state_file;
		_tmp5_ = strlen (data);
		_tmp6_ = _tmp5_;
		g_file_replace_contents (_tmp4_, data, (gsize) _tmp6_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_debug ("unity-greeter.vala:356: Failed to write state: %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		_g_free0 (data);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp9_ = username;
	g_debug ("unity-greeter.vala:359: Start authentication %s", _tmp9_);
	_tmp10_ = self->user_list;
	user_list_set_error (_tmp10_, NULL);
	_tmp11_ = unity_greeter_test_mode;
	if (_tmp11_) {
		UserList* _tmp12_;
		_tmp12_ = self->user_list;
		user_list_set_session (_tmp12_, "ubuntu");
	} else {
		UserList* _tmp13_;
		LightDMGreeter* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		_tmp13_ = self->user_list;
		_tmp14_ = self->priv->greeter;
		_tmp15_ = lightdm_greeter_get_default_session_hint (_tmp14_);
		_tmp16_ = _tmp15_;
		user_list_set_session (_tmp13_, _tmp16_);
	}
	unity_greeter_start_authentication (self);
	_g_free0 (data);
}


static void unity_greeter_update_other_label (UnityGreeter* self) {
	LightDMGreeter* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* text;
	gboolean _tmp5_;
	UserList* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->greeter;
	_tmp1_ = lightdm_greeter_get_hide_users_hint (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = _ ("Other...");
	_tmp4_ = g_strdup (_tmp3_);
	text = _tmp4_;
	_tmp5_ = unity_greeter_test_mode;
	if (_tmp5_) {
		gboolean _tmp6_ = FALSE;
		UserList* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gboolean _tmp11_;
		_tmp7_ = self->user_list;
		_tmp8_ = user_list_get_selected (_tmp7_);
		_tmp9_ = _tmp8_;
		if (g_strcmp0 (_tmp9_, "*other") == 0) {
			const gchar* _tmp10_;
			_tmp10_ = self->priv->test_username;
			_tmp6_ = _tmp10_ != NULL;
		} else {
			_tmp6_ = FALSE;
		}
		_tmp11_ = _tmp6_;
		if (_tmp11_) {
			const gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp12_ = self->priv->test_username;
			_tmp13_ = g_strdup (_tmp12_);
			_g_free0 (text);
			text = _tmp13_;
		}
	} else {
		gboolean _tmp14_ = FALSE;
		UserList* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		gboolean _tmp21_;
		_tmp15_ = self->user_list;
		_tmp16_ = user_list_get_selected (_tmp15_);
		_tmp17_ = _tmp16_;
		if (g_strcmp0 (_tmp17_, "*other") == 0) {
			LightDMGreeter* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			_tmp18_ = self->priv->greeter;
			_tmp19_ = lightdm_greeter_get_authentication_user (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp14_ = _tmp20_ != NULL;
		} else {
			_tmp14_ = FALSE;
		}
		_tmp21_ = _tmp14_;
		if (_tmp21_) {
			LightDMGreeter* _tmp22_;
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			gchar* _tmp25_;
			_tmp22_ = self->priv->greeter;
			_tmp23_ = lightdm_greeter_get_authentication_user (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = g_strdup (_tmp24_);
			_g_free0 (text);
			text = _tmp25_;
		}
	}
	_tmp26_ = self->user_list;
	_tmp27_ = text;
	_tmp28_ = self->priv->default_background;
	user_list_add_entry (_tmp26_, "*other", _tmp27_, _tmp28_, FALSE);
	_g_free0 (text);
}


static void unity_greeter_start_authentication (UnityGreeter* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->prompted = FALSE;
	self->priv->have_session = FALSE;
	_tmp0_ = unity_greeter_test_mode;
	if (_tmp0_) {
		UserList* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		_g_free0 (self->priv->test_username);
		self->priv->test_username = NULL;
		self->priv->test_is_authenticated = FALSE;
		_tmp1_ = self->user_list;
		_tmp2_ = user_list_get_selected (_tmp1_);
		_tmp3_ = _tmp2_;
		if (g_strcmp0 (_tmp3_, "*other") == 0) {
			const gchar* _tmp4_;
			_tmp4_ = self->priv->authenticate_user;
			if (_tmp4_ != NULL) {
				const gchar* _tmp5_;
				gchar* _tmp6_;
				const gchar* _tmp7_ = NULL;
				_tmp5_ = self->priv->authenticate_user;
				_tmp6_ = g_strdup (_tmp5_);
				_g_free0 (self->priv->test_username);
				self->priv->test_username = _tmp6_;
				_g_free0 (self->priv->authenticate_user);
				self->priv->authenticate_user = NULL;
				_tmp7_ = _ ("Password:");
				unity_greeter_show_prompt_cb (self, _tmp7_, LIGHTDM_PROMPT_TYPE_SECRET);
			} else {
				const gchar* _tmp8_ = NULL;
				_tmp8_ = _ ("Username:");
				unity_greeter_show_prompt_cb (self, _tmp8_, LIGHTDM_PROMPT_TYPE_QUESTION);
			}
		} else {
			UserList* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			_tmp9_ = self->user_list;
			_tmp10_ = user_list_get_selected (_tmp9_);
			_tmp11_ = _tmp10_;
			if (g_strcmp0 (_tmp11_, "*guest") == 0) {
				self->priv->test_is_authenticated = TRUE;
				unity_greeter_authentication_complete_cb (self);
			} else {
				UserList* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				_tmp12_ = self->user_list;
				_tmp13_ = user_list_get_selected (_tmp12_);
				_tmp14_ = _tmp13_;
				if (g_strcmp0 (_tmp14_, "bob") == 0) {
					UserList* _tmp15_;
					const gchar* _tmp16_;
					const gchar* _tmp17_;
					gchar* _tmp18_;
					self->priv->test_is_authenticated = TRUE;
					_tmp15_ = self->user_list;
					_tmp16_ = user_list_get_selected (_tmp15_);
					_tmp17_ = _tmp16_;
					_tmp18_ = g_strdup (_tmp17_);
					_g_free0 (self->priv->test_username);
					self->priv->test_username = _tmp18_;
					unity_greeter_authentication_complete_cb (self);
				} else {
					UserList* _tmp19_;
					const gchar* _tmp20_;
					const gchar* _tmp21_;
					gchar* _tmp22_;
					const gchar* _tmp23_ = NULL;
					_tmp19_ = self->user_list;
					_tmp20_ = user_list_get_selected (_tmp19_);
					_tmp21_ = _tmp20_;
					_tmp22_ = g_strdup (_tmp21_);
					_g_free0 (self->priv->test_username);
					self->priv->test_username = _tmp22_;
					_tmp23_ = _ ("Password:");
					unity_greeter_show_prompt_cb (self, _tmp23_, LIGHTDM_PROMPT_TYPE_SECRET);
				}
			}
		}
	} else {
		UserList* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		_tmp24_ = self->user_list;
		_tmp25_ = user_list_get_selected (_tmp24_);
		_tmp26_ = _tmp25_;
		if (g_strcmp0 (_tmp26_, "*other") == 0) {
			LightDMGreeter* _tmp27_;
			const gchar* _tmp28_;
			_tmp27_ = self->priv->greeter;
			_tmp28_ = self->priv->authenticate_user;
			lightdm_greeter_authenticate (_tmp27_, _tmp28_);
			_g_free0 (self->priv->authenticate_user);
			self->priv->authenticate_user = NULL;
		} else {
			UserList* _tmp29_;
			const gchar* _tmp30_;
			const gchar* _tmp31_;
			_tmp29_ = self->user_list;
			_tmp30_ = user_list_get_selected (_tmp29_);
			_tmp31_ = _tmp30_;
			if (g_strcmp0 (_tmp31_, "*guest") == 0) {
				LightDMGreeter* _tmp32_;
				_tmp32_ = self->priv->greeter;
				lightdm_greeter_authenticate_as_guest (_tmp32_);
			} else {
				LightDMGreeter* _tmp33_;
				UserList* _tmp34_;
				const gchar* _tmp35_;
				const gchar* _tmp36_;
				_tmp33_ = self->priv->greeter;
				_tmp34_ = self->user_list;
				_tmp35_ = user_list_get_selected (_tmp34_);
				_tmp36_ = _tmp35_;
				lightdm_greeter_authenticate (_tmp33_, _tmp36_);
			}
		}
	}
	unity_greeter_update_session (self);
	unity_greeter_update_other_label (self);
}


static void unity_greeter_respond_to_prompt_cb (UnityGreeter* self, const gchar* text) {
	UserList* _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = self->user_list;
	user_list_set_error (_tmp0_, NULL);
	_tmp1_ = unity_greeter_test_mode;
	if (_tmp1_) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = text;
		g_debug ("unity-greeter.vala:449: response %s", _tmp2_);
		_tmp3_ = self->priv->test_username;
		if (_tmp3_ == NULL) {
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			gchar* _tmp6_;
			const gchar* _tmp7_ = NULL;
			_tmp4_ = text;
			g_debug ("unity-greeter.vala:452: username=%s", _tmp4_);
			_tmp5_ = text;
			_tmp6_ = g_strdup (_tmp5_);
			_g_free0 (self->priv->test_username);
			self->priv->test_username = _tmp6_;
			_tmp7_ = _ ("Password:");
			unity_greeter_show_prompt_cb (self, _tmp7_, LIGHTDM_PROMPT_TYPE_SECRET);
		} else {
			const gchar* _tmp8_;
			_tmp8_ = text;
			self->priv->test_is_authenticated = g_strcmp0 (_tmp8_, "password") == 0;
			unity_greeter_authentication_complete_cb (self);
		}
	} else {
		LightDMGreeter* _tmp9_;
		const gchar* _tmp10_;
		_tmp9_ = self->priv->greeter;
		_tmp10_ = text;
		lightdm_greeter_respond (_tmp9_, _tmp10_);
	}
}


static void unity_greeter_start_session_cb (UnityGreeter* self) {
	gboolean is_authenticated;
	gboolean _tmp0_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	is_authenticated = FALSE;
	_tmp0_ = unity_greeter_test_mode;
	if (_tmp0_) {
		gboolean _tmp1_;
		_tmp1_ = self->priv->test_is_authenticated;
		is_authenticated = _tmp1_;
	} else {
		LightDMGreeter* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = self->priv->greeter;
		_tmp3_ = lightdm_greeter_get_is_authenticated (_tmp2_);
		_tmp4_ = _tmp3_;
		is_authenticated = _tmp4_;
	}
	_tmp5_ = is_authenticated;
	if (_tmp5_) {
		unity_greeter_authentication_complete_cb (self);
	} else {
		unity_greeter_start_authentication (self);
	}
}


gchar* unity_greeter_get_config_value (const gchar* group_name, const gchar* key, const gchar* _default_) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (group_name != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	{
		GKeyFile* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		_tmp0_ = unity_greeter_config;
		_tmp1_ = group_name;
		_tmp2_ = key;
		_tmp3_ = g_key_file_get_value (_tmp0_, _tmp1_, _tmp2_, &_inner_error_);
		_tmp4_ = _tmp3_;
		if (_inner_error_ != NULL) {
			goto __catch6_g_error;
		}
		result = _tmp4_;
		return result;
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		gboolean _tmp5_ = FALSE;
		GError* _tmp6_;
		gboolean _tmp8_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = e;
		if (g_error_matches (_tmp6_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_KEY_NOT_FOUND)) {
			_tmp5_ = TRUE;
		} else {
			GError* _tmp7_;
			_tmp7_ = e;
			_tmp5_ = g_error_matches (_tmp7_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_GROUP_NOT_FOUND);
		}
		_tmp8_ = _tmp5_;
		if (!_tmp8_) {
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			GError* _tmp11_;
			const gchar* _tmp12_;
			_tmp9_ = group_name;
			_tmp10_ = key;
			_tmp11_ = e;
			_tmp12_ = _tmp11_->message;
			g_warning ("unity-greeter.vala:490: Error reading configuration item %s:%s: %s", _tmp9_, _tmp10_, _tmp12_);
		}
		_tmp13_ = _default_;
		_tmp14_ = g_strdup (_tmp13_);
		result = _tmp14_;
		_g_error_free0 (e);
		return result;
	}
	__finally6:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


static cairo_surface_t* unity_greeter_create_root_surface (GdkScreen* screen) {
	cairo_surface_t* result = NULL;
	GdkScreen* _tmp0_;
	GdkVisual* _tmp1_ = NULL;
	GdkVisual* _tmp2_;
	GdkVisual* visual;
	GdkScreen* _tmp3_;
	GdkDisplay* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	Display* _tmp6_;
	Display* display;
	Display* _tmp7_;
	Display* _tmp8_;
	Display* _tmp9_;
	GdkScreen* _tmp10_;
	GdkWindow* _tmp11_ = NULL;
	Window _tmp12_ = 0;
	GdkScreen* _tmp13_;
	gint _tmp14_ = 0;
	GdkScreen* _tmp15_;
	gint _tmp16_ = 0;
	GdkVisual* _tmp17_;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gint pixmap;
	GdkScreen* _tmp20_;
	GdkDisplay* _tmp21_ = NULL;
	Display* _tmp22_ = NULL;
	Display* xdisplay;
	Display* _tmp23_;
	gint _tmp24_;
	GdkVisual* _tmp25_;
	Visual* _tmp26_ = NULL;
	GdkScreen* _tmp27_;
	gint _tmp28_ = 0;
	GdkScreen* _tmp29_;
	gint _tmp30_ = 0;
	cairo_surface_t* _tmp31_;
	cairo_surface_t* surface;
	Display* _tmp32_;
	GdkScreen* _tmp33_;
	GdkWindow* _tmp34_ = NULL;
	Window _tmp35_ = 0;
	cairo_surface_t* _tmp36_;
	gint _tmp37_ = 0;
	g_return_val_if_fail (screen != NULL, NULL);
	_tmp0_ = screen;
	_tmp1_ = gdk_screen_get_system_visual (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	visual = _tmp2_;
	gdk_flush ();
	_tmp3_ = screen;
	_tmp4_ = gdk_screen_get_display (_tmp3_);
	_tmp5_ = gdk_display_get_name (_tmp4_);
	_tmp6_ = XOpenDisplay (_tmp5_);
	display = _tmp6_;
	_tmp7_ = display;
	if (_tmp7_ == NULL) {
		g_warning ("unity-greeter.vala:504: Failed to create root pixmap");
		result = NULL;
		_XCloseDisplay0 (display);
		_g_object_unref0 (visual);
		return result;
	}
	_tmp8_ = display;
	XSetCloseDownMode (_tmp8_, RetainPermanent);
	_tmp9_ = display;
	_tmp10_ = screen;
	_tmp11_ = gdk_screen_get_root_window (_tmp10_);
	_tmp12_ = gdk_x11_window_get_xid (_tmp11_);
	_tmp13_ = screen;
	_tmp14_ = gdk_screen_width ();
	_tmp15_ = screen;
	_tmp16_ = gdk_screen_height ();
	_tmp17_ = visual;
	_tmp18_ = gdk_visual_get_depth (_tmp17_);
	_tmp19_ = XCreatePixmap (_tmp9_, (Drawable) _tmp12_, (guint) _tmp14_, (guint) _tmp16_, (guint) _tmp18_);
	pixmap = _tmp19_;
	_tmp20_ = screen;
	_tmp21_ = gdk_screen_get_display (_tmp20_);
	_tmp22_ = gdk_x11_display_get_xdisplay (_tmp21_);
	xdisplay = _tmp22_;
	_tmp23_ = xdisplay;
	_tmp24_ = pixmap;
	_tmp25_ = visual;
	_tmp26_ = gdk_x11_visual_get_xvisual (_tmp25_);
	_tmp27_ = screen;
	_tmp28_ = gdk_screen_width ();
	_tmp29_ = screen;
	_tmp30_ = gdk_screen_height ();
	_tmp31_ = cairo_xlib_surface_create (_tmp23_, _tmp24_, _tmp26_, _tmp28_, _tmp30_);
	surface = _tmp31_;
	_tmp32_ = xdisplay;
	_tmp33_ = screen;
	_tmp34_ = gdk_screen_get_root_window (_tmp33_);
	_tmp35_ = gdk_x11_window_get_xid (_tmp34_);
	_tmp36_ = surface;
	_tmp37_ = cairo_xlib_surface_get_drawable (_tmp36_);
	XSetWindowBackgroundPixmap (_tmp32_, _tmp35_, _tmp37_);
	result = surface;
	_XCloseDisplay0 (display);
	_g_object_unref0 (visual);
	return result;
}


static void unity_greeter_refresh_background (UnityGreeter* self, GdkScreen* screen) {
	GdkScreen* _tmp0_;
	GdkDisplay* _tmp1_ = NULL;
	Display* _tmp2_ = NULL;
	GdkScreen* _tmp3_;
	GdkWindow* _tmp4_ = NULL;
	Window _tmp5_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (screen != NULL);
	gdk_flush ();
	_tmp0_ = screen;
	_tmp1_ = gdk_screen_get_display (_tmp0_);
	_tmp2_ = gdk_x11_display_get_xdisplay (_tmp1_);
	_tmp3_ = screen;
	_tmp4_ = gdk_screen_get_root_window (_tmp3_);
	_tmp5_ = gdk_x11_window_get_xid (_tmp4_);
	XClearWindow (_tmp2_, _tmp5_);
}


static void unity_greeter_log_cb (const gchar* log_domain, GLogLevelFlags log_level, const gchar* message) {
	gchar* prefix = NULL;
	GLogLevelFlags _tmp0_;
	FILE* _tmp8_;
	GTimer* _tmp9_;
	gdouble _tmp10_ = 0.0;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	g_return_if_fail (message != NULL);
	_tmp0_ = log_level;
	switch (_tmp0_ & G_LOG_LEVEL_MASK) {
		case G_LOG_LEVEL_ERROR:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("ERROR:");
			_g_free0 (prefix);
			prefix = _tmp1_;
			break;
		}
		case G_LOG_LEVEL_CRITICAL:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("CRITICAL:");
			_g_free0 (prefix);
			prefix = _tmp2_;
			break;
		}
		case G_LOG_LEVEL_WARNING:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("WARNING:");
			_g_free0 (prefix);
			prefix = _tmp3_;
			break;
		}
		case G_LOG_LEVEL_MESSAGE:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("MESSAGE:");
			_g_free0 (prefix);
			prefix = _tmp4_;
			break;
		}
		case G_LOG_LEVEL_INFO:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("INFO:");
			_g_free0 (prefix);
			prefix = _tmp5_;
			break;
		}
		case G_LOG_LEVEL_DEBUG:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("DEBUG:");
			_g_free0 (prefix);
			prefix = _tmp6_;
			break;
		}
		default:
		{
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("LOG:");
			_g_free0 (prefix);
			prefix = _tmp7_;
			break;
		}
	}
	_tmp8_ = stderr;
	_tmp9_ = unity_greeter_log_timer;
	_tmp10_ = g_timer_elapsed (_tmp9_, NULL);
	_tmp11_ = prefix;
	_tmp12_ = message;
	fprintf (_tmp8_, "[%+.2fs] %s %s\n", _tmp10_, _tmp11_, _tmp12_);
	_g_free0 (prefix);
}


static void _unity_greeter_log_cb_glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self) {
	unity_greeter_log_cb (log_domain, log_levels, message);
}


static gdouble double_parse (const gchar* str) {
	gdouble result = 0.0;
	const gchar* _tmp0_;
	gdouble _tmp1_ = 0.0;
	g_return_val_if_fail (str != NULL, 0.0);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtod (_tmp0_, NULL);
	result = _tmp1_;
	return result;
}


gint unity_greeter_main (gchar** args, int args_length1) {
	gint result = 0;
	GTimer* _tmp0_;
	uid_t _tmp1_ = {0};
	const gchar* _tmp2_ = NULL;
	GdkWindow* _tmp3_ = NULL;
	GdkCursor* _tmp4_;
	GdkCursor* _tmp5_;
	GdkScreen* _tmp6_ = NULL;
	cairo_surface_t* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GOptionContext* _tmp9_;
	GOptionContext* c;
	GOptionContext* _tmp10_;
	GOptionContext* _tmp11_;
	GOptionGroup* _tmp12_ = NULL;
	gboolean _tmp22_;
	gboolean _tmp24_;
	GKeyFile* _tmp25_;
	GtkSettings* _tmp30_ = NULL;
	GtkSettings* _tmp31_;
	GtkSettings* settings;
	gchar* _tmp32_ = NULL;
	gchar* value;
	const gchar* _tmp33_;
	gchar* _tmp36_ = NULL;
	const gchar* _tmp37_;
	gchar* _tmp40_ = NULL;
	const gchar* _tmp41_;
	gchar* _tmp44_ = NULL;
	const gchar* _tmp45_;
	gchar* _tmp49_ = NULL;
	const gchar* _tmp50_;
	gchar* _tmp55_ = NULL;
	const gchar* _tmp56_;
	gchar* _tmp59_ = NULL;
	const gchar* _tmp60_;
	UnityGreeter* _tmp63_;
	UnityGreeter* greeter;
	UnityGreeter* _tmp64_;
	GError * _inner_error_ = NULL;
	g_unsetenv ("UBUNTU_MENUPROXY");
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	gtk_init (&args_length1, &args);
	_tmp0_ = g_timer_new ();
	_g_timer_destroy0 (unity_greeter_log_timer);
	unity_greeter_log_timer = _tmp0_;
	g_log_set_default_handler (_unity_greeter_log_cb_glog_func, NULL);
	_tmp1_ = getuid ();
	_tmp2_ = g_getenv ("LANG");
	g_debug ("unity-greeter.vala:583: Starting unity-greeter %s UID=%d LANG=%s", VERSION, (gint) _tmp1_, _tmp2_);
	g_debug ("unity-greeter.vala:586: Setting cursor");
	_tmp3_ = gdk_get_default_root_window ();
	_tmp4_ = gdk_cursor_new (GDK_LEFT_PTR);
	_tmp5_ = _tmp4_;
	gdk_window_set_cursor (_tmp3_, _tmp5_);
	_g_object_unref0 (_tmp5_);
	g_debug ("unity-greeter.vala:590: Creating background surface");
	_tmp6_ = gdk_screen_get_default ();
	_tmp7_ = unity_greeter_create_root_surface (_tmp6_);
	_cairo_surface_destroy0 (unity_greeter_background_surface);
	unity_greeter_background_surface = _tmp7_;
	g_debug ("unity-greeter.vala:593: Loading command line options");
	_tmp8_ = _ ("- Unity Greeter");
	_tmp9_ = g_option_context_new (_tmp8_);
	c = _tmp9_;
	_tmp10_ = c;
	g_option_context_add_main_entries (_tmp10_, UNITY_GREETER_options, GETTEXT_PACKAGE);
	_tmp11_ = c;
	_tmp12_ = gtk_get_option_group (TRUE);
	g_option_context_add_group (_tmp11_, _tmp12_);
	{
		GOptionContext* _tmp13_;
		_tmp13_ = c;
		g_option_context_parse (_tmp13_, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		FILE* _tmp14_;
		GError* _tmp15_;
		const gchar* _tmp16_;
		FILE* _tmp17_;
		const gchar* _tmp18_ = NULL;
		gchar** _tmp19_;
		gint _tmp19__length1;
		const gchar* _tmp20_;
		FILE* _tmp21_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp14_ = stderr;
		_tmp15_ = e;
		_tmp16_ = _tmp15_->message;
		fprintf (_tmp14_, "%s\n", _tmp16_);
		_tmp17_ = stderr;
		_tmp18_ = _ ("Run '%s --help' to see a full list of available command line options.");
		_tmp19_ = args;
		_tmp19__length1 = args_length1;
		_tmp20_ = _tmp19_[0];
		fprintf (_tmp17_, _tmp18_, _tmp20_);
		_tmp21_ = stderr;
		fprintf (_tmp21_, "\n");
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_g_option_context_free0 (c);
		return result;
	}
	__finally7:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (c);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp22_ = unity_greeter_show_version;
	if (_tmp22_) {
		FILE* _tmp23_;
		_tmp23_ = stderr;
		fprintf (_tmp23_, "unity-greeter %s\n", VERSION);
		result = EXIT_SUCCESS;
		_g_option_context_free0 (c);
		return result;
	}
	_tmp24_ = unity_greeter_test_mode;
	if (_tmp24_) {
		g_debug ("unity-greeter.vala:618: Running in test mode");
	}
	g_debug ("unity-greeter.vala:620: Loading configuration from %s", CONFIG_FILE);
	_tmp25_ = g_key_file_new ();
	_g_key_file_free0 (unity_greeter_config);
	unity_greeter_config = _tmp25_;
	{
		GKeyFile* _tmp26_;
		_tmp26_ = unity_greeter_config;
		g_key_file_load_from_file (_tmp26_, CONFIG_FILE, G_KEY_FILE_NONE, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch8_g_error;
		}
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
		GError* _tmp27_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp27_ = e;
		if (!g_error_matches (_tmp27_, G_FILE_ERROR, G_FILE_ERROR_NOENT)) {
			GError* _tmp28_;
			const gchar* _tmp29_;
			_tmp28_ = e;
			_tmp29_ = _tmp28_->message;
			g_warning ("unity-greeter.vala:629: Failed to load configuration from %s: %s\n", CONFIG_FILE, _tmp29_);
		}
		_g_error_free0 (e);
	}
	__finally8:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (c);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	g_debug ("unity-greeter.vala:633: Setting GTK+ settings");
	_tmp30_ = gtk_settings_get_default ();
	_tmp31_ = _g_object_ref0 (_tmp30_);
	settings = _tmp31_;
	_tmp32_ = unity_greeter_get_config_value ("greeter", "theme-name", NULL);
	value = _tmp32_;
	_tmp33_ = value;
	if (_tmp33_ != NULL) {
		GtkSettings* _tmp34_;
		const gchar* _tmp35_;
		_tmp34_ = settings;
		_tmp35_ = value;
		g_object_set ((GObject*) _tmp34_, "gtk-theme-name", _tmp35_, NULL, NULL);
	}
	_tmp36_ = unity_greeter_get_config_value ("greeter", "icon-theme-name", NULL);
	_g_free0 (value);
	value = _tmp36_;
	_tmp37_ = value;
	if (_tmp37_ != NULL) {
		GtkSettings* _tmp38_;
		const gchar* _tmp39_;
		_tmp38_ = settings;
		_tmp39_ = value;
		g_object_set ((GObject*) _tmp38_, "gtk-icon-theme-name", _tmp39_, NULL, NULL);
	}
	_tmp40_ = unity_greeter_get_config_value ("greeter", "font-name", NULL);
	_g_free0 (value);
	value = _tmp40_;
	_tmp41_ = value;
	if (_tmp41_ != NULL) {
		GtkSettings* _tmp42_;
		const gchar* _tmp43_;
		_tmp42_ = settings;
		_tmp43_ = value;
		g_object_set ((GObject*) _tmp42_, "gtk-font-name", _tmp43_, NULL, NULL);
	}
	_tmp44_ = unity_greeter_get_config_value ("greeter", "xft-dpi", NULL);
	_g_free0 (value);
	value = _tmp44_;
	_tmp45_ = value;
	if (_tmp45_ != NULL) {
		GtkSettings* _tmp46_;
		const gchar* _tmp47_;
		gdouble _tmp48_ = 0.0;
		_tmp46_ = settings;
		_tmp47_ = value;
		_tmp48_ = double_parse (_tmp47_);
		g_object_set ((GObject*) _tmp46_, "gtk-xft-dpi", (gint) (1024 * _tmp48_), NULL, NULL);
	}
	_tmp49_ = unity_greeter_get_config_value ("greeter", "xft-antialias", NULL);
	_g_free0 (value);
	value = _tmp49_;
	_tmp50_ = value;
	if (_tmp50_ != NULL) {
		GtkSettings* _tmp51_;
		GCompareFunc _tmp52_;
		const gchar* _tmp53_;
		gint _tmp54_ = 0;
		_tmp51_ = settings;
		_tmp52_ = g_strcmp0;
		_tmp53_ = value;
		_tmp54_ = _tmp52_ (_tmp53_, "true");
		g_object_set ((GObject*) _tmp51_, "gtk-xft-antialias", _tmp54_ == 0, NULL, NULL);
	}
	_tmp55_ = unity_greeter_get_config_value ("greeter", "xft-hintstyle", NULL);
	_g_free0 (value);
	value = _tmp55_;
	_tmp56_ = value;
	if (_tmp56_ != NULL) {
		GtkSettings* _tmp57_;
		const gchar* _tmp58_;
		_tmp57_ = settings;
		_tmp58_ = value;
		g_object_set ((GObject*) _tmp57_, "gtk-xft-hintstyle", _tmp58_, NULL, NULL);
	}
	_tmp59_ = unity_greeter_get_config_value ("greeter", "xft-rgba", NULL);
	_g_free0 (value);
	value = _tmp59_;
	_tmp60_ = value;
	if (_tmp60_ != NULL) {
		GtkSettings* _tmp61_;
		const gchar* _tmp62_;
		_tmp61_ = settings;
		_tmp62_ = value;
		g_object_set ((GObject*) _tmp61_, "gtk-xft-rgba", _tmp62_, NULL, NULL);
	}
	g_debug ("unity-greeter.vala:657: Creating Unity Greeter");
	_tmp63_ = unity_greeter_new ();
	greeter = _tmp63_;
	g_debug ("unity-greeter.vala:660: Showing greeter");
	_tmp64_ = greeter;
	unity_greeter_show (_tmp64_);
	g_debug ("unity-greeter.vala:663: Starting main loop");
	gtk_main ();
	result = EXIT_SUCCESS;
	_unity_greeter_unref0 (greeter);
	_g_free0 (value);
	_g_object_unref0 (settings);
	_g_option_context_free0 (c);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return unity_greeter_main (argv, argc);
}


static void value_unity_greeter_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_unity_greeter_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		unity_greeter_unref (value->data[0].v_pointer);
	}
}


static void value_unity_greeter_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = unity_greeter_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_unity_greeter_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_unity_greeter_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		UnityGreeter* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = unity_greeter_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_unity_greeter_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	UnityGreeter** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = unity_greeter_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_unity_greeter (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecUnityGreeter* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_UNITY_GREETER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_unity_greeter (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_UNITY_GREETER), NULL);
	return value->data[0].v_pointer;
}


void value_set_unity_greeter (GValue* value, gpointer v_object) {
	UnityGreeter* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_UNITY_GREETER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_UNITY_GREETER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		unity_greeter_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		unity_greeter_unref (old);
	}
}


void value_take_unity_greeter (GValue* value, gpointer v_object) {
	UnityGreeter* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_UNITY_GREETER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_UNITY_GREETER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		unity_greeter_unref (old);
	}
}


static void unity_greeter_class_init (UnityGreeterClass * klass) {
	unity_greeter_parent_class = g_type_class_peek_parent (klass);
	UNITY_GREETER_CLASS (klass)->finalize = unity_greeter_finalize;
	g_type_class_add_private (klass, sizeof (UnityGreeterPrivate));
}


static void unity_greeter_instance_init (UnityGreeter * self) {
	self->priv = UNITY_GREETER_GET_PRIVATE (self);
	self->priv->prompted = FALSE;
	self->priv->have_session = FALSE;
	self->priv->authenticate_user = NULL;
	self->priv->test_username = NULL;
	self->priv->test_is_authenticated = FALSE;
	self->ref_count = 1;
}


static void unity_greeter_finalize (UnityGreeter* obj) {
	UnityGreeter * self;
	self = UNITY_GREETER (obj);
	_g_object_unref0 (self->priv->state_file);
	_g_key_file_free0 (self->priv->state);
	_g_object_unref0 (self->priv->settings_daemon);
	_g_free0 (self->priv->default_background);
	_g_object_unref0 (self->user_list);
	_g_object_unref0 (self->priv->main_window);
	_g_object_unref0 (self->priv->greeter);
	_g_free0 (self->priv->authenticate_user);
	_g_free0 (self->priv->test_username);
}


GType unity_greeter_get_type (void) {
	static volatile gsize unity_greeter_type_id__volatile = 0;
	if (g_once_init_enter (&unity_greeter_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_unity_greeter_init, value_unity_greeter_free_value, value_unity_greeter_copy_value, value_unity_greeter_peek_pointer, "p", value_unity_greeter_collect_value, "p", value_unity_greeter_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (UnityGreeterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_greeter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityGreeter), 0, (GInstanceInitFunc) unity_greeter_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType unity_greeter_type_id;
		unity_greeter_type_id = g_type_register_fundamental (g_type_fundamental_next (), "UnityGreeter", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&unity_greeter_type_id__volatile, unity_greeter_type_id);
	}
	return unity_greeter_type_id__volatile;
}


gpointer unity_greeter_ref (gpointer instance) {
	UnityGreeter* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void unity_greeter_unref (gpointer instance) {
	UnityGreeter* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		UNITY_GREETER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



