# ubuntuone.storageprotocol.tests.test_query -
#     query tests
#
# Author: John R. Lenton <john.lenton@canonical.com>
#
# Copyright (C) 2009 Canonical
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU Affero General Public License version 3,
# as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""Tests for querying lots of items"""

import unittest
from ubuntuone.storageprotocol.client import MultiQuery
import os


class TestQuery10(unittest.TestCase):
    """
    Check that MultiQuery works using an iterator
    """
    N = 10

    def test_query_many(self):
        """
        Check the lenght is right. Not much more we can compare, is there?
        """
        # larger than real ids and hashes, and also randomer than real, so we
        # can get away with creating less queries per Query
        a_id = os.urandom(1024)
        b_id = os.urandom(1024)
        a_hash = os.urandom(1024)
        items = [(a_id, b_id, a_hash) for _ in xrange(self.N)]
        multi_query_list = MultiQuery(None, items)
        multi_query_iter = MultiQuery(None, iter(items))
        self.assertEqual(len(multi_query_list.queries),
                         len(multi_query_iter.queries))


class TestQuery1000(TestQuery10):
    """
    Check with even more queries
    """
    N = 1000

if __name__ == '__main__':
    unittest.main()
