/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*-
 * 
 * Authors: Alejandro J. Cura <alecu@canonical.com>
 *
 * Copyright (C) 2010 Canonical Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#include "config.h"

#include <stdlib.h>
#include <libintl.h>
#include <locale.h>
#include <string.h>
#include <unistd.h>

#include <glib/gi18n.h>
#include <gtk/gtk.h>

#include "gsd-ubuntuone.h"

static gboolean
idle (GsdUbuntuOne *plugin)
{
        gsd_ubuntuone_activate ((GnomeSettingsPlugin *) plugin);
        return FALSE;
}

int
main (int argc, char *argv[])
{
        GsdUbuntuOne *plugin;

        bindtextdomain (GETTEXT_PACKAGE, GNOME_SETTINGS_LOCALEDIR);
        bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
        textdomain (GETTEXT_PACKAGE);

        setlocale (LC_ALL, "");

        gtk_init (&argc, &argv);

        plugin = g_object_new (GSD_TYPE_UBUNTUONE, NULL);
        g_idle_add ((GSourceFunc)idle, plugin);

        gtk_main ();

        return 0;
}
