# -*- coding: utf-8 -*-
#
# Author: Manuel de la Pena<manuel@canonical.com>
#
# Copyright 2011 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.
"""Test that the interaction_interfaces are correctly called."""

from mocker import MockerTestCase, MATCH
from tests.platform import IPCTestCase

class TestStatusIPC(MockerTestCase, IPCTestCase):
    """Ensure that calls are correctly fowarded."""

    def setUp(self):
        """Set up tests."""
        super(TestStatusIPC, self).setUp()
        self.syncdaemon_status = self.mocker.mock()
        self.status.syncdaemon_status = self.syncdaemon_status

    def test_current_status(self):
        """Test if the method is relayed."""
        result = 'status'
        self.syncdaemon_status.current_status()
        self.mocker.result(result)
        self.mocker.replay()
        self.assertEqual(result, self.status.current_status())

    def test_current_downloads(self):
        """Test if the method is relayed."""
        result = 'downloads'
        self.syncdaemon_status.current_downloads()
        self.mocker.result(result)
        self.mocker.replay()
        self.assertEqual(result, self.status.current_downloads())

    def test_waiting_simple(self):
        """Test if the method is relayed."""
        result = []
        self.syncdaemon_status.waiting()
        self.mocker.result(result)
        self.mocker.replay()
        self.assertEqual(result, self.status.waiting())

    def test_waiting_metadata(self):
        """Test if the method is relayed."""
        result = []
        self.syncdaemon_status.waiting_metadata()
        self.mocker.result(result)
        self.mocker.replay()
        self.assertEqual(result, self.status.waiting_metadata())

    def test_waiting_content(self):
        """Test if the method is relayed."""
        result = []
        self.syncdaemon_status.waiting_content()
        self.mocker.result(result)
        self.mocker.replay()
        self.assertEqual(result, self.status.waiting_content())

    def test_current_uploads(self):
        """Test if the method is relayed."""
        result = 'uploading'
        self.syncdaemon_status.current_uploads()
        self.mocker.result(result)
        self.mocker.replay()
        self.assertEqual(result, self.status.current_uploads())


class TestEventsIPC(MockerTestCase, IPCTestCase):
    """Ensure that calls are correctly fowarded."""

    def setUp(self):
        """Set up tests."""
        super(TestEventsIPC, self).setUp()
        self.events_mock = self.mocker.mock()
        self.events.events = self.events_mock

    def test_push_event(self):
        """Test if the method is relayed."""
        event_name = 'name'
        args = ('uno', 'dos')
        self.events_mock.push_event(event_name, args)
        self.mocker.replay()
        self.events.push_event(event_name, args)


class TestSyncDaemonIPC(MockerTestCase, IPCTestCase):
    """Ensure that calls are correctly fowarded."""

    def setUp(self):
        """Set up tests."""
        super(TestSyncDaemonIPC, self).setUp()
        self.service = self.mocker.mock()
        self.sync.service = self.service

    def test_connect(self):
        """Test if the method is relayed."""
        self.service.connect()
        self.mocker.replay()
        self.sync.connect()

    def test_disconnect(self):
        """Test if the method is relayed."""
        self.service.disconnect()
        self.mocker.replay()
        self.sync.disconnect()

    def test_get_rootdir(self):
        """Test if the method is relayed."""
        result = 'root'
        self.service.get_rootdir()
        self.mocker.result(result)
        self.mocker.replay()
        self.assertEqual(result, self.sync.get_rootdir())

    def test_get_sharesdir(self):
        """Test if the method is relayed."""
        result = 'shares'
        self.service.get_sharesdir()
        self.mocker.result(result)
        self.mocker.replay()
        self.assertEqual(result, self.sync.get_sharesdir())

    def test_get_sharesdir_link(self):
        """Test if the method is relayed."""
        result = 'shares'
        self.service.get_sharesdir_link()
        self.mocker.result(result)
        self.mocker.replay()
        self.assertEqual(result, self.sync.get_sharesdir_link())

    def test_wait_for_nirvana(self):
        """Test if the method is relayed."""
        result = 'nirvana'
        last_event_interval = 'interval'
        reply_handler = lambda: None
        error_handler = lambda: None
        self.service.wait_for_nirvana(last_event_interval, MATCH(callable),
            MATCH(callable))
        self.mocker.result(result)
        self.mocker.replay()
        self.assertEqual(result, self.sync.wait_for_nirvana(
            last_event_interval, reply_handler, error_handler))

    def test_quit(self):
        """Test if the method is relayed."""
        reply_handler = lambda: None
        error_handler = lambda: None
        self.service.quit(MATCH(callable), MATCH(callable))
        self.mocker.replay()
        self.sync.quit(reply_handler, error_handler)

    def test_rescan_from_scratch(self):
        """Test if the method is relayed."""
        volume_id = 'id'
        self.service.rescan_from_scratch(volume_id)
        self.mocker.replay()
        self.sync.rescan_from_scratch(volume_id)


class TestFileSystemIPC(MockerTestCase, IPCTestCase):
    """Ensure that calls are correctly fowarded."""

    def setUp(self):
        """Set up tests."""
        super(TestFileSystemIPC, self).setUp()
        self.syncdaemon_filesystem = self.mocker.mock()
        self.fs.syncdaemon_filesystem = self.syncdaemon_filesystem

    def test_get_metadata(self):
        """Test if the method is relayed."""
        result = 'matadata'
        path = 'path'
        self.syncdaemon_filesystem.get_metadata(path)
        self.mocker.result(result)
        self.mocker.replay()
        self.assertEqual(result, self.fs.get_metadata(path))

    def test_get_metadata_by_node(self):
        """Test if the method is relayed."""
        result = 'matadata'
        share_id = 'share'
        node_id = 'node'
        self.syncdaemon_filesystem.get_metadata_by_node(share_id, node_id)
        self.mocker.result(result)
        self.mocker.replay()
        self.assertEqual(result, self.fs.get_metadata_by_node(
            share_id, node_id))

    def test_get_metadata_and_quick_tree_synced(self):
        """Test if the method is relayed."""
        result = 'matadata'
        path = 'path'
        self.syncdaemon_filesystem.get_metadata_and_quick_tree_synced(path)
        self.mocker.result(result)
        self.mocker.replay()
        self.assertEqual(result, self.fs.get_metadata_and_quick_tree_synced(
            path))

    def test_get_dirty_nodes(self):
        """Test if the method is relayed."""
        result = 'dirty'
        self.syncdaemon_filesystem.get_dirty_nodes()
        self.mocker.result(result)
        self.mocker.replay()
        self.assertEqual(result, self.fs.get_dirty_nodes())

class TestSharesIPC(MockerTestCase, IPCTestCase):
    """Ensure that calls are correctly fowarded."""

    def setUp(self):
        """Set up tests."""
        super(TestSharesIPC, self).setUp()
        self.syncdaemon_shares = self.mocker.mock()
        self.shares.syncdaemon_shares = self.syncdaemon_shares

    def test_get_shares(self):
        """Test if the method is relayed."""
        result = 'shares'
        self.syncdaemon_shares.get_shares()
        self.mocker.result(result)
        self.mocker.replay()
        self.assertEqual(result, self.shares.get_shares())

    def test_accept_share(self):
        """Test if the method is relayed."""
        share_id = 'id'
        reply_handler = lambda: None
        error_handler = lambda: None
        self.syncdaemon_shares.accept_share(share_id, MATCH(callable),
            MATCH(callable))
        self.mocker.replay()
        self.shares.accept_share(share_id, reply_handler, error_handler)

    def test_reject_share(self):
        """Test if the method is relayed."""
        share_id = 'id'
        reply_handler = lambda: None
        error_handler = lambda: None
        self.syncdaemon_shares.reject_share(share_id, MATCH(callable),
            MATCH(callable))
        self.mocker.replay()
        self.shares.reject_share(share_id, reply_handler, error_handler)

    def test_delete_share(self):
        """Test if the method is relayed."""
        share_id = 'id'
        self.syncdaemon_shares.delete_share(share_id)
        self.mocker.replay()
        self.shares.delete_share(share_id)

    def test_subscribe(self):
        """Test if the method is relayed."""
        share_id = 'id'
        self.syncdaemon_shares.subscribe(share_id)
        self.mocker.replay()
        self.shares.subscribe(share_id)

    def test_unsubscribe(self):
        """Test if the method is relayed."""
        share_id = 'id'
        self.syncdaemon_shares.unsubscribe(share_id)
        self.mocker.replay()
        self.shares.unsubscribe(share_id)

    def test_create_share(self):
        """Test if the method is relayed."""
        path = 'path'
        username = 'username'
        name = 'name'
        access_level = 'access'
        self.syncdaemon_shares.create_share(path, username, name, access_level)
        self.mocker.replay()
        self.shares.create_share(path, username, name, access_level)

    def test_create_shares(self):
        """Test if the method is relayed."""
        path = 'path'
        usernames = ['username', 'second', 'third',]
        name = 'name'
        access_level = 'access'
        for username in usernames:
            self.syncdaemon_shares.create_share(path, username, name,
                access_level)
        self.mocker.replay()
        self.shares.create_shares(path, usernames, name, access_level)

    def test_refresh_shares(self):
        """Test if the method is relayed."""
        self.syncdaemon_shares.refresh_shares()
        self.mocker.replay()
        self.shares.refresh_shares()

    def test_get_shared(self):
        """Test if the method is relayed."""
        result = 'shared'
        self.syncdaemon_shares.get_shared()
        self.mocker.result(result)
        self.mocker.replay()
        self.assertEqual(result, self.shares.get_shared())


class TestConfigIPC(MockerTestCase, IPCTestCase):
    """Ensure that calls are correctly fowarded."""

    def setUp(self):
        """Set up tests."""
        super(TestConfigIPC, self).setUp()
        self.syncdaemon_config = self.mocker.mock()
        self.config.syncdaemon_config = self.syncdaemon_config

    def test_get_throttling_limits(self):
        """Test if the method is relayed."""
        reply_handler = lambda: None
        error_handler = lambda: None
        self.syncdaemon_config.get_throttling_limits(MATCH(callable),
            MATCH(callable))
        self.mocker.replay()
        self.config.get_throttling_limits(reply_handler, error_handler)

    def test_set_throttling_limits(self):
        """Test if the method is relayed."""
        download = 'download'
        upload = 'upload'
        reply_handler = lambda: None
        error_handler = lambda: None
        self.syncdaemon_config.set_throttling_limits(download, upload,
            MATCH(callable), MATCH(callable))
        self.mocker.replay()
        self.config.set_throttling_limits(download, upload, reply_handler,
            error_handler)

    def test_enable_bandwidth_throttling(self):
        """Test if the method is relayed."""
        reply_handler = lambda: None
        error_handler = lambda: None
        self.syncdaemon_config.enable_bandwidth_throttling(MATCH(callable),
            MATCH(callable))
        self.mocker.replay()
        self.config.enable_bandwidth_throttling(reply_handler, error_handler)

    def test_disable_bandwidth_throttling(self):
        """Test if the method is relayed."""
        reply_handler = lambda: None
        error_handler = lambda: None
        self.syncdaemon_config.disable_bandwidth_throttling(MATCH(callable),
            MATCH(callable))
        self.mocker.replay()
        self.config.disable_bandwidth_throttling(reply_handler, error_handler)

    def test_bandwidth_throttling_enabled(self):
        """Test if the method is relayed."""
        result = 1
        reply_handler = lambda: None
        error_handler = lambda: None
        self.syncdaemon_config.bandwidth_throttling_enabled(MATCH(callable),
            MATCH(callable))
        self.mocker.result(result)
        self.mocker.replay()
        self.assertEqual(result, self.config.bandwidth_throttling_enabled(
            reply_handler, error_handler))

    def test_udf_autosubscribe_enabled(self):
        """Test if the method is relayed."""
        result = 1
        self.syncdaemon_config.udf_autosubscribe_enabled()
        self.mocker.result(result)
        self.mocker.replay()
        self.assertEqual(result, self.config.udf_autosubscribe_enabled())

    def test_enable_udf_autosubscribe(self):
        """Test if the method is relayed."""
        self.syncdaemon_config.enable_udf_autosubscribe()
        self.mocker.replay()
        self.config.enable_udf_autosubscribe()

    def test_disable_udf_autosubscribe(self):
        """Test if the method is relayed."""
        self.syncdaemon_config.disable_udf_autosubscribe()
        self.mocker.replay()
        self.config.disable_udf_autosubscribe()

    def test_share_autosubscribe_enabled(self):
        """Test if the method is relayed."""
        result = 1
        self.syncdaemon_config.share_autosubscribe_enabled()
        self.mocker.result(result)
        self.mocker.replay()
        self.assertEqual(result, self.config.share_autosubscribe_enabled())

    def test_enable_share_autosubscribe(self):
        """Test if the method is relayed."""
        self.syncdaemon_config.enable_share_autosubscribe()
        self.mocker.replay()
        self.config.enable_share_autosubscribe()

    def test_disable_share_autosubscribe(self):
        """Test if the method is relayed."""
        self.syncdaemon_config.disable_share_autosubscribe()
        self.mocker.replay()
        self.config.disable_share_autosubscribe()

    def test_set_files_sync_enabled(self):
        """Test if the method is relayed."""
        enabled = True
        self.syncdaemon_config.set_files_sync_enabled(enabled)
        self.mocker.replay()
        self.config.set_files_sync_enabled(enabled)

    def test_files_sync_enabled(self):
        """Test if the method is relayed."""
        result = 'result'
        self.syncdaemon_config.files_sync_enabled()
        self.mocker.result(result)
        self.mocker.replay()
        self.assertEqual(result, self.config.files_sync_enabled())

    def test_autoconnect_enabled(self):
        """Test if the method is relayed."""
        result = 'result'
        self.syncdaemon_config.autoconnect_enabled()
        self.mocker.result(result)
        self.mocker.replay()
        self.assertEqual(result, self.config.autoconnect_enabled())

    def test_set_autoconnect_enabled(self):
        """Test if the method is relayed."""
        enabled = True
        self.syncdaemon_config.set_autoconnect_enabled(enabled)
        self.mocker.replay()
        self.config.set_autoconnect_enabled(enabled)

    def test_show_all_notifications_enabled(self):
        """Test if the method is relayed."""
        result = 'result'
        self.syncdaemon_config.show_all_notifications_enabled()
        self.mocker.result(result)
        self.mocker.replay()
        self.config.show_all_notifications_enabled()

    def test_enable_show_all_notifications(self):
        """Test if the method is relayed."""
        self.syncdaemon_config.enable_show_all_notifications()
        self.mocker.replay()
        self.config.enable_show_all_notifications()

    def test_disable_show_all_notifications(self):
        """Test if the method is relayed."""
        self.syncdaemon_config.disable_show_all_notifications()
        self.mocker.replay()
        self.config.disable_show_all_notifications()


class TestFoldersIPC(MockerTestCase, IPCTestCase):
    """Ensure that calls are correctly fowarded."""

    def setUp(self):
        """Set up tests."""
        super(TestFoldersIPC, self).setUp()
        self.syncdaemon_folders = self.mocker.mock()
        self.folders.syncdaemon_folders = self.syncdaemon_folders

    def test_create(self):
        """Test if the method is relayed."""
        path = 'path'
        self.syncdaemon_folders.create(path)
        self.mocker.replay()
        self.folders.create(path)

    def test_delete(self):
        """Test if the method is relayed."""
        folder_id = 'id'
        self.syncdaemon_folders.delete(folder_id)
        self.mocker.replay()
        self.folders.delete(folder_id)

    def test_get_folders(self):
        """Test if the method is relayed."""
        result = 'folders'
        self.syncdaemon_folders.get_folders()
        self.mocker.result(result)
        self.mocker.replay()
        self.assertEqual(result, self.folders.get_folders())

    def test_subscribe(self):
        """Test if the method is relayed."""
        folder_id = 'id'
        self.syncdaemon_folders.subscribe(folder_id)
        self.mocker.replay()
        self.folders.subscribe(folder_id)

    def test_unsubscribe(self):
        """Test if the method is relayed."""
        folder_id = 'id'
        self.syncdaemon_folders.unsubscribe(folder_id)
        self.mocker.replay()
        self.folders.unsubscribe(folder_id)

    def test_get_info(self):
        """Test if the method is relayed."""
        result = 'info'
        path = 'path'
        self.syncdaemon_folders.get_info(path)
        self.mocker.result(result)
        self.mocker.replay()
        self.assertEqual(result, self.folders.get_info(path))

    def test_refresh_volumes(self):
        """Test if the method is relayed."""
        self.syncdaemon_folders.refresh_volumes()
        self.mocker.replay()
        self.folders.refresh_volumes()


class TestPublicFilesIPC(MockerTestCase, IPCTestCase):
    """Ensure that calls are correctly fowarded."""

    def setUp(self):
        """Set up tests."""
        super(TestPublicFilesIPC, self).setUp()
        self.syncdaemon_public_files = self.mocker.mock()
        self.public_files.syncdaemon_public_files =\
            self.syncdaemon_public_files

    def test_change_public_access(self):
        """Test if the method is relayed."""
        share_id = 'share'
        node_id = 'node'
        is_public = True
        self.syncdaemon_public_files.change_public_access(share_id, node_id,
            is_public)
        self.mocker.replay()
        self.public_files.change_public_access(share_id, node_id, is_public)

    def test_get_public_files(self):
        """Test if the method is relayed."""
        result = 'files'
        self.syncdaemon_public_files.get_public_files()
        self.mocker.result(result)
        self.mocker.replay()
        self.assertEqual(None, self.public_files.get_public_files())
