# ubuntuone.oauthdesktop.config - Configuration for OAuthDesktop
#
# Author: Stuart Langridge <stuart.langridge@canonical.com>
#
# Copyright 2009 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.
"Find the config file for ubuntuone-oauth-config"
import os, ConfigParser
from xdg.BaseDirectory import load_first_config

def get_config(use_tmpconfig=True):
    """Return a ConfigParser object from a config file.
    Config file is looked for in the source tree first and then in the
    FreeDesktop BaseDirectory folders.
    """
    # if tmpconfig exists, then we are running out of the source tree
    tmpconfig = os.path.realpath(os.path.join(
            __file__, "../../../data/oauth_urls"
            ))
    if os.path.isfile(tmpconfig) and use_tmpconfig:
        config_file = tmpconfig
    else:
        config_file = load_first_config('ubuntuone','oauth_urls')

    cfp = ConfigParser.ConfigParser()
    cfp.FILENAME = None
    if config_file is not None:
        try:
            cfp.read(config_file)
            cfp.FILENAME = config_file
        except ConfigParser.Error:
            cfp = ConfigParser.ConfigParser()
            cfp.FILENAME = None
    return cfp


