/*
 * QtTapioca, the Tapioca Qt4 Client Library
 * Copyright (C) 2006 by INdT
 *  @author Abner Jose de Faria Silva <abner.silva@indt.org.br>
 *  @author Andre Moreira Magalhaes <andre.magalhaes@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA
 */

#ifndef QTTAPIOCA_CONTACT_H
#define QTTAPIOCA_CONTACT_H

#include <QtCore/QObject>
#include <QtCore/QString>
#include <QtTapioca/ContactBase>
#include <qglobal.h>

#include <QtTelepathy/Client/Connection>
#include <QtTelepathy/Client/ConnectionAvatarsInterface>
#include <QtTelepathy/Client/ConnectionPresenceInterface>
#include <QtTelepathy/Client/ConnectionAliasingInterface>
#include <QtTelepathy/Client/ConnectionCapabilitiesInterface>
#include <QtTelepathy/Client/ChannelGroupInterface>

namespace QtTapioca {

class ContactPrivate;

class Q_DECL_EXPORT Contact: public ContactBase {
    Q_OBJECT
    Q_DECLARE_PRIVATE(Contact)
    Q_ENUMS(SubscriptionStatus)
    Q_ENUMS(AuthorizationStatus)

public:
    enum SubscriptionStatus {
        NotSubscribed = 0,
        RemotePending,
        Subscribed
    };

    enum AuthorizationStatus {
        NonExistent = 0,
        LocalPending,
        Authorized
    };

    ~Contact();

    SubscriptionStatus subscriptionStatus() const;
    AuthorizationStatus authorizationStatus() const;
    void subscribe(bool value);
    void authorize(bool value);
    void hideFrom(bool value);
    bool hidingFrom() const;
    void block(bool value);
    bool isBlocked() const;

Q_SIGNALS:
    void subscriptionStatusChanged(QtTapioca::Contact::SubscriptionStatus status);
    void authorizationStatusChanged(QtTapioca::Contact::AuthorizationStatus status);
    void hideFromStatusChanged(bool status);
    void blockStatusChanged(bool status);

private Q_SLOTS:
    void onMembersChangedSubscribe(const QString &, const QList<uint> &, const QList<uint> &, const QList<uint> &, const QList<uint> &, uint, uint);
    void onMembersChangedPublish(const QString &, const QList<uint> &, const QList<uint> &, const QList<uint> &, const QList<uint> &, uint, uint);
    void onMembersChangedHide(const QString &, const QList<uint> &, const QList<uint> &, const QList<uint> &, const QList<uint> &, uint, uint);
    void onMembersChangedAllow(const QString &, const QList<uint> &, const QList<uint> &, const QList<uint> &, const QList<uint> &, uint, uint);
    void onMembersChangedDeny(const QString &, const QList<uint> &, const QList<uint> &, const QList<uint> &, const QList<uint> &, uint, uint);

private:
    friend class ContactList;

    Contact(org::freedesktop::Telepathy::Connection *telepathyConn,
            org::freedesktop::Telepathy::ConnectionAvatarsInterface *telepathyIAvatar,
            org::freedesktop::Telepathy::ConnectionPresenceInterface *telepathyIPresence,
            org::freedesktop::Telepathy::ConnectionAliasingInterface *telepathyIAliasing,
            org::freedesktop::Telepathy::ConnectionCapabilitiesInterface *telepathyICapabilities,
            org::freedesktop::Telepathy::ChannelGroupInterface *telepathyGISubscribe,
            org::freedesktop::Telepathy::ChannelGroupInterface *telepathyGIPublish,
            org::freedesktop::Telepathy::ChannelGroupInterface *telepathyGIHide,
            org::freedesktop::Telepathy::ChannelGroupInterface *telepathyGIAllow,
            org::freedesktop::Telepathy::ChannelGroupInterface *telepathyGIDeny,
            Handle *handle,
            QObject *parent = 0);
    void setSubscriptionStatus(SubscriptionStatus status, bool emitSignal = false);
    void setAuthorizationStatus(AuthorizationStatus status, bool emitSignal = false);
    void setHideStatus(bool status, bool emitSignal = false);
    void setBlockStatus(bool status, bool emitSignal = false);
    void setOnGroup(org::freedesktop::Telepathy::ChannelGroupInterface *group, bool value);

    ContactPrivate *d;
};

} // namespace

#endif

