import glob
import os
import tempfile
import unittest

from tests.utils import (
    do_events_with_sleep,
    setup_test_env,
)
setup_test_env()
from softwarecenter.utils import SimpleFileDownloader


class TestImageDownloader(unittest.TestCase):

    DOWNLOAD_FILENAME = "test_image_download"

    def setUp(self):
        self.downloader = SimpleFileDownloader()
        self.downloader.connect("file-url-reachable",
                                self._cb_image_url_reachable)
        self.downloader.connect("file-download-complete",
                                self._cb_image_download_complete)
        self.downloader.connect("error",
                                self._cb_image_download_error)
        self._image_is_reachable = None
        self._image_downloaded_filename = None
        self._error = False
        if os.path.exists(self.DOWNLOAD_FILENAME):
            os.unlink(self.DOWNLOAD_FILENAME)

    def _cb_image_url_reachable(self, downloader, is_reachable):
        self._image_is_reachable = is_reachable

    def _cb_image_download_complete(self, downloader, filename):
        self._image_downloaded_filename = filename

    def _cb_image_download_error(self, downloader, gerror, exc):
        print "ERROR '%s'" % exc
        self._error = True

    @unittest.skipIf(not "DBUS_SESSION_BUS_ADDRESS" in os.environ,
                     "Need dbus session bus for the gio based test")
    def test_download_unreachable(self):
        self.downloader.download_file("http://www.ubuntu.com/really-not-there",
                                      self.DOWNLOAD_FILENAME)
        while self._image_is_reachable is None:
            do_events_with_sleep()
        self.assertNotEqual(self._image_is_reachable, None)
        self.assertFalse(self._image_is_reachable)
        self.assertTrue(not os.path.exists(self.DOWNLOAD_FILENAME))

    @unittest.skipIf(not "DBUS_SESSION_BUS_ADDRESS" in os.environ,
                     "Need dbus session bus for the gio based test")
    def test_download_reachable(self):
        self.downloader.download_file("http://www.google.com",
                                      self.DOWNLOAD_FILENAME)
        while (self._image_downloaded_filename is None and
               not self._error):
            do_events_with_sleep()
        self.assertNotEqual(self._image_is_reachable, None)
        self.assertTrue(self._image_is_reachable)
        self.assertTrue(os.path.exists(self.DOWNLOAD_FILENAME))

    @unittest.skip("highly dependant on network speed so disabled by default")
    def test_download_race_lp839462(self):
        hosts = ["google", "ubuntu"]
        tmpdir = tempfile.mkdtemp()
        # mvo: in order to reproduce the race these paramters can be tweaked
        # its highly depedant on network latency, for me it hit 1/3 times
        # at around i=7,8 - if the race ever hits again this will be a useful
        # starting point
        for i in range(5,15):
            for host in hosts:
                url = "http://www.%s.com/" % host
                target = os.path.join(tmpdir, host)
                self.downloader.download_file(url, target)
                do_events_with_sleep(iterations=i)
            for host in hosts:
                downloaded_file = os.path.join(tmpdir, host)
                if os.path.exists(downloaded_file):
                    self.assertTrue(
                        host in open(downloaded_file).read().lower(),
                        "file '%s' contains wrong content" % downloaded_file)
            for f in glob.glob(tmpdir+"/*"):
                os.unlink(f)

if __name__ == "__main__":
    unittest.main()
