/* scanner.c generated by valac 0.13.4, the Vala compiler
 * generated from scanner.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */
/* TODO: Could indicate the start of the next page immediately after the last page is received (i.e. before the sane_cancel()) */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <sane/sane.h>
#include <glib/gi18n-lib.h>
#include <sane/saneopts.h>
#include <gobject/gvaluecollector.h>


#define TYPE_SCAN_DEVICE (scan_device_get_type ())
#define SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_DEVICE, ScanDevice))
#define SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_DEVICE, ScanDeviceClass))
#define IS_SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_DEVICE))
#define IS_SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_DEVICE))
#define SCAN_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_DEVICE, ScanDeviceClass))

typedef struct _ScanDevice ScanDevice;
typedef struct _ScanDeviceClass ScanDeviceClass;
typedef struct _ScanDevicePrivate ScanDevicePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecScanDevice ParamSpecScanDevice;

#define TYPE_SCAN_PAGE_INFO (scan_page_info_get_type ())
#define SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfo))
#define SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))
#define IS_SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_PAGE_INFO))
#define IS_SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_PAGE_INFO))
#define SCAN_PAGE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))

typedef struct _ScanPageInfo ScanPageInfo;
typedef struct _ScanPageInfoClass ScanPageInfoClass;
typedef struct _ScanPageInfoPrivate ScanPageInfoPrivate;
typedef struct _ParamSpecScanPageInfo ParamSpecScanPageInfo;

#define TYPE_SCAN_LINE (scan_line_get_type ())
#define SCAN_LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_LINE, ScanLine))
#define SCAN_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_LINE, ScanLineClass))
#define IS_SCAN_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_LINE))
#define IS_SCAN_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_LINE))
#define SCAN_LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_LINE, ScanLineClass))

typedef struct _ScanLine ScanLine;
typedef struct _ScanLineClass ScanLineClass;
typedef struct _ScanLinePrivate ScanLinePrivate;
typedef struct _ParamSpecScanLine ParamSpecScanLine;

#define TYPE_SCAN_MODE (scan_mode_get_type ())

#define TYPE_SCAN_TYPE (scan_type_get_type ())

#define TYPE_SCAN_OPTIONS (scan_options_get_type ())
#define SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_OPTIONS, ScanOptions))
#define SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_OPTIONS, ScanOptionsClass))
#define IS_SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_OPTIONS))
#define IS_SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_OPTIONS))
#define SCAN_OPTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_OPTIONS, ScanOptionsClass))

typedef struct _ScanOptions ScanOptions;
typedef struct _ScanOptionsClass ScanOptionsClass;
typedef struct _ScanOptionsPrivate ScanOptionsPrivate;
typedef struct _ParamSpecScanOptions ParamSpecScanOptions;

#define TYPE_SCAN_JOB (scan_job_get_type ())
#define SCAN_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_JOB, ScanJob))
#define SCAN_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_JOB, ScanJobClass))
#define IS_SCAN_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_JOB))
#define IS_SCAN_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_JOB))
#define SCAN_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_JOB, ScanJobClass))

typedef struct _ScanJob ScanJob;
typedef struct _ScanJobClass ScanJobClass;
typedef struct _ScanJobPrivate ScanJobPrivate;
typedef struct _ParamSpecScanJob ParamSpecScanJob;

#define TYPE_REQUEST (request_get_type ())
#define REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REQUEST, Request))
#define REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REQUEST, RequestClass))
#define IS_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REQUEST))
#define IS_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REQUEST))
#define REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REQUEST, RequestClass))

typedef struct _Request Request;
typedef struct _RequestClass RequestClass;
typedef struct _RequestPrivate RequestPrivate;
typedef struct _ParamSpecRequest ParamSpecRequest;

#define TYPE_REQUEST_REDETECT (request_redetect_get_type ())
#define REQUEST_REDETECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REQUEST_REDETECT, RequestRedetect))
#define REQUEST_REDETECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REQUEST_REDETECT, RequestRedetectClass))
#define IS_REQUEST_REDETECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REQUEST_REDETECT))
#define IS_REQUEST_REDETECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REQUEST_REDETECT))
#define REQUEST_REDETECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REQUEST_REDETECT, RequestRedetectClass))

typedef struct _RequestRedetect RequestRedetect;
typedef struct _RequestRedetectClass RequestRedetectClass;
typedef struct _RequestRedetectPrivate RequestRedetectPrivate;

#define TYPE_REQUEST_CANCEL (request_cancel_get_type ())
#define REQUEST_CANCEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REQUEST_CANCEL, RequestCancel))
#define REQUEST_CANCEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REQUEST_CANCEL, RequestCancelClass))
#define IS_REQUEST_CANCEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REQUEST_CANCEL))
#define IS_REQUEST_CANCEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REQUEST_CANCEL))
#define REQUEST_CANCEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REQUEST_CANCEL, RequestCancelClass))

typedef struct _RequestCancel RequestCancel;
typedef struct _RequestCancelClass RequestCancelClass;
typedef struct _RequestCancelPrivate RequestCancelPrivate;

#define TYPE_REQUEST_START_SCAN (request_start_scan_get_type ())
#define REQUEST_START_SCAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REQUEST_START_SCAN, RequestStartScan))
#define REQUEST_START_SCAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REQUEST_START_SCAN, RequestStartScanClass))
#define IS_REQUEST_START_SCAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REQUEST_START_SCAN))
#define IS_REQUEST_START_SCAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REQUEST_START_SCAN))
#define REQUEST_START_SCAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REQUEST_START_SCAN, RequestStartScanClass))

typedef struct _RequestStartScan RequestStartScan;
typedef struct _RequestStartScanClass RequestStartScanClass;
typedef struct _RequestStartScanPrivate RequestStartScanPrivate;
#define _scan_job_unref0(var) ((var == NULL) ? NULL : (var = (scan_job_unref (var), NULL)))

#define TYPE_REQUEST_QUIT (request_quit_get_type ())
#define REQUEST_QUIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REQUEST_QUIT, RequestQuit))
#define REQUEST_QUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REQUEST_QUIT, RequestQuitClass))
#define IS_REQUEST_QUIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REQUEST_QUIT))
#define IS_REQUEST_QUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REQUEST_QUIT))
#define REQUEST_QUIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REQUEST_QUIT, RequestQuitClass))

typedef struct _RequestQuit RequestQuit;
typedef struct _RequestQuitClass RequestQuitClass;
typedef struct _RequestQuitPrivate RequestQuitPrivate;

#define TYPE_CREDENTIALS (credentials_get_type ())
#define CREDENTIALS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CREDENTIALS, Credentials))
#define CREDENTIALS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CREDENTIALS, CredentialsClass))
#define IS_CREDENTIALS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CREDENTIALS))
#define IS_CREDENTIALS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CREDENTIALS))
#define CREDENTIALS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CREDENTIALS, CredentialsClass))

typedef struct _Credentials Credentials;
typedef struct _CredentialsClass CredentialsClass;
typedef struct _CredentialsPrivate CredentialsPrivate;
typedef struct _ParamSpecCredentials ParamSpecCredentials;

#define TYPE_SCAN_STATE (scan_state_get_type ())

#define TYPE_NOTIFY (notify_get_type ())
#define NOTIFY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY, Notify))
#define NOTIFY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY, NotifyClass))
#define IS_NOTIFY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY))
#define IS_NOTIFY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY))
#define NOTIFY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY, NotifyClass))

typedef struct _Notify Notify;
typedef struct _NotifyClass NotifyClass;
typedef struct _NotifyPrivate NotifyPrivate;

#define TYPE_SCANNER (scanner_get_type ())
#define SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCANNER, Scanner))
#define SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCANNER, ScannerClass))
#define IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCANNER))
#define IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCANNER))
#define SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCANNER, ScannerClass))

typedef struct _Scanner Scanner;
typedef struct _ScannerClass ScannerClass;
typedef struct _ParamSpecNotify ParamSpecNotify;

#define TYPE_NOTIFY_SCANNING_CHANGED (notify_scanning_changed_get_type ())
#define NOTIFY_SCANNING_CHANGED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_SCANNING_CHANGED, NotifyScanningChanged))
#define NOTIFY_SCANNING_CHANGED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_SCANNING_CHANGED, NotifyScanningChangedClass))
#define IS_NOTIFY_SCANNING_CHANGED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_SCANNING_CHANGED))
#define IS_NOTIFY_SCANNING_CHANGED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_SCANNING_CHANGED))
#define NOTIFY_SCANNING_CHANGED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_SCANNING_CHANGED, NotifyScanningChangedClass))

typedef struct _NotifyScanningChanged NotifyScanningChanged;
typedef struct _NotifyScanningChangedClass NotifyScanningChangedClass;
typedef struct _NotifyScanningChangedPrivate NotifyScanningChangedPrivate;

#define TYPE_NOTIFY_UPDATE_DEVICES (notify_update_devices_get_type ())
#define NOTIFY_UPDATE_DEVICES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_UPDATE_DEVICES, NotifyUpdateDevices))
#define NOTIFY_UPDATE_DEVICES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_UPDATE_DEVICES, NotifyUpdateDevicesClass))
#define IS_NOTIFY_UPDATE_DEVICES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_UPDATE_DEVICES))
#define IS_NOTIFY_UPDATE_DEVICES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_UPDATE_DEVICES))
#define NOTIFY_UPDATE_DEVICES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_UPDATE_DEVICES, NotifyUpdateDevicesClass))

typedef struct _NotifyUpdateDevices NotifyUpdateDevices;
typedef struct _NotifyUpdateDevicesClass NotifyUpdateDevicesClass;
typedef struct _NotifyUpdateDevicesPrivate NotifyUpdateDevicesPrivate;
#define __g_list_free__scan_device_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__scan_device_unref0_ (var), NULL)))

#define TYPE_NOTIFY_REQUEST_AUTHORIZATION (notify_request_authorization_get_type ())
#define NOTIFY_REQUEST_AUTHORIZATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_REQUEST_AUTHORIZATION, NotifyRequestAuthorization))
#define NOTIFY_REQUEST_AUTHORIZATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_REQUEST_AUTHORIZATION, NotifyRequestAuthorizationClass))
#define IS_NOTIFY_REQUEST_AUTHORIZATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_REQUEST_AUTHORIZATION))
#define IS_NOTIFY_REQUEST_AUTHORIZATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_REQUEST_AUTHORIZATION))
#define NOTIFY_REQUEST_AUTHORIZATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_REQUEST_AUTHORIZATION, NotifyRequestAuthorizationClass))

typedef struct _NotifyRequestAuthorization NotifyRequestAuthorization;
typedef struct _NotifyRequestAuthorizationClass NotifyRequestAuthorizationClass;
typedef struct _NotifyRequestAuthorizationPrivate NotifyRequestAuthorizationPrivate;

#define TYPE_NOTIFY_SCAN_FAILED (notify_scan_failed_get_type ())
#define NOTIFY_SCAN_FAILED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_SCAN_FAILED, NotifyScanFailed))
#define NOTIFY_SCAN_FAILED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_SCAN_FAILED, NotifyScanFailedClass))
#define IS_NOTIFY_SCAN_FAILED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_SCAN_FAILED))
#define IS_NOTIFY_SCAN_FAILED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_SCAN_FAILED))
#define NOTIFY_SCAN_FAILED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_SCAN_FAILED, NotifyScanFailedClass))

typedef struct _NotifyScanFailed NotifyScanFailed;
typedef struct _NotifyScanFailedClass NotifyScanFailedClass;
typedef struct _NotifyScanFailedPrivate NotifyScanFailedPrivate;

#define TYPE_NOTIFY_DOCUMENT_DONE (notify_document_done_get_type ())
#define NOTIFY_DOCUMENT_DONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_DOCUMENT_DONE, NotifyDocumentDone))
#define NOTIFY_DOCUMENT_DONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_DOCUMENT_DONE, NotifyDocumentDoneClass))
#define IS_NOTIFY_DOCUMENT_DONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_DOCUMENT_DONE))
#define IS_NOTIFY_DOCUMENT_DONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_DOCUMENT_DONE))
#define NOTIFY_DOCUMENT_DONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_DOCUMENT_DONE, NotifyDocumentDoneClass))

typedef struct _NotifyDocumentDone NotifyDocumentDone;
typedef struct _NotifyDocumentDoneClass NotifyDocumentDoneClass;
typedef struct _NotifyDocumentDonePrivate NotifyDocumentDonePrivate;

#define TYPE_NOTIFY_EXPECT_PAGE (notify_expect_page_get_type ())
#define NOTIFY_EXPECT_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_EXPECT_PAGE, NotifyExpectPage))
#define NOTIFY_EXPECT_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_EXPECT_PAGE, NotifyExpectPageClass))
#define IS_NOTIFY_EXPECT_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_EXPECT_PAGE))
#define IS_NOTIFY_EXPECT_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_EXPECT_PAGE))
#define NOTIFY_EXPECT_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_EXPECT_PAGE, NotifyExpectPageClass))

typedef struct _NotifyExpectPage NotifyExpectPage;
typedef struct _NotifyExpectPageClass NotifyExpectPageClass;
typedef struct _NotifyExpectPagePrivate NotifyExpectPagePrivate;

#define TYPE_NOTIFY_GOT_PAGE_INFO (notify_got_page_info_get_type ())
#define NOTIFY_GOT_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_GOT_PAGE_INFO, NotifyGotPageInfo))
#define NOTIFY_GOT_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_GOT_PAGE_INFO, NotifyGotPageInfoClass))
#define IS_NOTIFY_GOT_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_GOT_PAGE_INFO))
#define IS_NOTIFY_GOT_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_GOT_PAGE_INFO))
#define NOTIFY_GOT_PAGE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_GOT_PAGE_INFO, NotifyGotPageInfoClass))

typedef struct _NotifyGotPageInfo NotifyGotPageInfo;
typedef struct _NotifyGotPageInfoClass NotifyGotPageInfoClass;
typedef struct _NotifyGotPageInfoPrivate NotifyGotPageInfoPrivate;
#define _scan_page_info_unref0(var) ((var == NULL) ? NULL : (var = (scan_page_info_unref (var), NULL)))

#define TYPE_NOTIFY_PAGE_DONE (notify_page_done_get_type ())
#define NOTIFY_PAGE_DONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_PAGE_DONE, NotifyPageDone))
#define NOTIFY_PAGE_DONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_PAGE_DONE, NotifyPageDoneClass))
#define IS_NOTIFY_PAGE_DONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_PAGE_DONE))
#define IS_NOTIFY_PAGE_DONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_PAGE_DONE))
#define NOTIFY_PAGE_DONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_PAGE_DONE, NotifyPageDoneClass))

typedef struct _NotifyPageDone NotifyPageDone;
typedef struct _NotifyPageDoneClass NotifyPageDoneClass;
typedef struct _NotifyPageDonePrivate NotifyPageDonePrivate;

#define TYPE_NOTIFY_GOT_LINE (notify_got_line_get_type ())
#define NOTIFY_GOT_LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_GOT_LINE, NotifyGotLine))
#define NOTIFY_GOT_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_GOT_LINE, NotifyGotLineClass))
#define IS_NOTIFY_GOT_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_GOT_LINE))
#define IS_NOTIFY_GOT_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_GOT_LINE))
#define NOTIFY_GOT_LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_GOT_LINE, NotifyGotLineClass))

typedef struct _NotifyGotLine NotifyGotLine;
typedef struct _NotifyGotLineClass NotifyGotLineClass;
typedef struct _NotifyGotLinePrivate NotifyGotLinePrivate;
#define _scan_line_unref0(var) ((var == NULL) ? NULL : (var = (scan_line_unref (var), NULL)))
typedef struct _ScannerPrivate ScannerPrivate;
#define _g_async_queue_unref0(var) ((var == NULL) ? NULL : (var = (g_async_queue_unref (var), NULL)))
#define __g_list_free__scan_job_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__scan_job_unref0_ (var), NULL)))
#define _scanner_unref0(var) ((var == NULL) ? NULL : (var = (scanner_unref (var), NULL)))
#define _notify_unref0(var) ((var == NULL) ? NULL : (var = (notify_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _scan_device_unref0(var) ((var == NULL) ? NULL : (var = (scan_device_unref (var), NULL)))
#define _credentials_unref0(var) ((var == NULL) ? NULL : (var = (credentials_unref (var), NULL)))
#define _request_unref0(var) ((var == NULL) ? NULL : (var = (request_unref (var), NULL)))
typedef struct _ParamSpecScanner ParamSpecScanner;

struct _ScanDevice {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanDevicePrivate * priv;
	gchar* name;
	gchar* label;
};

struct _ScanDeviceClass {
	GTypeClass parent_class;
	void (*finalize) (ScanDevice *self);
};

struct _ParamSpecScanDevice {
	GParamSpec parent_instance;
};

struct _ScanPageInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanPageInfoPrivate * priv;
	gint width;
	gint height;
	gint depth;
	gint n_channels;
	gdouble dpi;
	gchar* device;
};

struct _ScanPageInfoClass {
	GTypeClass parent_class;
	void (*finalize) (ScanPageInfo *self);
};

struct _ParamSpecScanPageInfo {
	GParamSpec parent_instance;
};

struct _ScanLine {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanLinePrivate * priv;
	gint number;
	gint n_lines;
	gint width;
	gint depth;
	gint channel;
	guchar* data;
	gint data_length1;
	gint data_length;
};

struct _ScanLineClass {
	GTypeClass parent_class;
	void (*finalize) (ScanLine *self);
};

struct _ParamSpecScanLine {
	GParamSpec parent_instance;
};

typedef enum  {
	SCAN_MODE_DEFAULT,
	SCAN_MODE_COLOR,
	SCAN_MODE_GRAY,
	SCAN_MODE_LINEART
} ScanMode;

typedef enum  {
	SCAN_TYPE_SINGLE,
	SCAN_TYPE_ADF_FRONT,
	SCAN_TYPE_ADF_BACK,
	SCAN_TYPE_ADF_BOTH
} ScanType;

struct _ScanOptions {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanOptionsPrivate * priv;
	gint dpi;
	ScanMode scan_mode;
	gint depth;
	ScanType type;
	gint paper_width;
	gint paper_height;
};

struct _ScanOptionsClass {
	GTypeClass parent_class;
	void (*finalize) (ScanOptions *self);
};

struct _ParamSpecScanOptions {
	GParamSpec parent_instance;
};

struct _ScanJob {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanJobPrivate * priv;
	gchar* device;
	gdouble dpi;
	ScanMode scan_mode;
	gint depth;
	ScanType type;
	gint page_width;
	gint page_height;
};

struct _ScanJobClass {
	GTypeClass parent_class;
	void (*finalize) (ScanJob *self);
};

struct _ParamSpecScanJob {
	GParamSpec parent_instance;
};

struct _Request {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RequestPrivate * priv;
};

struct _RequestClass {
	GTypeClass parent_class;
	void (*finalize) (Request *self);
};

struct _ParamSpecRequest {
	GParamSpec parent_instance;
};

struct _RequestRedetect {
	Request parent_instance;
	RequestRedetectPrivate * priv;
};

struct _RequestRedetectClass {
	RequestClass parent_class;
};

struct _RequestCancel {
	Request parent_instance;
	RequestCancelPrivate * priv;
};

struct _RequestCancelClass {
	RequestClass parent_class;
};

struct _RequestStartScan {
	Request parent_instance;
	RequestStartScanPrivate * priv;
	ScanJob* job;
};

struct _RequestStartScanClass {
	RequestClass parent_class;
};

struct _RequestQuit {
	Request parent_instance;
	RequestQuitPrivate * priv;
};

struct _RequestQuitClass {
	RequestClass parent_class;
};

struct _Credentials {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CredentialsPrivate * priv;
	gchar* username;
	gchar* password;
};

struct _CredentialsClass {
	GTypeClass parent_class;
	void (*finalize) (Credentials *self);
};

struct _ParamSpecCredentials {
	GParamSpec parent_instance;
};

typedef enum  {
	SCAN_STATE_IDLE = 0,
	SCAN_STATE_REDETECT,
	SCAN_STATE_OPEN,
	SCAN_STATE_GET_OPTION,
	SCAN_STATE_START,
	SCAN_STATE_GET_PARAMETERS,
	SCAN_STATE_READ
} ScanState;

struct _Notify {
	GTypeInstance parent_instance;
	volatile int ref_count;
	NotifyPrivate * priv;
};

struct _NotifyClass {
	GTypeClass parent_class;
	void (*finalize) (Notify *self);
	void (*run) (Notify* self, Scanner* scanner);
};

struct _ParamSpecNotify {
	GParamSpec parent_instance;
};

struct _NotifyScanningChanged {
	Notify parent_instance;
	NotifyScanningChangedPrivate * priv;
};

struct _NotifyScanningChangedClass {
	NotifyClass parent_class;
};

struct _NotifyUpdateDevices {
	Notify parent_instance;
	NotifyUpdateDevicesPrivate * priv;
};

struct _NotifyUpdateDevicesClass {
	NotifyClass parent_class;
};

struct _NotifyUpdateDevicesPrivate {
	GList* devices;
};

struct _NotifyRequestAuthorization {
	Notify parent_instance;
	NotifyRequestAuthorizationPrivate * priv;
};

struct _NotifyRequestAuthorizationClass {
	NotifyClass parent_class;
};

struct _NotifyRequestAuthorizationPrivate {
	gchar* resource;
};

struct _NotifyScanFailed {
	Notify parent_instance;
	NotifyScanFailedPrivate * priv;
};

struct _NotifyScanFailedClass {
	NotifyClass parent_class;
};

struct _NotifyScanFailedPrivate {
	gint error_code;
	gchar* error_string;
};

struct _NotifyDocumentDone {
	Notify parent_instance;
	NotifyDocumentDonePrivate * priv;
};

struct _NotifyDocumentDoneClass {
	NotifyClass parent_class;
};

struct _NotifyExpectPage {
	Notify parent_instance;
	NotifyExpectPagePrivate * priv;
};

struct _NotifyExpectPageClass {
	NotifyClass parent_class;
};

struct _NotifyGotPageInfo {
	Notify parent_instance;
	NotifyGotPageInfoPrivate * priv;
};

struct _NotifyGotPageInfoClass {
	NotifyClass parent_class;
};

struct _NotifyGotPageInfoPrivate {
	ScanPageInfo* info;
};

struct _NotifyPageDone {
	Notify parent_instance;
	NotifyPageDonePrivate * priv;
};

struct _NotifyPageDoneClass {
	NotifyClass parent_class;
};

struct _NotifyGotLine {
	Notify parent_instance;
	NotifyGotLinePrivate * priv;
};

struct _NotifyGotLineClass {
	NotifyClass parent_class;
};

struct _NotifyGotLinePrivate {
	ScanLine* line;
};

struct _Scanner {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScannerPrivate * priv;
};

struct _ScannerClass {
	GTypeClass parent_class;
	void (*finalize) (Scanner *self);
};

struct _ScannerPrivate {
	GThread* thread;
	GAsyncQueue* request_queue;
	GAsyncQueue* notify_queue;
	GAsyncQueue* authorize_queue;
	gchar* default_device;
	ScanState state;
	gboolean need_redetect;
	GList* job_queue;
	SANE_Handle handle;
	gboolean have_handle;
	gchar* current_device;
	SANE_Parameters parameters;
	SANE_Int option_index;
	SANE_Int br_x_option_index;
	SANE_Int br_y_option_index;
	guchar* buffer;
	gint buffer_length1;
	gint _buffer_size_;
	gint n_used;
	gint line_count;
	gint pass_number;
	gint page_number;
	gint notified_page;
	gboolean scanning;
};

struct _ParamSpecScanner {
	GParamSpec parent_instance;
};


static gpointer scan_device_parent_class = NULL;
static gpointer scan_page_info_parent_class = NULL;
static gpointer scan_line_parent_class = NULL;
static gpointer scan_options_parent_class = NULL;
static gpointer scan_job_parent_class = NULL;
static gpointer request_parent_class = NULL;
static gpointer request_redetect_parent_class = NULL;
static gpointer request_cancel_parent_class = NULL;
static gpointer request_start_scan_parent_class = NULL;
static gpointer request_quit_parent_class = NULL;
static gpointer credentials_parent_class = NULL;
static gpointer notify_parent_class = NULL;
static gpointer notify_scanning_changed_parent_class = NULL;
static gpointer notify_update_devices_parent_class = NULL;
static gpointer notify_request_authorization_parent_class = NULL;
static gpointer notify_scan_failed_parent_class = NULL;
static gpointer notify_document_done_parent_class = NULL;
static gpointer notify_expect_page_parent_class = NULL;
static gpointer notify_got_page_info_parent_class = NULL;
static gpointer notify_page_done_parent_class = NULL;
static gpointer notify_got_line_parent_class = NULL;
static gpointer scanner_parent_class = NULL;
static Scanner* scanner_scanner_object;
static Scanner* scanner_scanner_object = NULL;

gpointer scan_device_ref (gpointer instance);
void scan_device_unref (gpointer instance);
GParamSpec* param_spec_scan_device (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_device (GValue* value, gpointer v_object);
void value_take_scan_device (GValue* value, gpointer v_object);
gpointer value_get_scan_device (const GValue* value);
GType scan_device_get_type (void) G_GNUC_CONST;
enum  {
	SCAN_DEVICE_DUMMY_PROPERTY
};
ScanDevice* scan_device_new (void);
ScanDevice* scan_device_construct (GType object_type);
static void scan_device_finalize (ScanDevice* obj);
gpointer scan_page_info_ref (gpointer instance);
void scan_page_info_unref (gpointer instance);
GParamSpec* param_spec_scan_page_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_page_info (GValue* value, gpointer v_object);
void value_take_scan_page_info (GValue* value, gpointer v_object);
gpointer value_get_scan_page_info (const GValue* value);
GType scan_page_info_get_type (void) G_GNUC_CONST;
enum  {
	SCAN_PAGE_INFO_DUMMY_PROPERTY
};
ScanPageInfo* scan_page_info_new (void);
ScanPageInfo* scan_page_info_construct (GType object_type);
static void scan_page_info_finalize (ScanPageInfo* obj);
gpointer scan_line_ref (gpointer instance);
void scan_line_unref (gpointer instance);
GParamSpec* param_spec_scan_line (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_line (GValue* value, gpointer v_object);
void value_take_scan_line (GValue* value, gpointer v_object);
gpointer value_get_scan_line (const GValue* value);
GType scan_line_get_type (void) G_GNUC_CONST;
enum  {
	SCAN_LINE_DUMMY_PROPERTY
};
ScanLine* scan_line_new (void);
ScanLine* scan_line_construct (GType object_type);
static void scan_line_finalize (ScanLine* obj);
GType scan_mode_get_type (void) G_GNUC_CONST;
GType scan_type_get_type (void) G_GNUC_CONST;
gpointer scan_options_ref (gpointer instance);
void scan_options_unref (gpointer instance);
GParamSpec* param_spec_scan_options (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_options (GValue* value, gpointer v_object);
void value_take_scan_options (GValue* value, gpointer v_object);
gpointer value_get_scan_options (const GValue* value);
GType scan_options_get_type (void) G_GNUC_CONST;
enum  {
	SCAN_OPTIONS_DUMMY_PROPERTY
};
ScanOptions* scan_options_new (void);
ScanOptions* scan_options_construct (GType object_type);
static void scan_options_finalize (ScanOptions* obj);
gpointer scan_job_ref (gpointer instance);
void scan_job_unref (gpointer instance);
GParamSpec* param_spec_scan_job (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_job (GValue* value, gpointer v_object);
void value_take_scan_job (GValue* value, gpointer v_object);
gpointer value_get_scan_job (const GValue* value);
GType scan_job_get_type (void) G_GNUC_CONST;
enum  {
	SCAN_JOB_DUMMY_PROPERTY
};
ScanJob* scan_job_new (void);
ScanJob* scan_job_construct (GType object_type);
static void scan_job_finalize (ScanJob* obj);
gpointer request_ref (gpointer instance);
void request_unref (gpointer instance);
GParamSpec* param_spec_request (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_request (GValue* value, gpointer v_object);
void value_take_request (GValue* value, gpointer v_object);
gpointer value_get_request (const GValue* value);
GType request_get_type (void) G_GNUC_CONST;
enum  {
	REQUEST_DUMMY_PROPERTY
};
Request* request_new (void);
Request* request_construct (GType object_type);
static void request_finalize (Request* obj);
GType request_redetect_get_type (void) G_GNUC_CONST;
enum  {
	REQUEST_REDETECT_DUMMY_PROPERTY
};
RequestRedetect* request_redetect_new (void);
RequestRedetect* request_redetect_construct (GType object_type);
GType request_cancel_get_type (void) G_GNUC_CONST;
enum  {
	REQUEST_CANCEL_DUMMY_PROPERTY
};
RequestCancel* request_cancel_new (void);
RequestCancel* request_cancel_construct (GType object_type);
GType request_start_scan_get_type (void) G_GNUC_CONST;
enum  {
	REQUEST_START_SCAN_DUMMY_PROPERTY
};
RequestStartScan* request_start_scan_new (void);
RequestStartScan* request_start_scan_construct (GType object_type);
static void request_start_scan_finalize (Request* obj);
GType request_quit_get_type (void) G_GNUC_CONST;
enum  {
	REQUEST_QUIT_DUMMY_PROPERTY
};
RequestQuit* request_quit_new (void);
RequestQuit* request_quit_construct (GType object_type);
gpointer credentials_ref (gpointer instance);
void credentials_unref (gpointer instance);
GParamSpec* param_spec_credentials (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_credentials (GValue* value, gpointer v_object);
void value_take_credentials (GValue* value, gpointer v_object);
gpointer value_get_credentials (const GValue* value);
GType credentials_get_type (void) G_GNUC_CONST;
enum  {
	CREDENTIALS_DUMMY_PROPERTY
};
Credentials* credentials_new (void);
Credentials* credentials_construct (GType object_type);
static void credentials_finalize (Credentials* obj);
GType scan_state_get_type (void) G_GNUC_CONST;
gpointer notify_ref (gpointer instance);
void notify_unref (gpointer instance);
GParamSpec* param_spec_notify (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_notify (GValue* value, gpointer v_object);
void value_take_notify (GValue* value, gpointer v_object);
gpointer value_get_notify (const GValue* value);
GType notify_get_type (void) G_GNUC_CONST;
gpointer scanner_ref (gpointer instance);
void scanner_unref (gpointer instance);
GParamSpec* param_spec_scanner (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scanner (GValue* value, gpointer v_object);
void value_take_scanner (GValue* value, gpointer v_object);
gpointer value_get_scanner (const GValue* value);
GType scanner_get_type (void) G_GNUC_CONST;
enum  {
	NOTIFY_DUMMY_PROPERTY
};
void notify_run (Notify* self, Scanner* scanner);
static void notify_real_run (Notify* self, Scanner* scanner);
Notify* notify_new (void);
Notify* notify_construct (GType object_type);
static void notify_finalize (Notify* obj);
GType notify_scanning_changed_get_type (void) G_GNUC_CONST;
enum  {
	NOTIFY_SCANNING_CHANGED_DUMMY_PROPERTY
};
static void notify_scanning_changed_real_run (Notify* base, Scanner* scanner);
NotifyScanningChanged* notify_scanning_changed_new (void);
NotifyScanningChanged* notify_scanning_changed_construct (GType object_type);
GType notify_update_devices_get_type (void) G_GNUC_CONST;
#define NOTIFY_UPDATE_DEVICES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NOTIFY_UPDATE_DEVICES, NotifyUpdateDevicesPrivate))
enum  {
	NOTIFY_UPDATE_DEVICES_DUMMY_PROPERTY
};
static void _scan_device_unref0_ (gpointer var);
static void _g_list_free__scan_device_unref0_ (GList* self);
NotifyUpdateDevices* notify_update_devices_new (GList* devices);
NotifyUpdateDevices* notify_update_devices_construct (GType object_type, GList* devices);
static void notify_update_devices_real_run (Notify* base, Scanner* scanner);
static void notify_update_devices_finalize (Notify* obj);
GType notify_request_authorization_get_type (void) G_GNUC_CONST;
#define NOTIFY_REQUEST_AUTHORIZATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NOTIFY_REQUEST_AUTHORIZATION, NotifyRequestAuthorizationPrivate))
enum  {
	NOTIFY_REQUEST_AUTHORIZATION_DUMMY_PROPERTY
};
NotifyRequestAuthorization* notify_request_authorization_new (const gchar* resource);
NotifyRequestAuthorization* notify_request_authorization_construct (GType object_type, const gchar* resource);
static void notify_request_authorization_real_run (Notify* base, Scanner* scanner);
static void notify_request_authorization_finalize (Notify* obj);
GType notify_scan_failed_get_type (void) G_GNUC_CONST;
#define NOTIFY_SCAN_FAILED_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NOTIFY_SCAN_FAILED, NotifyScanFailedPrivate))
enum  {
	NOTIFY_SCAN_FAILED_DUMMY_PROPERTY
};
NotifyScanFailed* notify_scan_failed_new (gint error_code, const gchar* error_string);
NotifyScanFailed* notify_scan_failed_construct (GType object_type, gint error_code, const gchar* error_string);
static void notify_scan_failed_real_run (Notify* base, Scanner* scanner);
static void notify_scan_failed_finalize (Notify* obj);
GType notify_document_done_get_type (void) G_GNUC_CONST;
enum  {
	NOTIFY_DOCUMENT_DONE_DUMMY_PROPERTY
};
static void notify_document_done_real_run (Notify* base, Scanner* scanner);
NotifyDocumentDone* notify_document_done_new (void);
NotifyDocumentDone* notify_document_done_construct (GType object_type);
GType notify_expect_page_get_type (void) G_GNUC_CONST;
enum  {
	NOTIFY_EXPECT_PAGE_DUMMY_PROPERTY
};
static void notify_expect_page_real_run (Notify* base, Scanner* scanner);
NotifyExpectPage* notify_expect_page_new (void);
NotifyExpectPage* notify_expect_page_construct (GType object_type);
GType notify_got_page_info_get_type (void) G_GNUC_CONST;
#define NOTIFY_GOT_PAGE_INFO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NOTIFY_GOT_PAGE_INFO, NotifyGotPageInfoPrivate))
enum  {
	NOTIFY_GOT_PAGE_INFO_DUMMY_PROPERTY
};
NotifyGotPageInfo* notify_got_page_info_new (ScanPageInfo* info);
NotifyGotPageInfo* notify_got_page_info_construct (GType object_type, ScanPageInfo* info);
static void notify_got_page_info_real_run (Notify* base, Scanner* scanner);
static void notify_got_page_info_finalize (Notify* obj);
GType notify_page_done_get_type (void) G_GNUC_CONST;
enum  {
	NOTIFY_PAGE_DONE_DUMMY_PROPERTY
};
static void notify_page_done_real_run (Notify* base, Scanner* scanner);
NotifyPageDone* notify_page_done_new (void);
NotifyPageDone* notify_page_done_construct (GType object_type);
GType notify_got_line_get_type (void) G_GNUC_CONST;
#define NOTIFY_GOT_LINE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NOTIFY_GOT_LINE, NotifyGotLinePrivate))
enum  {
	NOTIFY_GOT_LINE_DUMMY_PROPERTY
};
NotifyGotLine* notify_got_line_new (ScanLine* line);
NotifyGotLine* notify_got_line_construct (GType object_type, ScanLine* line);
static void notify_got_line_real_run (Notify* base, Scanner* scanner);
static void notify_got_line_finalize (Notify* obj);
#define SCANNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SCANNER, ScannerPrivate))
enum  {
	SCANNER_DUMMY_PROPERTY
};
static void _scan_job_unref0_ (gpointer var);
static void _g_list_free__scan_job_unref0_ (GList* self);
static Scanner* scanner_new (void);
static Scanner* scanner_construct (GType object_type);
Scanner* scanner_get_instance (void);
static gboolean scanner_notify_idle_cb (Scanner* self);
static void scanner_notify (Scanner* self, Notify* notification);
static gboolean _scanner_notify_idle_cb_gsource_func (gpointer self);
static void scanner_set_scanning (Scanner* self, gboolean is_scanning);
static gint scanner_get_device_weight (const gchar* device);
static gint scanner_compare_devices (ScanDevice* device1, ScanDevice* device2);
static void scanner_do_redetect (Scanner* self);
static gint _scanner_compare_devices_gcompare_func (gconstpointer a, gconstpointer b);
static gboolean scanner_set_default_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index);
static void scanner_set_bool_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, gboolean value, gboolean* _result_);
static void scanner_set_int_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, gint value, gint* _result_);
static void scanner_set_fixed_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, gdouble value, gdouble* _result_);
static gboolean scanner_set_string_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, const gchar* value, gchar** _result_);
static gboolean scanner_set_constrained_string_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, gchar** values, int values_length1, gchar** _result_);
static void scanner_log_option (Scanner* self, SANE_Int index, SANE_Option_Descriptor* option);
static void scanner_authorization_cb (const gchar* resource, gchar* username, int username_length1, gchar* password, int password_length1);
void scanner_authorize (Scanner* self, const gchar* username, const gchar* password);
static void scanner_close_device (Scanner* self);
static void scanner_fail_scan (Scanner* self, gint error_code, const gchar* error_string);
static gboolean scanner_handle_requests (Scanner* self);
static void scanner_do_open (Scanner* self);
static void scanner_do_get_option (Scanner* self);
static void scanner_do_complete_document (Scanner* self);
static void scanner_do_start (Scanner* self);
static void scanner_do_get_parameters (Scanner* self);
static void scanner_do_complete_page (Scanner* self);
static void scanner_do_read (Scanner* self);
static void* scanner_scan_thread (Scanner* self);
static void _scanner_authorization_cb_sane_authcallback (const gchar* resource, gchar* username, gchar* password);
void scanner_redetect (Scanner* self);
void scanner_start (Scanner* self);
static gpointer _scanner_scan_thread_gthread_func (gpointer self);
gboolean scanner_is_scanning (Scanner* self);
static gchar* scanner_get_scan_mode_string (Scanner* self, ScanMode mode);
static gchar* scanner_get_scan_type_string (Scanner* self, ScanType type);
void scanner_scan (Scanner* self, const gchar* device, ScanOptions* options);
void scanner_cancel (Scanner* self);
void scanner_free (Scanner* self);
static void g_cclosure_user_marshal_VOID__SCAN_PAGE_INFO (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__SCAN_LINE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__INT_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void scanner_finalize (Scanner* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


ScanDevice* scan_device_construct (GType object_type) {
	ScanDevice* self = NULL;
	self = (ScanDevice*) g_type_create_instance (object_type);
	return self;
}


ScanDevice* scan_device_new (void) {
	return scan_device_construct (TYPE_SCAN_DEVICE);
}


static void value_scan_device_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_scan_device_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		scan_device_unref (value->data[0].v_pointer);
	}
}


static void value_scan_device_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = scan_device_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_scan_device_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_scan_device_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ScanDevice* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = scan_device_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_scan_device_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ScanDevice** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = scan_device_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_scan_device (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecScanDevice* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SCAN_DEVICE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_scan_device (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_DEVICE), NULL);
	return value->data[0].v_pointer;
}


void value_set_scan_device (GValue* value, gpointer v_object) {
	ScanDevice* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_DEVICE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_DEVICE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		scan_device_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		scan_device_unref (old);
	}
}


void value_take_scan_device (GValue* value, gpointer v_object) {
	ScanDevice* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_DEVICE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_DEVICE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		scan_device_unref (old);
	}
}


static void scan_device_class_init (ScanDeviceClass * klass) {
	scan_device_parent_class = g_type_class_peek_parent (klass);
	SCAN_DEVICE_CLASS (klass)->finalize = scan_device_finalize;
}


static void scan_device_instance_init (ScanDevice * self) {
	self->ref_count = 1;
}


static void scan_device_finalize (ScanDevice* obj) {
	ScanDevice * self;
	self = SCAN_DEVICE (obj);
	_g_free0 (self->name);
	_g_free0 (self->label);
}


GType scan_device_get_type (void) {
	static volatile gsize scan_device_type_id__volatile = 0;
	if (g_once_init_enter (&scan_device_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_scan_device_init, value_scan_device_free_value, value_scan_device_copy_value, value_scan_device_peek_pointer, "p", value_scan_device_collect_value, "p", value_scan_device_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ScanDeviceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scan_device_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScanDevice), 0, (GInstanceInitFunc) scan_device_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType scan_device_type_id;
		scan_device_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ScanDevice", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&scan_device_type_id__volatile, scan_device_type_id);
	}
	return scan_device_type_id__volatile;
}


gpointer scan_device_ref (gpointer instance) {
	ScanDevice* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void scan_device_unref (gpointer instance) {
	ScanDevice* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SCAN_DEVICE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


ScanPageInfo* scan_page_info_construct (GType object_type) {
	ScanPageInfo* self = NULL;
	self = (ScanPageInfo*) g_type_create_instance (object_type);
	return self;
}


ScanPageInfo* scan_page_info_new (void) {
	return scan_page_info_construct (TYPE_SCAN_PAGE_INFO);
}


static void value_scan_page_info_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_scan_page_info_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		scan_page_info_unref (value->data[0].v_pointer);
	}
}


static void value_scan_page_info_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = scan_page_info_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_scan_page_info_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_scan_page_info_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ScanPageInfo* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = scan_page_info_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_scan_page_info_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ScanPageInfo** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = scan_page_info_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_scan_page_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecScanPageInfo* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SCAN_PAGE_INFO), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_scan_page_info (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_PAGE_INFO), NULL);
	return value->data[0].v_pointer;
}


void value_set_scan_page_info (GValue* value, gpointer v_object) {
	ScanPageInfo* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_PAGE_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_PAGE_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		scan_page_info_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		scan_page_info_unref (old);
	}
}


void value_take_scan_page_info (GValue* value, gpointer v_object) {
	ScanPageInfo* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_PAGE_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_PAGE_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		scan_page_info_unref (old);
	}
}


static void scan_page_info_class_init (ScanPageInfoClass * klass) {
	scan_page_info_parent_class = g_type_class_peek_parent (klass);
	SCAN_PAGE_INFO_CLASS (klass)->finalize = scan_page_info_finalize;
}


static void scan_page_info_instance_init (ScanPageInfo * self) {
	self->ref_count = 1;
}


static void scan_page_info_finalize (ScanPageInfo* obj) {
	ScanPageInfo * self;
	self = SCAN_PAGE_INFO (obj);
	_g_free0 (self->device);
}


GType scan_page_info_get_type (void) {
	static volatile gsize scan_page_info_type_id__volatile = 0;
	if (g_once_init_enter (&scan_page_info_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_scan_page_info_init, value_scan_page_info_free_value, value_scan_page_info_copy_value, value_scan_page_info_peek_pointer, "p", value_scan_page_info_collect_value, "p", value_scan_page_info_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ScanPageInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scan_page_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScanPageInfo), 0, (GInstanceInitFunc) scan_page_info_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType scan_page_info_type_id;
		scan_page_info_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ScanPageInfo", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&scan_page_info_type_id__volatile, scan_page_info_type_id);
	}
	return scan_page_info_type_id__volatile;
}


gpointer scan_page_info_ref (gpointer instance) {
	ScanPageInfo* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void scan_page_info_unref (gpointer instance) {
	ScanPageInfo* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SCAN_PAGE_INFO_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


ScanLine* scan_line_construct (GType object_type) {
	ScanLine* self = NULL;
	self = (ScanLine*) g_type_create_instance (object_type);
	return self;
}


ScanLine* scan_line_new (void) {
	return scan_line_construct (TYPE_SCAN_LINE);
}


static void value_scan_line_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_scan_line_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		scan_line_unref (value->data[0].v_pointer);
	}
}


static void value_scan_line_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = scan_line_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_scan_line_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_scan_line_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ScanLine* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = scan_line_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_scan_line_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ScanLine** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = scan_line_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_scan_line (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecScanLine* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SCAN_LINE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_scan_line (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_LINE), NULL);
	return value->data[0].v_pointer;
}


void value_set_scan_line (GValue* value, gpointer v_object) {
	ScanLine* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_LINE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_LINE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		scan_line_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		scan_line_unref (old);
	}
}


void value_take_scan_line (GValue* value, gpointer v_object) {
	ScanLine* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_LINE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_LINE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		scan_line_unref (old);
	}
}


static void scan_line_class_init (ScanLineClass * klass) {
	scan_line_parent_class = g_type_class_peek_parent (klass);
	SCAN_LINE_CLASS (klass)->finalize = scan_line_finalize;
}


static void scan_line_instance_init (ScanLine * self) {
	self->ref_count = 1;
}


static void scan_line_finalize (ScanLine* obj) {
	ScanLine * self;
	self = SCAN_LINE (obj);
	self->data = (g_free (self->data), NULL);
}


GType scan_line_get_type (void) {
	static volatile gsize scan_line_type_id__volatile = 0;
	if (g_once_init_enter (&scan_line_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_scan_line_init, value_scan_line_free_value, value_scan_line_copy_value, value_scan_line_peek_pointer, "p", value_scan_line_collect_value, "p", value_scan_line_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ScanLineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scan_line_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScanLine), 0, (GInstanceInitFunc) scan_line_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType scan_line_type_id;
		scan_line_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ScanLine", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&scan_line_type_id__volatile, scan_line_type_id);
	}
	return scan_line_type_id__volatile;
}


gpointer scan_line_ref (gpointer instance) {
	ScanLine* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void scan_line_unref (gpointer instance) {
	ScanLine* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SCAN_LINE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


GType scan_mode_get_type (void) {
	static volatile gsize scan_mode_type_id__volatile = 0;
	if (g_once_init_enter (&scan_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{SCAN_MODE_DEFAULT, "SCAN_MODE_DEFAULT", "default"}, {SCAN_MODE_COLOR, "SCAN_MODE_COLOR", "color"}, {SCAN_MODE_GRAY, "SCAN_MODE_GRAY", "gray"}, {SCAN_MODE_LINEART, "SCAN_MODE_LINEART", "lineart"}, {0, NULL, NULL}};
		GType scan_mode_type_id;
		scan_mode_type_id = g_enum_register_static ("ScanMode", values);
		g_once_init_leave (&scan_mode_type_id__volatile, scan_mode_type_id);
	}
	return scan_mode_type_id__volatile;
}


GType scan_type_get_type (void) {
	static volatile gsize scan_type_type_id__volatile = 0;
	if (g_once_init_enter (&scan_type_type_id__volatile)) {
		static const GEnumValue values[] = {{SCAN_TYPE_SINGLE, "SCAN_TYPE_SINGLE", "single"}, {SCAN_TYPE_ADF_FRONT, "SCAN_TYPE_ADF_FRONT", "adf-front"}, {SCAN_TYPE_ADF_BACK, "SCAN_TYPE_ADF_BACK", "adf-back"}, {SCAN_TYPE_ADF_BOTH, "SCAN_TYPE_ADF_BOTH", "adf-both"}, {0, NULL, NULL}};
		GType scan_type_type_id;
		scan_type_type_id = g_enum_register_static ("ScanType", values);
		g_once_init_leave (&scan_type_type_id__volatile, scan_type_type_id);
	}
	return scan_type_type_id__volatile;
}


ScanOptions* scan_options_construct (GType object_type) {
	ScanOptions* self = NULL;
	self = (ScanOptions*) g_type_create_instance (object_type);
	return self;
}


ScanOptions* scan_options_new (void) {
	return scan_options_construct (TYPE_SCAN_OPTIONS);
}


static void value_scan_options_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_scan_options_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		scan_options_unref (value->data[0].v_pointer);
	}
}


static void value_scan_options_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = scan_options_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_scan_options_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_scan_options_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ScanOptions* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = scan_options_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_scan_options_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ScanOptions** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = scan_options_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_scan_options (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecScanOptions* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SCAN_OPTIONS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_scan_options (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_OPTIONS), NULL);
	return value->data[0].v_pointer;
}


void value_set_scan_options (GValue* value, gpointer v_object) {
	ScanOptions* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_OPTIONS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_OPTIONS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		scan_options_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		scan_options_unref (old);
	}
}


void value_take_scan_options (GValue* value, gpointer v_object) {
	ScanOptions* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_OPTIONS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_OPTIONS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		scan_options_unref (old);
	}
}


static void scan_options_class_init (ScanOptionsClass * klass) {
	scan_options_parent_class = g_type_class_peek_parent (klass);
	SCAN_OPTIONS_CLASS (klass)->finalize = scan_options_finalize;
}


static void scan_options_instance_init (ScanOptions * self) {
	self->ref_count = 1;
}


static void scan_options_finalize (ScanOptions* obj) {
	ScanOptions * self;
	self = SCAN_OPTIONS (obj);
}


GType scan_options_get_type (void) {
	static volatile gsize scan_options_type_id__volatile = 0;
	if (g_once_init_enter (&scan_options_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_scan_options_init, value_scan_options_free_value, value_scan_options_copy_value, value_scan_options_peek_pointer, "p", value_scan_options_collect_value, "p", value_scan_options_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ScanOptionsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scan_options_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScanOptions), 0, (GInstanceInitFunc) scan_options_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType scan_options_type_id;
		scan_options_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ScanOptions", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&scan_options_type_id__volatile, scan_options_type_id);
	}
	return scan_options_type_id__volatile;
}


gpointer scan_options_ref (gpointer instance) {
	ScanOptions* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void scan_options_unref (gpointer instance) {
	ScanOptions* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SCAN_OPTIONS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


ScanJob* scan_job_construct (GType object_type) {
	ScanJob* self = NULL;
	self = (ScanJob*) g_type_create_instance (object_type);
	return self;
}


ScanJob* scan_job_new (void) {
	return scan_job_construct (TYPE_SCAN_JOB);
}


static void value_scan_job_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_scan_job_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		scan_job_unref (value->data[0].v_pointer);
	}
}


static void value_scan_job_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = scan_job_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_scan_job_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_scan_job_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ScanJob* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = scan_job_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_scan_job_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ScanJob** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = scan_job_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_scan_job (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecScanJob* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SCAN_JOB), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_scan_job (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_JOB), NULL);
	return value->data[0].v_pointer;
}


void value_set_scan_job (GValue* value, gpointer v_object) {
	ScanJob* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_JOB));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_JOB));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		scan_job_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		scan_job_unref (old);
	}
}


void value_take_scan_job (GValue* value, gpointer v_object) {
	ScanJob* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_JOB));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_JOB));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		scan_job_unref (old);
	}
}


static void scan_job_class_init (ScanJobClass * klass) {
	scan_job_parent_class = g_type_class_peek_parent (klass);
	SCAN_JOB_CLASS (klass)->finalize = scan_job_finalize;
}


static void scan_job_instance_init (ScanJob * self) {
	self->ref_count = 1;
}


static void scan_job_finalize (ScanJob* obj) {
	ScanJob * self;
	self = SCAN_JOB (obj);
	_g_free0 (self->device);
}


GType scan_job_get_type (void) {
	static volatile gsize scan_job_type_id__volatile = 0;
	if (g_once_init_enter (&scan_job_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_scan_job_init, value_scan_job_free_value, value_scan_job_copy_value, value_scan_job_peek_pointer, "p", value_scan_job_collect_value, "p", value_scan_job_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ScanJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scan_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScanJob), 0, (GInstanceInitFunc) scan_job_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType scan_job_type_id;
		scan_job_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ScanJob", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&scan_job_type_id__volatile, scan_job_type_id);
	}
	return scan_job_type_id__volatile;
}


gpointer scan_job_ref (gpointer instance) {
	ScanJob* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void scan_job_unref (gpointer instance) {
	ScanJob* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SCAN_JOB_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


Request* request_construct (GType object_type) {
	Request* self = NULL;
	self = (Request*) g_type_create_instance (object_type);
	return self;
}


Request* request_new (void) {
	return request_construct (TYPE_REQUEST);
}


static void value_request_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_request_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		request_unref (value->data[0].v_pointer);
	}
}


static void value_request_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = request_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_request_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_request_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Request* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = request_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_request_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Request** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = request_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_request (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecRequest* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_REQUEST), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_request (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_REQUEST), NULL);
	return value->data[0].v_pointer;
}


void value_set_request (GValue* value, gpointer v_object) {
	Request* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_REQUEST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_REQUEST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		request_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		request_unref (old);
	}
}


void value_take_request (GValue* value, gpointer v_object) {
	Request* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_REQUEST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_REQUEST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		request_unref (old);
	}
}


static void request_class_init (RequestClass * klass) {
	request_parent_class = g_type_class_peek_parent (klass);
	REQUEST_CLASS (klass)->finalize = request_finalize;
}


static void request_instance_init (Request * self) {
	self->ref_count = 1;
}


static void request_finalize (Request* obj) {
	Request * self;
	self = REQUEST (obj);
}


GType request_get_type (void) {
	static volatile gsize request_type_id__volatile = 0;
	if (g_once_init_enter (&request_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_request_init, value_request_free_value, value_request_copy_value, value_request_peek_pointer, "p", value_request_collect_value, "p", value_request_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RequestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) request_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Request), 0, (GInstanceInitFunc) request_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType request_type_id;
		request_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Request", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&request_type_id__volatile, request_type_id);
	}
	return request_type_id__volatile;
}


gpointer request_ref (gpointer instance) {
	Request* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void request_unref (gpointer instance) {
	Request* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		REQUEST_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


RequestRedetect* request_redetect_construct (GType object_type) {
	RequestRedetect* self = NULL;
	self = (RequestRedetect*) request_construct (object_type);
	return self;
}


RequestRedetect* request_redetect_new (void) {
	return request_redetect_construct (TYPE_REQUEST_REDETECT);
}


static void request_redetect_class_init (RequestRedetectClass * klass) {
	request_redetect_parent_class = g_type_class_peek_parent (klass);
}


static void request_redetect_instance_init (RequestRedetect * self) {
}


GType request_redetect_get_type (void) {
	static volatile gsize request_redetect_type_id__volatile = 0;
	if (g_once_init_enter (&request_redetect_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RequestRedetectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) request_redetect_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RequestRedetect), 0, (GInstanceInitFunc) request_redetect_instance_init, NULL };
		GType request_redetect_type_id;
		request_redetect_type_id = g_type_register_static (TYPE_REQUEST, "RequestRedetect", &g_define_type_info, 0);
		g_once_init_leave (&request_redetect_type_id__volatile, request_redetect_type_id);
	}
	return request_redetect_type_id__volatile;
}


RequestCancel* request_cancel_construct (GType object_type) {
	RequestCancel* self = NULL;
	self = (RequestCancel*) request_construct (object_type);
	return self;
}


RequestCancel* request_cancel_new (void) {
	return request_cancel_construct (TYPE_REQUEST_CANCEL);
}


static void request_cancel_class_init (RequestCancelClass * klass) {
	request_cancel_parent_class = g_type_class_peek_parent (klass);
}


static void request_cancel_instance_init (RequestCancel * self) {
}


GType request_cancel_get_type (void) {
	static volatile gsize request_cancel_type_id__volatile = 0;
	if (g_once_init_enter (&request_cancel_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RequestCancelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) request_cancel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RequestCancel), 0, (GInstanceInitFunc) request_cancel_instance_init, NULL };
		GType request_cancel_type_id;
		request_cancel_type_id = g_type_register_static (TYPE_REQUEST, "RequestCancel", &g_define_type_info, 0);
		g_once_init_leave (&request_cancel_type_id__volatile, request_cancel_type_id);
	}
	return request_cancel_type_id__volatile;
}


RequestStartScan* request_start_scan_construct (GType object_type) {
	RequestStartScan* self = NULL;
	self = (RequestStartScan*) request_construct (object_type);
	return self;
}


RequestStartScan* request_start_scan_new (void) {
	return request_start_scan_construct (TYPE_REQUEST_START_SCAN);
}


static void request_start_scan_class_init (RequestStartScanClass * klass) {
	request_start_scan_parent_class = g_type_class_peek_parent (klass);
	REQUEST_CLASS (klass)->finalize = request_start_scan_finalize;
}


static void request_start_scan_instance_init (RequestStartScan * self) {
}


static void request_start_scan_finalize (Request* obj) {
	RequestStartScan * self;
	self = REQUEST_START_SCAN (obj);
	_scan_job_unref0 (self->job);
	REQUEST_CLASS (request_start_scan_parent_class)->finalize (obj);
}


GType request_start_scan_get_type (void) {
	static volatile gsize request_start_scan_type_id__volatile = 0;
	if (g_once_init_enter (&request_start_scan_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RequestStartScanClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) request_start_scan_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RequestStartScan), 0, (GInstanceInitFunc) request_start_scan_instance_init, NULL };
		GType request_start_scan_type_id;
		request_start_scan_type_id = g_type_register_static (TYPE_REQUEST, "RequestStartScan", &g_define_type_info, 0);
		g_once_init_leave (&request_start_scan_type_id__volatile, request_start_scan_type_id);
	}
	return request_start_scan_type_id__volatile;
}


RequestQuit* request_quit_construct (GType object_type) {
	RequestQuit* self = NULL;
	self = (RequestQuit*) request_construct (object_type);
	return self;
}


RequestQuit* request_quit_new (void) {
	return request_quit_construct (TYPE_REQUEST_QUIT);
}


static void request_quit_class_init (RequestQuitClass * klass) {
	request_quit_parent_class = g_type_class_peek_parent (klass);
}


static void request_quit_instance_init (RequestQuit * self) {
}


GType request_quit_get_type (void) {
	static volatile gsize request_quit_type_id__volatile = 0;
	if (g_once_init_enter (&request_quit_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RequestQuitClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) request_quit_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RequestQuit), 0, (GInstanceInitFunc) request_quit_instance_init, NULL };
		GType request_quit_type_id;
		request_quit_type_id = g_type_register_static (TYPE_REQUEST, "RequestQuit", &g_define_type_info, 0);
		g_once_init_leave (&request_quit_type_id__volatile, request_quit_type_id);
	}
	return request_quit_type_id__volatile;
}


Credentials* credentials_construct (GType object_type) {
	Credentials* self = NULL;
	self = (Credentials*) g_type_create_instance (object_type);
	return self;
}


Credentials* credentials_new (void) {
	return credentials_construct (TYPE_CREDENTIALS);
}


static void value_credentials_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_credentials_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		credentials_unref (value->data[0].v_pointer);
	}
}


static void value_credentials_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = credentials_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_credentials_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_credentials_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Credentials* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = credentials_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_credentials_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Credentials** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = credentials_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_credentials (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecCredentials* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_CREDENTIALS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_credentials (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CREDENTIALS), NULL);
	return value->data[0].v_pointer;
}


void value_set_credentials (GValue* value, gpointer v_object) {
	Credentials* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CREDENTIALS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CREDENTIALS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		credentials_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		credentials_unref (old);
	}
}


void value_take_credentials (GValue* value, gpointer v_object) {
	Credentials* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CREDENTIALS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CREDENTIALS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		credentials_unref (old);
	}
}


static void credentials_class_init (CredentialsClass * klass) {
	credentials_parent_class = g_type_class_peek_parent (klass);
	CREDENTIALS_CLASS (klass)->finalize = credentials_finalize;
}


static void credentials_instance_init (Credentials * self) {
	self->ref_count = 1;
}


static void credentials_finalize (Credentials* obj) {
	Credentials * self;
	self = CREDENTIALS (obj);
	_g_free0 (self->username);
	_g_free0 (self->password);
}


GType credentials_get_type (void) {
	static volatile gsize credentials_type_id__volatile = 0;
	if (g_once_init_enter (&credentials_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_credentials_init, value_credentials_free_value, value_credentials_copy_value, value_credentials_peek_pointer, "p", value_credentials_collect_value, "p", value_credentials_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (CredentialsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) credentials_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Credentials), 0, (GInstanceInitFunc) credentials_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType credentials_type_id;
		credentials_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Credentials", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&credentials_type_id__volatile, credentials_type_id);
	}
	return credentials_type_id__volatile;
}


gpointer credentials_ref (gpointer instance) {
	Credentials* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void credentials_unref (gpointer instance) {
	Credentials* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		CREDENTIALS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


GType scan_state_get_type (void) {
	static volatile gsize scan_state_type_id__volatile = 0;
	if (g_once_init_enter (&scan_state_type_id__volatile)) {
		static const GEnumValue values[] = {{SCAN_STATE_IDLE, "SCAN_STATE_IDLE", "idle"}, {SCAN_STATE_REDETECT, "SCAN_STATE_REDETECT", "redetect"}, {SCAN_STATE_OPEN, "SCAN_STATE_OPEN", "open"}, {SCAN_STATE_GET_OPTION, "SCAN_STATE_GET_OPTION", "get-option"}, {SCAN_STATE_START, "SCAN_STATE_START", "start"}, {SCAN_STATE_GET_PARAMETERS, "SCAN_STATE_GET_PARAMETERS", "get-parameters"}, {SCAN_STATE_READ, "SCAN_STATE_READ", "read"}, {0, NULL, NULL}};
		GType scan_state_type_id;
		scan_state_type_id = g_enum_register_static ("ScanState", values);
		g_once_init_leave (&scan_state_type_id__volatile, scan_state_type_id);
	}
	return scan_state_type_id__volatile;
}


static void notify_real_run (Notify* self, Scanner* scanner) {
	g_return_if_fail (scanner != NULL);
}


void notify_run (Notify* self, Scanner* scanner) {
	g_return_if_fail (self != NULL);
	NOTIFY_GET_CLASS (self)->run (self, scanner);
}


Notify* notify_construct (GType object_type) {
	Notify* self = NULL;
	self = (Notify*) g_type_create_instance (object_type);
	return self;
}


Notify* notify_new (void) {
	return notify_construct (TYPE_NOTIFY);
}


static void value_notify_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_notify_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		notify_unref (value->data[0].v_pointer);
	}
}


static void value_notify_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = notify_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_notify_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_notify_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Notify* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = notify_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_notify_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Notify** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = notify_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_notify (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecNotify* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_NOTIFY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_notify (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_NOTIFY), NULL);
	return value->data[0].v_pointer;
}


void value_set_notify (GValue* value, gpointer v_object) {
	Notify* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_NOTIFY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_NOTIFY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		notify_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		notify_unref (old);
	}
}


void value_take_notify (GValue* value, gpointer v_object) {
	Notify* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_NOTIFY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_NOTIFY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		notify_unref (old);
	}
}


static void notify_class_init (NotifyClass * klass) {
	notify_parent_class = g_type_class_peek_parent (klass);
	NOTIFY_CLASS (klass)->finalize = notify_finalize;
	NOTIFY_CLASS (klass)->run = notify_real_run;
}


static void notify_instance_init (Notify * self) {
	self->ref_count = 1;
}


static void notify_finalize (Notify* obj) {
	Notify * self;
	self = NOTIFY (obj);
}


GType notify_get_type (void) {
	static volatile gsize notify_type_id__volatile = 0;
	if (g_once_init_enter (&notify_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_notify_init, value_notify_free_value, value_notify_copy_value, value_notify_peek_pointer, "p", value_notify_collect_value, "p", value_notify_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (NotifyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Notify), 0, (GInstanceInitFunc) notify_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType notify_type_id;
		notify_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Notify", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&notify_type_id__volatile, notify_type_id);
	}
	return notify_type_id__volatile;
}


gpointer notify_ref (gpointer instance) {
	Notify* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void notify_unref (gpointer instance) {
	Notify* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		NOTIFY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void notify_scanning_changed_real_run (Notify* base, Scanner* scanner) {
	NotifyScanningChanged * self;
	Scanner* _tmp0_;
	self = (NotifyScanningChanged*) base;
	g_return_if_fail (scanner != NULL);
	_tmp0_ = scanner;
	g_signal_emit_by_name (_tmp0_, "scanning-changed");
}


NotifyScanningChanged* notify_scanning_changed_construct (GType object_type) {
	NotifyScanningChanged* self = NULL;
	self = (NotifyScanningChanged*) notify_construct (object_type);
	return self;
}


NotifyScanningChanged* notify_scanning_changed_new (void) {
	return notify_scanning_changed_construct (TYPE_NOTIFY_SCANNING_CHANGED);
}


static void notify_scanning_changed_class_init (NotifyScanningChangedClass * klass) {
	notify_scanning_changed_parent_class = g_type_class_peek_parent (klass);
	NOTIFY_CLASS (klass)->run = notify_scanning_changed_real_run;
}


static void notify_scanning_changed_instance_init (NotifyScanningChanged * self) {
}


GType notify_scanning_changed_get_type (void) {
	static volatile gsize notify_scanning_changed_type_id__volatile = 0;
	if (g_once_init_enter (&notify_scanning_changed_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyScanningChangedClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_scanning_changed_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyScanningChanged), 0, (GInstanceInitFunc) notify_scanning_changed_instance_init, NULL };
		GType notify_scanning_changed_type_id;
		notify_scanning_changed_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyScanningChanged", &g_define_type_info, 0);
		g_once_init_leave (&notify_scanning_changed_type_id__volatile, notify_scanning_changed_type_id);
	}
	return notify_scanning_changed_type_id__volatile;
}


static void _scan_device_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (scan_device_unref (var), NULL));
}


static void _g_list_free__scan_device_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _scan_device_unref0_, NULL);
	g_list_free (self);
}


NotifyUpdateDevices* notify_update_devices_construct (GType object_type, GList* devices) {
	NotifyUpdateDevices* self = NULL;
	GList* _tmp0_;
	self = (NotifyUpdateDevices*) notify_construct (object_type);
	_tmp0_ = devices;
	devices = NULL;
	__g_list_free__scan_device_unref0_0 (self->priv->devices);
	self->priv->devices = _tmp0_;
	__g_list_free__scan_device_unref0_0 (devices);
	return self;
}


NotifyUpdateDevices* notify_update_devices_new (GList* devices) {
	return notify_update_devices_construct (TYPE_NOTIFY_UPDATE_DEVICES, devices);
}


static void notify_update_devices_real_run (Notify* base, Scanner* scanner) {
	NotifyUpdateDevices * self;
	Scanner* _tmp0_;
	GList* _tmp1_;
	self = (NotifyUpdateDevices*) base;
	g_return_if_fail (scanner != NULL);
	_tmp0_ = scanner;
	_tmp1_ = self->priv->devices;
	g_signal_emit_by_name (_tmp0_, "update-devices", _tmp1_);
}


static void notify_update_devices_class_init (NotifyUpdateDevicesClass * klass) {
	notify_update_devices_parent_class = g_type_class_peek_parent (klass);
	NOTIFY_CLASS (klass)->finalize = notify_update_devices_finalize;
	g_type_class_add_private (klass, sizeof (NotifyUpdateDevicesPrivate));
	NOTIFY_CLASS (klass)->run = notify_update_devices_real_run;
}


static void notify_update_devices_instance_init (NotifyUpdateDevices * self) {
	self->priv = NOTIFY_UPDATE_DEVICES_GET_PRIVATE (self);
}


static void notify_update_devices_finalize (Notify* obj) {
	NotifyUpdateDevices * self;
	self = NOTIFY_UPDATE_DEVICES (obj);
	__g_list_free__scan_device_unref0_0 (self->priv->devices);
	NOTIFY_CLASS (notify_update_devices_parent_class)->finalize (obj);
}


GType notify_update_devices_get_type (void) {
	static volatile gsize notify_update_devices_type_id__volatile = 0;
	if (g_once_init_enter (&notify_update_devices_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyUpdateDevicesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_update_devices_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyUpdateDevices), 0, (GInstanceInitFunc) notify_update_devices_instance_init, NULL };
		GType notify_update_devices_type_id;
		notify_update_devices_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyUpdateDevices", &g_define_type_info, 0);
		g_once_init_leave (&notify_update_devices_type_id__volatile, notify_update_devices_type_id);
	}
	return notify_update_devices_type_id__volatile;
}


NotifyRequestAuthorization* notify_request_authorization_construct (GType object_type, const gchar* resource) {
	NotifyRequestAuthorization* self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (resource != NULL, NULL);
	self = (NotifyRequestAuthorization*) notify_construct (object_type);
	_tmp0_ = resource;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->resource);
	self->priv->resource = _tmp1_;
	return self;
}


NotifyRequestAuthorization* notify_request_authorization_new (const gchar* resource) {
	return notify_request_authorization_construct (TYPE_NOTIFY_REQUEST_AUTHORIZATION, resource);
}


static void notify_request_authorization_real_run (Notify* base, Scanner* scanner) {
	NotifyRequestAuthorization * self;
	Scanner* _tmp0_;
	const gchar* _tmp1_;
	self = (NotifyRequestAuthorization*) base;
	g_return_if_fail (scanner != NULL);
	_tmp0_ = scanner;
	_tmp1_ = self->priv->resource;
	g_signal_emit_by_name (_tmp0_, "request-authorization", _tmp1_);
}


static void notify_request_authorization_class_init (NotifyRequestAuthorizationClass * klass) {
	notify_request_authorization_parent_class = g_type_class_peek_parent (klass);
	NOTIFY_CLASS (klass)->finalize = notify_request_authorization_finalize;
	g_type_class_add_private (klass, sizeof (NotifyRequestAuthorizationPrivate));
	NOTIFY_CLASS (klass)->run = notify_request_authorization_real_run;
}


static void notify_request_authorization_instance_init (NotifyRequestAuthorization * self) {
	self->priv = NOTIFY_REQUEST_AUTHORIZATION_GET_PRIVATE (self);
}


static void notify_request_authorization_finalize (Notify* obj) {
	NotifyRequestAuthorization * self;
	self = NOTIFY_REQUEST_AUTHORIZATION (obj);
	_g_free0 (self->priv->resource);
	NOTIFY_CLASS (notify_request_authorization_parent_class)->finalize (obj);
}


GType notify_request_authorization_get_type (void) {
	static volatile gsize notify_request_authorization_type_id__volatile = 0;
	if (g_once_init_enter (&notify_request_authorization_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyRequestAuthorizationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_request_authorization_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyRequestAuthorization), 0, (GInstanceInitFunc) notify_request_authorization_instance_init, NULL };
		GType notify_request_authorization_type_id;
		notify_request_authorization_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyRequestAuthorization", &g_define_type_info, 0);
		g_once_init_leave (&notify_request_authorization_type_id__volatile, notify_request_authorization_type_id);
	}
	return notify_request_authorization_type_id__volatile;
}


NotifyScanFailed* notify_scan_failed_construct (GType object_type, gint error_code, const gchar* error_string) {
	NotifyScanFailed* self = NULL;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (error_string != NULL, NULL);
	self = (NotifyScanFailed*) notify_construct (object_type);
	_tmp0_ = error_code;
	self->priv->error_code = _tmp0_;
	_tmp1_ = error_string;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (self->priv->error_string);
	self->priv->error_string = _tmp2_;
	return self;
}


NotifyScanFailed* notify_scan_failed_new (gint error_code, const gchar* error_string) {
	return notify_scan_failed_construct (TYPE_NOTIFY_SCAN_FAILED, error_code, error_string);
}


static void notify_scan_failed_real_run (Notify* base, Scanner* scanner) {
	NotifyScanFailed * self;
	Scanner* _tmp0_;
	gint _tmp1_;
	const gchar* _tmp2_;
	self = (NotifyScanFailed*) base;
	g_return_if_fail (scanner != NULL);
	_tmp0_ = scanner;
	_tmp1_ = self->priv->error_code;
	_tmp2_ = self->priv->error_string;
	g_signal_emit_by_name (_tmp0_, "scan-failed", _tmp1_, _tmp2_);
}


static void notify_scan_failed_class_init (NotifyScanFailedClass * klass) {
	notify_scan_failed_parent_class = g_type_class_peek_parent (klass);
	NOTIFY_CLASS (klass)->finalize = notify_scan_failed_finalize;
	g_type_class_add_private (klass, sizeof (NotifyScanFailedPrivate));
	NOTIFY_CLASS (klass)->run = notify_scan_failed_real_run;
}


static void notify_scan_failed_instance_init (NotifyScanFailed * self) {
	self->priv = NOTIFY_SCAN_FAILED_GET_PRIVATE (self);
}


static void notify_scan_failed_finalize (Notify* obj) {
	NotifyScanFailed * self;
	self = NOTIFY_SCAN_FAILED (obj);
	_g_free0 (self->priv->error_string);
	NOTIFY_CLASS (notify_scan_failed_parent_class)->finalize (obj);
}


GType notify_scan_failed_get_type (void) {
	static volatile gsize notify_scan_failed_type_id__volatile = 0;
	if (g_once_init_enter (&notify_scan_failed_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyScanFailedClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_scan_failed_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyScanFailed), 0, (GInstanceInitFunc) notify_scan_failed_instance_init, NULL };
		GType notify_scan_failed_type_id;
		notify_scan_failed_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyScanFailed", &g_define_type_info, 0);
		g_once_init_leave (&notify_scan_failed_type_id__volatile, notify_scan_failed_type_id);
	}
	return notify_scan_failed_type_id__volatile;
}


static void notify_document_done_real_run (Notify* base, Scanner* scanner) {
	NotifyDocumentDone * self;
	Scanner* _tmp0_;
	self = (NotifyDocumentDone*) base;
	g_return_if_fail (scanner != NULL);
	_tmp0_ = scanner;
	g_signal_emit_by_name (_tmp0_, "document-done");
}


NotifyDocumentDone* notify_document_done_construct (GType object_type) {
	NotifyDocumentDone* self = NULL;
	self = (NotifyDocumentDone*) notify_construct (object_type);
	return self;
}


NotifyDocumentDone* notify_document_done_new (void) {
	return notify_document_done_construct (TYPE_NOTIFY_DOCUMENT_DONE);
}


static void notify_document_done_class_init (NotifyDocumentDoneClass * klass) {
	notify_document_done_parent_class = g_type_class_peek_parent (klass);
	NOTIFY_CLASS (klass)->run = notify_document_done_real_run;
}


static void notify_document_done_instance_init (NotifyDocumentDone * self) {
}


GType notify_document_done_get_type (void) {
	static volatile gsize notify_document_done_type_id__volatile = 0;
	if (g_once_init_enter (&notify_document_done_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyDocumentDoneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_document_done_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyDocumentDone), 0, (GInstanceInitFunc) notify_document_done_instance_init, NULL };
		GType notify_document_done_type_id;
		notify_document_done_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyDocumentDone", &g_define_type_info, 0);
		g_once_init_leave (&notify_document_done_type_id__volatile, notify_document_done_type_id);
	}
	return notify_document_done_type_id__volatile;
}


static void notify_expect_page_real_run (Notify* base, Scanner* scanner) {
	NotifyExpectPage * self;
	Scanner* _tmp0_;
	self = (NotifyExpectPage*) base;
	g_return_if_fail (scanner != NULL);
	_tmp0_ = scanner;
	g_signal_emit_by_name (_tmp0_, "expect-page");
}


NotifyExpectPage* notify_expect_page_construct (GType object_type) {
	NotifyExpectPage* self = NULL;
	self = (NotifyExpectPage*) notify_construct (object_type);
	return self;
}


NotifyExpectPage* notify_expect_page_new (void) {
	return notify_expect_page_construct (TYPE_NOTIFY_EXPECT_PAGE);
}


static void notify_expect_page_class_init (NotifyExpectPageClass * klass) {
	notify_expect_page_parent_class = g_type_class_peek_parent (klass);
	NOTIFY_CLASS (klass)->run = notify_expect_page_real_run;
}


static void notify_expect_page_instance_init (NotifyExpectPage * self) {
}


GType notify_expect_page_get_type (void) {
	static volatile gsize notify_expect_page_type_id__volatile = 0;
	if (g_once_init_enter (&notify_expect_page_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyExpectPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_expect_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyExpectPage), 0, (GInstanceInitFunc) notify_expect_page_instance_init, NULL };
		GType notify_expect_page_type_id;
		notify_expect_page_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyExpectPage", &g_define_type_info, 0);
		g_once_init_leave (&notify_expect_page_type_id__volatile, notify_expect_page_type_id);
	}
	return notify_expect_page_type_id__volatile;
}


static gpointer _scan_page_info_ref0 (gpointer self) {
	return self ? scan_page_info_ref (self) : NULL;
}


NotifyGotPageInfo* notify_got_page_info_construct (GType object_type, ScanPageInfo* info) {
	NotifyGotPageInfo* self = NULL;
	ScanPageInfo* _tmp0_;
	ScanPageInfo* _tmp1_;
	g_return_val_if_fail (info != NULL, NULL);
	self = (NotifyGotPageInfo*) notify_construct (object_type);
	_tmp0_ = info;
	_tmp1_ = _scan_page_info_ref0 (_tmp0_);
	_scan_page_info_unref0 (self->priv->info);
	self->priv->info = _tmp1_;
	return self;
}


NotifyGotPageInfo* notify_got_page_info_new (ScanPageInfo* info) {
	return notify_got_page_info_construct (TYPE_NOTIFY_GOT_PAGE_INFO, info);
}


static void notify_got_page_info_real_run (Notify* base, Scanner* scanner) {
	NotifyGotPageInfo * self;
	Scanner* _tmp0_;
	ScanPageInfo* _tmp1_;
	self = (NotifyGotPageInfo*) base;
	g_return_if_fail (scanner != NULL);
	_tmp0_ = scanner;
	_tmp1_ = self->priv->info;
	g_signal_emit_by_name (_tmp0_, "got-page-info", _tmp1_);
}


static void notify_got_page_info_class_init (NotifyGotPageInfoClass * klass) {
	notify_got_page_info_parent_class = g_type_class_peek_parent (klass);
	NOTIFY_CLASS (klass)->finalize = notify_got_page_info_finalize;
	g_type_class_add_private (klass, sizeof (NotifyGotPageInfoPrivate));
	NOTIFY_CLASS (klass)->run = notify_got_page_info_real_run;
}


static void notify_got_page_info_instance_init (NotifyGotPageInfo * self) {
	self->priv = NOTIFY_GOT_PAGE_INFO_GET_PRIVATE (self);
}


static void notify_got_page_info_finalize (Notify* obj) {
	NotifyGotPageInfo * self;
	self = NOTIFY_GOT_PAGE_INFO (obj);
	_scan_page_info_unref0 (self->priv->info);
	NOTIFY_CLASS (notify_got_page_info_parent_class)->finalize (obj);
}


GType notify_got_page_info_get_type (void) {
	static volatile gsize notify_got_page_info_type_id__volatile = 0;
	if (g_once_init_enter (&notify_got_page_info_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyGotPageInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_got_page_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyGotPageInfo), 0, (GInstanceInitFunc) notify_got_page_info_instance_init, NULL };
		GType notify_got_page_info_type_id;
		notify_got_page_info_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyGotPageInfo", &g_define_type_info, 0);
		g_once_init_leave (&notify_got_page_info_type_id__volatile, notify_got_page_info_type_id);
	}
	return notify_got_page_info_type_id__volatile;
}


static void notify_page_done_real_run (Notify* base, Scanner* scanner) {
	NotifyPageDone * self;
	Scanner* _tmp0_;
	self = (NotifyPageDone*) base;
	g_return_if_fail (scanner != NULL);
	_tmp0_ = scanner;
	g_signal_emit_by_name (_tmp0_, "page-done");
}


NotifyPageDone* notify_page_done_construct (GType object_type) {
	NotifyPageDone* self = NULL;
	self = (NotifyPageDone*) notify_construct (object_type);
	return self;
}


NotifyPageDone* notify_page_done_new (void) {
	return notify_page_done_construct (TYPE_NOTIFY_PAGE_DONE);
}


static void notify_page_done_class_init (NotifyPageDoneClass * klass) {
	notify_page_done_parent_class = g_type_class_peek_parent (klass);
	NOTIFY_CLASS (klass)->run = notify_page_done_real_run;
}


static void notify_page_done_instance_init (NotifyPageDone * self) {
}


GType notify_page_done_get_type (void) {
	static volatile gsize notify_page_done_type_id__volatile = 0;
	if (g_once_init_enter (&notify_page_done_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyPageDoneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_page_done_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyPageDone), 0, (GInstanceInitFunc) notify_page_done_instance_init, NULL };
		GType notify_page_done_type_id;
		notify_page_done_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyPageDone", &g_define_type_info, 0);
		g_once_init_leave (&notify_page_done_type_id__volatile, notify_page_done_type_id);
	}
	return notify_page_done_type_id__volatile;
}


static gpointer _scan_line_ref0 (gpointer self) {
	return self ? scan_line_ref (self) : NULL;
}


NotifyGotLine* notify_got_line_construct (GType object_type, ScanLine* line) {
	NotifyGotLine* self = NULL;
	ScanLine* _tmp0_;
	ScanLine* _tmp1_;
	g_return_val_if_fail (line != NULL, NULL);
	self = (NotifyGotLine*) notify_construct (object_type);
	_tmp0_ = line;
	_tmp1_ = _scan_line_ref0 (_tmp0_);
	_scan_line_unref0 (self->priv->line);
	self->priv->line = _tmp1_;
	return self;
}


NotifyGotLine* notify_got_line_new (ScanLine* line) {
	return notify_got_line_construct (TYPE_NOTIFY_GOT_LINE, line);
}


static void notify_got_line_real_run (Notify* base, Scanner* scanner) {
	NotifyGotLine * self;
	Scanner* _tmp0_;
	ScanLine* _tmp1_;
	self = (NotifyGotLine*) base;
	g_return_if_fail (scanner != NULL);
	_tmp0_ = scanner;
	_tmp1_ = self->priv->line;
	g_signal_emit_by_name (_tmp0_, "got-line", _tmp1_);
}


static void notify_got_line_class_init (NotifyGotLineClass * klass) {
	notify_got_line_parent_class = g_type_class_peek_parent (klass);
	NOTIFY_CLASS (klass)->finalize = notify_got_line_finalize;
	g_type_class_add_private (klass, sizeof (NotifyGotLinePrivate));
	NOTIFY_CLASS (klass)->run = notify_got_line_real_run;
}


static void notify_got_line_instance_init (NotifyGotLine * self) {
	self->priv = NOTIFY_GOT_LINE_GET_PRIVATE (self);
}


static void notify_got_line_finalize (Notify* obj) {
	NotifyGotLine * self;
	self = NOTIFY_GOT_LINE (obj);
	_scan_line_unref0 (self->priv->line);
	NOTIFY_CLASS (notify_got_line_parent_class)->finalize (obj);
}


GType notify_got_line_get_type (void) {
	static volatile gsize notify_got_line_type_id__volatile = 0;
	if (g_once_init_enter (&notify_got_line_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyGotLineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_got_line_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyGotLine), 0, (GInstanceInitFunc) notify_got_line_instance_init, NULL };
		GType notify_got_line_type_id;
		notify_got_line_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyGotLine", &g_define_type_info, 0);
		g_once_init_leave (&notify_got_line_type_id__volatile, notify_got_line_type_id);
	}
	return notify_got_line_type_id__volatile;
}


static void _scan_job_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (scan_job_unref (var), NULL));
}


static void _g_list_free__scan_job_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _scan_job_unref0_, NULL);
	g_list_free (self);
}


static Scanner* scanner_construct (GType object_type) {
	Scanner* self = NULL;
	GAsyncQueue* _tmp0_;
	GAsyncQueue* _tmp1_;
	GAsyncQueue* _tmp2_;
	self = (Scanner*) g_type_create_instance (object_type);
	_tmp0_ = g_async_queue_new ();
	_g_async_queue_unref0 (self->priv->request_queue);
	self->priv->request_queue = _tmp0_;
	_tmp1_ = g_async_queue_new ();
	_g_async_queue_unref0 (self->priv->notify_queue);
	self->priv->notify_queue = _tmp1_;
	_tmp2_ = g_async_queue_new ();
	_g_async_queue_unref0 (self->priv->authorize_queue);
	self->priv->authorize_queue = _tmp2_;
	return self;
}


static Scanner* scanner_new (void) {
	return scanner_construct (TYPE_SCANNER);
}


static gpointer _scanner_ref0 (gpointer self) {
	return self ? scanner_ref (self) : NULL;
}


Scanner* scanner_get_instance (void) {
	Scanner* result = NULL;
	Scanner* _tmp0_;
	Scanner* _tmp2_;
	Scanner* _tmp3_;
	_tmp0_ = scanner_scanner_object;
	if (_tmp0_ == NULL) {
		Scanner* _tmp1_;
		_tmp1_ = scanner_new ();
		_scanner_unref0 (scanner_scanner_object);
		scanner_scanner_object = _tmp1_;
	}
	_tmp2_ = scanner_scanner_object;
	_tmp3_ = _scanner_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


static gboolean scanner_notify_idle_cb (Scanner* self) {
	gboolean result = FALSE;
	GAsyncQueue* _tmp0_;
	gpointer _tmp1_ = NULL;
	Notify* notification;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->notify_queue;
	_tmp1_ = g_async_queue_pop (_tmp0_);
	notification = (Notify*) _tmp1_;
	notify_run (notification, self);
	result = FALSE;
	_notify_unref0 (notification);
	return result;
}


static gpointer _notify_ref0 (gpointer self) {
	return self ? notify_ref (self) : NULL;
}


static gboolean _scanner_notify_idle_cb_gsource_func (gpointer self) {
	gboolean result;
	result = scanner_notify_idle_cb (self);
	return result;
}


static void scanner_notify (Scanner* self, Notify* notification) {
	GAsyncQueue* _tmp0_;
	Notify* _tmp1_;
	Notify* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (notification != NULL);
	_tmp0_ = self->priv->notify_queue;
	_tmp1_ = notification;
	_tmp2_ = _notify_ref0 (_tmp1_);
	g_async_queue_push (_tmp0_, _tmp2_);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _scanner_notify_idle_cb_gsource_func, scanner_ref (self), scanner_unref);
}


static void scanner_set_scanning (Scanner* self, gboolean is_scanning) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	gboolean _tmp4_;
	gboolean _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp2_ = self->priv->scanning;
	if (_tmp2_) {
		gboolean _tmp3_;
		_tmp3_ = is_scanning;
		_tmp1_ = !_tmp3_;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp4_ = _tmp1_;
	if (_tmp4_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_;
		gboolean _tmp8_;
		_tmp6_ = self->priv->scanning;
		if (!_tmp6_) {
			gboolean _tmp7_;
			_tmp7_ = is_scanning;
			_tmp5_ = _tmp7_;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp8_ = _tmp5_;
		_tmp0_ = _tmp8_;
	}
	_tmp9_ = _tmp0_;
	if (_tmp9_) {
		gboolean _tmp10_;
		NotifyScanningChanged* _tmp11_;
		NotifyScanningChanged* _tmp12_;
		_tmp10_ = is_scanning;
		self->priv->scanning = _tmp10_;
		g_signal_emit_by_name (self, "scanning-changed");
		_tmp11_ = notify_scanning_changed_new ();
		_tmp12_ = _tmp11_;
		scanner_notify (self, (Notify*) _tmp12_);
		_notify_unref0 (_tmp12_);
	}
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gint scanner_get_device_weight (const gchar* device) {
	gint result = 0;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (device != NULL, 0);
	_tmp0_ = device;
	_tmp1_ = g_str_has_prefix (_tmp0_, "vfl:");
	if (_tmp1_) {
		result = 2;
		return result;
	}
	_tmp2_ = device;
	_tmp3_ = string_contains (_tmp2_, "usb");
	if (_tmp3_) {
		result = 0;
		return result;
	}
	result = 1;
	return result;
}


static gint scanner_compare_devices (ScanDevice* device1, ScanDevice* device2) {
	gint result = 0;
	ScanDevice* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_ = 0;
	gint weight1;
	ScanDevice* _tmp3_;
	const gchar* _tmp4_;
	gint _tmp5_ = 0;
	gint weight2;
	gint _tmp6_;
	gint _tmp7_;
	GCompareFunc _tmp10_;
	ScanDevice* _tmp11_;
	const gchar* _tmp12_;
	ScanDevice* _tmp13_;
	const gchar* _tmp14_;
	gint _tmp15_ = 0;
	g_return_val_if_fail (device1 != NULL, 0);
	g_return_val_if_fail (device2 != NULL, 0);
	_tmp0_ = device1;
	_tmp1_ = _tmp0_->name;
	_tmp2_ = scanner_get_device_weight (_tmp1_);
	weight1 = _tmp2_;
	_tmp3_ = device2;
	_tmp4_ = _tmp3_->name;
	_tmp5_ = scanner_get_device_weight (_tmp4_);
	weight2 = _tmp5_;
	_tmp6_ = weight1;
	_tmp7_ = weight2;
	if (_tmp6_ != _tmp7_) {
		gint _tmp8_;
		gint _tmp9_;
		_tmp8_ = weight1;
		_tmp9_ = weight2;
		result = _tmp8_ - _tmp9_;
		return result;
	}
	_tmp10_ = g_strcmp0;
	_tmp11_ = device1;
	_tmp12_ = _tmp11_->label;
	_tmp13_ = device2;
	_tmp14_ = _tmp13_->label;
	_tmp15_ = _tmp10_ (_tmp12_, _tmp14_);
	result = _tmp15_;
	return result;
}


static gchar* sane_status_to_string (SANE_Status status) {
	gchar* result = NULL;
	SANE_Status _tmp0_;
	_tmp0_ = status;
	switch (_tmp0_) {
		case SANE_STATUS_GOOD:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("SANE_STATUS_GOOD");
			result = _tmp1_;
			return result;
		}
		case SANE_STATUS_UNSUPPORTED:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("SANE_STATUS_UNSUPPORTED");
			result = _tmp2_;
			return result;
		}
		case SANE_STATUS_CANCELLED:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("SANE_STATUS_CANCELLED");
			result = _tmp3_;
			return result;
		}
		case SANE_STATUS_DEVICE_BUSY:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("SANE_STATUS_DEVICE_BUSY");
			result = _tmp4_;
			return result;
		}
		case SANE_STATUS_INVAL:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("SANE_STATUS_INVAL");
			result = _tmp5_;
			return result;
		}
		case SANE_STATUS_EOF:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("SANE_STATUS_EOF");
			result = _tmp6_;
			return result;
		}
		case SANE_STATUS_JAMMED:
		{
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("SANE_STATUS_JAMMED");
			result = _tmp7_;
			return result;
		}
		case SANE_STATUS_NO_DOCS:
		{
			gchar* _tmp8_;
			_tmp8_ = g_strdup ("SANE_STATUS_NO_DOCS");
			result = _tmp8_;
			return result;
		}
		case SANE_STATUS_COVER_OPEN:
		{
			gchar* _tmp9_;
			_tmp9_ = g_strdup ("SANE_STATUS_COVER_OPEN");
			result = _tmp9_;
			return result;
		}
		case SANE_STATUS_IO_ERROR:
		{
			gchar* _tmp10_;
			_tmp10_ = g_strdup ("SANE_STATUS_IO_ERROR");
			result = _tmp10_;
			return result;
		}
		case SANE_STATUS_NO_MEM:
		{
			gchar* _tmp11_;
			_tmp11_ = g_strdup ("SANE_STATUS_NO_MEM");
			result = _tmp11_;
			return result;
		}
		case SANE_STATUS_ACCESS_DENIED:
		{
			gchar* _tmp12_;
			_tmp12_ = g_strdup ("SANE_STATUS_ACCESS_DENIED");
			result = _tmp12_;
			return result;
		}
		default:
		{
			SANE_Status _tmp13_;
			gchar* _tmp14_ = NULL;
			_tmp13_ = status;
			_tmp14_ = g_strdup_printf ("SANE_STATUS(%d)", (gint) _tmp13_);
			result = _tmp14_;
			return result;
		}
	}
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch9_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch9_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally9;
	__catch9_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally9:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gpointer _scan_device_ref0 (gpointer self) {
	return self ? scan_device_ref (self) : NULL;
}


static gint _scanner_compare_devices_gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = scanner_compare_devices (a, b);
	return result;
}


static void scanner_do_redetect (Scanner* self) {
	SANE_Device** device_list;
	gint device_list_length1;
	gint _device_list_size_;
	SANE_Device** _tmp0_ = NULL;
	SANE_Status _tmp1_ = 0;
	SANE_Status status;
	SANE_Status _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	SANE_Status _tmp5_;
	GList* devices;
	GList* _tmp57_;
	GList* _tmp64_;
	NotifyUpdateDevices* _tmp65_;
	NotifyUpdateDevices* _tmp66_;
	g_return_if_fail (self != NULL);
	device_list = NULL;
	device_list_length1 = 0;
	_device_list_size_ = device_list_length1;
	_tmp1_ = sane_get_devices (&_tmp0_, FALSE);
	device_list = _tmp0_;
	device_list_length1 = -1;
	_device_list_size_ = device_list_length1;
	status = _tmp1_;
	_tmp2_ = status;
	_tmp3_ = sane_status_to_string (_tmp2_);
	_tmp4_ = _tmp3_;
	g_debug ("scanner.vala:318: sane_get_devices () -> %s", _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = status;
	if (_tmp5_ != SANE_STATUS_GOOD) {
		SANE_Status _tmp6_;
		const gchar* _tmp7_ = NULL;
		_tmp6_ = status;
		_tmp7_ = sane_strstatus (_tmp6_);
		g_warning ("scanner.vala:321: Unable to get SANE devices: %s", _tmp7_);
		self->priv->need_redetect = FALSE;
		self->priv->state = SCAN_STATE_IDLE;
		return;
	}
	devices = NULL;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp8_;
			_tmp8_ = TRUE;
			while (TRUE) {
				gboolean _tmp9_;
				SANE_Device** _tmp11_;
				gint _tmp11__length1;
				gint _tmp12_;
				SANE_Device* _tmp13_;
				SANE_Device** _tmp14_;
				gint _tmp14__length1;
				gint _tmp15_;
				SANE_Device* _tmp16_;
				const gchar* _tmp17_;
				SANE_Device** _tmp18_;
				gint _tmp18__length1;
				gint _tmp19_;
				SANE_Device* _tmp20_;
				const gchar* _tmp21_;
				SANE_Device** _tmp22_;
				gint _tmp22__length1;
				gint _tmp23_;
				SANE_Device* _tmp24_;
				const gchar* _tmp25_;
				SANE_Device** _tmp26_;
				gint _tmp26__length1;
				gint _tmp27_;
				SANE_Device* _tmp28_;
				const gchar* _tmp29_;
				ScanDevice* _tmp30_;
				ScanDevice* scan_device;
				ScanDevice* _tmp31_;
				SANE_Device** _tmp32_;
				gint _tmp32__length1;
				gint _tmp33_;
				SANE_Device* _tmp34_;
				const gchar* _tmp35_;
				gchar* _tmp36_;
				SANE_Device** _tmp37_;
				gint _tmp37__length1;
				gint _tmp38_;
				SANE_Device* _tmp39_;
				const gchar* _tmp40_;
				gchar* _tmp41_;
				gchar* vendor;
				const gchar* _tmp42_;
				ScanDevice* _tmp44_;
				const gchar* _tmp45_;
				SANE_Device** _tmp46_;
				gint _tmp46__length1;
				gint _tmp47_;
				SANE_Device* _tmp48_;
				const gchar* _tmp49_;
				gchar* _tmp50_ = NULL;
				ScanDevice* _tmp51_;
				const gchar* _tmp52_;
				gchar* _tmp53_ = NULL;
				gchar* _tmp54_;
				ScanDevice* _tmp55_;
				ScanDevice* _tmp56_;
				_tmp9_ = _tmp8_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp8_ = FALSE;
				_tmp11_ = device_list;
				_tmp11__length1 = device_list_length1;
				_tmp12_ = i;
				_tmp13_ = _tmp11_[_tmp12_];
				if (!(_tmp13_ != NULL)) {
					break;
				}
				_tmp14_ = device_list;
				_tmp14__length1 = device_list_length1;
				_tmp15_ = i;
				_tmp16_ = _tmp14_[_tmp15_];
				_tmp17_ = _tmp16_->name;
				_tmp18_ = device_list;
				_tmp18__length1 = device_list_length1;
				_tmp19_ = i;
				_tmp20_ = _tmp18_[_tmp19_];
				_tmp21_ = _tmp20_->vendor;
				_tmp22_ = device_list;
				_tmp22__length1 = device_list_length1;
				_tmp23_ = i;
				_tmp24_ = _tmp22_[_tmp23_];
				_tmp25_ = _tmp24_->model;
				_tmp26_ = device_list;
				_tmp26__length1 = device_list_length1;
				_tmp27_ = i;
				_tmp28_ = _tmp26_[_tmp27_];
				_tmp29_ = _tmp28_->type;
				g_debug ("scanner.vala:330: Device: name=\"%s\" vendor=\"%s\" model=\"%s\" type=" \
"\"%s\"", _tmp17_, _tmp21_, _tmp25_, _tmp29_);
				_tmp30_ = scan_device_new ();
				scan_device = _tmp30_;
				_tmp31_ = scan_device;
				_tmp32_ = device_list;
				_tmp32__length1 = device_list_length1;
				_tmp33_ = i;
				_tmp34_ = _tmp32_[_tmp33_];
				_tmp35_ = _tmp34_->name;
				_tmp36_ = g_strdup (_tmp35_);
				_g_free0 (_tmp31_->name);
				_tmp31_->name = _tmp36_;
				_tmp37_ = device_list;
				_tmp37__length1 = device_list_length1;
				_tmp38_ = i;
				_tmp39_ = _tmp37_[_tmp38_];
				_tmp40_ = _tmp39_->vendor;
				_tmp41_ = g_strdup (_tmp40_);
				vendor = _tmp41_;
				_tmp42_ = vendor;
				if (g_strcmp0 (_tmp42_, "Hewlett-Packard") == 0) {
					gchar* _tmp43_;
					_tmp43_ = g_strdup ("HP");
					_g_free0 (vendor);
					vendor = _tmp43_;
				}
				_tmp44_ = scan_device;
				_tmp45_ = vendor;
				_tmp46_ = device_list;
				_tmp46__length1 = device_list_length1;
				_tmp47_ = i;
				_tmp48_ = _tmp46_[_tmp47_];
				_tmp49_ = _tmp48_->model;
				_tmp50_ = g_strdup_printf ("%s %s", _tmp45_, _tmp49_);
				_g_free0 (_tmp44_->label);
				_tmp44_->label = _tmp50_;
				_tmp51_ = scan_device;
				_tmp52_ = _tmp51_->label;
				_tmp53_ = string_replace (_tmp52_, "_", " ");
				_tmp54_ = _tmp53_;
				_g_free0 (_tmp54_);
				_tmp55_ = scan_device;
				_tmp56_ = _scan_device_ref0 (_tmp55_);
				devices = g_list_append (devices, _tmp56_);
				_g_free0 (vendor);
				_scan_device_unref0 (scan_device);
			}
		}
	}
	devices = g_list_sort (devices, _scanner_compare_devices_gcompare_func);
	self->priv->need_redetect = FALSE;
	self->priv->state = SCAN_STATE_IDLE;
	_tmp57_ = devices;
	if (_tmp57_ != NULL) {
		GList* _tmp58_;
		gconstpointer _tmp59_ = NULL;
		ScanDevice* _tmp60_;
		ScanDevice* device;
		ScanDevice* _tmp61_;
		const gchar* _tmp62_;
		gchar* _tmp63_;
		_tmp58_ = devices;
		_tmp59_ = g_list_nth_data (_tmp58_, (guint) 0);
		_tmp60_ = _scan_device_ref0 ((ScanDevice*) _tmp59_);
		device = _tmp60_;
		_tmp61_ = device;
		_tmp62_ = _tmp61_->name;
		_tmp63_ = g_strdup (_tmp62_);
		_g_free0 (self->priv->default_device);
		self->priv->default_device = _tmp63_;
		_scan_device_unref0 (device);
	} else {
		_g_free0 (self->priv->default_device);
		self->priv->default_device = NULL;
	}
	_tmp64_ = devices;
	devices = NULL;
	_tmp65_ = notify_update_devices_new (_tmp64_);
	_tmp66_ = _tmp65_;
	scanner_notify (self, (Notify*) _tmp66_);
	_notify_unref0 (_tmp66_);
	__g_list_free__scan_device_unref0_0 (devices);
}


static gboolean scanner_set_default_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index) {
	gboolean result = FALSE;
	SANE_Option_Descriptor* _tmp0_;
	SANE_Int _tmp1_;
	SANE_Handle _tmp2_;
	SANE_Int _tmp3_;
	SANE_Status _tmp4_ = 0;
	SANE_Status status;
	SANE_Int _tmp5_;
	SANE_Status _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	SANE_Status _tmp9_;
	SANE_Status _tmp14_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (option != NULL, FALSE);
	_tmp0_ = option;
	_tmp1_ = _tmp0_->cap;
	if ((_tmp1_ & SANE_CAP_AUTOMATIC) == ((SANE_Int) 0)) {
		result = FALSE;
		return result;
	}
	_tmp2_ = handle;
	_tmp3_ = option_index;
	_tmp4_ = sane_control_option (_tmp2_, _tmp3_, SANE_ACTION_SET_AUTO, NULL, NULL);
	status = _tmp4_;
	_tmp5_ = option_index;
	_tmp6_ = status;
	_tmp7_ = sane_status_to_string (_tmp6_);
	_tmp8_ = _tmp7_;
	g_debug ("scanner.vala:372: sane_control_option (%d, SANE_ACTION_SET_AUTO) -> %s", (gint) _tmp5_, _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = status;
	if (_tmp9_ != SANE_STATUS_GOOD) {
		SANE_Option_Descriptor* _tmp10_;
		const gchar* _tmp11_;
		SANE_Status _tmp12_;
		const gchar* _tmp13_ = NULL;
		_tmp10_ = option;
		_tmp11_ = _tmp10_->name;
		_tmp12_ = status;
		_tmp13_ = sane_strstatus (_tmp12_);
		g_warning ("scanner.vala:374: Error setting default option %s: %s", _tmp11_, _tmp13_);
	}
	_tmp14_ = status;
	result = _tmp14_ == SANE_STATUS_GOOD;
	return result;
}


static void scanner_set_bool_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, gboolean value, gboolean* _result_) {
	gboolean _vala_result = FALSE;
	SANE_Option_Descriptor* _tmp0_;
	SANE_Value_Type _tmp1_;
	gboolean _tmp2_;
	SANE_Bool v;
	SANE_Handle _tmp3_;
	SANE_Int _tmp4_;
	SANE_Status _tmp5_ = 0;
	SANE_Status status;
	SANE_Bool _tmp6_;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp8_;
	const gchar* _tmp9_ = NULL;
	gboolean _tmp10_;
	SANE_Int _tmp11_;
	const gchar* _tmp12_;
	SANE_Status _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (option != NULL);
	_tmp0_ = option;
	_tmp1_ = _tmp0_->type;
	g_return_if_fail (_tmp1_ == SANE_TYPE_BOOL);
	_tmp2_ = value;
	v = (SANE_Bool) _tmp2_;
	_tmp3_ = handle;
	_tmp4_ = option_index;
	_tmp5_ = sane_control_option (_tmp3_, _tmp4_, SANE_ACTION_SET_VALUE, &v, NULL);
	status = _tmp5_;
	_tmp6_ = v;
	_vala_result = (gboolean) _tmp6_;
	_tmp8_ = value;
	if (_tmp8_) {
		_tmp7_ = "SANE_TRUE";
	} else {
		_tmp7_ = "SANE_FALSE";
	}
	_tmp10_ = _vala_result;
	if (_tmp10_) {
		_tmp9_ = "SANE_TRUE";
	} else {
		_tmp9_ = "SANE_FALSE";
	}
	_tmp11_ = option_index;
	_tmp12_ = _tmp7_;
	_tmp13_ = status;
	_tmp14_ = sane_status_to_string (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = _tmp9_;
	g_debug ("scanner.vala:386: sane_control_option (%d, SANE_ACTION_SET_VALUE, %s) " \
"-> (%s, %s)", (gint) _tmp11_, _tmp12_, _tmp15_, _tmp16_);
	_g_free0 (_tmp15_);
	if (_result_) {
		*_result_ = _vala_result;
	}
}


static void scanner_set_int_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, gint value, gint* _result_) {
	gint _vala_result = 0;
	SANE_Option_Descriptor* _tmp0_;
	SANE_Value_Type _tmp1_;
	gint _tmp2_;
	SANE_Int v;
	SANE_Option_Descriptor* _tmp3_;
	SANE_Constraint_Type _tmp4_;
	SANE_Handle _tmp49_;
	SANE_Int _tmp50_;
	SANE_Status _tmp51_ = 0;
	SANE_Status status;
	SANE_Int _tmp52_;
	gint _tmp53_;
	gchar* _tmp54_ = NULL;
	gchar* _tmp55_;
	SANE_Int _tmp56_;
	SANE_Int _tmp57_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (option != NULL);
	_tmp0_ = option;
	_tmp1_ = _tmp0_->type;
	g_return_if_fail (_tmp1_ == SANE_TYPE_INT);
	_tmp2_ = value;
	v = (SANE_Int) _tmp2_;
	_tmp3_ = option;
	_tmp4_ = _tmp3_->constraint_type;
	if (_tmp4_ == SANE_CONSTRAINT_RANGE) {
		SANE_Option_Descriptor* _tmp5_;
		SANE_Range* _tmp6_;
		SANE_Word _tmp7_;
		SANE_Int _tmp12_;
		SANE_Option_Descriptor* _tmp13_;
		SANE_Range* _tmp14_;
		SANE_Word _tmp15_;
		SANE_Int _tmp19_;
		SANE_Option_Descriptor* _tmp20_;
		SANE_Range* _tmp21_;
		SANE_Word _tmp22_;
		_tmp5_ = option;
		_tmp6_ = _tmp5_->constraint.range;
		_tmp7_ = _tmp6_->quant;
		if (_tmp7_ != ((SANE_Word) 0)) {
			SANE_Int _tmp8_;
			SANE_Option_Descriptor* _tmp9_;
			SANE_Range* _tmp10_;
			SANE_Word _tmp11_;
			_tmp8_ = v;
			_tmp9_ = option;
			_tmp10_ = _tmp9_->constraint.range;
			_tmp11_ = _tmp10_->quant;
			v = _tmp8_ * _tmp11_;
		}
		_tmp12_ = v;
		_tmp13_ = option;
		_tmp14_ = _tmp13_->constraint.range;
		_tmp15_ = _tmp14_->min;
		if (_tmp12_ < ((SANE_Int) _tmp15_)) {
			SANE_Option_Descriptor* _tmp16_;
			SANE_Range* _tmp17_;
			SANE_Word _tmp18_;
			_tmp16_ = option;
			_tmp17_ = _tmp16_->constraint.range;
			_tmp18_ = _tmp17_->min;
			v = (SANE_Int) _tmp18_;
		}
		_tmp19_ = v;
		_tmp20_ = option;
		_tmp21_ = _tmp20_->constraint.range;
		_tmp22_ = _tmp21_->max;
		if (_tmp19_ > ((SANE_Int) _tmp22_)) {
			SANE_Option_Descriptor* _tmp23_;
			SANE_Range* _tmp24_;
			SANE_Word _tmp25_;
			_tmp23_ = option;
			_tmp24_ = _tmp23_->constraint.range;
			_tmp25_ = _tmp24_->max;
			v = (SANE_Int) _tmp25_;
		}
	} else {
		SANE_Option_Descriptor* _tmp26_;
		SANE_Constraint_Type _tmp27_;
		_tmp26_ = option;
		_tmp27_ = _tmp26_->constraint_type;
		if (_tmp27_ == SANE_CONSTRAINT_WORD_LIST) {
			gint _tmp28_;
			gint distance;
			gint nearest;
			gint _tmp48_;
			_tmp28_ = G_MAXINT;
			distance = _tmp28_;
			nearest = 0;
			{
				gint i;
				i = 0;
				{
					gboolean _tmp29_;
					_tmp29_ = TRUE;
					while (TRUE) {
						gboolean _tmp30_;
						gint _tmp32_;
						SANE_Option_Descriptor* _tmp33_;
						SANE_Word* _tmp34_;
						gint _tmp34__length1;
						SANE_Word _tmp35_;
						SANE_Option_Descriptor* _tmp36_;
						SANE_Word* _tmp37_;
						gint _tmp37__length1;
						gint _tmp38_;
						SANE_Word _tmp39_;
						gint x;
						gint _tmp40_;
						SANE_Int _tmp41_;
						gint d;
						gint _tmp42_;
						gint _tmp43_ = 0;
						gint _tmp44_;
						gint _tmp45_;
						_tmp30_ = _tmp29_;
						if (!_tmp30_) {
							gint _tmp31_;
							_tmp31_ = i;
							i = _tmp31_ + 1;
						}
						_tmp29_ = FALSE;
						_tmp32_ = i;
						_tmp33_ = option;
						_tmp34_ = _tmp33_->constraint.word_list;
						_tmp34__length1 = -1;
						_tmp35_ = _tmp34_[0];
						if (!(((SANE_Word) _tmp32_) < _tmp35_)) {
							break;
						}
						_tmp36_ = option;
						_tmp37_ = _tmp36_->constraint.word_list;
						_tmp37__length1 = -1;
						_tmp38_ = i;
						_tmp39_ = _tmp37_[_tmp38_ + 1];
						x = (gint) _tmp39_;
						_tmp40_ = x;
						_tmp41_ = v;
						d = (gint) (_tmp40_ - _tmp41_);
						_tmp42_ = d;
						_tmp43_ = abs (_tmp42_);
						d = _tmp43_;
						_tmp44_ = d;
						_tmp45_ = distance;
						if (_tmp44_ < _tmp45_) {
							gint _tmp46_;
							gint _tmp47_;
							_tmp46_ = d;
							distance = _tmp46_;
							_tmp47_ = x;
							nearest = _tmp47_;
						}
					}
				}
			}
			_tmp48_ = nearest;
			v = (SANE_Int) _tmp48_;
		}
	}
	_tmp49_ = handle;
	_tmp50_ = option_index;
	_tmp51_ = sane_control_option (_tmp49_, _tmp50_, SANE_ACTION_SET_VALUE, &v, NULL);
	status = _tmp51_;
	_tmp52_ = option_index;
	_tmp53_ = value;
	_tmp54_ = sane_status_to_string (status);
	_tmp55_ = _tmp54_;
	_tmp56_ = v;
	g_debug ("scanner.vala:423: sane_control_option (%d, SANE_ACTION_SET_VALUE, %d) " \
"-> (%s, %d)", (gint) _tmp52_, _tmp53_, _tmp55_, (gint) _tmp56_);
	_g_free0 (_tmp55_);
	_tmp57_ = v;
	_vala_result = (gint) _tmp57_;
	if (_result_) {
		*_result_ = _vala_result;
	}
}


static void scanner_set_fixed_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, gdouble value, gdouble* _result_) {
	gdouble _vala_result = 0.0;
	gdouble _tmp0_;
	gdouble v;
	SANE_Fixed v_fixed = {0};
	SANE_Option_Descriptor* _tmp1_;
	SANE_Value_Type _tmp2_;
	SANE_Option_Descriptor* _tmp3_;
	SANE_Constraint_Type _tmp4_;
	gdouble _tmp43_;
	SANE_Fixed _tmp44_ = {0};
	SANE_Handle _tmp45_;
	SANE_Int _tmp46_;
	SANE_Status _tmp47_ = 0;
	SANE_Status status;
	SANE_Int _tmp48_;
	gdouble _tmp49_;
	gchar* _tmp50_ = NULL;
	gchar* _tmp51_;
	gdouble _tmp52_ = 0.0;
	gdouble _tmp53_ = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (option != NULL);
	_tmp0_ = value;
	v = _tmp0_;
	_tmp1_ = option;
	_tmp2_ = _tmp1_->type;
	g_return_if_fail (_tmp2_ == SANE_TYPE_FIXED);
	_tmp3_ = option;
	_tmp4_ = _tmp3_->constraint_type;
	if (_tmp4_ == SANE_CONSTRAINT_RANGE) {
		SANE_Option_Descriptor* _tmp5_;
		SANE_Range* _tmp6_;
		SANE_Word _tmp7_;
		gdouble _tmp8_ = 0.0;
		gdouble min;
		SANE_Option_Descriptor* _tmp9_;
		SANE_Range* _tmp10_;
		SANE_Word _tmp11_;
		gdouble _tmp12_ = 0.0;
		gdouble max;
		gdouble _tmp13_;
		gdouble _tmp14_;
		gdouble _tmp16_;
		gdouble _tmp17_;
		_tmp5_ = option;
		_tmp6_ = _tmp5_->constraint.range;
		_tmp7_ = _tmp6_->min;
		_tmp8_ = SANE_UNFIX ((SANE_Fixed) _tmp7_);
		min = _tmp8_;
		_tmp9_ = option;
		_tmp10_ = _tmp9_->constraint.range;
		_tmp11_ = _tmp10_->max;
		_tmp12_ = SANE_UNFIX ((SANE_Fixed) _tmp11_);
		max = _tmp12_;
		_tmp13_ = v;
		_tmp14_ = min;
		if (_tmp13_ < _tmp14_) {
			gdouble _tmp15_;
			_tmp15_ = min;
			v = _tmp15_;
		}
		_tmp16_ = v;
		_tmp17_ = max;
		if (_tmp16_ > _tmp17_) {
			gdouble _tmp18_;
			_tmp18_ = max;
			v = _tmp18_;
		}
	} else {
		SANE_Option_Descriptor* _tmp19_;
		SANE_Constraint_Type _tmp20_;
		_tmp19_ = option;
		_tmp20_ = _tmp19_->constraint_type;
		if (_tmp20_ == SANE_CONSTRAINT_WORD_LIST) {
			gdouble _tmp21_;
			gdouble distance;
			gdouble nearest;
			gdouble _tmp42_;
			_tmp21_ = DBL_MAX;
			distance = _tmp21_;
			nearest = 0.0;
			{
				gint i;
				i = 0;
				{
					gboolean _tmp22_;
					_tmp22_ = TRUE;
					while (TRUE) {
						gboolean _tmp23_;
						gint _tmp25_;
						SANE_Option_Descriptor* _tmp26_;
						SANE_Word* _tmp27_;
						gint _tmp27__length1;
						SANE_Word _tmp28_;
						SANE_Option_Descriptor* _tmp29_;
						SANE_Word* _tmp30_;
						gint _tmp30__length1;
						gint _tmp31_;
						SANE_Word _tmp32_;
						gdouble _tmp33_ = 0.0;
						gdouble x;
						gdouble _tmp34_;
						gdouble _tmp35_;
						gdouble _tmp36_ = 0.0;
						gdouble _tmp37_;
						_tmp23_ = _tmp22_;
						if (!_tmp23_) {
							gint _tmp24_;
							_tmp24_ = i;
							i = _tmp24_ + 1;
						}
						_tmp22_ = FALSE;
						_tmp25_ = i;
						_tmp26_ = option;
						_tmp27_ = _tmp26_->constraint.word_list;
						_tmp27__length1 = -1;
						_tmp28_ = _tmp27_[0];
						if (!(((SANE_Word) _tmp25_) < _tmp28_)) {
							break;
						}
						_tmp29_ = option;
						_tmp30_ = _tmp29_->constraint.word_list;
						_tmp30__length1 = -1;
						_tmp31_ = i;
						_tmp32_ = _tmp30_[_tmp31_ + 1];
						_tmp33_ = SANE_UNFIX ((SANE_Fixed) _tmp32_);
						x = _tmp33_;
						_tmp34_ = x;
						_tmp35_ = v;
						_tmp36_ = fabs (_tmp34_ - _tmp35_);
						_tmp37_ = distance;
						if (_tmp36_ < _tmp37_) {
							gdouble _tmp38_;
							gdouble _tmp39_;
							gdouble _tmp40_ = 0.0;
							gdouble _tmp41_;
							_tmp38_ = x;
							_tmp39_ = v;
							_tmp40_ = fabs (_tmp38_ - _tmp39_);
							distance = _tmp40_;
							_tmp41_ = x;
							nearest = _tmp41_;
						}
					}
				}
			}
			_tmp42_ = nearest;
			v = _tmp42_;
		}
	}
	_tmp43_ = v;
	_tmp44_ = SANE_FIX (_tmp43_);
	v_fixed = _tmp44_;
	_tmp45_ = handle;
	_tmp46_ = option_index;
	_tmp47_ = sane_control_option (_tmp45_, _tmp46_, SANE_ACTION_SET_VALUE, &v_fixed, NULL);
	status = _tmp47_;
	_tmp48_ = option_index;
	_tmp49_ = value;
	_tmp50_ = sane_status_to_string (status);
	_tmp51_ = _tmp50_;
	_tmp52_ = SANE_UNFIX (v_fixed);
	g_debug ("scanner.vala:463: sane_control_option (%d, SANE_ACTION_SET_VALUE, %f) " \
"-> (%s, %f)", (gint) _tmp48_, _tmp49_, _tmp51_, _tmp52_);
	_g_free0 (_tmp51_);
	_tmp53_ = SANE_UNFIX (v_fixed);
	_vala_result = _tmp53_;
	if (_result_) {
		*_result_ = _vala_result;
	}
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gboolean scanner_set_string_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, const gchar* value, gchar** _result_) {
	gchar* _vala_result = NULL;
	gboolean result = FALSE;
	SANE_Option_Descriptor* _tmp0_;
	SANE_Value_Type _tmp1_;
	SANE_Option_Descriptor* _tmp2_;
	SANE_Int _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* s;
	gint s_length1;
	gint _s_size_;
	gint i;
	gchar* _tmp22_;
	gint _tmp22__length1;
	gint _tmp23_;
	gchar _tmp24_;
	SANE_Handle _tmp25_;
	SANE_Int _tmp26_;
	gchar* _tmp27_;
	gint _tmp27__length1;
	SANE_Status _tmp28_ = 0;
	SANE_Status status;
	gchar* _tmp29_;
	gint _tmp29__length1;
	gchar* _tmp30_;
	SANE_Int _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp33_ = NULL;
	gchar* _tmp34_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (option != NULL, FALSE);
	g_return_val_if_fail (value != NULL, FALSE);
	_tmp0_ = option;
	_tmp1_ = _tmp0_->type;
	g_return_val_if_fail (_tmp1_ == SANE_TYPE_STRING, FALSE);
	_tmp2_ = option;
	_tmp3_ = _tmp2_->size;
	_tmp4_ = g_new0 (gchar, _tmp3_);
	s = _tmp4_;
	s_length1 = _tmp3_;
	_s_size_ = s_length1;
	i = 0;
	{
		gboolean _tmp5_;
		_tmp5_ = TRUE;
		while (TRUE) {
			gboolean _tmp6_;
			gboolean _tmp8_ = FALSE;
			gint _tmp9_;
			SANE_Option_Descriptor* _tmp10_;
			SANE_Int _tmp11_;
			gboolean _tmp15_;
			gchar* _tmp16_;
			gint _tmp16__length1;
			gint _tmp17_;
			const gchar* _tmp18_;
			gint _tmp19_;
			gchar _tmp20_ = '\0';
			gchar _tmp21_;
			_tmp6_ = _tmp5_;
			if (!_tmp6_) {
				gint _tmp7_;
				_tmp7_ = i;
				i = _tmp7_ + 1;
			}
			_tmp5_ = FALSE;
			_tmp9_ = i;
			_tmp10_ = option;
			_tmp11_ = _tmp10_->size;
			if (((SANE_Int) _tmp9_) < (_tmp11_ - 1)) {
				const gchar* _tmp12_;
				gint _tmp13_;
				gchar _tmp14_ = '\0';
				_tmp12_ = value;
				_tmp13_ = i;
				_tmp14_ = string_get (_tmp12_, (glong) _tmp13_);
				_tmp8_ = _tmp14_ != '\0';
			} else {
				_tmp8_ = FALSE;
			}
			_tmp15_ = _tmp8_;
			if (!_tmp15_) {
				break;
			}
			_tmp16_ = s;
			_tmp16__length1 = s_length1;
			_tmp17_ = i;
			_tmp18_ = value;
			_tmp19_ = i;
			_tmp20_ = string_get (_tmp18_, (glong) _tmp19_);
			_tmp16_[_tmp17_] = _tmp20_;
			_tmp21_ = _tmp16_[_tmp17_];
		}
	}
	_tmp22_ = s;
	_tmp22__length1 = s_length1;
	_tmp23_ = i;
	_tmp22_[_tmp23_] = '\0';
	_tmp24_ = _tmp22_[_tmp23_];
	_tmp25_ = handle;
	_tmp26_ = option_index;
	_tmp27_ = s;
	_tmp27__length1 = s_length1;
	_tmp28_ = sane_control_option (_tmp25_, _tmp26_, SANE_ACTION_SET_VALUE, _tmp27_, NULL);
	status = _tmp28_;
	_tmp29_ = s;
	_tmp29__length1 = s_length1;
	_tmp30_ = g_strdup ((const gchar*) _tmp29_);
	_g_free0 (_vala_result);
	_vala_result = _tmp30_;
	_tmp31_ = option_index;
	_tmp32_ = value;
	_tmp33_ = sane_status_to_string (status);
	_tmp34_ = _tmp33_;
	g_debug ("scanner.vala:479: sane_control_option (%d, SANE_ACTION_SET_VALUE, \"%s" \
"\") -> (%s, \"%s\")", (gint) _tmp31_, _tmp32_, _tmp34_, _vala_result);
	_g_free0 (_tmp34_);
	result = status == SANE_STATUS_GOOD;
	s = (g_free (s), NULL);
	if (_result_) {
		*_result_ = _vala_result;
	} else {
		_g_free0 (_vala_result);
	}
	return result;
}


static gboolean scanner_set_constrained_string_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, gchar** values, int values_length1, gchar** _result_) {
	gchar* _vala_result = NULL;
	gboolean result = FALSE;
	SANE_Option_Descriptor* _tmp0_;
	SANE_Value_Type _tmp1_;
	SANE_Option_Descriptor* _tmp2_;
	SANE_Constraint_Type _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (option != NULL, FALSE);
	_tmp0_ = option;
	_tmp1_ = _tmp0_->type;
	g_return_val_if_fail (_tmp1_ == SANE_TYPE_STRING, FALSE);
	_tmp2_ = option;
	_tmp3_ = _tmp2_->constraint_type;
	g_return_val_if_fail (_tmp3_ == SANE_CONSTRAINT_STRING_LIST, FALSE);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_;
				gchar** _tmp7_;
				gint _tmp7__length1;
				gint _tmp8_;
				const gchar* _tmp9_;
				gint j;
				SANE_Option_Descriptor* _tmp24_;
				gchar** _tmp25_;
				gint _tmp25__length1;
				gint _tmp26_;
				const gchar* _tmp27_;
				_tmp5_ = _tmp4_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp7_ = values;
				_tmp7__length1 = values_length1;
				_tmp8_ = i;
				_tmp9_ = _tmp7_[_tmp8_];
				if (!(_tmp9_ != NULL)) {
					break;
				}
				j = 0;
				{
					gboolean _tmp10_;
					_tmp10_ = TRUE;
					while (TRUE) {
						gboolean _tmp11_;
						SANE_Option_Descriptor* _tmp13_;
						gchar** _tmp14_;
						gint _tmp14__length1;
						gint _tmp15_;
						const gchar* _tmp16_;
						gchar** _tmp17_;
						gint _tmp17__length1;
						gint _tmp18_;
						const gchar* _tmp19_;
						SANE_Option_Descriptor* _tmp20_;
						gchar** _tmp21_;
						gint _tmp21__length1;
						gint _tmp22_;
						const gchar* _tmp23_;
						_tmp11_ = _tmp10_;
						if (!_tmp11_) {
							gint _tmp12_;
							_tmp12_ = j;
							j = _tmp12_ + 1;
						}
						_tmp10_ = FALSE;
						_tmp13_ = option;
						_tmp14_ = _tmp13_->constraint.string_list;
						_tmp14__length1 = -1;
						_tmp15_ = j;
						_tmp16_ = _tmp14_[_tmp15_];
						if (!(_tmp16_ != NULL)) {
							break;
						}
						_tmp17_ = values;
						_tmp17__length1 = values_length1;
						_tmp18_ = i;
						_tmp19_ = _tmp17_[_tmp18_];
						_tmp20_ = option;
						_tmp21_ = _tmp20_->constraint.string_list;
						_tmp21__length1 = -1;
						_tmp22_ = j;
						_tmp23_ = _tmp21_[_tmp22_];
						if (g_strcmp0 (_tmp19_, _tmp23_) == 0) {
							break;
						}
					}
				}
				_tmp24_ = option;
				_tmp25_ = _tmp24_->constraint.string_list;
				_tmp25__length1 = -1;
				_tmp26_ = j;
				_tmp27_ = _tmp25_[_tmp26_];
				if (_tmp27_ != NULL) {
					SANE_Handle _tmp28_;
					SANE_Option_Descriptor* _tmp29_;
					SANE_Int _tmp30_;
					gchar** _tmp31_;
					gint _tmp31__length1;
					gint _tmp32_;
					const gchar* _tmp33_;
					gchar* _tmp34_ = NULL;
					gboolean _tmp35_ = FALSE;
					_tmp28_ = handle;
					_tmp29_ = option;
					_tmp30_ = option_index;
					_tmp31_ = values;
					_tmp31__length1 = values_length1;
					_tmp32_ = i;
					_tmp33_ = _tmp31_[_tmp32_];
					_tmp35_ = scanner_set_string_option (self, _tmp28_, _tmp29_, _tmp30_, _tmp33_, &_tmp34_);
					_g_free0 (_vala_result);
					_vala_result = _tmp34_;
					result = _tmp35_;
					if (_result_) {
						*_result_ = _vala_result;
					} else {
						_g_free0 (_vala_result);
					}
					return result;
				}
			}
		}
	}
	result = FALSE;
	if (_result_) {
		*_result_ = _vala_result;
	} else {
		_g_free0 (_vala_result);
	}
	return result;
}


static void scanner_log_option (Scanner* self, SANE_Int index, SANE_Option_Descriptor* option) {
	SANE_Int _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* s;
	SANE_Option_Descriptor* _tmp2_;
	const gchar* _tmp3_;
	SANE_Option_Descriptor* _tmp10_;
	const gchar* _tmp11_;
	SANE_Option_Descriptor* _tmp18_;
	SANE_Value_Type _tmp19_;
	const gchar* _tmp38_;
	SANE_Option_Descriptor* _tmp39_;
	SANE_Int _tmp40_;
	gchar* _tmp41_ = NULL;
	gchar* _tmp42_;
	gchar* _tmp43_;
	SANE_Option_Descriptor* _tmp44_;
	SANE_Unit _tmp45_;
	SANE_Option_Descriptor* _tmp64_;
	SANE_Constraint_Type _tmp65_;
	SANE_Option_Descriptor* _tmp151_;
	SANE_Int _tmp152_;
	SANE_Int cap;
	SANE_Int _tmp153_;
	const gchar* _tmp214_;
	SANE_Option_Descriptor* _tmp215_;
	const gchar* _tmp216_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (option != NULL);
	_tmp0_ = index;
	_tmp1_ = g_strdup_printf ("Option %d:", (gint) _tmp0_);
	s = _tmp1_;
	_tmp2_ = option;
	_tmp3_ = _tmp2_->name;
	if (g_strcmp0 (_tmp3_, "") != 0) {
		const gchar* _tmp4_;
		SANE_Option_Descriptor* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp4_ = s;
		_tmp5_ = option;
		_tmp6_ = _tmp5_->name;
		_tmp7_ = g_strdup_printf (" name='%s'", _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strconcat (_tmp4_, _tmp8_, NULL);
		_g_free0 (s);
		s = _tmp9_;
		_g_free0 (_tmp8_);
	}
	_tmp10_ = option;
	_tmp11_ = _tmp10_->title;
	if (g_strcmp0 (_tmp11_, "") != 0) {
		const gchar* _tmp12_;
		SANE_Option_Descriptor* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp12_ = s;
		_tmp13_ = option;
		_tmp14_ = _tmp13_->title;
		_tmp15_ = g_strdup_printf (" title='%s'", _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strconcat (_tmp12_, _tmp16_, NULL);
		_g_free0 (s);
		s = _tmp17_;
		_g_free0 (_tmp16_);
	}
	_tmp18_ = option;
	_tmp19_ = _tmp18_->type;
	switch (_tmp19_) {
		case SANE_TYPE_BOOL:
		{
			const gchar* _tmp20_;
			gchar* _tmp21_;
			_tmp20_ = s;
			_tmp21_ = g_strconcat (_tmp20_, " type=bool", NULL);
			_g_free0 (s);
			s = _tmp21_;
			break;
		}
		case SANE_TYPE_INT:
		{
			const gchar* _tmp22_;
			gchar* _tmp23_;
			_tmp22_ = s;
			_tmp23_ = g_strconcat (_tmp22_, " type=int", NULL);
			_g_free0 (s);
			s = _tmp23_;
			break;
		}
		case SANE_TYPE_FIXED:
		{
			const gchar* _tmp24_;
			gchar* _tmp25_;
			_tmp24_ = s;
			_tmp25_ = g_strconcat (_tmp24_, " type=fixed", NULL);
			_g_free0 (s);
			s = _tmp25_;
			break;
		}
		case SANE_TYPE_STRING:
		{
			const gchar* _tmp26_;
			gchar* _tmp27_;
			_tmp26_ = s;
			_tmp27_ = g_strconcat (_tmp26_, " type=string", NULL);
			_g_free0 (s);
			s = _tmp27_;
			break;
		}
		case SANE_TYPE_BUTTON:
		{
			const gchar* _tmp28_;
			gchar* _tmp29_;
			_tmp28_ = s;
			_tmp29_ = g_strconcat (_tmp28_, " type=button", NULL);
			_g_free0 (s);
			s = _tmp29_;
			break;
		}
		case SANE_TYPE_GROUP:
		{
			const gchar* _tmp30_;
			gchar* _tmp31_;
			_tmp30_ = s;
			_tmp31_ = g_strconcat (_tmp30_, " type=group", NULL);
			_g_free0 (s);
			s = _tmp31_;
			break;
		}
		default:
		{
			const gchar* _tmp32_;
			SANE_Option_Descriptor* _tmp33_;
			SANE_Value_Type _tmp34_;
			gchar* _tmp35_ = NULL;
			gchar* _tmp36_;
			gchar* _tmp37_;
			_tmp32_ = s;
			_tmp33_ = option;
			_tmp34_ = _tmp33_->type;
			_tmp35_ = g_strdup_printf (" type=%d", (gint) _tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = g_strconcat (_tmp32_, _tmp36_, NULL);
			_g_free0 (s);
			s = _tmp37_;
			_g_free0 (_tmp36_);
			break;
		}
	}
	_tmp38_ = s;
	_tmp39_ = option;
	_tmp40_ = _tmp39_->size;
	_tmp41_ = g_strdup_printf (" size=%d", (gint) _tmp40_);
	_tmp42_ = _tmp41_;
	_tmp43_ = g_strconcat (_tmp38_, _tmp42_, NULL);
	_g_free0 (s);
	s = _tmp43_;
	_g_free0 (_tmp42_);
	_tmp44_ = option;
	_tmp45_ = _tmp44_->unit;
	switch (_tmp45_) {
		case SANE_UNIT_NONE:
		{
			break;
		}
		case SANE_UNIT_PIXEL:
		{
			const gchar* _tmp46_;
			gchar* _tmp47_;
			_tmp46_ = s;
			_tmp47_ = g_strconcat (_tmp46_, " unit=pixels", NULL);
			_g_free0 (s);
			s = _tmp47_;
			break;
		}
		case SANE_UNIT_BIT:
		{
			const gchar* _tmp48_;
			gchar* _tmp49_;
			_tmp48_ = s;
			_tmp49_ = g_strconcat (_tmp48_, " unit=bits", NULL);
			_g_free0 (s);
			s = _tmp49_;
			break;
		}
		case SANE_UNIT_MM:
		{
			const gchar* _tmp50_;
			gchar* _tmp51_;
			_tmp50_ = s;
			_tmp51_ = g_strconcat (_tmp50_, " unit=mm", NULL);
			_g_free0 (s);
			s = _tmp51_;
			break;
		}
		case SANE_UNIT_DPI:
		{
			const gchar* _tmp52_;
			gchar* _tmp53_;
			_tmp52_ = s;
			_tmp53_ = g_strconcat (_tmp52_, " unit=dpi", NULL);
			_g_free0 (s);
			s = _tmp53_;
			break;
		}
		case SANE_UNIT_PERCENT:
		{
			const gchar* _tmp54_;
			gchar* _tmp55_;
			_tmp54_ = s;
			_tmp55_ = g_strconcat (_tmp54_, " unit=percent", NULL);
			_g_free0 (s);
			s = _tmp55_;
			break;
		}
		case SANE_UNIT_MICROSECOND:
		{
			const gchar* _tmp56_;
			gchar* _tmp57_;
			_tmp56_ = s;
			_tmp57_ = g_strconcat (_tmp56_, " unit=microseconds", NULL);
			_g_free0 (s);
			s = _tmp57_;
			break;
		}
		default:
		{
			const gchar* _tmp58_;
			SANE_Option_Descriptor* _tmp59_;
			SANE_Unit _tmp60_;
			gchar* _tmp61_ = NULL;
			gchar* _tmp62_;
			gchar* _tmp63_;
			_tmp58_ = s;
			_tmp59_ = option;
			_tmp60_ = _tmp59_->unit;
			_tmp61_ = g_strdup_printf (" unit=%d", (gint) _tmp60_);
			_tmp62_ = _tmp61_;
			_tmp63_ = g_strconcat (_tmp58_, _tmp62_, NULL);
			_g_free0 (s);
			s = _tmp63_;
			_g_free0 (_tmp62_);
			break;
		}
	}
	_tmp64_ = option;
	_tmp65_ = _tmp64_->constraint_type;
	switch (_tmp65_) {
		case SANE_CONSTRAINT_RANGE:
		{
			SANE_Option_Descriptor* _tmp66_;
			SANE_Value_Type _tmp67_;
			_tmp66_ = option;
			_tmp67_ = _tmp66_->type;
			if (_tmp67_ == SANE_TYPE_FIXED) {
				const gchar* _tmp68_;
				SANE_Option_Descriptor* _tmp69_;
				SANE_Range* _tmp70_;
				SANE_Word _tmp71_;
				gdouble _tmp72_ = 0.0;
				SANE_Option_Descriptor* _tmp73_;
				SANE_Range* _tmp74_;
				SANE_Word _tmp75_;
				gdouble _tmp76_ = 0.0;
				SANE_Option_Descriptor* _tmp77_;
				SANE_Range* _tmp78_;
				SANE_Word _tmp79_;
				gchar* _tmp80_ = NULL;
				gchar* _tmp81_;
				gchar* _tmp82_;
				_tmp68_ = s;
				_tmp69_ = option;
				_tmp70_ = _tmp69_->constraint.range;
				_tmp71_ = _tmp70_->min;
				_tmp72_ = SANE_UNFIX ((SANE_Fixed) _tmp71_);
				_tmp73_ = option;
				_tmp74_ = _tmp73_->constraint.range;
				_tmp75_ = _tmp74_->max;
				_tmp76_ = SANE_UNFIX ((SANE_Fixed) _tmp75_);
				_tmp77_ = option;
				_tmp78_ = _tmp77_->constraint.range;
				_tmp79_ = _tmp78_->quant;
				_tmp80_ = g_strdup_printf (" min=%f, max=%f, quant=%d", _tmp72_, _tmp76_, (gint) _tmp79_);
				_tmp81_ = _tmp80_;
				_tmp82_ = g_strconcat (_tmp68_, _tmp81_, NULL);
				_g_free0 (s);
				s = _tmp82_;
				_g_free0 (_tmp81_);
			} else {
				const gchar* _tmp83_;
				SANE_Option_Descriptor* _tmp84_;
				SANE_Range* _tmp85_;
				SANE_Word _tmp86_;
				SANE_Option_Descriptor* _tmp87_;
				SANE_Range* _tmp88_;
				SANE_Word _tmp89_;
				SANE_Option_Descriptor* _tmp90_;
				SANE_Range* _tmp91_;
				SANE_Word _tmp92_;
				gchar* _tmp93_ = NULL;
				gchar* _tmp94_;
				gchar* _tmp95_;
				_tmp83_ = s;
				_tmp84_ = option;
				_tmp85_ = _tmp84_->constraint.range;
				_tmp86_ = _tmp85_->min;
				_tmp87_ = option;
				_tmp88_ = _tmp87_->constraint.range;
				_tmp89_ = _tmp88_->max;
				_tmp90_ = option;
				_tmp91_ = _tmp90_->constraint.range;
				_tmp92_ = _tmp91_->quant;
				_tmp93_ = g_strdup_printf (" min=%d, max=%d, quant=%d", (gint) _tmp86_, (gint) _tmp89_, (gint) _tmp92_);
				_tmp94_ = _tmp93_;
				_tmp95_ = g_strconcat (_tmp83_, _tmp94_, NULL);
				_g_free0 (s);
				s = _tmp95_;
				_g_free0 (_tmp94_);
			}
			break;
		}
		case SANE_CONSTRAINT_WORD_LIST:
		{
			const gchar* _tmp96_;
			gchar* _tmp97_;
			const gchar* _tmp127_;
			gchar* _tmp128_;
			_tmp96_ = s;
			_tmp97_ = g_strconcat (_tmp96_, " values=[", NULL);
			_g_free0 (s);
			s = _tmp97_;
			{
				gint i;
				i = 0;
				{
					gboolean _tmp98_;
					_tmp98_ = TRUE;
					while (TRUE) {
						gboolean _tmp99_;
						gint _tmp101_;
						SANE_Option_Descriptor* _tmp102_;
						SANE_Word* _tmp103_;
						gint _tmp103__length1;
						SANE_Word _tmp104_;
						gint _tmp105_;
						SANE_Option_Descriptor* _tmp108_;
						SANE_Value_Type _tmp109_;
						_tmp99_ = _tmp98_;
						if (!_tmp99_) {
							gint _tmp100_;
							_tmp100_ = i;
							i = _tmp100_ + 1;
						}
						_tmp98_ = FALSE;
						_tmp101_ = i;
						_tmp102_ = option;
						_tmp103_ = _tmp102_->constraint.word_list;
						_tmp103__length1 = -1;
						_tmp104_ = _tmp103_[0];
						if (!(((SANE_Word) _tmp101_) < _tmp104_)) {
							break;
						}
						_tmp105_ = i;
						if (_tmp105_ != 0) {
							const gchar* _tmp106_;
							gchar* _tmp107_;
							_tmp106_ = s;
							_tmp107_ = g_strconcat (_tmp106_, ", ", NULL);
							_g_free0 (s);
							s = _tmp107_;
						}
						_tmp108_ = option;
						_tmp109_ = _tmp108_->type;
						if (_tmp109_ == SANE_TYPE_INT) {
							const gchar* _tmp110_;
							SANE_Option_Descriptor* _tmp111_;
							SANE_Word* _tmp112_;
							gint _tmp112__length1;
							gint _tmp113_;
							SANE_Word _tmp114_;
							gchar* _tmp115_ = NULL;
							gchar* _tmp116_;
							gchar* _tmp117_;
							_tmp110_ = s;
							_tmp111_ = option;
							_tmp112_ = _tmp111_->constraint.word_list;
							_tmp112__length1 = -1;
							_tmp113_ = i;
							_tmp114_ = _tmp112_[_tmp113_ + 1];
							_tmp115_ = g_strdup_printf ("%d", (gint) _tmp114_);
							_tmp116_ = _tmp115_;
							_tmp117_ = g_strconcat (_tmp110_, _tmp116_, NULL);
							_g_free0 (s);
							s = _tmp117_;
							_g_free0 (_tmp116_);
						} else {
							const gchar* _tmp118_;
							SANE_Option_Descriptor* _tmp119_;
							SANE_Word* _tmp120_;
							gint _tmp120__length1;
							gint _tmp121_;
							SANE_Word _tmp122_;
							gdouble _tmp123_ = 0.0;
							gchar* _tmp124_ = NULL;
							gchar* _tmp125_;
							gchar* _tmp126_;
							_tmp118_ = s;
							_tmp119_ = option;
							_tmp120_ = _tmp119_->constraint.word_list;
							_tmp120__length1 = -1;
							_tmp121_ = i;
							_tmp122_ = _tmp120_[_tmp121_ + 1];
							_tmp123_ = SANE_UNFIX ((SANE_Fixed) _tmp122_);
							_tmp124_ = g_strdup_printf ("%f", _tmp123_);
							_tmp125_ = _tmp124_;
							_tmp126_ = g_strconcat (_tmp118_, _tmp125_, NULL);
							_g_free0 (s);
							s = _tmp126_;
							_g_free0 (_tmp125_);
						}
					}
				}
			}
			_tmp127_ = s;
			_tmp128_ = g_strconcat (_tmp127_, "]", NULL);
			_g_free0 (s);
			s = _tmp128_;
			break;
		}
		case SANE_CONSTRAINT_STRING_LIST:
		{
			const gchar* _tmp129_;
			gchar* _tmp130_;
			const gchar* _tmp149_;
			gchar* _tmp150_;
			_tmp129_ = s;
			_tmp130_ = g_strconcat (_tmp129_, " values=[", NULL);
			_g_free0 (s);
			s = _tmp130_;
			{
				gint i;
				i = 0;
				{
					gboolean _tmp131_;
					_tmp131_ = TRUE;
					while (TRUE) {
						gboolean _tmp132_;
						SANE_Option_Descriptor* _tmp134_;
						gchar** _tmp135_;
						gint _tmp135__length1;
						gint _tmp136_;
						const gchar* _tmp137_;
						gint _tmp138_;
						const gchar* _tmp141_;
						SANE_Option_Descriptor* _tmp142_;
						gchar** _tmp143_;
						gint _tmp143__length1;
						gint _tmp144_;
						const gchar* _tmp145_;
						gchar* _tmp146_ = NULL;
						gchar* _tmp147_;
						gchar* _tmp148_;
						_tmp132_ = _tmp131_;
						if (!_tmp132_) {
							gint _tmp133_;
							_tmp133_ = i;
							i = _tmp133_ + 1;
						}
						_tmp131_ = FALSE;
						_tmp134_ = option;
						_tmp135_ = _tmp134_->constraint.string_list;
						_tmp135__length1 = -1;
						_tmp136_ = i;
						_tmp137_ = _tmp135_[_tmp136_];
						if (!(_tmp137_ != NULL)) {
							break;
						}
						_tmp138_ = i;
						if (_tmp138_ != 0) {
							const gchar* _tmp139_;
							gchar* _tmp140_;
							_tmp139_ = s;
							_tmp140_ = g_strconcat (_tmp139_, ", ", NULL);
							_g_free0 (s);
							s = _tmp140_;
						}
						_tmp141_ = s;
						_tmp142_ = option;
						_tmp143_ = _tmp142_->constraint.string_list;
						_tmp143__length1 = -1;
						_tmp144_ = i;
						_tmp145_ = _tmp143_[_tmp144_];
						_tmp146_ = g_strdup_printf ("\"%s\"", _tmp145_);
						_tmp147_ = _tmp146_;
						_tmp148_ = g_strconcat (_tmp141_, _tmp147_, NULL);
						_g_free0 (s);
						s = _tmp148_;
						_g_free0 (_tmp147_);
					}
				}
			}
			_tmp149_ = s;
			_tmp150_ = g_strconcat (_tmp149_, "]", NULL);
			_g_free0 (s);
			s = _tmp150_;
			break;
		}
		default:
		{
			break;
		}
	}
	_tmp151_ = option;
	_tmp152_ = _tmp151_->cap;
	cap = _tmp152_;
	_tmp153_ = cap;
	if (_tmp153_ != ((SANE_Int) 0)) {
		const gchar* _tmp154_;
		gchar* _tmp155_;
		SANE_Int _tmp156_;
		SANE_Int _tmp163_;
		SANE_Int _tmp170_;
		SANE_Int _tmp177_;
		SANE_Int _tmp184_;
		SANE_Int _tmp191_;
		SANE_Int _tmp198_;
		SANE_Int _tmp205_;
		_tmp154_ = s;
		_tmp155_ = g_strconcat (_tmp154_, " cap=", NULL);
		_g_free0 (s);
		s = _tmp155_;
		_tmp156_ = cap;
		if ((_tmp156_ & SANE_CAP_SOFT_SELECT) != ((SANE_Int) 0)) {
			const gchar* _tmp157_;
			const gchar* _tmp160_;
			gchar* _tmp161_;
			SANE_Int _tmp162_;
			_tmp157_ = s;
			if (g_strcmp0 (_tmp157_, "") != 0) {
				const gchar* _tmp158_;
				gchar* _tmp159_;
				_tmp158_ = s;
				_tmp159_ = g_strconcat (_tmp158_, ",", NULL);
				_g_free0 (s);
				s = _tmp159_;
			}
			_tmp160_ = s;
			_tmp161_ = g_strconcat (_tmp160_, "soft-select", NULL);
			_g_free0 (s);
			s = _tmp161_;
			_tmp162_ = cap;
			cap = _tmp162_ & (~SANE_CAP_SOFT_SELECT);
		}
		_tmp163_ = cap;
		if ((_tmp163_ & SANE_CAP_HARD_SELECT) != ((SANE_Int) 0)) {
			const gchar* _tmp164_;
			const gchar* _tmp167_;
			gchar* _tmp168_;
			SANE_Int _tmp169_;
			_tmp164_ = s;
			if (g_strcmp0 (_tmp164_, "") != 0) {
				const gchar* _tmp165_;
				gchar* _tmp166_;
				_tmp165_ = s;
				_tmp166_ = g_strconcat (_tmp165_, ",", NULL);
				_g_free0 (s);
				s = _tmp166_;
			}
			_tmp167_ = s;
			_tmp168_ = g_strconcat (_tmp167_, "hard-select", NULL);
			_g_free0 (s);
			s = _tmp168_;
			_tmp169_ = cap;
			cap = _tmp169_ & (~SANE_CAP_HARD_SELECT);
		}
		_tmp170_ = cap;
		if ((_tmp170_ & SANE_CAP_SOFT_DETECT) != ((SANE_Int) 0)) {
			const gchar* _tmp171_;
			const gchar* _tmp174_;
			gchar* _tmp175_;
			SANE_Int _tmp176_;
			_tmp171_ = s;
			if (g_strcmp0 (_tmp171_, "") != 0) {
				const gchar* _tmp172_;
				gchar* _tmp173_;
				_tmp172_ = s;
				_tmp173_ = g_strconcat (_tmp172_, ",", NULL);
				_g_free0 (s);
				s = _tmp173_;
			}
			_tmp174_ = s;
			_tmp175_ = g_strconcat (_tmp174_, "soft-detect", NULL);
			_g_free0 (s);
			s = _tmp175_;
			_tmp176_ = cap;
			cap = _tmp176_ & (~SANE_CAP_SOFT_DETECT);
		}
		_tmp177_ = cap;
		if ((_tmp177_ & SANE_CAP_EMULATED) != ((SANE_Int) 0)) {
			const gchar* _tmp178_;
			const gchar* _tmp181_;
			gchar* _tmp182_;
			SANE_Int _tmp183_;
			_tmp178_ = s;
			if (g_strcmp0 (_tmp178_, "") != 0) {
				const gchar* _tmp179_;
				gchar* _tmp180_;
				_tmp179_ = s;
				_tmp180_ = g_strconcat (_tmp179_, ",", NULL);
				_g_free0 (s);
				s = _tmp180_;
			}
			_tmp181_ = s;
			_tmp182_ = g_strconcat (_tmp181_, "emulated", NULL);
			_g_free0 (s);
			s = _tmp182_;
			_tmp183_ = cap;
			cap = _tmp183_ & (~SANE_CAP_EMULATED);
		}
		_tmp184_ = cap;
		if ((_tmp184_ & SANE_CAP_AUTOMATIC) != ((SANE_Int) 0)) {
			const gchar* _tmp185_;
			const gchar* _tmp188_;
			gchar* _tmp189_;
			SANE_Int _tmp190_;
			_tmp185_ = s;
			if (g_strcmp0 (_tmp185_, "") != 0) {
				const gchar* _tmp186_;
				gchar* _tmp187_;
				_tmp186_ = s;
				_tmp187_ = g_strconcat (_tmp186_, ",", NULL);
				_g_free0 (s);
				s = _tmp187_;
			}
			_tmp188_ = s;
			_tmp189_ = g_strconcat (_tmp188_, "automatic", NULL);
			_g_free0 (s);
			s = _tmp189_;
			_tmp190_ = cap;
			cap = _tmp190_ & (~SANE_CAP_AUTOMATIC);
		}
		_tmp191_ = cap;
		if ((_tmp191_ & SANE_CAP_INACTIVE) != ((SANE_Int) 0)) {
			const gchar* _tmp192_;
			const gchar* _tmp195_;
			gchar* _tmp196_;
			SANE_Int _tmp197_;
			_tmp192_ = s;
			if (g_strcmp0 (_tmp192_, "") != 0) {
				const gchar* _tmp193_;
				gchar* _tmp194_;
				_tmp193_ = s;
				_tmp194_ = g_strconcat (_tmp193_, ",", NULL);
				_g_free0 (s);
				s = _tmp194_;
			}
			_tmp195_ = s;
			_tmp196_ = g_strconcat (_tmp195_, "inactive", NULL);
			_g_free0 (s);
			s = _tmp196_;
			_tmp197_ = cap;
			cap = _tmp197_ & (~SANE_CAP_INACTIVE);
		}
		_tmp198_ = cap;
		if ((_tmp198_ & SANE_CAP_ADVANCED) != ((SANE_Int) 0)) {
			const gchar* _tmp199_;
			const gchar* _tmp202_;
			gchar* _tmp203_;
			SANE_Int _tmp204_;
			_tmp199_ = s;
			if (g_strcmp0 (_tmp199_, "") != 0) {
				const gchar* _tmp200_;
				gchar* _tmp201_;
				_tmp200_ = s;
				_tmp201_ = g_strconcat (_tmp200_, ",", NULL);
				_g_free0 (s);
				s = _tmp201_;
			}
			_tmp202_ = s;
			_tmp203_ = g_strconcat (_tmp202_, "advanced", NULL);
			_g_free0 (s);
			s = _tmp203_;
			_tmp204_ = cap;
			cap = _tmp204_ & (~SANE_CAP_ADVANCED);
		}
		_tmp205_ = cap;
		if (_tmp205_ != ((SANE_Int) 0)) {
			const gchar* _tmp206_;
			const gchar* _tmp209_;
			SANE_Int _tmp210_;
			gchar* _tmp211_ = NULL;
			gchar* _tmp212_;
			gchar* _tmp213_;
			_tmp206_ = s;
			if (g_strcmp0 (_tmp206_, "") != 0) {
				const gchar* _tmp207_;
				gchar* _tmp208_;
				_tmp207_ = s;
				_tmp208_ = g_strconcat (_tmp207_, ",", NULL);
				_g_free0 (s);
				s = _tmp208_;
			}
			_tmp209_ = s;
			_tmp210_ = cap;
			_tmp211_ = g_strdup_printf ("%x", (guint) ((gint) _tmp210_));
			_tmp212_ = _tmp211_;
			_tmp213_ = g_strconcat (_tmp209_, _tmp212_, NULL);
			_g_free0 (s);
			s = _tmp213_;
			_g_free0 (_tmp212_);
		}
	}
	_tmp214_ = s;
	g_debug ("scanner.vala:666: %s", _tmp214_);
	_tmp215_ = option;
	_tmp216_ = _tmp215_->desc;
	if (_tmp216_ != NULL) {
		SANE_Option_Descriptor* _tmp217_;
		const gchar* _tmp218_;
		_tmp217_ = option;
		_tmp218_ = _tmp217_->desc;
		g_debug ("scanner.vala:669:   Description: %s", _tmp218_);
	}
	_g_free0 (s);
}


static void scanner_authorization_cb (const gchar* resource, gchar* username, int username_length1, gchar* password, int password_length1) {
	Scanner* _tmp0_;
	const gchar* _tmp1_;
	NotifyRequestAuthorization* _tmp2_;
	NotifyRequestAuthorization* _tmp3_;
	Scanner* _tmp4_;
	GAsyncQueue* _tmp5_;
	gpointer _tmp6_ = NULL;
	Credentials* credentials;
	g_return_if_fail (resource != NULL);
	_tmp0_ = scanner_scanner_object;
	_tmp1_ = resource;
	_tmp2_ = notify_request_authorization_new (_tmp1_);
	_tmp3_ = _tmp2_;
	scanner_notify (_tmp0_, (Notify*) _tmp3_);
	_notify_unref0 (_tmp3_);
	_tmp4_ = scanner_scanner_object;
	_tmp5_ = _tmp4_->priv->authorize_queue;
	_tmp6_ = g_async_queue_pop (_tmp5_);
	credentials = (Credentials*) _tmp6_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp7_;
			_tmp7_ = TRUE;
			while (TRUE) {
				gboolean _tmp8_;
				gboolean _tmp10_ = FALSE;
				Credentials* _tmp11_;
				const gchar* _tmp12_;
				gint _tmp13_;
				gchar _tmp14_ = '\0';
				gboolean _tmp17_;
				gchar* _tmp18_;
				gint _tmp18__length1;
				gint _tmp19_;
				Credentials* _tmp20_;
				const gchar* _tmp21_;
				gint _tmp22_;
				gchar _tmp23_ = '\0';
				gchar _tmp24_;
				_tmp8_ = _tmp7_;
				if (!_tmp8_) {
					gint _tmp9_;
					_tmp9_ = i;
					i = _tmp9_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp11_ = credentials;
				_tmp12_ = _tmp11_->username;
				_tmp13_ = i;
				_tmp14_ = string_get (_tmp12_, (glong) _tmp13_);
				if (_tmp14_ != '\0') {
					gint _tmp15_;
					gint _tmp16_;
					_tmp15_ = i;
					_tmp16_ = SANE_MAX_USERNAME_LEN;
					_tmp10_ = _tmp15_ < _tmp16_;
				} else {
					_tmp10_ = FALSE;
				}
				_tmp17_ = _tmp10_;
				if (!_tmp17_) {
					break;
				}
				_tmp18_ = username;
				_tmp18__length1 = username_length1;
				_tmp19_ = i;
				_tmp20_ = credentials;
				_tmp21_ = _tmp20_->username;
				_tmp22_ = i;
				_tmp23_ = string_get (_tmp21_, (glong) _tmp22_);
				_tmp18_[_tmp19_] = _tmp23_;
				_tmp24_ = _tmp18_[_tmp19_];
			}
		}
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp25_;
			_tmp25_ = TRUE;
			while (TRUE) {
				gboolean _tmp26_;
				gboolean _tmp28_ = FALSE;
				Credentials* _tmp29_;
				const gchar* _tmp30_;
				gint _tmp31_;
				gchar _tmp32_ = '\0';
				gboolean _tmp35_;
				gchar* _tmp36_;
				gint _tmp36__length1;
				gint _tmp37_;
				Credentials* _tmp38_;
				const gchar* _tmp39_;
				gint _tmp40_;
				gchar _tmp41_ = '\0';
				gchar _tmp42_;
				_tmp26_ = _tmp25_;
				if (!_tmp26_) {
					gint _tmp27_;
					_tmp27_ = i;
					i = _tmp27_ + 1;
				}
				_tmp25_ = FALSE;
				_tmp29_ = credentials;
				_tmp30_ = _tmp29_->password;
				_tmp31_ = i;
				_tmp32_ = string_get (_tmp30_, (glong) _tmp31_);
				if (_tmp32_ != '\0') {
					gint _tmp33_;
					gint _tmp34_;
					_tmp33_ = i;
					_tmp34_ = SANE_MAX_USERNAME_LEN;
					_tmp28_ = _tmp33_ < _tmp34_;
				} else {
					_tmp28_ = FALSE;
				}
				_tmp35_ = _tmp28_;
				if (!_tmp35_) {
					break;
				}
				_tmp36_ = password;
				_tmp36__length1 = password_length1;
				_tmp37_ = i;
				_tmp38_ = credentials;
				_tmp39_ = _tmp38_->password;
				_tmp40_ = i;
				_tmp41_ = string_get (_tmp39_, (glong) _tmp40_);
				_tmp36_[_tmp37_] = _tmp41_;
				_tmp42_ = _tmp36_[_tmp37_];
			}
		}
	}
	_credentials_unref0 (credentials);
}


static gpointer _credentials_ref0 (gpointer self) {
	return self ? credentials_ref (self) : NULL;
}


void scanner_authorize (Scanner* self, const gchar* username, const gchar* password) {
	Credentials* _tmp0_;
	Credentials* credentials;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	GAsyncQueue* _tmp5_;
	Credentials* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (username != NULL);
	g_return_if_fail (password != NULL);
	_tmp0_ = credentials_new ();
	credentials = _tmp0_;
	_tmp1_ = username;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (credentials->username);
	credentials->username = _tmp2_;
	_tmp3_ = password;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (credentials->password);
	credentials->password = _tmp4_;
	_tmp5_ = self->priv->authorize_queue;
	_tmp6_ = _credentials_ref0 (credentials);
	g_async_queue_push (_tmp5_, _tmp6_);
	_credentials_unref0 (credentials);
}


static void scanner_close_device (Scanner* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->have_handle;
	if (_tmp0_) {
		SANE_Handle _tmp1_;
		SANE_Handle _tmp2_;
		_tmp1_ = self->priv->handle;
		sane_cancel (_tmp1_);
		g_debug ("scanner.vala:696: sane_cancel ()");
		_tmp2_ = self->priv->handle;
		sane_close (_tmp2_);
		g_debug ("scanner.vala:699: sane_close ()");
		self->priv->have_handle = FALSE;
	}
	self->priv->buffer = (g_free (self->priv->buffer), NULL);
	self->priv->buffer = NULL;
	self->priv->buffer_length1 = 0;
	self->priv->_buffer_size_ = self->priv->buffer_length1;
	__g_list_free__scan_job_unref0_0 (self->priv->job_queue);
	self->priv->job_queue = NULL;
	scanner_set_scanning (self, FALSE);
}


static void scanner_fail_scan (Scanner* self, gint error_code, const gchar* error_string) {
	gint _tmp0_;
	const gchar* _tmp1_;
	NotifyScanFailed* _tmp2_;
	NotifyScanFailed* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (error_string != NULL);
	scanner_close_device (self);
	self->priv->state = SCAN_STATE_IDLE;
	_tmp0_ = error_code;
	_tmp1_ = error_string;
	_tmp2_ = notify_scan_failed_new (_tmp0_, _tmp1_);
	_tmp3_ = _tmp2_;
	scanner_notify (self, (Notify*) _tmp3_);
	_notify_unref0 (_tmp3_);
}


static gpointer _request_ref0 (gpointer self) {
	return self ? request_ref (self) : NULL;
}


static gpointer _scan_job_ref0 (gpointer self) {
	return self ? scan_job_ref (self) : NULL;
}


static gboolean scanner_handle_requests (Scanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ScanState _tmp1_;
	gboolean _tmp3_;
	gint request_count;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->state;
	if (_tmp1_ == SCAN_STATE_IDLE) {
		gboolean _tmp2_;
		_tmp2_ = self->priv->need_redetect;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		self->priv->state = SCAN_STATE_REDETECT;
	}
	request_count = 0;
	while (TRUE) {
		Request* request = NULL;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		ScanState _tmp6_;
		gboolean _tmp8_;
		gboolean _tmp11_;
		gint _tmp14_;
		Request* _tmp15_;
		_tmp6_ = self->priv->state;
		if (_tmp6_ == SCAN_STATE_IDLE) {
			gint _tmp7_;
			_tmp7_ = request_count;
			_tmp5_ = _tmp7_ == 0;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp8_ = _tmp5_;
		if (_tmp8_) {
			_tmp4_ = TRUE;
		} else {
			GAsyncQueue* _tmp9_;
			gint _tmp10_ = 0;
			_tmp9_ = self->priv->request_queue;
			_tmp10_ = g_async_queue_length (_tmp9_);
			_tmp4_ = _tmp10_ > 0;
		}
		_tmp11_ = _tmp4_;
		if (_tmp11_) {
			GAsyncQueue* _tmp12_;
			gpointer _tmp13_ = NULL;
			_tmp12_ = self->priv->request_queue;
			_tmp13_ = g_async_queue_pop (_tmp12_);
			_request_unref0 (request);
			request = (Request*) _tmp13_;
		} else {
			result = TRUE;
			_request_unref0 (request);
			return result;
		}
		g_debug ("scanner.vala:733: Processing request");
		_tmp14_ = request_count;
		request_count = _tmp14_ + 1;
		_tmp15_ = request;
		if (IS_REQUEST_START_SCAN (_tmp15_)) {
			Request* _tmp16_;
			RequestStartScan* _tmp17_;
			RequestStartScan* r;
			RequestStartScan* _tmp18_;
			ScanJob* _tmp19_;
			ScanJob* _tmp20_;
			_tmp16_ = request;
			_tmp17_ = _request_ref0 (REQUEST_START_SCAN (_tmp16_));
			r = _tmp17_;
			_tmp18_ = r;
			_tmp19_ = _tmp18_->job;
			_tmp20_ = _scan_job_ref0 (_tmp19_);
			self->priv->job_queue = g_list_append (self->priv->job_queue, _tmp20_);
			_request_unref0 (r);
		} else {
			Request* _tmp21_;
			_tmp21_ = request;
			if (IS_REQUEST_CANCEL (_tmp21_)) {
				scanner_fail_scan (self, (gint) SANE_STATUS_CANCELLED, "Scan cancelled - do not report this error");
			} else {
				Request* _tmp22_;
				_tmp22_ = request;
				if (IS_REQUEST_QUIT (_tmp22_)) {
					scanner_close_device (self);
					result = FALSE;
					_request_unref0 (request);
					return result;
				}
			}
		}
		_request_unref0 (request);
	}
}


static void scanner_do_open (Scanner* self) {
	GList* _tmp0_;
	gconstpointer _tmp1_;
	ScanJob* _tmp2_;
	ScanJob* job;
	gboolean _tmp3_ = FALSE;
	ScanJob* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp7_;
	ScanJob* _tmp11_;
	const gchar* _tmp12_;
	gboolean _tmp14_;
	ScanJob* _tmp19_;
	const gchar* _tmp20_;
	SANE_Handle _tmp21_ = {0};
	SANE_Status _tmp22_ = 0;
	SANE_Status status;
	ScanJob* _tmp23_;
	const gchar* _tmp24_;
	SANE_Status _tmp25_;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_;
	SANE_Status _tmp28_;
	ScanJob* _tmp33_;
	const gchar* _tmp34_;
	gchar* _tmp35_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->job_queue;
	_tmp1_ = _tmp0_->data;
	_tmp2_ = _scan_job_ref0 (SCAN_JOB ((ScanJob*) _tmp1_));
	job = _tmp2_;
	self->priv->line_count = 0;
	self->priv->pass_number = 0;
	self->priv->page_number = 0;
	self->priv->notified_page = -1;
	self->priv->option_index = (SANE_Int) 0;
	self->priv->br_x_option_index = (SANE_Int) 0;
	self->priv->br_y_option_index = (SANE_Int) 0;
	_tmp4_ = job;
	_tmp5_ = _tmp4_->device;
	if (_tmp5_ == NULL) {
		const gchar* _tmp6_;
		_tmp6_ = self->priv->default_device;
		_tmp3_ = _tmp6_ != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp7_ = _tmp3_;
	if (_tmp7_) {
		ScanJob* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp8_ = job;
		_tmp9_ = self->priv->default_device;
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (_tmp8_->device);
		_tmp8_->device = _tmp10_;
	}
	_tmp11_ = job;
	_tmp12_ = _tmp11_->device;
	if (_tmp12_ == NULL) {
		const gchar* _tmp13_ = NULL;
		g_warning ("scanner.vala:770: No scan device available");
		_tmp13_ = _ ("No scanners available.  Please connect a scanner.");
		scanner_fail_scan (self, 0, _tmp13_);
		_scan_job_unref0 (job);
		return;
	}
	_tmp14_ = self->priv->have_handle;
	if (_tmp14_) {
		const gchar* _tmp15_;
		ScanJob* _tmp16_;
		const gchar* _tmp17_;
		SANE_Handle _tmp18_;
		_tmp15_ = self->priv->current_device;
		_tmp16_ = job;
		_tmp17_ = _tmp16_->device;
		if (g_strcmp0 (_tmp15_, _tmp17_) == 0) {
			self->priv->state = SCAN_STATE_GET_OPTION;
			_scan_job_unref0 (job);
			return;
		}
		_tmp18_ = self->priv->handle;
		sane_close (_tmp18_);
		g_debug ("scanner.vala:787: sane_close ()");
		self->priv->have_handle = FALSE;
	}
	_g_free0 (self->priv->current_device);
	self->priv->current_device = NULL;
	self->priv->have_handle = FALSE;
	_tmp19_ = job;
	_tmp20_ = _tmp19_->device;
	_tmp22_ = sane_open (_tmp20_, &_tmp21_);
	self->priv->handle = _tmp21_;
	status = _tmp22_;
	_tmp23_ = job;
	_tmp24_ = _tmp23_->device;
	_tmp25_ = status;
	_tmp26_ = sane_status_to_string (_tmp25_);
	_tmp27_ = _tmp26_;
	g_debug ("scanner.vala:795: sane_open (\"%s\") -> %s", _tmp24_, _tmp27_);
	_g_free0 (_tmp27_);
	_tmp28_ = status;
	if (_tmp28_ != SANE_STATUS_GOOD) {
		SANE_Status _tmp29_;
		const gchar* _tmp30_ = NULL;
		SANE_Status _tmp31_;
		const gchar* _tmp32_ = NULL;
		_tmp29_ = status;
		_tmp30_ = sane_strstatus (_tmp29_);
		g_warning ("scanner.vala:799: Unable to get open device: %s", _tmp30_);
		_tmp31_ = status;
		_tmp32_ = _ ("Unable to connect to scanner");
		scanner_fail_scan (self, (gint) _tmp31_, _tmp32_);
		_scan_job_unref0 (job);
		return;
	}
	self->priv->have_handle = TRUE;
	_tmp33_ = job;
	_tmp34_ = _tmp33_->device;
	_tmp35_ = g_strdup (_tmp34_);
	_g_free0 (self->priv->current_device);
	self->priv->current_device = _tmp35_;
	self->priv->state = SCAN_STATE_GET_OPTION;
	_scan_job_unref0 (job);
}


static void scanner_do_get_option (Scanner* self) {
	GList* _tmp0_;
	gconstpointer _tmp1_;
	ScanJob* _tmp2_;
	ScanJob* job;
	SANE_Handle _tmp3_;
	SANE_Int _tmp4_;
	SANE_Option_Descriptor* _tmp5_ = NULL;
	SANE_Option_Descriptor* option;
	SANE_Int _tmp6_;
	SANE_Int _tmp7_;
	SANE_Int index;
	SANE_Int _tmp8_;
	SANE_Option_Descriptor* _tmp9_;
	SANE_Int _tmp54_;
	SANE_Option_Descriptor* _tmp55_;
	SANE_Option_Descriptor* _tmp56_;
	SANE_Value_Type _tmp57_;
	SANE_Option_Descriptor* _tmp58_;
	SANE_Int _tmp59_;
	SANE_Option_Descriptor* _tmp60_;
	const gchar* _tmp61_;
	SANE_Option_Descriptor* _tmp62_;
	const gchar* _tmp63_;
	const gchar* _tmp64_;
	const gchar* _tmp294_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->job_queue;
	_tmp1_ = _tmp0_->data;
	_tmp2_ = _scan_job_ref0 (SCAN_JOB ((ScanJob*) _tmp1_));
	job = _tmp2_;
	_tmp3_ = self->priv->handle;
	_tmp4_ = self->priv->option_index;
	_tmp5_ = sane_get_option_descriptor (_tmp3_, _tmp4_);
	option = _tmp5_;
	_tmp6_ = self->priv->option_index;
	g_debug ("scanner.vala:816: sane_get_option_descriptor (%d)", (gint) _tmp6_);
	_tmp7_ = self->priv->option_index;
	index = _tmp7_;
	_tmp8_ = self->priv->option_index;
	self->priv->option_index = _tmp8_ + 1;
	_tmp9_ = option;
	if (_tmp9_ == NULL) {
		SANE_Int _tmp10_;
		SANE_Int _tmp32_;
		_tmp10_ = self->priv->br_x_option_index;
		if (_tmp10_ != ((SANE_Int) 0)) {
			SANE_Handle _tmp11_;
			SANE_Int _tmp12_;
			SANE_Option_Descriptor* _tmp13_ = NULL;
			SANE_Int _tmp14_;
			SANE_Option_Descriptor* _tmp15_;
			SANE_Constraint_Type _tmp16_;
			_tmp11_ = self->priv->handle;
			_tmp12_ = self->priv->br_x_option_index;
			_tmp13_ = sane_get_option_descriptor (_tmp11_, _tmp12_);
			option = _tmp13_;
			_tmp14_ = self->priv->br_x_option_index;
			g_debug ("scanner.vala:826: sane_get_option_descriptor (%d)", (gint) _tmp14_);
			_tmp15_ = option;
			_tmp16_ = _tmp15_->constraint_type;
			if (_tmp16_ == SANE_CONSTRAINT_RANGE) {
				SANE_Option_Descriptor* _tmp17_;
				SANE_Value_Type _tmp18_;
				_tmp17_ = option;
				_tmp18_ = _tmp17_->type;
				if (_tmp18_ == SANE_TYPE_FIXED) {
					SANE_Handle _tmp19_;
					SANE_Option_Descriptor* _tmp20_;
					SANE_Int _tmp21_;
					SANE_Option_Descriptor* _tmp22_;
					SANE_Range* _tmp23_;
					SANE_Word _tmp24_;
					gdouble _tmp25_ = 0.0;
					_tmp19_ = self->priv->handle;
					_tmp20_ = option;
					_tmp21_ = self->priv->br_x_option_index;
					_tmp22_ = option;
					_tmp23_ = _tmp22_->constraint.range;
					_tmp24_ = _tmp23_->max;
					_tmp25_ = SANE_UNFIX ((SANE_Fixed) _tmp24_);
					scanner_set_fixed_option (self, _tmp19_, _tmp20_, _tmp21_, _tmp25_, NULL);
				} else {
					SANE_Handle _tmp26_;
					SANE_Option_Descriptor* _tmp27_;
					SANE_Int _tmp28_;
					SANE_Option_Descriptor* _tmp29_;
					SANE_Range* _tmp30_;
					SANE_Word _tmp31_;
					_tmp26_ = self->priv->handle;
					_tmp27_ = option;
					_tmp28_ = self->priv->br_x_option_index;
					_tmp29_ = option;
					_tmp30_ = _tmp29_->constraint.range;
					_tmp31_ = _tmp30_->max;
					scanner_set_int_option (self, _tmp26_, _tmp27_, _tmp28_, (gint) _tmp31_, NULL);
				}
			}
		}
		_tmp32_ = self->priv->br_y_option_index;
		if (_tmp32_ != ((SANE_Int) 0)) {
			SANE_Handle _tmp33_;
			SANE_Int _tmp34_;
			SANE_Option_Descriptor* _tmp35_ = NULL;
			SANE_Int _tmp36_;
			SANE_Option_Descriptor* _tmp37_;
			SANE_Constraint_Type _tmp38_;
			_tmp33_ = self->priv->handle;
			_tmp34_ = self->priv->br_y_option_index;
			_tmp35_ = sane_get_option_descriptor (_tmp33_, _tmp34_);
			option = _tmp35_;
			_tmp36_ = self->priv->br_y_option_index;
			g_debug ("scanner.vala:838: sane_get_option_descriptor (%d)", (gint) _tmp36_);
			_tmp37_ = option;
			_tmp38_ = _tmp37_->constraint_type;
			if (_tmp38_ == SANE_CONSTRAINT_RANGE) {
				SANE_Option_Descriptor* _tmp39_;
				SANE_Value_Type _tmp40_;
				_tmp39_ = option;
				_tmp40_ = _tmp39_->type;
				if (_tmp40_ == SANE_TYPE_FIXED) {
					SANE_Handle _tmp41_;
					SANE_Option_Descriptor* _tmp42_;
					SANE_Int _tmp43_;
					SANE_Option_Descriptor* _tmp44_;
					SANE_Range* _tmp45_;
					SANE_Word _tmp46_;
					gdouble _tmp47_ = 0.0;
					_tmp41_ = self->priv->handle;
					_tmp42_ = option;
					_tmp43_ = self->priv->br_y_option_index;
					_tmp44_ = option;
					_tmp45_ = _tmp44_->constraint.range;
					_tmp46_ = _tmp45_->max;
					_tmp47_ = SANE_UNFIX ((SANE_Fixed) _tmp46_);
					scanner_set_fixed_option (self, _tmp41_, _tmp42_, _tmp43_, _tmp47_, NULL);
				} else {
					SANE_Handle _tmp48_;
					SANE_Option_Descriptor* _tmp49_;
					SANE_Int _tmp50_;
					SANE_Option_Descriptor* _tmp51_;
					SANE_Range* _tmp52_;
					SANE_Word _tmp53_;
					_tmp48_ = self->priv->handle;
					_tmp49_ = option;
					_tmp50_ = self->priv->br_y_option_index;
					_tmp51_ = option;
					_tmp52_ = _tmp51_->constraint.range;
					_tmp53_ = _tmp52_->max;
					scanner_set_int_option (self, _tmp48_, _tmp49_, _tmp50_, (gint) _tmp53_, NULL);
				}
			}
		}
		self->priv->state = SCAN_STATE_START;
		_scan_job_unref0 (job);
		return;
	}
	_tmp54_ = index;
	_tmp55_ = option;
	scanner_log_option (self, _tmp54_, _tmp55_);
	_tmp56_ = option;
	_tmp57_ = _tmp56_->type;
	if (_tmp57_ == SANE_TYPE_GROUP) {
		_scan_job_unref0 (job);
		return;
	}
	_tmp58_ = option;
	_tmp59_ = _tmp58_->cap;
	if ((_tmp59_ & SANE_CAP_INACTIVE) != ((SANE_Int) 0)) {
		_scan_job_unref0 (job);
		return;
	}
	_tmp60_ = option;
	_tmp61_ = _tmp60_->name;
	if (_tmp61_ == NULL) {
		_scan_job_unref0 (job);
		return;
	}
	_tmp62_ = option;
	_tmp63_ = _tmp62_->name;
	_tmp64_ = SANE_NAME_SCAN_RESOLUTION;
	if (g_strcmp0 (_tmp63_, _tmp64_) == 0) {
		SANE_Option_Descriptor* _tmp65_;
		SANE_Value_Type _tmp66_;
		_tmp65_ = option;
		_tmp66_ = _tmp65_->type;
		if (_tmp66_ == SANE_TYPE_FIXED) {
			SANE_Handle _tmp67_;
			SANE_Option_Descriptor* _tmp68_;
			SANE_Int _tmp69_;
			ScanJob* _tmp70_;
			gdouble _tmp71_;
			ScanJob* _tmp72_;
			gdouble _tmp73_ = 0.0;
			_tmp67_ = self->priv->handle;
			_tmp68_ = option;
			_tmp69_ = index;
			_tmp70_ = job;
			_tmp71_ = _tmp70_->dpi;
			_tmp72_ = job;
			scanner_set_fixed_option (self, _tmp67_, _tmp68_, _tmp69_, _tmp71_, &_tmp73_);
			_tmp72_->dpi = _tmp73_;
		} else {
			gint dpi = 0;
			SANE_Handle _tmp74_;
			SANE_Option_Descriptor* _tmp75_;
			SANE_Int _tmp76_;
			ScanJob* _tmp77_;
			gdouble _tmp78_;
			gint _tmp79_ = 0;
			ScanJob* _tmp80_;
			gint _tmp81_;
			_tmp74_ = self->priv->handle;
			_tmp75_ = option;
			_tmp76_ = index;
			_tmp77_ = job;
			_tmp78_ = _tmp77_->dpi;
			scanner_set_int_option (self, _tmp74_, _tmp75_, _tmp76_, (gint) _tmp78_, &_tmp79_);
			dpi = _tmp79_;
			_tmp80_ = job;
			_tmp81_ = dpi;
			_tmp80_->dpi = (gdouble) _tmp81_;
		}
	} else {
		SANE_Option_Descriptor* _tmp82_;
		const gchar* _tmp83_;
		const gchar* _tmp84_;
		_tmp82_ = option;
		_tmp83_ = _tmp82_->name;
		_tmp84_ = SANE_NAME_SCAN_SOURCE;
		if (g_strcmp0 (_tmp83_, _tmp84_) == 0) {
			gchar* _tmp85_;
			const gchar* _tmp86_ = NULL;
			gchar* _tmp87_;
			gchar* _tmp88_;
			const gchar* _tmp89_ = NULL;
			gchar* _tmp90_;
			gchar* _tmp91_;
			gchar* _tmp92_;
			const gchar* _tmp93_ = NULL;
			gchar* _tmp94_;
			gchar** _tmp95_ = NULL;
			gchar** flatbed_sources;
			gint flatbed_sources_length1;
			gint _flatbed_sources_size_;
			gchar* _tmp96_;
			const gchar* _tmp97_ = NULL;
			gchar* _tmp98_;
			gchar* _tmp99_;
			gchar* _tmp100_;
			gchar* _tmp101_;
			gchar** _tmp102_ = NULL;
			gchar** adf_sources;
			gint adf_sources_length1;
			gint _adf_sources_size_;
			gchar* _tmp103_;
			const gchar* _tmp104_ = NULL;
			gchar* _tmp105_;
			gchar** _tmp106_ = NULL;
			gchar** adf_front_sources;
			gint adf_front_sources_length1;
			gint _adf_front_sources_size_;
			gchar* _tmp107_;
			const gchar* _tmp108_ = NULL;
			gchar* _tmp109_;
			gchar** _tmp110_ = NULL;
			gchar** adf_back_sources;
			gint adf_back_sources_length1;
			gint _adf_back_sources_size_;
			gchar* _tmp111_;
			const gchar* _tmp112_ = NULL;
			gchar* _tmp113_;
			gchar** _tmp114_ = NULL;
			gchar** adf_duplex_sources;
			gint adf_duplex_sources_length1;
			gint _adf_duplex_sources_size_;
			ScanJob* _tmp115_;
			ScanType _tmp116_;
			_tmp85_ = g_strdup ("Auto");
			_tmp86_ = SANE_I18N ("Auto");
			_tmp87_ = g_strdup (_tmp86_);
			_tmp88_ = g_strdup ("Flatbed");
			_tmp89_ = SANE_I18N ("Flatbed");
			_tmp90_ = g_strdup (_tmp89_);
			_tmp91_ = g_strdup ("FlatBed");
			_tmp92_ = g_strdup ("Normal");
			_tmp93_ = SANE_I18N ("Normal");
			_tmp94_ = g_strdup (_tmp93_);
			_tmp95_ = g_new0 (gchar*, 7 + 1);
			_tmp95_[0] = _tmp85_;
			_tmp95_[1] = _tmp87_;
			_tmp95_[2] = _tmp88_;
			_tmp95_[3] = _tmp90_;
			_tmp95_[4] = _tmp91_;
			_tmp95_[5] = _tmp92_;
			_tmp95_[6] = _tmp94_;
			flatbed_sources = _tmp95_;
			flatbed_sources_length1 = 7;
			_flatbed_sources_size_ = flatbed_sources_length1;
			_tmp96_ = g_strdup ("Automatic Document Feeder");
			_tmp97_ = SANE_I18N ("Automatic Document Feeder");
			_tmp98_ = g_strdup (_tmp97_);
			_tmp99_ = g_strdup ("ADF");
			_tmp100_ = g_strdup ("Automatic Document Feeder(left aligned)");
			_tmp101_ = g_strdup ("Automatic Document Feeder(centrally aligned)");
			_tmp102_ = g_new0 (gchar*, 5 + 1);
			_tmp102_[0] = _tmp96_;
			_tmp102_[1] = _tmp98_;
			_tmp102_[2] = _tmp99_;
			_tmp102_[3] = _tmp100_;
			_tmp102_[4] = _tmp101_;
			adf_sources = _tmp102_;
			adf_sources_length1 = 5;
			_adf_sources_size_ = adf_sources_length1;
			_tmp103_ = g_strdup ("ADF Front");
			_tmp104_ = SANE_I18N ("ADF Front");
			_tmp105_ = g_strdup (_tmp104_);
			_tmp106_ = g_new0 (gchar*, 2 + 1);
			_tmp106_[0] = _tmp103_;
			_tmp106_[1] = _tmp105_;
			adf_front_sources = _tmp106_;
			adf_front_sources_length1 = 2;
			_adf_front_sources_size_ = adf_front_sources_length1;
			_tmp107_ = g_strdup ("ADF Back");
			_tmp108_ = SANE_I18N ("ADF Back");
			_tmp109_ = g_strdup (_tmp108_);
			_tmp110_ = g_new0 (gchar*, 2 + 1);
			_tmp110_[0] = _tmp107_;
			_tmp110_[1] = _tmp109_;
			adf_back_sources = _tmp110_;
			adf_back_sources_length1 = 2;
			_adf_back_sources_size_ = adf_back_sources_length1;
			_tmp111_ = g_strdup ("ADF Duplex");
			_tmp112_ = SANE_I18N ("ADF Duplex");
			_tmp113_ = g_strdup (_tmp112_);
			_tmp114_ = g_new0 (gchar*, 2 + 1);
			_tmp114_[0] = _tmp111_;
			_tmp114_[1] = _tmp113_;
			adf_duplex_sources = _tmp114_;
			adf_duplex_sources_length1 = 2;
			_adf_duplex_sources_size_ = adf_duplex_sources_length1;
			_tmp115_ = job;
			_tmp116_ = _tmp115_->type;
			switch (_tmp116_) {
				case SCAN_TYPE_SINGLE:
				{
					SANE_Handle _tmp117_;
					SANE_Option_Descriptor* _tmp118_;
					SANE_Int _tmp119_;
					gboolean _tmp120_ = FALSE;
					_tmp117_ = self->priv->handle;
					_tmp118_ = option;
					_tmp119_ = index;
					_tmp120_ = scanner_set_default_option (self, _tmp117_, _tmp118_, _tmp119_);
					if (!_tmp120_) {
						SANE_Handle _tmp121_;
						SANE_Option_Descriptor* _tmp122_;
						SANE_Int _tmp123_;
						gchar** _tmp124_;
						gint _tmp124__length1;
						gboolean _tmp125_ = FALSE;
						_tmp121_ = self->priv->handle;
						_tmp122_ = option;
						_tmp123_ = index;
						_tmp124_ = flatbed_sources;
						_tmp124__length1 = flatbed_sources_length1;
						_tmp125_ = scanner_set_constrained_string_option (self, _tmp121_, _tmp122_, _tmp123_, _tmp124_, _tmp124__length1, NULL);
						if (!_tmp125_) {
							g_warning ("scanner.vala:922: Unable to set single page source, please file a bug");
						}
					}
					break;
				}
				case SCAN_TYPE_ADF_FRONT:
				{
					SANE_Handle _tmp126_;
					SANE_Option_Descriptor* _tmp127_;
					SANE_Int _tmp128_;
					gchar** _tmp129_;
					gint _tmp129__length1;
					gboolean _tmp130_ = FALSE;
					_tmp126_ = self->priv->handle;
					_tmp127_ = option;
					_tmp128_ = index;
					_tmp129_ = adf_front_sources;
					_tmp129__length1 = adf_front_sources_length1;
					_tmp130_ = scanner_set_constrained_string_option (self, _tmp126_, _tmp127_, _tmp128_, _tmp129_, _tmp129__length1, NULL);
					if (!_tmp130_) {
						SANE_Handle _tmp131_;
						SANE_Option_Descriptor* _tmp132_;
						SANE_Int _tmp133_;
						gchar** _tmp134_;
						gint _tmp134__length1;
						gboolean _tmp135_ = FALSE;
						_tmp131_ = self->priv->handle;
						_tmp132_ = option;
						_tmp133_ = index;
						_tmp134_ = adf_sources;
						_tmp134__length1 = adf_sources_length1;
						_tmp135_ = scanner_set_constrained_string_option (self, _tmp131_, _tmp132_, _tmp133_, _tmp134_, _tmp134__length1, NULL);
						if (!(!_tmp135_)) {
							g_warning ("scanner.vala:927: Unable to set front ADF source, please file a bug");
						}
					}
					break;
				}
				case SCAN_TYPE_ADF_BACK:
				{
					SANE_Handle _tmp136_;
					SANE_Option_Descriptor* _tmp137_;
					SANE_Int _tmp138_;
					gchar** _tmp139_;
					gint _tmp139__length1;
					gboolean _tmp140_ = FALSE;
					_tmp136_ = self->priv->handle;
					_tmp137_ = option;
					_tmp138_ = index;
					_tmp139_ = adf_back_sources;
					_tmp139__length1 = adf_back_sources_length1;
					_tmp140_ = scanner_set_constrained_string_option (self, _tmp136_, _tmp137_, _tmp138_, _tmp139_, _tmp139__length1, NULL);
					if (!_tmp140_) {
						SANE_Handle _tmp141_;
						SANE_Option_Descriptor* _tmp142_;
						SANE_Int _tmp143_;
						gchar** _tmp144_;
						gint _tmp144__length1;
						gboolean _tmp145_ = FALSE;
						_tmp141_ = self->priv->handle;
						_tmp142_ = option;
						_tmp143_ = index;
						_tmp144_ = adf_sources;
						_tmp144__length1 = adf_sources_length1;
						_tmp145_ = scanner_set_constrained_string_option (self, _tmp141_, _tmp142_, _tmp143_, _tmp144_, _tmp144__length1, NULL);
						if (!_tmp145_) {
							g_warning ("scanner.vala:932: Unable to set back ADF source, please file a bug");
						}
					}
					break;
				}
				case SCAN_TYPE_ADF_BOTH:
				{
					SANE_Handle _tmp146_;
					SANE_Option_Descriptor* _tmp147_;
					SANE_Int _tmp148_;
					gchar** _tmp149_;
					gint _tmp149__length1;
					gboolean _tmp150_ = FALSE;
					_tmp146_ = self->priv->handle;
					_tmp147_ = option;
					_tmp148_ = index;
					_tmp149_ = adf_duplex_sources;
					_tmp149__length1 = adf_duplex_sources_length1;
					_tmp150_ = scanner_set_constrained_string_option (self, _tmp146_, _tmp147_, _tmp148_, _tmp149_, _tmp149__length1, NULL);
					if (!_tmp150_) {
						SANE_Handle _tmp151_;
						SANE_Option_Descriptor* _tmp152_;
						SANE_Int _tmp153_;
						gchar** _tmp154_;
						gint _tmp154__length1;
						gboolean _tmp155_ = FALSE;
						_tmp151_ = self->priv->handle;
						_tmp152_ = option;
						_tmp153_ = index;
						_tmp154_ = adf_sources;
						_tmp154__length1 = adf_sources_length1;
						_tmp155_ = scanner_set_constrained_string_option (self, _tmp151_, _tmp152_, _tmp153_, _tmp154_, _tmp154__length1, NULL);
						if (!_tmp155_) {
							g_warning ("scanner.vala:937: Unable to set duplex ADF source, please file a bug");
						}
					}
					break;
				}
				default:
				break;
			}
			adf_duplex_sources = (_vala_array_free (adf_duplex_sources, adf_duplex_sources_length1, (GDestroyNotify) g_free), NULL);
			adf_back_sources = (_vala_array_free (adf_back_sources, adf_back_sources_length1, (GDestroyNotify) g_free), NULL);
			adf_front_sources = (_vala_array_free (adf_front_sources, adf_front_sources_length1, (GDestroyNotify) g_free), NULL);
			adf_sources = (_vala_array_free (adf_sources, adf_sources_length1, (GDestroyNotify) g_free), NULL);
			flatbed_sources = (_vala_array_free (flatbed_sources, flatbed_sources_length1, (GDestroyNotify) g_free), NULL);
		} else {
			SANE_Option_Descriptor* _tmp156_;
			const gchar* _tmp157_;
			_tmp156_ = option;
			_tmp157_ = _tmp156_->name;
			if (g_strcmp0 (_tmp157_, "duplex") == 0) {
				SANE_Option_Descriptor* _tmp158_;
				SANE_Value_Type _tmp159_;
				_tmp158_ = option;
				_tmp159_ = _tmp158_->type;
				if (_tmp159_ == SANE_TYPE_BOOL) {
					SANE_Handle _tmp160_;
					SANE_Option_Descriptor* _tmp161_;
					SANE_Int _tmp162_;
					ScanJob* _tmp163_;
					ScanType _tmp164_;
					_tmp160_ = self->priv->handle;
					_tmp161_ = option;
					_tmp162_ = index;
					_tmp163_ = job;
					_tmp164_ = _tmp163_->type;
					scanner_set_bool_option (self, _tmp160_, _tmp161_, _tmp162_, _tmp164_ == SCAN_TYPE_ADF_BOTH, NULL);
				}
			} else {
				SANE_Option_Descriptor* _tmp165_;
				const gchar* _tmp166_;
				_tmp165_ = option;
				_tmp166_ = _tmp165_->name;
				if (g_strcmp0 (_tmp166_, "batch-scan") == 0) {
					SANE_Option_Descriptor* _tmp167_;
					SANE_Value_Type _tmp168_;
					_tmp167_ = option;
					_tmp168_ = _tmp167_->type;
					if (_tmp168_ == SANE_TYPE_BOOL) {
						SANE_Handle _tmp169_;
						SANE_Option_Descriptor* _tmp170_;
						SANE_Int _tmp171_;
						ScanJob* _tmp172_;
						ScanType _tmp173_;
						_tmp169_ = self->priv->handle;
						_tmp170_ = option;
						_tmp171_ = index;
						_tmp172_ = job;
						_tmp173_ = _tmp172_->type;
						scanner_set_bool_option (self, _tmp169_, _tmp170_, _tmp171_, _tmp173_ != SCAN_TYPE_SINGLE, NULL);
					}
				} else {
					SANE_Option_Descriptor* _tmp174_;
					const gchar* _tmp175_;
					const gchar* _tmp176_;
					_tmp174_ = option;
					_tmp175_ = _tmp174_->name;
					_tmp176_ = SANE_NAME_BIT_DEPTH;
					if (g_strcmp0 (_tmp175_, _tmp176_) == 0) {
						ScanJob* _tmp177_;
						gint _tmp178_;
						_tmp177_ = job;
						_tmp178_ = _tmp177_->depth;
						if (_tmp178_ > 0) {
							SANE_Handle _tmp179_;
							SANE_Option_Descriptor* _tmp180_;
							SANE_Int _tmp181_;
							ScanJob* _tmp182_;
							gint _tmp183_;
							_tmp179_ = self->priv->handle;
							_tmp180_ = option;
							_tmp181_ = index;
							_tmp182_ = job;
							_tmp183_ = _tmp182_->depth;
							scanner_set_int_option (self, _tmp179_, _tmp180_, _tmp181_, _tmp183_, NULL);
						}
					} else {
						SANE_Option_Descriptor* _tmp184_;
						const gchar* _tmp185_;
						const gchar* _tmp186_;
						_tmp184_ = option;
						_tmp185_ = _tmp184_->name;
						_tmp186_ = SANE_NAME_SCAN_MODE;
						if (g_strcmp0 (_tmp185_, _tmp186_) == 0) {
							const gchar* _tmp187_;
							gchar* _tmp188_;
							gchar* _tmp189_;
							gchar* _tmp190_;
							gchar** _tmp191_ = NULL;
							gchar** color_scan_modes;
							gint color_scan_modes_length1;
							gint _color_scan_modes_size_;
							const gchar* _tmp192_;
							gchar* _tmp193_;
							gchar* _tmp194_;
							gchar* _tmp195_;
							const gchar* _tmp196_ = NULL;
							gchar* _tmp197_;
							gchar* _tmp198_;
							gchar** _tmp199_ = NULL;
							gchar** gray_scan_modes;
							gint gray_scan_modes_length1;
							gint _gray_scan_modes_size_;
							const gchar* _tmp200_;
							gchar* _tmp201_;
							gchar* _tmp202_;
							gchar* _tmp203_;
							const gchar* _tmp204_ = NULL;
							gchar* _tmp205_;
							gchar* _tmp206_;
							const gchar* _tmp207_ = NULL;
							gchar* _tmp208_;
							gchar* _tmp209_;
							const gchar* _tmp210_ = NULL;
							gchar* _tmp211_;
							gchar* _tmp212_;
							const gchar* _tmp213_;
							gchar* _tmp214_;
							gchar* _tmp215_;
							gchar* _tmp216_;
							const gchar* _tmp217_ = NULL;
							gchar* _tmp218_;
							gchar* _tmp219_;
							gchar** _tmp220_ = NULL;
							gchar** lineart_scan_modes;
							gint lineart_scan_modes_length1;
							gint _lineart_scan_modes_size_;
							ScanJob* _tmp221_;
							ScanMode _tmp222_;
							_tmp187_ = SANE_VALUE_SCAN_MODE_COLOR;
							_tmp188_ = g_strdup (_tmp187_);
							_tmp189_ = g_strdup ("Color");
							_tmp190_ = g_strdup ("24bit Color");
							_tmp191_ = g_new0 (gchar*, 3 + 1);
							_tmp191_[0] = _tmp188_;
							_tmp191_[1] = _tmp189_;
							_tmp191_[2] = _tmp190_;
							color_scan_modes = _tmp191_;
							color_scan_modes_length1 = 3;
							_color_scan_modes_size_ = color_scan_modes_length1;
							_tmp192_ = SANE_VALUE_SCAN_MODE_GRAY;
							_tmp193_ = g_strdup (_tmp192_);
							_tmp194_ = g_strdup ("Gray");
							_tmp195_ = g_strdup ("Grayscale");
							_tmp196_ = SANE_I18N ("Grayscale");
							_tmp197_ = g_strdup (_tmp196_);
							_tmp198_ = g_strdup ("True Gray");
							_tmp199_ = g_new0 (gchar*, 5 + 1);
							_tmp199_[0] = _tmp193_;
							_tmp199_[1] = _tmp194_;
							_tmp199_[2] = _tmp195_;
							_tmp199_[3] = _tmp197_;
							_tmp199_[4] = _tmp198_;
							gray_scan_modes = _tmp199_;
							gray_scan_modes_length1 = 5;
							_gray_scan_modes_size_ = gray_scan_modes_length1;
							_tmp200_ = SANE_VALUE_SCAN_MODE_LINEART;
							_tmp201_ = g_strdup (_tmp200_);
							_tmp202_ = g_strdup ("Lineart");
							_tmp203_ = g_strdup ("LineArt");
							_tmp204_ = SANE_I18N ("LineArt");
							_tmp205_ = g_strdup (_tmp204_);
							_tmp206_ = g_strdup ("Black & White");
							_tmp207_ = SANE_I18N ("Black & White");
							_tmp208_ = g_strdup (_tmp207_);
							_tmp209_ = g_strdup ("Binary");
							_tmp210_ = SANE_I18N ("Binary");
							_tmp211_ = g_strdup (_tmp210_);
							_tmp212_ = g_strdup ("Thresholded");
							_tmp213_ = SANE_VALUE_SCAN_MODE_GRAY;
							_tmp214_ = g_strdup (_tmp213_);
							_tmp215_ = g_strdup ("Gray");
							_tmp216_ = g_strdup ("Grayscale");
							_tmp217_ = SANE_I18N ("Grayscale");
							_tmp218_ = g_strdup (_tmp217_);
							_tmp219_ = g_strdup ("True Gray");
							_tmp220_ = g_new0 (gchar*, 14 + 1);
							_tmp220_[0] = _tmp201_;
							_tmp220_[1] = _tmp202_;
							_tmp220_[2] = _tmp203_;
							_tmp220_[3] = _tmp205_;
							_tmp220_[4] = _tmp206_;
							_tmp220_[5] = _tmp208_;
							_tmp220_[6] = _tmp209_;
							_tmp220_[7] = _tmp211_;
							_tmp220_[8] = _tmp212_;
							_tmp220_[9] = _tmp214_;
							_tmp220_[10] = _tmp215_;
							_tmp220_[11] = _tmp216_;
							_tmp220_[12] = _tmp218_;
							_tmp220_[13] = _tmp219_;
							lineart_scan_modes = _tmp220_;
							lineart_scan_modes_length1 = 14;
							_lineart_scan_modes_size_ = lineart_scan_modes_length1;
							_tmp221_ = job;
							_tmp222_ = _tmp221_->scan_mode;
							switch (_tmp222_) {
								case SCAN_MODE_COLOR:
								{
									SANE_Handle _tmp223_;
									SANE_Option_Descriptor* _tmp224_;
									SANE_Int _tmp225_;
									gchar** _tmp226_;
									gint _tmp226__length1;
									gboolean _tmp227_ = FALSE;
									_tmp223_ = self->priv->handle;
									_tmp224_ = option;
									_tmp225_ = index;
									_tmp226_ = color_scan_modes;
									_tmp226__length1 = color_scan_modes_length1;
									_tmp227_ = scanner_set_constrained_string_option (self, _tmp223_, _tmp224_, _tmp225_, _tmp226_, _tmp226__length1, NULL);
									if (!_tmp227_) {
										g_warning ("scanner.vala:995: Unable to set Color mode, please file a bug");
									}
									break;
								}
								case SCAN_MODE_GRAY:
								{
									SANE_Handle _tmp228_;
									SANE_Option_Descriptor* _tmp229_;
									SANE_Int _tmp230_;
									gchar** _tmp231_;
									gint _tmp231__length1;
									gboolean _tmp232_ = FALSE;
									_tmp228_ = self->priv->handle;
									_tmp229_ = option;
									_tmp230_ = index;
									_tmp231_ = gray_scan_modes;
									_tmp231__length1 = gray_scan_modes_length1;
									_tmp232_ = scanner_set_constrained_string_option (self, _tmp228_, _tmp229_, _tmp230_, _tmp231_, _tmp231__length1, NULL);
									if (!_tmp232_) {
										g_warning ("scanner.vala:999: Unable to set Gray mode, please file a bug");
									}
									break;
								}
								case SCAN_MODE_LINEART:
								{
									SANE_Handle _tmp233_;
									SANE_Option_Descriptor* _tmp234_;
									SANE_Int _tmp235_;
									gchar** _tmp236_;
									gint _tmp236__length1;
									gboolean _tmp237_ = FALSE;
									_tmp233_ = self->priv->handle;
									_tmp234_ = option;
									_tmp235_ = index;
									_tmp236_ = lineart_scan_modes;
									_tmp236__length1 = lineart_scan_modes_length1;
									_tmp237_ = scanner_set_constrained_string_option (self, _tmp233_, _tmp234_, _tmp235_, _tmp236_, _tmp236__length1, NULL);
									if (!_tmp237_) {
										g_warning ("scanner.vala:1003: Unable to set Lineart mode, please file a bug");
									}
									break;
								}
								default:
								{
									break;
								}
							}
							lineart_scan_modes = (_vala_array_free (lineart_scan_modes, lineart_scan_modes_length1, (GDestroyNotify) g_free), NULL);
							gray_scan_modes = (_vala_array_free (gray_scan_modes, gray_scan_modes_length1, (GDestroyNotify) g_free), NULL);
							color_scan_modes = (_vala_array_free (color_scan_modes, color_scan_modes_length1, (GDestroyNotify) g_free), NULL);
						} else {
							SANE_Option_Descriptor* _tmp238_;
							const gchar* _tmp239_;
							_tmp238_ = option;
							_tmp239_ = _tmp238_->name;
							if (g_strcmp0 (_tmp239_, "compression") == 0) {
								const gchar* _tmp240_ = NULL;
								gchar* _tmp241_;
								const gchar* _tmp242_ = NULL;
								gchar* _tmp243_;
								gchar* _tmp244_;
								gchar* _tmp245_;
								gchar** _tmp246_ = NULL;
								gchar** disable_compression_names;
								gint disable_compression_names_length1;
								gint _disable_compression_names_size_;
								SANE_Handle _tmp247_;
								SANE_Option_Descriptor* _tmp248_;
								SANE_Int _tmp249_;
								gchar** _tmp250_;
								gint _tmp250__length1;
								gboolean _tmp251_ = FALSE;
								_tmp240_ = SANE_I18N ("None");
								_tmp241_ = g_strdup (_tmp240_);
								_tmp242_ = SANE_I18N ("none");
								_tmp243_ = g_strdup (_tmp242_);
								_tmp244_ = g_strdup ("None");
								_tmp245_ = g_strdup ("none");
								_tmp246_ = g_new0 (gchar*, 4 + 1);
								_tmp246_[0] = _tmp241_;
								_tmp246_[1] = _tmp243_;
								_tmp246_[2] = _tmp244_;
								_tmp246_[3] = _tmp245_;
								disable_compression_names = _tmp246_;
								disable_compression_names_length1 = 4;
								_disable_compression_names_size_ = disable_compression_names_length1;
								_tmp247_ = self->priv->handle;
								_tmp248_ = option;
								_tmp249_ = index;
								_tmp250_ = disable_compression_names;
								_tmp250__length1 = disable_compression_names_length1;
								_tmp251_ = scanner_set_constrained_string_option (self, _tmp247_, _tmp248_, _tmp249_, _tmp250_, _tmp250__length1, NULL);
								if (!_tmp251_) {
									g_warning ("scanner.vala:1021: Unable to disable compression, please file a bug");
								}
								disable_compression_names = (_vala_array_free (disable_compression_names, disable_compression_names_length1, (GDestroyNotify) g_free), NULL);
							} else {
								SANE_Option_Descriptor* _tmp252_;
								const gchar* _tmp253_;
								const gchar* _tmp254_;
								_tmp252_ = option;
								_tmp253_ = _tmp252_->name;
								_tmp254_ = SANE_NAME_SCAN_BR_X;
								if (g_strcmp0 (_tmp253_, _tmp254_) == 0) {
									SANE_Int _tmp255_;
									_tmp255_ = index;
									self->priv->br_x_option_index = _tmp255_;
								} else {
									SANE_Option_Descriptor* _tmp256_;
									const gchar* _tmp257_;
									const gchar* _tmp258_;
									_tmp256_ = option;
									_tmp257_ = _tmp256_->name;
									_tmp258_ = SANE_NAME_SCAN_BR_Y;
									if (g_strcmp0 (_tmp257_, _tmp258_) == 0) {
										SANE_Int _tmp259_;
										_tmp259_ = index;
										self->priv->br_y_option_index = _tmp259_;
									} else {
										SANE_Option_Descriptor* _tmp260_;
										const gchar* _tmp261_;
										const gchar* _tmp262_;
										_tmp260_ = option;
										_tmp261_ = _tmp260_->name;
										_tmp262_ = SANE_NAME_PAGE_WIDTH;
										if (g_strcmp0 (_tmp261_, _tmp262_) == 0) {
											ScanJob* _tmp263_;
											gint _tmp264_;
											_tmp263_ = job;
											_tmp264_ = _tmp263_->page_width;
											if (((gdouble) _tmp264_) > 0.0) {
												SANE_Option_Descriptor* _tmp265_;
												SANE_Value_Type _tmp266_;
												_tmp265_ = option;
												_tmp266_ = _tmp265_->type;
												if (_tmp266_ == SANE_TYPE_FIXED) {
													SANE_Handle _tmp267_;
													SANE_Option_Descriptor* _tmp268_;
													SANE_Int _tmp269_;
													ScanJob* _tmp270_;
													gint _tmp271_;
													_tmp267_ = self->priv->handle;
													_tmp268_ = option;
													_tmp269_ = index;
													_tmp270_ = job;
													_tmp271_ = _tmp270_->page_width;
													scanner_set_fixed_option (self, _tmp267_, _tmp268_, _tmp269_, _tmp271_ / 10.0, NULL);
												} else {
													SANE_Handle _tmp272_;
													SANE_Option_Descriptor* _tmp273_;
													SANE_Int _tmp274_;
													ScanJob* _tmp275_;
													gint _tmp276_;
													_tmp272_ = self->priv->handle;
													_tmp273_ = option;
													_tmp274_ = index;
													_tmp275_ = job;
													_tmp276_ = _tmp275_->page_width;
													scanner_set_int_option (self, _tmp272_, _tmp273_, _tmp274_, _tmp276_ / 10, NULL);
												}
											}
										} else {
											SANE_Option_Descriptor* _tmp277_;
											const gchar* _tmp278_;
											const gchar* _tmp279_;
											_tmp277_ = option;
											_tmp278_ = _tmp277_->name;
											_tmp279_ = SANE_NAME_PAGE_HEIGHT;
											if (g_strcmp0 (_tmp278_, _tmp279_) == 0) {
												ScanJob* _tmp280_;
												gint _tmp281_;
												_tmp280_ = job;
												_tmp281_ = _tmp280_->page_height;
												if (((gdouble) _tmp281_) > 0.0) {
													SANE_Option_Descriptor* _tmp282_;
													SANE_Value_Type _tmp283_;
													_tmp282_ = option;
													_tmp283_ = _tmp282_->type;
													if (_tmp283_ == SANE_TYPE_FIXED) {
														SANE_Handle _tmp284_;
														SANE_Option_Descriptor* _tmp285_;
														SANE_Int _tmp286_;
														ScanJob* _tmp287_;
														gint _tmp288_;
														_tmp284_ = self->priv->handle;
														_tmp285_ = option;
														_tmp286_ = index;
														_tmp287_ = job;
														_tmp288_ = _tmp287_->page_height;
														scanner_set_fixed_option (self, _tmp284_, _tmp285_, _tmp286_, _tmp288_ / 10.0, NULL);
													} else {
														SANE_Handle _tmp289_;
														SANE_Option_Descriptor* _tmp290_;
														SANE_Int _tmp291_;
														ScanJob* _tmp292_;
														gint _tmp293_;
														_tmp289_ = self->priv->handle;
														_tmp290_ = option;
														_tmp291_ = index;
														_tmp292_ = job;
														_tmp293_ = _tmp292_->page_height;
														scanner_set_int_option (self, _tmp289_, _tmp290_, _tmp291_, _tmp293_ / 10, NULL);
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp294_ = self->priv->current_device;
	if (g_strcmp0 (_tmp294_, "test") == 0) {
		SANE_Option_Descriptor* _tmp295_;
		const gchar* _tmp296_;
		_tmp295_ = option;
		_tmp296_ = _tmp295_->name;
		if (g_strcmp0 (_tmp296_, "hand-scanner") == 0) {
			SANE_Handle _tmp297_;
			SANE_Option_Descriptor* _tmp298_;
			SANE_Int _tmp299_;
			_tmp297_ = self->priv->handle;
			_tmp298_ = option;
			_tmp299_ = index;
			scanner_set_bool_option (self, _tmp297_, _tmp298_, _tmp299_, FALSE, NULL);
		} else {
			SANE_Option_Descriptor* _tmp300_;
			const gchar* _tmp301_;
			_tmp300_ = option;
			_tmp301_ = _tmp300_->name;
			if (g_strcmp0 (_tmp301_, "three-pass") == 0) {
				SANE_Handle _tmp302_;
				SANE_Option_Descriptor* _tmp303_;
				SANE_Int _tmp304_;
				_tmp302_ = self->priv->handle;
				_tmp303_ = option;
				_tmp304_ = index;
				scanner_set_bool_option (self, _tmp302_, _tmp303_, _tmp304_, FALSE, NULL);
			} else {
				SANE_Option_Descriptor* _tmp305_;
				const gchar* _tmp306_;
				_tmp305_ = option;
				_tmp306_ = _tmp305_->name;
				if (g_strcmp0 (_tmp306_, "test-picture") == 0) {
					SANE_Handle _tmp307_;
					SANE_Option_Descriptor* _tmp308_;
					SANE_Int _tmp309_;
					_tmp307_ = self->priv->handle;
					_tmp308_ = option;
					_tmp309_ = index;
					scanner_set_string_option (self, _tmp307_, _tmp308_, _tmp309_, "Color pattern", NULL);
				} else {
					SANE_Option_Descriptor* _tmp310_;
					const gchar* _tmp311_;
					_tmp310_ = option;
					_tmp311_ = _tmp310_->name;
					if (g_strcmp0 (_tmp311_, "read-delay") == 0) {
						SANE_Handle _tmp312_;
						SANE_Option_Descriptor* _tmp313_;
						SANE_Int _tmp314_;
						_tmp312_ = self->priv->handle;
						_tmp313_ = option;
						_tmp314_ = index;
						scanner_set_bool_option (self, _tmp312_, _tmp313_, _tmp314_, TRUE, NULL);
					} else {
						SANE_Option_Descriptor* _tmp315_;
						const gchar* _tmp316_;
						_tmp315_ = option;
						_tmp316_ = _tmp315_->name;
						if (g_strcmp0 (_tmp316_, "read-delay-duration") == 0) {
							SANE_Handle _tmp317_;
							SANE_Option_Descriptor* _tmp318_;
							SANE_Int _tmp319_;
							_tmp317_ = self->priv->handle;
							_tmp318_ = option;
							_tmp319_ = index;
							scanner_set_int_option (self, _tmp317_, _tmp318_, _tmp319_, 200000, NULL);
						}
					}
				}
			}
		}
	}
	_scan_job_unref0 (job);
}


static void scanner_do_complete_document (Scanner* self) {
	GList* _tmp0_;
	GList* _tmp1_;
	NotifyDocumentDone* _tmp2_;
	NotifyDocumentDone* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->job_queue;
	self->priv->job_queue = g_list_remove_link (self->priv->job_queue, _tmp0_);
	self->priv->state = SCAN_STATE_IDLE;
	_tmp1_ = self->priv->job_queue;
	if (_tmp1_ != NULL) {
		self->priv->state = SCAN_STATE_OPEN;
		return;
	}
	_tmp2_ = notify_document_done_new ();
	_tmp3_ = _tmp2_;
	scanner_notify (self, (Notify*) _tmp3_);
	_notify_unref0 (_tmp3_);
	scanner_set_scanning (self, FALSE);
}


static void scanner_do_start (Scanner* self) {
	SANE_Status status = 0;
	NotifyExpectPage* _tmp0_;
	NotifyExpectPage* _tmp1_;
	SANE_Handle _tmp2_;
	SANE_Status _tmp3_ = 0;
	gint _tmp4_;
	gint _tmp5_;
	SANE_Status _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	SANE_Status _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = notify_expect_page_new ();
	_tmp1_ = _tmp0_;
	scanner_notify (self, (Notify*) _tmp1_);
	_notify_unref0 (_tmp1_);
	_tmp2_ = self->priv->handle;
	_tmp3_ = sane_start (_tmp2_);
	status = _tmp3_;
	_tmp4_ = self->priv->page_number;
	_tmp5_ = self->priv->pass_number;
	_tmp6_ = status;
	_tmp7_ = sane_status_to_string (_tmp6_);
	_tmp8_ = _tmp7_;
	g_debug ("scanner.vala:1091: sane_start (page=%d, pass=%d) -> %s", _tmp4_, _tmp5_, _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = status;
	if (_tmp9_ == SANE_STATUS_GOOD) {
		self->priv->state = SCAN_STATE_GET_PARAMETERS;
	} else {
		SANE_Status _tmp10_;
		_tmp10_ = status;
		if (_tmp10_ == SANE_STATUS_NO_DOCS) {
			scanner_do_complete_document (self);
		} else {
			SANE_Status _tmp11_;
			const gchar* _tmp12_ = NULL;
			SANE_Status _tmp13_;
			const gchar* _tmp14_ = NULL;
			_tmp11_ = status;
			_tmp12_ = sane_strstatus (_tmp11_);
			g_warning ("scanner.vala:1098: Unable to start device: %s", _tmp12_);
			_tmp13_ = status;
			_tmp14_ = _ ("Unable to start scan");
			scanner_fail_scan (self, (gint) _tmp13_, _tmp14_);
		}
	}
}


static gchar* sane_frame_to_string (SANE_Frame frame) {
	gchar* result = NULL;
	SANE_Frame _tmp0_;
	_tmp0_ = frame;
	switch (_tmp0_) {
		case SANE_FRAME_GRAY:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("SANE_FRAME_GRAY");
			result = _tmp1_;
			return result;
		}
		case SANE_FRAME_RGB:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("SANE_FRAME_RGB");
			result = _tmp2_;
			return result;
		}
		case SANE_FRAME_RED:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("SANE_FRAME_RED");
			result = _tmp3_;
			return result;
		}
		case SANE_FRAME_GREEN:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("SANE_FRAME_GREEN");
			result = _tmp4_;
			return result;
		}
		case SANE_FRAME_BLUE:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("SANE_FRAME_BLUE");
			result = _tmp5_;
			return result;
		}
		default:
		{
			SANE_Frame _tmp6_;
			gchar* _tmp7_ = NULL;
			_tmp6_ = frame;
			_tmp7_ = g_strdup_printf ("SANE_FRAME(%d)", (gint) _tmp6_);
			result = _tmp7_;
			return result;
		}
	}
}


static void scanner_do_get_parameters (Scanner* self) {
	SANE_Handle _tmp0_;
	SANE_Parameters _tmp1_ = {0};
	SANE_Status _tmp2_ = 0;
	SANE_Status status;
	SANE_Status _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	SANE_Status _tmp6_;
	GList* _tmp11_;
	gconstpointer _tmp12_;
	ScanJob* _tmp13_;
	ScanJob* job;
	const gchar* _tmp14_ = NULL;
	SANE_Parameters _tmp15_;
	gboolean _tmp16_;
	SANE_Parameters _tmp17_;
	SANE_Frame _tmp18_;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	SANE_Parameters _tmp22_;
	gint _tmp23_;
	SANE_Parameters _tmp24_;
	gint _tmp25_;
	SANE_Parameters _tmp26_;
	gint _tmp27_;
	SANE_Parameters _tmp28_;
	gint _tmp29_;
	ScanPageInfo* _tmp30_;
	ScanPageInfo* info;
	ScanPageInfo* _tmp31_;
	SANE_Parameters _tmp32_;
	gint _tmp33_;
	ScanPageInfo* _tmp34_;
	SANE_Parameters _tmp35_;
	gint _tmp36_;
	ScanPageInfo* _tmp37_;
	SANE_Parameters _tmp38_;
	gint _tmp39_;
	gboolean _tmp40_ = FALSE;
	gboolean _tmp41_ = FALSE;
	gboolean _tmp42_ = FALSE;
	SANE_Parameters _tmp43_;
	gint _tmp44_;
	gboolean _tmp47_;
	gboolean _tmp50_;
	gboolean _tmp53_;
	gint _tmp57_ = 0;
	SANE_Parameters _tmp58_;
	SANE_Frame _tmp59_;
	ScanPageInfo* _tmp60_;
	gint _tmp61_;
	ScanPageInfo* _tmp62_;
	ScanJob* _tmp63_;
	gdouble _tmp64_;
	ScanPageInfo* _tmp65_;
	const gchar* _tmp66_;
	gchar* _tmp67_;
	gint _tmp68_;
	gint _tmp69_;
	SANE_Parameters _tmp74_;
	gint _tmp75_;
	gint buffer_size;
	gint _tmp76_;
	guchar* _tmp77_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->handle;
	_tmp2_ = sane_get_parameters (_tmp0_, &_tmp1_);
	self->priv->parameters = _tmp1_;
	status = _tmp2_;
	_tmp3_ = status;
	_tmp4_ = sane_status_to_string (_tmp3_);
	_tmp5_ = _tmp4_;
	g_debug ("scanner.vala:1108: sane_get_parameters () -> %s", _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = status;
	if (_tmp6_ != SANE_STATUS_GOOD) {
		SANE_Status _tmp7_;
		const gchar* _tmp8_ = NULL;
		SANE_Status _tmp9_;
		const gchar* _tmp10_ = NULL;
		_tmp7_ = status;
		_tmp8_ = sane_strstatus (_tmp7_);
		g_warning ("scanner.vala:1111: Unable to get device parameters: %s", _tmp8_);
		_tmp9_ = status;
		_tmp10_ = _ ("Error communicating with scanner");
		scanner_fail_scan (self, (gint) _tmp9_, _tmp10_);
		return;
	}
	_tmp11_ = self->priv->job_queue;
	_tmp12_ = _tmp11_->data;
	_tmp13_ = _scan_job_ref0 (SCAN_JOB ((ScanJob*) _tmp12_));
	job = _tmp13_;
	_tmp15_ = self->priv->parameters;
	_tmp16_ = _tmp15_.last_frame;
	if (_tmp16_) {
		_tmp14_ = "SANE_TRUE";
	} else {
		_tmp14_ = "SANE_FALSE";
	}
	_tmp17_ = self->priv->parameters;
	_tmp18_ = _tmp17_.format;
	_tmp19_ = sane_frame_to_string (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = _tmp14_;
	_tmp22_ = self->priv->parameters;
	_tmp23_ = _tmp22_.bytes_per_line;
	_tmp24_ = self->priv->parameters;
	_tmp25_ = _tmp24_.pixels_per_line;
	_tmp26_ = self->priv->parameters;
	_tmp27_ = _tmp26_.lines;
	_tmp28_ = self->priv->parameters;
	_tmp29_ = _tmp28_.depth;
	g_debug ("scanner.vala:1120: Parameters: format=%s last_frame=%s bytes_per_line=" \
"%d pixels_per_line=%d lines=%d depth=%d", _tmp20_, _tmp21_, _tmp23_, _tmp25_, _tmp27_, _tmp29_);
	_g_free0 (_tmp20_);
	_tmp30_ = scan_page_info_new ();
	info = _tmp30_;
	_tmp31_ = info;
	_tmp32_ = self->priv->parameters;
	_tmp33_ = _tmp32_.pixels_per_line;
	_tmp31_->width = _tmp33_;
	_tmp34_ = info;
	_tmp35_ = self->priv->parameters;
	_tmp36_ = _tmp35_.lines;
	_tmp34_->height = _tmp36_;
	_tmp37_ = info;
	_tmp38_ = self->priv->parameters;
	_tmp39_ = _tmp38_.depth;
	_tmp37_->depth = _tmp39_;
	_tmp43_ = self->priv->parameters;
	_tmp44_ = _tmp43_.depth;
	if (_tmp44_ == 8) {
		SANE_Parameters _tmp45_;
		SANE_Frame _tmp46_;
		_tmp45_ = self->priv->parameters;
		_tmp46_ = _tmp45_.format;
		_tmp42_ = _tmp46_ == SANE_FRAME_GRAY;
	} else {
		_tmp42_ = FALSE;
	}
	_tmp47_ = _tmp42_;
	if (_tmp47_) {
		ScanJob* _tmp48_;
		gint _tmp49_;
		_tmp48_ = job;
		_tmp49_ = _tmp48_->depth;
		_tmp41_ = _tmp49_ == 2;
	} else {
		_tmp41_ = FALSE;
	}
	_tmp50_ = _tmp41_;
	if (_tmp50_) {
		ScanJob* _tmp51_;
		ScanMode _tmp52_;
		_tmp51_ = job;
		_tmp52_ = _tmp51_->scan_mode;
		_tmp40_ = _tmp52_ == SCAN_MODE_GRAY;
	} else {
		_tmp40_ = FALSE;
	}
	_tmp53_ = _tmp40_;
	if (_tmp53_) {
		ScanPageInfo* _tmp54_;
		ScanJob* _tmp55_;
		gint _tmp56_;
		_tmp54_ = info;
		_tmp55_ = job;
		_tmp56_ = _tmp55_->depth;
		_tmp54_->depth = _tmp56_;
	}
	_tmp58_ = self->priv->parameters;
	_tmp59_ = _tmp58_.format;
	if (_tmp59_ == SANE_FRAME_GRAY) {
		_tmp57_ = 1;
	} else {
		_tmp57_ = 3;
	}
	_tmp60_ = info;
	_tmp61_ = _tmp57_;
	_tmp60_->n_channels = _tmp61_;
	_tmp62_ = info;
	_tmp63_ = job;
	_tmp64_ = _tmp63_->dpi;
	_tmp62_->dpi = _tmp64_;
	_tmp65_ = info;
	_tmp66_ = self->priv->current_device;
	_tmp67_ = g_strdup (_tmp66_);
	_g_free0 (_tmp65_->device);
	_tmp65_->device = _tmp67_;
	_tmp68_ = self->priv->page_number;
	_tmp69_ = self->priv->notified_page;
	if (_tmp68_ != _tmp69_) {
		ScanPageInfo* _tmp70_;
		NotifyGotPageInfo* _tmp71_;
		NotifyGotPageInfo* _tmp72_;
		gint _tmp73_;
		_tmp70_ = info;
		_tmp71_ = notify_got_page_info_new (_tmp70_);
		_tmp72_ = _tmp71_;
		scanner_notify (self, (Notify*) _tmp72_);
		_notify_unref0 (_tmp72_);
		_tmp73_ = self->priv->page_number;
		self->priv->notified_page = _tmp73_;
	}
	_tmp74_ = self->priv->parameters;
	_tmp75_ = _tmp74_.bytes_per_line;
	buffer_size = _tmp75_ + 1;
	_tmp76_ = buffer_size;
	_tmp77_ = g_new0 (guchar, _tmp76_);
	self->priv->buffer = (g_free (self->priv->buffer), NULL);
	self->priv->buffer = _tmp77_;
	self->priv->buffer_length1 = _tmp76_;
	self->priv->_buffer_size_ = self->priv->buffer_length1;
	self->priv->n_used = 0;
	self->priv->line_count = 0;
	self->priv->pass_number = 0;
	self->priv->state = SCAN_STATE_READ;
	_scan_page_info_unref0 (info);
	_scan_job_unref0 (job);
}


static void scanner_do_complete_page (Scanner* self) {
	NotifyPageDone* _tmp0_;
	NotifyPageDone* _tmp1_;
	GList* _tmp2_;
	gconstpointer _tmp3_;
	ScanJob* _tmp4_;
	ScanJob* job;
	SANE_Parameters _tmp5_;
	gboolean _tmp6_;
	ScanJob* _tmp8_;
	ScanType _tmp9_;
	SANE_Handle _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = notify_page_done_new ();
	_tmp1_ = _tmp0_;
	scanner_notify (self, (Notify*) _tmp1_);
	_notify_unref0 (_tmp1_);
	_tmp2_ = self->priv->job_queue;
	_tmp3_ = _tmp2_->data;
	_tmp4_ = _scan_job_ref0 (SCAN_JOB ((ScanJob*) _tmp3_));
	job = _tmp4_;
	_tmp5_ = self->priv->parameters;
	_tmp6_ = _tmp5_.last_frame;
	if (!_tmp6_) {
		gint _tmp7_;
		_tmp7_ = self->priv->pass_number;
		self->priv->pass_number = _tmp7_ + 1;
		self->priv->state = SCAN_STATE_START;
		_scan_job_unref0 (job);
		return;
	}
	_tmp8_ = job;
	_tmp9_ = _tmp8_->type;
	if (_tmp9_ != SCAN_TYPE_SINGLE) {
		gint _tmp10_;
		NotifyPageDone* _tmp11_;
		NotifyPageDone* _tmp12_;
		_tmp10_ = self->priv->page_number;
		self->priv->page_number = _tmp10_ + 1;
		self->priv->pass_number = 0;
		_tmp11_ = notify_page_done_new ();
		_tmp12_ = _tmp11_;
		scanner_notify (self, (Notify*) _tmp12_);
		_notify_unref0 (_tmp12_);
		self->priv->state = SCAN_STATE_START;
		_scan_job_unref0 (job);
		return;
	}
	_tmp13_ = self->priv->handle;
	sane_cancel (_tmp13_);
	g_debug ("scanner.vala:1180: sane_cancel ()");
	scanner_do_complete_document (self);
	_scan_job_unref0 (job);
}


static void scanner_do_read (Scanner* self) {
	GList* _tmp0_;
	gconstpointer _tmp1_;
	ScanJob* _tmp2_;
	ScanJob* job;
	guchar* _tmp3_;
	gint _tmp3__length1;
	gint _tmp4_;
	gint n_to_read;
	SANE_Int n_read = {0};
	guchar* _tmp5_;
	gint _tmp5__length1;
	guchar* b;
	SANE_Handle _tmp6_;
	guchar* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	SANE_Int _tmp10_ = {0};
	SANE_Status _tmp11_ = 0;
	SANE_Status status;
	gint _tmp12_;
	SANE_Status _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	SANE_Int _tmp16_;
	SANE_Status _tmp17_;
	SANE_Status _tmp31_;
	gboolean full_read;
	gboolean _tmp36_ = FALSE;
	gint _tmp37_;
	gboolean _tmp40_;
	gint _tmp41_;
	SANE_Int _tmp42_;
	gint _tmp43_;
	SANE_Parameters _tmp44_;
	gint _tmp45_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->job_queue;
	_tmp1_ = _tmp0_->data;
	_tmp2_ = _scan_job_ref0 (SCAN_JOB ((ScanJob*) _tmp1_));
	job = _tmp2_;
	_tmp3_ = self->priv->buffer;
	_tmp3__length1 = self->priv->buffer_length1;
	_tmp4_ = self->priv->n_used;
	n_to_read = _tmp3__length1 - _tmp4_;
	_tmp5_ = self->priv->buffer;
	_tmp5__length1 = self->priv->buffer_length1;
	b = (guchar*) _tmp5_;
	_tmp6_ = self->priv->handle;
	_tmp7_ = b;
	_tmp8_ = self->priv->n_used;
	_tmp9_ = n_to_read;
	_tmp11_ = sane_read (_tmp6_, (guint8*) (_tmp7_ + _tmp8_), (SANE_Int) _tmp9_, &_tmp10_);
	n_read = _tmp10_;
	status = _tmp11_;
	_tmp12_ = n_to_read;
	_tmp13_ = status;
	_tmp14_ = sane_status_to_string (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = n_read;
	g_debug ("scanner.vala:1195: sane_read (%d) -> (%s, %d)", _tmp12_, _tmp15_, (gint) _tmp16_);
	_g_free0 (_tmp15_);
	_tmp17_ = status;
	if (_tmp17_ == SANE_STATUS_EOF) {
		gboolean _tmp18_ = FALSE;
		SANE_Parameters _tmp19_;
		gint _tmp20_;
		gboolean _tmp24_;
		gint _tmp29_;
		_tmp19_ = self->priv->parameters;
		_tmp20_ = _tmp19_.lines;
		if (_tmp20_ > 0) {
			gint _tmp21_;
			SANE_Parameters _tmp22_;
			gint _tmp23_;
			_tmp21_ = self->priv->line_count;
			_tmp22_ = self->priv->parameters;
			_tmp23_ = _tmp22_.lines;
			_tmp18_ = _tmp21_ != _tmp23_;
		} else {
			_tmp18_ = FALSE;
		}
		_tmp24_ = _tmp18_;
		if (_tmp24_) {
			SANE_Parameters _tmp25_;
			gint _tmp26_;
			SANE_Parameters _tmp27_;
			gint _tmp28_;
			_tmp25_ = self->priv->parameters;
			_tmp26_ = _tmp25_.lines;
			_tmp27_ = self->priv->parameters;
			_tmp28_ = _tmp27_.lines;
			g_warning ("scanner.vala:1201: Scan completed with %d lines, expected %d lines", _tmp26_, _tmp28_);
		}
		_tmp29_ = self->priv->n_used;
		if (_tmp29_ > 0) {
			gint _tmp30_;
			_tmp30_ = self->priv->n_used;
			g_warning ("scanner.vala:1203: Scan complete with %d bytes of unused data", _tmp30_);
		}
		scanner_do_complete_page (self);
		_scan_job_unref0 (job);
		return;
	}
	_tmp31_ = status;
	if (_tmp31_ != SANE_STATUS_GOOD) {
		SANE_Status _tmp32_;
		const gchar* _tmp33_ = NULL;
		SANE_Status _tmp34_;
		const gchar* _tmp35_ = NULL;
		_tmp32_ = status;
		_tmp33_ = sane_strstatus (_tmp32_);
		g_warning ("scanner.vala:1211: Unable to read frame from device: %s", _tmp33_);
		_tmp34_ = status;
		_tmp35_ = _ ("Error communicating with scanner");
		scanner_fail_scan (self, (gint) _tmp34_, _tmp35_);
		_scan_job_unref0 (job);
		return;
	}
	full_read = FALSE;
	_tmp37_ = self->priv->n_used;
	if (_tmp37_ == 0) {
		SANE_Int _tmp38_;
		guchar* _tmp39_;
		gint _tmp39__length1;
		_tmp38_ = n_read;
		_tmp39_ = self->priv->buffer;
		_tmp39__length1 = self->priv->buffer_length1;
		_tmp36_ = _tmp38_ == ((SANE_Int) _tmp39__length1);
	} else {
		_tmp36_ = FALSE;
	}
	_tmp40_ = _tmp36_;
	if (_tmp40_) {
		full_read = TRUE;
	}
	_tmp41_ = self->priv->n_used;
	_tmp42_ = n_read;
	self->priv->n_used = _tmp41_ + ((gint) _tmp42_);
	_tmp43_ = self->priv->n_used;
	_tmp44_ = self->priv->parameters;
	_tmp45_ = _tmp44_.bytes_per_line;
	if (_tmp43_ >= _tmp45_) {
		ScanLine* _tmp46_;
		ScanLine* line;
		SANE_Parameters _tmp47_;
		SANE_Frame _tmp48_;
		ScanLine* _tmp54_;
		SANE_Parameters _tmp55_;
		gint _tmp56_;
		ScanLine* _tmp57_;
		SANE_Parameters _tmp58_;
		gint _tmp59_;
		ScanLine* _tmp60_;
		guchar* _tmp61_;
		gint _tmp61__length1;
		ScanLine* _tmp62_;
		SANE_Parameters _tmp63_;
		gint _tmp64_;
		ScanLine* _tmp65_;
		gint _tmp66_;
		ScanLine* _tmp67_;
		gint _tmp68_;
		ScanLine* _tmp69_;
		gint _tmp70_;
		gint _tmp71_;
		ScanLine* _tmp72_;
		gint _tmp73_;
		guchar* _tmp74_;
		gint _tmp74__length1;
		gint buffer_size;
		gboolean _tmp75_;
		gint _tmp79_;
		guchar* _tmp80_ = NULL;
		gint _tmp81_;
		ScanLine* _tmp82_;
		gint _tmp83_;
		ScanLine* _tmp84_;
		gint _tmp85_;
		gint n_remaining;
		gboolean _tmp103_ = FALSE;
		gboolean _tmp104_ = FALSE;
		gboolean _tmp105_ = FALSE;
		SANE_Parameters _tmp106_;
		gint _tmp107_;
		gboolean _tmp110_;
		gboolean _tmp113_;
		gboolean _tmp116_;
		ScanLine* _tmp161_;
		NotifyGotLine* _tmp162_;
		NotifyGotLine* _tmp163_;
		_tmp46_ = scan_line_new ();
		line = _tmp46_;
		_tmp47_ = self->priv->parameters;
		_tmp48_ = _tmp47_.format;
		switch (_tmp48_) {
			case SANE_FRAME_GRAY:
			{
				ScanLine* _tmp49_;
				_tmp49_ = line;
				_tmp49_->channel = 0;
				break;
			}
			case SANE_FRAME_RGB:
			{
				ScanLine* _tmp50_;
				_tmp50_ = line;
				_tmp50_->channel = -1;
				break;
			}
			case SANE_FRAME_RED:
			{
				ScanLine* _tmp51_;
				_tmp51_ = line;
				_tmp51_->channel = 0;
				break;
			}
			case SANE_FRAME_GREEN:
			{
				ScanLine* _tmp52_;
				_tmp52_ = line;
				_tmp52_->channel = 1;
				break;
			}
			case SANE_FRAME_BLUE:
			{
				ScanLine* _tmp53_;
				_tmp53_ = line;
				_tmp53_->channel = 2;
				break;
			}
			default:
			break;
		}
		_tmp54_ = line;
		_tmp55_ = self->priv->parameters;
		_tmp56_ = _tmp55_.pixels_per_line;
		_tmp54_->width = _tmp56_;
		_tmp57_ = line;
		_tmp58_ = self->priv->parameters;
		_tmp59_ = _tmp58_.depth;
		_tmp57_->depth = _tmp59_;
		_tmp60_ = line;
		_tmp61_ = self->priv->buffer;
		_tmp61__length1 = self->priv->buffer_length1;
		self->priv->buffer = NULL;
		_tmp60_->data = (g_free (_tmp60_->data), NULL);
		_tmp60_->data = _tmp61_;
		_tmp60_->data_length1 = _tmp61__length1;
		_tmp62_ = line;
		_tmp63_ = self->priv->parameters;
		_tmp64_ = _tmp63_.bytes_per_line;
		_tmp62_->data_length = _tmp64_;
		_tmp65_ = line;
		_tmp66_ = self->priv->line_count;
		_tmp65_->number = _tmp66_;
		_tmp67_ = line;
		_tmp68_ = self->priv->n_used;
		_tmp69_ = line;
		_tmp70_ = _tmp69_->data_length;
		_tmp67_->n_lines = _tmp68_ / _tmp70_;
		_tmp71_ = self->priv->line_count;
		_tmp72_ = line;
		_tmp73_ = _tmp72_->n_lines;
		self->priv->line_count = _tmp71_ + _tmp73_;
		_tmp74_ = self->priv->buffer;
		_tmp74__length1 = self->priv->buffer_length1;
		buffer_size = _tmp74__length1;
		_tmp75_ = full_read;
		if (_tmp75_) {
			gint _tmp76_;
			SANE_Parameters _tmp77_;
			gint _tmp78_;
			_tmp76_ = buffer_size;
			_tmp77_ = self->priv->parameters;
			_tmp78_ = _tmp77_.bytes_per_line;
			buffer_size = _tmp76_ + _tmp78_;
		}
		_tmp79_ = buffer_size;
		_tmp80_ = g_new0 (guchar, _tmp79_);
		self->priv->buffer = (g_free (self->priv->buffer), NULL);
		self->priv->buffer = _tmp80_;
		self->priv->buffer_length1 = _tmp79_;
		self->priv->_buffer_size_ = self->priv->buffer_length1;
		_tmp81_ = self->priv->n_used;
		_tmp82_ = line;
		_tmp83_ = _tmp82_->n_lines;
		_tmp84_ = line;
		_tmp85_ = _tmp84_->data_length;
		n_remaining = _tmp81_ - (_tmp83_ * _tmp85_);
		self->priv->n_used = 0;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp86_;
				_tmp86_ = TRUE;
				while (TRUE) {
					gboolean _tmp87_;
					gint _tmp89_;
					gint _tmp90_;
					guchar* _tmp91_;
					gint _tmp91__length1;
					gint _tmp92_;
					ScanLine* _tmp93_;
					guchar* _tmp94_;
					gint _tmp94__length1;
					gint _tmp95_;
					ScanLine* _tmp96_;
					gint _tmp97_;
					ScanLine* _tmp98_;
					gint _tmp99_;
					guchar _tmp100_;
					guchar _tmp101_;
					gint _tmp102_;
					_tmp87_ = _tmp86_;
					if (!_tmp87_) {
						gint _tmp88_;
						_tmp88_ = i;
						i = _tmp88_ + 1;
					}
					_tmp86_ = FALSE;
					_tmp89_ = i;
					_tmp90_ = n_remaining;
					if (!(_tmp89_ < _tmp90_)) {
						break;
					}
					_tmp91_ = self->priv->buffer;
					_tmp91__length1 = self->priv->buffer_length1;
					_tmp92_ = i;
					_tmp93_ = line;
					_tmp94_ = _tmp93_->data;
					_tmp94__length1 = _tmp93_->data_length1;
					_tmp95_ = i;
					_tmp96_ = line;
					_tmp97_ = _tmp96_->n_lines;
					_tmp98_ = line;
					_tmp99_ = _tmp98_->data_length;
					_tmp100_ = _tmp94_[_tmp95_ + (_tmp97_ * _tmp99_)];
					_tmp91_[_tmp92_] = _tmp100_;
					_tmp101_ = _tmp91_[_tmp92_];
					_tmp102_ = self->priv->n_used;
					self->priv->n_used = _tmp102_ + 1;
				}
			}
		}
		_tmp106_ = self->priv->parameters;
		_tmp107_ = _tmp106_.depth;
		if (_tmp107_ == 8) {
			SANE_Parameters _tmp108_;
			SANE_Frame _tmp109_;
			_tmp108_ = self->priv->parameters;
			_tmp109_ = _tmp108_.format;
			_tmp105_ = _tmp109_ == SANE_FRAME_GRAY;
		} else {
			_tmp105_ = FALSE;
		}
		_tmp110_ = _tmp105_;
		if (_tmp110_) {
			ScanJob* _tmp111_;
			gint _tmp112_;
			_tmp111_ = job;
			_tmp112_ = _tmp111_->depth;
			_tmp104_ = _tmp112_ == 2;
		} else {
			_tmp104_ = FALSE;
		}
		_tmp113_ = _tmp104_;
		if (_tmp113_) {
			ScanJob* _tmp114_;
			ScanMode _tmp115_;
			_tmp114_ = job;
			_tmp115_ = _tmp114_->scan_mode;
			_tmp103_ = _tmp115_ == SCAN_MODE_GRAY;
		} else {
			_tmp103_ = FALSE;
		}
		_tmp116_ = _tmp103_;
		if (_tmp116_) {
			guchar block;
			gint write_offset;
			gint block_shift;
			ScanLine* _tmp158_;
			ScanLine* _tmp159_;
			gint _tmp160_;
			block = (guchar) 0;
			write_offset = 0;
			block_shift = 6;
			{
				gint i;
				i = 0;
				{
					gboolean _tmp117_;
					_tmp117_ = TRUE;
					while (TRUE) {
						gboolean _tmp118_;
						gint _tmp120_;
						ScanLine* _tmp121_;
						gint _tmp122_;
						gint _tmp123_;
						ScanLine* _tmp124_;
						gint _tmp125_;
						gint offset;
						gint _tmp151_;
						_tmp118_ = _tmp117_;
						if (!_tmp118_) {
							gint _tmp119_;
							_tmp119_ = i;
							i = _tmp119_ + 1;
						}
						_tmp117_ = FALSE;
						_tmp120_ = i;
						_tmp121_ = line;
						_tmp122_ = _tmp121_->n_lines;
						if (!(_tmp120_ < _tmp122_)) {
							break;
						}
						_tmp123_ = i;
						_tmp124_ = line;
						_tmp125_ = _tmp124_->data_length;
						offset = _tmp123_ * _tmp125_;
						{
							gint x;
							x = 0;
							{
								gboolean _tmp126_;
								_tmp126_ = TRUE;
								while (TRUE) {
									gboolean _tmp127_;
									gint _tmp129_;
									ScanLine* _tmp130_;
									gint _tmp131_;
									ScanLine* _tmp132_;
									guchar* _tmp133_;
									gint _tmp133__length1;
									gint _tmp134_;
									gint _tmp135_;
									guchar _tmp136_;
									guchar p;
									guchar sample = '\0';
									guchar _tmp137_;
									guchar _tmp140_;
									guchar _tmp141_;
									gint _tmp142_;
									gint _tmp143_;
									_tmp127_ = _tmp126_;
									if (!_tmp127_) {
										gint _tmp128_;
										_tmp128_ = x;
										x = _tmp128_ + 1;
									}
									_tmp126_ = FALSE;
									_tmp129_ = x;
									_tmp130_ = line;
									_tmp131_ = _tmp130_->width;
									if (!(_tmp129_ < _tmp131_)) {
										break;
									}
									_tmp132_ = line;
									_tmp133_ = _tmp132_->data;
									_tmp133__length1 = _tmp132_->data_length1;
									_tmp134_ = offset;
									_tmp135_ = x;
									_tmp136_ = _tmp133_[_tmp134_ + _tmp135_];
									p = _tmp136_;
									_tmp137_ = p;
									if (((gint) _tmp137_) >= 192) {
										sample = (guchar) 3;
									} else {
										guchar _tmp138_;
										_tmp138_ = p;
										if (((gint) _tmp138_) >= 128) {
											sample = (guchar) 2;
										} else {
											guchar _tmp139_;
											_tmp139_ = p;
											if (((gint) _tmp139_) >= 64) {
												sample = (guchar) 1;
											} else {
												sample = (guchar) 0;
											}
										}
									}
									_tmp140_ = block;
									_tmp141_ = sample;
									_tmp142_ = block_shift;
									block = _tmp140_ | (_tmp141_ << _tmp142_);
									_tmp143_ = block_shift;
									if (_tmp143_ == 0) {
										ScanLine* _tmp144_;
										guchar* _tmp145_;
										gint _tmp145__length1;
										gint _tmp146_;
										guchar _tmp147_;
										guchar _tmp148_;
										gint _tmp149_;
										_tmp144_ = line;
										_tmp145_ = _tmp144_->data;
										_tmp145__length1 = _tmp144_->data_length1;
										_tmp146_ = write_offset;
										_tmp147_ = block;
										_tmp145_[_tmp146_] = _tmp147_;
										_tmp148_ = _tmp145_[_tmp146_];
										_tmp149_ = write_offset;
										write_offset = _tmp149_ + 1;
										block = (guchar) 0;
										block_shift = 6;
									} else {
										gint _tmp150_;
										_tmp150_ = block_shift;
										block_shift = _tmp150_ - 2;
									}
								}
							}
						}
						_tmp151_ = block_shift;
						if (_tmp151_ != 6) {
							ScanLine* _tmp152_;
							guchar* _tmp153_;
							gint _tmp153__length1;
							gint _tmp154_;
							guchar _tmp155_;
							guchar _tmp156_;
							gint _tmp157_;
							_tmp152_ = line;
							_tmp153_ = _tmp152_->data;
							_tmp153__length1 = _tmp152_->data_length1;
							_tmp154_ = write_offset;
							_tmp155_ = block;
							_tmp153_[_tmp154_] = _tmp155_;
							_tmp156_ = _tmp153_[_tmp154_];
							_tmp157_ = write_offset;
							write_offset = _tmp157_ + 1;
							block = (guchar) 0;
							block_shift = 6;
						}
					}
				}
			}
			_tmp158_ = line;
			_tmp159_ = line;
			_tmp160_ = _tmp159_->width;
			_tmp158_->data_length = ((_tmp160_ * 2) + 7) / 8;
		}
		_tmp161_ = line;
		_tmp162_ = notify_got_line_new (_tmp161_);
		_tmp163_ = _tmp162_;
		scanner_notify (self, (Notify*) _tmp163_);
		_notify_unref0 (_tmp163_);
		_scan_line_unref0 (line);
	}
	_scan_job_unref0 (job);
}


static void _scanner_authorization_cb_sane_authcallback (const gchar* resource, gchar* username, gchar* password) {
	scanner_authorization_cb (resource, username, -1, password, -1);
}


static void* scanner_scan_thread (Scanner* self) {
	void* result = NULL;
	SANE_Int version_code = {0};
	SANE_Int _tmp0_ = {0};
	SANE_Status _tmp1_ = 0;
	SANE_Status status;
	SANE_Status _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	SANE_Status _tmp5_;
	SANE_Int _tmp8_;
	gint _tmp9_ = 0;
	SANE_Int _tmp10_;
	gint _tmp11_ = 0;
	SANE_Int _tmp12_;
	gint _tmp13_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	self->priv->state = SCAN_STATE_IDLE;
	_tmp1_ = sane_init (&_tmp0_, _scanner_authorization_cb_sane_authcallback);
	version_code = _tmp0_;
	status = _tmp1_;
	_tmp2_ = status;
	_tmp3_ = sane_status_to_string (_tmp2_);
	_tmp4_ = _tmp3_;
	g_debug ("scanner.vala:1328: sane_init () -> %s", _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = status;
	if (_tmp5_ != SANE_STATUS_GOOD) {
		SANE_Status _tmp6_;
		const gchar* _tmp7_ = NULL;
		_tmp6_ = status;
		_tmp7_ = sane_strstatus (_tmp6_);
		g_warning ("scanner.vala:1331: Unable to initialize SANE backend: %s", _tmp7_);
		result = NULL;
		return result;
	}
	_tmp8_ = version_code;
	_tmp9_ = SANE_VERSION_MAJOR (_tmp8_);
	_tmp10_ = version_code;
	_tmp11_ = SANE_VERSION_MINOR (_tmp10_);
	_tmp12_ = version_code;
	_tmp13_ = SANE_VERSION_BUILD (_tmp12_);
	g_debug ("scanner.vala:1334: SANE version %d.%d.%d", _tmp9_, _tmp11_, _tmp13_);
	scanner_redetect (self);
	while (TRUE) {
		gboolean _tmp14_ = FALSE;
		ScanState _tmp15_;
		_tmp14_ = scanner_handle_requests (self);
		if (!_tmp14_) {
			break;
		}
		_tmp15_ = self->priv->state;
		switch (_tmp15_) {
			case SCAN_STATE_IDLE:
			{
				GList* _tmp16_;
				_tmp16_ = self->priv->job_queue;
				if (_tmp16_ != NULL) {
					scanner_set_scanning (self, TRUE);
					self->priv->state = SCAN_STATE_OPEN;
				}
				break;
			}
			case SCAN_STATE_REDETECT:
			{
				scanner_do_redetect (self);
				break;
			}
			case SCAN_STATE_OPEN:
			{
				scanner_do_open (self);
				break;
			}
			case SCAN_STATE_GET_OPTION:
			{
				scanner_do_get_option (self);
				break;
			}
			case SCAN_STATE_START:
			{
				scanner_do_start (self);
				break;
			}
			case SCAN_STATE_GET_PARAMETERS:
			{
				scanner_do_get_parameters (self);
				break;
			}
			case SCAN_STATE_READ:
			{
				scanner_do_read (self);
				break;
			}
			default:
			break;
		}
	}
	result = NULL;
	return result;
}


static gpointer _scanner_scan_thread_gthread_func (gpointer self) {
	gpointer result;
	result = scanner_scan_thread (self);
	return result;
}


void scanner_start (Scanner* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GThread* _tmp0_ = NULL;
		GThread* _tmp1_;
		_tmp0_ = g_thread_create (_scanner_scan_thread_gthread_func, self, TRUE, &_inner_error_);
		_tmp1_ = _tmp0_;
		if (_inner_error_ != NULL) {
			goto __catch10_g_error;
		}
		self->priv->thread = _tmp1_;
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_critical ("scanner.vala:1385: Unable to create thread: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally10:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void scanner_redetect (Scanner* self) {
	gboolean _tmp0_;
	GAsyncQueue* _tmp1_;
	RequestRedetect* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->need_redetect;
	if (_tmp0_) {
		return;
	}
	self->priv->need_redetect = TRUE;
	g_debug ("scanner.vala:1395: Requesting redetection of scan devices");
	_tmp1_ = self->priv->request_queue;
	_tmp2_ = request_redetect_new ();
	g_async_queue_push (_tmp1_, (Request*) _tmp2_);
}


gboolean scanner_is_scanning (Scanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->scanning;
	result = _tmp0_;
	return result;
}


static gchar* scanner_get_scan_mode_string (Scanner* self, ScanMode mode) {
	gchar* result = NULL;
	ScanMode _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = mode;
	switch (_tmp0_) {
		case SCAN_MODE_DEFAULT:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("ScanMode.DEFAULT");
			result = _tmp1_;
			return result;
		}
		case SCAN_MODE_COLOR:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("ScanMode.COLOR");
			result = _tmp2_;
			return result;
		}
		case SCAN_MODE_GRAY:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("ScanMode.GRAY");
			result = _tmp3_;
			return result;
		}
		case SCAN_MODE_LINEART:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("ScanMode.LINEART");
			result = _tmp4_;
			return result;
		}
		default:
		{
			ScanMode _tmp5_;
			gchar* _tmp6_ = NULL;
			_tmp5_ = mode;
			_tmp6_ = g_strdup_printf ("%d", (gint) _tmp5_);
			result = _tmp6_;
			return result;
		}
	}
}


static gchar* scanner_get_scan_type_string (Scanner* self, ScanType type) {
	gchar* result = NULL;
	ScanType _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = type;
	switch (_tmp0_) {
		case SCAN_TYPE_SINGLE:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("ScanType.SINGLE");
			result = _tmp1_;
			return result;
		}
		case SCAN_TYPE_ADF_FRONT:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("ScanType.ADF_FRONT");
			result = _tmp2_;
			return result;
		}
		case SCAN_TYPE_ADF_BACK:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("ScanType.ADF_BACK");
			result = _tmp3_;
			return result;
		}
		case SCAN_TYPE_ADF_BOTH:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("ScanType.ADF_BOTH");
			result = _tmp4_;
			return result;
		}
		default:
		{
			ScanType _tmp5_;
			gchar* _tmp6_ = NULL;
			_tmp5_ = type;
			_tmp6_ = g_strdup_printf ("%d", (gint) _tmp5_);
			result = _tmp6_;
			return result;
		}
	}
}


void scanner_scan (Scanner* self, const gchar* device, ScanOptions* options) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp3_;
	ScanOptions* _tmp4_;
	gint _tmp5_;
	ScanOptions* _tmp6_;
	ScanMode _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	ScanOptions* _tmp10_;
	gint _tmp11_;
	ScanOptions* _tmp12_;
	ScanType _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	ScanOptions* _tmp16_;
	gint _tmp17_;
	ScanOptions* _tmp18_;
	gint _tmp19_;
	RequestStartScan* _tmp20_;
	RequestStartScan* request;
	ScanJob* _tmp21_;
	ScanJob* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	ScanJob* _tmp25_;
	ScanOptions* _tmp26_;
	gint _tmp27_;
	ScanJob* _tmp28_;
	ScanOptions* _tmp29_;
	ScanMode _tmp30_;
	ScanJob* _tmp31_;
	ScanOptions* _tmp32_;
	gint _tmp33_;
	ScanJob* _tmp34_;
	ScanOptions* _tmp35_;
	ScanType _tmp36_;
	ScanJob* _tmp37_;
	ScanOptions* _tmp38_;
	gint _tmp39_;
	ScanJob* _tmp40_;
	ScanOptions* _tmp41_;
	gint _tmp42_;
	GAsyncQueue* _tmp43_;
	Request* _tmp44_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (options != NULL);
	_tmp1_ = device;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = device;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = "(null)";
	}
	_tmp3_ = _tmp0_;
	_tmp4_ = options;
	_tmp5_ = _tmp4_->dpi;
	_tmp6_ = options;
	_tmp7_ = _tmp6_->scan_mode;
	_tmp8_ = scanner_get_scan_mode_string (self, _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = options;
	_tmp11_ = _tmp10_->depth;
	_tmp12_ = options;
	_tmp13_ = _tmp12_->type;
	_tmp14_ = scanner_get_scan_type_string (self, _tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = options;
	_tmp17_ = _tmp16_->paper_width;
	_tmp18_ = options;
	_tmp19_ = _tmp18_->paper_height;
	g_debug ("scanner.vala:1441: Scanner.scan (\"%s\", dpi=%d, scan_mode=%s, depth=%" \
"d, type=%s, paper_width=%d, paper_height=%d)", _tmp3_, _tmp5_, _tmp9_, _tmp11_, _tmp15_, _tmp17_, _tmp19_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp9_);
	_tmp20_ = request_start_scan_new ();
	request = _tmp20_;
	_tmp21_ = scan_job_new ();
	_scan_job_unref0 (request->job);
	request->job = _tmp21_;
	_tmp22_ = request->job;
	_tmp23_ = device;
	_tmp24_ = g_strdup (_tmp23_);
	_g_free0 (_tmp22_->device);
	_tmp22_->device = _tmp24_;
	_tmp25_ = request->job;
	_tmp26_ = options;
	_tmp27_ = _tmp26_->dpi;
	_tmp25_->dpi = (gdouble) _tmp27_;
	_tmp28_ = request->job;
	_tmp29_ = options;
	_tmp30_ = _tmp29_->scan_mode;
	_tmp28_->scan_mode = _tmp30_;
	_tmp31_ = request->job;
	_tmp32_ = options;
	_tmp33_ = _tmp32_->depth;
	_tmp31_->depth = _tmp33_;
	_tmp34_ = request->job;
	_tmp35_ = options;
	_tmp36_ = _tmp35_->type;
	_tmp34_->type = _tmp36_;
	_tmp37_ = request->job;
	_tmp38_ = options;
	_tmp39_ = _tmp38_->paper_width;
	_tmp37_->page_width = _tmp39_;
	_tmp40_ = request->job;
	_tmp41_ = options;
	_tmp42_ = _tmp41_->paper_height;
	_tmp40_->page_height = _tmp42_;
	_tmp43_ = self->priv->request_queue;
	_tmp44_ = _request_ref0 ((Request*) request);
	g_async_queue_push (_tmp43_, _tmp44_);
	_request_unref0 (request);
}


void scanner_cancel (Scanner* self) {
	GAsyncQueue* _tmp0_;
	RequestCancel* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->request_queue;
	_tmp1_ = request_cancel_new ();
	g_async_queue_push (_tmp0_, (Request*) _tmp1_);
}


void scanner_free (Scanner* self) {
	GAsyncQueue* _tmp0_;
	RequestQuit* _tmp1_;
	GThread* _tmp2_;
	g_return_if_fail (self != NULL);
	g_debug ("scanner.vala:1463: Stopping scan thread");
	_tmp0_ = self->priv->request_queue;
	_tmp1_ = request_quit_new ();
	g_async_queue_push (_tmp0_, (Request*) _tmp1_);
	_tmp2_ = self->priv->thread;
	if (_tmp2_ != NULL) {
		GThread* _tmp3_;
		_tmp3_ = self->priv->thread;
		g_thread_join (_tmp3_);
	}
	sane_exit ();
	g_debug ("scanner.vala:1471: sane_exit ()");
}


static void g_cclosure_user_marshal_VOID__SCAN_PAGE_INFO (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__SCAN_PAGE_INFO) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__SCAN_PAGE_INFO callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__SCAN_PAGE_INFO) (marshal_data ? marshal_data : cc->callback);
	callback (data1, value_get_scan_page_info (param_values + 1), data2);
}


static void g_cclosure_user_marshal_VOID__SCAN_LINE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__SCAN_LINE) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__SCAN_LINE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__SCAN_LINE) (marshal_data ? marshal_data : cc->callback);
	callback (data1, value_get_scan_line (param_values + 1), data2);
}


static void g_cclosure_user_marshal_VOID__INT_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT_STRING) (gpointer data1, gint arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_string (param_values + 2), data2);
}


static void value_scanner_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_scanner_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		scanner_unref (value->data[0].v_pointer);
	}
}


static void value_scanner_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = scanner_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_scanner_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_scanner_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Scanner* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = scanner_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_scanner_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Scanner** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = scanner_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_scanner (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecScanner* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SCANNER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_scanner (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCANNER), NULL);
	return value->data[0].v_pointer;
}


void value_set_scanner (GValue* value, gpointer v_object) {
	Scanner* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCANNER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCANNER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		scanner_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		scanner_unref (old);
	}
}


void value_take_scanner (GValue* value, gpointer v_object) {
	Scanner* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCANNER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCANNER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		scanner_unref (old);
	}
}


static void scanner_class_init (ScannerClass * klass) {
	scanner_parent_class = g_type_class_peek_parent (klass);
	SCANNER_CLASS (klass)->finalize = scanner_finalize;
	g_type_class_add_private (klass, sizeof (ScannerPrivate));
	g_signal_new ("update_devices", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__POINTER, G_TYPE_NONE, 1, G_TYPE_POINTER);
	g_signal_new ("request_authorization", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("expect_page", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("got_page_info", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__SCAN_PAGE_INFO, G_TYPE_NONE, 1, TYPE_SCAN_PAGE_INFO);
	g_signal_new ("got_line", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__SCAN_LINE, G_TYPE_NONE, 1, TYPE_SCAN_LINE);
	g_signal_new ("scan_failed", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_STRING, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_STRING);
	g_signal_new ("page_done", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("document_done", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("scanning_changed", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void scanner_instance_init (Scanner * self) {
	self->priv = SCANNER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void scanner_finalize (Scanner* obj) {
	Scanner * self;
	self = SCANNER (obj);
	_g_async_queue_unref0 (self->priv->request_queue);
	_g_async_queue_unref0 (self->priv->notify_queue);
	_g_async_queue_unref0 (self->priv->authorize_queue);
	_g_free0 (self->priv->default_device);
	__g_list_free__scan_job_unref0_0 (self->priv->job_queue);
	_g_free0 (self->priv->current_device);
	self->priv->buffer = (g_free (self->priv->buffer), NULL);
}


GType scanner_get_type (void) {
	static volatile gsize scanner_type_id__volatile = 0;
	if (g_once_init_enter (&scanner_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_scanner_init, value_scanner_free_value, value_scanner_copy_value, value_scanner_peek_pointer, "p", value_scanner_collect_value, "p", value_scanner_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Scanner), 0, (GInstanceInitFunc) scanner_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType scanner_type_id;
		scanner_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Scanner", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&scanner_type_id__volatile, scanner_type_id);
	}
	return scanner_type_id__volatile;
}


gpointer scanner_ref (gpointer instance) {
	Scanner* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void scanner_unref (gpointer instance) {
	Scanner* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SCANNER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



