/* 
   Unix SMB/CIFS implementation.
   NT ioctl code constants
   Copyright (C) Andrew Tridgell              2002
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/*
  I'm guessing we will need to support a bunch of these eventually. For now
  we only need the sparse flag
*/

#ifndef _NTIOCTL_H
#define _NTIOCTL_H

/* IOCTL information */
/* List of ioctl function codes that look to be of interest to remote clients like this. */
/* Need to do some experimentation to make sure they all work remotely.                  */
/* Some of the following such as the encryption/compression ones would be                */
/* invoked from tools via a specialized hook into the VFS rather than via the            */
/* standard vfs entry points */
#define FSCTL_LOCK_VOLUME            0x00090018
#define FSCTL_UNLOCK_VOLUME          0x0009001C
#define FSCTL_GET_COMPRESSION        0x0009003C
#define FSCTL_SET_COMPRESSION        0x0009C040
#define FSCTL_REQUEST_FILTER_OPLOCK  0x0009008C
#define FSCTL_SET_ZERO_DATA          0x000900C8
#define FSCTL_SET_ENCRYPTION         0x000900D7
#define FSCTL_ENCRYPTION_FSCTL_IO    0x000900DB
#define FSCTL_WRITE_RAW_ENCRYPTED    0x000900DF
#define FSCTL_READ_RAW_ENCRYPTED     0x000900E3
#define FSCTL_SIS_COPYFILE           0x00090100
#define FSCTL_SIS_LINK_FILES         0x0009C104

/* filesystem control codes */
#define FSCTL_METHOD_BUFFERED	0x00000000
#define FSCTL_METHOD_IN_DIRECT	0x00000001
#define FSCTL_METHOD_OUT_DIRECT	0x00000002
#define FSCTL_METHOD_NEITHER	0x00000003

#define FSCTL_ACCESS_ANY	0x00000000
#define FSCTL_ACCESS_READ	0x00004000
#define FSCTL_ACCESS_WRITE	0x00008000

#define FSCTL_DFS			0x00060000
#define FSCTL_DFS_GET_REFERRALS		(FSCTL_DFS | FSCTL_ACCESS_ANY | 0x0194 | FSCTL_METHOD_BUFFERED)
#define FSCTL_DFS_GET_REFERRALS_EX	(FSCTL_DFS | FSCTL_ACCESS_ANY | 0x01B0 | FSCTL_METHOD_BUFFERED)

#define FSCTL_FILESYSTEM		0x00090000
#define FSCTL_REQUEST_OPLOCK_LEVEL_1    (FSCTL_FILESYSTEM | FSCTL_ACCESS_ANY | 0x0000 | FSCTL_METHOD_BUFFERED)
#define FSCTL_REQUEST_OPLOCK_LEVEL_2    (FSCTL_FILESYSTEM | FSCTL_ACCESS_ANY | 0x0004 | FSCTL_METHOD_BUFFERED)
#define FSCTL_REQUEST_BATCH_OPLOCK      (FSCTL_FILESYSTEM | FSCTL_ACCESS_ANY | 0x0008 | FSCTL_METHOD_BUFFERED)
#define FSCTL_OPLOCK_BREAK_ACKNOWLEDGE  (FSCTL_FILESYSTEM | FSCTL_ACCESS_ANY | 0x000C | FSCTL_METHOD_BUFFERED)
#define FSCTL_OPBATCH_ACK_CLOSE_PENDING (FSCTL_FILESYSTEM | FSCTL_ACCESS_ANY | 0x0010 | FSCTL_METHOD_BUFFERED)
#define FSCTL_OPLOCK_BREAK_NOTIFY       (FSCTL_FILESYSTEM | FSCTL_ACCESS_ANY | 0x0014 | FSCTL_METHOD_BUFFERED)
#define FSCTL_FILESYS_GET_STATISTICS	(FSCTL_FILESYSTEM | FSCTL_ACCESS_ANY | 0x0060 | FSCTL_METHOD_BUFFERED)
#define FSCTL_GET_NTFS_VOLUME_DATA	(FSCTL_FILESYSTEM | FSCTL_ACCESS_ANY | 0x0064 | FSCTL_METHOD_BUFFERED)
#define FSCTL_IS_VOLUME_DIRTY		(FSCTL_FILESYSTEM | FSCTL_ACCESS_ANY | 0x0078 | FSCTL_METHOD_BUFFERED)
#define FSCTL_FIND_FILES_BY_SID		(FSCTL_FILESYSTEM | FSCTL_ACCESS_ANY | 0x008C | FSCTL_METHOD_NEITHER)
#define FSCTL_SET_OBJECT_ID		(FSCTL_FILESYSTEM | FSCTL_ACCESS_ANY | 0x0098 | FSCTL_METHOD_BUFFERED)
#define FSCTL_GET_OBJECT_ID		(FSCTL_FILESYSTEM | FSCTL_ACCESS_ANY | 0x009C | FSCTL_METHOD_BUFFERED)
#define FSCTL_DELETE_OBJECT_ID		(FSCTL_FILESYSTEM | FSCTL_ACCESS_ANY | 0x00A0 | FSCTL_METHOD_BUFFERED)
#define FSCTL_SET_REPARSE_POINT		(FSCTL_FILESYSTEM | FSCTL_ACCESS_ANY | 0x00A4 | FSCTL_METHOD_BUFFERED)
#define FSCTL_GET_REPARSE_POINT		(FSCTL_FILESYSTEM | FSCTL_ACCESS_ANY | 0x00A8 | FSCTL_METHOD_BUFFERED)
#define FSCTL_DELETE_REPARSE_POINT	(FSCTL_FILESYSTEM | FSCTL_ACCESS_ANY | 0x00AC | FSCTL_METHOD_BUFFERED)
#define FSCTL_CREATE_OR_GET_OBJECT_ID	(FSCTL_FILESYSTEM | FSCTL_ACCESS_ANY | 0x00C0 | FSCTL_METHOD_BUFFERED)
#define FSCTL_SET_SPARSE		(FSCTL_FILESYSTEM | FSCTL_ACCESS_ANY | 0x00C4 | FSCTL_METHOD_BUFFERED)
#define FSCTL_QUERY_ALLOCATED_RANGES	(FSCTL_FILESYSTEM | FSCTL_ACCESS_READ | 0x00CC | FSCTL_METHOD_NEITHER)
#define FSCTL_FILE_LEVEL_TRIM		(FSCTL_FILESYSTEM | FSCTL_ACCESS_WRITE | 0x0208 | FSCTL_METHOD_BUFFERED)
#define FSCTL_OFFLOAD_READ		(FSCTL_FILESYSTEM | FSCTL_ACCESS_READ | 0x0264 | FSCTL_METHOD_BUFFERED)
#define FSCTL_OFFLOAD_WRITE		(FSCTL_FILESYSTEM | FSCTL_ACCESS_WRITE | 0x0268 | FSCTL_METHOD_BUFFERED)

#define FSCTL_NAMED_PIPE		0x00110000
#define FSCTL_PIPE_PEEK			(FSCTL_NAMED_PIPE | FSCTL_ACCESS_READ | 0x000C | FSCTL_METHOD_BUFFERED)
#define FSCTL_NAMED_PIPE_READ_WRITE	(FSCTL_NAMED_PIPE | FSCTL_ACCESS_READ \
							  | FSCTL_ACCESS_WRITE | 0x0014 | FSCTL_METHOD_NEITHER)
#define FSCTL_PIPE_TRANSCEIVE		FSCTL_NAMED_PIPE_READ_WRITE	/* SMB2 function name */
#define FSCTL_PIPE_WAIT			(FSCTL_NAMED_PIPE | FSCTL_ACCESS_ANY | 0x0018 | FSCTL_METHOD_BUFFERED)

#define FSCTL_NETWORK_FILESYSTEM	0x00140000
#define FSCTL_GET_SHADOW_COPY_DATA	(FSCTL_NETWORK_FILESYSTEM | FSCTL_ACCESS_READ | 0x0064 | FSCTL_METHOD_BUFFERED)
#define FSCTL_SRV_ENUM_SNAPS		FSCTL_GET_SHADOW_COPY_DATA	/* SMB2 function name */
#define FSCTL_SRV_REQUEST_RESUME_KEY	(FSCTL_NETWORK_FILESYSTEM | FSCTL_ACCESS_ANY | 0x0078 | FSCTL_METHOD_BUFFERED)
#define FSCTL_SRV_COPYCHUNK		(FSCTL_NETWORK_FILESYSTEM | FSCTL_ACCESS_READ | 0x00F0 | FSCTL_METHOD_OUT_DIRECT)
#define FSCTL_SRV_COPYCHUNK_WRITE	(FSCTL_NETWORK_FILESYSTEM | FSCTL_ACCESS_WRITE | 0x00F0 | FSCTL_METHOD_OUT_DIRECT)
#define FSCTL_SRV_READ_HASH		(FSCTL_NETWORK_FILESYSTEM | FSCTL_ACCESS_READ| 0x01B8 | FSCTL_METHOD_NEITHER)
#define FSCTL_LMR_REQ_RESILIENCY	(FSCTL_NETWORK_FILESYSTEM | FSCTL_ACCESS_ANY | 0x01D4 | FSCTL_METHOD_BUFFERED)
#define FSCTL_LMR_SET_LINK_TRACKING_INFORMATION \
	(FSCTL_NETWORK_FILESYSTEM | FSCTL_ACCESS_ANY | 0x00EC | FSCTL_METHOD_BUFFERED)
#define FSCTL_QUERY_NETWORK_INTERFACE_INFO \
	(FSCTL_NETWORK_FILESYSTEM | FSCTL_ACCESS_ANY | 0x01FC | FSCTL_METHOD_BUFFERED)

/*
 * FSCTL_VALIDATE_NEGOTIATE_INFO_224 was used used in
 * Windows 8 server beta with SMB 2.24
 */
#define FSCTL_VALIDATE_NEGOTIATE_INFO_224 \
	(FSCTL_NETWORK_FILESYSTEM | FSCTL_ACCESS_ANY | 0x0200 | FSCTL_METHOD_BUFFERED)
#define FSCTL_VALIDATE_NEGOTIATE_INFO	(FSCTL_NETWORK_FILESYSTEM | FSCTL_ACCESS_ANY | 0x0204 | FSCTL_METHOD_BUFFERED)

#if 0
#define FSCTL_SECURITY_ID_CHECK
#define FSCTL_DISMOUNT_VOLUME
#define FSCTL_GET_NTFS_FILE_RECORD
#define FSCTL_ALLOW_EXTENDED_DASD_IO
#define FSCTL_RECALL_FILE

#endif

#define IO_REPARSE_TAG_MOUNT_POINT   0xA0000003
#define IO_REPARSE_TAG_HSM           0xC0000004
#define IO_REPARSE_TAG_SIS           0x80000007


/* For FSCTL_GET_SHADOW_COPY_DATA ...*/
typedef char SHADOW_COPY_LABEL[25];

struct shadow_copy_data {
	/* Total number of shadow volumes currently mounted */
	uint32 num_volumes;
	/* Concatenated list of labels */
	SHADOW_COPY_LABEL *labels;
};


#endif /* _NTIOCTL_H */
