/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sbxfac.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: obo $ $Date: 2007/03/15 15:31:55 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#ifndef __SBX_SBX_FACTORY_HXX
#define __SBX_SBX_FACTORY_HXX

#ifndef _SBXDEF_HXX
#include "sbxdef.hxx"
#endif

class String;
class UniString;

namespace binfilter {

class SbxBase;
class SbxObject;

class SbxFactory
{
	BOOL bHandleLast;	// TRUE: Factory soll zuletzt gefragt werden, da teuer
public:
	SbxFactory( BOOL bLast=FALSE )	{ bHandleLast = bLast; }
	BOOL IsHandleLast( void )		{ return bHandleLast; }
	virtual SbxBase* Create( UINT16 nSbxId, UINT32 = SBXCR_SBX );
	virtual SbxObject* CreateObject( const String& );
};

}

#endif
