/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: formlayerexport.cxx,v $
 *
 *  $Revision: 1.18 $
 *
 *  last change: $Author: hr $ $Date: 2007/06/27 15:15:36 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_xmloff.hxx"

#include <stdio.h>

#ifndef _XMLOFF_FORMLAYEREXPORT_HXX_
#include <xmloff/formlayerexport.hxx>
#endif
#ifndef _XMLOFF_FORMS_STRINGS_HXX_
#include "strings.hxx"
#endif
#ifndef _XMLOFF_ELEMENTEXPORT_HXX_
#include "elementexport.hxx"
#endif
#ifndef _XMLOFF_XMLNMSPE_HXX
#include "xmlnmspe.hxx"
#endif
#ifndef _XMLOFF_XMLEXP_HXX
#include <xmloff/xmlexp.hxx>
#endif
#ifndef _XMLOFF_FORMS_LAYEREXPORT_HXX_
#include "layerexport.hxx"
#endif
#ifndef _XMLOFF_FORMS_PROPERTYEXPORT_HXX_
#include "propertyexport.hxx"
#endif
#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif
#ifndef _COMPHELPER_EXTRACT_HXX_
#include <comphelper/extract.hxx>
#endif
#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif
#ifndef _COMPHELPER_STLTYPES_HXX_
#include <comphelper/stl_types.hxx>
#endif
#ifndef _XMLOFF_FORMS_OFFICEFORMS_HXX_
#include "officeforms.hxx"
#endif


//.........................................................................
namespace xmloff
{
//.........................................................................

	using namespace ::com::sun::star::uno;
	using namespace ::com::sun::star::lang;
	using namespace ::com::sun::star::awt;
	using namespace ::com::sun::star::beans;
	using namespace ::com::sun::star::container;
	using namespace ::com::sun::star::drawing;
	using namespace ::com::sun::star::frame;

	//=====================================================================
	//= OFormLayerXMLExport
	//=====================================================================

	//---------------------------------------------------------------------
	OFormLayerXMLExport::OFormLayerXMLExport(SvXMLExport& _rContext)
		:m_rContext(_rContext)
		,m_pImpl(new OFormLayerXMLExport_Impl(_rContext))
	{
	}

	//---------------------------------------------------------------------
	OFormLayerXMLExport::~OFormLayerXMLExport()
	{
		delete m_pImpl;
		m_pImpl = NULL;
	}

	//---------------------------------------------------------------------
	sal_Bool OFormLayerXMLExport::seekPage(const Reference< XDrawPage >& _rxDrawPage)
	{
		return m_pImpl->seekPage(_rxDrawPage);
	}

	//---------------------------------------------------------------------
	::rtl::OUString OFormLayerXMLExport::getControlId(const Reference< XPropertySet >& _rxControl)
	{
		return m_pImpl->getControlId(_rxControl);
	}

	//---------------------------------------------------------------------
	::rtl::OUString OFormLayerXMLExport::getControlNumberStyle( const Reference< XPropertySet >& _rxControl )
	{
		return m_pImpl->getControlNumberStyle(_rxControl);
	}

	//---------------------------------------------------------------------
	::vos::ORef< SvXMLExportPropertyMapper > OFormLayerXMLExport::getStylePropertyMapper()
	{
		return m_pImpl->getStylePropertyMapper();
	}

	//---------------------------------------------------------------------
	void OFormLayerXMLExport::initialize()
	{
		m_pImpl->clear();
	}

	//---------------------------------------------------------------------
	void OFormLayerXMLExport::examineForms(const Reference< XDrawPage >& _rxDrawPage)
	{
		try
		{
			m_pImpl->examineForms(_rxDrawPage);
		}
		catch(Exception&)
		{
			OSL_ENSURE(sal_False, "OFormLayerXMLExport::examine: could not examine the draw page!");
		}
	}

	//---------------------------------------------------------------------
	void OFormLayerXMLExport::exportForms(const Reference< XDrawPage >& _rxDrawPage)
	{
		m_pImpl->exportForms(_rxDrawPage);
	}

	//---------------------------------------------------------------------
	void OFormLayerXMLExport::exportXForms() const
    {
		m_pImpl->exportXForms();
    }

	//---------------------------------------------------------------------
	bool OFormLayerXMLExport::pageContainsForms( const Reference< XDrawPage >& _rxDrawPage ) const
    {
		return m_pImpl->pageContainsForms( _rxDrawPage );
    }

	//---------------------------------------------------------------------
	bool OFormLayerXMLExport::documentContainsXForms() const
    {
		return m_pImpl->documentContainsXForms();
    }

	//---------------------------------------------------------------------
	void OFormLayerXMLExport::exportControlNumberStyles()
	{
		m_pImpl->exportControlNumberStyles();
	}

	//---------------------------------------------------------------------
	void OFormLayerXMLExport::exportAutoControlNumberStyles()
	{
		m_pImpl->exportAutoControlNumberStyles();
	}

	//---------------------------------------------------------------------
	void OFormLayerXMLExport::exportAutoStyles()
	{
		m_pImpl->exportAutoStyles();
	}

	//---------------------------------------------------------------------
	void OFormLayerXMLExport::excludeFromExport( const Reference< XControlModel > _rxControl )
	{
		m_pImpl->excludeFromExport( _rxControl );
	}

	//=========================================================================
	//= OOfficeFormsExport
	//=========================================================================
	//-------------------------------------------------------------------------
	OOfficeFormsExport::OOfficeFormsExport( SvXMLExport& _rExp )
		:m_pImpl(NULL)
	{
		m_pImpl = new OFormsRootExport(_rExp);
	}

	//-------------------------------------------------------------------------
	OOfficeFormsExport::~OOfficeFormsExport()
	{
		delete m_pImpl;
	}

//.........................................................................
}	// namespace xmloff
//.........................................................................

