/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: TokenMap.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: fridrich_strba $ $Date: 2007/05/20 20:53:06 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef INCLUDED_TOKEN_MAP_HXX
#define INCLUDED_TOKEN_MAP_HXX

#ifndef INCLUDED_OOXML_RESOURCES_HXX
#include "OOXMLtokens.hxx"
#endif 

#include <map>

#define DEBUG_TOKEN_MAP

namespace ooxml
{

class TokenMap
{    
public:
    typedef boost::shared_ptr<TokenMap> Pointer_t;
    enum TokenType_t { ELEMENT, ATTRIBUTE };

private:
#ifdef DEBUG_TOKEN_MAP
    typedef map<TokenEnum_t, rtl::OUString> ReverseMap_t;
    ReverseMap_t mElementReverseMap, mAttributeReverseMap;
#endif
    static Pointer_t pInstance;    

public:
    TokenMap() { init(); }
    virtual ~TokenMap() {}

    void init();

    static Pointer_t getInstance()
    {
        if (pInstance.get() == NULL)
            pInstance = Pointer_t(new TokenMap);

        return pInstance;
    }

    TokenEnum_t getToken(TokenType_t nType, 
                         const rtl::OUString & rTokenString);

    const rtl::OUString & getTokenString(TokenType_t nType,
                                         TokenEnum_t nToken);
};
}

#endif // INCLUDED_TOKEN_MAP_HXX
